/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.datastructure.ConcurrentPool;
import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.MathKt;
import korlibs.math.RoundDecimalPlacesKt;
import korlibs.math.annotations.KormaMutableApi;
import korlibs.math.geom.Anchor2D;
import korlibs.math.geom.Circle;
import korlibs.math.geom.MMatrix;
import korlibs.math.geom.MPoint;
import korlibs.math.geom.MPointInt;
import korlibs.math.geom.MRectangle;
import korlibs.math.geom.MRectangleInt;
import korlibs.math.geom.MSize;
import korlibs.math.geom.MSizeable;
import korlibs.math.geom.Margin;
import korlibs.math.geom.MarginInt;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.ScaleMode;
import korlibs.math.geom.Size2D;
import korlibs.math.geom.Sizeable;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom._MathGeomMutableKt;
import korlibs.math.interpolation.Interpolable;
import korlibs.math.interpolation.MutableInterpolable;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@KormaMutableApi
@Deprecated(message="Use Rectangle")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000e\n\u0002\b\b\b\u0087\b\u0018\u0000 \u00b1\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\u00020\u00032\u00020\u00042\b\u0012\u0004\u0012\u00020\u00000\u0005:\u0002\u00b1\u0001B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020TJ\u0015\u0010U\u001a\u00020%H\u0007\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bV\u0010)J\u0006\u0010W\u001a\u00020\u0000J\u0006\u0010X\u001a\u00020\u0000J\u0006\u0010Y\u001a\u00020\u0000J\t\u0010Z\u001a\u00020\u0007H\u00c6\u0003J\t\u0010[\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\\\u001a\u00020\u0007H\u00c6\u0003J\t\u0010]\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010^\u001a\u00020+2\u0006\u0010_\u001a\u000202H\u0086\u0002J\u001b\u0010^\u001a\u00020+2\u0006\u0010_\u001a\u00020`H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\ba\u0010bJ\u0011\u0010^\u001a\u00020+2\u0006\u0010_\u001a\u00020\u0000H\u0086\u0002J\u0015\u0010^\u001a\u00020+2\n\u0010_\u001a\u00060\u0015j\u0002`\u0016H\u0086\u0002J\u0016\u0010^\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010^\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020c2\u0006\u0010\b\u001a\u00020cJ\u0016\u0010^\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020d2\u0006\u0010\b\u001a\u00020dJ1\u0010e\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u000e\u0010f\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0000J\u0012\u0010f\u001a\u00020\u00002\n\u0010_\u001a\u00060 j\u0002`!J\u0016\u0010g\u001a\u00020\u00002\u0006\u0010h\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u0007J\u0016\u0010g\u001a\u00020\u00002\u0006\u0010h\u001a\u00020c2\u0006\u0010i\u001a\u00020cJ\u0016\u0010g\u001a\u00020\u00002\u0006\u0010h\u001a\u00020d2\u0006\u0010i\u001a\u00020dJ\u0016\u0010j\u001a\u00020\u00002\u0006\u0010h\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u0007J\u0016\u0010j\u001a\u00020\u00002\u0006\u0010h\u001a\u00020c2\u0006\u0010i\u001a\u00020cJ\u0016\u0010j\u001a\u00020\u00002\u0006\u0010h\u001a\u00020d2\u0006\u0010i\u001a\u00020dJ\u0011\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u00020cH\u0086\u0002J\u0011\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u00020dH\u0086\u0002J\u0013\u0010m\u001a\u00020+2\b\u0010n\u001a\u0004\u0018\u00010oH\u0096\u0002J\u000e\u0010p\u001a\u00020\u00002\u0006\u0010q\u001a\u00020rJ\u000e\u0010p\u001a\u00020\u00002\u0006\u0010q\u001a\u00020sJ&\u0010p\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J)\u0010p\u001a\u00020\u00002\u0006\u0010.\u001a\u00020t2\u0006\u0010D\u001a\u00020t2\u0006\u0010<\u001a\u00020t2\u0006\u0010\u0010\u001a\u00020tH\u0086\bJ\u0006\u0010u\u001a\u00020\u0000J\t\u0010v\u001a\u00020dH\u00d6\u0001J,\u0010w\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00072\b\b\u0002\u0010D\u001a\u00020\u00072\b\b\u0002\u0010<\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0007J\"\u0010x\u001a\u00020\u00002\u0006\u0010y\u001a\u00020z2\u0006\u0010n\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b{\u0010|J\u0013\u0010}\u001a\u0004\u0018\u00010\u00002\u0006\u0010_\u001a\u00020\u0000H\u0086\u0004J\u001a\u0010}\u001a\u0004\u0018\u00010\u00002\u0006\u0010_\u001a\u00020\u00002\b\b\u0002\u0010~\u001a\u00020\u0000J\u0011\u0010\u007f\u001a\u00020+2\u0006\u0010_\u001a\u00020\u0000H\u0086\u0004J\u0012\u0010\u0080\u0001\u001a\u00020+2\u0006\u0010_\u001a\u00020\u0000H\u0086\u0004J\u0012\u0010\u0081\u0001\u001a\u00020+2\u0006\u0010_\u001a\u00020\u0000H\u0086\u0004J\u001a\u0010\u0082\u0001\u001a\u00020+2\u0006\u0010n\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\u0007H\u0016J\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001J\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J?\u0010\u0088\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u0002062\r\u0010\u008a\u0001\u001a\b0\u008b\u0001j\u0003`\u008c\u00012\u0007\u0010l\u001a\u00030\u008d\u00012\t\b\u0002\u0010\u008e\u0001\u001a\u00020\u0000\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u008f\u0001\u0010\u0090\u0001J:\u0010\u0088\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\r\u0010\u008a\u0001\u001a\b0\u008b\u0001j\u0003`\u008c\u00012\u0007\u0010l\u001a\u00030\u008d\u00012\t\b\u0002\u0010\u008e\u0001\u001a\u00020\u0000J\u0007\u0010\u0091\u0001\u001a\u00020\u0000J\u0010\u0010\u0092\u0001\u001a\u00020\u00002\u0007\u0010\u0093\u0001\u001a\u00020dJ'\u0010\u0094\u0001\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J'\u0010\u0094\u0001\u001a\u00020\u00002\u0006\u0010.\u001a\u00020c2\u0006\u0010D\u001a\u00020c2\u0006\u0010<\u001a\u00020c2\u0006\u0010\u0010\u001a\u00020cJ'\u0010\u0094\u0001\u001a\u00020\u00002\u0006\u0010.\u001a\u00020d2\u0006\u0010D\u001a\u00020d2\u0006\u0010<\u001a\u00020d2\u0006\u0010\u0010\u001a\u00020dJ'\u0010\u0095\u0001\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J'\u0010\u0095\u0001\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020c2\u0006\u0010\b\u001a\u00020c2\u0006\u0010\t\u001a\u00020c2\u0006\u0010\n\u001a\u00020cJ'\u0010\u0095\u0001\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020d2\u0006\u0010\b\u001a\u00020d2\u0006\u0010\t\u001a\u00020d2\u0006\u0010\n\u001a\u00020dJ(\u0010\u0096\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u00020\u00002\r\u0010\u008a\u0001\u001a\b0\u008b\u0001j\u0003`\u008c\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u0000J4\u0010\u0096\u0001\u001a\u00020\u00002\u0007\u0010\u0089\u0001\u001a\u0002062\r\u0010\u008a\u0001\u001a\b0\u008b\u0001j\u0003`\u008c\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u0000\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0098\u0001\u0010\u0099\u0001J,\u0010\u0096\u0001\u001a\u00020\u00002\u000b\u0010\u0089\u0001\u001a\u00060@j\u0002`A2\r\u0010\u008a\u0001\u001a\b0\u008b\u0001j\u0003`\u008c\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u0000J'\u0010\u009a\u0001\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J/\u0010\u009b\u0001\u001a\u00020\u00002\u0006\u0010y\u001a\u00020z2\u0007\u0010\u009c\u0001\u001a\u00020\u00002\u0007\u0010\u009d\u0001\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009e\u0001\u0010\u009f\u0001J\u001b\u0010\u00a0\u0001\u001a\u0004\u0018\u00010\u00002\u0007\u0010\u00a1\u0001\u001a\u00020\u00002\u0007\u0010\u00a2\u0001\u001a\u00020\u0000J\u0019\u0010\u00a3\u0001\u001a\u00020\u00002\u0007\u0010\u00a1\u0001\u001a\u00020\u00002\u0007\u0010\u00a2\u0001\u001a\u00020\u0000J\u0018\u0010\u00a4\u0001\u001a\u00030\u0085\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0012\u0010\u00a5\u0001\u001a\u00020\u00002\u0006\u0010l\u001a\u00020\u0007H\u0086\u0002J\u0012\u0010\u00a5\u0001\u001a\u00020\u00002\u0006\u0010l\u001a\u00020cH\u0086\u0002J\u0012\u0010\u00a5\u0001\u001a\u00020\u00002\u0006\u0010l\u001a\u00020dH\u0086\u0002J\u0015\u0010\u00a6\u0001\u001a\u00020%\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0005\b\u00a7\u0001\u0010)J\u000b\u0010\u00a8\u0001\u001a\u00060 j\u0002`!J\n\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0016J\b\u0010\u00ab\u0001\u001a\u00030\u00aa\u0001J\b\u0010\u00ac\u0001\u001a\u00030\u00aa\u0001J\b\u0010\u00ad\u0001\u001a\u00030\u00aa\u0001J\u000f\u0010\u00ae\u0001\u001a\u00020\u00002\u0006\u0010q\u001a\u00020rJ\u0010\u0010\u00af\u0001\u001a\u00020\u00002\u0007\u0010\u00b0\u0001\u001a\u00020rR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0014\u001a\u00060\u0015j\u0002`\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u0019\u001a\u00060\u0015j\u0002`\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0015\u0010\u001b\u001a\u00060\u0015j\u0002`\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0013R\u0015\u0010\u001f\u001a\u00060 j\u0002`!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R \u0010$\u001a\u00020%8FX\u0087\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\u0012\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u0011\u0010-\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010,R$\u0010.\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u000e\"\u0004\b0\u0010\u0013R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u0002068VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b7\u00104R\u0011\u00108\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b9\u0010)R\u0015\u0010:\u001a\u00060\u0015j\u0002`\u00168F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0018R$\u0010<\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\u000e\"\u0004\b>\u0010\u0013R\u0018\u0010?\u001a\u00060@j\u0002`A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR$\u0010D\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010\u000e\"\u0004\bF\u0010\u0013R\u0015\u0010G\u001a\u00060\u0015j\u0002`\u00168F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0018R\u0015\u0010I\u001a\u00060\u0015j\u0002`\u00168F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0018R\u0015\u0010\u000f\u001a\u00060 j\u0002`!8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010#R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\u000e\"\u0004\bM\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u000e\"\u0004\bO\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u000e\"\u0004\bQ\u0010\u0013\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00b2\u0001"}, d2={"Lkorlibs/math/geom/MRectangle;", "Lkorlibs/math/interpolation/MutableInterpolable;", "Lkorlibs/math/interpolation/Interpolable;", "Lkorlibs/math/geom/Sizeable;", "Lkorlibs/math/geom/MSizeable;", "Lkorlibs/math/IsAlmostEquals;", "x", "", "y", "width", "height", "(DDDD)V", "area", "getArea", "()D", "value", "bottom", "getBottom", "setBottom", "(D)V", "bottomLeft", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "getBottomLeft", "()Lkorlibs/math/geom/Vector2D;", "bottomRight", "getBottomRight", "center", "getCenter", "getHeight", "setHeight", "immutable", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "getImmutable", "()Lkorlibs/math/geom/RectangleD;", "int", "Lkorlibs/math/geom/MRectangleInt;", "getInt-OFoCKQA$annotations", "()V", "getInt-OFoCKQA", "()Lkorlibs/math/geom/MRectangle;", "isEmpty", "", "()Z", "isNotEmpty", "left", "getLeft", "setLeft", "mPosition", "Lkorlibs/math/geom/MPoint;", "getMPosition", "()Lkorlibs/math/geom/MPoint;", "mSize", "Lkorlibs/math/geom/MSize;", "getMSize-HDM-tKg", "mutable", "getMutable", "pos", "getPos", "right", "getRight", "setRight", "size", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "getSize", "()Lkorlibs/math/geom/Size2D;", "top", "getTop", "setTop", "topLeft", "getTopLeft", "topRight", "getTopRight", "getValue", "getWidth", "setWidth", "getX", "setX", "getY", "setY", "applyTransform", "m", "Lkorlibs/math/geom/MMatrix;", "asInt", "asInt-OFoCKQA", "ceil", "clear", "clone", "component1", "component2", "component3", "component4", "contains", "that", "Lkorlibs/math/geom/MPointInt;", "contains-mAxXXJE", "(Lkorlibs/math/geom/MPoint;)Z", "", "", "copy", "copyFrom", "displace", "dx", "dy", "displaced", "div", "scale", "equals", "other", "", "expand", "margin", "Lkorlibs/math/geom/Margin;", "Lkorlibs/math/geom/MarginInt;", "", "floor", "hashCode", "inflate", "interpolateWith", "ratio", "Lkorlibs/math/interpolation/Ratio;", "interpolateWith-DJj3pIk", "(DLkorlibs/math/geom/MRectangle;)Lkorlibs/math/geom/MRectangle;", "intersection", "target", "intersects", "intersectsX", "intersectsY", "isAlmostEquals", "epsilon", "normalize", "", "outerCircle", "Lkorlibs/math/geom/Circle;", "place", "item", "anchor", "Lkorlibs/math/geom/Anchor2D;", "Lkorlibs/math/geom/Anchor;", "Lkorlibs/math/geom/ScaleMode;", "out", "place-0sUc1gg", "(Lkorlibs/math/geom/MPoint;Lkorlibs/math/geom/Anchor2D;Lkorlibs/math/geom/ScaleMode;Lkorlibs/math/geom/MRectangle;)Lkorlibs/math/geom/MRectangle;", "round", "roundDecimalPlaces", "places", "setBounds", "setTo", "setToAnchoredRectangle", "container", "setToAnchoredRectangle-kXsYEek", "(Lkorlibs/math/geom/MPoint;Lkorlibs/math/geom/Anchor2D;Lkorlibs/math/geom/MRectangle;)Lkorlibs/math/geom/MRectangle;", "setToBounds", "setToInterpolated", "l", "r", "setToInterpolated-aphylw4", "(DLkorlibs/math/geom/MRectangle;Lkorlibs/math/geom/MRectangle;)Lkorlibs/math/geom/MRectangle;", "setToIntersection", "a", "b", "setToUnion", "setXY", "times", "toInt", "toInt-OFoCKQA", "toRectangle", "toString", "", "toStringBounds", "toStringCompat", "toStringSize", "with", "without", "padding", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeomMutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MRectangle\n*L\n1#1,3252:1\n2649#1:3253\n*S KotlinDebug\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MRectangle\n*L\n2655#1:3253\n*E\n"})
public final class MRectangle
implements MutableInterpolable<MRectangle>,
Interpolable<MRectangle>,
Sizeable,
MSizeable,
IsAlmostEquals<MRectangle> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double width;
    private double height;
    @NotNull
    private static final ConcurrentPool<MRectangle> POOL = new ConcurrentPool(Companion.POOL.1.INSTANCE, 0, Companion.POOL.2.INSTANCE, 2, null);

    public MRectangle(double x, double y, double width2, double height2) {
        this.x = x;
        this.y = y;
        this.width = width2;
        this.height = height2;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getWidth() {
        return this.width;
    }

    public final void setWidth(double d) {
        this.width = d;
    }

    public final double getHeight() {
        return this.height;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    public final boolean contains(@NotNull Vector2D that) {
        return this.contains(that.getX(), that.getY());
    }

    public final boolean contains(@NotNull MPoint that) {
        return this.contains(that.getX(), that.getY());
    }

    public final boolean contains-mAxXXJE(@NotNull MPoint that) {
        return this.contains(MPointInt.getX-impl(that), MPointInt.getY-impl(that));
    }

    public final boolean contains(double x, double y) {
        return x >= this.getLeft() && x < this.getRight() && y >= this.getTop() && y < this.getBottom();
    }

    public final boolean contains(float x, float y) {
        return this.contains((double)x, (double)y);
    }

    public final boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public final double getArea() {
        return this.width * this.height;
    }

    public final boolean isEmpty() {
        return this.width == 0.0 && this.height == 0.0;
    }

    public final boolean isNotEmpty() {
        return !(this.width == 0.0) || !(this.height == 0.0);
    }

    @NotNull
    public final MRectangle getMutable() {
        return new MRectangle(this.x, this.y, this.width, this.height);
    }

    @NotNull
    public final Vector2D getTopLeft() {
        return new Vector2D(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Vector2D getTopRight() {
        return new Vector2D(this.getRight(), this.getTop());
    }

    @NotNull
    public final Vector2D getBottomLeft() {
        return new Vector2D(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Vector2D getBottomRight() {
        return new Vector2D(this.getRight(), this.getBottom());
    }

    @NotNull
    public final Vector2D getCenter() {
        return new Vector2D((this.getRight() + this.getLeft()) * 0.5, (this.getBottom() + this.getTop()) * 0.5);
    }

    @Override
    public boolean isAlmostEquals(@NotNull MRectangle other, double epsilon) {
        return IsAlmostZeroKt.isAlmostEquals(this.x, other.x, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.y, other.y, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.width, other.width, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.height, other.height, epsilon);
    }

    @NotNull
    public final Circle outerCircle() {
        return new Circle(this.getCenter(), Vector2D.Companion.distance(this.getCenter(), this.getTopRight()));
    }

    @NotNull
    public final MRectangle without(@NotNull Margin padding) {
        return Companion.fromBounds(this.getLeft() + padding.getLeft(), this.getTop() + padding.getTop(), this.getRight() - padding.getRight(), this.getBottom() - padding.getBottom());
    }

    @NotNull
    public final MRectangle with(@NotNull Margin margin) {
        return Companion.fromBounds(this.getLeft() - margin.getLeft(), this.getTop() - margin.getTop(), this.getRight() + margin.getRight(), this.getBottom() + margin.getBottom());
    }

    public final boolean intersects(@NotNull MRectangle that) {
        return this.intersectsX(that) && this.intersectsY(that);
    }

    public final boolean intersectsX(@NotNull MRectangle that) {
        return that.getLeft() <= this.getRight() && that.getRight() >= this.getLeft();
    }

    public final boolean intersectsY(@NotNull MRectangle that) {
        return that.getTop() <= this.getBottom() && that.getBottom() >= this.getTop();
    }

    @Nullable
    public final MRectangle intersection(@NotNull MRectangle that, @NotNull MRectangle target) {
        return this.intersects(that) ? target.setBounds(Math.max(this.getLeft(), that.getLeft()), Math.max(this.getTop(), that.getTop()), Math.min(this.getRight(), that.getRight()), Math.min(this.getBottom(), that.getBottom())) : null;
    }

    public static /* synthetic */ MRectangle intersection$default(MRectangle mRectangle, MRectangle mRectangle2, MRectangle mRectangle3, int n, Object object) {
        if ((n & 2) != 0) {
            mRectangle3 = Companion.invoke();
        }
        return mRectangle.intersection(mRectangle2, mRectangle3);
    }

    public final void setXY(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getLeft() {
        return this.x;
    }

    public final void setLeft(double value) {
        this.width += this.x - value;
        this.x = value;
    }

    public final double getTop() {
        return this.y;
    }

    public final void setTop(double value) {
        this.height += this.y - value;
        this.y = value;
    }

    public final double getRight() {
        return this.x + this.width;
    }

    public final void setRight(double value) {
        this.width = value - this.x;
    }

    public final double getBottom() {
        return this.y + this.height;
    }

    public final void setBottom(double value) {
        this.height = value - this.y;
    }

    @NotNull
    public final Vector2D getPos() {
        return new Vector2D(this.x, this.y);
    }

    @NotNull
    public final MPoint getMPosition() {
        return new MPoint(this.x, this.y);
    }

    @Override
    @NotNull
    public Size2D getSize() {
        return new Size2D(this.width, this.height);
    }

    @Override
    @NotNull
    public MPoint getMSize-HDM-tKg() {
        return MSize.Companion.invoke-SQzGJso(this.width, this.height);
    }

    @NotNull
    public final MRectangle setToBounds(double left, double top, double right, double bottom) {
        return this.setTo(left, top, right - left, bottom - top);
    }

    @NotNull
    public final MRectangle setTo(double x, double y, double width2, double height2) {
        this.x = x;
        this.y = y;
        this.width = width2;
        this.height = height2;
        return this;
    }

    @NotNull
    public final MRectangle setTo(int x, int y, int width2, int height2) {
        return this.setTo((double)x, (double)y, (double)width2, (double)height2);
    }

    @NotNull
    public final MRectangle setTo(float x, float y, float width2, float height2) {
        return this.setTo((double)x, (double)y, (double)width2, (double)height2);
    }

    @NotNull
    public final MRectangle copyFrom(@NotNull RectangleD that) {
        return this.setTo(that.getX(), that.getY(), that.getWidth(), that.getHeight());
    }

    @NotNull
    public final MRectangle copyFrom(@NotNull MRectangle that) {
        return this.setTo(that.x, that.y, that.width, that.height);
    }

    @NotNull
    public final MRectangle setBounds(double left, double top, double right, double bottom) {
        return this.setTo(left, top, right - left, bottom - top);
    }

    @NotNull
    public final MRectangle setBounds(int left, int top, int right, int bottom) {
        return this.setBounds((double)left, (double)top, (double)right, (double)bottom);
    }

    @NotNull
    public final MRectangle setBounds(float left, float top, float right, float bottom) {
        return this.setBounds((double)left, (double)top, (double)right, (double)bottom);
    }

    @NotNull
    public final MRectangle times(double scale) {
        return new MRectangle(this.x * scale, this.y * scale, this.width * scale, this.height * scale);
    }

    @NotNull
    public final MRectangle times(float scale) {
        return this.times((double)scale);
    }

    @NotNull
    public final MRectangle times(int scale) {
        return this.times((double)scale);
    }

    @NotNull
    public final MRectangle div(double scale) {
        return new MRectangle(this.x / scale, this.y / scale, this.width / scale, this.height / scale);
    }

    @NotNull
    public final MRectangle div(float scale) {
        return this.div((double)scale);
    }

    @NotNull
    public final MRectangle div(int scale) {
        return this.div((double)scale);
    }

    public final boolean contains(@NotNull MRectangle that) {
        return Companion.isContainedIn(that, this);
    }

    @Nullable
    public final MRectangle setToIntersection(@NotNull MRectangle a, @NotNull MRectangle b) {
        return a.intersection(b, this) != null ? this : null;
    }

    @NotNull
    public final MRectangle setToUnion(@NotNull MRectangle a, @NotNull MRectangle b) {
        return this.setToBounds(Math.min(a.getLeft(), b.getLeft()), Math.min(a.getTop(), b.getTop()), Math.max(a.getRight(), b.getRight()), Math.max(a.getBottom(), b.getBottom()));
    }

    @Nullable
    public final MRectangle intersection(@NotNull MRectangle that) {
        return this.intersection(that, Companion.invoke());
    }

    @NotNull
    public final MRectangle displaced(double dx, double dy) {
        return new MRectangle(this.x + dx, this.y + dy, this.width, this.height);
    }

    @NotNull
    public final MRectangle displaced(float dx, float dy) {
        return this.displaced((double)dx, (double)dy);
    }

    @NotNull
    public final MRectangle displaced(int dx, int dy) {
        return this.displaced((double)dx, (double)dy);
    }

    @NotNull
    public final MRectangle displace(double dx, double dy) {
        return this.setTo(this.x + dx, this.y + dy, this.width, this.height);
    }

    @NotNull
    public final MRectangle displace(float dx, float dy) {
        return this.displace((double)dx, (double)dy);
    }

    @NotNull
    public final MRectangle displace(int dx, int dy) {
        return this.displace((double)dx, (double)dy);
    }

    @NotNull
    public final MRectangle place-0sUc1gg(@NotNull MPoint item2, @NotNull Anchor2D anchor, @NotNull ScaleMode scale, @NotNull MRectangle out) {
        return this.place(MSize.getWidth-impl(item2), MSize.getHeight-impl(item2), anchor, scale, out);
    }

    public static /* synthetic */ MRectangle place-0sUc1gg$default(MRectangle mRectangle, MPoint mPoint, Anchor2D anchor2D, ScaleMode scaleMode, MRectangle mRectangle2, int n, Object object) {
        if ((n & 8) != 0) {
            mRectangle2 = Companion.invoke();
        }
        return mRectangle.place-0sUc1gg(mPoint, anchor2D, scaleMode, mRectangle2);
    }

    @NotNull
    public final MRectangle place(double width2, double height2, @NotNull Anchor2D anchor, @NotNull ScaleMode scale, @NotNull MRectangle out) {
        Size2D size2D = scale.getTransform().invoke(new Size2D(width2, height2), new Size2D(this.width, this.height));
        double ow = size2D.component1();
        double oh = size2D.component2();
        double x = (this.width - ow) * anchor.getSx();
        double y = (this.height - oh) * anchor.getSy();
        return out.setTo(x, y, ow, oh);
    }

    public static /* synthetic */ MRectangle place$default(MRectangle mRectangle, double d, double d2, Anchor2D anchor2D, ScaleMode scaleMode, MRectangle mRectangle2, int n, Object object) {
        if ((n & 0x10) != 0) {
            mRectangle2 = Companion.invoke();
        }
        return mRectangle.place(d, d2, anchor2D, scaleMode, mRectangle2);
    }

    @NotNull
    public final MRectangle inflate(double left, double top, double right, double bottom) {
        return this.setBounds(this.getLeft() - left, this.getTop() - top, this.getRight() + right, this.getBottom() + bottom);
    }

    public static /* synthetic */ MRectangle inflate$default(MRectangle mRectangle, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        if ((n & 4) != 0) {
            d3 = d;
        }
        if ((n & 8) != 0) {
            d4 = d2;
        }
        return mRectangle.inflate(d, d2, d3, d4);
    }

    @NotNull
    public final MRectangle clear() {
        return this.setTo(0.0, 0.0, 0.0, 0.0);
    }

    @NotNull
    public final MRectangle clone() {
        return new MRectangle(this.x, this.y, this.width, this.height);
    }

    @NotNull
    public final MRectangle setToAnchoredRectangle(@NotNull MRectangle item2, @NotNull Anchor2D anchor, @NotNull MRectangle container2) {
        return this.setToAnchoredRectangle-kXsYEek(item2.getMSize-HDM-tKg(), anchor, container2);
    }

    @NotNull
    public final MRectangle setToAnchoredRectangle-kXsYEek(@NotNull MPoint item2, @NotNull Anchor2D anchor, @NotNull MRectangle container2) {
        return this.setToAnchoredRectangle(_MathGeomMutableKt.getImmutable-B3Y-Vy8(item2), anchor, container2);
    }

    @NotNull
    public final MRectangle setToAnchoredRectangle(@NotNull Size2D item2, @NotNull Anchor2D anchor, @NotNull MRectangle container2) {
        return this.setTo(container2.x + anchor.getSx() * (container2.width - item2.getWidth()), container2.y + anchor.getSy() * (container2.height - item2.getHeight()), item2.getWidth(), item2.getHeight());
    }

    @NotNull
    public final MRectangle applyTransform(@NotNull MMatrix m) {
        MPoint tl = MMatrix.transform$default(m, this.getLeft(), this.getTop(), null, 4, null);
        MPoint tr = MMatrix.transform$default(m, this.getRight(), this.getTop(), null, 4, null);
        MPoint bl = MMatrix.transform$default(m, this.getLeft(), this.getBottom(), null, 4, null);
        MPoint br2 = MMatrix.transform$default(m, this.getRight(), this.getBottom(), null, 4, null);
        double minX = MathKt.min(tl.getX(), tr.getX(), bl.getX(), br2.getX());
        double minY = MathKt.min(tl.getY(), tr.getY(), bl.getY(), br2.getY());
        double maxX = MathKt.max(tl.getX(), tr.getX(), bl.getX(), br2.getX());
        double maxY = MathKt.max(tl.getY(), tr.getY(), bl.getY(), br2.getY());
        return this.setBounds(minX, minY, maxX, maxY);
    }

    @NotNull
    public String toString() {
        return "Rectangle(x=" + StringExtKt.getNiceStr(this.x) + ", y=" + StringExtKt.getNiceStr(this.y) + ", width=" + StringExtKt.getNiceStr(this.width) + ", height=" + StringExtKt.getNiceStr(this.height) + ")";
    }

    @NotNull
    public final String toStringBounds() {
        return "Rectangle([" + StringExtKt.getNiceStr(this.getLeft()) + "," + StringExtKt.getNiceStr(this.getTop()) + "]-[" + StringExtKt.getNiceStr(this.getRight()) + "," + StringExtKt.getNiceStr(this.getBottom()) + "])";
    }

    @NotNull
    public final String toStringSize() {
        return "Rectangle([" + StringExtKt.getNiceStr(this.getLeft()) + "," + StringExtKt.getNiceStr(this.getTop()) + "],[" + StringExtKt.getNiceStr(this.width) + "," + StringExtKt.getNiceStr(this.height) + "])";
    }

    @NotNull
    public final String toStringCompat() {
        return "Rectangle(x=" + StringExtKt.getNiceStr(this.getLeft()) + ", y=" + StringExtKt.getNiceStr(this.getTop()) + ", w=" + StringExtKt.getNiceStr(this.width) + ", h=" + StringExtKt.getNiceStr(this.height) + ")";
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MRectangle && IsAlmostZeroKt.isAlmostEquals$default(this.x, ((MRectangle)other).x, 0.0, 2, null) && IsAlmostZeroKt.isAlmostEquals$default(this.y, ((MRectangle)other).y, 0.0, 2, null) && IsAlmostZeroKt.isAlmostEquals$default(this.width, ((MRectangle)other).width, 0.0, 2, null) && IsAlmostZeroKt.isAlmostEquals$default(this.height, ((MRectangle)other).height, 0.0, 2, null);
    }

    @Override
    @NotNull
    public MRectangle interpolateWith-DJj3pIk(double ratio2, @NotNull MRectangle other) {
        return Companion.invoke().setToInterpolated-aphylw4(ratio2, this, other);
    }

    @Override
    @NotNull
    public MRectangle setToInterpolated-aphylw4(double ratio2, @NotNull MRectangle l, @NotNull MRectangle r) {
        return this.setTo(_Math_interpolationKt.interpolate-aphylw4(ratio2, l.x, r.x), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.y, r.y), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.width, r.width), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.height, r.height));
    }

    @NotNull
    public final RectangleD getImmutable() {
        return new RectangleD(this.x, this.y, this.width, this.height);
    }

    @NotNull
    public final MRectangle toInt-OFoCKQA() {
        return MRectangleInt.Companion.invoke-ewggmzA((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    @NotNull
    public final MRectangle floor() {
        return this.setTo(Math.floor(this.x), Math.floor(this.y), Math.floor(this.width), Math.floor(this.height));
    }

    @NotNull
    public final MRectangle round() {
        return this.setTo(Math.rint(this.x), Math.rint(this.y), Math.rint(this.width), Math.rint(this.height));
    }

    @NotNull
    public final MRectangle roundDecimalPlaces(int places) {
        return this.setTo(RoundDecimalPlacesKt.roundDecimalPlaces(this.x, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.y, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.width, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.height, places));
    }

    @NotNull
    public final MRectangle ceil() {
        return this.setTo(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.width), Math.ceil(this.height));
    }

    public final void normalize() {
        if (this.width < 0.0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0.0) {
            this.y += this.height;
            this.height = -this.height;
        }
    }

    @NotNull
    public final MRectangle expand(double left, double top, double right, double bottom) {
        return this.setToBounds(this.getLeft() - left, this.getTop() - top, this.getRight() + right, this.getBottom() + bottom);
    }

    @NotNull
    public final MRectangle expand(@NotNull Number left, @NotNull Number top, @NotNull Number right, @NotNull Number bottom) {
        boolean $i$f$expand = false;
        return this.expand(left.doubleValue(), top.doubleValue(), right.doubleValue(), bottom.doubleValue());
    }

    @NotNull
    public final MRectangle expand(@NotNull Margin margin) {
        return this.expand(margin.getLeft(), margin.getTop(), margin.getRight(), margin.getBottom());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MRectangle expand(@NotNull MarginInt margin) {
        void right$iv;
        void top$iv;
        void left$iv;
        void this_$iv;
        MRectangle mRectangle = this;
        int n = margin.getLeft();
        int n2 = margin.getTop();
        int n3 = margin.getRight();
        int bottom$iv = margin.getBottom();
        boolean $i$f$expand = false;
        return this_$iv.expand((double)left$iv, (double)top$iv, (double)right$iv, bottom$iv);
    }

    @NotNull
    public final RectangleD toRectangle() {
        return new RectangleD(this.x, this.y, this.width, this.height);
    }

    @KormaMutableApi
    @NotNull
    public final MRectangle asInt-OFoCKQA() {
        return MRectangleInt.constructor-impl(this);
    }

    @NotNull
    public final MRectangle getInt-OFoCKQA() {
        return MRectangleInt.Companion.invoke-ewggmzA(this.x, this.y, this.width, this.height);
    }

    @KormaMutableApi
    public static /* synthetic */ void getInt-OFoCKQA$annotations() {
    }

    @NotNull
    public final RectangleD getValue() {
        return new RectangleD(this.x, this.y, this.width, this.height);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.width;
    }

    public final double component4() {
        return this.height;
    }

    @NotNull
    public final MRectangle copy(double x, double y, double width2, double height2) {
        return new MRectangle(x, y, width2, height2);
    }

    public static /* synthetic */ MRectangle copy$default(MRectangle mRectangle, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = mRectangle.x;
        }
        if ((n & 2) != 0) {
            d2 = mRectangle.y;
        }
        if ((n & 4) != 0) {
            d3 = mRectangle.width;
        }
        if ((n & 8) != 0) {
            d4 = mRectangle.height;
        }
        return mRectangle.copy(d, d2, d3, d4);
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.y);
        result2 = result2 * 31 + Double.hashCode(this.width);
        result2 = result2 * 31 + Double.hashCode(this.height);
        return result2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ&\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ&\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0005H\u0086\u0002J\u0019\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0086\u0002J#\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u0013\u001a\u00020\u00052\n\u0010\u0014\u001a\u00060\u0019j\u0002`\u001a2\n\u0010\u0015\u001a\u00060\u001bj\u0002`\u001cH\u0086\u0002J)\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0086\u0002J)\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0086\u0002J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006%"}, d2={"Lkorlibs/math/geom/MRectangle$Companion;", "", "()V", "POOL", "Lkorlibs/datastructure/ConcurrentPool;", "Lkorlibs/math/geom/MRectangle;", "getPOOL", "()Lkorlibs/datastructure/ConcurrentPool;", "fromBounds", "point1", "Lkorlibs/math/geom/MPoint;", "point2", "left", "", "top", "right", "bottom", "", "", "invoke", "topLeft", "size", "Lkorlibs/math/geom/MSize;", "invoke-JMkLsf4", "(Lkorlibs/math/geom/MPoint;Lkorlibs/math/geom/MPoint;)Lkorlibs/math/geom/MRectangle;", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "x", "y", "width", "height", "isContainedIn", "", "a", "b", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentPool<MRectangle> getPOOL() {
            return POOL;
        }

        @NotNull
        public final MRectangle invoke(@NotNull MPoint point1, @NotNull MPoint point2) {
            double left = Math.min(point1.getX(), point2.getX());
            double top = Math.min(point1.getY(), point2.getY());
            double right = Math.max(point1.getX(), point2.getX());
            double bottom = Math.max(point1.getY(), point2.getY());
            return new MRectangle(left, top, right - left, bottom - top);
        }

        @NotNull
        public final MRectangle invoke() {
            return new MRectangle(0.0, 0.0, 0.0, 0.0);
        }

        @NotNull
        public final MRectangle invoke(int x, int y, int width2, int height2) {
            return new MRectangle(x, y, width2, height2);
        }

        @NotNull
        public final MRectangle invoke(float x, float y, float width2, float height2) {
            return new MRectangle(x, y, width2, height2);
        }

        @NotNull
        public final MRectangle invoke-JMkLsf4(@NotNull MPoint topLeft, @NotNull MPoint size2) {
            return new MRectangle(topLeft.getX(), topLeft.getY(), MSize.getWidth-impl(size2), MSize.getHeight-impl(size2));
        }

        @NotNull
        public final MRectangle invoke(@NotNull Vector2D topLeft, @NotNull Size2D size2) {
            return new MRectangle(topLeft.getX(), topLeft.getY(), size2.getWidth(), size2.getHeight());
        }

        @NotNull
        public final MRectangle fromBounds(double left, double top, double right, double bottom) {
            return Companion.invoke().setBounds(left, top, right, bottom);
        }

        @NotNull
        public final MRectangle fromBounds(int left, int top, int right, int bottom) {
            return Companion.invoke().setBounds(left, top, right, bottom);
        }

        @NotNull
        public final MRectangle fromBounds(float left, float top, float right, float bottom) {
            return Companion.invoke().setBounds(left, top, right, bottom);
        }

        @NotNull
        public final MRectangle fromBounds(@NotNull MPoint point1, @NotNull MPoint point2) {
            return Companion.invoke(point1, point2);
        }

        public final boolean isContainedIn(@NotNull MRectangle a, @NotNull MRectangle b) {
            return a.getX() >= b.getX() && a.getY() >= b.getY() && a.getX() + a.getWidth() <= b.getX() + b.getWidth() && a.getY() + a.getHeight() <= b.getY() + b.getHeight();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

