/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import java.util.Arrays;
import korlibs.math.MathKt;
import korlibs.math.annotations.KormaMutableApi;
import korlibs.math.geom.IVector3;
import korlibs.math.geom.MMatrix4;
import korlibs.math.geom.MVector4;
import korlibs.math.geom.Vector3F;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KormaMutableApi
@Deprecated(message="")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0000J\u0013\u0010'\u001a\u00020(2\b\u0010!\u001a\u0004\u0018\u00010)H\u0096\u0002J\u0011\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,H\u0096\u0002J\b\u0010-\u001a\u00020,H\u0016J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000H\u0086\u0002J\u0010\u00100\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u0000J\u0010\u00101\u001a\u00020\u00002\b\b\u0002\u00102\u001a\u00020\u0000J\u0011\u00103\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000H\u0086\u0002J\u000e\u00104\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00104\u001a\u00020\u00002\u0006\u00104\u001a\u00020\bJ\u000e\u00104\u001a\u00020\u00002\u0006\u00104\u001a\u00020,J\u0019\u00106\u001a\u0002072\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\bH\u0086\u0002J\u001e\u00108\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u0002052\u0006\u0010\u0016\u001a\u0002052\u0006\u0010\u0019\u001a\u000205J\u001e\u00108\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bJ\u001e\u00108\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020,2\u0006\u0010\u0016\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020,J,\u00109\u001a\u00020\u00002!\u0010:\u001a\u001d\u0012\u0013\u0012\u00110,\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\b0;H\u0086\bJQ\u00109\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020>26\u0010:\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\b0?H\u0086\bJ\u001e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u000205J\u0016\u0010D\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u0011\u0010E\u001a\u00020\u00002\u0006\u00104\u001a\u00020\bH\u0086\u0002J\b\u0010F\u001a\u00020GH\u0016J\u0012\u0010H\u001a\u00020\u00002\n\u0010I\u001a\u00060Jj\u0002`KJ\u001c\u0010L\u001a\u00020\u00002\n\u0010I\u001a\u00060Jj\u0002`K2\b\b\u0002\u00102\u001a\u00020\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\u0015R$\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\n\"\u0004\b\u001b\u0010\u0015\u00a8\u0006N"}, d2={"Lkorlibs/math/geom/MVector3;", "Lkorlibs/math/geom/IVector3;", "()V", "data", "", "getData", "()[F", "length", "", "getLength", "()F", "lengthSquared", "getLengthSquared", "vector", "Lkorlibs/math/geom/Vector3F;", "getVector", "()Lkorlibs/math/geom/Vector3F;", "value", "x", "getX", "setX", "(F)V", "y", "getY", "setY", "z", "getZ", "setZ", "add", "l", "r", "clone", "copyFrom", "other", "cross", "a", "b", "dot", "v2", "equals", "", "", "get", "index", "", "hashCode", "minus", "that", "normalize", "normalized", "out", "plus", "scale", "", "set", "", "setTo", "setToFunc", "func", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lkorlibs/math/geom/MVector4;", "Lkotlin/Function2;", "setToInterpolated", "left", "right", "t", "sub", "times", "toString", "", "transform", "mat", "Lkorlibs/math/geom/MMatrix4;", "Lkorlibs/math/geom/MMatrix3D;", "transformed", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeomMutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MVector3\n*L\n1#1,3252:1\n3039#1:3253\n*S KotlinDebug\n*F\n+ 1 _MathGeomMutable.kt\nkorlibs/math/geom/MVector3\n*L\n3045#1:3253\n*E\n"})
public final class MVector3
implements IVector3 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] data = new float[3];

    @NotNull
    public final float[] getData() {
        return this.data;
    }

    @Override
    public float getX() {
        return this.data[0];
    }

    public void setX(float value) {
        this.data[0] = value;
    }

    @Override
    public float getY() {
        return this.data[1];
    }

    public void setY(float value) {
        this.data[1] = value;
    }

    @Override
    public float getZ() {
        return this.data[2];
    }

    public void setZ(float value) {
        this.data[2] = value;
    }

    @NotNull
    public final Vector3F getVector() {
        return new Vector3F(this.getX(), this.getY(), this.getZ());
    }

    public final float getLengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public final float getLength() {
        return (float)Math.sqrt(this.getLengthSquared());
    }

    @Override
    public float get(int index2) {
        return this.data[index2];
    }

    public final void set(int index2, float value) {
        this.data[index2] = value;
    }

    @NotNull
    public final MVector3 setTo(float x, float y, float z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    @NotNull
    public final MVector3 setTo(double x, double y, double z) {
        return this.setTo((float)x, (float)y, (float)z);
    }

    @NotNull
    public final MVector3 setTo(int x, int y, int z) {
        return this.setTo((float)x, (float)y, (float)z);
    }

    @NotNull
    public final MVector3 setToFunc(@NotNull Function1<? super Integer, Float> func2) {
        boolean $i$f$setToFunc = false;
        return this.setTo(((Number)func2.invoke((Integer)0)).floatValue(), ((Number)func2.invoke((Integer)1)).floatValue(), ((Number)func2.invoke((Integer)2)).floatValue());
    }

    @NotNull
    public final MVector3 setToFunc(@NotNull MVector4 l, @NotNull MVector4 r, @NotNull Function2<? super Float, ? super Float, Float> func2) {
        boolean $i$f$setToFunc = false;
        return this.setTo(((Number)func2.invoke(Float.valueOf(l.getX()), Float.valueOf(r.getX()))).floatValue(), ((Number)func2.invoke(Float.valueOf(l.getY()), Float.valueOf(r.getY()))).floatValue(), ((Number)func2.invoke(Float.valueOf(l.getZ()), Float.valueOf(r.getZ()))).floatValue());
    }

    @NotNull
    public final MVector3 setToInterpolated(@NotNull MVector4 left, @NotNull MVector4 right, double t) {
        int it;
        MVector3 this_$iv = this;
        boolean $i$f$setToFunc = false;
        boolean bl = false;
        MVector3 mVector3 = this_$iv;
        boolean bl2 = false;
        float f = _Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio(t), left.get(it), right.get(it));
        it = 1;
        bl2 = false;
        float f2 = _Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio(t), left.get(it), right.get(it));
        it = 2;
        bl2 = false;
        float f3 = _Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio(t), left.get(it), right.get(it));
        return mVector3.setTo(f, f2, f3);
    }

    @NotNull
    public final MVector3 copyFrom(@NotNull MVector3 other) {
        return this.setTo(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final MVector3 scale(float scale) {
        return this.setTo(this.getX() * scale, this.getY() * scale, this.getZ() * scale);
    }

    @NotNull
    public final MVector3 scale(int scale) {
        return this.scale((float)scale);
    }

    @NotNull
    public final MVector3 scale(double scale) {
        return this.scale((float)scale);
    }

    @NotNull
    public final MVector3 transform(@NotNull MMatrix4 mat) {
        return mat.transform(this, this);
    }

    @NotNull
    public final MVector3 transformed(@NotNull MMatrix4 mat, @NotNull MVector3 out) {
        return mat.transform(this, out);
    }

    public static /* synthetic */ MVector3 transformed$default(MVector3 mVector3, MMatrix4 mMatrix4, MVector3 mVector32, int n, Object object) {
        if ((n & 2) != 0) {
            mVector32 = new MVector3();
        }
        return mVector3.transformed(mMatrix4, mVector32);
    }

    @NotNull
    public final MVector3 normalize(@NotNull MVector3 vector) {
        double norm = 1.0 / (double)vector.getLength();
        this.setTo((double)vector.getX() * norm, (double)vector.getY() * norm, (double)vector.getZ() * norm);
        return this;
    }

    public static /* synthetic */ MVector3 normalize$default(MVector3 mVector3, MVector3 mVector32, int n, Object object) {
        if ((n & 1) != 0) {
            mVector32 = mVector3;
        }
        return mVector3.normalize(mVector32);
    }

    @NotNull
    public final MVector3 normalized(@NotNull MVector3 out) {
        return MVector3.normalize$default(out.copyFrom(this), null, 1, null);
    }

    public static /* synthetic */ MVector3 normalized$default(MVector3 mVector3, MVector3 mVector32, int n, Object object) {
        if ((n & 1) != 0) {
            mVector32 = new MVector3();
        }
        return mVector3.normalized(mVector32);
    }

    public final float dot(@NotNull MVector3 v2) {
        return this.getX() * v2.getX() + this.getY() * v2.getY() + this.getZ() * v2.getY();
    }

    @NotNull
    public final MVector3 plus(@NotNull MVector3 that) {
        return Companion.invoke(this.getX() + that.getX(), this.getY() + that.getY(), this.getZ() + that.getZ());
    }

    @NotNull
    public final MVector3 minus(@NotNull MVector3 that) {
        return Companion.invoke(this.getX() - that.getX(), this.getY() - that.getY(), this.getZ() - that.getZ());
    }

    @NotNull
    public final MVector3 times(float scale) {
        return Companion.invoke(this.getX() * scale, this.getY() * scale, this.getZ() * scale);
    }

    @NotNull
    public final MVector3 sub(@NotNull MVector3 l, @NotNull MVector3 r) {
        return this.setTo(l.getX() - r.getX(), l.getY() - r.getY(), l.getZ() - r.getZ());
    }

    @NotNull
    public final MVector3 add(@NotNull MVector3 l, @NotNull MVector3 r) {
        return this.setTo(l.getX() + r.getX(), l.getY() + r.getY(), l.getZ() + r.getZ());
    }

    @NotNull
    public final MVector3 cross(@NotNull MVector3 a, @NotNull MVector3 b) {
        return this.setTo(a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX());
    }

    @NotNull
    public final MVector3 clone() {
        return Companion.invoke(this.getX(), this.getY(), this.getZ());
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MVector3 && MathKt.almostEquals(this.getX(), ((MVector3)other).getX()) && MathKt.almostEquals(this.getY(), ((MVector3)other).getY()) && MathKt.almostEquals(this.getZ(), ((MVector3)other).getZ());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @NotNull
    public String toString() {
        return "(" + StringExtKt.getNiceStr(this.getX()) + ", " + StringExtKt.getNiceStr(this.getY()) + ", " + StringExtKt.getNiceStr(this.getZ()) + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\nH\u0086\u0002J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lkorlibs/math/geom/MVector3$Companion;", "", "()V", "invoke", "Lkorlibs/math/geom/MVector3;", "x", "", "y", "z", "", "", "length", "lengthSq", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MVector3 invoke(float x, float y, float z) {
            return new MVector3().setTo(x, y, z);
        }

        @NotNull
        public final MVector3 invoke(double x, double y, double z) {
            return new MVector3().setTo(x, y, z);
        }

        @NotNull
        public final MVector3 invoke(int x, int y, int z) {
            return new MVector3().setTo(x, y, z);
        }

        public final double length(double x, double y, double z) {
            return Math.sqrt(this.lengthSq(x, y, z));
        }

        public final float length(float x, float y, float z) {
            return (float)Math.sqrt(this.lengthSq(x, y, z));
        }

        public final double lengthSq(double x, double y, double z) {
            return x * x + y * y + z * z;
        }

        public final float lengthSq(float x, float y, float z) {
            return x * x + y * y + z * z;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

