/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.number.FixedShort;
import korlibs.number.FixedShortKt;
import korlibs.number.StringExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 >2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001>B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J1\u00101\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u00102\u001a\u00020\u00172\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u000206H\u00d6\u0001J\u0018\u00107\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0003H\u0016J\u0010\u00109\u001a\u00020\u00172\b\b\u0002\u00108\u001a\u00020\u0003J\u0011\u0010:\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010;\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000H\u0086\u0002J\b\u0010<\u001a\u00020=H\u0016R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000eR\u0017\u0010\u0014\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0017\u0010\u001a\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u0017\u0010\u001e\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000eR\u0017\u0010!\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000eR\u0017\u0010$\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0011\u0010&\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000eR\u0017\u0010(\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0017\u0010+\u001a\u00020\u00108F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0012\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006?"}, d2={"Lkorlibs/math/geom/Margin;", "Lkorlibs/math/IsAlmostEquals;", "vertical", "", "horizontal", "(DD)V", "margin", "(D)V", "top", "right", "bottom", "left", "(DDDD)V", "getBottom", "()D", "bottomFixed", "Lkorlibs/number/FixedShort;", "getBottomFixed-kO8_9wU", "()S", "getHorizontal", "horizontalFixed", "getHorizontalFixed-kO8_9wU", "isNotZero", "", "()Z", "getLeft", "leftFixed", "getLeftFixed-kO8_9wU", "leftPlusRight", "getLeftPlusRight", "leftPlusRightFixed", "getLeftPlusRightFixed-kO8_9wU", "getRight", "rightFixed", "getRightFixed-kO8_9wU", "getTop", "topFixed", "getTopFixed-kO8_9wU", "topPlusBottom", "getTopPlusBottom", "topPlusBottomFixed", "getTopPlusBottomFixed-kO8_9wU", "getVertical", "verticalFixed", "getVerticalFixed-kO8_9wU", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "isAlmostEquals", "epsilon", "isAlmostZero", "minus", "plus", "toString", "", "Companion", "korge-foundation"})
public final class Margin
implements IsAlmostEquals<Margin> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    @NotNull
    private static final Margin ZERO = new Margin(0.0, 0.0, 0.0, 0.0);

    public Margin(double top, double right, double bottom, double left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public Margin(double vertical, double horizontal) {
        this(vertical, horizontal, vertical, horizontal);
    }

    public Margin(double margin) {
        this(margin, margin, margin, margin);
    }

    @NotNull
    public final Margin plus(@NotNull Margin other) {
        return new Margin(this.top + other.top, this.right + other.right, this.bottom + other.bottom, this.left + other.left);
    }

    @NotNull
    public final Margin minus(@NotNull Margin other) {
        return new Margin(this.top - other.top, this.right - other.right, this.bottom - other.bottom, this.left - other.left);
    }

    public final boolean isNotZero() {
        return !(this.top == 0.0) || !(this.left == 0.0) || !(this.right == 0.0) || !(this.bottom == 0.0);
    }

    @Override
    public boolean isAlmostEquals(@NotNull Margin other, double epsilon) {
        return IsAlmostZeroKt.isAlmostEquals(this.left, other.left, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.right, other.right, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.top, other.top, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.bottom, other.bottom, epsilon);
    }

    public final boolean isAlmostZero(double epsilon) {
        return this.isAlmostEquals(ZERO, epsilon);
    }

    public static /* synthetic */ boolean isAlmostZero$default(Margin margin, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0E-6;
        }
        return margin.isAlmostZero(d);
    }

    public final short getTopFixed-kO8_9wU() {
        return FixedShortKt.toFixedShort(this.top);
    }

    public final short getRightFixed-kO8_9wU() {
        return FixedShortKt.toFixedShort(this.right);
    }

    public final short getBottomFixed-kO8_9wU() {
        return FixedShortKt.toFixedShort(this.bottom);
    }

    public final short getLeftFixed-kO8_9wU() {
        return FixedShortKt.toFixedShort(this.left);
    }

    public final short getLeftPlusRightFixed-kO8_9wU() {
        return FixedShort.plus-vE6hbVY(this.getLeftFixed-kO8_9wU(), this.getRightFixed-kO8_9wU());
    }

    public final short getTopPlusBottomFixed-kO8_9wU() {
        return FixedShort.plus-vE6hbVY(this.getTopFixed-kO8_9wU(), this.getBottomFixed-kO8_9wU());
    }

    public final short getHorizontalFixed-kO8_9wU() {
        return FixedShort.div-vE6hbVY(FixedShort.plus-vE6hbVY(this.getLeftFixed-kO8_9wU(), this.getRightFixed-kO8_9wU()), FixedShortKt.toFixedShort(2));
    }

    public final short getVerticalFixed-kO8_9wU() {
        return FixedShort.div-vE6hbVY(FixedShort.plus-vE6hbVY(this.getTopFixed-kO8_9wU(), this.getBottomFixed-kO8_9wU()), FixedShortKt.toFixedShort(2));
    }

    public final double getLeftPlusRight() {
        return this.left + this.right;
    }

    public final double getTopPlusBottom() {
        return this.top + this.bottom;
    }

    public final double getHorizontal() {
        return (this.left + this.right) / (double)2;
    }

    public final double getVertical() {
        return (this.top + this.bottom) / (double)2;
    }

    @NotNull
    public String toString() {
        return "Margin(top=" + StringExtKt.getNiceStr(this.top) + ", right=" + StringExtKt.getNiceStr(this.right) + ", bottom=" + StringExtKt.getNiceStr(this.bottom) + ", left=" + StringExtKt.getNiceStr(this.left) + ")";
    }

    public final double component1() {
        return this.top;
    }

    public final double component2() {
        return this.right;
    }

    public final double component3() {
        return this.bottom;
    }

    public final double component4() {
        return this.left;
    }

    @NotNull
    public final Margin copy(double top, double right, double bottom, double left) {
        return new Margin(top, right, bottom, left);
    }

    public static /* synthetic */ Margin copy$default(Margin margin, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = margin.top;
        }
        if ((n & 2) != 0) {
            d2 = margin.right;
        }
        if ((n & 4) != 0) {
            d3 = margin.bottom;
        }
        if ((n & 8) != 0) {
            d4 = margin.left;
        }
        return margin.copy(d, d2, d3, d4);
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.top);
        result2 = result2 * 31 + Double.hashCode(this.right);
        result2 = result2 * 31 + Double.hashCode(this.bottom);
        result2 = result2 * 31 + Double.hashCode(this.left);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Margin)) {
            return false;
        }
        Margin margin = (Margin)other;
        if (Double.compare(this.top, margin.top) != 0) {
            return false;
        }
        if (Double.compare(this.right, margin.right) != 0) {
            return false;
        }
        if (Double.compare(this.bottom, margin.bottom) != 0) {
            return false;
        }
        return Double.compare(this.left, margin.left) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0086\nJ\u0019\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0086\nJ)\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0086\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lkorlibs/math/geom/Margin$Companion;", "", "()V", "ZERO", "Lkorlibs/math/geom/Margin;", "getZERO", "()Lkorlibs/math/geom/Margin;", "invoke", "margin", "", "vertical", "horizontal", "top", "right", "bottom", "left", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Margin getZERO() {
            return ZERO;
        }

        @NotNull
        public final Margin invoke(@NotNull Number margin) {
            boolean $i$f$invoke = false;
            return new Margin(margin.doubleValue(), margin.doubleValue(), margin.doubleValue(), margin.doubleValue());
        }

        @NotNull
        public final Margin invoke(@NotNull Number vertical, @NotNull Number horizontal) {
            boolean $i$f$invoke = false;
            return new Margin(vertical.doubleValue(), horizontal.doubleValue(), vertical.doubleValue(), horizontal.doubleValue());
        }

        @NotNull
        public final Margin invoke(@NotNull Number top, @NotNull Number right, @NotNull Number bottom, @NotNull Number left) {
            boolean $i$f$invoke = false;
            return new Margin(top.doubleValue(), right.doubleValue(), bottom.doubleValue(), left.doubleValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

