/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.geom.Angle;
import korlibs.math.geom.MatrixTransform;
import korlibs.math.geom.MatrixType;
import korlibs.math.geom.Scale;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.Vector2F;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000 c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001cB;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\n\u0012\b\b\u0002\u0010\u0007\u001a\u00020\n\u0012\b\b\u0002\u0010\b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB9\u0012\u0006\u0010\u0002\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\f\u0012\u0006\u0010\u0005\u001a\u00020\f\u0012\u0006\u0010\u0006\u001a\u00020\f\u0012\b\b\u0002\u0010\u0007\u001a\u00020\f\u0012\b\b\u0002\u0010\b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001f\u001a\u00020\u0000H\u0007J\t\u0010 \u001a\u00020\fH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003JE\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\f2\b\b\u0002\u0010\u0004\u001a\u00020\f2\b\b\u0002\u0010\u0005\u001a\u00020\f2\b\b\u0002\u0010\u0006\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\f2\b\b\u0002\u0010\b\u001a\u00020\fH\u00c6\u0001J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*J\u000e\u0010)\u001a\u00020,2\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00060*j\u0002`.2\n\u0010+\u001a\u00060*j\u0002`.J\u0013\u0010/\u001a\u00020\u00142\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u00020\nH\u00d6\u0001J\u0006\u00103\u001a\u00020\u0000J\u0018\u00104\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00002\u0006\u00105\u001a\u00020\fH\u0016J\u0010\u00106\u001a\u00020\u00142\b\b\u0002\u00105\u001a\u00020\fJ\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0000J\u000e\u00109\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000J\u000e\u0010:\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0000J\u0018\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=\u00f8\u0001\u0000\u00a2\u0006\u0004\b>\u0010?J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020BJ\u0018\u0010@\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\f2\b\b\u0002\u0010D\u001a\u00020\fJ\u0018\u0010@\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u00032\b\b\u0002\u0010D\u001a\u00020\u0003J\u0018\u0010@\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\n2\b\b\u0002\u0010D\u001a\u00020\nJ \u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020=\u00f8\u0001\u0000\u00a2\u0006\u0004\bH\u0010IJ\u0012\u0010J\u001a\u00020\u00002\n\u0010K\u001a\u00060*j\u0002`.J\u0016\u0010J\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\f2\u0006\u0010M\u001a\u00020\fJ\u0016\u0010J\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020\u0003J\u0016\u0010J\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\nJ\u0018\u0010N\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=\u00f8\u0001\u0000\u00a2\u0006\u0004\bO\u0010?J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010A\u001a\u00020BJ\u0018\u0010P\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\f2\b\b\u0002\u0010D\u001a\u00020\fJ\u0018\u0010P\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u00032\b\b\u0002\u0010D\u001a\u00020\u0003J\u0018\u0010P\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\n2\b\b\u0002\u0010D\u001a\u00020\nJ \u0010Q\u001a\u00020\u00002\u0006\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020=\u00f8\u0001\u0000\u00a2\u0006\u0004\bR\u0010IJ\u0011\u0010S\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010S\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\fH\u0086\u0002J\u0011\u0010S\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0003H\u0086\u0002J\u0018\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\b\b\u0002\u0010X\u001a\u00020\nJ\u0018\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020Y2\b\b\u0002\u0010X\u001a\u00020\nJ\b\u0010Z\u001a\u00020[H\u0016J\u0006\u0010\\\u001a\u00020(J\u0011\u0010]\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0086\bJ\u0011\u0010]\u001a\u00020,2\u0006\u0010+\u001a\u00020,H\u0086\bJ\u0014\u0010^\u001a\u00020\f2\n\u0010+\u001a\u00060*j\u0002`.H\u0007J\u0018\u0010^\u001a\u00020\f2\u0006\u0010_\u001a\u00020\f2\u0006\u0010`\u001a\u00020\fH\u0007J\u0018\u0010^\u001a\u00020\u00032\u0006\u0010_\u001a\u00020\u00032\u0006\u0010`\u001a\u00020\u0003H\u0007J\u0018\u0010^\u001a\u00020\f2\u0006\u0010_\u001a\u00020\n2\u0006\u0010`\u001a\u00020\nH\u0007J\u0014\u0010a\u001a\u00020\f2\n\u0010+\u001a\u00060*j\u0002`.H\u0007J\u0018\u0010a\u001a\u00020\f2\u0006\u0010_\u001a\u00020\f2\u0006\u0010`\u001a\u00020\fH\u0007J\u0018\u0010a\u001a\u00020\u00032\u0006\u0010_\u001a\u00020\u00032\u0006\u0010`\u001a\u00020\u0003H\u0007J\u0018\u0010a\u001a\u00020\f2\u0006\u0010_\u001a\u00020\n2\u0006\u0010`\u001a\u00020\nH\u0007J\u0012\u0010b\u001a\u00020\u00002\n\u0010K\u001a\u00060*j\u0002`.J\u0016\u0010b\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\f2\u0006\u0010`\u001a\u00020\fJ\u0016\u0010b\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u00032\u0006\u0010`\u001a\u00020\u0003J\u0016\u0010b\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\n2\u0006\u0010`\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006d"}, d2={"Lkorlibs/math/geom/Matrix;", "Lkorlibs/math/IsAlmostEquals;", "a", "", "b", "c", "d", "tx", "ty", "(FFFFFF)V", "", "(IIIIII)V", "", "(DDDDDD)V", "getA", "()D", "getB", "getC", "getD", "isIdentity", "", "()Z", "isNIL", "isNaN", "isNotNIL", "getTx", "getTy", "type", "Lkorlibs/math/geom/MatrixType;", "getType", "()Lkorlibs/math/geom/MatrixType;", "clone", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "decompose", "Lkorlibs/math/geom/MatrixTransform;", "deltaTransform", "Lkorlibs/math/geom/Vector2D;", "p", "Lkorlibs/math/geom/Vector2F;", "deltaTransformPoint", "Lkorlibs/math/geom/Point;", "equals", "other", "", "hashCode", "inverted", "isAlmostEquals", "epsilon", "isAlmostIdentity", "multiplied", "m", "preconcated", "premultiplied", "prerotated", "angle", "Lkorlibs/math/geom/Angle;", "prerotated-Mi4kPw4", "(D)Lkorlibs/math/geom/Matrix;", "prescaled", "scale", "Lkorlibs/math/geom/Scale;", "scaleX", "scaleY", "preskewed", "skewX", "skewY", "preskewed-256m-Io", "(DD)Lkorlibs/math/geom/Matrix;", "pretranslated", "delta", "deltaX", "deltaY", "rotated", "rotated-Mi4kPw4", "scaled", "skewed", "skewed-256m-Io", "times", "toArray", "", "value", "", "offset", "", "toString", "", "toTransform", "transform", "transformX", "x", "y", "transformY", "translated", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nkorlibs/math/geom/Matrix\n+ 2 Angle.kt\nkorlibs/math/geom/AngleKt\n*L\n1#1,475:1\n211#2:476\n212#2:477\n212#2:478\n211#2:479\n212#2:480\n211#2:481\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\nkorlibs/math/geom/Matrix\n*L\n88#1:476\n89#1:477\n107#1:478\n108#1:479\n109#1:480\n110#1:481\n*E\n"})
public final class Matrix
implements IsAlmostEquals<Matrix> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double tx;
    private final double ty;
    @NotNull
    private static final Matrix IDENTITY = new Matrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    @NotNull
    private static final Matrix NIL;
    @NotNull
    private static final Matrix NaN;

    public Matrix(double a, double b, double c, double d, double tx, double ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public /* synthetic */ Matrix(double d, double d2, double d3, double d4, double d5, double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6);
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getC() {
        return this.c;
    }

    public final double getD() {
        return this.d;
    }

    public final double getTx() {
        return this.tx;
    }

    public final double getTy() {
        return this.ty;
    }

    public Matrix(float a, float b, float c, float d, float tx, float ty) {
        this((double)a, (double)b, (double)c, (double)d, (double)tx, (double)ty);
    }

    public /* synthetic */ Matrix(float f, float f2, float f3, float f4, float f5, float f6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            f5 = 0.0f;
        }
        if ((n & 0x20) != 0) {
            f6 = 0.0f;
        }
        this(f, f2, f3, f4, f5, f6);
    }

    public Matrix(int a, int b, int c, int d, int tx, int ty) {
        this((double)a, (double)b, (double)c, (double)d, (double)tx, (double)ty);
    }

    public /* synthetic */ Matrix(int n, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x20) != 0) {
            n6 = 0;
        }
        this(n, n2, n3, n4, n5, n6);
    }

    @NotNull
    public final Matrix times(@NotNull Matrix other) {
        return Companion.multiply(this, other);
    }

    @NotNull
    public final Matrix times(double scale) {
        return new Matrix(this.a * scale, this.b * scale, this.c * scale, this.d * scale, this.tx * scale, this.ty * scale);
    }

    @NotNull
    public final Matrix times(float scale) {
        return this.times((double)scale);
    }

    public final boolean isNIL() {
        return Double.isNaN(this.a);
    }

    public final boolean isNotNIL() {
        return !this.isNIL();
    }

    public final boolean isNaN() {
        return this.isNIL();
    }

    public final boolean isIdentity() {
        return this.a == 1.0 && this.b == 0.0 && this.c == 0.0 && this.d == 1.0 && this.tx == 0.0 && this.ty == 0.0;
    }

    @NotNull
    public final MatrixType getType() {
        boolean hasRotation = !(this.b == 0.0) || !(this.c == 0.0);
        boolean hasScale = !(this.a == 1.0) || !(this.d == 1.0);
        boolean hasTranslation = !(this.tx == 0.0) || !(this.ty == 0.0);
        return hasRotation ? MatrixType.COMPLEX : (hasScale && hasTranslation ? MatrixType.SCALE_TRANSLATE : (hasScale ? MatrixType.SCALE : (hasTranslation ? MatrixType.TRANSLATE : MatrixType.IDENTITY)));
    }

    @NotNull
    public final Vector2F transform(@NotNull Vector2F p) {
        boolean $i$f$transform = false;
        if (this.isNIL()) {
            return p;
        }
        return new Vector2F(this.getA() * (double)p.getX() + this.getC() * (double)p.getY() + this.getTx(), this.getD() * (double)p.getY() + this.getB() * (double)p.getX() + this.getTy());
    }

    @NotNull
    public final Vector2D transform(@NotNull Vector2D p) {
        boolean $i$f$transform = false;
        if (this.isNIL()) {
            return p;
        }
        return new Vector2D(this.transformX(p.getX(), p.getY()), this.transformY(p.getX(), p.getY()));
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).x", imports={}))
    public final double transformX(@NotNull Vector2D p) {
        return this.transformX(p.getX(), p.getY());
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).y", imports={}))
    public final double transformY(@NotNull Vector2D p) {
        return this.transformY(p.getX(), p.getY());
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).x", imports={}))
    public final float transformX(float x, float y) {
        return (float)this.transformX((double)x, (double)y);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).y", imports={}))
    public final float transformY(float x, float y) {
        return (float)this.transformY((double)x, (double)y);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).x", imports={}))
    public final double transformX(double x, double y) {
        return this.a * x + this.c * y + this.tx;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).y", imports={}))
    public final double transformY(double x, double y) {
        return this.d * y + this.b * x + this.ty;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).x", imports={}))
    public final double transformX(int x, int y) {
        return this.transformX((double)x, (double)y);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="transform(p).y", imports={}))
    public final double transformY(int x, int y) {
        return this.transformY((double)x, (double)y);
    }

    @NotNull
    public final Vector2F deltaTransform(@NotNull Vector2F p) {
        return new Vector2F((double)p.getX() * this.a + (double)p.getY() * this.c, (double)p.getX() * this.b + (double)p.getY() * this.d);
    }

    @NotNull
    public final Vector2D deltaTransform(@NotNull Vector2D p) {
        return new Vector2D(p.getX() * this.a + p.getY() * this.c, p.getX() * this.b + p.getY() * this.d);
    }

    @NotNull
    public final Matrix rotated-Mi4kPw4(double angle) {
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        double cos = Angle.cosine-impl(angle, up$iv);
        Vector2D up$iv2 = Vector2D.Companion.getUP();
        boolean bl2 = false;
        double sin = Angle.sine-impl(angle, up$iv2);
        double a1 = this.a * cos - this.b * sin;
        double b = this.a * sin + this.b * cos;
        double a = a1;
        double c1 = this.c * cos - this.d * sin;
        double d = this.c * sin + this.d * cos;
        double c = c1;
        double tx1 = this.tx * cos - this.ty * sin;
        double ty = this.tx * sin + this.ty * cos;
        double tx = tx1;
        return new Matrix(a, b, c, d, tx, ty);
    }

    @NotNull
    public final Matrix skewed-256m-Io(double skewX, double skewY) {
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        double sinX = Angle.sine-impl(skewX, up$iv);
        Vector2D up$iv2 = Vector2D.Companion.getUP();
        boolean bl2 = false;
        double cosX = Angle.cosine-impl(skewX, up$iv2);
        Vector2D up$iv3 = Vector2D.Companion.getUP();
        $i$f$sin-2FdH_oo = false;
        double sinY = Angle.sine-impl(skewY, up$iv3);
        Vector2D up$iv4 = Vector2D.Companion.getUP();
        $i$f$cos-2FdH_oo = false;
        double cosY = Angle.cosine-impl(skewY, up$iv4);
        return new Matrix(this.a * cosY - this.b * sinX, this.a * sinY + this.b * cosX, this.c * cosY - this.d * sinX, this.c * sinY + this.d * cosX, this.tx * cosY - this.ty * sinX, this.tx * sinY + this.ty * cosX);
    }

    @NotNull
    public final Matrix scaled(@NotNull Scale scale) {
        return new Matrix(this.a * scale.getScaleX(), this.b * scale.getScaleX(), this.c * scale.getScaleY(), this.d * scale.getScaleY(), this.tx * scale.getScaleX(), this.ty * scale.getScaleY());
    }

    @NotNull
    public final Matrix scaled(int scaleX, int scaleY) {
        return this.scaled(new Scale(scaleX, scaleY));
    }

    public static /* synthetic */ Matrix scaled$default(Matrix matrix2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return matrix2.scaled(n, n2);
    }

    @NotNull
    public final Matrix scaled(float scaleX, float scaleY) {
        return this.scaled(new Scale(scaleX, scaleY));
    }

    public static /* synthetic */ Matrix scaled$default(Matrix matrix2, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        return matrix2.scaled(f, f2);
    }

    @NotNull
    public final Matrix scaled(double scaleX, double scaleY) {
        return this.scaled(new Scale(scaleX, scaleY));
    }

    public static /* synthetic */ Matrix scaled$default(Matrix matrix2, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return matrix2.scaled(d, d2);
    }

    @NotNull
    public final Matrix prescaled(@NotNull Scale scale) {
        return new Matrix(this.a * scale.getScaleX(), this.b * scale.getScaleX(), this.c * scale.getScaleY(), this.d * scale.getScaleY(), this.tx, this.ty);
    }

    @NotNull
    public final Matrix prescaled(int scaleX, int scaleY) {
        return this.prescaled(new Scale(scaleX, scaleY));
    }

    public static /* synthetic */ Matrix prescaled$default(Matrix matrix2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return matrix2.prescaled(n, n2);
    }

    @NotNull
    public final Matrix prescaled(float scaleX, float scaleY) {
        return this.prescaled(new Scale(scaleX, scaleY));
    }

    public static /* synthetic */ Matrix prescaled$default(Matrix matrix2, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        return matrix2.prescaled(f, f2);
    }

    @NotNull
    public final Matrix prescaled(double scaleX, double scaleY) {
        return this.prescaled(new Scale(scaleX, scaleY));
    }

    public static /* synthetic */ Matrix prescaled$default(Matrix matrix2, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return matrix2.prescaled(d, d2);
    }

    @NotNull
    public final Matrix translated(@NotNull Vector2D delta) {
        return new Matrix(this.a, this.b, this.c, this.d, this.tx + delta.getX(), this.ty + delta.getY());
    }

    @NotNull
    public final Matrix translated(int x, int y) {
        return this.translated(new Vector2D(x, y));
    }

    @NotNull
    public final Matrix translated(float x, float y) {
        return this.translated(new Vector2D(x, y));
    }

    @NotNull
    public final Matrix translated(double x, double y) {
        return this.translated(new Vector2D(x, y));
    }

    @NotNull
    public final Matrix pretranslated(@NotNull Vector2D delta) {
        return new Matrix(this.a, this.b, this.c, this.d, this.tx + (this.a * delta.getX() + this.c * delta.getY()), this.ty + (this.b * delta.getX() + this.d * delta.getY()));
    }

    @NotNull
    public final Matrix pretranslated(int deltaX, int deltaY) {
        return this.pretranslated(new Vector2D(deltaX, deltaY));
    }

    @NotNull
    public final Matrix pretranslated(float deltaX, float deltaY) {
        return this.pretranslated(new Vector2D(deltaX, deltaY));
    }

    @NotNull
    public final Matrix pretranslated(double deltaX, double deltaY) {
        return this.pretranslated(new Vector2D(deltaX, deltaY));
    }

    @NotNull
    public final Matrix prerotated-Mi4kPw4(double angle) {
        return Companion.rotating-Mi4kPw4(angle).times(this);
    }

    @NotNull
    public final Matrix preskewed-256m-Io(double skewX, double skewY) {
        return Companion.skewing-256m-Io(skewX, skewY).times(this);
    }

    @NotNull
    public final Matrix premultiplied(@NotNull Matrix m) {
        return m.times(this);
    }

    @NotNull
    public final Matrix multiplied(@NotNull Matrix m) {
        return this.times(m);
    }

    @NotNull
    public final Vector2D deltaTransformPoint(@NotNull Vector2D p) {
        return new Vector2D(p.getX() * this.a + p.getY() * this.c, p.getX() * this.b + p.getY() * this.d);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="this", imports={}))
    @NotNull
    public final Matrix clone() {
        return this;
    }

    @NotNull
    public final Matrix inverted() {
        Matrix matrix2;
        if (this.isNIL()) {
            return IDENTITY;
        }
        Matrix m = this;
        double norm = m.a * m.d - m.b * m.c;
        if (norm == 0.0) {
            matrix2 = new Matrix(0.0, 0.0, 0.0, 0.0, -m.tx, -m.ty);
        } else {
            double inorm = 1.0 / norm;
            double d = m.a * inorm;
            double a = m.d * inorm;
            double b = m.b * -inorm;
            double c = m.c * -inorm;
            matrix2 = new Matrix(a, b, c, d, -a * m.tx - c * m.ty, -b * m.tx - d * m.ty);
        }
        return matrix2;
    }

    @NotNull
    public final MatrixTransform toTransform() {
        return this.decompose();
    }

    @NotNull
    public final MatrixTransform decompose() {
        return MatrixTransform.Companion.fromMatrix$default(MatrixTransform.Companion, this, 0.0, 0.0, 6, null);
    }

    public final void toArray(@NotNull double[] value, int offset2) {
        value[offset2 + 0] = this.a;
        value[offset2 + 1] = this.b;
        value[offset2 + 2] = this.c;
        value[offset2 + 3] = this.d;
        value[offset2 + 4] = this.tx;
        value[offset2 + 5] = this.ty;
    }

    public static /* synthetic */ void toArray$default(Matrix matrix2, double[] dArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        matrix2.toArray(dArray, n);
    }

    public final void toArray(@NotNull float[] value, int offset2) {
        value[offset2 + 0] = (float)this.a;
        value[offset2 + 1] = (float)this.b;
        value[offset2 + 2] = (float)this.c;
        value[offset2 + 3] = (float)this.d;
        value[offset2 + 4] = (float)this.tx;
        value[offset2 + 5] = (float)this.ty;
    }

    public static /* synthetic */ void toArray$default(Matrix matrix2, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        matrix2.toArray(fArray, n);
    }

    @NotNull
    public String toString() {
        return "Matrix(" + StringExtKt.getNiceStr(this.a) + ", " + StringExtKt.getNiceStr(this.b) + ", " + StringExtKt.getNiceStr(this.c) + ", " + StringExtKt.getNiceStr(this.d) + ", " + StringExtKt.getNiceStr(this.tx) + ", " + StringExtKt.getNiceStr(this.ty) + ")";
    }

    @Override
    public boolean isAlmostEquals(@NotNull Matrix other, double epsilon) {
        return Companion.isAlmostEquals(this, other, epsilon);
    }

    public final boolean isAlmostIdentity(double epsilon) {
        return Companion.isAlmostEquals(this, IDENTITY, epsilon);
    }

    public static /* synthetic */ boolean isAlmostIdentity$default(Matrix matrix2, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0E-5;
        }
        return matrix2.isAlmostIdentity(d);
    }

    @NotNull
    public final Matrix preconcated(@NotNull Matrix other) {
        return this.times(other);
    }

    public final double component1() {
        return this.a;
    }

    public final double component2() {
        return this.b;
    }

    public final double component3() {
        return this.c;
    }

    public final double component4() {
        return this.d;
    }

    public final double component5() {
        return this.tx;
    }

    public final double component6() {
        return this.ty;
    }

    @NotNull
    public final Matrix copy(double a, double b, double c, double d, double tx, double ty) {
        return new Matrix(a, b, c, d, tx, ty);
    }

    public static /* synthetic */ Matrix copy$default(Matrix matrix2, double d, double d2, double d3, double d4, double d5, double d6, int n, Object object) {
        if ((n & 1) != 0) {
            d = matrix2.a;
        }
        if ((n & 2) != 0) {
            d2 = matrix2.b;
        }
        if ((n & 4) != 0) {
            d3 = matrix2.c;
        }
        if ((n & 8) != 0) {
            d4 = matrix2.d;
        }
        if ((n & 0x10) != 0) {
            d5 = matrix2.tx;
        }
        if ((n & 0x20) != 0) {
            d6 = matrix2.ty;
        }
        return matrix2.copy(d, d2, d3, d4, d5, d6);
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.a);
        result2 = result2 * 31 + Double.hashCode(this.b);
        result2 = result2 * 31 + Double.hashCode(this.c);
        result2 = result2 * 31 + Double.hashCode(this.d);
        result2 = result2 * 31 + Double.hashCode(this.tx);
        result2 = result2 * 31 + Double.hashCode(this.ty);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Matrix)) {
            return false;
        }
        Matrix matrix2 = (Matrix)other;
        if (Double.compare(this.a, matrix2.a) != 0) {
            return false;
        }
        if (Double.compare(this.b, matrix2.b) != 0) {
            return false;
        }
        if (Double.compare(this.c, matrix2.c) != 0) {
            return false;
        }
        if (Double.compare(this.d, matrix2.d) != 0) {
            return false;
        }
        if (Double.compare(this.tx, matrix2.tx) != 0) {
            return false;
        }
        return Double.compare(this.ty, matrix2.ty) == 0;
    }

    static {
        NaN = NIL = new Matrix(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00102\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015Jf\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00152\b\b\u0002\u0010\u001c\u001a\u00020\u00152\b\b\u0002\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u001a2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J(\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\t\u0010(\u001a\u00020\u0004H\u0086\u0002J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\b\b\u0002\u0010-\u001a\u00020\u0015J\u0016\u0010.\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u0018\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u001a\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J \u00103\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105JF\u0010\u0012\u001a\u000606j\u0002`72\u0006\u0010+\u001a\u0002082\u0006\u0010,\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u0002082\u0006\u0010;\u001a\u0002082\u0006\u0010<\u001a\u0002082\n\u0010=\u001a\u000606j\u0002`7J\u0012\u0010>\u001a\u00020\u00042\n\u0010?\u001a\u000606j\u0002`7R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006@"}, d2={"Lkorlibs/math/geom/Matrix$Companion;", "", "()V", "IDENTITY", "Lkorlibs/math/geom/Matrix;", "getIDENTITY", "()Lkorlibs/math/geom/Matrix;", "NIL", "getNIL", "NaN", "getNaN", "fromArray", "value", "", "offset", "", "", "fromTransform", "transform", "Lkorlibs/math/geom/MatrixTransform;", "pivotX", "", "pivotY", "x", "y", "rotation", "Lkorlibs/math/geom/Angle;", "scaleX", "scaleY", "skewX", "skewY", "fromTransform-acwDim4", "(DDDDDDDDD)Lkorlibs/math/geom/Matrix;", "interpolated", "l", "r", "ratio", "Lkorlibs/math/interpolation/Ratio;", "interpolated-i056VXE", "(Lkorlibs/math/geom/Matrix;Lkorlibs/math/geom/Matrix;D)Lkorlibs/math/geom/Matrix;", "invoke", "isAlmostEquals", "", "a", "b", "epsilon", "multiply", "rotating", "angle", "rotating-Mi4kPw4", "(D)Lkorlibs/math/geom/Matrix;", "skewing", "skewing-256m-Io", "(DD)Lkorlibs/math/geom/Matrix;", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "", "c", "d", "tx", "ty", "p", "translating", "delta", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nkorlibs/math/geom/Matrix$Companion\n+ 2 Angle.kt\nkorlibs/math/geom/AngleKt\n*L\n1#1,475:1\n211#2:476\n212#2:477\n212#2:478\n211#2:479\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\nkorlibs/math/geom/Matrix$Companion\n*L\n271#1:476\n272#1:477\n273#1:478\n274#1:479\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix getNIL() {
            return NIL;
        }

        @NotNull
        public final Matrix getNaN() {
            return NaN;
        }

        @NotNull
        public final Matrix invoke() {
            return this.getIDENTITY();
        }

        public final boolean isAlmostEquals(@NotNull Matrix a, @NotNull Matrix b, double epsilon) {
            return IsAlmostZeroKt.isAlmostEquals(a.getTx(), b.getTx(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getTy(), b.getTy(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getA(), b.getA(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getB(), b.getB(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getC(), b.getC(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getD(), b.getD(), epsilon);
        }

        public static /* synthetic */ boolean isAlmostEquals$default(Companion companion, Matrix matrix2, Matrix matrix3, double d, int n, Object object) {
            if ((n & 4) != 0) {
                d = 1.0E-5;
            }
            return companion.isAlmostEquals(matrix2, matrix3, d);
        }

        @NotNull
        public final Matrix multiply(@NotNull Matrix l, @NotNull Matrix r) {
            if (l.isNIL()) {
                return r;
            }
            if (r.isNIL()) {
                return l;
            }
            return new Matrix(l.getA() * r.getA() + l.getB() * r.getC(), l.getA() * r.getB() + l.getB() * r.getD(), l.getC() * r.getA() + l.getD() * r.getC(), l.getC() * r.getB() + l.getD() * r.getD(), l.getTx() * r.getA() + l.getTy() * r.getC() + r.getTx(), l.getTx() * r.getB() + l.getTy() * r.getD() + r.getTy());
        }

        @NotNull
        public final Matrix translating(@NotNull Vector2D delta) {
            return Matrix.copy$default(Companion.getIDENTITY(), 0.0, 0.0, 0.0, 0.0, delta.getX(), delta.getY(), 15, null);
        }

        @NotNull
        public final Matrix rotating-Mi4kPw4(double angle) {
            return Companion.getIDENTITY().rotated-Mi4kPw4(angle);
        }

        @NotNull
        public final Matrix skewing-256m-Io(double skewX, double skewY) {
            return Companion.getIDENTITY().skewed-256m-Io(skewX, skewY);
        }

        @NotNull
        public final Matrix fromArray(@NotNull float[] value, int offset2) {
            return new Matrix(value[offset2 + 0], value[offset2 + 1], value[offset2 + 2], value[offset2 + 3], value[offset2 + 4], value[offset2 + 5]);
        }

        public static /* synthetic */ Matrix fromArray$default(Companion companion, float[] fArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromArray(fArray, n);
        }

        @NotNull
        public final Matrix fromArray(@NotNull double[] value, int offset2) {
            return new Matrix(value[offset2 + 0], value[offset2 + 1], value[offset2 + 2], value[offset2 + 3], value[offset2 + 4], value[offset2 + 5]);
        }

        public static /* synthetic */ Matrix fromArray$default(Companion companion, double[] dArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromArray(dArray, n);
        }

        @NotNull
        public final Matrix fromTransform(@NotNull MatrixTransform transform2, double pivotX, double pivotY) {
            return this.fromTransform-acwDim4(transform2.getX(), transform2.getY(), transform2.getRotation-igmgxjg(), transform2.getScaleX(), transform2.getScaleY(), transform2.getSkewX-igmgxjg(), transform2.getSkewY-igmgxjg(), pivotX, pivotY);
        }

        public static /* synthetic */ Matrix fromTransform$default(Companion companion, MatrixTransform matrixTransform, double d, double d2, int n, Object object) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            if ((n & 4) != 0) {
                d2 = 0.0;
            }
            return companion.fromTransform(matrixTransform, d, d2);
        }

        @NotNull
        public final Matrix fromTransform-acwDim4(double x, double y, double rotation, double scaleX, double scaleY, double skewX, double skewY, double pivotX, double pivotY) {
            double angle$iv = Angle.plus-9E-s4b0(rotation, skewY);
            Vector2D up$iv = Vector2D.Companion.getUP();
            boolean bl = false;
            double a = Angle.cosine-impl(angle$iv, up$iv) * scaleX + (double)0.0f;
            double angle$iv2 = Angle.plus-9E-s4b0(rotation, skewY);
            Vector2D up$iv2 = Vector2D.Companion.getUP();
            boolean bl2 = false;
            double b = Angle.sine-impl(angle$iv2, up$iv2) * scaleX + (double)0.0f;
            double angle$iv3 = Angle.minus-9E-s4b0(rotation, skewX);
            Vector2D up$iv3 = Vector2D.Companion.getUP();
            $i$f$sin-2FdH_oo = false;
            double c = -Angle.sine-impl(angle$iv3, up$iv3) * scaleY + (double)0.0f;
            double angle$iv4 = Angle.minus-9E-s4b0(rotation, skewX);
            Vector2D up$iv4 = Vector2D.Companion.getUP();
            $i$f$cos-2FdH_oo = false;
            double d = Angle.cosine-impl(angle$iv4, up$iv4) * scaleY + (double)0.0f;
            double tx = 0.0;
            double ty = 0.0;
            if (pivotX == 0.0 && pivotY == 0.0) {
                tx = x;
                ty = y;
            } else {
                tx = x - (pivotX * a + pivotY * c);
                ty = y - (pivotX * b + pivotY * d);
            }
            return new Matrix(a, b, c, d, tx, ty);
        }

        public static /* synthetic */ Matrix fromTransform-acwDim4$default(Companion companion, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, Object object) {
            if ((n & 4) != 0) {
                d3 = Angle.Companion.getZERO-igmgxjg();
            }
            if ((n & 8) != 0) {
                d4 = 1.0;
            }
            if ((n & 0x10) != 0) {
                d5 = 1.0;
            }
            if ((n & 0x20) != 0) {
                d6 = Angle.Companion.getZERO-igmgxjg();
            }
            if ((n & 0x40) != 0) {
                d7 = Angle.Companion.getZERO-igmgxjg();
            }
            if ((n & 0x80) != 0) {
                d8 = 0.0;
            }
            if ((n & 0x100) != 0) {
                d9 = 0.0;
            }
            return companion.fromTransform-acwDim4(d, d2, d3, d4, d5, d6, d7, d8, d9);
        }

        @NotNull
        public final Vector2D transform(float a, float b, float c, float d, float tx, float ty, @NotNull Vector2D p) {
            return new Vector2D((double)a * p.getX() + (double)c * p.getY() + (double)tx, (double)d * p.getY() + (double)b * p.getX() + (double)ty);
        }

        @NotNull
        public final Matrix interpolated-i056VXE(@NotNull Matrix l, @NotNull Matrix r, double ratio2) {
            return new Matrix(_Math_interpolationKt.interpolate-aphylw4(ratio2, l.getA(), r.getA()), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.getB(), r.getB()), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.getC(), r.getC()), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.getD(), r.getD()), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.getTx(), r.getTx()), _Math_interpolationKt.interpolate-aphylw4(ratio2, l.getTy(), r.getTy()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

