/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import java.util.Arrays;
import korlibs.math.IsAlmostEqualsF;
import korlibs.math.geom.Vector3F;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u0000 K2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001KBO\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fB\u000f\b\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u000eH\u00c0\u0003\u00a2\u0006\u0002\b0J\u0013\u00101\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0011\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0003H\u0086\u0002J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0096\u0002J\u0019\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020.2\u0006\u0010-\u001a\u00020.H\u0086\u0002J\b\u0010:\u001a\u00020.H\u0016J\u0006\u0010;\u001a\u00020\u0000J\u0006\u0010<\u001a\u00020\u0000J\u0018\u0010=\u001a\u0002052\u0006\u00106\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0003H\u0016J\u0011\u0010?\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010@\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010A\u001a\u00020\u00112\u0006\u00109\u001a\u00020.J\u0011\u0010B\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0003H\u0086\u0002J\b\u0010C\u001a\u00020DH\u0016J\u000e\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u0011J\u0006\u0010G\u001a\u00020\u0000J\t\u0010H\u001a\u00020\u0000H\u0086\u0002J\t\u0010I\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010F\u001a\u00020\u00032\u0006\u0010J\u001a\u00020.R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013R\u0011\u0010!\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001cR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001cR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001cR\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001c\u00a8\u0006L"}, d2={"Lkorlibs/math/geom/Matrix3;", "Lkorlibs/math/IsAlmostEqualsF;", "v00", "", "v10", "v20", "v01", "v11", "v21", "v02", "v12", "v22", "(FFFFFFFFF)V", "data", "", "([F)V", "c0", "Lkorlibs/math/geom/Vector3F;", "getC0", "()Lkorlibs/math/geom/Vector3F;", "c1", "getC1", "c2", "getC2", "getData$korge_foundation", "()[F", "determinant", "getDeterminant", "()F", "r0", "getR0", "r1", "getR1", "r2", "getR2", "getV00", "getV01", "getV02", "getV10", "getV11", "getV12", "getV20", "getV21", "getV22", "c", "column", "", "component1", "component1$korge_foundation", "copy", "div", "scale", "equals", "", "other", "", "get", "row", "hashCode", "inv", "inverted", "isAlmostEquals", "epsilon", "minus", "plus", "r", "times", "toString", "", "transform", "v", "transposed", "unaryMinus", "unaryPlus", "index", "Companion", "korge-foundation"})
public final class Matrix3
implements IsAlmostEqualsF<Matrix3> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] data;
    public static final int M00 = 0;
    public static final int M10 = 1;
    public static final int M20 = 2;
    public static final int M01 = 3;
    public static final int M11 = 4;
    public static final int M21 = 5;
    public static final int M02 = 6;
    public static final int M12 = 7;
    public static final int M22 = 8;
    public static final int M03 = 9;
    public static final int M13 = 10;
    public static final int M23 = 11;
    @NotNull
    private static final int[] INDICES_BY_COLUMNS;
    @NotNull
    private static final int[] INDICES_BY_ROWS;
    @NotNull
    private static final Matrix3 IDENTITY;

    private Matrix3(float[] data2) {
        this.data = data2;
        if (!(this.data.length == 9)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final float[] getData$korge_foundation() {
        return this.data;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Matrix3 && Arrays.equals(this.data, ((Matrix3)other).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    private Matrix3(float v00, float v10, float v20, float v01, float v11, float v21, float v02, float v12, float v22) {
        float[] fArray = new float[]{v00, v10, v20, v01, v11, v21, v02, v12, v22};
        this(fArray);
    }

    public final float getV00() {
        return this.data[0];
    }

    public final float getV10() {
        return this.data[1];
    }

    public final float getV20() {
        return this.data[2];
    }

    public final float getV01() {
        return this.data[3];
    }

    public final float getV11() {
        return this.data[4];
    }

    public final float getV21() {
        return this.data[5];
    }

    public final float getV02() {
        return this.data[6];
    }

    public final float getV12() {
        return this.data[7];
    }

    public final float getV22() {
        return this.data[8];
    }

    @NotNull
    public final Vector3F getC0() {
        return Vector3F.Companion.fromArray(this.data, 0);
    }

    @NotNull
    public final Vector3F getC1() {
        return Vector3F.Companion.fromArray(this.data, 3);
    }

    @NotNull
    public final Vector3F getC2() {
        return Vector3F.Companion.fromArray(this.data, 6);
    }

    @NotNull
    public final Vector3F c(int column) {
        if (column < 0 || column >= 3) {
            throw new IllegalStateException(("Invalid column " + column).toString());
        }
        return Vector3F.Companion.fromArray(this.data, column * 3);
    }

    @NotNull
    public final Vector3F getR0() {
        return new Vector3F(this.getV00(), this.getV01(), this.getV02());
    }

    @NotNull
    public final Vector3F getR1() {
        return new Vector3F(this.getV10(), this.getV11(), this.getV12());
    }

    @NotNull
    public final Vector3F getR2() {
        return new Vector3F(this.getV20(), this.getV21(), this.getV22());
    }

    public final float v(int index2) {
        return this.data[index2];
    }

    @NotNull
    public final Vector3F r(int row) {
        Vector3F vector3F;
        switch (row) {
            case 0: {
                vector3F = this.getR0();
                break;
            }
            case 1: {
                vector3F = this.getR1();
                break;
            }
            case 2: {
                vector3F = this.getR2();
                break;
            }
            default: {
                throw new IllegalStateException(("Invalid row " + row).toString());
            }
        }
        return vector3F;
    }

    public final float get(int row, int column) {
        block4: {
            block3: {
                boolean bl = 0 <= column ? column < 3 : false;
                if (!bl) break block3;
                if (0 <= row ? row < 3 : false) break block4;
            }
            throw new IllegalStateException(("Invalid index " + row + "," + column).toString());
        }
        return this.data[row * 3 + column];
    }

    @NotNull
    public final Vector3F transform(@NotNull Vector3F v) {
        return new Vector3F(this.getR0().dot(v), this.getR1().dot(v), this.getR2().dot(v));
    }

    @NotNull
    public final Matrix3 unaryMinus() {
        return new Matrix3(-this.getV00(), -this.getV10(), -this.getV20(), -this.getV01(), -this.getV11(), -this.getV21(), -this.getV02(), -this.getV12(), -this.getV22());
    }

    @NotNull
    public final Matrix3 unaryPlus() {
        return this;
    }

    @NotNull
    public final Matrix3 minus(@NotNull Matrix3 other) {
        return new Matrix3(this.getV00() - other.getV00(), this.getV10() - other.getV10(), this.getV20() - other.getV20(), this.getV01() - other.getV01(), this.getV11() - other.getV11(), this.getV21() - other.getV21(), this.getV02() - other.getV02(), this.getV12() - other.getV12(), this.getV22() - other.getV22());
    }

    @NotNull
    public final Matrix3 plus(@NotNull Matrix3 other) {
        return new Matrix3(this.getV00() + other.getV00(), this.getV10() + other.getV10(), this.getV20() + other.getV20(), this.getV01() + other.getV01(), this.getV11() + other.getV11(), this.getV21() + other.getV21(), this.getV02() + other.getV02(), this.getV12() + other.getV12(), this.getV22() + other.getV22());
    }

    @NotNull
    public final Matrix3 times(@NotNull Matrix3 other) {
        return Companion.multiply(this, other);
    }

    @NotNull
    public final Matrix3 times(float scale) {
        return new Matrix3(this.getV00() * scale, this.getV10() * scale, this.getV20() * scale, this.getV01() * scale, this.getV11() * scale, this.getV21() * scale, this.getV02() * scale, this.getV12() * scale, this.getV22() * scale);
    }

    @NotNull
    public final Matrix3 div(float scale) {
        return this.times(1.0f / scale);
    }

    @NotNull
    public final Matrix3 inv() {
        return this.inverted();
    }

    public final float getDeterminant() {
        return this.getV00() * (this.getV11() * this.getV22() - this.getV21() * this.getV12()) - this.getV01() * (this.getV10() * this.getV22() - this.getV12() * this.getV20()) + this.getV02() * (this.getV10() * this.getV21() - this.getV11() * this.getV20());
    }

    @NotNull
    public final Matrix3 inverted() {
        float determinant = this.getDeterminant();
        if (determinant == 0.0f) {
            throw new ArithmeticException("Matrix is not invertible");
        }
        float invDet = 1.0f / determinant;
        return Companion.fromRows((this.getV11() * this.getV22() - this.getV21() * this.getV12()) * invDet, (this.getV02() * this.getV21() - this.getV01() * this.getV22()) * invDet, (this.getV01() * this.getV12() - this.getV02() * this.getV11()) * invDet, (this.getV12() * this.getV20() - this.getV10() * this.getV22()) * invDet, (this.getV00() * this.getV22() - this.getV02() * this.getV20()) * invDet, (this.getV10() * this.getV02() - this.getV00() * this.getV12()) * invDet, (this.getV10() * this.getV21() - this.getV20() * this.getV11()) * invDet, (this.getV20() * this.getV01() - this.getV00() * this.getV21()) * invDet, (this.getV00() * this.getV11() - this.getV10() * this.getV01()) * invDet);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("Matrix3(\n");
        for (int row = 0; row < 3; ++row) {
            $this$toString_u24lambda_u240.append("  [ ");
            for (int col = 0; col < 3; ++col) {
                float v;
                if (col != 0) {
                    $this$toString_u24lambda_u240.append(", ");
                }
                if ((float)Math.floor(v = this.get(row, col)) == v) {
                    $this$toString_u24lambda_u240.append((int)v);
                    continue;
                }
                $this$toString_u24lambda_u240.append(v);
            }
            $this$toString_u24lambda_u240.append(" ],\n");
        }
        $this$toString_u24lambda_u240.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final Matrix3 transposed() {
        return Companion.fromColumns(this.getR0(), this.getR1(), this.getR2());
    }

    @Override
    public boolean isAlmostEquals(@NotNull Matrix3 other, float epsilon) {
        return this.getC0().isAlmostEquals(other.getC0(), epsilon) && this.getC1().isAlmostEquals(other.getC1(), epsilon) && this.getC2().isAlmostEquals(other.getC2(), epsilon);
    }

    @NotNull
    public final float[] component1$korge_foundation() {
        return this.data;
    }

    @NotNull
    public final Matrix3 copy(@NotNull float[] data2) {
        return new Matrix3(data2);
    }

    public static /* synthetic */ Matrix3 copy$default(Matrix3 matrix3, float[] fArray, int n, Object object) {
        if ((n & 1) != 0) {
            fArray = matrix3.data;
        }
        return matrix3.copy(fArray);
    }

    public /* synthetic */ Matrix3(float v00, float v10, float v20, float v01, float v11, float v21, float v02, float v12, float v22, DefaultConstructorMarker $constructor_marker) {
        this(v00, v10, v20, v01, v11, v21, v02, v12, v22);
    }

    static {
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        INDICES_BY_COLUMNS = nArray;
        nArray = new int[]{0, 3, 6, 1, 4, 7, 2, 5, 8};
        INDICES_BY_ROWS = nArray;
        IDENTITY = new Matrix3(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cJN\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 J\u001e\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001cJN\u0010)\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0006\u0010(\u001a\u00020 J\u0016\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lkorlibs/math/geom/Matrix3$Companion;", "", "()V", "IDENTITY", "Lkorlibs/math/geom/Matrix3;", "getIDENTITY", "()Lkorlibs/math/geom/Matrix3;", "INDICES_BY_COLUMNS", "", "getINDICES_BY_COLUMNS", "()[I", "INDICES_BY_ROWS", "getINDICES_BY_ROWS", "M00", "", "M01", "M02", "M03", "M10", "M11", "M12", "M13", "M20", "M21", "M22", "M23", "fromColumns", "c0", "Lkorlibs/math/geom/Vector3F;", "c1", "c2", "v00", "", "v10", "v20", "v01", "v11", "v21", "v02", "v12", "v22", "fromRows", "r0", "r1", "r2", "multiply", "l", "r", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getINDICES_BY_COLUMNS() {
            return INDICES_BY_COLUMNS;
        }

        @NotNull
        public final int[] getINDICES_BY_ROWS() {
            return INDICES_BY_ROWS;
        }

        @NotNull
        public final Matrix3 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix3 fromRows(@NotNull Vector3F r0, @NotNull Vector3F r1, @NotNull Vector3F r2) {
            return new Matrix3(r0.getX(), r1.getX(), r2.getX(), r0.getY(), r1.getY(), r2.getY(), r0.getZ(), r1.getZ(), r2.getZ(), null);
        }

        @NotNull
        public final Matrix3 fromColumns(@NotNull Vector3F c0, @NotNull Vector3F c1, @NotNull Vector3F c2) {
            return new Matrix3(c0.getX(), c0.getY(), c0.getZ(), c1.getX(), c1.getY(), c1.getZ(), c2.getX(), c2.getY(), c2.getZ(), null);
        }

        @NotNull
        public final Matrix3 fromColumns(float v00, float v10, float v20, float v01, float v11, float v21, float v02, float v12, float v22) {
            return new Matrix3(v00, v10, v20, v01, v11, v21, v02, v12, v22, null);
        }

        @NotNull
        public final Matrix3 fromRows(float v00, float v01, float v02, float v10, float v11, float v12, float v20, float v21, float v22) {
            return new Matrix3(v00, v10, v20, v01, v11, v21, v02, v12, v22, null);
        }

        @NotNull
        public final Matrix3 multiply(@NotNull Matrix3 l, @NotNull Matrix3 r) {
            return Companion.fromRows(l.getV00() * r.getV00() + l.getV01() * r.getV10() + l.getV02() * r.getV20(), l.getV00() * r.getV01() + l.getV01() * r.getV11() + l.getV02() * r.getV21(), l.getV00() * r.getV02() + l.getV01() * r.getV12() + l.getV02() * r.getV22(), l.getV10() * r.getV00() + l.getV11() * r.getV10() + l.getV12() * r.getV20(), l.getV10() * r.getV01() + l.getV11() * r.getV11() + l.getV12() * r.getV21(), l.getV10() * r.getV02() + l.getV11() * r.getV12() + l.getV12() * r.getV22(), l.getV20() * r.getV00() + l.getV21() * r.getV10() + l.getV22() * r.getV20(), l.getV20() * r.getV01() + l.getV21() * r.getV11() + l.getV22() * r.getV21(), l.getV20() * r.getV02() + l.getV21() * r.getV12() + l.getV22() * r.getV22());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

