/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import java.util.Arrays;
import korlibs.math.IsAlmostEqualsF;
import korlibs.math.geom.Angle;
import korlibs.math.geom.EulerRotation;
import korlibs.math.geom.MMatrix4;
import korlibs.math.geom.Quaternion;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.TRS4;
import korlibs.math.geom.Vector3F;
import korlibs.math.geom.Vector4F;
import korlibs.memory.ArraysKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u0000 x2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001xB\u0087\u0001\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?J\t\u0010@\u001a\u00020\u0016H\u00c2\u0003J\u0013\u0010A\u001a\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u00c6\u0001J\u001a\u0010B\u001a\u00020\u00162\b\b\u0002\u0010C\u001a\u00020\u00162\b\b\u0002\u0010D\u001a\u00020?J\u001a\u0010E\u001a\u00020\u00162\b\b\u0002\u0010C\u001a\u00020\u00162\b\b\u0002\u0010D\u001a\u00020?J\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020KJ\u0013\u0010L\u001a\u00020K2\b\u0010M\u001a\u0004\u0018\u00010NH\u0096\u0002J\u0019\u0010O\u001a\u00020\u00032\u0006\u0010P\u001a\u00020?2\u0006\u0010>\u001a\u00020?H\u0086\u0002J\u000e\u0010Q\u001a\u00020\u00032\u0006\u0010R\u001a\u00020?J\b\u0010S\u001a\u00020?H\u0016J\u0006\u0010T\u001a\u00020\u0000J\u0018\u0010U\u001a\u00020K2\u0006\u0010M\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u0003H\u0016J\u000e\u0010W\u001a\u00020\u00192\u0006\u0010P\u001a\u00020?J(\u0010X\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020Z2\u0006\u0010\\\u001a\u00020Z\u00f8\u0001\u0000\u00a2\u0006\u0004\b]\u0010^J0\u0010X\u001a\u00020\u00002\u0006\u0010_\u001a\u00020Z2\u0006\u0010Y\u001a\u00020`2\u0006\u0010[\u001a\u00020`2\u0006\u0010\\\u001a\u00020`\u00f8\u0001\u0000\u00a2\u0006\u0004\ba\u0010bJ0\u0010X\u001a\u00020\u00002\u0006\u0010_\u001a\u00020Z2\u0006\u0010Y\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\ba\u0010cJ0\u0010X\u001a\u00020\u00002\u0006\u0010_\u001a\u00020Z2\u0006\u0010Y\u001a\u00020?2\u0006\u0010[\u001a\u00020?2\u0006\u0010\\\u001a\u00020?\u00f8\u0001\u0000\u00a2\u0006\u0004\ba\u0010dJ\u0018\u0010X\u001a\u00020\u00002\u0006\u0010e\u001a\u00020f\u00f8\u0001\u0000\u00a2\u0006\u0004\bg\u0010hJ\u000e\u0010X\u001a\u00020\u00002\u0006\u0010i\u001a\u00020IJ(\u0010j\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020`2\u0006\u0010[\u001a\u00020`2\u0006\u0010\\\u001a\u00020`2\b\b\u0002\u0010k\u001a\u00020`J(\u0010j\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u00032\b\b\u0002\u0010k\u001a\u00020\u0003J(\u0010j\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020?2\u0006\u0010[\u001a\u00020?2\u0006\u0010\\\u001a\u00020?2\b\b\u0002\u0010k\u001a\u00020?J\u0011\u0010l\u001a\u00020\u00002\u0006\u0010m\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010l\u001a\u00020\u00002\u0006\u0010n\u001a\u00020\u0003H\u0086\u0002J\b\u0010o\u001a\u00020pH\u0016J\u0006\u0010q\u001a\u00020GJ\u000e\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020sJ\u000e\u0010r\u001a\u00020\u00192\u0006\u0010t\u001a\u00020\u0019J\u000e\u0010u\u001a\u00020\u00192\u0006\u0010t\u001a\u00020\u0019J(\u0010v\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020`2\u0006\u0010[\u001a\u00020`2\u0006\u0010\\\u001a\u00020`2\b\b\u0002\u0010k\u001a\u00020`J(\u0010v\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\u00032\u0006\u0010\\\u001a\u00020\u00032\b\b\u0002\u0010k\u001a\u00020\u0003J(\u0010v\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020?2\u0006\u0010[\u001a\u00020?2\u0006\u0010\\\u001a\u00020?2\b\b\u0002\u0010k\u001a\u00020?J\u0006\u0010w\u001a\u00020\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001bR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001bR\u0011\u0010'\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001bR\u0011\u0010)\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001bR\u0011\u0010+\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b-\u0010$R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b.\u0010$R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b/\u0010$R\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b0\u0010$R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u0010$R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b2\u0010$R\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b3\u0010$R\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b4\u0010$R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b5\u0010$R\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b6\u0010$R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b7\u0010$R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b8\u0010$R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b9\u0010$R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b:\u0010$R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b;\u0010$R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b<\u0010$\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006y"}, d2={"Lkorlibs/math/geom/Matrix4;", "Lkorlibs/math/IsAlmostEqualsF;", "v00", "", "v10", "v20", "v30", "v01", "v11", "v21", "v31", "v02", "v12", "v22", "v32", "v03", "v13", "v23", "v33", "(FFFFFFFFFFFFFFFF)V", "()V", "data", "", "([F)V", "c0", "Lkorlibs/math/geom/Vector4F;", "getC0", "()Lkorlibs/math/geom/Vector4F;", "c1", "getC1", "c2", "getC2", "c3", "getC3", "determinant", "getDeterminant", "()F", "r0", "getR0", "r1", "getR1", "r2", "getR2", "r3", "getR3", "getV00", "getV01", "getV02", "getV03", "getV10", "getV11", "getV12", "getV13", "getV20", "getV21", "getV22", "getV23", "getV30", "getV31", "getV32", "getV33", "c", "column", "", "component1", "copy", "copyToColumns", "out", "offset", "copyToRows", "decompose", "Lkorlibs/math/geom/TRS4;", "decomposeRotation", "Lkorlibs/math/geom/Quaternion;", "rowNormalise", "", "equals", "other", "", "get", "row", "getAtIndex", "index", "hashCode", "inverted", "isAlmostEquals", "epsilon", "r", "rotated", "x", "Lkorlibs/math/geom/Angle;", "y", "z", "rotated-kZEIK3s", "(DDD)Lkorlibs/math/geom/Matrix4;", "angle", "", "rotated-FE8ZRLo", "(DDDD)Lkorlibs/math/geom/Matrix4;", "(DFFF)Lkorlibs/math/geom/Matrix4;", "(DIII)Lkorlibs/math/geom/Matrix4;", "euler", "Lkorlibs/math/geom/EulerRotation;", "rotated-llqBCb4", "(Lkorlibs/math/geom/Vector4F;)Lkorlibs/math/geom/Matrix4;", "quat", "scaled", "w", "times", "that", "scale", "toString", "", "toTRS", "transform", "Lkorlibs/math/geom/Vector3F;", "v", "transformTransposed", "translated", "transposed", "Companion", "korge-foundation"})
public final class Matrix4
implements IsAlmostEqualsF<Matrix4> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] data;
    public static final int M00 = 0;
    public static final int M10 = 1;
    public static final int M20 = 2;
    public static final int M30 = 3;
    public static final int M01 = 4;
    public static final int M11 = 5;
    public static final int M21 = 6;
    public static final int M31 = 7;
    public static final int M02 = 8;
    public static final int M12 = 9;
    public static final int M22 = 10;
    public static final int M32 = 11;
    public static final int M03 = 12;
    public static final int M13 = 13;
    public static final int M23 = 14;
    public static final int M33 = 15;
    @NotNull
    private static final Matrix4 IDENTITY = new Matrix4();

    private Matrix4(float[] data2) {
        this.data = data2;
        if (!(this.data.length == 16)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public final float getV00() {
        return this.data[0];
    }

    public final float getV10() {
        return this.data[1];
    }

    public final float getV20() {
        return this.data[2];
    }

    public final float getV30() {
        return this.data[3];
    }

    public final float getV01() {
        return this.data[4];
    }

    public final float getV11() {
        return this.data[5];
    }

    public final float getV21() {
        return this.data[6];
    }

    public final float getV31() {
        return this.data[7];
    }

    public final float getV02() {
        return this.data[8];
    }

    public final float getV12() {
        return this.data[9];
    }

    public final float getV22() {
        return this.data[10];
    }

    public final float getV32() {
        return this.data[11];
    }

    public final float getV03() {
        return this.data[12];
    }

    public final float getV13() {
        return this.data[13];
    }

    public final float getV23() {
        return this.data[14];
    }

    public final float getV33() {
        return this.data[15];
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Matrix4 && Arrays.equals(this.data, ((Matrix4)other).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @NotNull
    public final Matrix4 times(float scale) {
        return Companion.fromColumns(this.getC0().times(scale), this.getC1().times(scale), this.getC2().times(scale), this.getC3().times(scale));
    }

    @NotNull
    public final Matrix4 times(@NotNull Matrix4 that) {
        return Companion.multiply(this, that);
    }

    @NotNull
    public final Vector4F transformTransposed(@NotNull Vector4F v) {
        return new Vector4F(this.getC0().dot(v), this.getC1().dot(v), this.getC2().dot(v), this.getC3().dot(v));
    }

    @NotNull
    public final Vector4F transform(@NotNull Vector4F v) {
        return new Vector4F(this.getR0().dot(v), this.getR1().dot(v), this.getR2().dot(v), this.getR3().dot(v));
    }

    @NotNull
    public final Vector3F transform(@NotNull Vector3F v) {
        return this.transform(Vector3F.toVector4$default(v, 0.0f, 1, null)).toVector3();
    }

    @NotNull
    public final Matrix4 transposed() {
        return Companion.fromColumns(this.getR0(), this.getR1(), this.getR2(), this.getR3());
    }

    public final float getDeterminant() {
        return 0.0f + this.getV30() * this.getV21() * this.getV12() * this.getV03() - this.getV20() * this.getV31() * this.getV12() * this.getV03() - this.getV30() * this.getV11() * this.getV22() * this.getV03() + this.getV10() * this.getV31() * this.getV22() * this.getV03() + this.getV20() * this.getV11() * this.getV32() * this.getV03() - this.getV10() * this.getV21() * this.getV32() * this.getV03() - this.getV30() * this.getV21() * this.getV02() * this.getV13() + this.getV20() * this.getV31() * this.getV02() * this.getV13() + this.getV30() * this.getV01() * this.getV22() * this.getV13() - this.getV00() * this.getV31() * this.getV22() * this.getV13() - this.getV20() * this.getV01() * this.getV32() * this.getV13() + this.getV00() * this.getV21() * this.getV32() * this.getV13() + this.getV30() * this.getV11() * this.getV02() * this.getV23() - this.getV10() * this.getV31() * this.getV02() * this.getV23() - this.getV30() * this.getV01() * this.getV12() * this.getV23() + this.getV00() * this.getV31() * this.getV12() * this.getV23() + this.getV10() * this.getV01() * this.getV32() * this.getV23() - this.getV00() * this.getV11() * this.getV32() * this.getV23() - this.getV20() * this.getV11() * this.getV02() * this.getV33() + this.getV10() * this.getV21() * this.getV02() * this.getV33() + this.getV20() * this.getV01() * this.getV12() * this.getV33() - this.getV00() * this.getV21() * this.getV12() * this.getV33() - this.getV10() * this.getV01() * this.getV22() * this.getV33() + this.getV00() * this.getV11() * this.getV22() * this.getV33();
    }

    @NotNull
    public final Quaternion decomposeRotation(boolean rowNormalise) {
        Vector4F v1 = this.getR0();
        Vector4F v2 = this.getR1();
        Vector4F v3 = this.getR2();
        if (rowNormalise) {
            v1 = v1.normalized();
            v2 = v2.normalized();
            v3 = v3.normalized();
        }
        float d = 0.25f * (v1.get(0) + v2.get(1) + v3.get(2) + 1.0f);
        Vector4F out = null;
        if (d > 0.0f) {
            float num1 = (float)Math.sqrt(d);
            float num2 = 1.0f / (4.0f * num1);
            out = new Vector4F((v2.get(2) - v3.get(1)) * num2, (v3.get(0) - v1.get(2)) * num2, (v1.get(1) - v2.get(0)) * num2, num1);
        } else if (v1.get(0) > v2.get(1) && v1.get(0) > v3.get(2)) {
            float num1 = 2.0f * (float)Math.sqrt(1.0f + v1.get(0) - v2.get(1) - v3.get(2));
            float num2 = 1.0f / num1;
            out = new Vector4F(0.25f * num1, (v2.get(0) + v1.get(1)) * num2, (v3.get(0) + v1.get(2)) * num2, (v3.get(1) - v2.get(2)) * num2);
        } else if (v2.get(1) > v3.get(2)) {
            float num5 = 2.0f * (float)Math.sqrt(1.0f + v2.get(1) - v1.get(0) - v3.get(2));
            float num6 = 1.0f / num5;
            out = new Vector4F((v2.get(0) + v1.get(1)) * num6, 0.25f * num5, (v3.get(1) + v2.get(2)) * num6, (v3.get(0) - v1.get(2)) * num6);
        } else {
            float num7 = 2.0f * (float)Math.sqrt(1.0f + v3.get(2) - v1.get(0) - v2.get(1));
            float num8 = 1.0f / num7;
            out = new Vector4F((v3.get(0) + v1.get(2)) * num8, (v3.get(1) + v2.get(2)) * num8, 0.25f * num7, (v2.get(0) - v1.get(1)) * num8);
        }
        return new Quaternion(out.normalized(), null, 2, null);
    }

    public static /* synthetic */ Quaternion decomposeRotation$default(Matrix4 matrix4, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return matrix4.decomposeRotation(bl);
    }

    @NotNull
    public final float[] copyToColumns(@NotNull float[] out, int offset2) {
        ArraysKt.arraycopy(this.data, 0, out, offset2, 16);
        return out;
    }

    public static /* synthetic */ float[] copyToColumns$default(Matrix4 matrix4, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            fArray = new float[16];
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return matrix4.copyToColumns(fArray, n);
    }

    @NotNull
    public final float[] copyToRows(@NotNull float[] out, int offset2) {
        this.getR0().copyTo(out, offset2 + 0);
        this.getR1().copyTo(out, offset2 + 4);
        this.getR2().copyTo(out, offset2 + 8);
        this.getR3().copyTo(out, offset2 + 12);
        return out;
    }

    public static /* synthetic */ float[] copyToRows$default(Matrix4 matrix4, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            fArray = new float[16];
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return matrix4.copyToRows(fArray, n);
    }

    private Matrix4(float v00, float v10, float v20, float v30, float v01, float v11, float v21, float v31, float v02, float v12, float v22, float v32, float v03, float v13, float v23, float v33) {
        float[] fArray = new float[]{v00, v10, v20, v30, v01, v11, v21, v31, v02, v12, v22, v32, v03, v13, v23, v33};
        this(fArray);
    }

    public Matrix4() {
        this(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Vector4F getC0() {
        return Vector4F.Companion.fromArray(this.data, 0);
    }

    @NotNull
    public final Vector4F getC1() {
        return Vector4F.Companion.fromArray(this.data, 4);
    }

    @NotNull
    public final Vector4F getC2() {
        return Vector4F.Companion.fromArray(this.data, 8);
    }

    @NotNull
    public final Vector4F getC3() {
        return Vector4F.Companion.fromArray(this.data, 12);
    }

    @NotNull
    public final Vector4F c(int column) {
        if (column < 0 || column >= 4) {
            throw new IllegalStateException(("Invalid column " + column).toString());
        }
        return Vector4F.Companion.fromArray(this.data, column * 4);
    }

    @NotNull
    public final Vector4F getR0() {
        return new Vector4F(this.getV00(), this.getV01(), this.getV02(), this.getV03());
    }

    @NotNull
    public final Vector4F getR1() {
        return new Vector4F(this.getV10(), this.getV11(), this.getV12(), this.getV13());
    }

    @NotNull
    public final Vector4F getR2() {
        return new Vector4F(this.getV20(), this.getV21(), this.getV22(), this.getV23());
    }

    @NotNull
    public final Vector4F getR3() {
        return new Vector4F(this.getV30(), this.getV31(), this.getV32(), this.getV33());
    }

    @NotNull
    public final Vector4F r(int row) {
        Vector4F vector4F;
        switch (row) {
            case 0: {
                vector4F = this.getR0();
                break;
            }
            case 1: {
                vector4F = this.getR1();
                break;
            }
            case 2: {
                vector4F = this.getR2();
                break;
            }
            case 3: {
                vector4F = this.getR3();
                break;
            }
            default: {
                throw new IllegalStateException(("Invalid row " + row).toString());
            }
        }
        return vector4F;
    }

    public final float get(int row, int column) {
        block4: {
            block3: {
                boolean bl = 0 <= column ? column < 4 : false;
                if (!bl) break block3;
                if (0 <= row ? row < 4 : false) break block4;
            }
            throw new IllegalStateException(("Invalid index " + row + "," + column).toString());
        }
        return this.data[row * 4 + column];
    }

    public final float getAtIndex(int index2) {
        if (!(0 <= index2 ? index2 < this.data.length : false)) {
            throw new IllegalStateException(("Invalid index " + index2).toString());
        }
        return this.data[index2];
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("Matrix4(\n");
        for (int row = 0; row < 4; ++row) {
            $this$toString_u24lambda_u240.append("  [ ");
            for (int col = 0; col < 4; ++col) {
                float v;
                if (col != 0) {
                    $this$toString_u24lambda_u240.append(", ");
                }
                if ((float)Math.floor(v = this.get(row, col)) == v) {
                    $this$toString_u24lambda_u240.append((int)v);
                    continue;
                }
                $this$toString_u24lambda_u240.append(v);
            }
            $this$toString_u24lambda_u240.append(" ],\n");
        }
        $this$toString_u24lambda_u240.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final Matrix4 translated(float x, float y, float z, float w) {
        return this.times(Companion.translation(x, y, z, w));
    }

    public static /* synthetic */ Matrix4 translated$default(Matrix4 matrix4, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        return matrix4.translated(f, f2, f3, f4);
    }

    @NotNull
    public final Matrix4 translated(double x, double y, double z, double w) {
        return this.translated((float)x, (float)y, (float)z, (float)w);
    }

    public static /* synthetic */ Matrix4 translated$default(Matrix4 matrix4, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        return matrix4.translated(d, d2, d3, d4);
    }

    @NotNull
    public final Matrix4 translated(int x, int y, int z, int w) {
        return this.translated((float)x, (float)y, (float)z, (float)w);
    }

    public static /* synthetic */ Matrix4 translated$default(Matrix4 matrix4, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 1;
        }
        return matrix4.translated(n, n2, n3, n4);
    }

    @NotNull
    public final Matrix4 rotated-FE8ZRLo(double angle, float x, float y, float z) {
        return this.times(Companion.rotation-FE8ZRLo(angle, x, y, z));
    }

    @NotNull
    public final Matrix4 rotated-FE8ZRLo(double angle, double x, double y, double z) {
        return this.rotated-FE8ZRLo(angle, (float)x, (float)y, (float)z);
    }

    @NotNull
    public final Matrix4 rotated-FE8ZRLo(double angle, int x, int y, int z) {
        return this.rotated-FE8ZRLo(angle, (float)x, (float)y, (float)z);
    }

    @NotNull
    public final Matrix4 scaled(float x, float y, float z, float w) {
        return this.times(Companion.scale(x, y, z, w));
    }

    public static /* synthetic */ Matrix4 scaled$default(Matrix4 matrix4, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        return matrix4.scaled(f, f2, f3, f4);
    }

    @NotNull
    public final Matrix4 scaled(double x, double y, double z, double w) {
        return this.scaled((float)x, (float)y, (float)z, (float)w);
    }

    public static /* synthetic */ Matrix4 scaled$default(Matrix4 matrix4, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        return matrix4.scaled(d, d2, d3, d4);
    }

    @NotNull
    public final Matrix4 scaled(int x, int y, int z, int w) {
        return this.scaled((float)x, (float)y, (float)z, (float)w);
    }

    public static /* synthetic */ Matrix4 scaled$default(Matrix4 matrix4, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 1;
        }
        return matrix4.scaled(n, n2, n3, n4);
    }

    @NotNull
    public final Matrix4 rotated(@NotNull Quaternion quat) {
        return this.times(quat.toMatrix());
    }

    @NotNull
    public final Matrix4 rotated-llqBCb4(@NotNull Vector4F euler) {
        return this.times(EulerRotation.toMatrix-impl(euler));
    }

    @NotNull
    public final Matrix4 rotated-kZEIK3s(double x, double y, double z) {
        return this.rotated-FE8ZRLo(x, 1.0f, 0.0f, 0.0f).rotated-FE8ZRLo(y, 0.0f, 1.0f, 0.0f).rotated-FE8ZRLo(z, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final TRS4 decompose() {
        return this.toTRS();
    }

    @NotNull
    public final TRS4 toTRS() {
        float det = this.getDeterminant();
        Vector4F translation = new Vector4F(this.getV03(), this.getV13(), this.getV23(), 1.0f);
        Vector4F scale = new Vector4F(Vector3F.Companion.length(this.getV00(), this.getV10(), this.getV20()) * Math.signum(det), Vector3F.Companion.length(this.getV01(), this.getV11(), this.getV21()), Vector3F.Companion.length(this.getV02(), this.getV12(), this.getV22()), 1.0f);
        float invSX = 1.0f / scale.getX();
        float invSY = 1.0f / scale.getY();
        float invSZ = 1.0f / scale.getZ();
        Quaternion rotation = Quaternion.Companion.fromRotationMatrix(Companion.fromRows(this.getV00() * invSX, this.getV01() * invSY, this.getV02() * invSZ, this.getV03(), this.getV10() * invSX, this.getV11() * invSY, this.getV12() * invSZ, this.getV13(), this.getV20() * invSX, this.getV21() * invSY, this.getV22() * invSZ, this.getV23(), this.getV30(), this.getV31(), this.getV32(), this.getV33()));
        return new TRS4(translation, rotation, scale);
    }

    @NotNull
    public final Matrix4 inverted() {
        float t11 = this.getV12() * this.getV23() * this.getV31() - this.getV13() * this.getV22() * this.getV31() + this.getV13() * this.getV21() * this.getV32() - this.getV11() * this.getV23() * this.getV32() - this.getV12() * this.getV21() * this.getV33() + this.getV11() * this.getV22() * this.getV33();
        float t12 = this.getV03() * this.getV22() * this.getV31() - this.getV02() * this.getV23() * this.getV31() - this.getV03() * this.getV21() * this.getV32() + this.getV01() * this.getV23() * this.getV32() + this.getV02() * this.getV21() * this.getV33() - this.getV01() * this.getV22() * this.getV33();
        float t13 = this.getV02() * this.getV13() * this.getV31() - this.getV03() * this.getV12() * this.getV31() + this.getV03() * this.getV11() * this.getV32() - this.getV01() * this.getV13() * this.getV32() - this.getV02() * this.getV11() * this.getV33() + this.getV01() * this.getV12() * this.getV33();
        float t14 = this.getV03() * this.getV12() * this.getV21() - this.getV02() * this.getV13() * this.getV21() - this.getV03() * this.getV11() * this.getV22() + this.getV01() * this.getV13() * this.getV22() + this.getV02() * this.getV11() * this.getV23() - this.getV01() * this.getV12() * this.getV23();
        float det = this.getV00() * t11 + this.getV10() * t12 + this.getV20() * t13 + this.getV30() * t14;
        if (det == 0.0f) {
            System.out.println((Object)"Matrix doesn't have inverse");
            return IDENTITY;
        }
        float detInv = 1.0f / det;
        return Companion.fromRows(t11 * detInv, t12 * detInv, t13 * detInv, t14 * detInv, (this.getV13() * this.getV22() * this.getV30() - this.getV12() * this.getV23() * this.getV30() - this.getV13() * this.getV20() * this.getV32() + this.getV10() * this.getV23() * this.getV32() + this.getV12() * this.getV20() * this.getV33() - this.getV10() * this.getV22() * this.getV33()) * detInv, (this.getV02() * this.getV23() * this.getV30() - this.getV03() * this.getV22() * this.getV30() + this.getV03() * this.getV20() * this.getV32() - this.getV00() * this.getV23() * this.getV32() - this.getV02() * this.getV20() * this.getV33() + this.getV00() * this.getV22() * this.getV33()) * detInv, (this.getV03() * this.getV12() * this.getV30() - this.getV02() * this.getV13() * this.getV30() - this.getV03() * this.getV10() * this.getV32() + this.getV00() * this.getV13() * this.getV32() + this.getV02() * this.getV10() * this.getV33() - this.getV00() * this.getV12() * this.getV33()) * detInv, (this.getV02() * this.getV13() * this.getV20() - this.getV03() * this.getV12() * this.getV20() + this.getV03() * this.getV10() * this.getV22() - this.getV00() * this.getV13() * this.getV22() - this.getV02() * this.getV10() * this.getV23() + this.getV00() * this.getV12() * this.getV23()) * detInv, (this.getV11() * this.getV23() * this.getV30() - this.getV13() * this.getV21() * this.getV30() + this.getV13() * this.getV20() * this.getV31() - this.getV10() * this.getV23() * this.getV31() - this.getV11() * this.getV20() * this.getV33() + this.getV10() * this.getV21() * this.getV33()) * detInv, (this.getV03() * this.getV21() * this.getV30() - this.getV01() * this.getV23() * this.getV30() - this.getV03() * this.getV20() * this.getV31() + this.getV00() * this.getV23() * this.getV31() + this.getV01() * this.getV20() * this.getV33() - this.getV00() * this.getV21() * this.getV33()) * detInv, (this.getV01() * this.getV13() * this.getV30() - this.getV03() * this.getV11() * this.getV30() + this.getV03() * this.getV10() * this.getV31() - this.getV00() * this.getV13() * this.getV31() - this.getV01() * this.getV10() * this.getV33() + this.getV00() * this.getV11() * this.getV33()) * detInv, (this.getV03() * this.getV11() * this.getV20() - this.getV01() * this.getV13() * this.getV20() - this.getV03() * this.getV10() * this.getV21() + this.getV00() * this.getV13() * this.getV21() + this.getV01() * this.getV10() * this.getV23() - this.getV00() * this.getV11() * this.getV23()) * detInv, (this.getV12() * this.getV21() * this.getV30() - this.getV11() * this.getV22() * this.getV30() - this.getV12() * this.getV20() * this.getV31() + this.getV10() * this.getV22() * this.getV31() + this.getV11() * this.getV20() * this.getV32() - this.getV10() * this.getV21() * this.getV32()) * detInv, (this.getV01() * this.getV22() * this.getV30() - this.getV02() * this.getV21() * this.getV30() + this.getV02() * this.getV20() * this.getV31() - this.getV00() * this.getV22() * this.getV31() - this.getV01() * this.getV20() * this.getV32() + this.getV00() * this.getV21() * this.getV32()) * detInv, (this.getV02() * this.getV11() * this.getV30() - this.getV01() * this.getV12() * this.getV30() - this.getV02() * this.getV10() * this.getV31() + this.getV00() * this.getV12() * this.getV31() + this.getV01() * this.getV10() * this.getV32() - this.getV00() * this.getV11() * this.getV32()) * detInv, (this.getV01() * this.getV12() * this.getV20() - this.getV02() * this.getV11() * this.getV20() + this.getV02() * this.getV10() * this.getV21() - this.getV00() * this.getV12() * this.getV21() - this.getV01() * this.getV10() * this.getV22() + this.getV00() * this.getV11() * this.getV22()) * detInv);
    }

    @Override
    public boolean isAlmostEquals(@NotNull Matrix4 other, float epsilon) {
        return this.getC0().isAlmostEquals(other.getC0(), epsilon) && this.getC1().isAlmostEquals(other.getC1(), epsilon) && this.getC2().isAlmostEquals(other.getC2(), epsilon) && this.getC3().isAlmostEquals(other.getC3(), epsilon);
    }

    private final float[] component1() {
        return this.data;
    }

    @NotNull
    public final Matrix4 copy(@NotNull float[] data2) {
        return new Matrix4(data2);
    }

    public static /* synthetic */ Matrix4 copy$default(Matrix4 matrix4, float[] fArray, int n, Object object) {
        if ((n & 1) != 0) {
            fArray = matrix4.data;
        }
        return matrix4.copy(fArray);
    }

    public /* synthetic */ Matrix4(float v00, float v10, float v20, float v30, float v01, float v11, float v21, float v31, float v02, float v12, float v22, float v32, float v03, float v13, float v23, float v33, DefaultConstructorMarker $constructor_marker) {
        this(v00, v10, v20, v30, v01, v11, v21, v31, v02, v12, v22, v32, v03, v13, v23, v33);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0014\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$J\u0086\u0001\u0010\"\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020)J\u0018\u0010\"\u001a\u00020\u00042\u0006\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020\u0012JN\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020)2\u0006\u0010C\u001a\u00020)2\u0006\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020)J&\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020$2\u0006\u0010J\u001a\u00020$J\u0086\u0001\u0010F\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020)2\u0006\u00101\u001a\u00020)2\u0006\u00105\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010.\u001a\u00020)2\u0006\u00102\u001a\u00020)2\u0006\u00106\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010/\u001a\u00020)2\u0006\u00103\u001a\u00020)2\u0006\u00107\u001a\u00020)2\u0006\u0010,\u001a\u00020)2\u0006\u00100\u001a\u00020)2\u0006\u00104\u001a\u00020)2\u0006\u00108\u001a\u00020)J\u0018\u0010F\u001a\u00020\u00042\u0006\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020\u0012JN\u0010K\u001a\u00020\u00042\u0006\u0010=\u001a\u00020)2\u0006\u0010@\u001a\u00020)2\u0006\u0010C\u001a\u00020)2\u0006\u0010>\u001a\u00020)2\u0006\u0010A\u001a\u00020)2\u0006\u0010D\u001a\u00020)2\u0006\u0010?\u001a\u00020)2\u0006\u0010B\u001a\u00020)2\u0006\u0010E\u001a\u00020)J\u000e\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020NJ\u001e\u0010L\u001a\u00020\u00042\u0006\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020$J&\u0010S\u001a\u00020\u00042\n\u0010T\u001a\u00060Uj\u0002`V2\b\b\u0002\u0010W\u001a\u00020X2\b\b\u0002\u0010Y\u001a\u00020XJ&\u0010S\u001a\u00020\u00042\n\u0010T\u001a\u00060Uj\u0002`V2\b\b\u0002\u0010W\u001a\u00020)2\b\b\u0002\u0010Y\u001a\u00020)J&\u0010S\u001a\u00020\u00042\n\u0010T\u001a\u00060Uj\u0002`V2\b\b\u0002\u0010W\u001a\u00020\u00122\b\b\u0002\u0010Y\u001a\u00020\u0012J:\u0010S\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020X2\u0006\u0010[\u001a\u00020X2\u0006\u0010\\\u001a\u00020X2\u0006\u0010]\u001a\u00020X2\b\b\u0002\u0010W\u001a\u00020X2\b\b\u0002\u0010Y\u001a\u00020XJ:\u0010S\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020)2\u0006\u0010[\u001a\u00020)2\u0006\u0010\\\u001a\u00020)2\u0006\u0010]\u001a\u00020)2\b\b\u0002\u0010W\u001a\u00020)2\b\b\u0002\u0010Y\u001a\u00020)J:\u0010S\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\u00122\u0006\u0010\\\u001a\u00020\u00122\u0006\u0010]\u001a\u00020\u00122\b\b\u0002\u0010W\u001a\u00020\u00122\b\b\u0002\u0010Y\u001a\u00020\u0012J\u001e\u0010^\u001a\u00020\u00042\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`2\u0006\u0010b\u001a\u00020`J\u0016\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u0004J\u008c\u0002\u0010c\u001a\u00020\u00042\u0006\u0010f\u001a\u00020)2\u0006\u0010g\u001a\u00020)2\u0006\u0010h\u001a\u00020)2\u0006\u0010i\u001a\u00020)2\u0006\u0010j\u001a\u00020)2\u0006\u0010k\u001a\u00020)2\u0006\u0010l\u001a\u00020)2\u0006\u0010m\u001a\u00020)2\u0006\u0010n\u001a\u00020)2\u0006\u0010o\u001a\u00020)2\u0006\u0010p\u001a\u00020)2\u0006\u0010q\u001a\u00020)2\u0006\u0010r\u001a\u00020)2\u0006\u0010s\u001a\u00020)2\u0006\u0010t\u001a\u00020)2\u0006\u0010u\u001a\u00020)2\u0006\u0010v\u001a\u00020)2\u0006\u0010w\u001a\u00020)2\u0006\u0010x\u001a\u00020)2\u0006\u0010y\u001a\u00020)2\u0006\u0010z\u001a\u00020)2\u0006\u0010{\u001a\u00020)2\u0006\u0010|\u001a\u00020)2\u0006\u0010}\u001a\u00020)2\u0006\u0010~\u001a\u00020)2\u0006\u0010\u007f\u001a\u00020)2\u0007\u0010\u0080\u0001\u001a\u00020)2\u0007\u0010\u0081\u0001\u001a\u00020)2\u0007\u0010\u0082\u0001\u001a\u00020)2\u0007\u0010\u0083\u0001\u001a\u00020)2\u0007\u0010\u0084\u0001\u001a\u00020)2\u0007\u0010\u0085\u0001\u001a\u00020)J)\u0010\u0086\u0001\u001a\u00020\u00042\n\u0010T\u001a\u00060Uj\u0002`V2\t\b\u0002\u0010\u0087\u0001\u001a\u00020X2\t\b\u0002\u0010\u0088\u0001\u001a\u00020XJ)\u0010\u0086\u0001\u001a\u00020\u00042\n\u0010T\u001a\u00060Uj\u0002`V2\t\b\u0002\u0010\u0087\u0001\u001a\u00020)2\t\b\u0002\u0010\u0088\u0001\u001a\u00020)J)\u0010\u0086\u0001\u001a\u00020\u00042\n\u0010T\u001a\u00060Uj\u0002`V2\t\b\u0002\u0010\u0087\u0001\u001a\u00020\u00122\t\b\u0002\u0010\u0088\u0001\u001a\u00020\u0012J9\u0010\u0086\u0001\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020X2\u0006\u0010[\u001a\u00020X2\u0006\u0010\\\u001a\u00020X2\u0006\u0010]\u001a\u00020X2\u0007\u0010\u0087\u0001\u001a\u00020X2\u0007\u0010\u0088\u0001\u001a\u00020XJ=\u0010\u0086\u0001\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020)2\u0006\u0010[\u001a\u00020)2\u0006\u0010\\\u001a\u00020)2\u0006\u0010]\u001a\u00020)2\t\b\u0002\u0010\u0087\u0001\u001a\u00020)2\t\b\u0002\u0010\u0088\u0001\u001a\u00020)J9\u0010\u0086\u0001\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020\u00122\u0006\u0010[\u001a\u00020\u00122\u0006\u0010\\\u001a\u00020\u00122\u0006\u0010]\u001a\u00020\u00122\u0007\u0010\u0087\u0001\u001a\u00020\u00122\u0007\u0010\u0088\u0001\u001a\u00020\u0012J6\u0010\u0089\u0001\u001a\u00020\u00042\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020X2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020X\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u008d\u0001\u0010\u008e\u0001J6\u0010\u0089\u0001\u001a\u00020\u00042\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020)2\u0006\u0010W\u001a\u00020)2\u0006\u0010Y\u001a\u00020)\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u008d\u0001\u0010\u008f\u0001J%\u0010P\u001a\u00020\u00042\b\u0010\u0090\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u0091\u0001\u001a\u00020`\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J7\u0010P\u001a\u00020\u00042\b\u0010\u0090\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u0094\u0001\u001a\u00020X2\u0007\u0010\u0095\u0001\u001a\u00020X2\u0007\u0010\u0096\u0001\u001a\u00020X\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0097\u0001\u0010\u008e\u0001J7\u0010P\u001a\u00020\u00042\b\u0010\u0090\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u0094\u0001\u001a\u00020)2\u0007\u0010\u0095\u0001\u001a\u00020)2\u0007\u0010\u0096\u0001\u001a\u00020)\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0097\u0001\u0010\u008f\u0001J7\u0010P\u001a\u00020\u00042\b\u0010\u0090\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u0094\u0001\u001a\u00020\u00122\u0007\u0010\u0095\u0001\u001a\u00020\u00122\u0007\u0010\u0096\u0001\u001a\u00020\u0012\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0097\u0001\u0010\u0098\u0001J\u001d\u0010\u0099\u0001\u001a\u00020\u00042\b\u0010\u0090\u0001\u001a\u00030\u008b\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009a\u0001\u0010\u009b\u0001J\u001d\u0010\u009c\u0001\u001a\u00020\u00042\b\u0010\u0090\u0001\u001a\u00030\u008b\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009d\u0001\u0010\u009b\u0001J\u001d\u0010\u009e\u0001\u001a\u00020\u00042\b\u0010\u0090\u0001\u001a\u00030\u008b\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009f\u0001\u0010\u009b\u0001J,\u0010R\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020X2\u0007\u0010\u0095\u0001\u001a\u00020X2\u0007\u0010\u0096\u0001\u001a\u00020X2\t\b\u0002\u0010\u00a0\u0001\u001a\u00020XJ,\u0010R\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020)2\u0007\u0010\u0095\u0001\u001a\u00020)2\u0007\u0010\u0096\u0001\u001a\u00020)2\t\b\u0002\u0010\u00a0\u0001\u001a\u00020)J,\u0010R\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020\u00122\u0007\u0010\u0095\u0001\u001a\u00020\u00122\u0007\u0010\u0096\u0001\u001a\u00020\u00122\t\b\u0002\u0010\u00a0\u0001\u001a\u00020\u0012J\"\u0010\u00a1\u0001\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020X2\u0007\u0010\u0095\u0001\u001a\u00020X2\u0007\u0010\u0096\u0001\u001a\u00020XJ\"\u0010\u00a1\u0001\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020)2\u0007\u0010\u0095\u0001\u001a\u00020)2\u0007\u0010\u0096\u0001\u001a\u00020)J\"\u0010\u00a1\u0001\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020\u00122\u0007\u0010\u0095\u0001\u001a\u00020\u00122\u0007\u0010\u0096\u0001\u001a\u00020\u0012J,\u0010O\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020X2\u0007\u0010\u0095\u0001\u001a\u00020X2\u0007\u0010\u0096\u0001\u001a\u00020X2\t\b\u0002\u0010\u00a0\u0001\u001a\u00020XJ,\u0010O\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020)2\u0007\u0010\u0095\u0001\u001a\u00020)2\u0007\u0010\u0096\u0001\u001a\u00020)2\t\b\u0002\u0010\u00a0\u0001\u001a\u00020)J,\u0010O\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020\u00122\u0007\u0010\u0095\u0001\u001a\u00020\u00122\u0007\u0010\u0096\u0001\u001a\u00020\u00122\t\b\u0002\u0010\u00a0\u0001\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u00a2\u0001"}, d2={"Lkorlibs/math/geom/Matrix4$Companion;", "", "()V", "IDENTITY", "Lkorlibs/math/geom/Matrix4;", "getIDENTITY", "()Lkorlibs/math/geom/Matrix4;", "INDICES_BY_COLUMNS_3x3", "", "getINDICES_BY_COLUMNS_3x3", "()[I", "INDICES_BY_COLUMNS_4x4", "getINDICES_BY_COLUMNS_4x4", "INDICES_BY_ROWS_3x3", "getINDICES_BY_ROWS_3x3", "INDICES_BY_ROWS_4x4", "getINDICES_BY_ROWS_4x4", "M00", "", "M01", "M02", "M03", "M10", "M11", "M12", "M13", "M20", "M21", "M22", "M23", "M30", "M31", "M32", "M33", "fromColumns", "c0", "Lkorlibs/math/geom/Vector4F;", "c1", "c2", "c3", "v00", "", "v10", "v20", "v30", "v01", "v11", "v21", "v31", "v02", "v12", "v22", "v32", "v03", "v13", "v23", "v33", "v", "", "offset", "fromColumns3x3", "a00", "a10", "a20", "a01", "a11", "a21", "a02", "a12", "a22", "fromRows", "r0", "r1", "r2", "r3", "fromRows3x3", "fromTRS", "trs", "Lkorlibs/math/geom/TRS4;", "translation", "rotation", "Lkorlibs/math/geom/Quaternion;", "scale", "frustum", "rect", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "zNear", "", "zFar", "left", "right", "bottom", "top", "lookAt", "eye", "Lkorlibs/math/geom/Vector3F;", "target", "up", "multiply", "l", "r", "lv00", "lv01", "lv02", "lv03", "lv10", "lv11", "lv12", "lv13", "lv20", "lv21", "lv22", "lv23", "lv30", "lv31", "lv32", "lv33", "rv00", "rv01", "rv02", "rv03", "rv10", "rv11", "rv12", "rv13", "rv20", "rv21", "rv22", "rv23", "rv30", "rv31", "rv32", "rv33", "ortho", "near", "far", "perspective", "fovy", "Lkorlibs/math/geom/Angle;", "aspect", "perspective-FE8ZRLo", "(DDDD)Lkorlibs/math/geom/Matrix4;", "(DFFF)Lkorlibs/math/geom/Matrix4;", "angle", "direction", "rotation-2FdH_oo", "(DLkorlibs/math/geom/Vector3F;)Lkorlibs/math/geom/Matrix4;", "x", "y", "z", "rotation-FE8ZRLo", "(DIII)Lkorlibs/math/geom/Matrix4;", "rotationX", "rotationX-Mi4kPw4", "(D)Lkorlibs/math/geom/Matrix4;", "rotationY", "rotationY-Mi4kPw4", "rotationZ", "rotationZ-Mi4kPw4", "w", "shear", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getINDICES_BY_COLUMNS_4x4() {
            return MMatrix4.Companion.getINDICES_BY_COLUMNS_4x4();
        }

        @NotNull
        public final int[] getINDICES_BY_ROWS_4x4() {
            return MMatrix4.Companion.getINDICES_BY_ROWS_4x4();
        }

        @NotNull
        public final int[] getINDICES_BY_COLUMNS_3x3() {
            return MMatrix4.Companion.getINDICES_BY_COLUMNS_3x3();
        }

        @NotNull
        public final int[] getINDICES_BY_ROWS_3x3() {
            return MMatrix4.Companion.getINDICES_BY_ROWS_3x3();
        }

        @NotNull
        public final Matrix4 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix4 fromColumns(@NotNull Vector4F c0, @NotNull Vector4F c1, @NotNull Vector4F c2, @NotNull Vector4F c3) {
            return new Matrix4(c0.getX(), c0.getY(), c0.getZ(), c0.getW(), c1.getX(), c1.getY(), c1.getZ(), c1.getW(), c2.getX(), c2.getY(), c2.getZ(), c2.getW(), c3.getX(), c3.getY(), c3.getZ(), c3.getW(), null);
        }

        @NotNull
        public final Matrix4 fromColumns(@NotNull float[] v, int offset2) {
            return Companion.fromColumns(v[offset2 + 0], v[offset2 + 1], v[offset2 + 2], v[offset2 + 3], v[offset2 + 4], v[offset2 + 5], v[offset2 + 6], v[offset2 + 7], v[offset2 + 8], v[offset2 + 9], v[offset2 + 10], v[offset2 + 11], v[offset2 + 12], v[offset2 + 13], v[offset2 + 14], v[offset2 + 15]);
        }

        public static /* synthetic */ Matrix4 fromColumns$default(Companion companion, float[] fArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromColumns(fArray, n);
        }

        @NotNull
        public final Matrix4 fromRows(@NotNull float[] v, int offset2) {
            return Companion.fromRows(v[offset2 + 0], v[offset2 + 1], v[offset2 + 2], v[offset2 + 3], v[offset2 + 4], v[offset2 + 5], v[offset2 + 6], v[offset2 + 7], v[offset2 + 8], v[offset2 + 9], v[offset2 + 10], v[offset2 + 11], v[offset2 + 12], v[offset2 + 13], v[offset2 + 14], v[offset2 + 15]);
        }

        public static /* synthetic */ Matrix4 fromRows$default(Companion companion, float[] fArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromRows(fArray, n);
        }

        @NotNull
        public final Matrix4 fromRows(@NotNull Vector4F r0, @NotNull Vector4F r1, @NotNull Vector4F r2, @NotNull Vector4F r3) {
            return new Matrix4(r0.getX(), r1.getX(), r2.getX(), r3.getX(), r0.getY(), r1.getY(), r2.getY(), r3.getY(), r0.getZ(), r1.getZ(), r2.getZ(), r3.getZ(), r0.getW(), r1.getW(), r2.getW(), r3.getW(), null);
        }

        @NotNull
        public final Matrix4 fromColumns(float v00, float v10, float v20, float v30, float v01, float v11, float v21, float v31, float v02, float v12, float v22, float v32, float v03, float v13, float v23, float v33) {
            return new Matrix4(v00, v10, v20, v30, v01, v11, v21, v31, v02, v12, v22, v32, v03, v13, v23, v33, null);
        }

        @NotNull
        public final Matrix4 fromRows(float v00, float v01, float v02, float v03, float v10, float v11, float v12, float v13, float v20, float v21, float v22, float v23, float v30, float v31, float v32, float v33) {
            return new Matrix4(v00, v10, v20, v30, v01, v11, v21, v31, v02, v12, v22, v32, v03, v13, v23, v33, null);
        }

        @NotNull
        public final Matrix4 fromRows3x3(float a00, float a01, float a02, float a10, float a11, float a12, float a20, float a21, float a22) {
            return Companion.fromRows(a00, a01, a02, 0.0f, a10, a11, a12, 0.0f, a20, a21, a22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 fromColumns3x3(float a00, float a10, float a20, float a01, float a11, float a21, float a02, float a12, float a22) {
            return Companion.fromColumns(a00, a10, a20, 0.0f, a01, a11, a21, 0.0f, a02, a12, a22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 fromTRS(@NotNull TRS4 trs) {
            return this.fromTRS(trs.getTranslation(), trs.getRotation(), trs.getScale());
        }

        @NotNull
        public final Matrix4 fromTRS(@NotNull Vector4F translation, @NotNull Quaternion rotation, @NotNull Vector4F scale) {
            float rx = rotation.getX();
            float ry = rotation.getY();
            float rz = rotation.getZ();
            float rw = rotation.getW();
            float xt = rx + rx;
            float yt = ry + ry;
            float zt = rz + rz;
            float xx = rx * xt;
            float xy = rx * yt;
            float xz = rx * zt;
            float yy = ry * yt;
            float yz = ry * zt;
            float zz = rz * zt;
            float wx = rw * xt;
            float wy = rw * yt;
            float wz = rw * zt;
            return Companion.fromRows((1.0f - (yy + zz)) * scale.getX(), (xy - wz) * scale.getY(), (xz + wy) * scale.getZ(), translation.getX(), (xy + wz) * scale.getX(), (1.0f - (xx + zz)) * scale.getY(), (yz - wx) * scale.getZ(), translation.getY(), (xz - wy) * scale.getX(), (yz + wx) * scale.getY(), (1.0f - (xx + yy)) * scale.getZ(), translation.getZ(), 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 translation(float x, float y, float z, float w) {
            return Companion.fromRows(1.0f, 0.0f, 0.0f, x, 0.0f, 1.0f, 0.0f, y, 0.0f, 0.0f, 1.0f, z, 0.0f, 0.0f, 0.0f, w);
        }

        public static /* synthetic */ Matrix4 translation$default(Companion companion, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 8) != 0) {
                f4 = 1.0f;
            }
            return companion.translation(f, f2, f3, f4);
        }

        @NotNull
        public final Matrix4 translation(double x, double y, double z, double w) {
            return this.translation((float)x, (float)y, (float)z, (float)w);
        }

        public static /* synthetic */ Matrix4 translation$default(Companion companion, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 8) != 0) {
                d4 = 1.0;
            }
            return companion.translation(d, d2, d3, d4);
        }

        @NotNull
        public final Matrix4 translation(int x, int y, int z, int w) {
            return this.translation((float)x, (float)y, (float)z, (float)w);
        }

        public static /* synthetic */ Matrix4 translation$default(Companion companion, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 8) != 0) {
                n4 = 1;
            }
            return companion.translation(n, n2, n3, n4);
        }

        @NotNull
        public final Matrix4 scale(float x, float y, float z, float w) {
            return Companion.fromRows(x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, w);
        }

        public static /* synthetic */ Matrix4 scale$default(Companion companion, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 8) != 0) {
                f4 = 1.0f;
            }
            return companion.scale(f, f2, f3, f4);
        }

        @NotNull
        public final Matrix4 scale(double x, double y, double z, double w) {
            return this.scale((float)x, (float)y, (float)z, (float)w);
        }

        public static /* synthetic */ Matrix4 scale$default(Companion companion, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 8) != 0) {
                d4 = 1.0;
            }
            return companion.scale(d, d2, d3, d4);
        }

        @NotNull
        public final Matrix4 scale(int x, int y, int z, int w) {
            return this.scale((float)x, (float)y, (float)z, (float)w);
        }

        public static /* synthetic */ Matrix4 scale$default(Companion companion, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 8) != 0) {
                n4 = 1;
            }
            return companion.scale(n, n2, n3, n4);
        }

        @NotNull
        public final Matrix4 shear(float x, float y, float z) {
            return this.fromRows(1.0f, y, z, 0.0f, x, 1.0f, z, 0.0f, x, y, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 shear(double x, double y, double z) {
            return this.shear((float)x, (float)y, (float)z);
        }

        @NotNull
        public final Matrix4 shear(int x, int y, int z) {
            return this.shear((float)x, (float)y, (float)z);
        }

        @NotNull
        public final Matrix4 rotationX-Mi4kPw4(double angle) {
            float c = (float)Angle.getCosine-impl(angle);
            float s = (float)Angle.getSine-impl(angle);
            return Companion.fromRows(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 rotationY-Mi4kPw4(double angle) {
            float c = (float)Angle.getCosine-impl(angle);
            float s = (float)Angle.getSine-impl(angle);
            return Companion.fromRows(c, 0.0f, s, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -s, 0.0f, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 rotationZ-Mi4kPw4(double angle) {
            float c = (float)Angle.getCosine-impl(angle);
            float s = (float)Angle.getSine-impl(angle);
            return Companion.fromRows(c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 rotation-FE8ZRLo(double angle, float x, float y, float z) {
            float mag = (float)Math.sqrt(x * x + y * y + z * z);
            float norm = 1.0f / mag;
            float nx = x * norm;
            float ny = y * norm;
            float nz = z * norm;
            float c = (float)Angle.getCosine-impl(angle);
            float s = (float)Angle.getSine-impl(angle);
            float t = 1.0f - c;
            float tx = t * nx;
            float ty = t * ny;
            return Companion.fromRows(tx * nx + c, tx * ny - s * nz, tx * nz + s * ny, 0.0f, tx * ny + s * nz, ty * ny + c, ty * nz - s * nx, 0.0f, tx * nz - s * ny, ty * nz + s * nx, t * nz * nz + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        @NotNull
        public final Matrix4 rotation-2FdH_oo(double angle, @NotNull Vector3F direction2) {
            return this.rotation-FE8ZRLo(angle, direction2.getX(), direction2.getY(), direction2.getZ());
        }

        @NotNull
        public final Matrix4 rotation-FE8ZRLo(double angle, double x, double y, double z) {
            return this.rotation-FE8ZRLo(angle, (float)x, (float)y, (float)z);
        }

        @NotNull
        public final Matrix4 rotation-FE8ZRLo(double angle, int x, int y, int z) {
            return this.rotation-FE8ZRLo(angle, (float)x, (float)y, (float)z);
        }

        @NotNull
        public final Matrix4 multiply(@NotNull Matrix4 l, @NotNull Matrix4 r) {
            return Companion.fromRows(l.getV00() * r.getV00() + l.getV01() * r.getV10() + l.getV02() * r.getV20() + l.getV03() * r.getV30(), l.getV00() * r.getV01() + l.getV01() * r.getV11() + l.getV02() * r.getV21() + l.getV03() * r.getV31(), l.getV00() * r.getV02() + l.getV01() * r.getV12() + l.getV02() * r.getV22() + l.getV03() * r.getV32(), l.getV00() * r.getV03() + l.getV01() * r.getV13() + l.getV02() * r.getV23() + l.getV03() * r.getV33(), l.getV10() * r.getV00() + l.getV11() * r.getV10() + l.getV12() * r.getV20() + l.getV13() * r.getV30(), l.getV10() * r.getV01() + l.getV11() * r.getV11() + l.getV12() * r.getV21() + l.getV13() * r.getV31(), l.getV10() * r.getV02() + l.getV11() * r.getV12() + l.getV12() * r.getV22() + l.getV13() * r.getV32(), l.getV10() * r.getV03() + l.getV11() * r.getV13() + l.getV12() * r.getV23() + l.getV13() * r.getV33(), l.getV20() * r.getV00() + l.getV21() * r.getV10() + l.getV22() * r.getV20() + l.getV23() * r.getV30(), l.getV20() * r.getV01() + l.getV21() * r.getV11() + l.getV22() * r.getV21() + l.getV23() * r.getV31(), l.getV20() * r.getV02() + l.getV21() * r.getV12() + l.getV22() * r.getV22() + l.getV23() * r.getV32(), l.getV20() * r.getV03() + l.getV21() * r.getV13() + l.getV22() * r.getV23() + l.getV23() * r.getV33(), l.getV30() * r.getV00() + l.getV31() * r.getV10() + l.getV32() * r.getV20() + l.getV33() * r.getV30(), l.getV30() * r.getV01() + l.getV31() * r.getV11() + l.getV32() * r.getV21() + l.getV33() * r.getV31(), l.getV30() * r.getV02() + l.getV31() * r.getV12() + l.getV32() * r.getV22() + l.getV33() * r.getV32(), l.getV30() * r.getV03() + l.getV31() * r.getV13() + l.getV32() * r.getV23() + l.getV33() * r.getV33());
        }

        @NotNull
        public final Matrix4 multiply(float lv00, float lv01, float lv02, float lv03, float lv10, float lv11, float lv12, float lv13, float lv20, float lv21, float lv22, float lv23, float lv30, float lv31, float lv32, float lv33, float rv00, float rv01, float rv02, float rv03, float rv10, float rv11, float rv12, float rv13, float rv20, float rv21, float rv22, float rv23, float rv30, float rv31, float rv32, float rv33) {
            return Companion.fromRows(lv00 * rv00 + lv01 * rv10 + lv02 * rv20 + lv03 * rv30, lv00 * rv01 + lv01 * rv11 + lv02 * rv21 + lv03 * rv31, lv00 * rv02 + lv01 * rv12 + lv02 * rv22 + lv03 * rv32, lv00 * rv03 + lv01 * rv13 + lv02 * rv23 + lv03 * rv33, lv10 * rv00 + lv11 * rv10 + lv12 * rv20 + lv13 * rv30, lv10 * rv01 + lv11 * rv11 + lv12 * rv21 + lv13 * rv31, lv10 * rv02 + lv11 * rv12 + lv12 * rv22 + lv13 * rv32, lv10 * rv03 + lv11 * rv13 + lv12 * rv23 + lv13 * rv33, lv20 * rv00 + lv21 * rv10 + lv22 * rv20 + lv23 * rv30, lv20 * rv01 + lv21 * rv11 + lv22 * rv21 + lv23 * rv31, lv20 * rv02 + lv21 * rv12 + lv22 * rv22 + lv23 * rv32, lv20 * rv03 + lv21 * rv13 + lv22 * rv23 + lv23 * rv33, lv30 * rv00 + lv31 * rv10 + lv32 * rv20 + lv33 * rv30, lv30 * rv01 + lv31 * rv11 + lv32 * rv21 + lv33 * rv31, lv30 * rv02 + lv31 * rv12 + lv32 * rv22 + lv33 * rv32, lv30 * rv03 + lv31 * rv13 + lv32 * rv23 + lv33 * rv33);
        }

        @NotNull
        public final Matrix4 ortho(float left, float right, float bottom, float top, float near, float far) {
            float sx = 2.0f / (right - left);
            float sy = 2.0f / (top - bottom);
            float sz = -2.0f / (far - near);
            float tx = -(right + left) / (right - left);
            float ty = -(top + bottom) / (top - bottom);
            float tz = -(far + near) / (far - near);
            return Companion.fromRows(sx, 0.0f, 0.0f, tx, 0.0f, sy, 0.0f, ty, 0.0f, 0.0f, sz, tz, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        public static /* synthetic */ Matrix4 ortho$default(Companion companion, float f, float f2, float f3, float f4, float f5, float f6, int n, Object object) {
            if ((n & 0x10) != 0) {
                f5 = 0.0f;
            }
            if ((n & 0x20) != 0) {
                f6 = 1.0f;
            }
            return companion.ortho(f, f2, f3, f4, f5, f6);
        }

        @NotNull
        public final Matrix4 ortho(double left, double right, double bottom, double top, double near, double far) {
            return this.ortho((float)left, (float)right, (float)bottom, (float)top, (float)near, (float)far);
        }

        @NotNull
        public final Matrix4 ortho(int left, int right, int bottom, int top, int near, int far) {
            return this.ortho((float)left, (float)right, (float)bottom, (float)top, (float)near, (float)far);
        }

        @NotNull
        public final Matrix4 ortho(@NotNull RectangleD rect, float near, float far) {
            return this.ortho(rect.getLeft(), rect.getRight(), rect.getBottom(), rect.getTop(), (double)near, (double)far);
        }

        public static /* synthetic */ Matrix4 ortho$default(Companion companion, RectangleD rectangleD, float f, float f2, int n, Object object) {
            if ((n & 2) != 0) {
                f = 0.0f;
            }
            if ((n & 4) != 0) {
                f2 = 1.0f;
            }
            return companion.ortho(rectangleD, f, f2);
        }

        @NotNull
        public final Matrix4 ortho(@NotNull RectangleD rect, double near, double far) {
            return this.ortho(rect, (float)near, (float)far);
        }

        public static /* synthetic */ Matrix4 ortho$default(Companion companion, RectangleD rectangleD, double d, double d2, int n, Object object) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            if ((n & 4) != 0) {
                d2 = 1.0;
            }
            return companion.ortho(rectangleD, d, d2);
        }

        @NotNull
        public final Matrix4 ortho(@NotNull RectangleD rect, int near, int far) {
            return this.ortho(rect, (float)near, (float)far);
        }

        public static /* synthetic */ Matrix4 ortho$default(Companion companion, RectangleD rectangleD, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 1;
            }
            return companion.ortho(rectangleD, n, n2);
        }

        @NotNull
        public final Matrix4 frustum(float left, float right, float bottom, float top, float zNear, float zFar) {
            if (zNear <= 0.0f || zFar <= zNear) {
                throw new Exception("Error: Required zNear > 0 and zFar > zNear, but zNear " + zNear + ", zFar " + zFar);
            }
            if (left == right || top == bottom) {
                throw new Exception("Error: top,bottom and left,right must not be equal");
            }
            float zNear2 = 2.0f * zNear;
            float dx = right - left;
            float dy = top - bottom;
            float dz = zFar - zNear;
            float A = (right + left) / dx;
            float B = (top + bottom) / dy;
            float C = -1.0f * (zFar + zNear) / dz;
            float D = -2.0f * (zFar * zNear) / dz;
            return Companion.fromRows(zNear2 / dx, 0.0f, A, 0.0f, 0.0f, zNear2 / dy, B, 0.0f, 0.0f, 0.0f, C, D, 0.0f, 0.0f, -1.0f, 0.0f);
        }

        public static /* synthetic */ Matrix4 frustum$default(Companion companion, float f, float f2, float f3, float f4, float f5, float f6, int n, Object object) {
            if ((n & 0x10) != 0) {
                f5 = 0.0f;
            }
            if ((n & 0x20) != 0) {
                f6 = 1.0f;
            }
            return companion.frustum(f, f2, f3, f4, f5, f6);
        }

        @NotNull
        public final Matrix4 frustum(double left, double right, double bottom, double top, double zNear, double zFar) {
            return this.frustum((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
        }

        public static /* synthetic */ Matrix4 frustum$default(Companion companion, double d, double d2, double d3, double d4, double d5, double d6, int n, Object object) {
            if ((n & 0x10) != 0) {
                d5 = 0.0;
            }
            if ((n & 0x20) != 0) {
                d6 = 1.0;
            }
            return companion.frustum(d, d2, d3, d4, d5, d6);
        }

        @NotNull
        public final Matrix4 frustum(int left, int right, int bottom, int top, int zNear, int zFar) {
            return this.frustum((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
        }

        public static /* synthetic */ Matrix4 frustum$default(Companion companion, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
            if ((n7 & 0x10) != 0) {
                n5 = 0;
            }
            if ((n7 & 0x20) != 0) {
                n6 = 1;
            }
            return companion.frustum(n, n2, n3, n4, n5, n6);
        }

        @NotNull
        public final Matrix4 frustum(@NotNull RectangleD rect, float zNear, float zFar) {
            return this.frustum(rect.getLeft(), rect.getRight(), rect.getBottom(), rect.getTop(), (double)zNear, (double)zFar);
        }

        public static /* synthetic */ Matrix4 frustum$default(Companion companion, RectangleD rectangleD, float f, float f2, int n, Object object) {
            if ((n & 2) != 0) {
                f = 0.0f;
            }
            if ((n & 4) != 0) {
                f2 = 1.0f;
            }
            return companion.frustum(rectangleD, f, f2);
        }

        @NotNull
        public final Matrix4 frustum(@NotNull RectangleD rect, double zNear, double zFar) {
            return this.frustum(rect, (float)zNear, (float)zFar);
        }

        public static /* synthetic */ Matrix4 frustum$default(Companion companion, RectangleD rectangleD, double d, double d2, int n, Object object) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            if ((n & 4) != 0) {
                d2 = 1.0;
            }
            return companion.frustum(rectangleD, d, d2);
        }

        @NotNull
        public final Matrix4 frustum(@NotNull RectangleD rect, int zNear, int zFar) {
            return this.frustum(rect, (float)zNear, (float)zFar);
        }

        public static /* synthetic */ Matrix4 frustum$default(Companion companion, RectangleD rectangleD, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 1;
            }
            return companion.frustum(rectangleD, n, n2);
        }

        @NotNull
        public final Matrix4 perspective-FE8ZRLo(double fovy, float aspect, float zNear, float zFar) {
            float top = (float)Math.tan((float)fovy / 2.0f) * zNear;
            float bottom = -1.0f * top;
            float left = aspect * bottom;
            float right = aspect * top;
            return this.frustum(left, right, bottom, top, zNear, zFar);
        }

        @NotNull
        public final Matrix4 perspective-FE8ZRLo(double fovy, double aspect, double zNear, double zFar) {
            return this.perspective-FE8ZRLo(fovy, (float)aspect, (float)zNear, (float)zFar);
        }

        @NotNull
        public final Matrix4 lookAt(@NotNull Vector3F eye, @NotNull Vector3F target, @NotNull Vector3F up2) {
            Vector3F x;
            Vector3F z = eye.minus(target);
            if (z.getLengthSquared() == 0.0f) {
                z = Vector3F.copy$default(z, 0.0f, 0.0f, 1.0f, 3, null);
            }
            if ((x = Vector3F.Companion.cross(up2, z = z.normalized())).getLengthSquared() == 0.0f) {
                z = Math.abs(up2.getZ()) == 1.0f ? Vector3F.copy$default(z, z.getX() + 1.0E-4f, 0.0f, 0.0f, 6, null) : Vector3F.copy$default(z, 0.0f, 0.0f, z.getZ() + 1.0E-4f, 3, null);
                z = z.normalized();
                x = Vector3F.Companion.cross(up2, z);
            }
            x = x.normalized();
            Vector3F y = Vector3F.Companion.cross(z, x);
            return Companion.fromRows(x.getX(), y.getX(), z.getX(), 0.0f, x.getY(), y.getY(), z.getY(), 0.0f, x.getZ(), y.getZ(), z.getZ(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

