/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.geom.Angle;
import korlibs.math.geom.AngleKt;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.Scale;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 <2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001<B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B?\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fBK\u0012\b\b\u0002\u0010\u0003\u001a\u00020\r\u0012\b\b\u0002\u0010\u0005\u001a\u00020\r\u0012\b\b\u0002\u0010\u0006\u001a\u00020\r\u0012\b\b\u0002\u0010\u0007\u001a\u00020\r\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001e\u001a\u00020\rH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\rH\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003J\t\u0010!\u001a\u00020\rH\u00c6\u0003J\u0016\u0010\"\u001a\u00020\tH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010\u0010J\u0016\u0010$\u001a\u00020\tH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010\u0010J\u0016\u0010&\u001a\u00020\tH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b'\u0010\u0010JY\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\r2\b\b\u0002\u0010\u0005\u001a\u00020\r2\b\b\u0002\u0010\u0006\u001a\u00020\r2\b\b\u0002\u0010\u0007\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010*J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\u0018\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00002\u0006\u00102\u001a\u00020\rH\u0016J\u0011\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0000H\u0086\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0000H\u0086\u0002J\u001a\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u00020\r2\b\b\u0002\u00109\u001a\u00020\rJ\b\u0010:\u001a\u00020;H\u0016R\u0019\u0010\u000b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0019\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u001a\u0010\u0010R\u0019\u0010\n\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u001b\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006="}, d2={"Lkorlibs/math/geom/MatrixTransform;", "Lkorlibs/math/IsAlmostEquals;", "()V", "x", "", "y", "scaleX", "scaleY", "skewX", "Lkorlibs/math/geom/Angle;", "skewY", "rotation", "(FFFFDDDLkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "(DDDDDDDLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getRotation-igmgxjg", "()D", "D", "scale", "Lkorlibs/math/geom/Scale;", "getScale", "()Lkorlibs/math/geom/Scale;", "scaleAvg", "getScaleAvg", "getScaleX", "getScaleY", "getSkewX-igmgxjg", "getSkewY-igmgxjg", "getX", "getY", "component1", "component2", "component3", "component4", "component5", "component5-igmgxjg", "component6", "component6-igmgxjg", "component7", "component7-igmgxjg", "copy", "copy-C29mWsE", "(DDDDDDD)Lkorlibs/math/geom/MatrixTransform;", "equals", "", "other", "", "hashCode", "", "isAlmostEquals", "epsilon", "minus", "that", "plus", "toMatrix", "Lkorlibs/math/geom/Matrix;", "pivotX", "pivotY", "toString", "", "Companion", "korge-foundation"})
public final class MatrixTransform
implements IsAlmostEquals<MatrixTransform> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double scaleX;
    private final double scaleY;
    private final double skewX;
    private final double skewY;
    private final double rotation;
    @NotNull
    private static final MatrixTransform IDENTITY = new MatrixTransform(0.0, 0.0, 1.0, 1.0, Angle.Companion.getZERO-igmgxjg(), Angle.Companion.getZERO-igmgxjg(), Angle.Companion.getZERO-igmgxjg(), null);

    private MatrixTransform(double x, double y, double scaleX, double scaleY, double skewX, double skewY, double rotation) {
        this.x = x;
        this.y = y;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.skewX = skewX;
        this.skewY = skewY;
        this.rotation = rotation;
    }

    public /* synthetic */ MatrixTransform(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            d5 = Angle.Companion.getZERO-igmgxjg();
        }
        if ((n & 0x20) != 0) {
            d6 = Angle.Companion.getZERO-igmgxjg();
        }
        if ((n & 0x40) != 0) {
            d7 = Angle.Companion.getZERO-igmgxjg();
        }
        this(d, d2, d3, d4, d5, d6, d7, null);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getScaleX() {
        return this.scaleX;
    }

    public final double getScaleY() {
        return this.scaleY;
    }

    public final double getSkewX-igmgxjg() {
        return this.skewX;
    }

    public final double getSkewY-igmgxjg() {
        return this.skewY;
    }

    public final double getRotation-igmgxjg() {
        return this.rotation;
    }

    @NotNull
    public final Scale getScale() {
        return new Scale(this.scaleX, this.scaleY);
    }

    @NotNull
    public String toString() {
        return "MatrixTransform(x=" + StringExtKt.getNiceStr(this.x) + ", y=" + StringExtKt.getNiceStr(this.y) + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", skewX=" + Angle.toString-impl(this.skewX) + ", skewY=" + Angle.toString-impl(this.skewY) + ", rotation=" + Angle.toString-impl(this.rotation) + ")";
    }

    public MatrixTransform() {
        this(0.0, 0.0, 1.0, 1.0, Angle.Companion.getZERO-igmgxjg(), Angle.Companion.getZERO-igmgxjg(), Angle.Companion.getZERO-igmgxjg(), null);
    }

    private MatrixTransform(float x, float y, float scaleX, float scaleY, double skewX, double skewY, double rotation) {
        this((double)x, (double)y, (double)scaleX, (double)scaleY, skewX, skewY, rotation, null);
    }

    @Override
    public boolean isAlmostEquals(@NotNull MatrixTransform other, double epsilon) {
        return Companion.isAlmostEquals(this, other, epsilon);
    }

    public final double getScaleAvg() {
        return (this.scaleX + this.scaleY) * 0.5;
    }

    @NotNull
    public final Matrix toMatrix(double pivotX, double pivotY) {
        return Matrix.Companion.fromTransform(this, pivotX, pivotY);
    }

    public static /* synthetic */ Matrix toMatrix$default(MatrixTransform matrixTransform, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        return matrixTransform.toMatrix(d, d2);
    }

    @NotNull
    public final MatrixTransform plus(@NotNull MatrixTransform that) {
        return new MatrixTransform(this.x + that.x, this.y + that.y, this.scaleX * that.scaleX, this.scaleY * that.scaleY, Angle.plus-9E-s4b0(this.skewX, that.skewX), Angle.plus-9E-s4b0(this.skewY, that.skewY), Angle.plus-9E-s4b0(this.rotation, that.rotation), null);
    }

    @NotNull
    public final MatrixTransform minus(@NotNull MatrixTransform that) {
        return new MatrixTransform(this.x - that.x, this.y - that.y, this.scaleX / that.scaleX, this.scaleY / that.scaleY, Angle.minus-9E-s4b0(this.skewX, that.skewX), Angle.minus-9E-s4b0(this.skewY, that.skewY), Angle.minus-9E-s4b0(this.rotation, that.rotation), null);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.scaleX;
    }

    public final double component4() {
        return this.scaleY;
    }

    public final double component5-igmgxjg() {
        return this.skewX;
    }

    public final double component6-igmgxjg() {
        return this.skewY;
    }

    public final double component7-igmgxjg() {
        return this.rotation;
    }

    @NotNull
    public final MatrixTransform copy-C29mWsE(double x, double y, double scaleX, double scaleY, double skewX, double skewY, double rotation) {
        return new MatrixTransform(x, y, scaleX, scaleY, skewX, skewY, rotation, null);
    }

    public static /* synthetic */ MatrixTransform copy-C29mWsE$default(MatrixTransform matrixTransform, double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, Object object) {
        if ((n & 1) != 0) {
            d = matrixTransform.x;
        }
        if ((n & 2) != 0) {
            d2 = matrixTransform.y;
        }
        if ((n & 4) != 0) {
            d3 = matrixTransform.scaleX;
        }
        if ((n & 8) != 0) {
            d4 = matrixTransform.scaleY;
        }
        if ((n & 0x10) != 0) {
            d5 = matrixTransform.skewX;
        }
        if ((n & 0x20) != 0) {
            d6 = matrixTransform.skewY;
        }
        if ((n & 0x40) != 0) {
            d7 = matrixTransform.rotation;
        }
        return matrixTransform.copy-C29mWsE(d, d2, d3, d4, d5, d6, d7);
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.y);
        result2 = result2 * 31 + Double.hashCode(this.scaleX);
        result2 = result2 * 31 + Double.hashCode(this.scaleY);
        result2 = result2 * 31 + Angle.hashCode-impl(this.skewX);
        result2 = result2 * 31 + Angle.hashCode-impl(this.skewY);
        result2 = result2 * 31 + Angle.hashCode-impl(this.rotation);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MatrixTransform)) {
            return false;
        }
        MatrixTransform matrixTransform = (MatrixTransform)other;
        if (Double.compare(this.x, matrixTransform.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, matrixTransform.y) != 0) {
            return false;
        }
        if (Double.compare(this.scaleX, matrixTransform.scaleX) != 0) {
            return false;
        }
        if (Double.compare(this.scaleY, matrixTransform.scaleY) != 0) {
            return false;
        }
        if (!Angle.equals-impl0(this.skewX, matrixTransform.skewX)) {
            return false;
        }
        if (!Angle.equals-impl0(this.skewY, matrixTransform.skewY)) {
            return false;
        }
        return Angle.equals-impl0(this.rotation, matrixTransform.rotation);
    }

    public /* synthetic */ MatrixTransform(double x, double y, double scaleX, double scaleY, double skewX, double skewY, double rotation, DefaultConstructorMarker $constructor_marker) {
        this(x, y, scaleX, scaleY, skewX, skewY, rotation);
    }

    public /* synthetic */ MatrixTransform(float x, float y, float scaleX, float scaleY, double skewX, double skewY, double rotation, DefaultConstructorMarker $constructor_marker) {
        this(x, y, scaleX, scaleY, skewX, skewY, rotation);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0019"}, d2={"Lkorlibs/math/geom/MatrixTransform$Companion;", "", "()V", "IDENTITY", "Lkorlibs/math/geom/MatrixTransform;", "getIDENTITY", "()Lkorlibs/math/geom/MatrixTransform;", "fromMatrix", "matrix", "Lkorlibs/math/geom/Matrix;", "pivotX", "", "pivotY", "interpolated", "l", "r", "ratio", "Lkorlibs/math/interpolation/Ratio;", "interpolated-i056VXE", "(Lkorlibs/math/geom/MatrixTransform;Lkorlibs/math/geom/MatrixTransform;D)Lkorlibs/math/geom/MatrixTransform;", "isAlmostEquals", "", "a", "b", "epsilon", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MatrixTransform getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final MatrixTransform fromMatrix(@NotNull Matrix matrix2, double pivotX, double pivotY) {
            double a = matrix2.getA();
            double b = matrix2.getB();
            double c = matrix2.getC();
            double d = matrix2.getD();
            double skewX = -Math.atan2(-c, d);
            double skewY = Math.atan2(b, a);
            double delta = Math.abs(skewX + skewY);
            double trotation = 0.0;
            double tskewX = 0.0;
            double tskewY = 0.0;
            double tx = 0.0;
            double ty = 0.0;
            if (delta < (double)0.001f || Math.abs(Math.PI * 2 - delta) < (double)0.001f) {
                trotation = AngleKt.getRadians(skewY);
                tskewX = AngleKt.getRadians(0.0);
                tskewY = AngleKt.getRadians(0.0);
            } else {
                trotation = AngleKt.getRadians(0);
                tskewX = AngleKt.getRadians(skewX);
                tskewY = AngleKt.getRadians(skewY);
            }
            double tscaleX = Math.hypot(a, b);
            double tscaleY = Math.hypot(c, d);
            if (pivotX == 0.0 && pivotY == 0.0) {
                tx = matrix2.getTx();
                ty = matrix2.getTy();
            } else {
                tx = matrix2.getTx() + (pivotX * a + pivotY * c);
                ty = matrix2.getTy() + (pivotX * b + pivotY * d);
            }
            return new MatrixTransform(tx, ty, tscaleX, tscaleY, tskewX, tskewY, trotation, null);
        }

        public static /* synthetic */ MatrixTransform fromMatrix$default(Companion companion, Matrix matrix2, double d, double d2, int n, Object object) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            if ((n & 4) != 0) {
                d2 = 0.0;
            }
            return companion.fromMatrix(matrix2, d, d2);
        }

        @NotNull
        public final MatrixTransform interpolated-i056VXE(@NotNull MatrixTransform l, @NotNull MatrixTransform r, double ratio2) {
            return new MatrixTransform(_Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio-kg1FUQ0(ratio2), l.getX(), r.getX()), _Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio-kg1FUQ0(ratio2), l.getY(), r.getY()), _Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio-kg1FUQ0(ratio2), l.getScaleX(), r.getScaleX()), _Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio-kg1FUQ0(ratio2), l.getScaleY(), r.getScaleY()), AngleKt.interpolateAngleDenormalized-kA_E3HI(_Math_interpolationKt.toRatio-kg1FUQ0(ratio2), l.getSkewX-igmgxjg(), r.getSkewX-igmgxjg()), AngleKt.interpolateAngleDenormalized-kA_E3HI(_Math_interpolationKt.toRatio-kg1FUQ0(ratio2), l.getSkewY-igmgxjg(), r.getSkewY-igmgxjg()), AngleKt.interpolateAngleDenormalized-kA_E3HI(_Math_interpolationKt.toRatio-kg1FUQ0(ratio2), l.getRotation-igmgxjg(), r.getRotation-igmgxjg()), null);
        }

        public final boolean isAlmostEquals(@NotNull MatrixTransform a, @NotNull MatrixTransform b, double epsilon) {
            return IsAlmostZeroKt.isAlmostEquals(a.getX(), b.getX(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getY(), b.getY(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getScaleX(), b.getScaleX(), epsilon) && IsAlmostZeroKt.isAlmostEquals(a.getScaleY(), b.getScaleY(), epsilon) && Angle.isAlmostEquals-2FdH_oo(a.getSkewX-igmgxjg(), b.getSkewX-igmgxjg(), epsilon) && Angle.isAlmostEquals-2FdH_oo(a.getSkewY-igmgxjg(), b.getSkewY-igmgxjg(), epsilon) && Angle.isAlmostEquals-2FdH_oo(a.getRotation-igmgxjg(), b.getRotation-igmgxjg(), epsilon);
        }

        public static /* synthetic */ boolean isAlmostEquals$default(Companion companion, MatrixTransform matrixTransform, MatrixTransform matrixTransform2, double d, int n, Object object) {
            if ((n & 4) != 0) {
                d = 1.0E-6;
            }
            return companion.isAlmostEquals(matrixTransform, matrixTransform2, d);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

