/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.geom.Vector2D;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\t\u0010\b\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lkorlibs/math/geom/Orientation;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "unaryMinus", "unaryPlus", "CLOCK_WISE", "COUNTER_CLOCK_WISE", "COLLINEAR", "Companion", "korge-foundation"})
public final class Orientation
extends Enum<Orientation> {
    @NotNull
    public static final Companion Companion;
    private final int value;
    private static final double EPSILON = 1.0E-7;
    public static final /* enum */ Orientation CLOCK_WISE;
    public static final /* enum */ Orientation COUNTER_CLOCK_WISE;
    public static final /* enum */ Orientation COLLINEAR;
    private static final /* synthetic */ Orientation[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Orientation(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    @NotNull
    public final Orientation unaryMinus() {
        Orientation orientation2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                orientation2 = COUNTER_CLOCK_WISE;
                break;
            }
            case 2: {
                orientation2 = CLOCK_WISE;
                break;
            }
            case 3: {
                orientation2 = COLLINEAR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return orientation2;
    }

    @NotNull
    public final Orientation unaryPlus() {
        return this;
    }

    public static Orientation[] values() {
        return (Orientation[])$VALUES.clone();
    }

    public static Orientation valueOf(String value) {
        return Enum.valueOf(Orientation.class, value);
    }

    @NotNull
    public static EnumEntries<Orientation> getEntries() {
        return $ENTRIES;
    }

    static {
        CLOCK_WISE = new Orientation(1);
        COUNTER_CLOCK_WISE = new Orientation(-1);
        COLLINEAR = new Orientation(0);
        $VALUES = orientationArray = new Orientation[]{Orientation.CLOCK_WISE, Orientation.COUNTER_CLOCK_WISE, Orientation.COLLINEAR};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ4\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\bj\u0002`\r2\n\u0010\u000e\u001a\u00060\bj\u0002`\r2\n\u0010\u000f\u001a\u00060\bj\u0002`\r2\b\b\u0002\u0010\u0007\u001a\u00020\bJJ\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkorlibs/math/geom/Orientation$Companion;", "", "()V", "EPSILON", "", "checkValidUpVector", "", "up", "Lkorlibs/math/geom/Vector2D;", "checkValidUpVector$korge_foundation", "orient2d", "Lkorlibs/math/geom/Orientation;", "pa", "Lkorlibs/math/geom/Point;", "pb", "pc", "paX", "paY", "pbX", "pbY", "pcX", "pcY", "epsilon", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\nOrientation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Orientation.kt\nkorlibs/math/geom/Orientation$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkValidUpVector$korge_foundation(@NotNull Vector2D up2) {
            if (!(up2.getX() == 0.0 && Math.abs(up2.getY()) == 1.0)) {
                boolean bl = false;
                String string = "up vector only supports (0, -1) and (0, +1) for now";
                throw new IllegalStateException(string.toString());
            }
        }

        @NotNull
        public final Orientation orient2d(@NotNull Vector2D pa, @NotNull Vector2D pb, @NotNull Vector2D pc, @NotNull Vector2D up2) {
            return korlibs.math.geom.Orientation$Companion.orient2d$default(this, pa.getX(), pa.getY(), pb.getX(), pb.getY(), pc.getX(), pc.getY(), 0.0, up2, 64, null);
        }

        public static /* synthetic */ Orientation orient2d$default(Companion companion, Vector2D vector2D, Vector2D vector2D2, Vector2D vector2D3, Vector2D vector2D4, int n, Object object) {
            if ((n & 8) != 0) {
                vector2D4 = Vector2D.Companion.getUP();
            }
            return companion.orient2d(vector2D, vector2D2, vector2D3, vector2D4);
        }

        @NotNull
        public final Orientation orient2d(double paX, double paY, double pbX, double pbY, double pcX, double pcY, double epsilon, @NotNull Vector2D up2) {
            this.checkValidUpVector$korge_foundation(up2);
            double detleft = (paX - pcX) * (pbY - pcY);
            double detright = (paY - pcY) * (pbX - pcX);
            double v = detleft - detright;
            Orientation res = Math.abs(v) < epsilon ? COLLINEAR : (v > 0.0 ? COUNTER_CLOCK_WISE : CLOCK_WISE);
            return up2.getY() > 0.0 ? res : res.unaryMinus();
        }

        public static /* synthetic */ Orientation orient2d$default(Companion companion, double d, double d2, double d3, double d4, double d5, double d6, double d7, Vector2D vector2D, int n, Object object) {
            if ((n & 0x40) != 0) {
                d7 = 1.0E-7;
            }
            if ((n & 0x80) != 0) {
                vector2D = Vector2D.Companion.getUP();
            }
            return companion.orient2d(d, d2, d3, d4, d5, d6, d7, vector2D);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.CLOCK_WISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.COUNTER_CLOCK_WISE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.COLLINEAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

