/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import java.util.ArrayList;
import java.util.List;
import korlibs.datastructure.Extra;
import korlibs.math.RoundDecimalPlacesKt;
import korlibs.math.geom.DoubleVectorList;
import korlibs.math.geom.GenericDoubleVector;
import korlibs.math.geom.Orientation;
import korlibs.math.geom.PointArrayList;
import korlibs.math.geom.Vector2D;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\bv\u0018\u00002\u00020\u00012\u00020\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0016J\u0015\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\bj\u0002`\tH\u0096\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0015\u0010\u0018\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0019\u001a\u00020\u0004H\u0096\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\bH\u0016J\u0011\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0000H\u0096\u0002J\u001a\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010(\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0)H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00060\bj\u0002`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u0082\u0001\u0001\u000f\u00a8\u0006*"}, d2={"Lkorlibs/math/geom/PointList;", "Lkorlibs/math/geom/DoubleVectorList;", "Lkorlibs/datastructure/Extra;", "dimensions", "", "getDimensions", "()I", "first", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "getFirst", "()Lkorlibs/math/geom/Vector2D;", "last", "getLast", "clone", "Lkorlibs/math/geom/PointArrayList;", "out", "contains", "", "p", "x", "", "y", "", "get", "index", "getComponentList", "", "component", "getX", "getY", "orientationScreen", "Lkorlibs/math/geom/Orientation;", "orientationStd", "orientationWithUp", "up", "plus", "other", "roundDecimalPlaces", "places", "toList", "", "korge-foundation"})
public interface PointList
extends DoubleVectorList,
Extra {
    @Override
    public int getDimensions();

    public double getX(int var1);

    public double getY(int var1);

    @NotNull
    public Vector2D get(int var1);

    @NotNull
    public List<Vector2D> toList();

    @NotNull
    public PointList roundDecimalPlaces(int var1, @NotNull PointArrayList var2);

    @NotNull
    public double[] getComponentList(int var1, @NotNull double[] var2);

    @NotNull
    public Vector2D getFirst();

    @NotNull
    public Vector2D getLast();

    @NotNull
    public Orientation orientationScreen();

    @NotNull
    public Orientation orientationStd();

    @NotNull
    public Orientation orientationWithUp(@NotNull Vector2D var1);

    public boolean contains(@NotNull Vector2D var1);

    public boolean contains(float var1, float var2);

    public boolean contains(int var1, int var2);

    public boolean contains(double var1, double var3);

    @NotNull
    public PointArrayList clone(@NotNull PointArrayList var1);

    @NotNull
    public PointArrayList plus(@NotNull PointList var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nVectorsList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorsList.kt\nkorlibs/math/geom/PointList$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 VectorsList.kt\nkorlibs/math/geom/VectorsListKt\n*L\n1#1,629:1\n1#2:630\n69#3:631\n69#3:632\n*S KotlinDebug\n*F\n+ 1 VectorsList.kt\nkorlibs/math/geom/PointList$DefaultImpls\n*L\n18#1:631\n21#1:632\n*E\n"})
    public static final class DefaultImpls {
        public static int getDimensions(@NotNull PointList $this) {
            return 2;
        }

        public static double getX(@NotNull PointList $this, int index2) {
            return $this.get(index2, 0);
        }

        public static double getY(@NotNull PointList $this, int index2) {
            return $this.get(index2, 1);
        }

        @NotNull
        public static Vector2D get(@NotNull PointList $this, int index2) {
            return new Vector2D($this.get(index2, 0), $this.get(index2, 1));
        }

        @NotNull
        public static List<Vector2D> toList(@NotNull PointList $this) {
            ArrayList<Vector2D> arrayList;
            ArrayList<Vector2D> out = arrayList = new ArrayList<Vector2D>($this.getSize());
            boolean bl = false;
            PointList $this$fastForEach$iv = $this;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.getSize();
            for (int n$iv = 0; n$iv < n; ++n$iv) {
                Vector2D it = $this$fastForEach$iv.get(n$iv);
                boolean bl2 = false;
                out.add(it);
            }
            return arrayList;
        }

        @NotNull
        public static PointList roundDecimalPlaces(@NotNull PointList $this, int places, @NotNull PointArrayList out) {
            PointList $this$fastForEach$iv = $this;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.getSize();
            for (int n$iv = 0; n$iv < n; ++n$iv) {
                Vector2D vector2D = $this$fastForEach$iv.get(n$iv);
                boolean bl = false;
                double x = vector2D.component1();
                double y = vector2D.component2();
                out.add(RoundDecimalPlacesKt.roundDecimalPlaces(x, places), RoundDecimalPlacesKt.roundDecimalPlaces(y, places));
            }
            return out;
        }

        public static /* synthetic */ PointList roundDecimalPlaces$default(PointList pointList, int n, PointArrayList pointArrayList, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: roundDecimalPlaces");
            }
            if ((n2 & 2) != 0) {
                pointArrayList = new PointArrayList(0, 1, null);
            }
            return pointList.roundDecimalPlaces(n, pointArrayList);
        }

        @NotNull
        public static double[] getComponentList(@NotNull PointList $this, int component, @NotNull double[] out) {
            int n = $this.getSize();
            for (int n2 = 0; n2 < n; ++n2) {
                out[n2] = $this.get(n2, component);
            }
            return out;
        }

        public static /* synthetic */ double[] getComponentList$default(PointList pointList, int n, double[] dArray, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getComponentList");
            }
            if ((n2 & 2) != 0) {
                dArray = new double[pointList.getSize()];
            }
            return pointList.getComponentList(n, dArray);
        }

        @NotNull
        public static Vector2D getFirst(@NotNull PointList $this) {
            return $this.get(0);
        }

        @NotNull
        public static Vector2D getLast(@NotNull PointList $this) {
            return $this.get($this.getSize() - 1);
        }

        @NotNull
        public static Orientation orientationScreen(@NotNull PointList $this) {
            return $this.orientationWithUp(Vector2D.Companion.getUP_SCREEN());
        }

        @NotNull
        public static Orientation orientationStd(@NotNull PointList $this) {
            return $this.orientationWithUp(Vector2D.Companion.getUP());
        }

        @NotNull
        public static Orientation orientationWithUp(@NotNull PointList $this, @NotNull Vector2D up2) {
            if ($this.getSize() < 3) {
                return Orientation.COLLINEAR;
            }
            return Orientation.Companion.orient2d$default(Orientation.Companion, $this.getX(0), $this.getY(0), $this.getX(1), $this.getY(1), $this.getX(2), $this.getY(2), 0.0, null, 192, null);
        }

        public static boolean contains(@NotNull PointList $this, @NotNull Vector2D p) {
            return $this.contains(p.getX(), p.getY());
        }

        public static boolean contains(@NotNull PointList $this, float x, float y) {
            return $this.contains((double)x, (double)y);
        }

        public static boolean contains(@NotNull PointList $this, int x, int y) {
            return $this.contains((double)x, (double)y);
        }

        public static boolean contains(@NotNull PointList $this, double x, double y) {
            int n = $this.getSize();
            for (int n2 = 0; n2 < n; ++n2) {
                if (!($this.getX(n2) == x) || !($this.getY(n2) == y)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public static PointArrayList clone(@NotNull PointList $this, @NotNull PointArrayList out) {
            out.copyFrom($this);
            return out;
        }

        public static /* synthetic */ PointArrayList clone$default(PointList pointList, PointArrayList pointArrayList, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clone");
            }
            if ((n & 1) != 0) {
                pointArrayList = new PointArrayList(pointList.getSize());
            }
            return pointList.clone(pointArrayList);
        }

        @NotNull
        public static PointArrayList plus(@NotNull PointList $this, @NotNull PointList other) {
            PointArrayList pointArrayList;
            PointArrayList it = pointArrayList = new PointArrayList($this.getSize() + other.getSize());
            boolean bl = false;
            it.add($this);
            it.add(other);
            return pointArrayList;
        }

        public static boolean isEmpty(@NotNull PointList $this) {
            return DoubleVectorList.DefaultImpls.isEmpty($this);
        }

        public static boolean isNotEmpty(@NotNull PointList $this) {
            return DoubleVectorList.DefaultImpls.isNotEmpty($this);
        }

        @NotNull
        public static GenericDoubleVector getGeneric(@NotNull PointList $this, int index2) {
            return DoubleVectorList.DefaultImpls.getGeneric($this, index2);
        }

        public static boolean isAlmostEquals(@NotNull PointList $this, @NotNull DoubleVectorList other, double epsilon) {
            return DoubleVectorList.DefaultImpls.isAlmostEquals($this, other, epsilon);
        }
    }
}

