/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.IsAlmostEqualsF;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.geom.Angle;
import korlibs.math.geom.EulerRotation;
import korlibs.math.geom.Matrix3;
import korlibs.math.geom.Matrix4;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.Vector3F;
import korlibs.math.geom.Vector4F;
import korlibs.math.interpolation.Ratio;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 Q2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001QB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rB%\u0012\u0006\u0010\b\u001a\u00020\u000e\u0012\u0006\u0010\n\u001a\u00020\u000e\u0012\u0006\u0010\u000b\u001a\u00020\u000e\u0012\u0006\u0010\f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001f\u001a\u00020 H\u0002J\u001b\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b$\u0010%J\t\u0010&\u001a\u00020\u000eH\u00c6\u0003J\t\u0010'\u001a\u00020\u000eH\u00c6\u0003J\t\u0010(\u001a\u00020\u000eH\u00c6\u0003J\t\u0010)\u001a\u00020\u000eH\u00c6\u0003J\u0006\u0010*\u001a\u00020\u0000J1\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u000e2\b\b\u0002\u0010\n\u001a\u00020\u000e2\b\b\u0002\u0010\u000b\u001a\u00020\u000e2\b\b\u0002\u0010\f\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010#\u001a\u0004\u0018\u00010.H\u00d6\u0003J\u0011\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H\u0086\u0002J\t\u00102\u001a\u000201H\u00d6\u0001J \u00103\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00002\u0006\u00104\u001a\u000205\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107J\u0016\u00103\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u000eJ\u0006\u00108\u001a\u00020\u0000J\u0018\u00109\u001a\u00020-2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u000eH\u0016J\u0011\u0010;\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010<\u001a\u00020\u0000J\u0011\u0010=\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\tJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u000eJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u000201J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\tH\u0086\u0002J\u0011\u0010@\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u000eH\u0086\u0002J\u001a\u0010A\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020D\u00f8\u0001\u0001\u00a2\u0006\u0004\bE\u0010FJ\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020JJ\b\u0010K\u001a\u00020HH\u0007J\t\u0010L\u001a\u00020MH\u00d6\u0001J\u000e\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\u001aJ\t\u0010P\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\b\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006R"}, d2={"Lkorlibs/math/geom/Quaternion;", "Lkorlibs/math/IsAlmostEqualsF;", "vector", "Lkorlibs/math/geom/Vector4F;", "unit", "", "(Lkorlibs/math/geom/Vector4F;Lkotlin/Unit;)V", "()V", "x", "", "y", "z", "w", "(DDDD)V", "", "(FFFF)V", "length", "getLength", "()F", "lengthSquared", "getLengthSquared", "getVector", "()Lkorlibs/math/geom/Vector4F;", "getW", "getX", "xyz", "Lkorlibs/math/geom/Vector3F;", "getXyz", "()Lkorlibs/math/geom/Vector3F;", "getY", "getZ", "_toMatrix", "", "angleTo", "Lkorlibs/math/geom/Angle;", "other", "angleTo-AmL7uXk", "(Lkorlibs/math/geom/Quaternion;)D", "component1", "component2", "component3", "component4", "conjugate", "copy", "equals", "", "", "get", "index", "", "hashCode", "interpolated", "t", "Lkorlibs/math/interpolation/Ratio;", "interpolated-BdQlfBE", "(Lkorlibs/math/geom/Quaternion;D)Lkorlibs/math/geom/Quaternion;", "inverted", "isAlmostEquals", "epsilon", "minus", "normalized", "plus", "scaled", "scale", "times", "toEuler", "Lkorlibs/math/geom/EulerRotation;", "config", "Lkorlibs/math/geom/EulerRotation$Config;", "toEuler-krfxFeQ", "(I)Lkorlibs/math/geom/Vector4F;", "toMatrix", "Lkorlibs/math/geom/Matrix4;", "toMatrix3", "Lkorlibs/math/geom/Matrix3;", "toMatrixInverted", "toString", "", "transform", "v", "unaryMinus", "Companion", "korge-foundation"})
public final class Quaternion
implements IsAlmostEqualsF<Quaternion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final float z;
    private final float w;
    @NotNull
    private static final Quaternion IDENTITY = new Quaternion();

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public final float getW() {
        return this.w;
    }

    @NotNull
    public final Vector4F getVector() {
        return new Vector4F(this.x, this.y, this.z, this.w);
    }

    @NotNull
    public final Vector3F getXyz() {
        return new Vector3F(this.x, this.y, this.z);
    }

    @NotNull
    public final Quaternion conjugate() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    public final float get(int index2) {
        float f;
        switch (index2) {
            case 0: {
                f = this.x;
                break;
            }
            case 1: {
                f = this.y;
                break;
            }
            case 2: {
                f = this.z;
                break;
            }
            case 3: {
                f = this.w;
                break;
            }
            default: {
                f = Float.NaN;
            }
        }
        return f;
    }

    public final float getLengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final float getLength() {
        return (float)Math.sqrt(this.getLengthSquared());
    }

    public Quaternion(@NotNull Vector4F vector, @NotNull Unit unit) {
        this(vector.getX(), vector.getY(), vector.getZ(), vector.getW());
    }

    public /* synthetic */ Quaternion(Vector4F vector4F, Unit unit, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            unit = Unit.INSTANCE;
        }
        this(vector4F, unit);
    }

    public Quaternion() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion(double x, double y, double z, double w) {
        this((float)x, (float)y, (float)z, (float)w);
    }

    @NotNull
    public final Matrix4 toMatrix() {
        float[] v = this._toMatrix();
        return Matrix4.Companion.fromRows(v[0], v[1], v[2], 0.0f, v[3], v[4], v[5], 0.0f, v[6], v[7], v[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @NotNull
    public final Matrix3 toMatrix3() {
        float[] v = this._toMatrix();
        return Matrix3.Companion.fromRows(v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8]);
    }

    private final float[] _toMatrix() {
        float xx = this.x * this.x;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float xw = this.x * this.w;
        float yy = this.y * this.y;
        float yz = this.y * this.z;
        float yw = this.y * this.w;
        float zz = this.z * this.z;
        float zw = this.z * this.w;
        float[] fArray = new float[]{1.0f - (float)2 * (yy + zz), (float)2 * (xy - zw), (float)2 * (xz + yw), (float)2 * (xy + zw), 1.0f - (float)2 * (xx + zz), (float)2 * (yz - xw), (float)2 * (xz - yw), (float)2 * (yz + xw), 1.0f - (float)2 * (xx + yy)};
        return fArray;
    }

    @Deprecated(message="Use toMatrix instead")
    @NotNull
    public final Matrix4 toMatrixInverted() {
        return Matrix4.Companion.multiply(this.w, this.z, -this.y, this.x, -this.z, this.w, this.x, this.y, this.y, -this.x, this.w, this.z, -this.x, -this.y, -this.z, this.w, this.w, this.z, -this.y, -this.x, -this.z, this.w, this.x, -this.y, this.y, -this.x, this.w, -this.z, this.x, this.y, this.z, this.w);
    }

    @NotNull
    public final Quaternion unaryMinus() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    @NotNull
    public final Quaternion plus(@NotNull Quaternion other) {
        return new Quaternion(this.x + other.x, this.y + other.y, this.z + other.z, this.w + other.w);
    }

    @NotNull
    public final Quaternion minus(@NotNull Quaternion other) {
        return new Quaternion(this.x - other.x, this.y - other.y, this.z - other.z, this.w - other.w);
    }

    @NotNull
    public final Quaternion scaled(float scale) {
        return Companion.interpolated(IDENTITY, this, scale);
    }

    @NotNull
    public final Quaternion scaled(double scale) {
        return this.scaled((float)scale);
    }

    @NotNull
    public final Quaternion scaled(int scale) {
        return this.scaled((float)scale);
    }

    @NotNull
    public final Quaternion times(float scale) {
        return new Quaternion(this.x * scale, this.y * scale, this.z * scale, this.w * scale);
    }

    @NotNull
    public final Quaternion times(double scale) {
        return this.times((float)scale);
    }

    @NotNull
    public final Quaternion times(@NotNull Quaternion other) {
        Quaternion left = this;
        Quaternion right = other;
        return new Quaternion(new Vector4F(left.getXyz().times(right.w).plus(right.getXyz().times(left.w)).plus(Vector3F.Companion.cross(left.getXyz(), right.getXyz())), left.w * right.w - left.getXyz().dot(right.getXyz())), null, 2, null);
    }

    @NotNull
    public final Quaternion normalized() {
        float length2 = 1.0f / new Vector4F(this.x, this.y, this.z, this.w).getLength();
        return new Quaternion(this.x / length2, this.y / length2, this.z / length2, this.w / length2);
    }

    @NotNull
    public final Quaternion inverted() {
        Quaternion q = this;
        float lengthSquared = q.getLengthSquared();
        if (IsAlmostZeroKt.isAlmostZero(lengthSquared)) {
            throw new IllegalStateException("Zero quaternion doesn't have invesrse".toString());
        }
        float num = 1.0f / lengthSquared;
        return new Quaternion(q.x * -num, q.y * -num, q.z * -num, q.w * num);
    }

    @NotNull
    public final Vector3F transform(@NotNull Vector3F v) {
        Quaternion q = this;
        Quaternion p = new Quaternion(v.getX(), v.getY(), v.getZ(), 0.0f);
        Quaternion resultQuaternion = q.times(p).times(q.conjugate());
        return new Vector3F(resultQuaternion.x, resultQuaternion.y, resultQuaternion.z);
    }

    @NotNull
    public final Vector4F toEuler-krfxFeQ(int config2) {
        return EulerRotation.Companion.fromQuaternion-FYhG3Bk(this, config2);
    }

    public static /* synthetic */ Vector4F toEuler-krfxFeQ$default(Quaternion quaternion, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = EulerRotation.Config.Companion.getDEFAULT-r7tHrnw();
        }
        return quaternion.toEuler-krfxFeQ(n);
    }

    @Override
    public boolean isAlmostEquals(@NotNull Quaternion other, float epsilon) {
        return IsAlmostZeroKt.isAlmostEquals(this.x, other.x, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.y, other.y, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.z, other.z, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.w, other.w, epsilon);
    }

    @NotNull
    public final Quaternion interpolated(@NotNull Quaternion other, float t) {
        return Companion.interpolated(this, other, t);
    }

    @NotNull
    public final Quaternion interpolated-BdQlfBE(@NotNull Quaternion other, double t) {
        return Companion.interpolated(this, other, Ratio.toFloat-impl(t));
    }

    public final double angleTo-AmL7uXk(@NotNull Quaternion other) {
        return Companion.angleBetween-YNSfjqc(this, other);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    public final float component4() {
        return this.w;
    }

    @NotNull
    public final Quaternion copy(float x, float y, float z, float w) {
        return new Quaternion(x, y, z, w);
    }

    public static /* synthetic */ Quaternion copy$default(Quaternion quaternion, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = quaternion.x;
        }
        if ((n & 2) != 0) {
            f2 = quaternion.y;
        }
        if ((n & 4) != 0) {
            f3 = quaternion.z;
        }
        if ((n & 8) != 0) {
            f4 = quaternion.w;
        }
        return quaternion.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "Quaternion(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = result2 * 31 + Float.hashCode(this.y);
        result2 = result2 * 31 + Float.hashCode(this.z);
        result2 = result2 * 31 + Float.hashCode(this.w);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)other;
        if (Float.compare(this.x, quaternion.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, quaternion.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, quaternion.z) != 0) {
            return false;
        }
        return Float.compare(this.w, quaternion.w) == 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020$JN\u0010!\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eJ\u0016\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013J\u001d\u00101\u001a\u00020\u00042\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u000e03H\u0086\bJQ\u00101\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000426\u00101\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u000e05H\u0086\bJ\u001e\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u000eJ\u0018\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00132\b\b\u0002\u0010>\u001a\u00020\u0013J\u001e\u0010?\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020@J\u001e\u0010A\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u000eJ:\u0010B\u001a\u00020\u001e2\u0006\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u000e2\b\b\u0002\u0010G\u001a\u00020H\u00f8\u0001\u0001\u00a2\u0006\u0004\bI\u0010JR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006K"}, d2={"Lkorlibs/math/geom/Quaternion$Companion;", "", "()V", "IDENTITY", "Lkorlibs/math/geom/Quaternion;", "getIDENTITY", "()Lkorlibs/math/geom/Quaternion;", "angleBetween", "Lkorlibs/math/geom/Angle;", "a", "b", "angleBetween-YNSfjqc", "(Lkorlibs/math/geom/Quaternion;Lkorlibs/math/geom/Quaternion;)D", "dotProduct", "", "l", "r", "fromAxisAngle", "axis", "Lkorlibs/math/geom/Vector3F;", "angle", "fromAxisAngle-iCR1u9g", "(Lkorlibs/math/geom/Vector3F;D)Lkorlibs/math/geom/Quaternion;", "fromEuler", "roll", "pitch", "yaw", "fromEuler-kZEIK3s", "(DDD)Lkorlibs/math/geom/Quaternion;", "e", "Lkorlibs/math/geom/EulerRotation;", "fromEuler-llqBCb4", "(Lkorlibs/math/geom/Vector4F;)Lkorlibs/math/geom/Quaternion;", "fromRotationMatrix", "m", "Lkorlibs/math/geom/Matrix3;", "Lkorlibs/math/geom/Matrix4;", "v00", "v10", "v20", "v01", "v11", "v21", "v02", "v12", "v22", "fromVectors", "from", "to", "func", "callback", "Lkotlin/Function1;", "", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "interpolated", "left", "right", "t", "lookRotation", "forward", "up", "nlerp", "", "slerp", "toEuler", "x", "y", "z", "w", "config", "Lkorlibs/math/geom/EulerRotation$Config;", "toEuler-2ez1ybA", "(FFFFI)Lkorlibs/math/geom/Vector4F;", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\nQuaternion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quaternion.kt\nkorlibs/math/geom/Quaternion$Companion\n+ 2 Angle.kt\nkorlibs/math/geom/AngleKt\n*L\n1#1,327:1\n156#1,6:328\n156#1,6:334\n155#1:340\n212#2:341\n211#2:342\n*S KotlinDebug\n*F\n+ 1 Quaternion.kt\nkorlibs/math/geom/Quaternion$Companion\n*L\n173#1:328,6\n181#1:334,6\n186#1:340\n229#1:341\n234#1:342\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Quaternion getIDENTITY() {
            return IDENTITY;
        }

        public final float dotProduct(@NotNull Quaternion l, @NotNull Quaternion r) {
            return l.getX() * r.getX() + l.getY() * r.getY() + l.getZ() * r.getZ() + l.getW() * r.getW();
        }

        public final double angleBetween-YNSfjqc(@NotNull Quaternion a, @NotNull Quaternion b) {
            float dot = this.dotProduct(a, b);
            return Angle.Companion.arcCosine-AmL7uXk((float)2 * (dot * dot) - 1.0f);
        }

        @NotNull
        public final Quaternion func(@NotNull Function1<? super Integer, Float> callback) {
            boolean $i$f$func = false;
            return new Quaternion(((Number)callback.invoke((Integer)0)).floatValue(), ((Number)callback.invoke((Integer)1)).floatValue(), ((Number)callback.invoke((Integer)2)).floatValue(), ((Number)callback.invoke((Integer)3)).floatValue());
        }

        @NotNull
        public final Quaternion func(@NotNull Quaternion l, @NotNull Quaternion r, @NotNull Function2<? super Float, ? super Float, Float> func2) {
            boolean $i$f$func = false;
            return new Quaternion(((Number)func2.invoke(Float.valueOf(l.getX()), Float.valueOf(r.getX()))).floatValue(), ((Number)func2.invoke(Float.valueOf(l.getY()), Float.valueOf(r.getY()))).floatValue(), ((Number)func2.invoke(Float.valueOf(l.getZ()), Float.valueOf(r.getZ()))).floatValue(), ((Number)func2.invoke(Float.valueOf(l.getW()), Float.valueOf(r.getW()))).floatValue());
        }

        @NotNull
        public final Quaternion slerp(@NotNull Quaternion left, @NotNull Quaternion right, float t) {
            float f;
            float r;
            Quaternion tleft = left.normalized();
            Quaternion tright = right.normalized();
            float dot = Companion.dotProduct(tleft, right);
            if (dot < 0.0f) {
                tright = tright.unaryMinus();
                dot = -dot;
            }
            if (dot > 0.99995f) {
                float f2;
                float r2;
                Companion this_$iv = this;
                boolean $i$f$func = false;
                float f3 = tright.getX();
                float l = tleft.getX();
                boolean bl = false;
                float f4 = l + t * (r2 - l);
                r2 = tright.getY();
                l = tleft.getY();
                float f5 = f4;
                bl = false;
                float f6 = l + t * (r2 - l);
                r2 = tright.getZ();
                l = tleft.getZ();
                bl = false;
                float f7 = l + t * (r2 - l);
                r2 = tright.getW();
                l = tleft.getW();
                bl = false;
                float f8 = f2 = l + t * (r2 - l);
                float f9 = f7;
                float f10 = f6;
                float f11 = f5;
                return new Quaternion(f11, f10, f9, f8);
            }
            float angle0 = (float)Math.acos(dot);
            float angle1 = angle0 * t;
            float s1 = (float)Math.sin(angle1) / (float)Math.sin(angle0);
            float s0 = (float)Math.cos(angle1) - dot * s1;
            Companion this_$iv = this;
            boolean $i$f$func = false;
            float f12 = tright.getX();
            float l = tleft.getX();
            boolean bl = false;
            float f13 = s0 * l + s1 * r;
            r = tright.getY();
            l = tleft.getY();
            float f14 = f13;
            bl = false;
            float f15 = s0 * l + s1 * r;
            r = tright.getZ();
            l = tleft.getZ();
            bl = false;
            float f16 = s0 * l + s1 * r;
            r = tright.getW();
            l = tleft.getW();
            bl = false;
            float f17 = f = s0 * l + s1 * r;
            float f18 = f16;
            float f19 = f15;
            float f20 = f14;
            return new Quaternion(f20, f19, f18, f17);
        }

        @NotNull
        public final Quaternion nlerp(@NotNull Quaternion left, @NotNull Quaternion right, double t) {
            float f;
            int sign = Companion.dotProduct(left, right) < 0.0f ? -1 : 1;
            Companion this_$iv = this;
            boolean $i$f$func = false;
            int it = 0;
            boolean bl = false;
            float f2 = (float)(((double)1.0f - t) * (double)left.get(it) + t * (double)right.get(it) * (double)sign);
            it = 1;
            float f3 = f2;
            bl = false;
            float f4 = (float)(((double)1.0f - t) * (double)left.get(it) + t * (double)right.get(it) * (double)sign);
            it = 2;
            bl = false;
            float f5 = (float)(((double)1.0f - t) * (double)left.get(it) + t * (double)right.get(it) * (double)sign);
            it = 3;
            bl = false;
            float f6 = f = (float)(((double)1.0f - t) * (double)left.get(it) + t * (double)right.get(it) * (double)sign);
            float f7 = f5;
            float f8 = f4;
            float f9 = f3;
            return new Quaternion(f9, f8, f7, f6).normalized();
        }

        @NotNull
        public final Quaternion interpolated(@NotNull Quaternion left, @NotNull Quaternion right, float t) {
            return this.slerp(left, right, t);
        }

        @NotNull
        public final Quaternion fromVectors(@NotNull Vector3F from, @NotNull Vector3F to) {
            Vector3F start2 = from.normalized();
            Vector3F dest = to.normalized();
            float dot = start2.dot(dest);
            if (dot < -0.9999999f) {
                Vector3F tmp = new Vector3F(start2.getY(), -start2.getX(), 0.0f).normalized();
                return new Quaternion(tmp.getX(), tmp.getY(), tmp.getZ(), 0.0f);
            }
            if (dot > 0.9999999f) {
                return new Quaternion();
            }
            float s = (float)Math.sqrt((1.0f + dot) * (float)2);
            float invs = 1.0f / s;
            Vector3F c = start2.cross(dest);
            return new Quaternion(c.getX() * invs, c.getY() * invs, c.getZ() * invs, s * 0.5f).normalized();
        }

        @NotNull
        public final Quaternion fromAxisAngle-iCR1u9g(@NotNull Vector3F axis, double angle) {
            Vector3F naxis = axis.normalized();
            double angle2 = Angle.div-AmL7uXk(angle, 2);
            Vector2D up$iv = Vector2D.Companion.getUP();
            boolean bl = false;
            double s = Angle.sine-impl(angle2, up$iv);
            up$iv = Vector2D.Companion.getUP();
            boolean bl2 = false;
            return new Quaternion((double)naxis.getX() * s, (double)naxis.getY() * s, (double)naxis.getZ() * s, Angle.cosine-impl(angle2, up$iv));
        }

        @NotNull
        public final Quaternion lookRotation(@NotNull Vector3F forward, @NotNull Vector3F up2) {
            Vector3F z = forward.normalized();
            Vector3F x = up2.normalized().cross(z).normalized();
            if (IsAlmostZeroKt.isAlmostZero(x.getLengthSquared())) {
                return Companion.fromVectors(Vector3F.Companion.getFORWARD(), z);
            }
            Vector3F y = z.cross(x);
            return this.fromRotationMatrix(Matrix3.Companion.fromColumns(x, y, z));
        }

        public static /* synthetic */ Quaternion lookRotation$default(Companion companion, Vector3F vector3F, Vector3F vector3F2, int n, Object object) {
            if ((n & 2) != 0) {
                vector3F2 = Vector3F.Companion.getUP();
            }
            return companion.lookRotation(vector3F, vector3F2);
        }

        @NotNull
        public final Quaternion fromRotationMatrix(@NotNull Matrix4 m) {
            return this.fromRotationMatrix(m.getV00(), m.getV10(), m.getV20(), m.getV01(), m.getV11(), m.getV21(), m.getV02(), m.getV12(), m.getV22());
        }

        @NotNull
        public final Quaternion fromRotationMatrix(@NotNull Matrix3 m) {
            return this.fromRotationMatrix(m.getV00(), m.getV10(), m.getV20(), m.getV01(), m.getV11(), m.getV21(), m.getV02(), m.getV12(), m.getV22());
        }

        @NotNull
        public final Quaternion fromRotationMatrix(float v00, float v10, float v20, float v01, float v11, float v21, float v02, float v12, float v22) {
            Quaternion quaternion;
            float t = v00 + v11 + v22;
            if (t >= 0.0f) {
                float s = 0.5f / (float)Math.sqrt(t + 1.0f);
                quaternion = new Quaternion((v21 - v12) * s, (v02 - v20) * s, (v10 - v01) * s, 0.25f / s);
            } else if (v00 > v11 && v00 > v22) {
                float s = 2.0f * (float)Math.sqrt(1.0f + v00 - v11 - v22);
                quaternion = new Quaternion(0.25f * s, (v01 + v10) / s, (v02 + v20) / s, (v21 - v12) / s);
            } else if (v11 > v22) {
                float s = 2.0f * (float)Math.sqrt(1.0f + v11 - v00 - v22);
                quaternion = new Quaternion((v01 + v10) / s, 0.25f * s, (v12 + v21) / s, (v02 - v20) / s);
            } else {
                float s = 2.0f * (float)Math.sqrt(1.0f + v22 - v00 - v11);
                quaternion = new Quaternion((v02 + v20) / s, (v12 + v21) / s, 0.25f * s, (v10 - v01) / s);
            }
            return quaternion;
        }

        @NotNull
        public final Quaternion fromEuler-llqBCb4(@NotNull Vector4F e) {
            return EulerRotation.toQuaternion-impl(e);
        }

        @NotNull
        public final Quaternion fromEuler-kZEIK3s(double roll, double pitch, double yaw) {
            return EulerRotation.toQuaternion-impl(EulerRotation.constructor-impl$default(roll, pitch, yaw, 0, 8, null));
        }

        @NotNull
        public final Vector4F toEuler-2ez1ybA(float x, float y, float z, float w, int config2) {
            return EulerRotation.Companion.fromQuaternion-2ez1ybA(x, y, z, w, config2);
        }

        public static /* synthetic */ Vector4F toEuler-2ez1ybA$default(Companion companion, float f, float f2, float f3, float f4, int n, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = EulerRotation.Config.Companion.getDEFAULT-r7tHrnw();
            }
            return companion.toEuler-2ez1ybA(f, f2, f3, f4, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

