/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.MathKt;
import korlibs.math.RoundDecimalPlacesKt;
import korlibs.math.ToIntegerConvertersKt;
import korlibs.math.annotations.KormaMutableApi;
import korlibs.math.geom.Anchor2D;
import korlibs.math.geom.Circle;
import korlibs.math.geom.Line2D;
import korlibs.math.geom.MRectangle;
import korlibs.math.geom.Margin;
import korlibs.math.geom.MarginInt;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.PointList;
import korlibs.math.geom.RectangleI;
import korlibs.math.geom.Size2D;
import korlibs.math.geom.SizeKt;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.Vector2F;
import korlibs.math.geom.Vector2I;
import korlibs.math.geom.VectorsDoubleKt;
import korlibs.math.geom.shape.Shape2D;
import korlibs.math.geom.vector.VectorPath;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u0099\u00012\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0002\u0099\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\n\u0010R\u001a\u00060\u0000j\u0002`!J\f\u0010S\u001a\u00060\u0000j\u0002`!H\u0007J\t\u0010T\u001a\u00020\u0004H\u00c6\u0003J\t\u0010U\u001a\u00020\u0004H\u00c6\u0003J\t\u0010V\u001a\u00020\u0004H\u00c6\u0003J\t\u0010W\u001a\u00020\u0004H\u00c6\u0003J\u0015\u0010X\u001a\u00020+2\n\u0010Y\u001a\u00060\u000fj\u0002`\u0010H\u0086\u0002J\u0011\u0010X\u001a\u00020+2\u0006\u0010Y\u001a\u00020ZH\u0086\u0002J\u0011\u0010X\u001a\u00020+2\u0006\u0010Y\u001a\u00020[H\u0086\u0002J\u0016\u0010X\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010X\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\\2\u0006\u0010\u0005\u001a\u00020\\J\u0016\u0010X\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020]2\u0006\u0010\u0005\u001a\u00020]J\u0014\u0010^\u001a\u00020+2\n\u0010_\u001a\u00060\u000fj\u0002`\u0010H\u0016J1\u0010`\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J2\u0010a\u001a\u00060\u0000j\u0002`!2\b\b\u0002\u00103\u001a\u00020\u00042\b\b\u0002\u0010@\u001a\u00020\u00042\b\b\u0002\u00109\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004J\u0014\u0010b\u001a\u00020\u00042\n\u0010_\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0015\u0010c\u001a\u00060\u0000j\u0002`!2\u0006\u0010d\u001a\u00020\u0004H\u0086\u0002J\u0015\u0010c\u001a\u00060\u0000j\u0002`!2\u0006\u0010d\u001a\u00020\\H\u0086\u0002J\u0015\u0010c\u001a\u00060\u0000j\u0002`!2\u0006\u0010d\u001a\u00020]H\u0086\u0002J\u0013\u0010e\u001a\u00020+2\b\u0010f\u001a\u0004\u0018\u00010gH\u00d6\u0003J\u0012\u0010h\u001a\u00060\u0000j\u0002`!2\u0006\u0010i\u001a\u00020jJ\n\u0010k\u001a\u00060\u0000j\u0002`!J\u0016\u0010l\u001a\u00060\u000fj\u0002`\u00102\n\u0010m\u001a\u00060nj\u0002`oJ\t\u0010p\u001a\u00020]H\u00d6\u0001J\u0019\u0010q\u001a\u00060\u0000j\u0002`!2\n\u0010Y\u001a\u00060\u0000j\u0002`!H\u0086\u0004J\u001d\u0010r\u001a\n\u0018\u00010\u0000j\u0004\u0018\u0001`!2\n\u0010Y\u001a\u00060\u0000j\u0002`!H\u0086\u0004J\u0015\u0010s\u001a\u00020+2\n\u0010Y\u001a\u00060\u0000j\u0002`!H\u0086\u0004J\u0015\u0010t\u001a\u00020+2\n\u0010Y\u001a\u00060\u0000j\u0002`!H\u0086\u0004J\u0015\u0010u\u001a\u00020+2\n\u0010Y\u001a\u00060\u0000j\u0002`!H\u0086\u0004J\u001c\u0010v\u001a\u00020+2\n\u0010f\u001a\u00060\u0000j\u0002`!2\u0006\u0010w\u001a\u00020\u0004H\u0016J\u0014\u0010x\u001a\u00020\u000f2\n\u0010_\u001a\u00060\u000fj\u0002`\u0010H\u0016J\n\u0010y\u001a\u00060\u0000j\u0002`!J\u0006\u0010z\u001a\u00020{J\u0018\u0010|\u001a\u00060\u000fj\u0002`\u00102\n\u0010_\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0012\u0010}\u001a\u00060\u0000j\u0002`!2\u0006\u0010~\u001a\u00020]J\n\u0010\u007f\u001a\u00060\u0000j\u0002`!J\u0016\u0010\u0080\u0001\u001a\u00060\u0000j\u0002`!2\u0006\u0010d\u001a\u00020\u0004H\u0086\u0002J\u0016\u0010\u0080\u0001\u001a\u00060\u0000j\u0002`!2\u0006\u0010d\u001a\u00020\\H\u0086\u0002J\u0016\u0010\u0080\u0001\u001a\u00060\u0000j\u0002`!2\u0006\u0010d\u001a\u00020]H\u0086\u0002J\u000b\u0010\u0081\u0001\u001a\u00060&j\u0002`'J\u000b\u0010\u0082\u0001\u001a\u00060&j\u0002`'J\u000b\u0010\u0083\u0001\u001a\u00060&j\u0002`'J\u000b\u0010\u0084\u0001\u001a\u00060&j\u0002`'J\u0016\u0010\u0085\u0001\u001a\u00030\u0086\u00012\n\b\u0002\u0010\u0087\u0001\u001a\u00030\u0086\u0001H\u0007J\n\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\b\u0010\u008a\u0001\u001a\u00030\u0089\u0001J\b\u0010\u008b\u0001\u001a\u00030\u0089\u0001J\b\u0010\u008c\u0001\u001a\u00030\u0089\u0001J\n\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0016J\u0015\u0010\u008f\u0001\u001a\u00060\u0000j\u0002`!2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001J\u0018\u0010\u0092\u0001\u001a\u00060\u0000j\u0002`!2\u000b\u0010\u0093\u0001\u001a\u00060\u000fj\u0002`\u0010J\u0015\u0010\u0094\u0001\u001a\u00060\u0000j\u0002`!2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001J\u0015\u0010\u0097\u0001\u001a\u00060\u0000j\u0002`!2\b\u0010\u0098\u0001\u001a\u00030\u0096\u0001R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0015\u0010\u000e\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0018\u0010\u0015\u001a\u00060\u000fj\u0002`\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u001a\u0010\u001c\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010\u000bR\u001e\u0010 \u001a\u00060\u0000j\u0002`!8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u001e\u001a\u0004\b#\u0010$R\u0015\u0010%\u001a\u00060&j\u0002`'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u0011\u0010-\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010,R\u0011\u0010.\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u0011\u0010/\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010,R\u0011\u00100\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010,R\u0011\u00101\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010,R\u0011\u00102\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010,R\u0011\u00103\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u000bR\u0014\u00105\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u000bR\u0015\u00107\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0012R\u0011\u00109\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u000bR\u0015\u0010;\u001a\u00060<j\u0002`=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u000bR\u0015\u0010B\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0012R\u0015\u0010D\u001a\u00060\u000fj\u0002`\u00108F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u000bR\u001a\u0010G\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bH\u0010\u001e\u001a\u0004\bI\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u000bR\u001a\u0010K\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bL\u0010\u001e\u001a\u0004\bM\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\u000bR\u001a\u0010O\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bP\u0010\u001e\u001a\u0004\bQ\u0010\u000b\u00a8\u0006\u009a\u0001"}, d2={"Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/shape/Shape2D;", "Lkorlibs/math/IsAlmostEquals;", "x", "", "y", "width", "height", "(DDDD)V", "area", "getArea", "()D", "bottom", "getBottom", "bottomLeft", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "getBottomLeft", "()Lkorlibs/math/geom/Vector2D;", "bottomRight", "getBottomRight", "center", "getCenter", "centerX", "getCenterX", "centerY", "getCenterY", "getHeight", "heightD", "getHeightD$annotations", "()V", "getHeightD", "immutable", "Lkorlibs/math/geom/Rectangle;", "getImmutable$annotations", "getImmutable", "()Lkorlibs/math/geom/RectangleD;", "int", "Lkorlibs/math/geom/RectangleI;", "Lkorlibs/math/geom/RectangleInt;", "getInt", "()Lkorlibs/math/geom/RectangleI;", "isEmpty", "", "()Z", "isInfinite", "isNIL", "isNaN", "isNotEmpty", "isNotNIL", "isZero", "left", "getLeft", "perimeter", "getPerimeter", "position", "getPosition", "right", "getRight", "size", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "getSize", "()Lkorlibs/math/geom/Size2D;", "top", "getTop", "topLeft", "getTopLeft", "topRight", "getTopRight", "getWidth", "widthD", "getWidthD$annotations", "getWidthD", "getX", "xD", "getXD$annotations", "getXD", "getY", "yD", "getYD$annotations", "getYD", "ceiled", "clone", "component1", "component2", "component3", "component4", "contains", "that", "Lkorlibs/math/geom/Vector2F;", "Lkorlibs/math/geom/Vector2I;", "", "", "containsPoint", "p", "copy", "copyBounds", "distance", "div", "scale", "equals", "other", "", "expanded", "border", "Lkorlibs/math/geom/MarginInt;", "floored", "getAnchoredPoint", "anchor", "Lkorlibs/math/geom/Anchor2D;", "Lkorlibs/math/geom/Anchor;", "hashCode", "intersection", "intersectionOrNull", "intersects", "intersectsX", "intersectsY", "isAlmostEquals", "epsilon", "normalVectorAt", "normalized", "outerCircle", "Lkorlibs/math/geom/Circle;", "projectedPoint", "roundDecimalPlaces", "places", "rounded", "times", "toInt", "toIntCeil", "toIntFloor", "toIntRound", "toMRectangle", "Lkorlibs/math/geom/MRectangle;", "out", "toString", "", "toStringBounds", "toStringCompat", "toStringSize", "toVectorPath", "Lkorlibs/math/geom/vector/VectorPath;", "transformed", "m", "Lkorlibs/math/geom/Matrix;", "translated", "delta", "with", "margin", "Lkorlibs/math/geom/Margin;", "without", "padding", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\nRectangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rectangle.kt\nkorlibs/math/geom/RectangleD\n+ 2 _MathGeom.shape.kt\nkorlibs/math/geom/shape/_MathGeom_shapeKt\n+ 3 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 4 Matrix.kt\nkorlibs/math/geom/Matrix\n*L\n1#1,389:1\n51#2:390\n43#3:391\n43#3:392\n43#3:393\n43#3:394\n43#3:395\n43#3:396\n65#4,4:397\n65#4,4:401\n65#4,4:405\n65#4,4:409\n*S KotlinDebug\n*F\n+ 1 Rectangle.kt\nkorlibs/math/geom/RectangleD\n*L\n116#1:390\n118#1:391\n120#1:392\n144#1:393\n145#1:394\n146#1:395\n147#1:396\n245#1:397,4\n246#1:401,4\n247#1:405,4\n248#1:409,4\n*E\n"})
public final class RectangleD
implements Shape2D,
IsAlmostEquals<RectangleD> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    @NotNull
    private static final RectangleD ZERO = Companion.invoke(0, 0, 0, 0);
    @NotNull
    private static final RectangleD INFINITE = Companion.invoke(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
    @NotNull
    private static final RectangleD NaN = Companion.invoke(Float.NaN, Float.NaN, 0.0f, 0.0f);

    public RectangleD(double x, double y, double width2, double height2) {
        this.x = x;
        this.y = y;
        this.width = width2;
        this.height = height2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    @NotNull
    public final RectangleI getInt() {
        return this.toInt();
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="this", imports={}))
    @NotNull
    public final RectangleD clone() {
        return this;
    }

    @NotNull
    public final RectangleD getImmutable() {
        return this;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="this", imports={}))
    public static /* synthetic */ void getImmutable$annotations() {
    }

    @NotNull
    public final Vector2D getPosition() {
        return new Vector2D(this.x, this.y);
    }

    @NotNull
    public final Size2D getSize() {
        return new Size2D(this.width, this.height);
    }

    public final double getXD() {
        return this.x;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="x", imports={}))
    public static /* synthetic */ void getXD$annotations() {
    }

    public final double getYD() {
        return this.y;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="y", imports={}))
    public static /* synthetic */ void getYD$annotations() {
    }

    public final double getWidthD() {
        return this.width;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="width", imports={}))
    public static /* synthetic */ void getWidthD$annotations() {
    }

    public final double getHeightD() {
        return this.height;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="height", imports={}))
    public static /* synthetic */ void getHeightD$annotations() {
    }

    public final boolean isZero() {
        return Intrinsics.areEqual(this, ZERO);
    }

    public final boolean isInfinite() {
        return Intrinsics.areEqual(this, INFINITE);
    }

    public final boolean isNaN() {
        return Double.isNaN(this.x);
    }

    public final boolean isNIL() {
        return this.isNaN();
    }

    public final boolean isNotNIL() {
        return !this.isNIL();
    }

    @Override
    public boolean isAlmostEquals(@NotNull RectangleD other, double epsilon) {
        return IsAlmostZeroKt.isAlmostEquals(this.x, other.x, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.y, other.y, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.width, other.width, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.height, other.height, epsilon);
    }

    @NotNull
    public final String toStringBounds() {
        return "Rectangle([" + StringExtKt.getNiceStr(this.getLeft()) + "," + StringExtKt.getNiceStr(this.getTop()) + "]-[" + StringExtKt.getNiceStr(this.getRight()) + "," + StringExtKt.getNiceStr(this.getBottom()) + "])";
    }

    @NotNull
    public final String toStringSize() {
        return "Rectangle([" + StringExtKt.getNiceStr(this.getLeft()) + "," + StringExtKt.getNiceStr(this.getTop()) + "],[" + StringExtKt.getNiceStr(this.width) + "," + StringExtKt.getNiceStr(this.height) + "])";
    }

    @NotNull
    public final String toStringCompat() {
        return "Rectangle(x=" + StringExtKt.getNiceStr(this.getLeft()) + ", y=" + StringExtKt.getNiceStr(this.getTop()) + ", w=" + StringExtKt.getNiceStr(this.width) + ", h=" + StringExtKt.getNiceStr(this.height) + ")";
    }

    @NotNull
    public String toString() {
        return this.isNIL() ? "null" : "Rectangle(x=" + StringExtKt.getNiceStr(this.x) + ", y=" + StringExtKt.getNiceStr(this.y) + ", width=" + StringExtKt.getNiceStr(this.width) + ", height=" + StringExtKt.getNiceStr(this.height) + ")";
    }

    @NotNull
    public final RectangleD times(double scale) {
        return new RectangleD(this.x * scale, this.y * scale, this.width * scale, this.height * scale);
    }

    @NotNull
    public final RectangleD times(float scale) {
        return this.times((double)scale);
    }

    @NotNull
    public final RectangleD times(int scale) {
        return this.times((double)scale);
    }

    @NotNull
    public final RectangleD div(double scale) {
        return new RectangleD(this.x / scale, this.y / scale, this.width / scale, this.height / scale);
    }

    @NotNull
    public final RectangleD div(float scale) {
        return this.div((double)scale);
    }

    @NotNull
    public final RectangleD div(int scale) {
        return this.div((double)scale);
    }

    public final boolean contains(@NotNull Vector2D that) {
        return this.contains(that.getX(), that.getY());
    }

    public final boolean contains(@NotNull Vector2F that) {
        return this.contains(that.getX(), that.getY());
    }

    public final boolean contains(@NotNull Vector2I that) {
        return this.contains(that.getX(), that.getY());
    }

    public final boolean contains(double x, double y) {
        return x >= this.getLeft() && x < this.getRight() && y >= this.getTop() && y < this.getBottom();
    }

    public final boolean contains(float x, float y) {
        return this.contains((double)x, (double)y);
    }

    public final boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Override
    public double getArea() {
        return this.width * this.height;
    }

    @Override
    public double getPerimeter() {
        return (this.width + this.height) * (double)2;
    }

    @Override
    public boolean containsPoint(@NotNull Vector2D p) {
        return p.getX() >= this.getLeft() && p.getX() < this.getRight() && p.getY() >= this.getTop() && p.getY() < this.getBottom();
    }

    @Override
    @NotNull
    public VectorPath toVectorPath() {
        VectorPath vectorPath;
        VectorPath out$iv = new VectorPath(null, null, null, false, 15, null);
        boolean $i$f$buildVectorPath = false;
        VectorPath $this$toVectorPath_u24lambda_u240 = vectorPath = out$iv;
        boolean bl = false;
        $this$toVectorPath_u24lambda_u240.rect(this);
        return vectorPath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double distance(@NotNull Vector2D p) {
        void this_$iv;
        Vector2D vector2D = p;
        Vector2D that$iv = this.getCenter();
        boolean $i$f$minus = false;
        Vector2D p2 = new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY());
        Vector2D b = new Vector2D(this.width * 0.5, this.height * 0.5);
        Vector2D this_$iv2 = p2.getAbsoluteValue();
        boolean $i$f$minus2 = false;
        Vector2D d = new Vector2D(this_$iv2.getX() - b.getX(), this_$iv2.getY() - b.getY());
        return VectorsDoubleKt.max(d, Vector2D.Companion.getZERO()).getLength() + Math.min(Math.max(d.getX(), d.getY()), 0.0);
    }

    @Override
    @NotNull
    public Vector2D normalVectorAt(@NotNull Vector2D p) {
        Vector2D pp = this.projectedPoint(p);
        double d = pp.getX();
        double x = d == this.getLeft() ? -1.0 : (d == this.getRight() ? 1.0 : 0.0);
        double d2 = pp.getY();
        double y = d2 == this.getTop() ? -1.0 : (d2 == this.getBottom() ? 1.0 : 0.0);
        return new Vector2D(x, y).getNormalized();
    }

    @Override
    @NotNull
    public Vector2D projectedPoint(@NotNull Vector2D p) {
        Vector2D p0 = new Line2D(this.getTopLeft(), this.getTopRight()).projectedPoint(p);
        Vector2D p1 = new Line2D(this.getTopRight(), this.getBottomRight()).projectedPoint(p);
        Vector2D p2 = new Line2D(this.getBottomRight(), this.getBottomLeft()).projectedPoint(p);
        Vector2D p3 = new Line2D(this.getBottomLeft(), this.getTopLeft()).projectedPoint(p);
        Vector2D this_$iv = p0;
        boolean $i$f$minus = false;
        double d0 = new Vector2D(this_$iv.getX() - p.getX(), this_$iv.getY() - p.getY()).getLengthSquared();
        Vector2D this_$iv2 = p1;
        boolean $i$f$minus2 = false;
        double d1 = new Vector2D(this_$iv2.getX() - p.getX(), this_$iv2.getY() - p.getY()).getLengthSquared();
        Vector2D this_$iv3 = p2;
        boolean $i$f$minus3 = false;
        double d2 = new Vector2D(this_$iv3.getX() - p.getX(), this_$iv3.getY() - p.getY()).getLengthSquared();
        Vector2D this_$iv4 = p3;
        boolean $i$f$minus4 = false;
        double d3 = new Vector2D(this_$iv4.getX() - p.getX(), this_$iv4.getY() - p.getY()).getLengthSquared();
        double dmin = MathKt.min(d0, d1, d2, d3);
        double d = dmin;
        return d == d0 ? p0 : (d == d1 ? p1 : (d == d2 ? p2 : (d == d3 ? p3 : p0)));
    }

    public final boolean isEmpty() {
        return this.width == 0.0 && this.height == 0.0;
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final double getLeft() {
        return this.x;
    }

    public final double getTop() {
        return this.y;
    }

    public final double getRight() {
        return this.x + this.width;
    }

    public final double getBottom() {
        return this.y + this.height;
    }

    @NotNull
    public final Vector2D getTopLeft() {
        return new Vector2D(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Vector2D getTopRight() {
        return new Vector2D(this.getRight(), this.getTop());
    }

    @NotNull
    public final Vector2D getBottomLeft() {
        return new Vector2D(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Vector2D getBottomRight() {
        return new Vector2D(this.getRight(), this.getBottom());
    }

    public final double getCenterX() {
        return (this.getRight() + this.getLeft()) * 0.5;
    }

    public final double getCenterY() {
        return (this.getBottom() + this.getTop()) * 0.5;
    }

    @Override
    @NotNull
    public Vector2D getCenter() {
        return new Vector2D(this.getCenterX(), this.getCenterY());
    }

    @NotNull
    public final Circle outerCircle() {
        double centerX = this.getCenterX();
        double centerY = this.getCenterY();
        return new Circle(this.getCenter(), Vector2D.Companion.distance(centerX, centerY, this.getRight(), this.getTop()));
    }

    @NotNull
    public final RectangleD without(@NotNull Margin padding) {
        return Companion.fromBounds(this.getLeft() + padding.getLeft(), this.getTop() + padding.getTop(), this.getRight() - padding.getRight(), this.getBottom() - padding.getBottom());
    }

    @NotNull
    public final RectangleD with(@NotNull Margin margin) {
        return Companion.fromBounds(this.getLeft() - margin.getLeft(), this.getTop() - margin.getTop(), this.getRight() + margin.getRight(), this.getBottom() + margin.getBottom());
    }

    public final boolean intersects(@NotNull RectangleD that) {
        return this.intersectsX(that) && this.intersectsY(that);
    }

    public final boolean intersectsX(@NotNull RectangleD that) {
        return that.getLeft() <= this.getRight() && that.getRight() >= this.getLeft();
    }

    public final boolean intersectsY(@NotNull RectangleD that) {
        return that.getTop() <= this.getBottom() && that.getBottom() >= this.getTop();
    }

    @Nullable
    public final RectangleD intersectionOrNull(@NotNull RectangleD that) {
        return this.intersects(that) ? new RectangleD(Math.max(this.getLeft(), that.getLeft()), Math.max(this.getTop(), that.getTop()), Math.min(this.getRight(), that.getRight()), Math.min(this.getBottom(), that.getBottom())) : null;
    }

    @NotNull
    public final RectangleD intersection(@NotNull RectangleD that) {
        return this.intersects(that) ? new RectangleD(Math.max(this.getLeft(), that.getLeft()), Math.max(this.getTop(), that.getTop()), Math.min(this.getRight(), that.getRight()), Math.min(this.getBottom(), that.getBottom())) : Companion.getNIL();
    }

    @NotNull
    public final RectangleI toInt() {
        return new RectangleI((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    @NotNull
    public final RectangleI toIntRound() {
        return new RectangleI(ToIntegerConvertersKt.toIntRound(this.x), ToIntegerConvertersKt.toIntRound(this.y), ToIntegerConvertersKt.toIntRound(this.width), ToIntegerConvertersKt.toIntRound(this.height));
    }

    @NotNull
    public final RectangleI toIntCeil() {
        return new RectangleI(ToIntegerConvertersKt.toIntCeil(this.x), ToIntegerConvertersKt.toIntCeil(this.y), ToIntegerConvertersKt.toIntCeil(this.width), ToIntegerConvertersKt.toIntCeil(this.height));
    }

    @NotNull
    public final RectangleI toIntFloor() {
        return new RectangleI(ToIntegerConvertersKt.toIntFloor(this.x), ToIntegerConvertersKt.toIntFloor(this.y), ToIntegerConvertersKt.toIntFloor(this.width), ToIntegerConvertersKt.toIntFloor(this.height));
    }

    @NotNull
    public final Vector2D getAnchoredPoint(@NotNull Anchor2D anchor) {
        return new Vector2D(this.getLeft() + this.width * anchor.getSx(), this.getTop() + this.height * anchor.getSy());
    }

    @Deprecated(message="")
    @KormaMutableApi
    @NotNull
    public final MRectangle toMRectangle(@NotNull MRectangle out) {
        return out.setTo(this.x, this.y, this.width, this.height);
    }

    public static /* synthetic */ MRectangle toMRectangle$default(RectangleD rectangleD, MRectangle mRectangle, int n, Object object) {
        if ((n & 1) != 0) {
            mRectangle = MRectangle.Companion.invoke();
        }
        return rectangleD.toMRectangle(mRectangle);
    }

    @NotNull
    public final RectangleD expanded(@NotNull MarginInt border) {
        return Companion.fromBounds(this.getLeft() - (double)border.getLeft(), this.getTop() - (double)border.getTop(), this.getRight() + (double)border.getRight(), this.getBottom() + (double)border.getBottom());
    }

    @NotNull
    public final RectangleD copyBounds(double left, double top, double right, double bottom) {
        return Companion.fromBounds(left, top, right, bottom);
    }

    public static /* synthetic */ RectangleD copyBounds$default(RectangleD rectangleD, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = rectangleD.getLeft();
        }
        if ((n & 2) != 0) {
            d2 = rectangleD.getTop();
        }
        if ((n & 4) != 0) {
            d3 = rectangleD.getRight();
        }
        if ((n & 8) != 0) {
            d4 = rectangleD.getBottom();
        }
        return rectangleD.copyBounds(d, d2, d3, d4);
    }

    @NotNull
    public final RectangleD translated(@NotNull Vector2D delta) {
        return RectangleD.copy$default(this, this.x + delta.getX(), this.y + delta.getY(), 0.0, 0.0, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RectangleD transformed(@NotNull Matrix m) {
        void this_$iv;
        void this_$iv2;
        void this_$iv3;
        void this_$iv4;
        Matrix matrix2 = m;
        IsAlmostEquals<Vector2D> p$iv = this.getTopLeft();
        boolean $i$f$transform = false;
        Vector2D tl = this_$iv4.isNIL() ? p$iv : new Vector2D(this_$iv4.transformX(((Vector2D)p$iv).getX(), ((Vector2D)p$iv).getY()), this_$iv4.transformY(((Vector2D)p$iv).getX(), ((Vector2D)p$iv).getY()));
        p$iv = m;
        IsAlmostEquals<Vector2D> p$iv2 = this.getTopRight();
        boolean $i$f$transform2 = false;
        Vector2D tr = this_$iv3.isNIL() ? p$iv2 : new Vector2D(this_$iv3.transformX(((Vector2D)p$iv2).getX(), ((Vector2D)p$iv2).getY()), this_$iv3.transformY(((Vector2D)p$iv2).getX(), ((Vector2D)p$iv2).getY()));
        p$iv2 = m;
        IsAlmostEquals<Vector2D> p$iv3 = this.getBottomLeft();
        boolean $i$f$transform3 = false;
        Vector2D bl = this_$iv2.isNIL() ? p$iv3 : new Vector2D(this_$iv2.transformX(((Vector2D)p$iv3).getX(), ((Vector2D)p$iv3).getY()), this_$iv2.transformY(((Vector2D)p$iv3).getX(), ((Vector2D)p$iv3).getY()));
        p$iv3 = m;
        Vector2D p$iv4 = this.getBottomRight();
        boolean $i$f$transform4 = false;
        Vector2D br2 = this_$iv.isNIL() ? p$iv4 : new Vector2D(this_$iv.transformX(p$iv4.getX(), p$iv4.getY()), this_$iv.transformY(p$iv4.getX(), p$iv4.getY()));
        Vector2D min = Vector2D.Companion.minComponents(tl, tr, bl, br2);
        Vector2D max = Vector2D.Companion.maxComponents(tl, tr, bl, br2);
        return Companion.fromBounds(min, max);
    }

    @NotNull
    public final RectangleD normalized() {
        return Companion.fromBounds(Vector2D.Companion.minComponents(this.getTopLeft(), this.getBottomRight()), Vector2D.Companion.maxComponents(this.getTopLeft(), this.getBottomRight()));
    }

    @NotNull
    public final RectangleD roundDecimalPlaces(int places) {
        return new RectangleD(RoundDecimalPlacesKt.roundDecimalPlaces(this.x, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.y, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.width, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.height, places));
    }

    @NotNull
    public final RectangleD rounded() {
        return new RectangleD(Math.rint(this.x), Math.rint(this.y), Math.rint(this.width), Math.rint(this.height));
    }

    @NotNull
    public final RectangleD floored() {
        return new RectangleD(Math.floor(this.x), Math.floor(this.y), Math.floor(this.width), Math.floor(this.height));
    }

    @NotNull
    public final RectangleD ceiled() {
        return new RectangleD(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.width), Math.ceil(this.height));
    }

    @Override
    @Deprecated(message="Untested yet")
    public boolean containsPoint(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.containsPoint(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    public double distance(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.distance(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D normalVectorAt(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.normalVectorAt(this, ml, p, mr);
    }

    @Override
    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D projectedPoint(@NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.projectedPoint(this, ml, p, mr);
    }

    @Override
    public boolean getClosed() {
        return Shape2D.DefaultImpls.getClosed(this);
    }

    @Override
    @NotNull
    public RectangleD getBounds() {
        return Shape2D.DefaultImpls.getBounds(this);
    }

    @Override
    @NotNull
    public PointList intersectionsWith(@NotNull Shape2D that) {
        return Shape2D.DefaultImpls.intersectionsWith(this, that);
    }

    @Override
    @NotNull
    public PointList intersectionsWith(@NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.intersectionsWith(this, ml, that, mr);
    }

    @Override
    public boolean intersectsWith(@NotNull Shape2D that) {
        return Shape2D.DefaultImpls.intersectsWith(this, that);
    }

    @Override
    public boolean intersectsWith(@NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
        return Shape2D.DefaultImpls.intersectsWith(this, ml, that, mr);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.width;
    }

    public final double component4() {
        return this.height;
    }

    @NotNull
    public final RectangleD copy(double x, double y, double width2, double height2) {
        return new RectangleD(x, y, width2, height2);
    }

    public static /* synthetic */ RectangleD copy$default(RectangleD rectangleD, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = rectangleD.x;
        }
        if ((n & 2) != 0) {
            d2 = rectangleD.y;
        }
        if ((n & 4) != 0) {
            d3 = rectangleD.width;
        }
        if ((n & 8) != 0) {
            d4 = rectangleD.height;
        }
        return rectangleD.copy(d, d2, d3, d4);
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.y);
        result2 = result2 * 31 + Double.hashCode(this.width);
        result2 = result2 * 31 + Double.hashCode(this.height);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RectangleD)) {
            return false;
        }
        RectangleD rectangleD = (RectangleD)other;
        if (Double.compare(this.x, rectangleD.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, rectangleD.y) != 0) {
            return false;
        }
        if (Double.compare(this.width, rectangleD.width) != 0) {
            return false;
        }
        return Double.compare(this.height, rectangleD.height) == 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011J*\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014J*\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0019J-\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001aH\u0086\bJ4\u0010\u001b\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u001c\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u001d\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u001e\u001a\u00020\u001f\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00060\u0004j\u0002`\u0005H\u0086\u0002J%\u0010\"\u001a\u00060\u0004j\u0002`\u00052\n\u0010#\u001a\u00060\u0010j\u0002`\u00112\n\u0010$\u001a\u00060%j\u0002`&H\u0086\u0002J-\u0010\"\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0086\u0002J-\u0010\"\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0018H\u0086\u0002J-\u0010\"\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0019H\u0086\u0002J-\u0010\"\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001aH\u0086\nJ\u001e\u0010+\u001a\u00020,2\n\u0010\u001c\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u001d\u001a\u00060\u0004j\u0002`\u0005R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u00060\u0004j\u0002`\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0015\u0010\n\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0015\u0010\f\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006-"}, d2={"Lkorlibs/math/geom/RectangleD$Companion;", "", "()V", "INFINITE", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "getINFINITE", "()Lkorlibs/math/geom/RectangleD;", "NIL", "getNIL", "NaN", "getNaN", "ZERO", "getZERO", "fromBounds", "point1", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "point2", "left", "", "top", "right", "bottom", "", "", "", "interpolated", "a", "b", "ratio", "Lkorlibs/math/interpolation/Ratio;", "interpolated-i056VXE", "(Lkorlibs/math/geom/RectangleD;Lkorlibs/math/geom/RectangleD;D)Lkorlibs/math/geom/RectangleD;", "invoke", "p", "s", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "x", "y", "width", "height", "isContainedIn", "", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\nRectangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rectangle.kt\nkorlibs/math/geom/RectangleD$Companion\n+ 2 VectorsDouble.kt\nkorlibs/math/geom/Vector2D$Companion\n+ 3 Size.kt\nkorlibs/math/geom/Size2D$Companion\n+ 4 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n*L\n1#1,389:1\n161#2:390\n18#3:391\n43#4:392\n*S KotlinDebug\n*F\n+ 1 Rectangle.kt\nkorlibs/math/geom/RectangleD$Companion\n*L\n79#1:390\n79#1:391\n84#1:392\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RectangleD getZERO() {
            return ZERO;
        }

        @NotNull
        public final RectangleD getINFINITE() {
            return INFINITE;
        }

        @NotNull
        public final RectangleD getNaN() {
            return NaN;
        }

        @NotNull
        public final RectangleD getNIL() {
            return this.getNaN();
        }

        @NotNull
        public final RectangleD invoke() {
            return this.getZERO();
        }

        @NotNull
        public final RectangleD invoke(@NotNull Vector2D p, @NotNull Size2D s) {
            return new RectangleD(p.getX(), p.getY(), s.getWidth(), s.getHeight());
        }

        @NotNull
        public final RectangleD invoke(int x, int y, int width2, int height2) {
            return Companion.invoke(new Vector2D(x, y), new Size2D(width2, height2));
        }

        @NotNull
        public final RectangleD invoke(float x, float y, float width2, float height2) {
            return Companion.invoke(new Vector2D(x, y), new Size2D(width2, height2));
        }

        @NotNull
        public final RectangleD invoke(double x, double y, double width2, double height2) {
            return Companion.invoke(new Vector2D(x, y), new Size2D(width2, height2));
        }

        @NotNull
        public final RectangleD invoke(@NotNull Number x, @NotNull Number y, @NotNull Number width2, @NotNull Number height2) {
            boolean $i$f$invoke = false;
            Object this_$iv = Vector2D.Companion;
            boolean $i$f$invoke2 = false;
            this_$iv = Size2D.Companion;
            $i$f$invoke2 = false;
            return Companion.invoke(new Vector2D(x.doubleValue(), y.doubleValue()), new Size2D(width2.doubleValue(), height2.doubleValue()));
        }

        @NotNull
        public final RectangleD fromBounds(double left, double top, double right, double bottom) {
            return new RectangleD(left, top, right - left, bottom - top);
        }

        @NotNull
        public final RectangleD fromBounds(int left, int top, int right, int bottom) {
            return this.fromBounds((double)left, (double)top, (double)right, (double)bottom);
        }

        @NotNull
        public final RectangleD fromBounds(float left, float top, float right, float bottom) {
            return this.fromBounds((double)left, (double)top, (double)right, (double)bottom);
        }

        @NotNull
        public final RectangleD fromBounds(@NotNull Vector2D point1, @NotNull Vector2D point2) {
            Vector2D this_$iv = point2;
            boolean $i$f$minus = false;
            return Companion.invoke(point1, SizeKt.toSize(new Vector2D(this_$iv.getX() - point1.getX(), this_$iv.getY() - point1.getY())));
        }

        @NotNull
        public final RectangleD fromBounds(@NotNull Number left, @NotNull Number top, @NotNull Number right, @NotNull Number bottom) {
            boolean $i$f$fromBounds = false;
            return this.fromBounds(left.doubleValue(), top.doubleValue(), right.doubleValue(), bottom.doubleValue());
        }

        public final boolean isContainedIn(@NotNull RectangleD a, @NotNull RectangleD b) {
            return a.getX() >= b.getX() && a.getY() >= b.getY() && a.getX() + a.getWidth() <= b.getX() + b.getWidth() && a.getY() + a.getHeight() <= b.getY() + b.getHeight();
        }

        @NotNull
        public final RectangleD interpolated-i056VXE(@NotNull RectangleD a, @NotNull RectangleD b, double ratio2) {
            return Companion.fromBounds(_Math_interpolationKt.interpolate-aphylw4(ratio2, a.getLeft(), b.getLeft()), _Math_interpolationKt.interpolate-aphylw4(ratio2, a.getTop(), b.getTop()), _Math_interpolationKt.interpolate-aphylw4(ratio2, a.getRight(), b.getRight()), _Math_interpolationKt.interpolate-aphylw4(ratio2, a.getBottom(), b.getBottom()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

