/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.geom.MarginInt;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.SizeInt;
import korlibs.math.geom.SizeKt;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.Vector2I;
import korlibs.math.geom.VectorsIntKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 S2\u00020\u0001:\u0001SB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\t\u00108\u001a\u00020\tH\u00c6\u0003J\t\u00109\u001a\u00020\tH\u00c6\u0003J\t\u0010:\u001a\u00020\tH\u00c6\u0003J\t\u0010;\u001a\u00020\tH\u00c6\u0003J\u0015\u0010<\u001a\u00020%2\n\u0010=\u001a\u00060>j\u0002`?H\u0086\u0002J\u0011\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020\u0004H\u0086\u0002J\u0016\u0010<\u001a\u00020%2\u0006\u0010\b\u001a\u00020@2\u0006\u0010\n\u001a\u00020@J\u0016\u0010<\u001a\u00020%2\u0006\u0010\b\u001a\u00020A2\u0006\u0010\n\u001a\u00020AJ\u0016\u0010<\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ1\u0010B\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\tH\u00c6\u0001J\u0015\u0010C\u001a\u00060\u0000j\u0002`D2\u0006\u0010E\u001a\u00020@H\u0086\u0002J\u0015\u0010C\u001a\u00060\u0000j\u0002`D2\u0006\u0010E\u001a\u00020AH\u0086\u0002J\u0015\u0010C\u001a\u00060\u0000j\u0002`D2\u0006\u0010E\u001a\u00020\tH\u0086\u0002J\u0013\u0010F\u001a\u00020%2\b\u0010G\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0012\u0010H\u001a\u00060\u0000j\u0002`D2\u0006\u0010I\u001a\u00020JJ\t\u0010K\u001a\u00020\tH\u00d6\u0001J4\u0010L\u001a\u00060\u0000j\u0002`D2\u0006\u0010(\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010M\u001a\u00020%J4\u0010N\u001a\u00060\u0000j\u0002`D2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010M\u001a\u00020%J\u0015\u0010O\u001a\u00060\u0000j\u0002`D2\u0006\u0010E\u001a\u00020@H\u0086\u0002J\u0015\u0010O\u001a\u00060\u0000j\u0002`D2\u0006\u0010E\u001a\u00020AH\u0086\u0002J\u0015\u0010O\u001a\u00060\u0000j\u0002`D2\u0006\u0010E\u001a\u00020\tH\u0086\u0002J\n\u0010P\u001a\u00060\u001fj\u0002` J\b\u0010Q\u001a\u00020RH\u0016R\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u0015\u0010\u001e\u001a\u00060\u001fj\u0002` 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0011\u0010'\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0011\u0010(\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0015R\u0011\u0010+\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0010R\u0011\u00101\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0015R\u0011\u00103\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0010R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0010\u00a8\u0006T"}, d2={"Lkorlibs/math/geom/RectangleI;", "", "()V", "position", "Lkorlibs/math/geom/Vector2I;", "size", "Lkorlibs/math/geom/SizeInt;", "(Lkorlibs/math/geom/Vector2I;Lkorlibs/math/geom/SizeInt;)V", "x", "", "y", "width", "height", "(IIII)V", "area", "getArea", "()I", "bottom", "getBottom", "bottomLeft", "getBottomLeft", "()Lkorlibs/math/geom/Vector2I;", "bottomRight", "getBottomRight", "center", "getCenter", "centerX", "getCenterX", "centerY", "getCenterY", "float", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "getFloat", "()Lkorlibs/math/geom/RectangleD;", "getHeight", "isEmpty", "", "()Z", "isNotEmpty", "left", "getLeft", "getPosition", "right", "getRight", "getSize", "()Lkorlibs/math/geom/SizeInt;", "top", "getTop", "topLeft", "getTopLeft", "topRight", "getTopRight", "getWidth", "getX", "getY", "component1", "component2", "component3", "component4", "contains", "that", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "", "", "copy", "div", "Lkorlibs/math/geom/RectangleInt;", "scale", "equals", "other", "expanded", "border", "Lkorlibs/math/geom/MarginInt;", "hashCode", "sliceWithBounds", "clamped", "sliceWithSize", "times", "toFloat", "toString", "", "Companion", "korge-foundation"})
public final class RectangleI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public RectangleI(int x, int y, int width2, int height2) {
        this.x = x;
        this.y = y;
        this.width = width2;
        this.height = height2;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final RectangleD getFloat() {
        return RectangleD.Companion.invoke(this.x, this.y, this.width, this.height);
    }

    @NotNull
    public final Vector2I getPosition() {
        return new Vector2I(this.x, this.y);
    }

    @NotNull
    public final SizeInt getSize() {
        return new SizeInt(this.width, this.height);
    }

    public final int getArea() {
        return this.width * this.height;
    }

    public final boolean isEmpty() {
        return this.width == 0 && this.height == 0;
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final int getLeft() {
        return this.x;
    }

    public final int getTop() {
        return this.y;
    }

    public final int getRight() {
        return this.x + this.width;
    }

    public final int getBottom() {
        return this.y + this.height;
    }

    @NotNull
    public final Vector2I getTopLeft() {
        return new Vector2I(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Vector2I getTopRight() {
        return new Vector2I(this.getRight(), this.getTop());
    }

    @NotNull
    public final Vector2I getBottomLeft() {
        return new Vector2I(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Vector2I getBottomRight() {
        return new Vector2I(this.getRight(), this.getBottom());
    }

    public final int getCenterX() {
        return (int)((float)(this.getRight() + this.getLeft()) * 0.5f);
    }

    public final int getCenterY() {
        return (int)((float)(this.getBottom() + this.getTop()) * 0.5f);
    }

    @NotNull
    public final Vector2I getCenter() {
        return new Vector2I(this.getCenterX(), this.getCenterY());
    }

    @NotNull
    public final RectangleD toFloat() {
        return RectangleD.Companion.invoke(VectorsIntKt.toDouble(this.getPosition()), SizeKt.toDouble(this.getSize()));
    }

    @NotNull
    public final RectangleI times(double scale) {
        return new RectangleI((int)((double)this.x * scale), (int)((double)this.y * scale), (int)((double)this.width * scale), (int)((double)this.height * scale));
    }

    @NotNull
    public final RectangleI times(float scale) {
        return this.times((double)scale);
    }

    @NotNull
    public final RectangleI times(int scale) {
        return this.times((double)scale);
    }

    @NotNull
    public final RectangleI div(float scale) {
        return new RectangleI((int)((float)this.x / scale), (int)((float)this.y / scale), (int)((float)this.width / scale), (int)((float)this.height / scale));
    }

    @NotNull
    public final RectangleI div(double scale) {
        return this.div((float)scale);
    }

    @NotNull
    public final RectangleI div(int scale) {
        return this.div((float)scale);
    }

    public final boolean contains(@NotNull Vector2D that) {
        return this.contains(that.getX(), that.getY());
    }

    public final boolean contains(@NotNull Vector2I that) {
        return this.contains(that.getX(), that.getY());
    }

    public final boolean contains(float x, float y) {
        return x >= (float)this.getLeft() && x < (float)this.getRight() && y >= (float)this.getTop() && y < (float)this.getBottom();
    }

    public final boolean contains(double x, double y) {
        return this.contains((float)x, (float)y);
    }

    public final boolean contains(int x, int y) {
        return this.contains((float)x, (float)y);
    }

    public RectangleI() {
        this(new Vector2I(), new SizeInt());
    }

    public RectangleI(@NotNull Vector2I position, @NotNull SizeInt size2) {
        this(position.getX(), position.getY(), size2.getWidth(), size2.getHeight());
    }

    @NotNull
    public final RectangleI sliceWithBounds(int left, int top, int right, int bottom, boolean clamped2) {
        int left2 = !clamped2 ? left : RangesKt.coerceIn(left, 0, this.width);
        int right2 = !clamped2 ? right : RangesKt.coerceIn(right, 0, this.width);
        int top2 = !clamped2 ? top : RangesKt.coerceIn(top, 0, this.height);
        int bottom2 = !clamped2 ? bottom : RangesKt.coerceIn(bottom, 0, this.height);
        return Companion.fromBounds(this.x + left2, this.y + top2, this.x + right2, this.y + bottom2);
    }

    public static /* synthetic */ RectangleI sliceWithBounds$default(RectangleI rectangleI, int n, int n2, int n3, int n4, boolean bl, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            bl = true;
        }
        return rectangleI.sliceWithBounds(n, n2, n3, n4, bl);
    }

    @NotNull
    public final RectangleI sliceWithSize(int x, int y, int width2, int height2, boolean clamped2) {
        return this.sliceWithBounds(x, y, x + width2, y + height2, clamped2);
    }

    public static /* synthetic */ RectangleI sliceWithSize$default(RectangleI rectangleI, int n, int n2, int n3, int n4, boolean bl, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            bl = true;
        }
        return rectangleI.sliceWithSize(n, n2, n3, n4, bl);
    }

    @NotNull
    public final RectangleI expanded(@NotNull MarginInt border) {
        return Companion.fromBounds(this.getLeft() - border.getLeft(), this.getTop() - border.getTop(), this.getRight() + border.getRight(), this.getBottom() + border.getBottom());
    }

    @NotNull
    public String toString() {
        return "Rectangle(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @NotNull
    public final RectangleI copy(int x, int y, int width2, int height2) {
        return new RectangleI(x, y, width2, height2);
    }

    public static /* synthetic */ RectangleI copy$default(RectangleI rectangleI, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = rectangleI.x;
        }
        if ((n5 & 2) != 0) {
            n2 = rectangleI.y;
        }
        if ((n5 & 4) != 0) {
            n3 = rectangleI.width;
        }
        if ((n5 & 8) != 0) {
            n4 = rectangleI.height;
        }
        return rectangleI.copy(n, n2, n3, n4);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.x);
        result2 = result2 * 31 + Integer.hashCode(this.y);
        result2 = result2 * 31 + Integer.hashCode(this.width);
        result2 = result2 * 31 + Integer.hashCode(this.height);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RectangleI)) {
            return false;
        }
        RectangleI rectangleI = (RectangleI)other;
        if (this.x != rectangleI.x) {
            return false;
        }
        if (this.y != rectangleI.y) {
            return false;
        }
        if (this.width != rectangleI.width) {
            return false;
        }
        return this.height == rectangleI.height;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J*\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ\"\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u000f\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0010\u001a\u00060\u0004j\u0002`\u0005\u00a8\u0006\u0011"}, d2={"Lkorlibs/math/geom/RectangleI$Companion;", "", "()V", "fromBounds", "Lkorlibs/math/geom/RectangleI;", "Lkorlibs/math/geom/RectangleInt;", "topLeft", "Lkorlibs/math/geom/Vector2I;", "bottomRight", "left", "", "top", "right", "bottom", "union", "a", "b", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RectangleI union(@NotNull RectangleI a, @NotNull RectangleI b) {
            return this.fromBounds(Math.min(a.getLeft(), b.getLeft()), Math.min(a.getTop(), b.getTop()), Math.max(a.getRight(), b.getRight()), Math.max(a.getBottom(), b.getBottom()));
        }

        @NotNull
        public final RectangleI fromBounds(@NotNull Vector2I topLeft, @NotNull Vector2I bottomRight) {
            return new RectangleI(topLeft, SizeKt.toSize(bottomRight.minus(topLeft)));
        }

        @NotNull
        public final RectangleI fromBounds(int left, int top, int right, int bottom) {
            return this.fromBounds(new Vector2I(left, top), new Vector2I(right, bottom));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

