/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.geom.Scale;
import korlibs.math.geom.Vector2F;
import korlibs.number.StringExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\tJ\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\tH\u00c6\u0001J\u0015\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0000j\u0002`\u0019H\u0086\u0002J\u0015\u0010\u0016\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0086\u0002J\u0015\u0010\u0016\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002J\u0015\u0010\u0016\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0086\u0002J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\tJ\u0019\u0010!\u001a\u00060\u0000j\u0002`\u00192\n\u0010\u0018\u001a\u00060\u0000j\u0002`\u0019H\u0086\u0002J\u0019\u0010\"\u001a\u00060\u0000j\u0002`\u00192\n\u0010\u0018\u001a\u00060\u0000j\u0002`\u0019H\u0086\u0002J\u0015\u0010#\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010$\u001a\u00020\u0017H\u0086\u0002J\u0015\u0010#\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010$\u001a\u00020%H\u0086\u0002J\u0015\u0010#\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0086\u0002J\u0015\u0010#\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002J\u0015\u0010#\u001a\u00060\u0000j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0086\u0002J\b\u0010&\u001a\u00020'H\u0016J\r\u0010(\u001a\u00060\u0000j\u0002`\u0019H\u0086\u0002J\r\u0010)\u001a\u00060\u0000j\u0002`\u0019H\u0086\u0002R\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0003\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006+"}, d2={"Lkorlibs/math/geom/Size2D;", "", "()V", "width", "", "height", "(FF)V", "", "(II)V", "", "(DD)V", "area", "getArea", "()D", "getHeight", "perimeter", "getPerimeter", "getWidth", "avgComponent", "component1", "component2", "copy", "div", "Lkorlibs/math/geom/Scale;", "other", "Lkorlibs/math/geom/Size;", "s", "equals", "", "hashCode", "isEmpty", "maxComponent", "minComponent", "minus", "plus", "times", "scale", "Lkorlibs/math/geom/Vector2F;", "toString", "", "unaryMinus", "unaryPlus", "Companion", "korge-foundation"})
public final class Size2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double width;
    private final double height;
    @NotNull
    private static final Size2D ZERO = new Size2D(0.0, 0.0);

    public Size2D(double width2, double height2) {
        this.width = width2;
        this.height = height2;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final boolean isEmpty() {
        return this.width == 0.0 || this.height == 0.0;
    }

    public final double avgComponent() {
        return this.width * 0.5 + this.height * 0.5;
    }

    public final double minComponent() {
        return Math.min(this.width, this.height);
    }

    public final double maxComponent() {
        return Math.max(this.width, this.height);
    }

    public final double getArea() {
        return this.width * this.height;
    }

    public final double getPerimeter() {
        return this.width * (double)2 + this.height * (double)2;
    }

    public Size2D() {
        this(0.0, 0.0);
    }

    public Size2D(float width2, float height2) {
        this((double)width2, (double)height2);
    }

    public Size2D(int width2, int height2) {
        this((double)width2, (double)height2);
    }

    @NotNull
    public final Size2D unaryMinus() {
        return new Size2D(-this.width, -this.height);
    }

    @NotNull
    public final Size2D unaryPlus() {
        return this;
    }

    @NotNull
    public final Size2D minus(@NotNull Size2D other) {
        return new Size2D(this.width - other.width, this.height - other.height);
    }

    @NotNull
    public final Size2D plus(@NotNull Size2D other) {
        return new Size2D(this.width + other.width, this.height + other.height);
    }

    @NotNull
    public final Size2D times(@NotNull Scale scale) {
        return new Size2D(this.width * scale.getScaleX(), this.height * scale.getScaleY());
    }

    @NotNull
    public final Size2D times(@NotNull Vector2F scale) {
        return new Size2D(this.width * (double)scale.getX(), this.height * (double)scale.getY());
    }

    @NotNull
    public final Size2D times(float s) {
        return new Size2D(this.width * (double)s, this.height * (double)s);
    }

    @NotNull
    public final Size2D times(double s) {
        return this.times((float)s);
    }

    @NotNull
    public final Size2D times(int s) {
        return this.times((float)s);
    }

    @NotNull
    public final Scale div(@NotNull Size2D other) {
        return new Scale(this.width / other.width, this.height / other.height);
    }

    @NotNull
    public final Size2D div(float s) {
        return new Size2D(this.width / (double)s, this.height / (double)s);
    }

    @NotNull
    public final Size2D div(double s) {
        return this.div((float)s);
    }

    @NotNull
    public final Size2D div(int s) {
        return this.div((float)s);
    }

    @NotNull
    public String toString() {
        return "Size(width=" + StringExtKt.getNiceStr(this.width) + ", height=" + StringExtKt.getNiceStr(this.height) + ")";
    }

    public final double component1() {
        return this.width;
    }

    public final double component2() {
        return this.height;
    }

    @NotNull
    public final Size2D copy(double width2, double height2) {
        return new Size2D(width2, height2);
    }

    public static /* synthetic */ Size2D copy$default(Size2D size2D, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = size2D.width;
        }
        if ((n & 2) != 0) {
            d2 = size2D.height;
        }
        return size2D.copy(d, d2);
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.width);
        result2 = result2 * 31 + Double.hashCode(this.height);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Size2D)) {
            return false;
        }
        Size2D size2D = (Size2D)other;
        if (Double.compare(this.width, size2D.width) != 0) {
            return false;
        }
        return Double.compare(this.height, size2D.height) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0086\nJ\u0012\u0010\f\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\f\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\r\u001a\u00020\u000fR\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkorlibs/math/geom/Size2D$Companion;", "", "()V", "ZERO", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "getZERO", "()Lkorlibs/math/geom/Size2D;", "invoke", "width", "", "height", "square", "value", "", "", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Size2D invoke(@NotNull Number width2, @NotNull Number height2) {
            boolean $i$f$invoke = false;
            return new Size2D(width2.doubleValue(), height2.doubleValue());
        }

        @NotNull
        public final Size2D getZERO() {
            return ZERO;
        }

        @NotNull
        public final Size2D square(int value) {
            return new Size2D(value, value);
        }

        @NotNull
        public final Size2D square(double value) {
            return new Size2D(value, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

