/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.geom.Scale;
import korlibs.math.geom.Vector2F;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u0004J\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004H\u0086\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u0004J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020!H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0016H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004H\u0086\u0002J\b\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0000H\u0086\u0002J\t\u0010%\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006&"}, d2={"Lkorlibs/math/geom/SizeInt;", "", "()V", "width", "", "height", "(II)V", "area", "getArea", "()I", "getHeight", "perimeter", "getPerimeter", "getWidth", "avgComponent", "component1", "component2", "copy", "div", "other", "s", "", "", "equals", "", "hashCode", "maxComponent", "minComponent", "minus", "plus", "times", "scale", "Lkorlibs/math/geom/Scale;", "Lkorlibs/math/geom/Vector2F;", "toString", "", "unaryMinus", "unaryPlus", "korge-foundation"})
public final class SizeInt {
    private final int width;
    private final int height;

    public SizeInt(int width2, int height2) {
        this.width = width2;
        this.height = height2;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public SizeInt() {
        this(0, 0);
    }

    public final int avgComponent() {
        return (this.width + this.height) / 2;
    }

    public final int minComponent() {
        return Math.min(this.width, this.height);
    }

    public final int maxComponent() {
        return Math.max(this.width, this.height);
    }

    public final int getArea() {
        return this.width * this.height;
    }

    public final int getPerimeter() {
        return this.width * 2 + this.height * 2;
    }

    @NotNull
    public final SizeInt unaryMinus() {
        return new SizeInt(-this.width, -this.height);
    }

    @NotNull
    public final SizeInt unaryPlus() {
        return this;
    }

    @NotNull
    public final SizeInt minus(@NotNull SizeInt other) {
        return new SizeInt(this.width - other.width, this.height - other.height);
    }

    @NotNull
    public final SizeInt plus(@NotNull SizeInt other) {
        return new SizeInt(this.width + other.width, this.height + other.height);
    }

    @NotNull
    public final SizeInt times(float s) {
        return new SizeInt((int)((float)this.width * s), (int)((float)this.height * s));
    }

    @NotNull
    public final SizeInt times(double s) {
        return this.times((float)s);
    }

    @NotNull
    public final SizeInt times(int s) {
        return this.times((float)s);
    }

    @NotNull
    public final SizeInt times(@NotNull Vector2F scale) {
        return new SizeInt((int)((float)this.width * scale.getX()), (int)((float)this.height * scale.getY()));
    }

    @NotNull
    public final SizeInt times(@NotNull Scale scale) {
        return new SizeInt((int)((double)this.width * scale.getScaleX()), (int)((double)this.height * scale.getScaleY()));
    }

    @NotNull
    public final SizeInt div(@NotNull SizeInt other) {
        return new SizeInt(this.width / other.width, this.height / other.height);
    }

    @NotNull
    public final SizeInt div(float s) {
        return new SizeInt((int)((float)this.width / s), (int)((float)this.height / s));
    }

    @NotNull
    public final SizeInt div(double s) {
        return this.div((float)s);
    }

    @NotNull
    public final SizeInt div(int s) {
        return this.div((float)s);
    }

    @NotNull
    public String toString() {
        return this.width + "x" + this.height;
    }

    public final int component1() {
        return this.width;
    }

    public final int component2() {
        return this.height;
    }

    @NotNull
    public final SizeInt copy(int width2, int height2) {
        return new SizeInt(width2, height2);
    }

    public static /* synthetic */ SizeInt copy$default(SizeInt sizeInt, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = sizeInt.width;
        }
        if ((n3 & 2) != 0) {
            n2 = sizeInt.height;
        }
        return sizeInt.copy(n, n2);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.width);
        result2 = result2 * 31 + Integer.hashCode(this.height);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SizeInt)) {
            return false;
        }
        SizeInt sizeInt = (SizeInt)other;
        if (this.width != sizeInt.width) {
            return false;
        }
        return this.height == sizeInt.height;
    }
}

