/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.IsAlmostEqualsF;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.geom.Vector4F;
import korlibs.math.geom.VectorsFloatKt;
import korlibs.number.StringExtKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00017B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\t2\b\b\u0002\u0010\u0004\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\tH\u00c6\u0001J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\u0011\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010%\u001a\u00020\u0000J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010'\u001a\u00020\tH\u0016J\u0006\u0010(\u001a\u00020\u001fJ\u0011\u0010)\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010*\u001a\u00020\u0000J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0002J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010/\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010/\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010/\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0002J\u0011\u0010/\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003H\u0086\u0002J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u00020\tJ\t\u00105\u001a\u00020\u0000H\u0086\u0002J\t\u00106\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u000b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u00068"}, d2={"Lkorlibs/math/geom/Vector3F;", "Lkorlibs/math/IsAlmostEqualsF;", "x", "", "y", "z", "(III)V", "", "(DDD)V", "", "(FFF)V", "absoluteValue", "getAbsoluteValue", "()Lkorlibs/math/geom/Vector3F;", "length", "getLength", "()F", "lengthSquared", "getLengthSquared", "getX", "getY", "getZ", "component1", "component2", "component3", "copy", "cross", "v", "div", "dot", "equals", "", "other", "", "get", "index", "hashCode", "inv", "isAlmostEquals", "epsilon", "isNaN", "minus", "normalized", "plus", "reflected", "surfaceNormal", "rem", "times", "toString", "", "toVector4", "Lkorlibs/math/geom/Vector4F;", "w", "unaryMinus", "unaryPlus", "Companion", "korge-foundation"})
public final class Vector3F
implements IsAlmostEqualsF<Vector3F> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final float z;
    @NotNull
    private static final Vector3F NaN = new Vector3F(Float.NaN, Float.NaN, Float.NaN);
    @NotNull
    private static final Vector3F ZERO = new Vector3F(0.0f, 0.0f, 0.0f);
    @NotNull
    private static final Vector3F ONE = new Vector3F(1.0f, 1.0f, 1.0f);
    @NotNull
    private static final Vector3F FORWARD = new Vector3F(0.0f, 0.0f, 1.0f);
    @NotNull
    private static final Vector3F BACK = new Vector3F(0.0f, 0.0f, -1.0f);
    @NotNull
    private static final Vector3F LEFT = new Vector3F(-1.0f, 0.0f, 0.0f);
    @NotNull
    private static final Vector3F RIGHT = new Vector3F(1.0f, 0.0f, 0.0f);
    @NotNull
    private static final Vector3F UP = new Vector3F(0.0f, 1.0f, 0.0f);
    @NotNull
    private static final Vector3F DOWN = new Vector3F(0.0f, -1.0f, 0.0f);

    public Vector3F(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public Vector3F(int x, int y, int z) {
        this((float)x, (float)y, (float)z);
    }

    public Vector3F(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public final float getLengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float getLength() {
        return (float)Math.sqrt(this.getLengthSquared());
    }

    @NotNull
    public final Vector3F normalized() {
        float length2 = this.getLength();
        if (length2 == 0.0f) {
            return ZERO;
        }
        return this.div(length2);
    }

    @NotNull
    public final Vector3F reflected(@NotNull Vector3F surfaceNormal) {
        Vector3F d = this;
        Vector3F n = surfaceNormal;
        return d.minus(VectorsFloatKt.times(2.0f * d.dot(n), n));
    }

    public final float get(int index2) {
        float f;
        switch (index2) {
            case 0: {
                f = this.x;
                break;
            }
            case 1: {
                f = this.y;
                break;
            }
            case 2: {
                f = this.z;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return f;
    }

    @NotNull
    public final Vector3F unaryPlus() {
        return this;
    }

    @NotNull
    public final Vector3F unaryMinus() {
        return new Vector3F(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final Vector3F plus(@NotNull Vector3F v) {
        return new Vector3F(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    @NotNull
    public final Vector3F minus(@NotNull Vector3F v) {
        return new Vector3F(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    @NotNull
    public final Vector3F times(@NotNull Vector3F v) {
        return new Vector3F(this.x * v.x, this.y * v.y, this.z * v.z);
    }

    @NotNull
    public final Vector3F div(@NotNull Vector3F v) {
        return new Vector3F(this.x / v.x, this.y / v.y, this.z / v.z);
    }

    @NotNull
    public final Vector3F rem(@NotNull Vector3F v) {
        return new Vector3F(this.x % v.x, this.y % v.y, this.z % v.z);
    }

    @NotNull
    public final Vector3F times(float v) {
        return new Vector3F(this.x * v, this.y * v, this.z * v);
    }

    @NotNull
    public final Vector3F div(float v) {
        return new Vector3F(this.x / v, this.y / v, this.z / v);
    }

    @NotNull
    public final Vector3F rem(float v) {
        return new Vector3F(this.x % v, this.y % v, this.z % v);
    }

    @NotNull
    public final Vector3F times(int v) {
        return this.times((float)v);
    }

    @NotNull
    public final Vector3F div(int v) {
        return this.div((float)v);
    }

    @NotNull
    public final Vector3F rem(int v) {
        return this.rem((float)v);
    }

    @NotNull
    public final Vector3F times(double v) {
        return this.times((float)v);
    }

    @NotNull
    public final Vector3F div(double v) {
        return this.div((float)v);
    }

    @NotNull
    public final Vector3F rem(double v) {
        return this.rem((float)v);
    }

    public final float dot(@NotNull Vector3F v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    @NotNull
    public final Vector3F cross(@NotNull Vector3F v) {
        return Companion.cross(this, v);
    }

    @NotNull
    public final Vector3F inv() {
        return new Vector3F(1.0f / this.x, 1.0f / this.y, 1.0f / this.z);
    }

    public final boolean isNaN() {
        return Float.isNaN(this.x) && Float.isNaN(this.y) && Float.isNaN(this.z);
    }

    @NotNull
    public final Vector3F getAbsoluteValue() {
        return new Vector3F(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    @NotNull
    public String toString() {
        return "Vector3(" + StringExtKt.getNiceStr(this.x) + ", " + StringExtKt.getNiceStr(this.y) + ", " + StringExtKt.getNiceStr(this.z) + ")";
    }

    @NotNull
    public final Vector4F toVector4(float w) {
        return new Vector4F(this.x, this.y, this.z, w);
    }

    public static /* synthetic */ Vector4F toVector4$default(Vector3F vector3F, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        return vector3F.toVector4(f);
    }

    @Override
    public boolean isAlmostEquals(@NotNull Vector3F other, float epsilon) {
        return IsAlmostZeroKt.isAlmostEquals(this.x, other.x, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.y, other.y, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.z, other.z, epsilon);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    @NotNull
    public final Vector3F copy(float x, float y, float z) {
        return new Vector3F(x, y, z);
    }

    public static /* synthetic */ Vector3F copy$default(Vector3F vector3F, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = vector3F.x;
        }
        if ((n & 2) != 0) {
            f2 = vector3F.y;
        }
        if ((n & 4) != 0) {
            f3 = vector3F.z;
        }
        return vector3F.copy(f, f2, f3);
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = result2 * 31 + Float.hashCode(this.y);
        result2 = result2 * 31 + Float.hashCode(this.z);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3F)) {
            return false;
        }
        Vector3F vector3F = (Vector3F)other;
        if (Float.compare(this.x, vector3F.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, vector3F.y) != 0) {
            return false;
        }
        return Float.compare(this.z, vector3F.z) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ,\u0010\u001f\u001a\u00020\u00042!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$0 H\u0086\bJ\t\u0010%\u001a\u00020\u0004H\u0086\u0002J\u001e\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$J\u001e\u0010*\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006+"}, d2={"Lkorlibs/math/geom/Vector3F$Companion;", "", "()V", "BACK", "Lkorlibs/math/geom/Vector3F;", "getBACK", "()Lkorlibs/math/geom/Vector3F;", "DOWN", "getDOWN", "FORWARD", "getFORWARD", "LEFT", "getLEFT", "NaN", "getNaN", "ONE", "getONE", "RIGHT", "getRIGHT", "UP", "getUP", "ZERO", "getZERO", "cross", "a", "b", "fromArray", "array", "", "offset", "", "func", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "index", "", "invoke", "length", "x", "y", "z", "lengthSq", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3F getNaN() {
            return NaN;
        }

        @NotNull
        public final Vector3F getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector3F getONE() {
            return ONE;
        }

        @NotNull
        public final Vector3F getFORWARD() {
            return FORWARD;
        }

        @NotNull
        public final Vector3F getBACK() {
            return BACK;
        }

        @NotNull
        public final Vector3F getLEFT() {
            return LEFT;
        }

        @NotNull
        public final Vector3F getRIGHT() {
            return RIGHT;
        }

        @NotNull
        public final Vector3F getUP() {
            return UP;
        }

        @NotNull
        public final Vector3F getDOWN() {
            return DOWN;
        }

        @NotNull
        public final Vector3F invoke() {
            return this.getZERO();
        }

        @NotNull
        public final Vector3F cross(@NotNull Vector3F a, @NotNull Vector3F b) {
            return new Vector3F(a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX());
        }

        public final float length(float x, float y, float z) {
            return (float)Math.sqrt(this.lengthSq(x, y, z));
        }

        public final float lengthSq(float x, float y, float z) {
            return x * x + y * y + z * z;
        }

        @NotNull
        public final Vector3F fromArray(@NotNull float[] array, int offset2) {
            return new Vector3F(array[offset2 + 0], array[offset2 + 1], array[offset2 + 2]);
        }

        @NotNull
        public final Vector3F func(@NotNull Function1<? super Integer, Float> func2) {
            boolean $i$f$func = false;
            return new Vector3F(((Number)func2.invoke((Integer)0)).floatValue(), ((Number)func2.invoke((Integer)1)).floatValue(), ((Number)func2.invoke((Integer)2)).floatValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

