/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom;

import korlibs.math.IsAlmostZeroKt;
import korlibs.math.geom.Vector3F;
import korlibs.number.StringExtKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001AB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\f\u0012\u0006\u0010\t\u001a\u00020\f\u0012\u0006\u0010\n\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB%\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J1\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\b\b\u0002\u0010)\u001a\u00020\bJ\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010,\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\bH\u0086\u0002J\t\u00102\u001a\u00020\bH\u00d6\u0001J\u0006\u00103\u001a\u00020\u0000J\u0018\u00104\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00002\b\b\u0002\u00105\u001a\u00020\u0005J\u0006\u00106\u001a\u00020.J\u0011\u00107\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0006\u00108\u001a\u00020\u0000J\u0011\u00109\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010:\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010:\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010;\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010;\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0005H\u0086\u0002J\b\u0010<\u001a\u00020=H\u0016J\u0006\u0010>\u001a\u00020\u0003J\t\u0010?\u001a\u00020\u0000H\u0086\u0002J\t\u0010@\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u000f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014\u00a8\u0006B"}, d2={"Lkorlibs/math/geom/Vector4F;", "", "xyz", "Lkorlibs/math/geom/Vector3F;", "w", "", "(Lkorlibs/math/geom/Vector3F;F)V", "x", "", "y", "z", "(IIII)V", "", "(DDDD)V", "(FFFF)V", "absoluteValue", "getAbsoluteValue", "()Lkorlibs/math/geom/Vector4F;", "length", "getLength", "()F", "length3", "getLength3", "length3Squared", "getLength3Squared", "lengthSquared", "getLengthSquared", "getW", "getX", "getXyz", "()Lkorlibs/math/geom/Vector3F;", "getY", "getZ", "component1", "component2", "component3", "component4", "copy", "copyTo", "", "out", "offset", "div", "v", "dot", "equals", "", "other", "get", "index", "hashCode", "inv", "isAlmostEquals", "epsilon", "isNaN", "minus", "normalized", "plus", "rem", "times", "toString", "", "toVector3", "unaryMinus", "unaryPlus", "Companion", "korge-foundation"})
public final class Vector4F {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final float z;
    private final float w;
    @NotNull
    private static final Vector4F ZERO = new Vector4F(0.0f, 0.0f, 0.0f, 0.0f);
    @NotNull
    private static final Vector4F ONE = new Vector4F(1.0f, 1.0f, 1.0f, 1.0f);

    public Vector4F(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public final float getW() {
        return this.w;
    }

    public Vector4F(@NotNull Vector3F xyz, float w) {
        this(xyz.getX(), xyz.getY(), xyz.getZ(), w);
    }

    public Vector4F(int x, int y, int z, int w) {
        this((float)x, (float)y, (float)z, (float)w);
    }

    public Vector4F(double x, double y, double z, double w) {
        this((float)x, (float)y, (float)z, (float)w);
    }

    @NotNull
    public final Vector3F getXyz() {
        return new Vector3F(this.x, this.y, this.z);
    }

    public final float getLength3Squared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float getLength3() {
        return (float)Math.sqrt(this.getLength3Squared());
    }

    public final float getLengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final float getLength() {
        return (float)Math.sqrt(this.getLengthSquared());
    }

    @NotNull
    public final Vector4F normalized() {
        float length2 = this.getLength();
        if (length2 == 0.0f) {
            return ZERO;
        }
        return this.div(length2);
    }

    public final float get(int index2) {
        float f;
        switch (index2) {
            case 0: {
                f = this.x;
                break;
            }
            case 1: {
                f = this.y;
                break;
            }
            case 2: {
                f = this.z;
                break;
            }
            case 3: {
                f = this.w;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return f;
    }

    @NotNull
    public final Vector4F unaryPlus() {
        return this;
    }

    @NotNull
    public final Vector4F unaryMinus() {
        return new Vector4F(-this.x, -this.y, -this.z, -this.w);
    }

    @NotNull
    public final Vector4F plus(@NotNull Vector4F v) {
        return new Vector4F(this.x + v.x, this.y + v.y, this.z + v.z, this.w + v.w);
    }

    @NotNull
    public final Vector4F minus(@NotNull Vector4F v) {
        return new Vector4F(this.x - v.x, this.y - v.y, this.z - v.z, this.w - v.w);
    }

    @NotNull
    public final Vector4F times(@NotNull Vector4F v) {
        return new Vector4F(this.x * v.x, this.y * v.y, this.z * v.z, this.w * v.w);
    }

    @NotNull
    public final Vector4F div(@NotNull Vector4F v) {
        return new Vector4F(this.x / v.x, this.y / v.y, this.z / v.z, this.w / v.w);
    }

    @NotNull
    public final Vector4F rem(@NotNull Vector4F v) {
        return new Vector4F(this.x % v.x, this.y % v.y, this.z % v.z, this.w % v.w);
    }

    @NotNull
    public final Vector4F times(float v) {
        return new Vector4F(this.x * v, this.y * v, this.z * v, this.w * v);
    }

    @NotNull
    public final Vector4F div(float v) {
        return new Vector4F(this.x / v, this.y / v, this.z / v, this.w / v);
    }

    @NotNull
    public final Vector4F rem(float v) {
        return new Vector4F(this.x % v, this.y % v, this.z % v, this.w % v);
    }

    public final float dot(@NotNull Vector4F v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    @NotNull
    public final float[] copyTo(@NotNull float[] out, int offset2) {
        out[offset2 + 0] = this.x;
        out[offset2 + 1] = this.y;
        out[offset2 + 2] = this.z;
        out[offset2 + 3] = this.w;
        return out;
    }

    public static /* synthetic */ float[] copyTo$default(Vector4F vector4F, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vector4F.copyTo(fArray, n);
    }

    @NotNull
    public final Vector4F inv() {
        return new Vector4F(1.0f / this.x, 1.0f / this.y, 1.0f / this.z, 1.0f / this.w);
    }

    public final boolean isNaN() {
        return Float.isNaN(this.x) && Float.isNaN(this.y) && Float.isNaN(this.z) && Float.isNaN(this.w);
    }

    @NotNull
    public final Vector4F getAbsoluteValue() {
        return new Vector4F(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z), Math.abs(this.w));
    }

    @NotNull
    public String toString() {
        return "Vector4(" + StringExtKt.getNiceStr(this.x) + ", " + StringExtKt.getNiceStr(this.y) + ", " + StringExtKt.getNiceStr(this.z) + ", " + StringExtKt.getNiceStr(this.w) + ")";
    }

    @NotNull
    public final Vector3F toVector3() {
        return new Vector3F(this.x, this.y, this.z);
    }

    public final boolean isAlmostEquals(@NotNull Vector4F other, float epsilon) {
        return IsAlmostZeroKt.isAlmostEquals(this.x, other.x, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.y, other.y, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.z, other.z, epsilon) && IsAlmostZeroKt.isAlmostEquals(this.w, other.w, epsilon);
    }

    public static /* synthetic */ boolean isAlmostEquals$default(Vector4F vector4F, Vector4F vector4F2, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0E-5f;
        }
        return vector4F.isAlmostEquals(vector4F2, f);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    public final float component4() {
        return this.w;
    }

    @NotNull
    public final Vector4F copy(float x, float y, float z, float w) {
        return new Vector4F(x, y, z, w);
    }

    public static /* synthetic */ Vector4F copy$default(Vector4F vector4F, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = vector4F.x;
        }
        if ((n & 2) != 0) {
            f2 = vector4F.y;
        }
        if ((n & 4) != 0) {
            f3 = vector4F.z;
        }
        if ((n & 8) != 0) {
            f4 = vector4F.w;
        }
        return vector4F.copy(f, f2, f3, f4);
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = result2 * 31 + Float.hashCode(this.y);
        result2 = result2 * 31 + Float.hashCode(this.z);
        result2 = result2 * 31 + Float.hashCode(this.w);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector4F)) {
            return false;
        }
        Vector4F vector4F = (Vector4F)other;
        if (Float.compare(this.x, vector4F.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, vector4F.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, vector4F.z) != 0) {
            return false;
        }
        return Float.compare(this.w, vector4F.w) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u00020\u00042!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000fH\u0086\bJ\t\u0010\u0014\u001a\u00020\u0004H\u0086\u0002J&\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J&\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lkorlibs/math/geom/Vector4F$Companion;", "", "()V", "ONE", "Lkorlibs/math/geom/Vector4F;", "getONE", "()Lkorlibs/math/geom/Vector4F;", "ZERO", "getZERO", "fromArray", "array", "", "offset", "", "func", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "index", "", "invoke", "length", "x", "y", "z", "w", "lengthSq", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector4F getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector4F getONE() {
            return ONE;
        }

        @NotNull
        public final Vector4F invoke() {
            return Companion.getZERO();
        }

        @NotNull
        public final Vector4F fromArray(@NotNull float[] array, int offset2) {
            return new Vector4F(array[offset2 + 0], array[offset2 + 1], array[offset2 + 2], array[offset2 + 3]);
        }

        public static /* synthetic */ Vector4F fromArray$default(Companion companion, float[] fArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromArray(fArray, n);
        }

        public final float length(float x, float y, float z, float w) {
            return (float)Math.sqrt(this.lengthSq(x, y, z, w));
        }

        public final float lengthSq(float x, float y, float z, float w) {
            return x * x + y * y + z * z + w * w;
        }

        @NotNull
        public final Vector4F func(@NotNull Function1<? super Integer, Float> func2) {
            boolean $i$f$func = false;
            return new Vector4F(((Number)func2.invoke((Integer)0)).floatValue(), ((Number)func2.invoke((Integer)1)).floatValue(), ((Number)func2.invoke((Integer)2)).floatValue(), ((Number)func2.invoke((Integer)3)).floatValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

