/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.bezier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import korlibs.datastructure.ArrayListExtKt;
import korlibs.datastructure.DoubleArrayList;
import korlibs.math.ConvertRangeKt;
import korlibs.math.IsAlmostEquals;
import korlibs.math.IsAlmostZeroKt;
import korlibs.math.MathKt;
import korlibs.math.RoundDecimalPlacesKt;
import korlibs.math.geom.Angle;
import korlibs.math.geom.AngleKt;
import korlibs.math.geom.Circle;
import korlibs.math.geom.Line2D;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.PointArrayList;
import korlibs.math.geom.PointList;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.VectorsListKt;
import korlibs.math.geom.bezier.Curve;
import korlibs.math.geom.bezier.CurveLUT;
import korlibs.math.geom.bezier.CurveSplit;
import korlibs.math.geom.bezier.Curves;
import korlibs.math.geom.bezier.SubBezier;
import korlibs.math.geom.bezier._MathGeom_bezierKt;
import korlibs.math.interpolation.Ratio;
import korlibs.math.interpolation._Math_interpolationKt;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function8;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleSpreadBuilder;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u00b9\u00012\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\b\u00b9\u0001\u00ba\u0001\u00bb\u0001\u00bc\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001f\b\u0016\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\bB+\b\u0016\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\nB7\b\u0016\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u000b\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010J\u001a\u00060\u0019j\u0002`\u001a2\b\b\u0002\u0010K\u001a\u00020LH\u0002J\u001e\u0010M\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020OH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bP\u0010QJ\b\u0010R\u001a\u00020\u0000H\u0007J\u001c\u0010S\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020O\u00f8\u0001\u0000\u00a2\u0006\u0004\bT\u0010QJ\"\u0010U\u001a\u00020V2\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010W\u001a\u00020\u001f\u00f8\u0001\u0000\u00a2\u0006\u0004\bX\u0010YJ&\u0010Z\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010[\u001a\u00020\u001f\u00f8\u0001\u0000\u00a2\u0006\u0004\b\\\u0010]J\u0013\u0010^\u001a\u00020\u001f2\b\u0010_\u001a\u0004\u0018\u00010`H\u0096\u0002JB\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020:2\u0006\u0010d\u001a\u00020:2\u0006\u0010e\u001a\u00020:2\u0006\u0010f\u001a\u00020:2\u0006\u0010g\u001a\u00020:2\u0006\u0010h\u001a\u00020:2\b\b\u0002\u0010i\u001a\u00020bH\u0002J\u001f\u0010j\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020OH\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bk\u0010QJ\f\u0010l\u001a\u00060\u0019j\u0002`\u001aH\u0016J\u0012\u0010l\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010K\u001a\u00020LJ\u001a\u0010m\u001a\u00020>2\b\b\u0002\u0010n\u001a\u00020#2\b\b\u0002\u0010i\u001a\u00020>J\b\u0010o\u001a\u00020#H\u0016J\"\u0010p\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010i\u001a\u00020q\u00f8\u0001\u0000\u00a2\u0006\u0004\br\u0010sJ$\u0010t\u001a\u0004\u0018\u00010\u000e2\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010i\u001a\u00020q\u00f8\u0001\u0000\u00a2\u0006\u0004\bu\u0010sJ\u0006\u0010v\u001a\u00020wJ\u0012\u0010x\u001a\u00020w2\n\u0010y\u001a\u00060zj\u0002`{J*\u0010x\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020O0|0,2\u0006\u0010}\u001a\u00020\u00002\b\b\u0002\u0010~\u001a\u00020:J\u0019\u0010\u007f\u001a\u00020\u001f2\u0006\u0010_\u001a\u00020\u00002\u0007\u0010\u0080\u0001\u001a\u00020:H\u0016J \u0010\u0081\u0001\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020OH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0005\b\u0082\u0001\u0010QJ(\u0010\u0081\u0001\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020O2\b\b\u0002\u0010[\u001a\u00020\u001f\u00f8\u0001\u0000\u00a2\u0006\u0005\b\u0083\u0001\u0010]J(\u0010\u0084\u0001\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020O2\u0007\u0010\u0085\u0001\u001a\u00020:\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0086\u0001\u0010\u0087\u0001J\u0016\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000,2\u0007\u0010\u0085\u0001\u001a\u00020:J2\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008a\u0001\u001a\u00020:2\t\b\u0002\u0010\u008b\u0001\u001a\u00020:2\t\b\u0002\u0010\u008c\u0001\u001a\u00020:2\t\b\u0002\u0010\u008d\u0001\u001a\u00020:J\u000f\u0010\u008e\u0001\u001a\u00020\u001f2\u0006\u0010}\u001a\u00020\u0000J\u001e\u0010\u008f\u0001\u001a\u00020b2\u000b\u0010\u0090\u0001\u001a\u00060\u0005j\u0002`\u00062\b\b\u0002\u0010i\u001a\u00020bJ\t\u0010\u0091\u0001\u001a\u00020\u0000H\u0002J \u0010\u0092\u0001\u001a\u00020O2\u0006\u00109\u001a\u00020:H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0093\u0001\u0010\u0094\u0001J\u000e\u0010\u0095\u0001\u001a\t\u0012\u0005\u0012\u00030\u0096\u00010,J\u0010\u0010\u0097\u0001\u001a\u00020\u00002\u0007\u0010\u0098\u0001\u001a\u00020#J\u001d\u0010\u0099\u0001\u001a\u00020\u00002\u0014\u0010\u0085\u0001\u001a\u000f\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:0\u009a\u0001J\u0010\u0010\u0099\u0001\u001a\u00020\u00002\u0007\u0010\u0085\u0001\u001a\u00020:J\u0019\u0010\u0099\u0001\u001a\u00020\u00002\u0007\u0010\u009b\u0001\u001a\u00020:2\u0007\u0010\u008a\u0001\u001a\u00020:J\u001d\u0010\u009c\u0001\u001a\u00030\u009d\u00012\b\b\u0002\u0010~\u001a\u00020:2\t\b\u0002\u0010i\u001a\u00030\u009d\u0001J\u001c\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0006\u0010N\u001a\u00020O\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00a0\u0001\u0010\u00a1\u0001J&\u0010\u009e\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u00a2\u0001\u001a\u00020O2\u0007\u0010\u00a3\u0001\u001a\u00020O\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00a4\u0001\u0010\u00a5\u0001J\u001c\u0010\u00a6\u0001\u001a\u00030\u0096\u00012\u0006\u0010N\u001a\u00020O\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00a7\u0001\u0010\u00a8\u0001J\u001c\u0010\u00a9\u0001\u001a\u00030\u0096\u00012\u0006\u0010N\u001a\u00020O\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00aa\u0001\u0010\u00a8\u0001J \u0010\u00ab\u0001\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010N\u001a\u00020OH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0005\b\u00ac\u0001\u0010QJ\u0007\u0010\u00ad\u0001\u001a\u00020\u0000J\u000b\u0010\u00ae\u0001\u001a\u00060zj\u0002`{J\u0007\u0010\u00af\u0001\u001a\u00020\u0000J\u0007\u0010\u00b0\u0001\u001a\u00020\u0000J\r\u0010\u00b1\u0001\u001a\b\u0012\u0004\u0012\u00020\u00000,J\u000e\u0010\u00b2\u0001\u001a\t\u0012\u0005\u0012\u00030\u0096\u00010,J\n\u0010\u00b3\u0001\u001a\u00030\u00b4\u0001H\u0016J\u000f\u0010\u00b5\u0001\u001a\u00020\u00002\u0006\u0010K\u001a\u00020LJ\u0019\u0010\u00b6\u0001\u001a\u00020\u00002\u0007\u0010\u00b7\u0001\u001a\u00020:2\u0007\u0010\u00b8\u0001\u001a\u00020:R\u001b\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0017\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R!\u0010&\u001a\u00020'8FX\u0086\u0084\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\f\n\u0004\b*\u0010\u0017\u001a\u0004\b(\u0010)R!\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u0017\u001a\u0004\b-\u0010.R\u001b\u00100\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0017\u001a\u0004\b2\u00103R\u001b\u00105\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0017\u001a\u0004\b5\u0010!R\u001b\u00107\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u0017\u001a\u0004\b7\u0010!R\u001b\u00109\u001a\u00020:8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010\u0017\u001a\u0004\b;\u0010)R\u001b\u0010=\u001a\u00020>8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010\u0017\u001a\u0004\b?\u0010@R\u0014\u0010B\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010%R\u001b\u0010D\u001a\u00020E8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010\u0017\u001a\u0004\bF\u0010GR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0015\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00bd\u0001"}, d2={"Lkorlibs/math/geom/bezier/Bezier;", "Lkorlibs/math/geom/bezier/Curve;", "Lkorlibs/math/IsAlmostEquals;", "()V", "p0", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "p1", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;)V", "p2", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;)V", "p3", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;)V", "points", "Lkorlibs/math/geom/PointList;", "(Lkorlibs/math/geom/PointList;)V", "dummy", "", "(Lkorlibs/math/geom/PointList;Lkotlin/Unit;)V", "aligned", "getAligned", "()Lkorlibs/math/geom/PointList;", "aligned$delegate", "Lkotlin/Lazy;", "boundingBox", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "getBoundingBox", "()Lkorlibs/math/geom/RectangleD;", "boundingBox$delegate", "clockwise", "", "getClockwise", "()Z", "dims", "", "getDims", "()I", "direction", "Lkorlibs/math/geom/Angle;", "getDirection-igmgxjg", "()D", "direction$delegate", "dpoints", "", "getDpoints", "()Ljava/util/List;", "dpoints$delegate", "extrema", "Lkorlibs/math/geom/bezier/Bezier$Extrema;", "getExtrema", "()Lkorlibs/math/geom/bezier/Bezier$Extrema;", "extrema$delegate", "isLinear", "isLinear$delegate", "isSimple", "isSimple$delegate", "length", "", "getLength", "length$delegate", "lut", "Lkorlibs/math/geom/bezier/CurveLUT;", "getLut", "()Lkorlibs/math/geom/bezier/CurveLUT;", "lut$delegate", "order", "getOrder", "outerCircle", "Lkorlibs/math/geom/Circle;", "getOuterCircle", "()Lkorlibs/math/geom/Circle;", "outerCircle$delegate", "getPoints", "_getBoundingBox", "m", "Lkorlibs/math/geom/Matrix;", "calc", "t", "Lkorlibs/math/interpolation/Ratio;", "calc-kg1FUQ0", "(D)Lkorlibs/math/geom/Vector2D;", "clone", "compute", "compute-kg1FUQ0", "curvature", "Lkorlibs/math/geom/bezier/Bezier$Curvature;", "kOnly", "curvature-DJj3pIk", "(DZ)Lkorlibs/math/geom/bezier/Bezier$Curvature;", "derivative", "normalize", "derivative-DJj3pIk", "(DZ)Lkorlibs/math/geom/Vector2D;", "equals", "other", "", "findNearestLine", "Lkorlibs/math/geom/bezier/Bezier$ProjectedPoint;", "pX", "pY", "aX", "aY", "bX", "bY", "out", "get", "get-kg1FUQ0", "getBounds", "getLUT", "steps", "hashCode", "hull", "Lkorlibs/math/geom/PointArrayList;", "hull-DJj3pIk", "(DLkorlibs/math/geom/PointArrayList;)Lkorlibs/math/geom/PointList;", "hullOrNull", "hullOrNull-DJj3pIk", "inflections", "", "intersections", "line", "Lkorlibs/math/geom/Line2D;", "Lkorlibs/math/geom/Line;", "Lkotlin/Pair;", "curve", "threshold", "isAlmostEquals", "epsilon", "normal", "normal-kg1FUQ0", "normal-DJj3pIk", "offset", "d", "offset-DJj3pIk", "(DD)Lkorlibs/math/geom/Vector2D;", "outline", "Lkorlibs/math/geom/bezier/Curves;", "d1", "d2", "d3", "d4", "overlaps", "project", "point", "raise", "ratioFromLength", "ratioFromLength-4uGNJ3M", "(D)D", "reduce", "Lkorlibs/math/geom/bezier/SubBezier;", "roundDecimalPlaces", "places", "scaleSimple", "Lkotlin/Function1;", "d0", "selfIntersections", "Lkorlibs/datastructure/DoubleArrayList;", "split", "Lkorlibs/math/geom/bezier/CurveSplit;", "split-kg1FUQ0", "(D)Lkorlibs/math/geom/bezier/CurveSplit;", "t0", "t1", "split-QGGGw1I", "(DD)Lkorlibs/math/geom/bezier/SubBezier;", "splitLeft", "splitLeft-kg1FUQ0", "(D)Lkorlibs/math/geom/bezier/SubBezier;", "splitRight", "splitRight-kg1FUQ0", "tangent", "tangent-kg1FUQ0", "toCubic", "toLine", "toLineBezier", "toQuad", "toQuadList", "toSimpleList", "toString", "", "transform", "translate", "dx", "dy", "Companion", "Curvature", "Extrema", "ProjectedPoint", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeom.bezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/Bezier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n+ 4 _Math_interpolation.kt\nkorlibs/math/interpolation/Ratio$Companion\n+ 5 _Math_interpolation.kt\nkorlibs/math/interpolation/_Math_interpolationKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 8 ArrayListExt.kt\nkorlibs/datastructure/ArrayListExtKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1957:1\n1726#2,3:1958\n1549#2:1987\n1620#2,3:1988\n1549#2:2050\n1620#2,3:2051\n1549#2:2054\n1620#2,3:2055\n1549#2:2058\n1620#2,2:2059\n1622#2:2062\n81#3,3:1961\n399#4,10:1964\n413#5:1974\n1699#6,6:1975\n1699#6,6:1981\n3846#6:2011\n4367#6,2:2012\n52#7:1991\n42#7:1992\n52#7:1993\n42#7:1994\n52#7:1995\n42#7:1996\n43#7:1997\n52#7:1998\n42#7:1999\n54#7:2000\n52#7,7:2001\n42#7:2008\n43#7:2014\n52#7:2015\n42#7,11:2016\n42#7,11:2027\n53#7:2038\n52#7:2039\n36#7:2040\n53#7:2041\n52#7:2042\n42#7:2043\n53#7:2044\n52#7:2045\n42#7:2046\n53#7:2047\n52#7:2048\n43#7:2049\n19#8:2009\n1#9:2010\n1#9:2061\n*S KotlinDebug\n*F\n+ 1 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/Bezier\n*L\n163#1:1958,3\n500#1:1987\n500#1:1988,3\n751#1:2050\n751#1:2051,3\n801#1:2054\n801#1:2055,3\n819#1:2058\n819#1:2059,2\n819#1:2062\n223#1:1961,3\n296#1:1964,10\n314#1:1974\n426#1:1975,6\n427#1:1981,6\n609#1:2011\n609#1:2012,2\n509#1:1991\n509#1:1992\n529#1:1993\n529#1:1994\n530#1:1995\n530#1:1996\n563#1:1997\n566#1:1998\n566#1:1999\n584#1:2000\n584#1:2001,7\n584#1:2008\n713#1:2014\n716#1:2015\n716#1:2016,11\n734#1:2027,11\n742#1:2038\n742#1:2039\n742#1:2040\n742#1:2041\n742#1:2042\n742#1:2043\n742#1:2044\n742#1:2045\n742#1:2046\n742#1:2047\n742#1:2048\n742#1:2049\n599#1:2009\n599#1:2010\n*E\n"})
public final class Bezier
implements Curve,
IsAlmostEquals<Bezier> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PointList points;
    @NotNull
    private final Lazy aligned$delegate;
    @NotNull
    private final Lazy dpoints$delegate;
    @NotNull
    private final Lazy direction$delegate;
    @NotNull
    private final Lazy extrema$delegate;
    @NotNull
    private final Lazy outerCircle$delegate;
    @NotNull
    private final Lazy boundingBox$delegate;
    @NotNull
    private final Lazy length$delegate;
    @NotNull
    private final Lazy lut$delegate;
    @NotNull
    private final Lazy isLinear$delegate;
    @NotNull
    private final Lazy isSimple$delegate;
    @NotNull
    private static final double[] T_VALUES;
    @NotNull
    private static final double[] C_VALUES;
    private static final double tau = Math.PI * 2;
    @NotNull
    private static final Line2D X_AXIS;
    @NotNull
    private static final double[] EMPTY_DOUBLE_ARRAY;

    private Bezier(PointList points, Unit dummy) {
        this.points = points;
        if (this.points.getSize() > 4) {
            throw new IllegalStateException("Only supports quad and cubic beziers".toString());
        }
        this.aligned$delegate = LazyKt.lazy((Function0)new Function0<PointList>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PointList invoke() {
                return korlibs.math.geom.bezier.Bezier$Companion.align$default(Bezier.Companion, this.this$0.getPoints(), new Line2D(this.this$0.getPoints().getFirst(), this.this$0.getPoints().getLast()), null, 4, null);
            }
        });
        this.dpoints$delegate = LazyKt.lazy((Function0)new Function0<List<? extends PointList>>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<PointList> invoke() {
                return korlibs.math.geom.bezier.Bezier$Companion.access$derive(Bezier.Companion, this.this$0.getPoints());
            }
        });
        this.direction$delegate = LazyKt.lazy((Function0)new Function0<Angle>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final double invoke-igmgxjg() {
                void x1$iv$iv;
                void y0$iv$iv;
                void x0$iv$iv;
                void p1$iv;
                void p0$iv;
                void this_$iv;
                Angle.Companion companion = Angle.Companion;
                Vector2D vector2D = this.this$0.getPoints().get(0);
                Vector2D vector2D2 = this.this$0.getPoints().get(this.this$0.getOrder());
                Vector2D up$iv = this.this$0.getPoints().get(1);
                boolean bl = false;
                void var6_6 = this_$iv;
                double d = p0$iv.getX();
                double d2 = p0$iv.getY();
                double d3 = p1$iv.getX();
                double y1$iv$iv = p1$iv.getY();
                boolean bl2 = false;
                return AngleKt.Angle_between((double)x0$iv$iv, (double)y0$iv$iv, (double)x1$iv$iv, y1$iv$iv, up$iv);
            }
        });
        this.extrema$delegate = LazyKt.lazy((Function0)new Function0<Extrema>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Extrema invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = RangesKt.until(0, this.this$0.getDims());
                Bezier bezier = this.this$0;
                boolean $i$f$map = false;
                void var5_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void $this$mapDouble$iv;
                    double[] dArray;
                    void dim;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    double[] dArray2 = PointList.DefaultImpls.getComponentList$default(bezier.getDpoints().get(0), (int)dim, null, 2, null);
                    Companion companion = Bezier.Companion;
                    boolean $i$f$mapDouble = false;
                    double[] it$iv = dArray = new double[((void)$this$mapDouble$iv).length];
                    boolean bl2 = false;
                    int n$iv = 0;
                    int n2 = ((void)$this$mapDouble$iv).length;
                    while (n$iv < n2) {
                        void it;
                        void var20_19 = $this$mapDouble$iv[n$iv];
                        int n3 = n$iv++;
                        double[] dArray3 = it$iv;
                        boolean bl3 = false;
                        void var25_23 = it;
                        dArray3[n3] = var25_23;
                    }
                    double[] out = korlibs.math.geom.bezier.Bezier$Companion.access$droots(companion, dArray);
                    if (bezier.getOrder() == 3) {
                        out = korlibs.math.geom.bezier.Bezier$Companion.access$combineSmallDistinctSorted(Bezier.Companion, out, korlibs.math.geom.bezier.Bezier$Companion.access$droots(Bezier.Companion, PointList.DefaultImpls.getComponentList$default(bezier.getDpoints().get(1), (int)dim, null, 2, null)));
                    }
                    collection.add(out);
                }
                List out = (List)destination$iv$iv;
                return new Extrema((double[])out.get(0), (double[])out.get(1));
            }
        });
        this.outerCircle$delegate = LazyKt.lazy((Function0)new Function0<Circle>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Circle invoke() {
                return this.this$0.getBoundingBox().outerCircle();
            }
        });
        this.boundingBox$delegate = LazyKt.lazy((Function0)new Function0<RectangleD>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RectangleD invoke() {
                return Bezier.access$_getBoundingBox(this.this$0, Matrix.Companion.getNIL());
            }
        });
        this.length$delegate = LazyKt.lazy((Function0)new Function0<Double>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                double z = 0.5;
                double sum = 0.0;
                int n = Bezier.Companion.getT_VALUES().length;
                for (int i2 = 0; i2 < n; ++i2) {
                    double t = Ratio.constructor-impl(z * Bezier.Companion.getT_VALUES()[i2] + z);
                    Vector2D temp = Bezier.derivative-DJj3pIk$default(this.this$0, t, false, 2, null);
                    sum += Bezier.Companion.getC_VALUES()[i2] * temp.getLength();
                }
                return z * sum;
            }
        });
        this.lut$delegate = LazyKt.lazy((Function0)new Function0<CurveLUT>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CurveLUT invoke() {
                return Bezier.getLUT$default(this.this$0, 0, null, 3, null);
            }
        });
        this.isLinear$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                void $this$sumOfDouble$iv;
                Iterable this_$iv;
                Vector2D vector2D = this.this$0.getPoints().get(this.this$0.getOrder());
                Vector2D that$iv = this.this$0.getPoints().get(0);
                boolean $i$f$minus = false;
                double baseLength = new Vector2D(((Vector2D)((Object)this_$iv)).getX() - that$iv.getX(), ((Vector2D)((Object)this_$iv)).getY() - that$iv.getY()).getLength();
                this_$iv = RangesKt.until(0, Bezier.access$getAligned(this.this$0).getSize());
                Bezier bezier = this.this$0;
                boolean $i$f$sumOfFloat = false;
                double sum$iv = 0.0;
                Iterator<T> iterator2 = $this$sumOfDouble$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int element$iv;
                    int n = element$iv = ((IntIterator)iterator2).nextInt();
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = Math.abs(Bezier.access$getAligned(bezier).getY((int)it));
                    sum$iv = d + d2;
                }
                return sum$iv < baseLength / 50.0;
            }
        });
        this.isSimple$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Bezier this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                if (this.this$0.getOrder() == 3) {
                    double a1 = korlibs.math.geom.bezier.Bezier$Companion.access$angle(Bezier.Companion, this.this$0.getPoints().get(0), this.this$0.getPoints().get(3), this.this$0.getPoints().get(1));
                    double a2 = korlibs.math.geom.bezier.Bezier$Companion.access$angle(Bezier.Companion, this.this$0.getPoints().get(0), this.this$0.getPoints().get(3), this.this$0.getPoints().get(2));
                    if (a1 > 0.0 && a2 < 0.0 || a1 < 0.0 && a2 > 0.0) {
                        return false;
                    }
                }
                Vector2D n1 = this.this$0.normal-kg1FUQ0(Ratio.Companion.getZERO-eKSQRR4());
                Vector2D n2 = this.this$0.normal-kg1FUQ0(Ratio.Companion.getONE-eKSQRR4());
                double s = n1.getX() * n2.getX() + n1.getY() * n2.getY();
                return Math.abs(Math.acos(s)) < 1.0471975511965976;
            }
        });
    }

    @NotNull
    public final PointList getPoints() {
        return this.points;
    }

    public Bezier() {
        this(new Vector2D(0.0f, 0.0f), new Vector2D(0.0f, 0.0f));
    }

    public Bezier(@NotNull Vector2D p0, @NotNull Vector2D p1) {
        this(VectorsListKt.pointArrayListOf(p0, p1), Unit.INSTANCE);
    }

    public Bezier(@NotNull Vector2D p0, @NotNull Vector2D p1, @NotNull Vector2D p2) {
        this(VectorsListKt.pointArrayListOf(p0, p1, p2), Unit.INSTANCE);
    }

    public Bezier(@NotNull Vector2D p0, @NotNull Vector2D p1, @NotNull Vector2D p2, @NotNull Vector2D p3) {
        this(VectorsListKt.pointArrayListOf(p0, p1, p2, p3), Unit.INSTANCE);
    }

    public Bezier(@NotNull PointList points) {
        this(PointList.DefaultImpls.clone$default(points, null, 1, null), Unit.INSTANCE);
    }

    @Override
    public boolean isAlmostEquals(@NotNull Bezier other, double epsilon) {
        boolean bl;
        block4: {
            if (this.points.getSize() != other.points.getSize()) {
                return false;
            }
            Iterable $this$all$iv = RangesKt.until(0, this.points.getSize());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (this.points.get(it).isAlmostEquals(other.points.get(it), epsilon)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final List<SubBezier> toSimpleList() {
        return this.reduce();
    }

    @NotNull
    public final Bezier scaleSimple(double d) {
        return this.scaleSimple((Function1<? super Double, Double>)new Function1<Double, Double>(d){
            final /* synthetic */ double $d;
            {
                this.$d = $d;
                super(1);
            }

            @NotNull
            public final Double invoke(double it) {
                return this.$d;
            }
        });
    }

    @NotNull
    public final Bezier scaleSimple(double d0, double d1) {
        return this.scaleSimple((Function1<? super Double, Double>)new Function1<Double, Double>(d0, d1){
            final /* synthetic */ double $d0;
            final /* synthetic */ double $d1;
            {
                this.$d0 = $d0;
                this.$d1 = $d1;
                super(1);
            }

            @NotNull
            public final Double invoke(double it) {
                return it < 0.5 ? this.$d0 : this.$d1;
            }
        });
    }

    @NotNull
    public final Vector2D get-kg1FUQ0(double t) {
        return this.compute-kg1FUQ0(t);
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="this", imports={}))
    @NotNull
    public final Bezier clone() {
        return this;
    }

    @NotNull
    public final Bezier roundDecimalPlaces(int places) {
        return new Bezier(PointList.DefaultImpls.roundDecimalPlaces$default(this.points, places, null, 2, null));
    }

    @Override
    @NotNull
    public RectangleD getBounds() {
        return this.getBoundingBox();
    }

    @NotNull
    public final RectangleD getBounds(@NotNull Matrix m) {
        return this._getBoundingBox(m);
    }

    @Override
    @NotNull
    public Vector2D calc-kg1FUQ0(double t) {
        return this.compute-kg1FUQ0(t);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Bezier && Intrinsics.areEqual(this.points, ((Bezier)other).points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    @NotNull
    public String toString() {
        return "Bezier(" + this.points + ")";
    }

    public final int getDims() {
        return 2;
    }

    @Override
    public int getOrder() {
        return this.points.getSize() - 1;
    }

    private final PointList getAligned() {
        Lazy lazy = this.aligned$delegate;
        return (PointList)lazy.getValue();
    }

    @NotNull
    public final List<PointList> getDpoints() {
        Lazy lazy = this.dpoints$delegate;
        return (List)lazy.getValue();
    }

    public final double getDirection-igmgxjg() {
        Lazy lazy = this.direction$delegate;
        return ((Angle)lazy.getValue()).unbox-impl();
    }

    public final boolean getClockwise() {
        return Angle.compareTo-Mi4kPw4(this.getDirection-igmgxjg(), Angle.Companion.getZERO-igmgxjg()) > 0;
    }

    @NotNull
    public final Extrema getExtrema() {
        Lazy lazy = this.extrema$delegate;
        return (Extrema)lazy.getValue();
    }

    @NotNull
    public final Circle getOuterCircle() {
        Lazy lazy = this.outerCircle$delegate;
        return (Circle)lazy.getValue();
    }

    @NotNull
    public final RectangleD getBoundingBox() {
        Lazy lazy = this.boundingBox$delegate;
        return (RectangleD)lazy.getValue();
    }

    private final RectangleD _getBoundingBox(Matrix m) {
        double xmin = 0.0;
        double ymin = 0.0;
        double xmax = 0.0;
        double ymax = 0.0;
        for (int n = 0; n < 2; ++n) {
            double[] ext = this.getExtrema().dimt01(n);
            double min = 0.0;
            min = Double.POSITIVE_INFINITY;
            double max = 0.0;
            max = Double.NEGATIVE_INFINITY;
            double[] $this$fastForEach$iv = ext;
            boolean $i$f$fastForEach = false;
            int n$iv = 0;
            while (n$iv < $this$fastForEach$iv.length) {
                double t = $this$fastForEach$iv[n$iv++];
                boolean bl = false;
                Vector2D p = this.get-kg1FUQ0(Ratio.constructor-impl(t));
                double value = n == 0 ? p.transformX(m) : p.transformY(m);
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            if (n == 0) {
                xmin = min;
                xmax = max;
                continue;
            }
            ymin = min;
            ymax = max;
        }
        return RectangleD.Companion.fromBounds(xmin, ymin, xmax, ymax);
    }

    static /* synthetic */ RectangleD _getBoundingBox$default(Bezier bezier, Matrix matrix2, int n, Object object) {
        if ((n & 1) != 0) {
            matrix2 = Matrix.Companion.getNIL();
        }
        return bezier._getBoundingBox(matrix2);
    }

    @Override
    public double getLength() {
        Lazy lazy = this.length$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final CurveLUT getLut() {
        Lazy lazy = this.lut$delegate;
        return (CurveLUT)lazy.getValue();
    }

    public final boolean isLinear() {
        Lazy lazy = this.isLinear$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isSimple() {
        Lazy lazy = this.isSimple$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public double ratioFromLength-4uGNJ3M(double length2) {
        return CurveLUT.estimateAtLength$default(this.getLut(), length2, null, 2, null).getRatio-eKSQRR4();
    }

    @NotNull
    public final CurveLUT getLUT(int steps2, @NotNull CurveLUT out) {
        out.clear();
        Ratio.Companion companion = Ratio.Companion;
        int steps$iv = steps2 + 1;
        boolean include0$iv = true;
        boolean include1$iv = true;
        boolean $i$f$forEachRatio = false;
        int NS$iv = steps$iv - 1;
        double NSd$iv = NS$iv;
        int start$iv = 0;
        int end$iv = NS$iv;
        int n$iv = start$iv;
        if (n$iv <= end$iv) {
            while (true) {
                double ratio$iv = (double)n$iv / NSd$iv;
                double t = _Math_interpolationKt.toRatio(ratio$iv);
                boolean bl = false;
                out.add-DJj3pIk(t, this.compute-kg1FUQ0(t));
                if (n$iv == end$iv) break;
                ++n$iv;
            }
        }
        return out;
    }

    public static /* synthetic */ CurveLUT getLUT$default(Bezier bezier, int n, CurveLUT curveLUT, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        if ((n2 & 2) != 0) {
            curveLUT = new CurveLUT(bezier, n + 1);
        }
        return bezier.getLUT(n, curveLUT);
    }

    private final ProjectedPoint findNearestLine(double pX, double pY, double aX, double aY, double bX, double bY, ProjectedPoint out) {
        out.setBezier(this);
        double atobX = bX - aX;
        double atobY = bY - aY;
        double atopX = pX - aX;
        double atopY = pY - aY;
        double len = atobX * atobX + atobY * atobY;
        double dot = atopX * atobX + atopY * atobY;
        double t = _Math_interpolationKt.toRatio(Math.min(1.0, Math.max(0.0, dot / len)));
        double $this$times_u2dBdQlfBE$iv = atobX;
        boolean bl = false;
        double d = aX + $this$times_u2dBdQlfBE$iv * t;
        $this$times_u2dBdQlfBE$iv = atobY;
        bl = false;
        out.setP(new Vector2D(d, aY + $this$times_u2dBdQlfBE$iv * t));
        out.setT-kg1FUQ0(t);
        out.setDSq(Vector2D.Companion.distanceSquared(out.getP().getX(), out.getP().getY(), pX, pY));
        return out;
    }

    static /* synthetic */ ProjectedPoint findNearestLine$default(Bezier bezier, double d, double d2, double d3, double d4, double d5, double d6, ProjectedPoint projectedPoint, int n, Object object) {
        if ((n & 0x40) != 0) {
            projectedPoint = new ProjectedPoint(null, 0.0, 0.0, 7, null);
        }
        return bezier.findNearestLine(d, d2, d3, d4, d5, d6, projectedPoint);
    }

    @NotNull
    public final ProjectedPoint project(@NotNull Vector2D point2, @NotNull ProjectedPoint out) {
        double t;
        out.setBezier(this);
        if (this.points.getSize() == 2) {
            Vector2D p0 = this.points.get(0);
            Vector2D p1 = this.points.get(1);
            return this.findNearestLine(point2.getX(), point2.getY(), p0.getX(), p0.getY(), p1.getX(), p1.getY(), out);
        }
        CurveLUT LUT = this.getLut();
        double l = LUT.getSteps();
        CurveLUT.ClosestResult closest = LUT.closest(point2);
        int mpos = closest.getMpos();
        double t1 = (double)(mpos - 1) / l;
        double t2 = (double)(mpos + 1) / l;
        double step2 = 0.1 / l;
        double mdistSq = closest.getMdistSq();
        double ft = t = t1;
        mdistSq += 1.0;
        while (t < t2 + step2) {
            Vector2D p = this.compute-kg1FUQ0(_Math_interpolationKt.toRatio(t));
            double d = Vector2D.Companion.distanceSquared(point2, p);
            if (d < mdistSq) {
                mdistSq = d;
                ft = t;
                out.setP(p);
            }
            t += step2;
        }
        out.setP(this.compute-kg1FUQ0(_Math_interpolationKt.toRatio(ft)));
        out.setT-kg1FUQ0(ft < 0.0 ? Ratio.Companion.getZERO-eKSQRR4() : (ft > 1.0 ? Ratio.Companion.getONE-eKSQRR4() : _Math_interpolationKt.toRatio(ft)));
        out.setDSq(mdistSq);
        return out;
    }

    public static /* synthetic */ ProjectedPoint project$default(Bezier bezier, Vector2D vector2D, ProjectedPoint projectedPoint, int n, Object object) {
        if ((n & 2) != 0) {
            projectedPoint = new ProjectedPoint(null, 0.0, 0.0, 7, null);
        }
        return bezier.project(vector2D, projectedPoint);
    }

    @NotNull
    public final double[] inflections() {
        if (this.points.getSize() < 4) {
            return EMPTY_DOUBLE_ARRAY;
        }
        PointList p = this.getAligned();
        Vector2D p1 = p.get(1);
        Vector2D p2 = p.get(2);
        Vector2D p3 = p.get(3);
        double a = p2.getX() * p1.getY();
        double b = p3.getX() * p1.getY();
        double c = p1.getX() * p2.getY();
        double d = p3.getX() * p2.getY();
        double v1 = 18.0 * (-3.0 * a + 2.0 * b + 3.0 * c - d);
        double v2 = 18.0 * (3.0 * a - b - 3.0 * c);
        double v3 = 18.0 * (c - a);
        if (IsAlmostZeroKt.isAlmostZero(v1)) {
            if (!IsAlmostZeroKt.isAlmostZero(v2)) {
                double t = -v3 / v2;
                boolean bl = 0.0 <= t ? t <= 1.0 : false;
                if (bl) {
                    double[] dArray = new double[]{t};
                    return dArray;
                }
            }
            return EMPTY_DOUBLE_ARRAY;
        }
        double d2 = 2.0 * v1;
        if (IsAlmostZeroKt.isAlmostEquals$default(d2, 0.0, 0.0, 2, null)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double trm = v2 * v2 - (double)4.0f * v1 * v3;
        if (trm < 0.0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double sq = Math.sqrt(trm);
        double out0 = (sq - v2) / d2;
        double out1 = -(v2 + sq) / d2;
        DoubleArrayList out = new DoubleArrayList(2);
        boolean bl = 0.0 <= out0 ? out0 <= 1.0 : false;
        if (bl) {
            out.add(out0);
        }
        boolean bl2 = 0.0 <= out1 ? out1 <= 1.0 : false;
        if (bl2) {
            out.add(out1);
        }
        return out.toDoubleArray();
    }

    @NotNull
    public final List<SubBezier> reduce() {
        Object object;
        int n;
        double[] extrema2;
        ArrayList<SubBezier> pass2;
        ArrayList<SubBezier> pass1;
        double step2;
        block12: {
            int n2;
            double it;
            int index$iv;
            int n3;
            boolean $i$f$indexOfFirst;
            double[] $this$indexOfFirst$iv;
            block11: {
                if (this.isLinear()) {
                    return CollectionsKt.listOf(new SubBezier(this));
                }
                step2 = Ratio.constructor-impl(0.01);
                pass1 = new ArrayList<SubBezier>();
                pass2 = new ArrayList<SubBezier>();
                extrema2 = null;
                $this$indexOfFirst$iv = extrema2 = this.getExtrema().getAllt();
                $i$f$indexOfFirst = false;
                n3 = $this$indexOfFirst$iv.length;
                for (index$iv = 0; index$iv < n3; ++index$iv) {
                    it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it == 0.0)) continue;
                    n2 = index$iv;
                    break block11;
                }
                n2 = -1;
            }
            if (n2 < 0) {
                $this$indexOfFirst$iv = new double[]{0.0};
                extrema2 = ArraysKt.plus($this$indexOfFirst$iv, extrema2);
            }
            $this$indexOfFirst$iv = extrema2;
            $i$f$indexOfFirst = false;
            n3 = $this$indexOfFirst$iv.length;
            for (index$iv = 0; index$iv < n3; ++index$iv) {
                it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it == 1.0)) continue;
                n = index$iv;
                break block12;
            }
            n = -1;
        }
        if (n < 0) {
            object = new double[]{1.0};
            extrema2 = ArraysKt.plus(extrema2, object);
        }
        Bezier $this$reduce_u24lambda_u245 = this;
        boolean bl = false;
        double t1 = _Math_interpolationKt.toRatio(extrema2[0]);
        int n4 = extrema2.length;
        for (int i2 = 1; i2 < n4; ++i2) {
            double t2 = _Math_interpolationKt.toRatio(extrema2[i2]);
            SubBezier segment = $this$reduce_u24lambda_u245.split-QGGGw1I(t1, t2);
            pass1.add(segment);
            t1 = t2;
        }
        object = pass1.iterator();
        while (object.hasNext()) {
            SubBezier segment;
            SubBezier p1Curve = (SubBezier)object.next();
            Bezier p1 = p1Curve.getCurve();
            t1 = Ratio.Companion.getZERO-eKSQRR4();
            double t2 = Ratio.Companion.getZERO-eKSQRR4();
            block4: while (Ratio.compareTo-kg1FUQ0(t2, Ratio.Companion.getONE-eKSQRR4()) <= 0) {
                t2 = Ratio.plus-ce6x77s(t1, step2);
                while (Ratio.compareTo-kg1FUQ0(t2, Ratio.plus-ce6x77s(Ratio.Companion.getONE-eKSQRR4(), step2)) <= 0) {
                    segment = p1.split-QGGGw1I(t1, t2);
                    if (!segment.getCurve().isSimple()) {
                        if (Ratio.compareTo-kg1FUQ0(_Math_interpolationKt.abs-kg1FUQ0(Ratio.minus-ce6x77s(t1, t2 = Ratio.minus-ce6x77s(t2, step2))), step2) < 0) {
                            return CollectionsKt.emptyList();
                        }
                        segment = p1.split-QGGGw1I(t1, t2);
                        pass2.add(new SubBezier(segment.getCurve(), Bezier.Companion.map-nq_ZziQ(t1, Ratio.Companion.getZERO-eKSQRR4(), Ratio.Companion.getONE-eKSQRR4(), p1Curve.getT1-eKSQRR4(), p1Curve.getT2-eKSQRR4()), Bezier.Companion.map-nq_ZziQ(t2, Ratio.Companion.getZERO-eKSQRR4(), Ratio.Companion.getONE-eKSQRR4(), p1Curve.getT1-eKSQRR4(), p1Curve.getT2-eKSQRR4()), this, null));
                        t1 = t2;
                        continue block4;
                    }
                    t2 = Ratio.plus-ce6x77s(t2, step2);
                }
            }
            if (Ratio.compareTo-kg1FUQ0(t1, Ratio.Companion.getONE-eKSQRR4()) >= 0) continue;
            segment = p1.split-QGGGw1I(t1, Ratio.Companion.getONE-eKSQRR4());
            pass2.add(new SubBezier(segment.getCurve(), Bezier.Companion.map-nq_ZziQ(t1, Ratio.Companion.getZERO-eKSQRR4(), Ratio.Companion.getONE-eKSQRR4(), p1Curve.getT1-eKSQRR4(), p1Curve.getT2-eKSQRR4()), p1Curve.getT2-eKSQRR4(), this, null));
        }
        return pass2;
    }

    public final boolean overlaps(@NotNull Bezier curve) {
        RectangleD lbbox = this.getBoundingBox();
        RectangleD tbbox = curve.getBoundingBox();
        return Bezier.Companion.bboxoverlap(lbbox, tbbox);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bezier> offset(double d) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.toSimpleList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SubBezier subBezier = (SubBezier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCurve().scaleSimple((Function1<? super Double, Double>)new Function1<Double, Double>(d){
                final /* synthetic */ double $d;
                {
                    this.$d = $d;
                    super(1);
                }

                @NotNull
                public final Double invoke(double it) {
                    return this.$d;
                }
            }));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vector2D offset-DJj3pIk(double t, double d) {
        void that$iv;
        void this_$iv;
        Vector2D pos = this.calc-kg1FUQ0(t);
        Vector2D normal2 = this.normal-kg1FUQ0(t);
        Vector2D vector2D = pos;
        Vector2D this_$iv2 = normal2;
        boolean $i$f$times = false;
        this_$iv2 = new Vector2D(this_$iv2.getX() * d, this_$iv2.getY() * d);
        boolean $i$f$plus = false;
        return new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bezier scaleSimple(@NotNull Function1<? super Double, Double> d) {
        double r0 = ((Number)d.invoke((Double)0.0)).doubleValue();
        double r1 = ((Number)d.invoke((Double)1.0)).doubleValue();
        if (this.isLinear()) {
            void that$iv;
            Vector2D this_$iv;
            Vector2D nv = this.normal-kg1FUQ0(Ratio.Companion.getZERO-eKSQRR4());
            Vector2D vector2D = this.points.get(0);
            Vector2D this_$iv2 = nv;
            boolean $i$f$times = false;
            this_$iv2 = new Vector2D(this_$iv2.getX() * r0, this_$iv2.getY() * r0);
            boolean $i$f$plus = false;
            Vector2D vector2D2 = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
            this_$iv = this.points.get(1);
            this_$iv2 = nv;
            $i$f$times = false;
            this_$iv2 = new Vector2D(this_$iv2.getX() * r1, this_$iv2.getY() * r1);
            $i$f$plus = false;
            return new Bezier(vector2D2, new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY()));
        }
        Vector2D c0 = this.calc-kg1FUQ0(Ratio.Companion.getZERO-eKSQRR4());
        Vector2D c1 = this.calc-kg1FUQ0(Ratio.Companion.getONE-eKSQRR4());
        Vector2D n0 = this.normal-kg1FUQ0(Ratio.Companion.getZERO-eKSQRR4());
        Vector2D n1 = this.normal-kg1FUQ0(Ratio.Companion.getONE-eKSQRR4());
        Vector2D[] vector2DArray = new Vector2D[]{this.offset-DJj3pIk(Ratio.Companion.getZERO-eKSQRR4(), 10.0), this.offset-DJj3pIk(Ratio.Companion.getONE-eKSQRR4(), 10.0)};
        List<Vector2D> v = CollectionsKt.listOf(vector2DArray);
        Vector2D vector2D = Bezier.Companion.lli4(v.get(0), c0, v.get(1), c1);
        if (vector2D == null) {
            throw new IllegalStateException("cannot scale this curve. Try reducing it first.".toString());
        }
        Vector2D o = vector2D;
        PointArrayList np = new PointArrayList(this.points.getSize());
        boolean singleDist = r0 == r1 && r0 == ((Number)d.invoke((Double)0.5)).doubleValue();
        int n = 0;
        int n2 = this.getOrder();
        if (n <= n2) {
            do {
                void that$iv;
                void this_$iv;
                Vector2D p;
                int t;
                int n3;
                if ((n3 = ++n) == 0) {
                    np.add(r0 * n0.getX(), r0 * n0.getY());
                    continue;
                }
                if (n3 == this.getOrder()) {
                    np.add(r1 * n1.getX(), r1 * n1.getY());
                    continue;
                }
                if (singleDist) {
                    t = n - 1;
                    p = np.get(t * this.getOrder());
                    Vector2D d2 = Bezier.derivative-DJj3pIk$default(this, _Math_interpolationKt.toRatio((double)t), false, 2, null);
                    Vector2D p2 = new Vector2D(p.getX() + d2.getX(), p.getY() + d2.getY());
                    Vector2D vector2D3 = Bezier.Companion.lli4(p, p2, o, this.points.get(t + 1));
                    if (vector2D3 == null) {
                        throw new IllegalStateException("Invalid curve".toString());
                    }
                    np.add(vector2D3);
                    continue;
                }
                t = n - 1;
                Vector2D this_$iv3 = p = this.points.get(t + 1);
                boolean $i$f$minus = false;
                Vector2D ov = new Vector2D(this_$iv3.getX() - o.getX(), this_$iv3.getY() - o.getY());
                double rc = ((Number)d.invoke((Double)((double)(t + 1) / (double)this.getOrder()))).doubleValue();
                if (!this.getClockwise()) {
                    rc = -rc;
                }
                Vector2D vector2D4 = p;
                Vector2D this_$iv4 = ov.getNormalized();
                boolean $i$f$times = false;
                this_$iv4 = new Vector2D(this_$iv4.getX() * rc, this_$iv4.getY() * rc);
                boolean $i$f$plus = false;
                np.add(new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY()));
            } while (n != n2);
        }
        return new Bezier(np);
    }

    /*
     * WARNING - void declaration
     */
    private final Bezier raise() {
        PointList p = this.points;
        PointArrayList np = new PointArrayList(0, 1, null);
        np.add(p.get(0));
        int k = p.getSize();
        for (int i2 = 1; i2 < k; ++i2) {
            void that$iv;
            Vector2D this_$iv;
            void this_$iv$iv;
            void this_$iv$iv2;
            Vector2D this_$iv2;
            Vector2D pi = p.get(i2);
            Vector2D pim = p.get(i2 - 1);
            Vector2D vector2D = pi;
            int scale$iv = k - i2;
            boolean $i$f$times22 = false;
            void var10_14 = this_$iv2;
            double scale$iv$iv = scale$iv;
            boolean $i$f$times = false;
            this_$iv2 = new Vector2D(this_$iv$iv2.getX() * scale$iv$iv, this_$iv$iv2.getY() * scale$iv$iv);
            boolean $i$f$div22 = false;
            Vector2D $i$f$times22 = this_$iv2;
            double scale$iv$iv2 = k;
            boolean $i$f$div = false;
            this_$iv2 = new Vector2D(this_$iv$iv.getX() / scale$iv$iv2, this_$iv$iv.getY() / scale$iv$iv2);
            Vector2D $i$f$div22 = pim;
            double scale$iv2 = (double)i2 / (double)k;
            boolean $i$f$times3 = false;
            this_$iv = new Vector2D(this_$iv.getX() * scale$iv2, this_$iv.getY() * scale$iv2);
            boolean $i$f$plus = false;
            np.add(new Vector2D(this_$iv2.getX() + that$iv.getX(), this_$iv2.getY() + that$iv.getY()));
        }
        np.add(p, k - 1);
        return new Bezier(np);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleArrayList selfIntersections(double threshold, @NotNull DoubleArrayList out) {
        List<SubBezier> reduced = this.reduce();
        int len = reduced.size() - 2;
        DoubleArrayList results = out;
        for (int i2 = 0; i2 < len; ++i2) {
            void $this$mapDouble$iv;
            DoubleArrayList doubleArrayList;
            List<SubBezier> left = CollectionsKt.slice(reduced, RangesKt.until(i2, i2 + 1));
            List<SubBezier> right = CollectionsKt.slice(reduced, RangesKt.until(i2 + 2, reduced.size()));
            List result2 = Bezier.Companion.curveintersects(left, right, threshold);
            Iterable iterable = result2;
            DoubleArrayList doubleArrayList2 = results;
            boolean $i$f$mapDouble = false;
            DoubleArrayList it$iv = doubleArrayList = new DoubleArrayList(0, 1, null);
            boolean bl = false;
            for (Object v$iv : $this$mapDouble$iv) {
                void it;
                Pair pair = (Pair)v$iv;
                DoubleArrayList doubleArrayList3 = it$iv;
                boolean bl2 = false;
                double d = Ratio.toDouble-impl(((Ratio)it.getFirst()).unbox-impl());
                doubleArrayList3.add(d);
            }
            doubleArrayList2.add(doubleArrayList);
        }
        return results;
    }

    public static /* synthetic */ DoubleArrayList selfIntersections$default(Bezier bezier, double d, DoubleArrayList doubleArrayList, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        if ((n & 2) != 0) {
            doubleArrayList = new DoubleArrayList(0, 1, null);
        }
        return bezier.selfIntersections(d, doubleArrayList);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final double[] intersections(@NotNull Line2D line2) {
        void $this$filterTo$iv$iv;
        double minX = line2.getMinX();
        double minY = line2.getMinY();
        double maxX = line2.getMaxX();
        double maxY = line2.getMaxY();
        double[] $this$filter$iv = Bezier.Companion.roots(this.points, line2);
        boolean $i$f$filter = false;
        double[] dArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void t = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            Vector2D p = this.get-kg1FUQ0(_Math_interpolationKt.toRatio((double)t));
            if (!(Bezier.Companion.between(p.getX(), minX, maxX) && Bezier.Companion.between(p.getY(), minY, maxY))) continue;
            destination$iv$iv.add((double)element$iv$iv);
        }
        return CollectionsKt.toDoubleArray((List)destination$iv$iv);
    }

    @NotNull
    public final List<Pair<Ratio, Ratio>> intersections(@NotNull Bezier curve, double threshold) {
        return Bezier.Companion.curveintersects(this.reduce(), curve.reduce(), threshold);
    }

    public static /* synthetic */ List intersections$default(Bezier bezier, Bezier bezier2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        return bezier.intersections(bezier2, d);
    }

    @NotNull
    public final Vector2D compute-kg1FUQ0(double t) {
        return Bezier.Companion.compute-DJj3pIk(t, this.points);
    }

    @NotNull
    public final Vector2D derivative-DJj3pIk(double t, boolean normalize) {
        Vector2D out = Bezier.Companion.compute-DJj3pIk(t, this.getDpoints().get(0));
        if ((Ratio.equals-impl0(t, Ratio.Companion.getZERO-eKSQRR4()) || Ratio.equals-impl0(t, Ratio.Companion.getONE-eKSQRR4())) && IsAlmostZeroKt.isAlmostZero(out.getLengthSquared())) {
            for (int n = 0; n < 10; ++n) {
                double newT = Math.pow(10.0, -(10 - n));
                double nt = Ratio.equals-impl0(t, Ratio.Companion.getONE-eKSQRR4()) ? 1.0 - newT : newT;
                out = Bezier.Companion.compute-DJj3pIk(Ratio.constructor-impl(nt), this.getDpoints().get(0));
                if (!IsAlmostZeroKt.isAlmostZero(out.getLengthSquared())) break;
            }
        }
        if (normalize) {
            out = out.getNormalized();
        }
        return out;
    }

    public static /* synthetic */ Vector2D derivative-DJj3pIk$default(Bezier bezier, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return bezier.derivative-DJj3pIk(d, bl);
    }

    @NotNull
    public final Vector2D normal-DJj3pIk(double t, boolean normalize) {
        return this.derivative-DJj3pIk(t, normalize).toNormal();
    }

    public static /* synthetic */ Vector2D normal-DJj3pIk$default(Bezier bezier, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return bezier.normal-DJj3pIk(d, bl);
    }

    @Override
    @NotNull
    public Vector2D normal-kg1FUQ0(double t) {
        return this.normal-DJj3pIk(t, true);
    }

    @Override
    @NotNull
    public Vector2D tangent-kg1FUQ0(double t) {
        return this.derivative-DJj3pIk(t, true);
    }

    @NotNull
    public final PointList hull-DJj3pIk(double t, @NotNull PointArrayList out) {
        if (this.getOrder() < 2) {
            throw new IllegalStateException(("Can't compute hull of order=" + this.getOrder() + " < 2").toString());
        }
        PointList pointList = this.hullOrNull-DJj3pIk(t, out);
        Intrinsics.checkNotNull(pointList);
        return pointList;
    }

    public static /* synthetic */ PointList hull-DJj3pIk$default(Bezier bezier, double d, PointArrayList pointArrayList, int n, Object object) {
        if ((n & 2) != 0) {
            pointArrayList = new PointArrayList(0, 1, null);
        }
        return bezier.hull-DJj3pIk(d, pointArrayList);
    }

    @NotNull
    public final Curvature curvature-DJj3pIk(double t, boolean kOnly) {
        return Bezier.Companion.curvature-OzkQpaQ(t, this.getDpoints().get(0), this.getDpoints().get(1), this.getDims(), kOnly);
    }

    public static /* synthetic */ Curvature curvature-DJj3pIk$default(Bezier bezier, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return bezier.curvature-DJj3pIk(d, bl);
    }

    @Nullable
    public final PointList hullOrNull-DJj3pIk(double t, @NotNull PointArrayList out) {
        if (this.getOrder() < 2) {
            return null;
        }
        PointList p = this.points;
        out.add(p, 0);
        out.add(p, 1);
        out.add(p, 2);
        if (this.getOrder() == 3) {
            out.add(p, 3);
        }
        while (p.getSize() > 1) {
            PointArrayList next = new PointArrayList(0, 1, null);
            int n = p.getSize() - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                Vector2D p2 = _Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio-kg1FUQ0(t), p.get(i2), p.get(i2 + 1));
                out.add(p2);
                next.add(p2);
            }
            p = next;
        }
        return out;
    }

    public static /* synthetic */ PointList hullOrNull-DJj3pIk$default(Bezier bezier, double d, PointArrayList pointArrayList, int n, Object object) {
        if ((n & 2) != 0) {
            pointArrayList = new PointArrayList(0, 1, null);
        }
        return bezier.hullOrNull-DJj3pIk(d, pointArrayList);
    }

    @NotNull
    public final SubBezier split-QGGGw1I(double t0, double t1) {
        return new SubBezier(this.splitRight-kg1FUQ0(t0).splitLeft-kg1FUQ0(Bezier.Companion.map-nq_ZziQ(t1, t0, Ratio.Companion.getONE-eKSQRR4(), Ratio.Companion.getZERO-eKSQRR4(), Ratio.Companion.getONE-eKSQRR4())).getCurve(), t0, t1, this, null);
    }

    @NotNull
    public final CurveSplit split-kg1FUQ0(double t) {
        return new SubBezier(this).split-kg1FUQ0(t);
    }

    @NotNull
    public final SubBezier splitLeft-kg1FUQ0(double t) {
        return new SubBezier(this).splitLeft-kg1FUQ0(t);
    }

    @NotNull
    public final SubBezier splitRight-kg1FUQ0(double t) {
        return new SubBezier(this).splitRight-kg1FUQ0(t);
    }

    @NotNull
    public final Line2D toLine() {
        return new Line2D(this.points.get(0), this.points.get(this.getOrder()));
    }

    @NotNull
    public final Bezier toLineBezier() {
        return new Bezier(this.points.get(0), this.points.get(this.getOrder()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bezier toCubic() {
        Bezier bezier;
        switch (this.getOrder()) {
            case 1: {
                void that$iv;
                Vector2D this_$iv;
                Vector2D p1;
                Vector2D p0 = this.points.get(0);
                Vector2D this_$iv2 = p1 = this.points.get(1);
                boolean $i$f$minus = false;
                Vector2D pd = new Vector2D(this_$iv2.getX() - p0.getX(), this_$iv2.getY() - p0.getY());
                double r1 = 0.3333333333333333;
                double r2 = 0.6666666666666666;
                Vector2D vector2D = p0;
                Vector2D this_$iv3 = pd;
                boolean $i$f$times = false;
                this_$iv3 = new Vector2D(this_$iv3.getX() * r1, this_$iv3.getY() * r1);
                boolean $i$f$plus = false;
                Vector2D vector2D2 = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
                this_$iv = p0;
                this_$iv3 = pd;
                $i$f$times = false;
                this_$iv3 = new Vector2D(this_$iv3.getX() * r2, this_$iv3.getY() * r2);
                $i$f$plus = false;
                Bezier bezier2 = new Bezier(p0, vector2D2, new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY()), p1);
                bezier = bezier2;
                break;
            }
            case 2: {
                Vector2D p0 = this.points.get(0);
                Vector2D pc = this.points.get(1);
                Vector2D p1 = this.points.get(2);
                bezier = new Bezier(p0, Companion.quadToCubic1(p0, pc), Companion.quadToCubic2(pc, p1), p1);
                break;
            }
            case 3: {
                bezier = this;
                break;
            }
            default: {
                String string = "Unsupported higher order curves";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return bezier;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bezier toQuad() {
        Bezier bezier;
        switch (this.getOrder()) {
            case 1: {
                Vector2D p0 = this.points.get(0);
                Vector2D p1 = this.points.get(1);
                Vector2D this_$iv = p0;
                boolean $i$f$plus = false;
                this_$iv = new Vector2D(this_$iv.getX() + p1.getX(), this_$iv.getY() + p1.getY());
                double scale$iv = 0.5;
                boolean $i$f$times = false;
                Bezier bezier2 = new Bezier(p0, new Vector2D(this_$iv.getX() * scale$iv, this_$iv.getY() * scale$iv), p1);
                bezier = bezier2;
                break;
            }
            case 2: {
                bezier = this;
                break;
            }
            case 3: {
                Vector2D that$iv;
                Vector2D this_$iv$iv;
                Vector2D this_$iv;
                void this_$iv$iv2;
                Vector2D this_$iv2;
                Vector2D p0 = this.points.get(0);
                Vector2D pc1 = this.points.get(1);
                Vector2D pc2 = this.points.get(2);
                Vector2D p1 = this.points.get(3);
                Vector2D $i$f$times = p0;
                float scale$iv = 0.25f;
                boolean $i$f$times2 = false;
                void var9_23 = this_$iv2;
                double scale$iv$iv22 = scale$iv;
                boolean $i$f$times3 = false;
                this_$iv2 = new Vector2D(this_$iv$iv2.getX() * scale$iv$iv22, this_$iv$iv2.getY() * scale$iv$iv22);
                boolean $i$f$unaryMinus22 = false;
                this_$iv2 = new Vector2D(-this_$iv2.getX(), -this_$iv2.getY());
                Vector2D $i$f$unaryMinus22 = pc1;
                float scale$iv2 = 0.75f;
                boolean $i$f$times4 = false;
                void scale$iv$iv22 = this_$iv;
                double scale$iv$iv = scale$iv2;
                boolean $i$f$times5 = false;
                this_$iv = new Vector2D(this_$iv$iv.getX() * scale$iv$iv, this_$iv$iv.getY() * scale$iv$iv);
                boolean $i$f$plus = false;
                this_$iv2 = new Vector2D(this_$iv2.getX() + that$iv.getX(), this_$iv2.getY() + that$iv.getY());
                that$iv = pc2;
                scale$iv = 0.75f;
                $i$f$times4 = false;
                this_$iv$iv = this_$iv;
                scale$iv$iv = scale$iv;
                $i$f$times5 = false;
                this_$iv = new Vector2D(this_$iv$iv.getX() * scale$iv$iv, this_$iv$iv.getY() * scale$iv$iv);
                $i$f$plus = false;
                this_$iv2 = new Vector2D(this_$iv2.getX() + that$iv.getX(), this_$iv2.getY() + that$iv.getY());
                that$iv = p1;
                scale$iv = 0.25f;
                $i$f$times4 = false;
                this_$iv$iv = this_$iv;
                scale$iv$iv = scale$iv;
                $i$f$times5 = false;
                this_$iv = new Vector2D(this_$iv$iv.getX() * scale$iv$iv, this_$iv$iv.getY() * scale$iv$iv);
                boolean $i$f$minus = false;
                Vector2D pc = new Vector2D(this_$iv2.getX() - that$iv.getX(), this_$iv2.getY() - that$iv.getY());
                return new Bezier(p0, pc, p1);
            }
            default: {
                String string = "Unsupported higher order curves";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return bezier;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bezier> toQuadList() {
        void $this$mapTo$iv$iv;
        if (this.getOrder() == 2) {
            return CollectionsKt.listOf(this);
        }
        Iterable $this$map$iv = this.toSimpleList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SubBezier subBezier = (SubBezier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCurve().toQuad());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Curves outline(double d1, double d2, double d3, double d4) {
        Object segment2;
        Bezier it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (this.isLinear()) {
            Vector2D n = this.normal-kg1FUQ0(Ratio.Companion.getZERO-eKSQRR4());
            Vector2D start2 = this.points.get(0);
            Vector2D end2 = this.points.get(this.points.getSize() - 1);
            Bezier $this$outline_u24lambda_u2410 = this;
            boolean bl = false;
            Vector2D s = new Vector2D(start2.getX() + n.getX() * d1, start2.getY() + n.getY() * d1);
            Vector2D e = new Vector2D(end2.getX() + n.getX() * d3, end2.getY() + n.getY() * d3);
            Vector2D mid = new Vector2D((s.getX() + e.getX()) / 2.0, (s.getY() + e.getY()) / 2.0);
            PointArrayList fline = VectorsListKt.pointArrayListOf(s, mid, e);
            Bezier $this$outline_u24lambda_u2411 = this;
            boolean bl2 = false;
            Vector2D s2 = new Vector2D(start2.getX() - n.getX() * d2, start2.getY() - n.getY() * d2);
            Vector2D e2 = new Vector2D(end2.getX() - n.getX() * d4, end2.getY() - n.getY() * d4);
            Vector2D mid2 = new Vector2D((s2.getX() + e2.getX()) / 2.0, (s2.getY() + e2.getY()) / 2.0);
            PointArrayList bline = VectorsListKt.pointArrayListOf(e2, mid2, s2);
            Bezier ls = Bezier.Companion.makeline(bline.get(2), fline.get(0));
            Bezier le = Bezier.Companion.makeline(fline.get(2), bline.get(0));
            Bezier[] bezierArray = new Bezier[]{ls, new Bezier(fline), le, new Bezier(bline)};
            List<Bezier> segments = CollectionsKt.listOf(bezierArray);
            return new Curves(segments, true);
        }
        List<SubBezier> reduced = this.reduce();
        int len = reduced.size();
        ArrayList<Bezier> fcurves = new ArrayList<Bezier>();
        ArrayList<Bezier> bcurves0 = new ArrayList<Bezier>();
        double tlen = this.getLength();
        boolean graduated = !(d3 == d1) && !(d4 == d2);
        double alen = 0.0;
        Iterable $this$map$iv = reduced;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SubBezier subBezier = (SubBezier)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((SubBezier)((Object)it)).getCurve());
        }
        for (Object segment2 : (List)destination$iv$iv) {
            double slen = ((Bezier)segment2).getLength();
            if (graduated) {
                fcurves.add(((Bezier)segment2).scaleSimple(Bezier.outline$linearDistanceFunction(d1, d3, tlen, alen, slen)));
                bcurves0.add(((Bezier)segment2).scaleSimple(Bezier.outline$linearDistanceFunction(-d2, -d4, tlen, alen, slen)));
            } else {
                fcurves.add(((Bezier)segment2).scaleSimple(d1));
                bcurves0.add(((Bezier)segment2).scaleSimple(-d2));
            }
            alen += slen;
        }
        segment2 = bcurves0;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PointArrayList pointArrayList;
            it = (Bezier)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PointArrayList it2 = pointArrayList = PointList.DefaultImpls.clone$default(it.points, null, 1, null);
            boolean bl3 = false;
            it2.reverse();
            PointList pointList = pointArrayList;
            collection.add(new Bezier(pointList));
        }
        List bcurves = CollectionsKt.reversed((List)destination$iv$iv);
        Vector2D fs = ((Bezier)fcurves.get((int)0)).points.get(0);
        Vector2D fe = ((Bezier)fcurves.get((int)(len - 1))).points.get(((Bezier)fcurves.get((int)(len - 1))).points.getSize() - 1);
        Vector2D bs = ((Bezier)bcurves.get((int)(len - 1))).points.get(((Bezier)bcurves.get((int)(len - 1))).points.getSize() - 1);
        Vector2D be = ((Bezier)bcurves.get((int)0)).points.get(0);
        Bezier ls = Bezier.Companion.makeline(bs, fs);
        Bezier le = Bezier.Companion.makeline(fe, be);
        return _MathGeom_bezierKt.ListCurve_toCurves(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(ls), (Iterable)fcurves), le), (Iterable)bcurves), true);
    }

    public static /* synthetic */ Curves outline$default(Bezier bezier, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        if ((n & 4) != 0) {
            d3 = d;
        }
        if ((n & 8) != 0) {
            d4 = d2;
        }
        return bezier.outline(d, d2, d3, d4);
    }

    @NotNull
    public final Bezier translate(double dx, double dy) {
        return new Bezier(VectorsListKt.mapPoints(this.points, (Function1<? super Vector2D, Vector2D>)new Function1<Vector2D, Vector2D>(dx, dy){
            final /* synthetic */ double $dx;
            final /* synthetic */ double $dy;
            {
                this.$dx = $dx;
                this.$dy = $dy;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Vector2D invoke(@NotNull Vector2D p) {
                void this_$iv;
                Vector2D vector2D = p;
                Vector2D that$iv = new Vector2D(this.$dx, this.$dy);
                boolean $i$f$plus = false;
                return new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
            }
        }));
    }

    @NotNull
    public final Bezier transform(@NotNull Matrix m) {
        return new Bezier(VectorsListKt.mapPoints(this.points, (Function1<? super Vector2D, Vector2D>)new Function1<Vector2D, Vector2D>(m){
            final /* synthetic */ Matrix $m;
            {
                this.$m = $m;
                super(1);
            }

            @NotNull
            public final Vector2D invoke(@NotNull Vector2D p) {
                Matrix this_$iv = this.$m;
                boolean $i$f$transform = false;
                return this_$iv.isNIL() ? p : new Vector2D(this_$iv.transformX(p.getX(), p.getY()), this_$iv.transformY(p.getX(), p.getY()));
            }
        }));
    }

    @Override
    public int recommendedDivisions() {
        return Curve.DefaultImpls.recommendedDivisions(this);
    }

    @Override
    @NotNull
    public Vector2D calcOffset-DJj3pIk(double t, double offset2) {
        return Curve.DefaultImpls.calcOffset-DJj3pIk(this, t, offset2);
    }

    private static final Function1<Double, Double> outline$linearDistanceFunction(double s, double e, double tlen, double alen, double slen) {
        return new Function1<Double, Double>(alen, tlen, slen, e, s){
            final /* synthetic */ double $alen;
            final /* synthetic */ double $tlen;
            final /* synthetic */ double $slen;
            final /* synthetic */ double $e;
            final /* synthetic */ double $s;
            {
                this.$alen = $alen;
                this.$tlen = $tlen;
                this.$slen = $slen;
                this.$e = $e;
                this.$s = $s;
                super(1);
            }

            @NotNull
            public final Double invoke(double v) {
                double f1 = this.$alen / this.$tlen;
                double f2 = (this.$alen + this.$slen) / this.$tlen;
                double d = this.$e - this.$s;
                return ConvertRangeKt.convertRange(v, 0.0, 1.0, this.$s + f1 * d, this.$s + f2 * d);
            }
        };
    }

    public static final /* synthetic */ RectangleD access$_getBoundingBox(Bezier $this, Matrix m) {
        return $this._getBoundingBox(m);
    }

    public static final /* synthetic */ PointList access$getAligned(Bezier $this) {
        return $this.getAligned();
    }

    static {
        double[] dArray = new double[]{-0.06405689286260563, 0.06405689286260563, -0.1911188674736163, 0.1911188674736163, -0.3150426796961634, 0.3150426796961634, -0.4337935076260451, 0.4337935076260451, -0.5454214713888396, 0.5454214713888396, -0.6480936519369755, 0.6480936519369755, -0.7401241915785544, 0.7401241915785544, -0.820001985973903, 0.820001985973903, -0.8864155270044011, 0.8864155270044011, -0.9382745520027328, 0.9382745520027328, -0.9747285559713095, 0.9747285559713095, -0.9951872199970213, 0.9951872199970213};
        T_VALUES = dArray;
        dArray = new double[]{0.12793819534675216, 0.12793819534675216, 0.1258374563468283, 0.1258374563468283, 0.12167047292780339, 0.12167047292780339, 0.1155056680537256, 0.1155056680537256, 0.10744427011596563, 0.10744427011596563, 0.09761865210411388, 0.09761865210411388, 0.08619016153195327, 0.08619016153195327, 0.0733464814110803, 0.0733464814110803, 0.05929858491543678, 0.05929858491543678, 0.04427743881741981, 0.04427743881741981, 0.028531388628933663, 0.028531388628933663, 0.0123412297999872, 0.0123412297999872};
        C_VALUES = dArray;
        X_AXIS = new Line2D(0, 0, 1, 0);
        EMPTY_DOUBLE_ARRAY = new double[0];
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u009b\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\n\u0010\"\u001a\u00060\rj\u0002`\u000e2\b\b\u0002\u0010#\u001a\u00020$H\u0002J,\u0010%\u001a\u00020\u00102\n\u0010&\u001a\u00060'j\u0002`(2\n\u0010)\u001a\u00060'j\u0002`(2\n\u0010*\u001a\u00060'j\u0002`(H\u0002J \u0010+\u001a\u00020,2\n\u0010-\u001a\u00060\u0012j\u0002`\u00132\n\u0010.\u001a\u00060\u0012j\u0002`\u0013H\u0002J \u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u0010H\u0002J\u0018\u00103\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004H\u0002J&\u00104\u001a\u00060'j\u0002`(2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010!\u001a\u00020 H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b5\u00106J\u0010\u00107\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u0010H\u0002JL\u00108\u001a\u00060'j\u0002`(2\n\u00109\u001a\u00060'j\u0002`(2\n\u0010:\u001a\u00060'j\u0002`(2\n\u0010;\u001a\u00060'j\u0002`(2\n\u0010<\u001a\u00060'j\u0002`(2\u0006\u0010\u001a\u001a\u00020\u0019\u00f8\u0001\u0000\u00a2\u0006\u0004\b=\u0010>J\u00a6\u0001\u00108\u001a\u0002H?\"\u0004\b\u0000\u0010?2\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001926\u0010H\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\bJ\u0012\b\bK\u0012\u0004\b\b(L\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\bJ\u0012\b\bK\u0012\u0004\b\b(M\u0012\u0004\u0012\u0002H?0IH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\n \u0001\u00a2\u0006\u0004\bN\u0010OJJ\u0010P\u001a\u00020Q2\n\u0010R\u001a\u00060'j\u0002`(2\n\u0010S\u001a\u00060'j\u0002`(2\n\u0010T\u001a\u00060'j\u0002`(2\b\b\u0002\u0010\u001a\u001a\u00020\u00192\n\b\u0002\u0010U\u001a\u0004\u0018\u00010\u0010\u00f8\u0001\u0000\u00a2\u0006\u0004\bV\u0010WJ<\u0010X\u001a\u00020Y2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010U\u001a\u00020 2\u0006\u0010Z\u001a\u00020 2\u0006\u0010[\u001a\u00020\u001c2\b\b\u0002\u0010\\\u001a\u00020,H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b]\u0010^J@\u0010_\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190a0`2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020c0`2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020c0`2\b\b\u0002\u0010e\u001a\u00020\u0010H\u0002J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020 0`2\u0006\u0010!\u001a\u00020 H\u0002J \u0010g\u001a\u00020\u00102\n\u0010:\u001a\u00060'j\u0002`(2\n\u0010;\u001a\u00060'j\u0002`(H\u0002J&\u0010h\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00102\b\b\u0002\u0010*\u001a\u00020\u00102\b\b\u0002\u0010i\u001a\u00020\u0010H\u0002J\u0010\u0010j\u001a\u00020\u00042\u0006\u0010k\u001a\u00020\u0004H\u0002JH\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020\u001c2\n\u0010R\u001a\u00060'j\u0002`(2\n\u0010S\u001a\u00060'j\u0002`(2\n\u0010T\u001a\u00060'j\u0002`(2\b\b\u0002\u0010\u001a\u001a\u00020\u0019H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bo\u0010pJ@\u0010q\u001a\n\u0018\u00010'j\u0004\u0018\u0001`(2\n\u0010:\u001a\u00060'j\u0002`(2\n\u0010;\u001a\u00060'j\u0002`(2\n\u0010<\u001a\u00060'j\u0002`(2\n\u0010r\u001a\u00060'j\u0002`(H\u0002JP\u0010s\u001a\n\u0018\u00010'j\u0004\u0018\u0001`(2\u0006\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00102\u0006\u0010t\u001a\u00020\u00102\u0006\u0010u\u001a\u00020\u0010H\u0002J \u0010v\u001a\u00020Q2\n\u0010:\u001a\u00060'j\u0002`(2\n\u0010;\u001a\u00060'j\u0002`(H\u0002J:\u0010w\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00192\u0006\u0010x\u001a\u00020\u00192\u0006\u0010y\u001a\u00020\u00192\u0006\u0010z\u001a\u00020\u00192\u0006\u0010{\u001a\u00020\u0019H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b|\u0010}J4\u0010~\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190a0`2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020c2\b\b\u0002\u0010e\u001a\u00020\u0010H\u0002J%\u0010\u007f\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0005\b\u0080\u0001\u0010\u001eJD\u0010\u0081\u0001\u001a\u00060'j\u0002`(2\n\u0010k\u001a\u00060'j\u0002`(2\u000b\u0010\u0082\u0001\u001a\u00060'j\u0002`(2\n\u0010-\u001a\u00060'j\u0002`(2\u0006\u0010\u001a\u001a\u00020\u0019\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001J\u009b\u0001\u0010\u0081\u0001\u001a\u0002H?\"\u0004\b\u0000\u0010?2\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00102\u0007\u0010\u0085\u0001\u001a\u00020\u00102\u0007\u0010\u0086\u0001\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001926\u0010H\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\bJ\u0012\b\bK\u0012\u0004\b\b(L\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\bJ\u0012\b\bK\u0012\u0004\b\b(M\u0012\u0004\u0012\u0002H?0IH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\b \u0001\u00a2\u0006\u0006\b\u0087\u0001\u0010\u0088\u0001J\u0097\u0002\u0010\u0089\u0001\u001a\u0002H?\"\u0004\b\u0000\u0010?2\u0006\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00102\u0007\u0010\u0085\u0001\u001a\u00020\u00102\u0007\u0010\u0086\u0001\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u00102\u00bf\u0001\u0010\u008a\u0001\u001a\u00b9\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u008c\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u008d\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u008e\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u008f\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u0090\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u0091\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u0092\u0001\u0012\u0014\u0012\u00120\u0010\u00a2\u0006\r\bJ\u0012\t\bK\u0012\u0005\b\b(\u0093\u0001\u0012\u0004\u0012\u0002H?0\u008b\u0001H\u0086\b\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0007 \u0001\u00a2\u0006\u0003\u0010\u0094\u0001J%\u0010\u0095\u0001\u001a\u00060'j\u0002`(2\n\u0010-\u001a\u00060'j\u0002`(2\n\u0010.\u001a\u00060'j\u0002`(H\u0001J\u0019\u0010\u0095\u0001\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0001J%\u0010\u0096\u0001\u001a\u00060'j\u0002`(2\n\u0010-\u001a\u00060'j\u0002`(2\n\u0010.\u001a\u00060'j\u0002`(H\u0001J\u0019\u0010\u0096\u0001\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0001JA\u0010\u0097\u0001\u001a\u00020Q2\n\u0010:\u001a\u00060'j\u0002`(2\n\u0010;\u001a\u00060'j\u0002`(2\n\u0010<\u001a\u00060'j\u0002`(2\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0098\u0001\u0010\u0099\u0001J\u001f\u0010\u009a\u0001\u001a\u00020\u00042\u0006\u0010!\u001a\u00020 2\f\b\u0002\u0010\"\u001a\u00060\rj\u0002`\u000eH\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\u0007R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\u00020\u0010*\u00060\u0012j\u0002`\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\u00020\u0010*\u00060\u0012j\u0002`\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u009c\u0001"}, d2={"Lkorlibs/math/geom/bezier/Bezier$Companion;", "", "()V", "C_VALUES", "", "getC_VALUES$annotations", "getC_VALUES", "()[D", "EMPTY_DOUBLE_ARRAY", "T_VALUES", "getT_VALUES$annotations", "getT_VALUES", "X_AXIS", "Lkorlibs/math/geom/Line2D;", "Lkorlibs/math/geom/Line;", "tau", "", "midX", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "getMidX", "(Lkorlibs/math/geom/RectangleD;)D", "midY", "getMidY", "abcratio", "Lkorlibs/math/interpolation/Ratio;", "t", "n", "", "abcratio-vxhRpak", "(DI)D", "align", "Lkorlibs/math/geom/PointList;", "points", "line", "out", "Lkorlibs/math/geom/PointArrayList;", "angle", "o", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "v1", "v2", "bboxoverlap", "", "a", "b", "between", "v", "min", "max", "combineSmallDistinctSorted", "compute", "compute-DJj3pIk", "(DLkorlibs/math/geom/PointList;)Lkorlibs/math/geom/Vector2D;", "crt", "cubicCalc", "p0", "p1", "p2", "p3", "cubicCalc--1ayk3M", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;D)Lkorlibs/math/geom/Vector2D;", "T", "x0", "y0", "x1", "y1", "x2", "y2", "x3", "y3", "emit", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "x", "y", "cubicCalc-rtMv0Vs", "(DDDDDDDDDLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "cubicFromPoints", "Lkorlibs/math/geom/bezier/Bezier;", "S", "B", "E", "d1", "cubicFromPoints-xqnzwCs", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;DLjava/lang/Double;)Lkorlibs/math/geom/bezier/Bezier;", "curvature", "Lkorlibs/math/geom/bezier/Bezier$Curvature;", "d2", "dims", "kOnly", "curvature-OzkQpaQ", "(DLkorlibs/math/geom/PointList;Lkorlibs/math/geom/PointList;IZ)Lkorlibs/math/geom/bezier/Bezier$Curvature;", "curveintersects", "", "Lkotlin/Pair;", "c1", "Lkorlibs/math/geom/bezier/SubBezier;", "c2", "threshold", "derive", "dist", "doubleArrayOfValid01", "v3", "droots", "p", "getABC", "Lkorlibs/math/geom/bezier/Bezier$Companion$ABCResult;", "order", "getABC--1ayk3M", "(ILkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;D)Lkorlibs/math/geom/bezier/Bezier$Companion$ABCResult;", "lli4", "p4", "lli8", "x4", "y4", "makeline", "map", "ds", "de", "ts", "te", "map-nq_ZziQ", "(DDDDD)D", "pairiteration", "projectionratio", "projectionratio-vxhRpak", "quadCalc", "c", "quadCalc-hJc2f3Q", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;D)Lkorlibs/math/geom/Vector2D;", "xc", "yc", "quadCalc-z913DAQ", "(DDDDDDDLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "quadToCubic", "bezier", "Lkotlin/Function8;", "qx0", "qy0", "qx1", "qy1", "qx2", "qy2", "qx3", "qy3", "(DDDDDDLkotlin/jvm/functions/Function8;)Ljava/lang/Object;", "quadToCubic1", "quadToCubic2", "quadraticFromPoints", "quadraticFromPoints-hJc2f3Q", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;D)Lkorlibs/math/geom/bezier/Bezier;", "roots", "ABCResult", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\n_MathGeom.bezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/Bezier$Companion\n+ 2 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 3 _Math_interpolation.kt\nkorlibs/math/interpolation/_Math_interpolationKt\n+ 4 VectorsList.kt\nkorlibs/math/geom/VectorsListKt\n+ 5 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1957:1\n1396#1,17:2027\n1413#1:2045\n1376#1,7:2046\n1383#1,3:2054\n52#2:1958\n42#2:1959\n52#2:1961\n42#2,11:1962\n52#2:1974\n42#2,11:1975\n43#2,10:1986\n42#2:2021\n58#2:2022\n56#2:2023\n413#3:1960\n413#3:1973\n413#3:2009\n413#3:2010\n416#3:2016\n416#3:2017\n413#3:2024\n413#3:2025\n413#3:2026\n413#3:2044\n413#3:2053\n69#4:1996\n61#5,2:1997\n61#5,3:1999\n63#5:2002\n81#5,3:2018\n1360#6:2003\n1446#6,5:2004\n766#6:2011\n857#6,2:2012\n1855#6,2:2014\n*S KotlinDebug\n*F\n+ 1 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/Bezier$Companion\n*L\n1422#1:2027,17\n1422#1:2045\n1433#1:2046,7\n1433#1:2054,3\n997#1:1958\n997#1:1959\n1004#1:1961\n1004#1:1962,11\n1011#1:1974\n1011#1:1975,11\n1025#1:1986,10\n1366#1:2021\n1366#1:2022\n1366#1:2023\n1001#1:1960\n1008#1:1973\n1229#1:2009\n1230#1:2010\n1318#1:2016\n1319#1:2017\n1382#1:2024\n1412#1:2025\n1413#1:2026\n1422#1:2044\n1433#1:2053\n1046#1:1996\n1203#1:1997,2\n1204#1:1999,3\n1203#1:2002\n1361#1:2018,3\n1211#1:2003\n1211#1:2004,5\n1244#1:2011\n1244#1:2012,2\n1253#1:2014,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final double[] getT_VALUES() {
            return T_VALUES;
        }

        @PublishedApi
        public static /* synthetic */ void getT_VALUES$annotations() {
        }

        @NotNull
        public final double[] getC_VALUES() {
            return C_VALUES;
        }

        @PublishedApi
        public static /* synthetic */ void getC_VALUES$annotations() {
        }

        private final Curvature curvature-OzkQpaQ(double t, PointList d1, PointList d2, int dims, boolean kOnly) {
            Curvature curvature;
            Vector2D d = this.compute-DJj3pIk(t, d1);
            Vector2D dd = this.compute-DJj3pIk(t, d2);
            double qdsum = d.getX() * d.getX() + d.getY() * d.getY();
            if (dims >= 3) {
                throw new NotImplementedError(null, 1, null);
            }
            double num = d.getX() * dd.getY() - d.getY() * dd.getX();
            if (dims >= 3) {
                throw new NotImplementedError(null, 1, null);
            }
            double dnm = Math.pow(qdsum, 1.5);
            if (num == 0.0 || dnm == 0.0) {
                return new Curvature(0.0, 0.0, 0.0, 0.0, 12, null);
            }
            double k = num / dnm;
            double r = dnm / num;
            if (!kOnly) {
                double pk = this.curvature-OzkQpaQ(Ratio.minus-ce6x77s(t, Ratio.constructor-impl(0.001)), d1, d2, dims, true).getK();
                double nk = this.curvature-OzkQpaQ(Ratio.plus-ce6x77s(t, Ratio.constructor-impl(0.001)), d1, d2, dims, true).getK();
                double dk = (nk - k + (k - pk)) / (double)2;
                double adk = (Math.abs(nk - k) + Math.abs(k - pk)) / (double)2;
                curvature = new Curvature(k, r, dk, adk);
            } else {
                curvature = new Curvature(k, r, 0.0, 0.0, 12, null);
            }
            return curvature;
        }

        static /* synthetic */ Curvature curvature-OzkQpaQ$default(Companion companion, double d, PointList pointList, PointList pointList2, int n, boolean bl, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                bl = false;
            }
            return companion.curvature-OzkQpaQ(d, pointList, pointList2, n, bl);
        }

        public final double getMidX(@NotNull RectangleD $this$midX) {
            return ($this$midX.getLeft() + $this$midX.getRight()) * 0.5;
        }

        public final double getMidY(@NotNull RectangleD $this$midY) {
            return ($this$midY.getTop() + $this$midY.getBottom()) * 0.5;
        }

        private final boolean bboxoverlap(RectangleD a, RectangleD b) {
            return !(Math.abs(this.getMidX(a) - this.getMidX(b)) >= (a.getWidth() + b.getWidth()) / (double)2.0f) && !(Math.abs(this.getMidY(a) - this.getMidY(b)) >= (a.getHeight() + b.getHeight()) / (double)2.0f);
        }

        private final double map-nq_ZziQ(double v, double ds, double de, double ts, double te) {
            return _Math_interpolationKt.convertRange-BKgx9t0(v, ds, de, ts, te);
        }

        private final double angle(Vector2D o, Vector2D v1, Vector2D v2) {
            double dx1 = v1.getX() - o.getX();
            double dy1 = v1.getY() - o.getY();
            double dx2 = v2.getX() - o.getX();
            double dy2 = v2.getY() - o.getY();
            double cross = dx1 * dy2 - dy1 * dx2;
            double dot = dx1 * dx2 + dy1 * dy2;
            return Math.atan2(cross, dot);
        }

        /*
         * WARNING - void declaration
         */
        private final Vector2D compute-DJj3pIk(double t, PointList points) {
            Vector2D vector2D;
            PointList p = points;
            int order = p.getSize() - 1;
            if (Ratio.equals-impl0(t, Ratio.Companion.getZERO-eKSQRR4())) {
                return p.get(0);
            }
            if (Ratio.equals-impl0(t, Ratio.Companion.getONE-eKSQRR4())) {
                return p.get(order);
            }
            if (order == 0) {
                return p.get(0);
            }
            double mt = Ratio.toDouble-impl(Ratio.minus-ce6x77s(Ratio.Companion.getONE-eKSQRR4(), t));
            double mt2 = mt * mt;
            double t2 = Ratio.toDouble-impl(Ratio.times-ce6x77s(t, t));
            switch (order) {
                case 1: {
                    void that$iv;
                    Vector2D this_$iv;
                    Vector2D this_$iv2 = p.get(0);
                    boolean $i$f$times22 = false;
                    this_$iv2 = new Vector2D(this_$iv2.getX() * mt, this_$iv2.getY() * mt);
                    Vector2D $i$f$times22 = p.get(1);
                    double scale$iv = Ratio.toDouble-impl(t);
                    boolean $i$f$times = false;
                    this_$iv = new Vector2D(this_$iv.getX() * scale$iv, this_$iv.getY() * scale$iv);
                    boolean $i$f$plus = false;
                    vector2D = new Vector2D(this_$iv2.getX() + that$iv.getX(), this_$iv2.getY() + that$iv.getY());
                    break;
                }
                case 2: {
                    void that$iv;
                    double a = mt2;
                    double $this$times_u2dBdQlfBE$iv = mt;
                    boolean bl = false;
                    double b = $this$times_u2dBdQlfBE$iv * t * (double)2;
                    double c = t2;
                    Vector2D this_$iv = p.get(0);
                    boolean $i$f$times = false;
                    this_$iv = new Vector2D(this_$iv.getX() * a, this_$iv.getY() * a);
                    Vector2D this_$iv3 = p.get(1);
                    boolean $i$f$times2 = false;
                    this_$iv3 = new Vector2D(this_$iv3.getX() * b, this_$iv3.getY() * b);
                    boolean $i$f$plus = false;
                    this_$iv = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
                    this_$iv3 = p.get(2);
                    $i$f$times2 = false;
                    this_$iv3 = new Vector2D(this_$iv3.getX() * c, this_$iv3.getY() * c);
                    $i$f$plus = false;
                    vector2D = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
                    break;
                }
                case 3: {
                    void that$iv;
                    double a = mt2 * mt;
                    double $this$times_u2dBdQlfBE$iv = mt2;
                    boolean bl = false;
                    double b = $this$times_u2dBdQlfBE$iv * t * (double)3;
                    double c = mt * t2 * (double)3;
                    double d = Ratio.times-impl(t, t2);
                    Vector2D this_$iv = p.get(0);
                    boolean $i$f$times = false;
                    this_$iv = new Vector2D(this_$iv.getX() * a, this_$iv.getY() * a);
                    Vector2D this_$iv4 = p.get(1);
                    boolean $i$f$times3 = false;
                    this_$iv4 = new Vector2D(this_$iv4.getX() * b, this_$iv4.getY() * b);
                    boolean $i$f$plus = false;
                    this_$iv = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
                    this_$iv4 = p.get(2);
                    $i$f$times3 = false;
                    this_$iv4 = new Vector2D(this_$iv4.getX() * c, this_$iv4.getY() * c);
                    $i$f$plus = false;
                    this_$iv = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
                    this_$iv4 = p.get(3);
                    $i$f$times3 = false;
                    this_$iv4 = new Vector2D(this_$iv4.getX() * d, this_$iv4.getY() * d);
                    $i$f$plus = false;
                    vector2D = new Vector2D(this_$iv.getX() + that$iv.getX(), this_$iv.getY() + that$iv.getY());
                    break;
                }
                default: {
                    String string = "higher order curves";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
            }
            return vector2D;
        }

        private final List<PointList> derive(PointList points) {
            ArrayList<PointArrayList> out = new ArrayList<PointArrayList>();
            PointList current2 = points;
            while (current2.getSize() >= 2) {
                PointArrayList pointArrayList = new PointArrayList(current2.getSize() - 1);
                double c = current2.getSize() - 1;
                int n = current2.getSize() - 1;
                for (int n2 = 0; n2 < n; ++n2) {
                    Vector2D this_$iv;
                    Vector2D vector2D = current2.get(n2 + 1);
                    Vector2D that$iv = current2.get(n2);
                    boolean $i$f$minus = false;
                    this_$iv = new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY());
                    boolean $i$f$times = false;
                    pointArrayList.add(new Vector2D(this_$iv.getX() * c, this_$iv.getY() * c));
                }
                out.add(pointArrayList);
                current2 = pointArrayList;
            }
            return out;
        }

        private final double crt(double v) {
            return v < 0.0 ? -Math.pow(-v, 0.3333333333333333) : Math.pow(v, 0.3333333333333333);
        }

        private final PointList align(PointList points, Line2D line2, PointArrayList out) {
            Vector2D p1 = line2.getA();
            Vector2D p2 = line2.getB();
            double tx = p1.getX();
            double ty = p1.getY();
            double a = -Math.atan2(p2.getY() - ty, p2.getX() - tx);
            PointList $this$fastForEach$iv = points;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.getSize();
            for (int n$iv = 0; n$iv < n; ++n$iv) {
                Vector2D vector2D = $this$fastForEach$iv.get(n$iv);
                boolean bl = false;
                double x = vector2D.component1();
                double y = vector2D.component2();
                out.add((x - tx) * Math.cos(a) - (y - ty) * Math.sin(a), (x - tx) * Math.sin(a) + (y - ty) * Math.cos(a));
            }
            return out;
        }

        static /* synthetic */ PointList align$default(Companion companion, PointList pointList, Line2D line2D, PointArrayList pointArrayList, int n, Object object) {
            if ((n & 4) != 0) {
                pointArrayList = new PointArrayList(0, 1, null);
            }
            return companion.align(pointList, line2D, pointArrayList);
        }

        private final boolean between(double v, double min, double max) {
            return min <= v && v <= max || IsAlmostZeroKt.isAlmostEquals(v, min, 1.0E-4) || IsAlmostZeroKt.isAlmostEquals(v, max, 1.0E-4);
        }

        private final double[] roots(PointList points, Line2D line2) {
            double p;
            double p3;
            double q;
            double q2;
            double discriminant;
            int order = points.getSize() - 1;
            PointList aligned2 = korlibs.math.geom.bezier.Bezier$Companion.align$default(this, points, line2, null, 4, null);
            if (order == 2) {
                double c;
                double b;
                double a = aligned2.getY(0);
                double d = a - (double)2.0f * (b = aligned2.getY(1)) + (c = aligned2.getY(2));
                if (!(d == 0.0)) {
                    double m1 = -Math.sqrt(b * b - a * c);
                    double m2 = -a + b;
                    double v1 = -(m1 + m2) / d;
                    double v2 = -(-m1 + m2) / d;
                    return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, v1, v2, 0.0, 4, null);
                }
                if (!(b == c) && d == 0.0) {
                    return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, ((double)2 * b - c) / ((double)2 * b - (double)2 * c), 0.0, 0.0, 6, null);
                }
                return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, 0.0, 0.0, 0.0, 7, null);
            }
            double pa = aligned2.getY(0);
            double pb = aligned2.getY(1);
            double pc = aligned2.getY(2);
            double pd = aligned2.getY(3);
            double d = -pa + (double)3 * pb - (double)3 * pc + pd;
            double a = (double)3 * pa - (double)6 * pb + (double)3 * pc;
            double b = (double)-3 * pa + (double)3 * pb;
            double c = pa;
            if (IsAlmostZeroKt.isAlmostZero(d)) {
                if (IsAlmostZeroKt.isAlmostZero(a)) {
                    if (IsAlmostZeroKt.isAlmostZero(b)) {
                        return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, 0.0, 0.0, 0.0, 7, null);
                    }
                    return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, -c / b, 0.0, 0.0, 6, null);
                }
                double q3 = Math.sqrt(b * b - (double)4 * a * c);
                double a2 = (double)2 * a;
                return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, (q3 - b) / a2, (-b - q3) / a2, 0.0, 4, null);
            }
            if ((discriminant = (q2 = (q = ((double)2 * (a /= d) * a * a - (double)9 * a * (b /= d) + (double)27 * (c /= d)) / 27.0) / (double)2.0f) * q2 + (p3 = (p = ((double)3 * b - a * a) / 3.0) / 3.0) * p3 * p3) < 0.0) {
                double mp3 = -p / (double)3.0f;
                double mp33 = mp3 * mp3 * mp3;
                double r = Math.sqrt(mp33);
                double t = -q / ((double)2.0f * r);
                double cosphi = t < -1.0 ? -1.0 : (t > 1.0 ? 1.0 : t);
                double phi = Math.acos(cosphi);
                double crtr = this.crt(r);
                double t1 = (double)2 * crtr;
                double x1 = t1 * Math.cos(phi / (double)3.0f) - a / (double)3.0f;
                double x2 = t1 * Math.cos((phi + Math.PI * 2) / (double)3.0f) - a / (double)3.0f;
                double x3 = t1 * Math.cos((phi + Math.PI * 4) / (double)3.0f) - a / (double)3.0f;
                return this.doubleArrayOfValid01(x1, x2, x3);
            }
            if (discriminant == 0.0) {
                double u1 = q2 < 0.0 ? this.crt(-q2) : -this.crt(q2);
                double x1 = (double)2.0f * u1 - a / (double)3.0f;
                double x2 = -u1 - a / (double)3.0f;
                return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, x1, x2, 0.0, 4, null);
            }
            double sd = Math.sqrt(discriminant);
            double u1 = this.crt(-q2 + sd);
            double v1 = this.crt(q2 + sd);
            return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, u1 - v1 - a / (double)3.0f, 0.0, 0.0, 6, null);
        }

        static /* synthetic */ double[] roots$default(Companion companion, PointList pointList, Line2D line2D, int n, Object object) {
            if ((n & 2) != 0) {
                line2D = X_AXIS;
            }
            return companion.roots(pointList, line2D);
        }

        private final double[] droots(double[] p) {
            switch (p.length) {
                case 3: {
                    double a = p[0];
                    double b = p[1];
                    double c = p[2];
                    double d = a - (double)2 * b + c;
                    if (!(d == 0.0)) {
                        double m1 = -Math.sqrt(b * b - a * c);
                        double m2 = -a + b;
                        double v1 = -(m1 + m2) / d;
                        double v2 = -(-m1 + m2) / d;
                        return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, v1, v2, 0.0, 4, null);
                    }
                    if (b == c || !(d == 0.0)) break;
                    return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, ((double)2.0f * b - c) / ((double)2.0f * (b - c)), 0.0, 0.0, 6, null);
                }
                case 2: {
                    double a = p[0];
                    double b = p[1];
                    if (a == b) break;
                    return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, a / (a - b), 0.0, 0.0, 6, null);
                }
            }
            return korlibs.math.geom.bezier.Bezier$Companion.doubleArrayOfValid01$default(this, 0.0, 0.0, 0.0, 7, null);
        }

        private final double[] doubleArrayOfValid01(double v1, double v2, double v3) {
            boolean v2Valid;
            boolean v1Valid;
            boolean bl = 0.0 <= v1 ? v1 <= 1.0 : (v1Valid = false);
            boolean bl2 = 0.0 <= v2 ? v2 <= 1.0 : (v2Valid = false);
            boolean v3Valid = 0.0 <= v3 ? v3 <= 1.0 : false;
            int validCount = 0;
            if (v1Valid) {
                ++validCount;
            }
            if (v2Valid) {
                ++validCount;
            }
            if (v3Valid) {
                ++validCount;
            }
            if (validCount == 0) {
                return EMPTY_DOUBLE_ARRAY;
            }
            int index2 = 0;
            double[] out = new double[validCount];
            if (v1Valid) {
                out[index2++] = MathKt.normalizeZero(v1);
            }
            if (v2Valid) {
                out[index2++] = MathKt.normalizeZero(v2);
            }
            if (v3Valid) {
                out[index2++] = MathKt.normalizeZero(v3);
            }
            return out;
        }

        static /* synthetic */ double[] doubleArrayOfValid01$default(Companion companion, double d, double d2, double d3, int n, Object object) {
            if ((n & 1) != 0) {
                d = Double.NaN;
            }
            if ((n & 2) != 0) {
                d2 = Double.NaN;
            }
            if ((n & 4) != 0) {
                d3 = Double.NaN;
            }
            return companion.doubleArrayOfValid01(d, d2, d3);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<Ratio, Ratio>> curveintersects(List<SubBezier> c1, List<SubBezier> c2, double threshold) {
            void $this$flatMapTo$iv$iv;
            ArrayList<Pair<SubBezier, SubBezier>> pairs = new ArrayList<Pair<SubBezier, SubBezier>>();
            List<SubBezier> $this$fastForEach$iv = c1;
            boolean $i$f$fastForEach = false;
            int n$iv22 = 0;
            while (n$iv22 < $this$fastForEach$iv.size()) {
                SubBezier l = $this$fastForEach$iv.get(n$iv22++);
                boolean bl = false;
                List<SubBezier> $this$fastForEach$iv2 = c2;
                boolean $i$f$fastForEach2 = false;
                int n$iv = 0;
                while (n$iv < $this$fastForEach$iv2.size()) {
                    SubBezier r = $this$fastForEach$iv2.get(n$iv++);
                    boolean bl2 = false;
                    if (!l.getCurve().overlaps(r.getCurve())) continue;
                    pairs.add(TuplesKt.to(l, r));
                }
            }
            Iterable $this$flatMap$iv = pairs;
            boolean $i$f$flatMap = false;
            Iterable n$iv22 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = Companion.pairiteration((SubBezier)it.getFirst(), (SubBezier)it.getSecond(), threshold);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        static /* synthetic */ List curveintersects$default(Companion companion, List list2, List list3, double d, int n, Object object) {
            if ((n & 4) != 0) {
                d = 0.5;
            }
            return companion.curveintersects(list2, list3, d);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<Ratio, Ratio>> pairiteration(SubBezier c1, SubBezier c2, double threshold) {
            void $this$filterTo$iv$iv;
            RectangleD c1b = c1.getBoundingBox();
            RectangleD c2b = c2.getBoundingBox();
            double r = 100000.0;
            if (Math.abs(c1b.getWidth()) + Math.abs(c1b.getHeight()) < threshold && Math.abs(c2b.getWidth()) + Math.abs(c2b.getHeight()) < threshold) {
                double $this$times_u2dBdQlfBE$iv;
                double d = r;
                double ratio$iv = Ratio.plus-ce6x77s(c1.getT1-eKSQRR4(), c1.getT2-eKSQRR4());
                boolean bl = false;
                Ratio ratio2 = Ratio.box-impl(Ratio.constructor-impl((double)((int)($this$times_u2dBdQlfBE$iv * ratio$iv / 2.0)) / r));
                $this$times_u2dBdQlfBE$iv = r;
                ratio$iv = Ratio.plus-ce6x77s(c2.getT1-eKSQRR4(), c2.getT2-eKSQRR4());
                bl = false;
                return CollectionsKt.listOf(new Pair<Ratio, Ratio>(ratio2, Ratio.box-impl(Ratio.constructor-impl((double)((int)($this$times_u2dBdQlfBE$iv * ratio$iv / 2.0)) / r))));
            }
            CurveSplit cc1 = c1.split-kg1FUQ0(Ratio.Companion.getHALF-eKSQRR4());
            CurveSplit cc2 = c2.split-kg1FUQ0(Ratio.Companion.getHALF-eKSQRR4());
            Pair[] pairArray = new Pair[]{new Pair<SubBezier, SubBezier>(cc1.getLeft(), cc2.getLeft()), new Pair<SubBezier, SubBezier>(cc1.getLeft(), cc2.getRight()), new Pair<SubBezier, SubBezier>(cc1.getRight(), cc2.getRight()), new Pair<SubBezier, SubBezier>(cc1.getRight(), cc2.getLeft())};
            List<Pair> pairs2 = CollectionsKt.listOf(pairArray);
            Iterable $this$filter$iv = pairs2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                boolean bl = false;
                if (!Companion.bboxoverlap(((SubBezier)pair.getFirst()).getCurve().getBoundingBox(), ((SubBezier)pair.getSecond()).getCurve().getBoundingBox())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List pairs = (List)destination$iv$iv;
            ArrayList results = new ArrayList();
            if (pairs.isEmpty()) {
                return results;
            }
            Iterable $this$forEach$iv = pairs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                results.addAll(Companion.pairiteration((SubBezier)pair.getFirst(), (SubBezier)pair.getSecond(), threshold));
            }
            return CollectionsKt.distinct(results);
        }

        static /* synthetic */ List pairiteration$default(Companion companion, SubBezier subBezier, SubBezier subBezier2, double d, int n, Object object) {
            if ((n & 4) != 0) {
                d = 0.5;
            }
            return companion.pairiteration(subBezier, subBezier2, d);
        }

        private final Vector2D lli8(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
            double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
            if (d == 0.0) {
                return null;
            }
            double nx = (x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4);
            double ny = (x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4);
            return new Vector2D(nx / d, ny / d);
        }

        private final Vector2D lli4(Vector2D p1, Vector2D p2, Vector2D p3, Vector2D p4) {
            return this.lli8(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY(), p4.getX(), p4.getY());
        }

        @NotNull
        public final Bezier cubicFromPoints-xqnzwCs(@NotNull Vector2D S, @NotNull Vector2D B, @NotNull Vector2D E, double t, @Nullable Double d1) {
            ABCResult abc = this.getABC--1ayk3M(3, S, B, E, t);
            Double d = d1;
            double d12 = d != null ? d.doubleValue() : this.dist(B, abc.getC());
            double t2 = Ratio.toDouble-impl(t);
            double d2 = d12 * (1.0 - t2) / t2;
            double selen = this.dist(S, E);
            double lx = (E.getX() - S.getX()) / selen;
            double ly = (E.getY() - S.getY()) / selen;
            double bx1 = d12 * lx;
            double by1 = d12 * ly;
            double bx2 = d2 * lx;
            double by2 = d2 * ly;
            Vector2D e1 = new Vector2D(B.getX() - bx1, B.getY() - by1);
            Vector2D e2 = new Vector2D(B.getX() + bx2, B.getY() + by2);
            Vector2D A = abc.getA();
            Vector2D v1 = new Vector2D(A.getX() + (e1.getX() - A.getX()) / (1.0 - t2), A.getY() + (e1.getY() - A.getY()) / (1.0 - t2));
            Vector2D v2 = new Vector2D(A.getX() + (e2.getX() - A.getX()) / t2, A.getY() + (e2.getY() - A.getY()) / t2);
            Vector2D nc1 = new Vector2D(S.getX() + (v1.getX() - S.getX()) / t2, S.getY() + (v1.getY() - S.getY()) / t2);
            Vector2D nc2 = new Vector2D(E.getX() + (v2.getX() - E.getX()) / (1.0 - t2), E.getY() + (v2.getY() - E.getY()) / (1.0 - t2));
            return new Bezier(S, nc1, nc2, E);
        }

        public static /* synthetic */ Bezier cubicFromPoints-xqnzwCs$default(Companion companion, Vector2D vector2D, Vector2D vector2D2, Vector2D vector2D3, double d, Double d2, int n, Object object) {
            if ((n & 8) != 0) {
                d = Ratio.Companion.getHALF-eKSQRR4();
            }
            if ((n & 0x10) != 0) {
                d2 = null;
            }
            return companion.cubicFromPoints-xqnzwCs(vector2D, vector2D2, vector2D3, d, d2);
        }

        @NotNull
        public final Bezier quadraticFromPoints-hJc2f3Q(@NotNull Vector2D p1, @NotNull Vector2D p2, @NotNull Vector2D p3, double t) {
            if (Ratio.equals-impl0(t, Ratio.Companion.getZERO-eKSQRR4())) {
                return new Bezier(p2, p2, p3);
            }
            if (Ratio.equals-impl0(t, Ratio.Companion.getONE-eKSQRR4())) {
                return new Bezier(p1, p2, p2);
            }
            ABCResult abc = Companion.getABC--1ayk3M(2, p1, p2, p3, t);
            return new Bezier(p1, abc.getA(), p3);
        }

        public static /* synthetic */ Bezier quadraticFromPoints-hJc2f3Q$default(Companion companion, Vector2D vector2D, Vector2D vector2D2, Vector2D vector2D3, double d, int n, Object object) {
            if ((n & 8) != 0) {
                d = Ratio.Companion.getHALF-eKSQRR4();
            }
            return companion.quadraticFromPoints-hJc2f3Q(vector2D, vector2D2, vector2D3, d);
        }

        private final ABCResult getABC--1ayk3M(int order, Vector2D S, Vector2D B, Vector2D E, double t) {
            double u = this.projectionratio-vxhRpak(t, order);
            double um = Ratio.minus-ce6x77s(Ratio.Companion.getONE-eKSQRR4(), u);
            Vector2D C = new Vector2D(Ratio.times-impl(u, S.getX()) + Ratio.times-impl(um, E.getX()), Ratio.times-impl(u, S.getY()) + Ratio.times-impl(um, E.getY()));
            double s = this.abcratio-vxhRpak(t, order);
            double $this$div_u2dBdQlfBE$iv = B.getX() - C.getX();
            boolean bl = false;
            double d = B.getX() + $this$div_u2dBdQlfBE$iv / s;
            $this$div_u2dBdQlfBE$iv = B.getY() - C.getY();
            bl = false;
            Vector2D A = new Vector2D(d, B.getY() + $this$div_u2dBdQlfBE$iv / s);
            return new ABCResult(A, B, C, S, E);
        }

        static /* synthetic */ ABCResult getABC--1ayk3M$default(Companion companion, int n, Vector2D vector2D, Vector2D vector2D2, Vector2D vector2D3, double d, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                d = Ratio.Companion.getHALF-eKSQRR4();
            }
            return companion.getABC--1ayk3M(n, vector2D, vector2D2, vector2D3, d);
        }

        private final double projectionratio-vxhRpak(double t, int n) {
            if (n != 2 && n != 3) {
                return Ratio.Companion.getNaN-eKSQRR4();
            }
            if (Ratio.equals-impl0(t, Ratio.Companion.getZERO-eKSQRR4()) || Ratio.equals-impl0(t, Ratio.Companion.getONE-eKSQRR4())) {
                return t;
            }
            double t2 = Ratio.toDouble-impl(t);
            double top = Math.pow(1.0 - t2, n);
            double bottom = Math.pow(t2, n) + top;
            return _Math_interpolationKt.toRatio(top / bottom);
        }

        static /* synthetic */ double projectionratio-vxhRpak$default(Companion companion, double d, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = Ratio.Companion.getHALF-eKSQRR4();
            }
            return companion.projectionratio-vxhRpak(d, n);
        }

        private final double abcratio-vxhRpak(double t, int n) {
            if (n != 2 && n != 3) {
                return Ratio.Companion.getNaN-eKSQRR4();
            }
            if (Ratio.equals-impl0(t, Ratio.Companion.getZERO-eKSQRR4()) || Ratio.equals-impl0(t, Ratio.Companion.getONE-eKSQRR4())) {
                return t;
            }
            double t2 = Ratio.toDouble-impl(t);
            double bottom = Math.pow(t2, n) + Math.pow(1.0 - t2, n);
            double top = bottom - 1.0;
            return _Math_interpolationKt.toRatio(Math.abs(top / bottom));
        }

        private final double dist(Vector2D p1, Vector2D p2) {
            double dx = p1.getX() - p2.getX();
            double dy = p1.getY() - p2.getY();
            return Math.sqrt(dx * dx + dy * dy);
        }

        private final double[] combineSmallDistinctSorted(double[] a, double[] b) {
            DoubleArrayList out = new DoubleArrayList(a.length + b.length);
            DoubleArrayList.add$default(out, a, 0, 0, 6, null);
            double[] $this$fastForEach$iv = b;
            boolean $i$f$fastForEach = false;
            int n$iv = 0;
            while (n$iv < $this$fastForEach$iv.length) {
                double it = $this$fastForEach$iv[n$iv++];
                boolean bl = false;
                if (out.contains((Object)it)) continue;
                out.add(it);
            }
            ArrayListExtKt.sort$default(out, 0, 0, false, 7, null);
            return out.toDoubleArray();
        }

        /*
         * WARNING - void declaration
         */
        private final Bezier makeline(Vector2D p1, Vector2D p2) {
            void this_$iv$iv;
            Vector2D this_$iv = p1;
            boolean $i$f$plus = false;
            this_$iv = new Vector2D(this_$iv.getX() + p2.getX(), this_$iv.getY() + p2.getY());
            int scale$iv = 2;
            boolean $i$f$div = false;
            Vector2D vector2D = this_$iv;
            double scale$iv$iv = scale$iv;
            boolean $i$f$div2 = false;
            return new Bezier(p1, new Vector2D(this_$iv$iv.getX() / scale$iv$iv, this_$iv$iv.getY() / scale$iv$iv), p2);
        }

        public final <T> T quadCalc-z913DAQ(double x0, double y0, double xc, double yc, double x1, double y1, double t, @NotNull Function2<? super Double, ? super Double, ? extends T> emit2) {
            boolean bl = false;
            double t1 = 1.0 - Ratio.toDouble-impl(t);
            double a = t1 * t1;
            double c = Ratio.times-ce6x77s(t, t);
            double $this$times_u2dBdQlfBE$iv = (double)2 * t1;
            boolean bl2 = false;
            double b = $this$times_u2dBdQlfBE$iv * t;
            return emit2.invoke(a * x0 + b * xc + Ratio.times-impl(c, x1), a * y0 + b * yc + Ratio.times-impl(c, y1));
        }

        public final <T> T cubicCalc-rtMv0Vs(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double t, @NotNull Function2<? super Double, ? super Double, ? extends T> emit2) {
            boolean bl = false;
            double cx = (double)3.0f * (x1 - x0);
            double bx = (double)3.0f * (x2 - x1) - cx;
            double ax = x3 - x0 - cx - bx;
            double cy = (double)3.0f * (y1 - y0);
            double by = (double)3.0f * (y2 - y1) - cy;
            double ay = y3 - y0 - cy - by;
            double tSquared = Ratio.times-ce6x77s(t, t);
            double tCubed = Ratio.times-ce6x77s(tSquared, t);
            double $this$times_u2dBdQlfBE$iv = ax;
            boolean bl2 = false;
            double d = $this$times_u2dBdQlfBE$iv * tCubed;
            $this$times_u2dBdQlfBE$iv = bx;
            bl2 = false;
            double d2 = d + $this$times_u2dBdQlfBE$iv * tSquared;
            $this$times_u2dBdQlfBE$iv = cx;
            bl2 = false;
            Double d3 = d2 + $this$times_u2dBdQlfBE$iv * t + x0;
            $this$times_u2dBdQlfBE$iv = ay;
            bl2 = false;
            double d4 = $this$times_u2dBdQlfBE$iv * tCubed;
            $this$times_u2dBdQlfBE$iv = by;
            bl2 = false;
            double d5 = d4 + $this$times_u2dBdQlfBE$iv * tSquared;
            $this$times_u2dBdQlfBE$iv = cy;
            bl2 = false;
            return emit2.invoke(d3, d5 + $this$times_u2dBdQlfBE$iv * t + y0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Vector2D cubicCalc--1ayk3M(@NotNull Vector2D p0, @NotNull Vector2D p1, @NotNull Vector2D p2, @NotNull Vector2D p3, double t) {
            void y;
            void y2$iv;
            void y0$iv;
            void y1$iv;
            void x3$iv;
            void x2$iv;
            void x0$iv;
            void x1$iv;
            Vector2D out = null;
            Companion companion = this;
            double d = p0.getX();
            double d2 = p0.getY();
            double d3 = p1.getX();
            double d4 = p1.getY();
            double d5 = p2.getX();
            double d6 = p2.getY();
            double d7 = p3.getX();
            double y3$iv = p3.getY();
            boolean bl = false;
            double cx$iv = (double)3.0f * (x1$iv - x0$iv);
            double bx$iv = (double)3.0f * (x2$iv - x1$iv) - cx$iv;
            void ax$iv = x3$iv - x0$iv - cx$iv - bx$iv;
            double cy$iv = (double)3.0f * (y1$iv - y0$iv);
            double by$iv = (double)3.0f * (y2$iv - y1$iv) - cy$iv;
            double ay$iv = y3$iv - y0$iv - cy$iv - by$iv;
            double tSquared$iv = Ratio.times-ce6x77s(t, t);
            double tCubed$iv = Ratio.times-ce6x77s(tSquared$iv, t);
            double $this$times_u2dBdQlfBE$iv$iv = ax$iv;
            boolean bl2 = false;
            void v0 = $this$times_u2dBdQlfBE$iv$iv * tCubed$iv;
            $this$times_u2dBdQlfBE$iv$iv = bx$iv;
            bl2 = false;
            void v1 = v0 + $this$times_u2dBdQlfBE$iv$iv * tSquared$iv;
            $this$times_u2dBdQlfBE$iv$iv = cx$iv;
            bl2 = false;
            void v2 = v1 + $this$times_u2dBdQlfBE$iv$iv * t + x0$iv;
            $this$times_u2dBdQlfBE$iv$iv = ay$iv;
            bl2 = false;
            double d8 = $this$times_u2dBdQlfBE$iv$iv * tCubed$iv;
            $this$times_u2dBdQlfBE$iv$iv = by$iv;
            bl2 = false;
            double d9 = d8 + $this$times_u2dBdQlfBE$iv$iv * tSquared$iv;
            $this$times_u2dBdQlfBE$iv$iv = cy$iv;
            bl2 = false;
            double d10 = d9 + $this$times_u2dBdQlfBE$iv$iv * t + y0$iv;
            void x = v2;
            boolean bl3 = false;
            out = new Vector2D((double)x, (double)y);
            return out;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Vector2D quadCalc-hJc2f3Q(@NotNull Vector2D p, @NotNull Vector2D c, @NotNull Vector2D a, double t) {
            void y;
            void x1$iv;
            void xc$iv;
            void x0$iv;
            void yc$iv;
            void y0$iv;
            Vector2D out = null;
            Companion companion = this;
            double d = p.getX();
            double d2 = p.getY();
            double d3 = c.getX();
            double d4 = c.getY();
            double d5 = a.getX();
            double y1$iv = a.getY();
            boolean bl = false;
            double t1$iv = 1.0 - Ratio.toDouble-impl(t);
            double a$iv = t1$iv * t1$iv;
            double c$iv = Ratio.times-ce6x77s(t, t);
            double $this$times_u2dBdQlfBE$iv$iv = (double)2 * t1$iv;
            boolean bl2 = false;
            double b$iv = $this$times_u2dBdQlfBE$iv$iv * t;
            double d6 = a$iv * y0$iv + b$iv * yc$iv + Ratio.times-impl(c$iv, y1$iv);
            double x = a$iv * x0$iv + b$iv * xc$iv + Ratio.times-impl(c$iv, (double)x1$iv);
            boolean bl3 = false;
            out = new Vector2D(x, (double)y);
            return out;
        }

        @PublishedApi
        @NotNull
        public final Vector2D quadToCubic1(@NotNull Vector2D a, @NotNull Vector2D b) {
            return new Vector2D(this.quadToCubic1(a.getX(), b.getX()), this.quadToCubic1(a.getY(), b.getY()));
        }

        @PublishedApi
        @NotNull
        public final Vector2D quadToCubic2(@NotNull Vector2D a, @NotNull Vector2D b) {
            return new Vector2D(this.quadToCubic2(a.getX(), a.getX()), this.quadToCubic2(a.getY(), b.getY()));
        }

        @PublishedApi
        public final double quadToCubic1(double a, double b) {
            return a + (b - a) * 0.6666666666666666;
        }

        @PublishedApi
        public final double quadToCubic2(double a, double b) {
            return b + (a - b) * 0.6666666666666666;
        }

        public final <T> T quadToCubic(double x0, double y0, double xc, double yc, double x1, double y1, @NotNull Function8<? super Double, ? super Double, ? super Double, ? super Double, ? super Double, ? super Double, ? super Double, ? super Double, ? extends T> bezier) {
            boolean $i$f$quadToCubic = false;
            return bezier.invoke(x0, y0, this.quadToCubic1(x0, xc), this.quadToCubic1(y0, yc), this.quadToCubic2(xc, x1), this.quadToCubic2(yc, y1), x1, y1);
        }

        public static final /* synthetic */ double[] access$combineSmallDistinctSorted(Companion $this, double[] a, double[] b) {
            return $this.combineSmallDistinctSorted(a, b);
        }

        public static final /* synthetic */ List access$derive(Companion $this, PointList points) {
            return $this.derive(points);
        }

        public static final /* synthetic */ double[] access$droots(Companion $this, double[] p) {
            return $this.droots(p);
        }

        public static final /* synthetic */ double access$angle(Companion $this, Vector2D o, Vector2D v1, Vector2D v2) {
            return $this.angle(o, v1, v2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\b\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\u0011\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\u0012\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\u0013\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\r\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003JO\u0010\u0015\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0005\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0006\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\u0007\u001a\u00060\u0003j\u0002`\u00042\f\b\u0002\u0010\b\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0015\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0015\u0010\b\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0015\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lkorlibs/math/geom/bezier/Bezier$Companion$ABCResult;", "", "A", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "B", "C", "S", "E", "(Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;Lkorlibs/math/geom/Vector2D;)V", "getA", "()Lkorlibs/math/geom/Vector2D;", "getB", "getC", "getE", "getS", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "korge-foundation"})
        public static final class ABCResult {
            @NotNull
            private final Vector2D A;
            @NotNull
            private final Vector2D B;
            @NotNull
            private final Vector2D C;
            @NotNull
            private final Vector2D S;
            @NotNull
            private final Vector2D E;

            public ABCResult(@NotNull Vector2D A, @NotNull Vector2D B, @NotNull Vector2D C, @NotNull Vector2D S, @NotNull Vector2D E) {
                this.A = A;
                this.B = B;
                this.C = C;
                this.S = S;
                this.E = E;
            }

            @NotNull
            public final Vector2D getA() {
                return this.A;
            }

            @NotNull
            public final Vector2D getB() {
                return this.B;
            }

            @NotNull
            public final Vector2D getC() {
                return this.C;
            }

            @NotNull
            public final Vector2D getS() {
                return this.S;
            }

            @NotNull
            public final Vector2D getE() {
                return this.E;
            }

            @NotNull
            public final Vector2D component1() {
                return this.A;
            }

            @NotNull
            public final Vector2D component2() {
                return this.B;
            }

            @NotNull
            public final Vector2D component3() {
                return this.C;
            }

            @NotNull
            public final Vector2D component4() {
                return this.S;
            }

            @NotNull
            public final Vector2D component5() {
                return this.E;
            }

            @NotNull
            public final ABCResult copy(@NotNull Vector2D A, @NotNull Vector2D B, @NotNull Vector2D C, @NotNull Vector2D S, @NotNull Vector2D E) {
                return new ABCResult(A, B, C, S, E);
            }

            public static /* synthetic */ ABCResult copy$default(ABCResult aBCResult, Vector2D vector2D, Vector2D vector2D2, Vector2D vector2D3, Vector2D vector2D4, Vector2D vector2D5, int n, Object object) {
                if ((n & 1) != 0) {
                    vector2D = aBCResult.A;
                }
                if ((n & 2) != 0) {
                    vector2D2 = aBCResult.B;
                }
                if ((n & 4) != 0) {
                    vector2D3 = aBCResult.C;
                }
                if ((n & 8) != 0) {
                    vector2D4 = aBCResult.S;
                }
                if ((n & 0x10) != 0) {
                    vector2D5 = aBCResult.E;
                }
                return aBCResult.copy(vector2D, vector2D2, vector2D3, vector2D4, vector2D5);
            }

            @NotNull
            public String toString() {
                return "ABCResult(A=" + this.A + ", B=" + this.B + ", C=" + this.C + ", S=" + this.S + ", E=" + this.E + ")";
            }

            public int hashCode() {
                int result2 = this.A.hashCode();
                result2 = result2 * 31 + this.B.hashCode();
                result2 = result2 * 31 + this.C.hashCode();
                result2 = result2 * 31 + this.S.hashCode();
                result2 = result2 * 31 + this.E.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ABCResult)) {
                    return false;
                }
                ABCResult aBCResult = (ABCResult)other;
                if (!Intrinsics.areEqual(this.A, aBCResult.A)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.B, aBCResult.B)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.C, aBCResult.C)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.S, aBCResult.S)) {
                    return false;
                }
                return Intrinsics.areEqual(this.E, aBCResult.E);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lkorlibs/math/geom/bezier/Bezier$Curvature;", "", "k", "", "r", "dk", "adk", "(DDDD)V", "getAdk", "()D", "getDk", "getK", "getR", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "korge-foundation"})
    public static final class Curvature {
        private final double k;
        private final double r;
        private final double dk;
        private final double adk;

        public Curvature(double k, double r, double dk, double adk) {
            this.k = k;
            this.r = r;
            this.dk = dk;
            this.adk = adk;
        }

        public /* synthetic */ Curvature(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = 0.0;
            }
            if ((n & 2) != 0) {
                d2 = 0.0;
            }
            if ((n & 4) != 0) {
                d3 = 0.0;
            }
            if ((n & 8) != 0) {
                d4 = 0.0;
            }
            this(d, d2, d3, d4);
        }

        public final double getK() {
            return this.k;
        }

        public final double getR() {
            return this.r;
        }

        public final double getDk() {
            return this.dk;
        }

        public final double getAdk() {
            return this.adk;
        }

        public final double component1() {
            return this.k;
        }

        public final double component2() {
            return this.r;
        }

        public final double component3() {
            return this.dk;
        }

        public final double component4() {
            return this.adk;
        }

        @NotNull
        public final Curvature copy(double k, double r, double dk, double adk) {
            return new Curvature(k, r, dk, adk);
        }

        public static /* synthetic */ Curvature copy$default(Curvature curvature, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = curvature.k;
            }
            if ((n & 2) != 0) {
                d2 = curvature.r;
            }
            if ((n & 4) != 0) {
                d3 = curvature.dk;
            }
            if ((n & 8) != 0) {
                d4 = curvature.adk;
            }
            return curvature.copy(d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "Curvature(k=" + this.k + ", r=" + this.r + ", dk=" + this.dk + ", adk=" + this.adk + ")";
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.k);
            result2 = result2 * 31 + Double.hashCode(this.r);
            result2 = result2 * 31 + Double.hashCode(this.dk);
            result2 = result2 * 31 + Double.hashCode(this.adk);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Curvature)) {
                return false;
            }
            Curvature curvature = (Curvature)other;
            if (Double.compare(this.k, curvature.k) != 0) {
                return false;
            }
            if (Double.compare(this.r, curvature.r) != 0) {
                return false;
            }
            if (Double.compare(this.dk, curvature.dk) != 0) {
                return false;
            }
            return Double.compare(this.adk, curvature.adk) == 0;
        }

        public Curvature() {
            this(0.0, 0.0, 0.0, 0.0, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001b\u0010\u0006\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001b\u0010\f\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001b\u0010\u0010\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001d"}, d2={"Lkorlibs/math/geom/bezier/Bezier$Extrema;", "", "xt", "", "yt", "([D[D)V", "allt", "getAllt", "()[D", "allt$delegate", "Lkotlin/Lazy;", "getXt", "xt01", "getXt01", "xt01$delegate", "getYt", "yt01", "getYt01", "yt01$delegate", "dimt", "index", "", "dimt01", "equals", "", "other", "hashCode", "toString", "", "korge-foundation"})
    public static final class Extrema {
        @NotNull
        private final double[] xt;
        @NotNull
        private final double[] yt;
        @NotNull
        private final Lazy allt$delegate;
        @NotNull
        private final Lazy xt01$delegate;
        @NotNull
        private final Lazy yt01$delegate;

        public Extrema(@NotNull double[] xt, @NotNull double[] yt) {
            this.xt = xt;
            this.yt = yt;
            this.allt$delegate = LazyKt.lazy((Function0)new Function0<double[]>(this){
                final /* synthetic */ Extrema this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final double[] invoke() {
                    return korlibs.math.geom.bezier.Bezier$Companion.access$combineSmallDistinctSorted(Bezier.Companion, this.this$0.getXt(), this.this$0.getYt());
                }
            });
            this.xt01$delegate = LazyKt.lazy((Function0)new Function0<double[]>(this){
                final /* synthetic */ Extrema this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final double[] invoke() {
                    DoubleSpreadBuilder doubleSpreadBuilder = new DoubleSpreadBuilder(3);
                    doubleSpreadBuilder.add(0.0);
                    doubleSpreadBuilder.addSpread(this.this$0.getXt());
                    doubleSpreadBuilder.add(1.0);
                    return doubleSpreadBuilder.toArray();
                }
            });
            this.yt01$delegate = LazyKt.lazy((Function0)new Function0<double[]>(this){
                final /* synthetic */ Extrema this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final double[] invoke() {
                    DoubleSpreadBuilder doubleSpreadBuilder = new DoubleSpreadBuilder(3);
                    doubleSpreadBuilder.add(0.0);
                    doubleSpreadBuilder.addSpread(this.this$0.getYt());
                    doubleSpreadBuilder.add(1.0);
                    return doubleSpreadBuilder.toArray();
                }
            });
        }

        @NotNull
        public final double[] getXt() {
            return this.xt;
        }

        @NotNull
        public final double[] getYt() {
            return this.yt;
        }

        @NotNull
        public final double[] getAllt() {
            Lazy lazy = this.allt$delegate;
            return (double[])lazy.getValue();
        }

        @NotNull
        public final double[] getXt01() {
            Lazy lazy = this.xt01$delegate;
            return (double[])lazy.getValue();
        }

        @NotNull
        public final double[] getYt01() {
            Lazy lazy = this.yt01$delegate;
            return (double[])lazy.getValue();
        }

        @NotNull
        public final double[] dimt(int index2) {
            return index2 == 0 ? this.xt : this.yt;
        }

        @NotNull
        public final double[] dimt01(int index2) {
            return index2 == 0 ? this.getXt01() : this.getYt01();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Extrema && Arrays.equals(this.xt, ((Extrema)other).xt) && Arrays.equals(this.yt, ((Extrema)other).yt);
        }

        public int hashCode() {
            return Arrays.hashCode(this.xt) + Arrays.hashCode(this.yt) * 7;
        }

        @NotNull
        public String toString() {
            String string = Arrays.toString(this.xt);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string2 = Arrays.toString(this.yt);
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            return "Extrema(x=" + string + ", y=" + string2 + ")";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u001f\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0016\u0010 \u001a\u00020\u0006H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\u0012J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J5\u0010#\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u0018\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\bH\u0016J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020+J\t\u00100\u001a\u000201H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0012\"\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0018\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0015\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00062"}, d2={"Lkorlibs/math/geom/bezier/Bezier$ProjectedPoint;", "Lkorlibs/math/IsAlmostEquals;", "p", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "t", "Lkorlibs/math/interpolation/Ratio;", "dSq", "", "(Lkorlibs/math/geom/Vector2D;DDLkotlin/jvm/internal/DefaultConstructorMarker;)V", "bezier", "Lkorlibs/math/geom/bezier/Bezier;", "getBezier", "()Lkorlibs/math/geom/bezier/Bezier;", "setBezier", "(Lkorlibs/math/geom/bezier/Bezier;)V", "d", "getD", "()D", "getDSq", "setDSq", "(D)V", "normal", "getNormal", "()Lkorlibs/math/geom/Vector2D;", "getP", "setP", "(Lkorlibs/math/geom/Vector2D;)V", "getT-eKSQRR4", "setT-kg1FUQ0", "D", "component1", "component2", "component2-eKSQRR4", "component3", "copy", "copy-NvLngv4", "(Lkorlibs/math/geom/Vector2D;DD)Lkorlibs/math/geom/bezier/Bezier$ProjectedPoint;", "equals", "", "other", "", "hashCode", "", "isAlmostEquals", "epsilon", "roundDecimalPlaces", "places", "toString", "", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\n_MathGeom.bezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/Bezier$ProjectedPoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1957:1\n1#2:1958\n*E\n"})
    public static final class ProjectedPoint
    implements IsAlmostEquals<ProjectedPoint> {
        @NotNull
        private Vector2D p;
        private double t;
        private double dSq;
        public Bezier bezier;

        private ProjectedPoint(Vector2D p, double t, double dSq) {
            this.p = p;
            this.t = t;
            this.dSq = dSq;
        }

        public /* synthetic */ ProjectedPoint(Vector2D vector2D, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                vector2D = new Vector2D();
            }
            if ((n & 2) != 0) {
                d = Ratio.Companion.getZERO-eKSQRR4();
            }
            if ((n & 4) != 0) {
                d2 = 0.0;
            }
            this(vector2D, d, d2, null);
        }

        @NotNull
        public final Vector2D getP() {
            return this.p;
        }

        public final void setP(@NotNull Vector2D vector2D) {
            this.p = vector2D;
        }

        public final double getT-eKSQRR4() {
            return this.t;
        }

        public final void setT-kg1FUQ0(double d) {
            this.t = d;
        }

        public final double getDSq() {
            return this.dSq;
        }

        public final void setDSq(double d) {
            this.dSq = d;
        }

        @NotNull
        public final Bezier getBezier() {
            Bezier bezier = this.bezier;
            if (bezier != null) {
                return bezier;
            }
            Intrinsics.throwUninitializedPropertyAccessException("bezier");
            return null;
        }

        public final void setBezier(@NotNull Bezier bezier) {
            this.bezier = bezier;
        }

        public final double getD() {
            return Math.sqrt(this.dSq);
        }

        @NotNull
        public final Vector2D getNormal() {
            return this.getBezier().normal-kg1FUQ0(this.t);
        }

        @NotNull
        public final ProjectedPoint roundDecimalPlaces(int places) {
            ProjectedPoint projectedPoint;
            ProjectedPoint it = projectedPoint = new ProjectedPoint(this.p.roundDecimalPlaces(places), Ratio.roundDecimalPlaces-4uGNJ3M(this.t, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.dSq, places), null);
            boolean bl = false;
            it.setBezier(this.getBezier());
            return projectedPoint;
        }

        @Override
        public boolean isAlmostEquals(@NotNull ProjectedPoint other, double epsilon) {
            return this.p.isAlmostEquals(other.p, epsilon) && _Math_interpolationKt.isAlmostEquals-yBVj4vc(this.t, other.t, _Math_interpolationKt.toRatio(epsilon)) && IsAlmostZeroKt.isAlmostEquals(this.dSq, other.dSq, epsilon);
        }

        @NotNull
        public final Vector2D component1() {
            return this.p;
        }

        public final double component2-eKSQRR4() {
            return this.t;
        }

        public final double component3() {
            return this.dSq;
        }

        @NotNull
        public final ProjectedPoint copy-NvLngv4(@NotNull Vector2D p, double t, double dSq) {
            return new ProjectedPoint(p, t, dSq, null);
        }

        public static /* synthetic */ ProjectedPoint copy-NvLngv4$default(ProjectedPoint projectedPoint, Vector2D vector2D, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                vector2D = projectedPoint.p;
            }
            if ((n & 2) != 0) {
                d = projectedPoint.t;
            }
            if ((n & 4) != 0) {
                d2 = projectedPoint.dSq;
            }
            return projectedPoint.copy-NvLngv4(vector2D, d, d2);
        }

        @NotNull
        public String toString() {
            return "ProjectedPoint(p=" + this.p + ", t=" + Ratio.toString-impl(this.t) + ", dSq=" + this.dSq + ")";
        }

        public int hashCode() {
            int result2 = this.p.hashCode();
            result2 = result2 * 31 + Ratio.hashCode-impl(this.t);
            result2 = result2 * 31 + Double.hashCode(this.dSq);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectedPoint)) {
                return false;
            }
            ProjectedPoint projectedPoint = (ProjectedPoint)other;
            if (!Intrinsics.areEqual(this.p, projectedPoint.p)) {
                return false;
            }
            if (!Ratio.equals-impl0(this.t, projectedPoint.t)) {
                return false;
            }
            return Double.compare(this.dSq, projectedPoint.dSq) == 0;
        }

        public /* synthetic */ ProjectedPoint(Vector2D p, double t, double dSq, DefaultConstructorMarker $constructor_marker) {
            this(p, t, dSq);
        }
    }
}

