/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.bezier;

import korlibs.datastructure.BSearchResult;
import korlibs.datastructure.DoubleArrayList;
import korlibs.datastructure._ExtensionsKt;
import korlibs.math.ConvertRangeKt;
import korlibs.math.RoundDecimalPlacesKt;
import korlibs.math.geom.PointArrayList;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.bezier.Curve;
import korlibs.math.interpolation.Ratio;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0002EFB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060#j\u0002`$\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010&J\u0006\u0010'\u001a\u00020\u001fJ\u0012\u0010(\u001a\u00020)2\n\u0010*\u001a\u00060#j\u0002`$J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\t\u0010.\u001a\u00020\nH\u00c2\u0003J1\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\"\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u00102\b\b\u0002\u00107\u001a\u000204H\u0002J\"\u00108\u001a\u0002042\u0006\u00109\u001a\u00020!2\b\b\u0002\u00107\u001a\u000204\u00f8\u0001\u0000\u00a2\u0006\u0004\b:\u0010;J\u0018\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020\u00102\b\b\u0002\u00107\u001a\u000204J\u0018\u0010>\u001a\u0002042\u0006\u0010 \u001a\u00020\u00102\b\b\u0002\u00107\u001a\u000204J\t\u0010?\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010@\u001a\u00020\u00002\b\b\u0002\u00107\u001a\u00020\u0000J\b\u0010A\u001a\u00020BH\u0016J\u001a\u0010C\u001a\u000204*\u0002042\u0006\u0010D\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0010R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006G"}, d2={"Lkorlibs/math/geom/bezier/CurveLUT;", "", "curve", "Lkorlibs/math/geom/bezier/Curve;", "capacity", "", "(Lkorlibs/math/geom/bezier/Curve;I)V", "points", "Lkorlibs/math/geom/PointArrayList;", "ts", "Lkorlibs/datastructure/DoubleArrayList;", "_estimatedLengths", "(Lkorlibs/math/geom/bezier/Curve;Lkorlibs/math/geom/PointArrayList;Lkorlibs/datastructure/DoubleArrayList;Lkorlibs/datastructure/DoubleArrayList;)V", "getCurve", "()Lkorlibs/math/geom/bezier/Curve;", "estimatedLength", "", "getEstimatedLength", "()D", "estimatedLengths", "getEstimatedLengths", "()Lkorlibs/datastructure/DoubleArrayList;", "getPoints", "()Lkorlibs/math/geom/PointArrayList;", "size", "getSize", "()I", "steps", "getSteps", "getTs", "add", "", "t", "Lkorlibs/math/interpolation/Ratio;", "p", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "add-DJj3pIk", "(DLkorlibs/math/geom/Vector2D;)V", "clear", "closest", "Lkorlibs/math/geom/bezier/CurveLUT$ClosestResult;", "point", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "estimateAt", "Lkorlibs/math/geom/bezier/CurveLUT$Estimation;", "values", "value", "out", "estimateAtEquidistantRatio", "ratio", "estimateAtEquidistantRatio-DJj3pIk", "(DLkorlibs/math/geom/bezier/CurveLUT$Estimation;)Lkorlibs/math/geom/bezier/CurveLUT$Estimation;", "estimateAtLength", "length", "estimateAtT", "hashCode", "toEquidistantLUT", "toString", "", "setAtIndexRatio", "index", "ClosestResult", "Estimation", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeom.bezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/CurveLUT\n+ 2 _Math_interpolation.kt\nkorlibs/math/interpolation/_Math_interpolationKt\n+ 3 _Math_interpolation.kt\nkorlibs/math/interpolation/Ratio$Companion\n*L\n1#1,1957:1\n413#2:1958\n399#3,10:1959\n*S KotlinDebug\n*F\n+ 1 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/CurveLUT\n*L\n1605#1:1958\n1616#1:1959,10\n*E\n"})
public final class CurveLUT {
    @NotNull
    private final Curve curve;
    @NotNull
    private final PointArrayList points;
    @NotNull
    private final DoubleArrayList ts;
    @NotNull
    private final DoubleArrayList _estimatedLengths;

    public CurveLUT(@NotNull Curve curve, @NotNull PointArrayList points, @NotNull DoubleArrayList ts, @NotNull DoubleArrayList _estimatedLengths) {
        this.curve = curve;
        this.points = points;
        this.ts = ts;
        this._estimatedLengths = _estimatedLengths;
    }

    @NotNull
    public final Curve getCurve() {
        return this.curve;
    }

    @NotNull
    public final PointArrayList getPoints() {
        return this.points;
    }

    @NotNull
    public final DoubleArrayList getTs() {
        return this.ts;
    }

    public CurveLUT(@NotNull Curve curve, int capacity) {
        this(curve, new PointArrayList(capacity), new DoubleArrayList(capacity), new DoubleArrayList(capacity));
    }

    @NotNull
    public final DoubleArrayList getEstimatedLengths() {
        if (this._estimatedLengths.isEmpty()) {
            this._estimatedLengths.add(0.0);
        }
        while (this._estimatedLengths.size() < this.getSize()) {
            int pos = this._estimatedLengths.size();
            double prev = ((Number)CollectionsKt.last(this._estimatedLengths)).doubleValue();
            this._estimatedLengths.add(prev + Vector2D.Companion.distance(this.points.get(pos - 1), this.points.get(pos)));
        }
        return this._estimatedLengths;
    }

    public final double getEstimatedLength() {
        return ((Number)CollectionsKt.last(this.getEstimatedLengths())).doubleValue();
    }

    public final int getSteps() {
        return this.points.getSize() - 1;
    }

    public final int getSize() {
        return this.points.getSize();
    }

    public final void clear() {
        this.points.clear();
        this.ts.clear();
        this._estimatedLengths.clear();
    }

    public final void add-DJj3pIk(double t, @NotNull Vector2D p) {
        this.points.add(p);
        this.ts.add(Ratio.toDouble-impl(t));
    }

    @NotNull
    public final ClosestResult closest(@NotNull Vector2D point2) {
        double mdistSq = Double.POSITIVE_INFINITY;
        int mpos = 0;
        int n = this.getSize();
        for (int n2 = 0; n2 < n; ++n2) {
            double d = Vector2D.Companion.distanceSquared(this.points.get(n2), point2);
            if (!(d < mdistSq)) continue;
            mdistSq = d;
            mpos = n2;
        }
        return new ClosestResult(mdistSq, mpos);
    }

    @NotNull
    public final Estimation setAtIndexRatio(@NotNull Estimation $this$setAtIndexRatio, int index2, double ratio2) {
        double ratio0 = _Math_interpolationKt.toRatio(this.ts.get(index2));
        double length0 = this.getEstimatedLengths().get(index2);
        Vector2D point0 = this.points.get(index2);
        if (ratio2 == 0.0) {
            $this$setAtIndexRatio.setRatio-kg1FUQ0(ratio0);
            $this$setAtIndexRatio.setLength(length0);
            $this$setAtIndexRatio.setPoint(point0);
        } else {
            double ratio1 = _Math_interpolationKt.toRatio(this.ts.get(index2 + 1));
            double length1 = this.getEstimatedLengths().get(index2 + 1);
            Vector2D point1 = this.points.get(index2 + 1);
            $this$setAtIndexRatio.setRatio-kg1FUQ0(_Math_interpolationKt.interpolate-yBVj4vc(_Math_interpolationKt.toRatio(ratio2), ratio0, ratio1));
            $this$setAtIndexRatio.setLength(_Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio(ratio2), length0, length1));
            $this$setAtIndexRatio.setPoint(_Math_interpolationKt.interpolate-aphylw4(_Math_interpolationKt.toRatio(ratio2), point0, point1));
        }
        return $this$setAtIndexRatio;
    }

    private final Estimation estimateAt(DoubleArrayList values2, double value, Estimation out) {
        int result2 = _ExtensionsKt.binarySearch$default(values2, value, 0, 0, 6, null);
        if (BSearchResult.getFound-impl(result2)) {
            return this.setAtIndexRatio(out, BSearchResult.getIndex-impl(result2), 0.0);
        }
        int index2 = BSearchResult.getNearIndex-impl(result2);
        if (value <= 0.0) {
            return this.setAtIndexRatio(out, 0, 0.0);
        }
        if (index2 >= values2.size() - 1) {
            return this.setAtIndexRatio(out, this.points.getSize() - 1, 0.0);
        }
        double ratio0 = values2.get(index2);
        double ratio1 = values2.get(index2 + 1);
        double ratio2 = ConvertRangeKt.convertRange(value, ratio0, ratio1, 0.0, 1.0);
        return this.setAtIndexRatio(out, index2, ratio2);
    }

    static /* synthetic */ Estimation estimateAt$default(CurveLUT curveLUT, DoubleArrayList doubleArrayList, double d, Estimation estimation, int n, Object object) {
        if ((n & 4) != 0) {
            estimation = new Estimation(null, 0.0, 0.0, 7, null);
        }
        return curveLUT.estimateAt(doubleArrayList, d, estimation);
    }

    @NotNull
    public final Estimation estimateAtT(double t, @NotNull Estimation out) {
        return this.estimateAt(this.ts, t, out);
    }

    public static /* synthetic */ Estimation estimateAtT$default(CurveLUT curveLUT, double d, Estimation estimation, int n, Object object) {
        if ((n & 2) != 0) {
            estimation = new Estimation(null, 0.0, 0.0, 7, null);
        }
        return curveLUT.estimateAtT(d, estimation);
    }

    @NotNull
    public final Estimation estimateAtEquidistantRatio-DJj3pIk(double ratio2, @NotNull Estimation out) {
        double $this$times_u2dBdQlfBE$iv = this.getEstimatedLength();
        boolean bl = false;
        return this.estimateAtLength($this$times_u2dBdQlfBE$iv * ratio2, out);
    }

    public static /* synthetic */ Estimation estimateAtEquidistantRatio-DJj3pIk$default(CurveLUT curveLUT, double d, Estimation estimation, int n, Object object) {
        if ((n & 2) != 0) {
            estimation = new Estimation(null, 0.0, 0.0, 7, null);
        }
        return curveLUT.estimateAtEquidistantRatio-DJj3pIk(d, estimation);
    }

    @NotNull
    public final Estimation estimateAtLength(double length2, @NotNull Estimation out) {
        return this.estimateAt(this.getEstimatedLengths(), length2, out);
    }

    public static /* synthetic */ Estimation estimateAtLength$default(CurveLUT curveLUT, double d, Estimation estimation, int n, Object object) {
        if ((n & 2) != 0) {
            estimation = new Estimation(null, 0.0, 0.0, 7, null);
        }
        return curveLUT.estimateAtLength(d, estimation);
    }

    @NotNull
    public final CurveLUT toEquidistantLUT(@NotNull CurveLUT out) {
        int steps2 = this.getSteps();
        double length2 = this.getEstimatedLength();
        Estimation result2 = new Estimation(null, 0.0, 0.0, 7, null);
        Ratio.Companion $this$iv = Ratio.Companion;
        boolean include0$iv = true;
        boolean include1$iv = true;
        boolean $i$f$forEachRatio = false;
        int NS$iv = steps2 - 1;
        double NSd$iv = NS$iv;
        int start$iv = 0;
        int n$iv = start$iv;
        int end$iv = NS$iv;
        if (n$iv <= end$iv) {
            while (true) {
                double ratio$iv = (double)n$iv / NSd$iv;
                double ratio2 = _Math_interpolationKt.toRatio(ratio$iv);
                boolean bl = false;
                double len = Ratio.convertToRange-impl(ratio2, 0.0, length2);
                Estimation est = this.estimateAtLength(len, result2);
                this.add-DJj3pIk(est.getRatio-eKSQRR4(), est.getPoint());
                if (n$iv == end$iv) break;
                ++n$iv;
            }
        }
        return out;
    }

    public static /* synthetic */ CurveLUT toEquidistantLUT$default(CurveLUT curveLUT, CurveLUT curveLUT2, int n, Object object) {
        if ((n & 1) != 0) {
            curveLUT2 = new CurveLUT(curveLUT.curve, curveLUT.points.getSize());
        }
        return curveLUT.toEquidistantLUT(curveLUT2);
    }

    @NotNull
    public String toString() {
        return "CurveLUT[" + this.curve + "](" + CollectionsKt.joinToString$default(RangesKt.until(0, this.getSize()), ", ", null, null, 0, null, new Function1<Integer, CharSequence>(this){
            final /* synthetic */ CurveLUT this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(int it) {
                return this.this$0.getTs().get(it) + ",len=" + this.this$0.getEstimatedLengths().get(it) + ": " + this.this$0.getPoints().get(it);
            }
        }, 30, null) + ")";
    }

    @NotNull
    public final Curve component1() {
        return this.curve;
    }

    @NotNull
    public final PointArrayList component2() {
        return this.points;
    }

    @NotNull
    public final DoubleArrayList component3() {
        return this.ts;
    }

    private final DoubleArrayList component4() {
        return this._estimatedLengths;
    }

    @NotNull
    public final CurveLUT copy(@NotNull Curve curve, @NotNull PointArrayList points, @NotNull DoubleArrayList ts, @NotNull DoubleArrayList _estimatedLengths) {
        return new CurveLUT(curve, points, ts, _estimatedLengths);
    }

    public static /* synthetic */ CurveLUT copy$default(CurveLUT curveLUT, Curve curve, PointArrayList pointArrayList, DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, int n, Object object) {
        if ((n & 1) != 0) {
            curve = curveLUT.curve;
        }
        if ((n & 2) != 0) {
            pointArrayList = curveLUT.points;
        }
        if ((n & 4) != 0) {
            doubleArrayList = curveLUT.ts;
        }
        if ((n & 8) != 0) {
            doubleArrayList2 = curveLUT._estimatedLengths;
        }
        return curveLUT.copy(curve, pointArrayList, doubleArrayList, doubleArrayList2);
    }

    public int hashCode() {
        int result2 = this.curve.hashCode();
        result2 = result2 * 31 + this.points.hashCode();
        result2 = result2 * 31 + this.ts.hashCode();
        result2 = result2 * 31 + this._estimatedLengths.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CurveLUT)) {
            return false;
        }
        CurveLUT curveLUT = (CurveLUT)other;
        if (!Intrinsics.areEqual(this.curve, curveLUT.curve)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.points, curveLUT.points)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ts, curveLUT.ts)) {
            return false;
        }
        return Intrinsics.areEqual(this._estimatedLengths, curveLUT._estimatedLengths);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lkorlibs/math/geom/bezier/CurveLUT$ClosestResult;", "", "mdistSq", "", "mpos", "", "(DI)V", "mdist", "getMdist", "()D", "getMdistSq", "getMpos", "()I", "korge-foundation"})
    public static final class ClosestResult {
        private final double mdistSq;
        private final int mpos;

        public ClosestResult(double mdistSq, int mpos) {
            this.mdistSq = mdistSq;
            this.mpos = mpos;
        }

        public final double getMdistSq() {
            return this.mdistSq;
        }

        public final int getMpos() {
            return this.mpos;
        }

        public final double getMdist() {
            return Math.sqrt(this.mdistSq);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0015\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0016\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u000bJ\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020 J\b\u0010#\u001a\u00020$H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006%"}, d2={"Lkorlibs/math/geom/bezier/CurveLUT$Estimation;", "", "point", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "ratio", "Lkorlibs/math/interpolation/Ratio;", "length", "", "(Lkorlibs/math/geom/Vector2D;DDLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getLength", "()D", "setLength", "(D)V", "getPoint", "()Lkorlibs/math/geom/Vector2D;", "setPoint", "(Lkorlibs/math/geom/Vector2D;)V", "getRatio-eKSQRR4", "setRatio-kg1FUQ0", "D", "component1", "component2", "component2-eKSQRR4", "component3", "copy", "copy-NvLngv4", "(Lkorlibs/math/geom/Vector2D;DD)Lkorlibs/math/geom/bezier/CurveLUT$Estimation;", "equals", "", "other", "hashCode", "", "roundDecimalDigits", "places", "toString", "", "korge-foundation"})
    public static final class Estimation {
        @NotNull
        private Vector2D point;
        private double ratio;
        private double length;

        private Estimation(Vector2D point2, double ratio2, double length2) {
            this.point = point2;
            this.ratio = ratio2;
            this.length = length2;
        }

        public /* synthetic */ Estimation(Vector2D vector2D, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                vector2D = new Vector2D();
            }
            if ((n & 2) != 0) {
                d = Ratio.Companion.getZERO-eKSQRR4();
            }
            if ((n & 4) != 0) {
                d2 = 0.0;
            }
            this(vector2D, d, d2, null);
        }

        @NotNull
        public final Vector2D getPoint() {
            return this.point;
        }

        public final void setPoint(@NotNull Vector2D vector2D) {
            this.point = vector2D;
        }

        public final double getRatio-eKSQRR4() {
            return this.ratio;
        }

        public final void setRatio-kg1FUQ0(double d) {
            this.ratio = d;
        }

        public final double getLength() {
            return this.length;
        }

        public final void setLength(double d) {
            this.length = d;
        }

        @NotNull
        public final Estimation roundDecimalDigits(int places) {
            return new Estimation(this.point.roundDecimalPlaces(places), Ratio.roundDecimalPlaces-4uGNJ3M(this.ratio, places), RoundDecimalPlacesKt.roundDecimalPlaces(this.length, places), null);
        }

        @NotNull
        public String toString() {
            return "Estimation(point=" + this.point.getNiceStr() + ", ratio=" + _Math_interpolationKt.getNiceStr-kg1FUQ0(this.ratio) + ", length=" + StringExtKt.getNiceStr(this.length) + ")";
        }

        @NotNull
        public final Vector2D component1() {
            return this.point;
        }

        public final double component2-eKSQRR4() {
            return this.ratio;
        }

        public final double component3() {
            return this.length;
        }

        @NotNull
        public final Estimation copy-NvLngv4(@NotNull Vector2D point2, double ratio2, double length2) {
            return new Estimation(point2, ratio2, length2, null);
        }

        public static /* synthetic */ Estimation copy-NvLngv4$default(Estimation estimation, Vector2D vector2D, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                vector2D = estimation.point;
            }
            if ((n & 2) != 0) {
                d = estimation.ratio;
            }
            if ((n & 4) != 0) {
                d2 = estimation.length;
            }
            return estimation.copy-NvLngv4(vector2D, d, d2);
        }

        public int hashCode() {
            int result2 = this.point.hashCode();
            result2 = result2 * 31 + Ratio.hashCode-impl(this.ratio);
            result2 = result2 * 31 + Double.hashCode(this.length);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Estimation)) {
                return false;
            }
            Estimation estimation = (Estimation)other;
            if (!Intrinsics.areEqual(this.point, estimation.point)) {
                return false;
            }
            if (!Ratio.equals-impl0(this.ratio, estimation.ratio)) {
                return false;
            }
            return Double.compare(this.length, estimation.length) == 0;
        }

        public /* synthetic */ Estimation(Vector2D point2, double ratio2, double length2, DefaultConstructorMarker $constructor_marker) {
            this(point2, ratio2, length2);
        }
    }
}

