/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.bezier;

import java.util.List;
import korlibs.math.geom.PointArrayList;
import korlibs.math.geom.PointList;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.bezier.Bezier;
import korlibs.math.geom.bezier.CurveSplit;
import korlibs.math.interpolation.Ratio;
import korlibs.math.interpolation._Math_interpolationKt;
import korlibs.number.StringExtKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ,\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ&\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J&\u0010!\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010 J\u001c\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010\u0017\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\u0018\u0010/\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101J\u0018\u00102\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b3\u00101J\b\u00104\u001a\u000205H\u0016R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0019\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0007\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0015\u0010\u0013\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00067"}, d2={"Lkorlibs/math/geom/bezier/SubBezier;", "", "curve", "Lkorlibs/math/geom/bezier/Bezier;", "(Lkorlibs/math/geom/bezier/Bezier;)V", "t1", "Lkorlibs/math/interpolation/Ratio;", "t2", "parent", "(Lkorlibs/math/geom/bezier/Bezier;DDLkorlibs/math/geom/bezier/Bezier;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "boundingBox", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "getBoundingBox", "()Lkorlibs/math/geom/RectangleD;", "getCurve", "()Lkorlibs/math/geom/bezier/Bezier;", "getParent", "getT1-eKSQRR4", "()D", "D", "getT2-eKSQRR4", "_split", "t", "hull", "Lkorlibs/math/geom/PointList;", "left", "", "_split-aphylw4", "(DLkorlibs/math/geom/PointList;Z)Lkorlibs/math/geom/bezier/SubBezier;", "_splitLeft", "_splitLeft-DJj3pIk", "(DLkorlibs/math/geom/PointList;)Lkorlibs/math/geom/bezier/SubBezier;", "_splitRight", "_splitRight-DJj3pIk", "calc", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "calc-kg1FUQ0", "(D)Lkorlibs/math/geom/Vector2D;", "roundDecimalPlaces", "places", "", "split", "Lkorlibs/math/geom/bezier/CurveSplit;", "split-kg1FUQ0", "(D)Lkorlibs/math/geom/bezier/CurveSplit;", "splitLeft", "splitLeft-kg1FUQ0", "(D)Lkorlibs/math/geom/bezier/SubBezier;", "splitRight", "splitRight-kg1FUQ0", "toString", "", "Companion", "korge-foundation"})
public final class SubBezier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bezier curve;
    private final double t1;
    private final double t2;
    @Nullable
    private final Bezier parent;
    @NotNull
    private static final List<int[]> LEFT;
    @NotNull
    private static final List<int[]> RIGHT;

    private SubBezier(Bezier curve, double t1, double t2, Bezier parent2) {
        this.curve = curve;
        this.t1 = t1;
        this.t2 = t2;
        this.parent = parent2;
    }

    @NotNull
    public final Bezier getCurve() {
        return this.curve;
    }

    public final double getT1-eKSQRR4() {
        return this.t1;
    }

    public final double getT2-eKSQRR4() {
        return this.t2;
    }

    @Nullable
    public final Bezier getParent() {
        return this.parent;
    }

    public SubBezier(@NotNull Bezier curve) {
        this(curve, Ratio.Companion.getZERO-eKSQRR4(), Ratio.Companion.getONE-eKSQRR4(), null, null);
    }

    @NotNull
    public final RectangleD getBoundingBox() {
        return this.curve.getBoundingBox();
    }

    @NotNull
    public final Vector2D calc-kg1FUQ0(double t) {
        return this.curve.calc-kg1FUQ0(_Math_interpolationKt.convertRange-BKgx9t0(t, this.t1, this.t2, Ratio.Companion.getZERO-eKSQRR4(), Ratio.Companion.getONE-eKSQRR4()));
    }

    private final SubBezier _split-aphylw4(double t, PointList hull, boolean left) {
        Bezier bezier;
        double rt2;
        double rt = _Math_interpolationKt.convertRange-BKgx9t0(t, Ratio.Companion.getZERO-eKSQRR4(), Ratio.Companion.getONE-eKSQRR4(), this.t1, this.t2);
        double rt1 = left ? this.t1 : rt;
        double d = rt2 = left ? rt : this.t2;
        if (this.curve.getOrder() < 2) {
            Vector2D p1 = this.calc-kg1FUQ0(rt1);
            Vector2D p2 = this.calc-kg1FUQ0(rt2);
            bezier = new Bezier(p1, p2);
        } else {
            List<int[]> indices = left ? LEFT : RIGHT;
            int[] nArray = indices.get(this.curve.getOrder());
            Intrinsics.checkNotNull(nArray);
            PointList pointList = hull;
            Intrinsics.checkNotNull(pointList);
            bezier = SubBezier.Companion.BezierCurveFromIndices(nArray, pointList);
        }
        Bezier curve = bezier;
        return new SubBezier(curve, rt1, rt2, this.parent, null);
    }

    private final SubBezier _splitLeft-DJj3pIk(double t, PointList hull) {
        return this._split-aphylw4(t, hull, true);
    }

    static /* synthetic */ SubBezier _splitLeft-DJj3pIk$default(SubBezier subBezier, double d, PointList pointList, int n, Object object) {
        if ((n & 2) != 0) {
            pointList = Bezier.hullOrNull-DJj3pIk$default(subBezier.curve, d, null, 2, null);
        }
        return subBezier._splitLeft-DJj3pIk(d, pointList);
    }

    private final SubBezier _splitRight-DJj3pIk(double t, PointList hull) {
        return this._split-aphylw4(t, hull, false);
    }

    static /* synthetic */ SubBezier _splitRight-DJj3pIk$default(SubBezier subBezier, double d, PointList pointList, int n, Object object) {
        if ((n & 2) != 0) {
            pointList = Bezier.hullOrNull-DJj3pIk$default(subBezier.curve, d, null, 2, null);
        }
        return subBezier._splitRight-DJj3pIk(d, pointList);
    }

    @NotNull
    public final SubBezier splitLeft-kg1FUQ0(double t) {
        return SubBezier._splitLeft-DJj3pIk$default(this, t, null, 2, null);
    }

    @NotNull
    public final SubBezier splitRight-kg1FUQ0(double t) {
        return SubBezier._splitRight-DJj3pIk$default(this, t, null, 2, null);
    }

    @NotNull
    public final CurveSplit split-kg1FUQ0(double t) {
        PointList hull = Bezier.hullOrNull-DJj3pIk$default(this.curve, t, null, 2, null);
        Bezier bezier = this.curve;
        SubBezier subBezier = this._splitLeft-DJj3pIk(t, hull);
        SubBezier subBezier2 = this._splitRight-DJj3pIk(t, hull);
        return new CurveSplit(bezier, subBezier, subBezier2, t, hull, null);
    }

    @NotNull
    public String toString() {
        return "SubBezier[" + StringExtKt.getNiceStr(Ratio.toDouble-impl(this.t1)) + ".." + StringExtKt.getNiceStr(Ratio.toDouble-impl(this.t2)) + "](" + this.curve + ")";
    }

    @NotNull
    public final SubBezier roundDecimalPlaces(int places) {
        Bezier bezier = this.parent;
        return new SubBezier(this.curve.roundDecimalPlaces(places), Ratio.roundDecimalPlaces-4uGNJ3M(this.t1, places), Ratio.roundDecimalPlaces-4uGNJ3M(this.t2, places), bezier != null ? bezier.roundDecimalPlaces(places) : null, null);
    }

    public /* synthetic */ SubBezier(Bezier curve, double t1, double t2, Bezier parent2, DefaultConstructorMarker $constructor_marker) {
        this(curve, t1, t2, parent2);
    }

    static {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = null;
        nArrayArray[1] = null;
        int[] nArray = new int[]{0, 3, 5};
        nArrayArray[2] = nArray;
        nArray = new int[]{0, 4, 7, 9};
        nArrayArray[3] = nArray;
        LEFT = CollectionsKt.listOf((Object[])nArrayArray);
        nArrayArray = new int[4][];
        nArrayArray[0] = null;
        nArrayArray[1] = null;
        nArray = new int[]{5, 4, 2};
        nArrayArray[2] = nArray;
        nArray = new int[]{9, 8, 6, 3};
        nArrayArray[3] = nArray;
        RIGHT = CollectionsKt.listOf((Object[])nArrayArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkorlibs/math/geom/bezier/SubBezier$Companion;", "", "()V", "LEFT", "", "", "RIGHT", "BezierCurveFromIndices", "Lkorlibs/math/geom/bezier/Bezier;", "indices", "points", "Lkorlibs/math/geom/PointList;", "korge-foundation"})
    public static final class Companion {
        private Companion() {
        }

        private final Bezier BezierCurveFromIndices(int[] indices, PointList points) {
            PointArrayList p = new PointArrayList(indices.length);
            for (int index2 : indices) {
                p.add(points, index2);
            }
            return new Bezier(p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

