/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.binpack;

import korlibs.datastructure.FastArrayList;
import korlibs.datastructure.FastArrayListKt;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Size2D;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.binpack.BinPacker;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0011\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0014\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\n\u0010\u0015\u001a\u00060\tj\u0002`\nH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006H\u0002J\u001a\u0010\u0019\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\n\u0010\u0015\u001a\u00060\tj\u0002`\nJ \u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u001d\u001a\u00060\u000ej\u0002`\u000fH\u0002R$\u0010\f\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lkorlibs/math/geom/binpack/MaxRects;", "Lkorlibs/math/geom/binpack/BinPacker$Algo;", "width", "", "height", "(FF)V", "", "(DD)V", "maxSize", "Lkorlibs/math/geom/Size2D;", "Lkorlibs/math/geom/Size;", "(Lkorlibs/math/geom/Size2D;)V", "freeRectangles", "Lkorlibs/datastructure/FastArrayList;", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "getFreeRectangles", "()Lkorlibs/datastructure/FastArrayList;", "setFreeRectangles", "(Lkorlibs/datastructure/FastArrayList;)V", "add", "size", "pruneFreeList", "", "quickFindPositionForNewNodeBestAreaFit", "quickInsert", "splitFreeNode", "", "freeNode", "usedNode", "korge-foundation"})
public final class MaxRects
implements BinPacker.Algo {
    @NotNull
    private FastArrayList<RectangleD> freeRectangles;

    public MaxRects(@NotNull Size2D maxSize) {
        RectangleD[] rectangleDArray = new RectangleD[]{RectangleD.Companion.invoke(Vector2D.Companion.getZERO(), maxSize)};
        this.freeRectangles = FastArrayListKt.fastArrayListOf(rectangleDArray);
    }

    public MaxRects(float width2, float height2) {
        this(new Size2D(width2, height2));
    }

    public MaxRects(double width2, double height2) {
        this(new Size2D(width2, height2));
    }

    @NotNull
    public final FastArrayList<RectangleD> getFreeRectangles() {
        return this.freeRectangles;
    }

    public final void setFreeRectangles(@NotNull FastArrayList<RectangleD> fastArrayList) {
        this.freeRectangles = fastArrayList;
    }

    @Override
    @Nullable
    public RectangleD add(@NotNull Size2D size2) {
        return this.quickInsert(size2);
    }

    @Nullable
    public final RectangleD quickInsert(@NotNull Size2D size2) {
        double width2 = size2.component1();
        double height2 = size2.component2();
        if (width2 <= 0.0 && height2 <= 0.0) {
            return RectangleD.Companion.invoke(0, 0, 0, 0);
        }
        RectangleD newNode = this.quickFindPositionForNewNodeBestAreaFit(width2, height2);
        if (newNode.getHeight() == 0.0) {
            return null;
        }
        int numRectanglesToProcess = this.freeRectangles.size();
        for (int i2 = 0; i2 < numRectanglesToProcess; ++i2) {
            if (!this.splitFreeNode(this.freeRectangles.get(i2), newNode)) continue;
            this.freeRectangles.remove(i2);
            --numRectanglesToProcess;
            --i2;
        }
        this.pruneFreeList();
        return newNode;
    }

    private final RectangleD quickFindPositionForNewNodeBestAreaFit(double width2, double height2) {
        double score = Double.MAX_VALUE;
        double areaFit = 0.0;
        RectangleD bestNode = RectangleD.Companion.invoke();
        for (RectangleD r : this.freeRectangles) {
            if (!(r.getWidth() >= width2) || !(r.getHeight() >= height2) || !((areaFit = r.getWidth() * r.getHeight() - width2 * height2) < score)) continue;
            bestNode = new RectangleD(r.getX(), r.getY(), width2, height2);
            score = areaFit;
        }
        return bestNode;
    }

    private final boolean splitFreeNode(RectangleD freeNode, RectangleD usedNode) {
        RectangleD newNode = null;
        if (usedNode.getLeft() >= freeNode.getRight() || usedNode.getRight() <= freeNode.getX() || usedNode.getTop() >= freeNode.getBottom() || usedNode.getBottom() <= freeNode.getTop()) {
            return false;
        }
        if (usedNode.getX() < freeNode.getRight() && usedNode.getRight() > freeNode.getX()) {
            if (usedNode.getY() > freeNode.getY() && usedNode.getY() < freeNode.getBottom()) {
                newNode = RectangleD.copy$default(freeNode, 0.0, 0.0, 0.0, usedNode.getY() - freeNode.getY(), 7, null);
                this.freeRectangles.add(newNode);
            }
            if (usedNode.getBottom() < freeNode.getBottom()) {
                newNode = RectangleD.copy$default(freeNode, 0.0, usedNode.getBottom(), 0.0, freeNode.getBottom() - usedNode.getBottom(), 5, null);
                this.freeRectangles.add(newNode);
            }
        }
        if (usedNode.getY() < freeNode.getBottom() && usedNode.getBottom() > freeNode.getY()) {
            if (usedNode.getX() > freeNode.getX() && usedNode.getX() < freeNode.getRight()) {
                newNode = RectangleD.copy$default(freeNode, 0.0, 0.0, usedNode.getX() - freeNode.getX(), 0.0, 11, null);
                this.freeRectangles.add(newNode);
            }
            if (usedNode.getRight() < freeNode.getRight()) {
                newNode = RectangleD.copy$default(freeNode, usedNode.getRight(), 0.0, freeNode.getRight() - usedNode.getRight(), 0.0, 10, null);
                this.freeRectangles.add(newNode);
            }
        }
        return true;
    }

    private final void pruneFreeList() {
        int len = this.freeRectangles.size();
        block0: for (int i2 = 0; i2 < len; ++i2) {
            RectangleD tmpRect = this.freeRectangles.get(i2);
            for (int j = i2 + 1; j < len; ++j) {
                RectangleD tmpRect2 = this.freeRectangles.get(j);
                if (RectangleD.Companion.isContainedIn(tmpRect, tmpRect2)) {
                    this.freeRectangles.remove(i2);
                    --i2;
                    --len;
                    continue block0;
                }
                if (!RectangleD.Companion.isContainedIn(tmpRect2, tmpRect)) continue;
                this.freeRectangles.remove(j);
                --len;
                --j;
            }
        }
    }
}

