/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.convex;

import java.util.List;
import korlibs.math.geom.Angle;
import korlibs.math.geom.PointList;
import korlibs.math.geom.bezier.Curves;
import korlibs.math.geom.bezier._MathGeom_bezierKt;
import korlibs.math.geom.vector.VectorPath;
import korlibs.math.geom.vector._MathGeom_vector_VectorPathKt;
import korlibs.math.interpolation.Ratio;
import korlibs.math.interpolation._Math_interpolationKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lkorlibs/math/geom/convex/Convex;", "", "()V", "isConvex", "", "vertices", "Lkorlibs/math/geom/PointList;", "curves", "Lkorlibs/math/geom/bezier/Curves;", "path", "Lkorlibs/math/geom/vector/VectorPath;", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeom.convex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.convex.kt\nkorlibs/math/geom/convex/Convex\n+ 2 Angle.kt\nkorlibs/math/geom/Angle$Companion\n*L\n1#1,203:1\n149#2:204\n*S KotlinDebug\n*F\n+ 1 _MathGeom.convex.kt\nkorlibs/math/geom/convex/Convex\n*L\n90#1:204\n*E\n"})
public final class Convex {
    @NotNull
    public static final Convex INSTANCE = new Convex();

    private Convex() {
    }

    public final boolean isConvex(@NotNull VectorPath path2) {
        List<Curves> curvesLists = _MathGeom_vector_VectorPathKt.getCurvesList(path2);
        if (curvesLists.size() != 1) {
            return false;
        }
        return this.isConvex(CollectionsKt.first(curvesLists));
    }

    public final boolean isConvex(@NotNull Curves curves) {
        PointList pointList = _MathGeom_bezierKt.toNonCurveSimplePointList$default(curves, null, 1, null);
        if (pointList == null) {
            return false;
        }
        PointList points = pointList;
        return this.isConvex(points);
    }

    public final boolean isConvex(@NotNull PointList vertices) {
        int base2 = 0;
        int n = vertices.getSize();
        double TWO_PI = Math.PI * 2;
        if (n <= 3) {
            return true;
        }
        if (vertices.getX(base2) == vertices.getX(n - 1) && vertices.getY(base2) == vertices.getY(n - 1)) {
            --n;
        }
        double old_x = vertices.getX(n - 2);
        double old_y = vertices.getY(n - 2);
        double new_x = vertices.getX(n - 1);
        double new_y = vertices.getY(n - 1);
        double new_direction = Math.atan2(new_y - old_y, new_x - old_x);
        double old_direction = 0.0;
        double angle_sum = Angle.Companion.getZERO-igmgxjg();
        double orientation2 = 0.0;
        int n2 = n;
        for (int i2 = 0; i2 < n2; ++i2) {
            old_x = new_x;
            old_y = new_y;
            old_direction = new_direction;
            int p = base2++;
            new_x = vertices.getX(p);
            new_y = vertices.getY(p);
            new_direction = Math.atan2(new_y - old_y, new_x - old_x);
            if (old_x == new_x && old_y == new_y) {
                return false;
            }
            double angle = new_direction - old_direction;
            if (angle <= -Math.PI) {
                angle += TWO_PI;
            } else if (angle > Math.PI) {
                angle -= TWO_PI;
            }
            if (i2 == 0) {
                if (angle == 0.0) {
                    return false;
                }
                orientation2 = angle > 0.0 ? 1.0 : -1.0;
            } else if (orientation2 * angle < 0.0) {
                return false;
            }
            Angle.Companion this_$iv = Angle.Companion;
            boolean bl = false;
            angle_sum = Angle.plus-9E-s4b0(angle_sum, Angle.constructor-impl(angle));
        }
        return _Math_interpolationKt.isAlmostEquals-yBVj4vc$default(Ratio.Companion.getONE-eKSQRR4(), Ratio.getAbsoluteValue-eKSQRR4(Angle.getRatio-eKSQRR4(angle_sum)), 0.0, 2, null);
    }
}

