/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.shape;

import java.util.List;
import korlibs.datastructure.FastArrayList;
import korlibs.datastructure.ds.BVH;
import korlibs.math.IsAlmostEquals;
import korlibs.math.geom.Circle;
import korlibs.math.geom.Matrix;
import korlibs.math.geom.PointArrayList;
import korlibs.math.geom.PointList;
import korlibs.math.geom.RectangleD;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.bezier.Bezier;
import korlibs.math.geom.bezier.Curves;
import korlibs.math.geom.ds.BVH2D;
import korlibs.math.geom.shape.CompoundShape2D;
import korlibs.math.geom.shape.EmptyShape2D;
import korlibs.math.geom.shape._MathGeom_shapeKt;
import korlibs.math.geom.vector.VectorPath;
import korlibs.math.geom.vector._MathGeom_vector_VectorPathKt;
import korlibs.math.interpolation.Ratio;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \"2\u00020\u0001:\u0001\"J$\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0017J\u0014\u0010\u0011\u001a\u00020\f2\n\u0010\u0014\u001a\u00060\u0007j\u0002`\bH\u0016J$\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0017J\u0014\u0010\u0016\u001a\u00020\u00032\n\u0010\u0014\u001a\u00060\u0007j\u0002`\bH\u0016J\f\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0016J \u0010\u001d\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0000H\u0016J(\u0010\u001e\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0017J\u0014\u0010\u001e\u001a\u00020\u00072\n\u0010\u0014\u001a\u00060\u0007j\u0002`\bH&J(\u0010\u001f\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0015\u001a\u00020\u0013H\u0017J\u0018\u0010\u001f\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0014\u001a\u00060\u0007j\u0002`\bH&J\b\u0010 \u001a\u00020!H&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005\u00a8\u0006#"}, d2={"Lkorlibs/math/geom/shape/Shape2D;", "", "area", "", "getArea", "()D", "center", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "getCenter", "()Lkorlibs/math/geom/Vector2D;", "closed", "", "getClosed", "()Z", "perimeter", "getPerimeter", "containsPoint", "ml", "Lkorlibs/math/geom/Matrix;", "p", "mr", "distance", "getBounds", "Lkorlibs/math/geom/RectangleD;", "Lkorlibs/math/geom/Rectangle;", "intersectionsWith", "Lkorlibs/math/geom/PointList;", "that", "intersectsWith", "normalVectorAt", "projectedPoint", "toVectorPath", "Lkorlibs/math/geom/vector/VectorPath;", "Companion", "korge-foundation"})
public interface Shape2D {
    @NotNull
    public static final Companion Companion = korlibs.math.geom.shape.Shape2D$Companion.$$INSTANCE;

    public boolean getClosed();

    @NotNull
    public Vector2D getCenter();

    public double getArea();

    public double getPerimeter();

    public double distance(@NotNull Vector2D var1);

    @NotNull
    public Vector2D normalVectorAt(@NotNull Vector2D var1);

    @NotNull
    public Vector2D projectedPoint(@NotNull Vector2D var1);

    @NotNull
    public VectorPath toVectorPath();

    public boolean containsPoint(@NotNull Vector2D var1);

    @NotNull
    public RectangleD getBounds();

    @NotNull
    public PointList intersectionsWith(@NotNull Shape2D var1);

    public boolean intersectsWith(@NotNull Shape2D var1);

    public boolean intersectsWith(@NotNull Matrix var1, @NotNull Shape2D var2, @NotNull Matrix var3);

    @Deprecated(message="Untested yet")
    public boolean containsPoint(@NotNull Matrix var1, @NotNull Vector2D var2, @NotNull Matrix var3);

    @Deprecated(message="Untested yet")
    public double distance(@NotNull Matrix var1, @NotNull Vector2D var2, @NotNull Matrix var3);

    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D normalVectorAt(@NotNull Matrix var1, @NotNull Vector2D var2, @NotNull Matrix var3);

    @Deprecated(message="Untested yet")
    @NotNull
    public Vector2D projectedPoint(@NotNull Matrix var1, @NotNull Vector2D var2, @NotNull Matrix var3);

    @NotNull
    public PointList intersectionsWith(@NotNull Matrix var1, @NotNull Shape2D var2, @NotNull Matrix var3);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\"\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lkorlibs/math/geom/shape/Shape2D$Companion;", "", "()V", "_intersectsStep0", "", "l", "Lkorlibs/math/geom/shape/Shape2D;", "ml", "Lkorlibs/math/geom/Matrix;", "r", "mr", "intersections", "Lkorlibs/math/geom/PointList;", "intersects", "invoke", "shapes", "", "([Lkorlibs/math/geom/shape/Shape2D;)Lkorlibs/math/geom/shape/Shape2D;", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\n_MathGeom.shape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.shape.kt\nkorlibs/math/geom/shape/Shape2D$Companion\n+ 2 VectorsList.kt\nkorlibs/math/geom/VectorsListKt\n+ 3 Matrix.kt\nkorlibs/math/geom/Matrix\n*L\n1#1,533:1\n69#2:534\n65#3,4:535\n*S KotlinDebug\n*F\n+ 1 _MathGeom.shape.kt\nkorlibs/math/geom/shape/Shape2D$Companion\n*L\n193#1:534\n194#1:535,4\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Shape2D invoke(Shape2D ... shapes) {
            if (shapes.length == 0) {
                return EmptyShape2D.INSTANCE;
            }
            if (shapes.length == 1) {
                return shapes[0];
            }
            return new CompoundShape2D(ArraysKt.toList(shapes));
        }

        @NotNull
        public final PointList intersections(@NotNull Shape2D l, @NotNull Matrix ml, @NotNull Shape2D r, @NotNull Matrix mr) {
            return l.intersectionsWith(ml, r, mr);
        }

        public final boolean intersects(@NotNull Shape2D l, @NotNull Matrix ml, @NotNull Shape2D r, @NotNull Matrix mr) {
            if (ml.isNIL() && mr.isNIL() && l instanceof Circle && r instanceof Circle) {
                return _MathGeom_shapeKt.access$optimizedIntersect((Circle)l, ml, (Circle)r, mr);
            }
            return this._intersectsStep0(l, ml, r, mr) || this._intersectsStep0(r, mr, l, ml);
        }

        private final boolean _intersectsStep0(Shape2D l, Matrix ml, Shape2D r, Matrix mr) {
            Matrix tempMatrix = null;
            Matrix matrix2 = tempMatrix = mr.isNotNIL() ? mr.inverted() : Matrix.Companion.getIDENTITY();
            if (ml.isNotNIL()) {
                tempMatrix = tempMatrix.premultiplied(ml);
            }
            PointList $this$fastForEach$iv = _MathGeom_shapeKt.getCachedPoints(l.toVectorPath());
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.getSize();
            for (int n$iv = 0; n$iv < n; ++n$iv) {
                Vector2D it = $this$fastForEach$iv.get(n$iv);
                boolean bl = false;
                Matrix this_$iv = tempMatrix;
                boolean $i$f$transform = false;
                if (!r.containsPoint(this_$iv.isNIL() ? it : new Vector2D(this_$iv.transformX(it.getX(), it.getY()), this_$iv.transformY(it.getX(), it.getY())))) continue;
                return true;
            }
            return false;
        }

        public final boolean intersects(@NotNull Shape2D l, @NotNull Shape2D r) {
            return this.intersects(l, Matrix.Companion.getNIL(), r, Matrix.Companion.getNIL());
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\n_MathGeom.shape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.shape.kt\nkorlibs/math/geom/shape/Shape2D$DefaultImpls\n+ 2 _Datastructure_iterators.kt\nkorlibs/datastructure/iterators/_Datastructure_iteratorsKt\n+ 3 VectorsDouble.kt\nkorlibs/math/geom/Vector2D\n+ 4 Matrix.kt\nkorlibs/math/geom/Matrix\n+ 5 _MathGeom.bezier.kt\nkorlibs/math/geom/bezier/_MathGeom_bezierKt\n+ 6 NonJs.kt\nkorlibs/datastructure/FastArrayList\n+ 7 VectorsDouble.kt\nkorlibs/math/geom/Vector2D$Companion\n*L\n1#1,533:1\n61#2,3:534\n61#2,2:561\n61#2,2:570\n63#2:590\n63#2:592\n43#3:537\n81#3:538\n81#3:543\n43#3:548\n81#3:549\n80#3:554\n81#3:555\n42#3,11:573\n81#3:584\n43#3:589\n65#4,4:539\n65#4,4:544\n65#4,4:550\n65#4,4:556\n65#4,4:585\n1814#5:560\n1815#5:593\n161#6,7:563\n169#6:591\n172#7:572\n*S KotlinDebug\n*F\n+ 1 _MathGeom.shape.kt\nkorlibs/math/geom/shape/Shape2D$DefaultImpls\n*L\n70#1:534,3\n135#1:561,2\n141#1:570,2\n141#1:590\n135#1:592\n75#1:537\n103#1:538\n110#1:543\n110#1:548\n118#1:549\n118#1:554\n126#1:555\n144#1:573,11\n144#1:584\n147#1:589\n103#1:539,4\n110#1:544,4\n118#1:550,4\n126#1:556,4\n144#1:585,4\n135#1:560\n135#1:593\n138#1:563,7\n138#1:591\n144#1:572\n*E\n"})
    public static final class DefaultImpls {
        public static boolean getClosed(@NotNull Shape2D $this) {
            return $this.toVectorPath().isLastCommandClose();
        }

        @NotNull
        public static Vector2D getCenter(@NotNull Shape2D $this) {
            return $this.getBounds().getCenter();
        }

        public static double getArea(@NotNull Shape2D $this) {
            VectorPath lazyVectorPath2 = $this.toVectorPath();
            return lazyVectorPath2.isLastCommandClose() ? lazyVectorPath2.getArea() : 0.0;
        }

        public static double getPerimeter(@NotNull Shape2D $this) {
            double sum = 0.0;
            List<Curves> $this$fastForEach$iv = _MathGeom_vector_VectorPathKt.getCurvesList($this.toVectorPath());
            boolean $i$f$fastForEach = false;
            int n$iv = 0;
            while (n$iv < $this$fastForEach$iv.size()) {
                Curves it = $this$fastForEach$iv.get(n$iv++);
                boolean bl = false;
                sum += it.getLength();
            }
            return sum;
        }

        /*
         * WARNING - void declaration
         */
        public static double distance(@NotNull Shape2D $this, @NotNull Vector2D p) {
            void this_$iv;
            Vector2D vector2D = p;
            Vector2D that$iv = $this.projectedPoint(p);
            boolean $i$f$minus = false;
            return new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY()).getLength();
        }

        public static boolean containsPoint(@NotNull Shape2D $this, @NotNull Vector2D p) {
            return $this.distance(p) <= 0.0;
        }

        @NotNull
        public static RectangleD getBounds(@NotNull Shape2D $this) {
            return $this.toVectorPath().getBounds();
        }

        @NotNull
        public static PointList intersectionsWith(@NotNull Shape2D $this, @NotNull Shape2D that) {
            return $this.intersectionsWith(Matrix.Companion.getNIL(), that, Matrix.Companion.getNIL());
        }

        public static boolean intersectsWith(@NotNull Shape2D $this, @NotNull Shape2D that) {
            return Companion.intersects($this, Matrix.Companion.getNIL(), that, Matrix.Companion.getNIL());
        }

        public static boolean intersectsWith(@NotNull Shape2D $this, @NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
            return Companion.intersects($this, ml, that, mr);
        }

        @Deprecated(message="Untested yet")
        public static boolean containsPoint(@NotNull Shape2D $this, @NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
            Matrix mat = mr.times(ml.inverted());
            Vector2D this_$iv = p;
            boolean $i$f$transformed = false;
            Matrix this_$iv$iv = mat;
            boolean $i$f$transform = false;
            return $this.containsPoint(this_$iv$iv.isNIL() ? this_$iv : new Vector2D(this_$iv$iv.transformX(this_$iv.getX(), this_$iv.getY()), this_$iv$iv.transformY(this_$iv.getX(), this_$iv.getY())));
        }

        @Deprecated(message="Untested yet")
        public static double distance(@NotNull Shape2D $this, @NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
            Vector2D this_$iv = p;
            boolean $i$f$transformed = false;
            Matrix this_$iv$iv = mr;
            boolean $i$f$transform = false;
            this_$iv = this_$iv$iv.isNIL() ? this_$iv : new Vector2D(this_$iv$iv.transformX(this_$iv.getX(), this_$iv.getY()), this_$iv$iv.transformY(this_$iv.getX(), this_$iv.getY()));
            Vector2D that$iv = $this.projectedPoint(ml, p, mr);
            boolean $i$f$minus = false;
            return new Vector2D(this_$iv.getX() - that$iv.getX(), this_$iv.getY() - that$iv.getY()).getLength();
        }

        @Deprecated(message="Untested yet")
        @NotNull
        public static Vector2D normalVectorAt(@NotNull Shape2D $this, @NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
            Matrix mat = mr.times(ml.inverted());
            Vector2D this_$iv = p;
            boolean $i$f$transformed = false;
            Matrix this_$iv$iv = mat;
            boolean $i$f$transform = false;
            this_$iv = $this.normalVectorAt(this_$iv$iv.isNIL() ? this_$iv : new Vector2D(this_$iv$iv.transformX(this_$iv.getX(), this_$iv.getY()), this_$iv$iv.transformY(this_$iv.getX(), this_$iv.getY())));
            boolean $i$f$deltaTransformed = false;
            return ml.deltaTransform(this_$iv);
        }

        @Deprecated(message="Untested yet")
        @NotNull
        public static Vector2D projectedPoint(@NotNull Shape2D $this, @NotNull Matrix ml, @NotNull Vector2D p, @NotNull Matrix mr) {
            Matrix mat = mr.times(ml.inverted());
            Vector2D this_$iv = p;
            boolean $i$f$transformed = false;
            Matrix this_$iv$iv = mat;
            boolean $i$f$transform = false;
            this_$iv = $this.projectedPoint(this_$iv$iv.isNIL() ? this_$iv : new Vector2D(this_$iv$iv.transformX(this_$iv.getX(), this_$iv.getY()), this_$iv$iv.transformY(this_$iv.getX(), this_$iv.getY())));
            $i$f$transformed = false;
            this_$iv$iv = ml;
            $i$f$transform = false;
            return this_$iv$iv.isNIL() ? this_$iv : new Vector2D(this_$iv$iv.transformX(this_$iv.getX(), this_$iv.getY()), this_$iv$iv.transformY(this_$iv.getX(), this_$iv.getY()));
        }

        @NotNull
        public static PointList intersectionsWith(@NotNull Shape2D $this, @NotNull Matrix ml, @NotNull Shape2D that, @NotNull Matrix mr) {
            Matrix mat = mr.times(ml.inverted());
            PointArrayList out = new PointArrayList(0, 1, null);
            VectorPath thatPath = that.toVectorPath();
            List<Curves> $this$fastForEachBezier$iv = _MathGeom_vector_VectorPathKt.getCurvesList(thatPath);
            boolean $i$f$fastForEachBezier = false;
            List<Curves> $this$fastForEach$iv$iv = $this$fastForEachBezier$iv;
            boolean $i$f$fastForEach = false;
            int n$iv$iv = 0;
            while (n$iv$iv < $this$fastForEach$iv$iv.size()) {
                Curves it$iv = $this$fastForEach$iv$iv.get(n$iv$iv++);
                boolean bl = false;
                List<Bezier> $this$fastForEach$iv$iv2 = it$iv.getBeziers();
                boolean $i$f$fastForEach2 = false;
                int n$iv$iv2 = 0;
                while (n$iv$iv2 < $this$fastForEach$iv$iv2.size()) {
                    int size$iv;
                    Bezier bezier1 = $this$fastForEach$iv$iv2.get(n$iv$iv2++);
                    boolean bl2 = false;
                    Bezier bezier12 = bezier1.transform(mat);
                    FastArrayList this_$iv = BVH2D.search$default(_MathGeom_vector_VectorPathKt.getBVHBeziers($this.toVectorPath()), bezier12.getBounds(), null, 2, null);
                    boolean $i$f$fastForEach3 = false;
                    Object[] array$iv = this_$iv.getArray();
                    int initialSize$iv = this_$iv.get_size();
                    int n$iv = 0;
                    while (n$iv < (size$iv = Math.min(initialSize$iv, this_$iv.get_size()))) {
                        Bezier bezier0;
                        BVH.Node it = (BVH.Node)array$iv[n$iv++];
                        boolean bl3 = false;
                        if ((Bezier)it.getValue() == null) continue;
                        boolean bl4 = false;
                        List $this$fastForEach$iv = Bezier.intersections$default(bezier0, bezier12, 0.0, 2, null);
                        boolean $i$f$fastForEach4 = false;
                        int n$iv2 = 0;
                        while (n$iv2 < $this$fastForEach$iv.size()) {
                            Pair it2 = (Pair)$this$fastForEach$iv.get(n$iv2++);
                            boolean bl5 = false;
                            Vector2D p1 = bezier0.get-kg1FUQ0(((Ratio)it2.getFirst()).unbox-impl());
                            Vector2D p2 = bezier12.get-kg1FUQ0(((Ratio)it2.getSecond()).unbox-impl());
                            Object this_$iv2 = Vector2D.Companion;
                            boolean $i$f$middle = false;
                            IsAlmostEquals<Vector2D> this_$iv$iv = p1;
                            boolean $i$f$plus = false;
                            this_$iv$iv = new Vector2D(((Vector2D)this_$iv$iv).getX() + p2.getX(), ((Vector2D)this_$iv$iv).getY() + p2.getY());
                            double scale$iv$iv = 0.5;
                            boolean $i$f$times = false;
                            this_$iv2 = new Vector2D(((Vector2D)this_$iv$iv).getX() * scale$iv$iv, ((Vector2D)this_$iv$iv).getY() * scale$iv$iv);
                            boolean $i$f$transformed = false;
                            this_$iv$iv = ml;
                            boolean $i$f$transform = false;
                            Object p = ((Matrix)this_$iv$iv).isNIL() ? this_$iv2 : new Vector2D(((Matrix)this_$iv$iv).transformX(((Vector2D)this_$iv2).getX(), ((Vector2D)this_$iv2).getY()), ((Matrix)this_$iv$iv).transformY(((Vector2D)this_$iv2).getX(), ((Vector2D)this_$iv2).getY()));
                            if (out.isNotEmpty()) {
                                Vector2D this_$iv3 = out.getLast();
                                boolean $i$f$minus = false;
                                Vector2D diff = new Vector2D(this_$iv3.getX() - ((Vector2D)p).getX(), this_$iv3.getY() - ((Vector2D)p).getY()).getAbsoluteValue();
                                if (diff.maxComponent() < 0.5) continue;
                            }
                            out.add((Vector2D)p);
                        }
                    }
                }
            }
            return out;
        }
    }
}

