/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.trapezoid;

import korlibs.math.ToIntegerConvertersKt;
import korlibs.math.annotations.KormaMutableApi;
import korlibs.math.geom.trapezoid.ISegmentInt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KormaMutableApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 82\u00020\u0001:\u00018B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\t\u0010%\u001a\u00020\u0004H\u00c6\u0003J\t\u0010&\u001a\u00020\u0004H\u00c6\u0003J\t\u0010'\u001a\u00020\u0004H\u00c6\u0003J\t\u0010(\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u0004J1\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010/\u001a\u00020*2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\u000e\u00102\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0000J\t\u00103\u001a\u00020\u0004H\u00d6\u0001J&\u00104\u001a\u0002052\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\b\u00106\u001a\u000207H\u0016J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0011\u0010\u001b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000b\"\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000bR\u0011\u0010#\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000b\u00a8\u00069"}, d2={"Lkorlibs/math/geom/trapezoid/MSegmentInt;", "Lkorlibs/math/geom/trapezoid/ISegmentInt;", "()V", "x0", "", "y0", "x1", "y1", "(IIII)V", "dx", "getDx", "()I", "dy", "getDy", "islope", "", "getIslope", "()D", "slope", "getSlope", "getX0", "setX0", "(I)V", "getX1", "setX1", "xMax", "getXMax", "xMin", "getXMin", "getY0", "setY0", "getY1", "setY1", "yMax", "getYMax", "yMin", "getYMin", "component1", "component2", "component3", "component4", "containsX", "", "x", "containsY", "y", "copy", "equals", "other", "", "getIntersectY", "hashCode", "setTo", "", "toString", "", "Companion", "korge-foundation"})
public final class MSegmentInt
implements ISegmentInt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int x0;
    private int y0;
    private int x1;
    private int y1;

    public MSegmentInt(int x0, int y0, int x1, int y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    @Override
    public int getX0() {
        return this.x0;
    }

    @Override
    public void setX0(int n) {
        this.x0 = n;
    }

    @Override
    public int getY0() {
        return this.y0;
    }

    @Override
    public void setY0(int n) {
        this.y0 = n;
    }

    @Override
    public int getX1() {
        return this.x1;
    }

    @Override
    public void setX1(int n) {
        this.x1 = n;
    }

    @Override
    public int getY1() {
        return this.y1;
    }

    @Override
    public void setY1(int n) {
        this.y1 = n;
    }

    public MSegmentInt() {
        this(0, 0, 0, 0);
    }

    public final void setTo(int x0, int y0, int x1, int y1) {
        this.setX0(x0);
        this.setY0(y0);
        this.setX1(x1);
        this.setY1(y1);
    }

    public final int getDx() {
        return this.getX1() - this.getX0();
    }

    public final int getDy() {
        return this.getY1() - this.getY0();
    }

    public final double getSlope() {
        return (double)this.getDy() / (double)this.getDx();
    }

    public final double getIslope() {
        return (double)this.getDx() / (double)this.getDy();
    }

    public final int getXMin() {
        return Math.min(this.getX0(), this.getX1());
    }

    public final int getYMin() {
        return Math.min(this.getY0(), this.getY1());
    }

    public final int getXMax() {
        return Math.max(this.getX0(), this.getX1());
    }

    public final int getYMax() {
        return Math.max(this.getY0(), this.getY1());
    }

    public final int x(int y) {
        return this.getX0() + ToIntegerConvertersKt.toIntRound((double)(y - this.getY0()) * this.getIslope());
    }

    public final int y(int x) {
        return this.getY0() + ToIntegerConvertersKt.toIntRound(this.getSlope() * (double)(x - this.getX0()));
    }

    public final boolean containsX(int x) {
        int n = this.getXMin();
        return x <= this.getXMax() ? n <= x : false;
    }

    public final boolean containsY(int y) {
        int n = this.getYMin();
        return y <= this.getYMax() ? n <= y : false;
    }

    public final int getIntersectY(@NotNull MSegmentInt other) {
        return Companion.getIntersectY(this, other);
    }

    @NotNull
    public String toString() {
        return "SegmentInt((" + this.getX0() + ", " + this.getY0() + "), (" + this.getX1() + ", " + this.getY1() + "))";
    }

    public final int component1() {
        return this.x0;
    }

    public final int component2() {
        return this.y0;
    }

    public final int component3() {
        return this.x1;
    }

    public final int component4() {
        return this.y1;
    }

    @NotNull
    public final MSegmentInt copy(int x0, int y0, int x1, int y1) {
        return new MSegmentInt(x0, y0, x1, y1);
    }

    public static /* synthetic */ MSegmentInt copy$default(MSegmentInt mSegmentInt, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = mSegmentInt.x0;
        }
        if ((n5 & 2) != 0) {
            n2 = mSegmentInt.y0;
        }
        if ((n5 & 4) != 0) {
            n3 = mSegmentInt.x1;
        }
        if ((n5 & 8) != 0) {
            n4 = mSegmentInt.y1;
        }
        return mSegmentInt.copy(n, n2, n3, n4);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.x0);
        result2 = result2 * 31 + Integer.hashCode(this.y0);
        result2 = result2 * 31 + Integer.hashCode(this.x1);
        result2 = result2 * 31 + Integer.hashCode(this.y1);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MSegmentInt)) {
            return false;
        }
        MSegmentInt mSegmentInt = (MSegmentInt)other;
        if (this.x0 != mSegmentInt.x0) {
            return false;
        }
        if (this.y0 != mSegmentInt.y0) {
            return false;
        }
        if (this.x1 != mSegmentInt.x1) {
            return false;
        }
        return this.y1 == mSegmentInt.y1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000628\b\u0004\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tH\u0086\bJ\u0081\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n26\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tH\u0086\bJ\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006JF\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n\u00a8\u0006\u0019"}, d2={"Lkorlibs/math/geom/trapezoid/MSegmentInt$Companion;", "", "()V", "getIntersectXY", "", "a", "Lkorlibs/math/geom/trapezoid/MSegmentInt;", "b", "out", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "", "Ax", "Ay", "Bx", "By", "Cx", "Cy", "Dx", "Dy", "getIntersectY", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\n_MathGeom.trapezoid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.trapezoid.kt\nkorlibs/math/geom/trapezoid/MSegmentInt$Companion\n*L\n1#1,824:1\n492#1,12:825\n507#1:837\n492#1,12:838\n492#1,12:850\n*S KotlinDebug\n*F\n+ 1 _MathGeom.trapezoid.kt\nkorlibs/math/geom/trapezoid/MSegmentInt$Companion\n*L\n507#1:825,12\n511#1:837\n511#1:838,12\n517#1:850,12\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getIntersectXY(int Ax, int Ay, int Bx, int By, int Cx, int Cy, int Dx, int Dy, @NotNull Function2<? super Integer, ? super Integer, Unit> out) {
            boolean $i$f$getIntersectXY = false;
            int a1 = By - Ay;
            int b1 = Ax - Bx;
            int c1 = a1 * Ax + b1 * Ay;
            int a2 = Dy - Cy;
            int b2 = Cx - Dx;
            int c2 = a2 * Cx + b2 * Cy;
            int determinant = a1 * b2 - a2 * b1;
            if (determinant == 0) {
                return false;
            }
            int x = (b2 * c1 - b1 * c2) / determinant;
            int y = (a1 * c2 - a2 * c1) / determinant;
            out.invoke((Integer)x, (Integer)y);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean getIntersectXY(@NotNull MSegmentInt a, @NotNull MSegmentInt b, @NotNull Function2<? super Integer, ? super Integer, Unit> out) {
            boolean bl;
            void Dx$iv;
            void Cx$iv;
            void Cy$iv;
            void Bx$iv;
            void Ax$iv;
            void Ay$iv;
            void By$iv;
            boolean $i$f$getIntersectXY = false;
            Companion companion = this;
            int n = a.getX0();
            int n2 = a.getY0();
            int n3 = a.getX1();
            int n4 = a.getY1();
            int n5 = b.getX0();
            int n6 = b.getY0();
            int n7 = b.getX1();
            int Dy$iv = b.getY1();
            boolean $i$f$getIntersectXY2 = false;
            void a1$iv = By$iv - Ay$iv;
            void b1$iv = Ax$iv - Bx$iv;
            void c1$iv = a1$iv * Ax$iv + b1$iv * Ay$iv;
            int a2$iv = Dy$iv - Cy$iv;
            void b2$iv = Cx$iv - Dx$iv;
            int c2$iv = a2$iv * Cx$iv + b2$iv * Cy$iv;
            void determinant$iv = a1$iv * b2$iv - a2$iv * b1$iv;
            if (determinant$iv == false) {
                bl = false;
            } else {
                void x$iv = (b2$iv * c1$iv - b1$iv * c2$iv) / determinant$iv;
                void y$iv = (a1$iv * c2$iv - a2$iv * c1$iv) / determinant$iv;
                out.invoke((Integer)((int)x$iv), (Integer)((int)y$iv));
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final int getIntersectY(@NotNull MSegmentInt a, @NotNull MSegmentInt b) {
            void Dx$iv$iv;
            void Cx$iv$iv;
            void Cy$iv$iv;
            void Bx$iv$iv;
            void Ax$iv$iv;
            void Ay$iv$iv;
            void By$iv$iv;
            int outY = 0;
            outY = Integer.MIN_VALUE;
            Companion this_$iv = this;
            boolean $i$f$getIntersectXY = false;
            Companion companion = this_$iv;
            int n = a.getX0();
            int n2 = a.getY0();
            int n3 = a.getX1();
            int n4 = a.getY1();
            int n5 = b.getX0();
            int n6 = b.getY0();
            int n7 = b.getX1();
            int Dy$iv$iv = b.getY1();
            boolean $i$f$getIntersectXY2 = false;
            void a1$iv$iv = By$iv$iv - Ay$iv$iv;
            void b1$iv$iv = Ax$iv$iv - Bx$iv$iv;
            void c1$iv$iv = a1$iv$iv * Ax$iv$iv + b1$iv$iv * Ay$iv$iv;
            int a2$iv$iv = Dy$iv$iv - Cy$iv$iv;
            void b2$iv$iv = Cx$iv$iv - Dx$iv$iv;
            int c2$iv$iv = a2$iv$iv * Cx$iv$iv + b2$iv$iv * Cy$iv$iv;
            void determinant$iv$iv = a1$iv$iv * b2$iv$iv - a2$iv$iv * b1$iv$iv;
            if (determinant$iv$iv != false) {
                void y;
                void y$iv$iv;
                void x$iv$iv = (b2$iv$iv * c1$iv$iv - b1$iv$iv * c2$iv$iv) / determinant$iv$iv;
                void var25_25 = y$iv$iv = (a1$iv$iv * c2$iv$iv - a2$iv$iv * c1$iv$iv) / determinant$iv$iv;
                void x = x$iv$iv;
                boolean bl = false;
                outY = y;
            }
            return outY;
        }

        /*
         * WARNING - void declaration
         */
        public final int getIntersectY(int Ax, int Ay, int Bx, int By, int Cx, int Cy, int Dx, int Dy) {
            int outY = 0;
            outY = Integer.MIN_VALUE;
            Companion this_$iv = this;
            boolean $i$f$getIntersectXY = false;
            int a1$iv = By - Ay;
            int b1$iv = Ax - Bx;
            int c1$iv = a1$iv * Ax + b1$iv * Ay;
            int a2$iv = Dy - Cy;
            int b2$iv = Cx - Dx;
            int c2$iv = a2$iv * Cx + b2$iv * Cy;
            int determinant$iv = a1$iv * b2$iv - a2$iv * b1$iv;
            if (determinant$iv != 0) {
                void y;
                int y$iv;
                int x$iv = (b2$iv * c1$iv - b1$iv * c2$iv) / determinant$iv;
                int n = y$iv = (a1$iv * c2$iv - a2$iv * c1$iv) / determinant$iv;
                int x = x$iv;
                boolean bl = false;
                outY = y;
            }
            return outY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

