/*
 * Decompiled with CFR 0.152.
 */
package korlibs.math.geom.vector;

import korlibs.math.MathKt;
import korlibs.math.annotations.KormaExperimental;
import korlibs.math.annotations.KormaMutableApi;
import korlibs.math.geom.Angle;
import korlibs.math.geom.AngleKt;
import korlibs.math.geom.MLine;
import korlibs.math.geom.Vector2D;
import korlibs.math.geom.Vector2I;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@KormaExperimental
@KormaMutableApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 B2\u00020\u0001:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\rJ\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0000J\u000e\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\rJ\u000e\u00109\u001a\u00020\r2\u0006\u00108\u001a\u00020\rJ\u000e\u0010:\u001a\u00020\r2\u0006\u00104\u001a\u00020\rJ.\u0010;\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u00101\u001a\u00020\rJ\u0016\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0000J\b\u0010?\u001a\u00020@H\u0016J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\u00020\n8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u001e\u0010\u0019\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u001e\u0010\u001d\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010R\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010R\u0011\u0010+\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0010R\u0011\u0010-\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0010R\u0011\u0010/\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0006R\u001e\u00101\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0010\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006C"}, d2={"Lkorlibs/math/geom/vector/MEdge;", "", "()V", "absCos", "", "getAbsCos", "()D", "absSin", "getAbsSin", "angle", "Lkorlibs/math/geom/Angle;", "getAngle-igmgxjg", "<set-?>", "", "ax", "getAx", "()I", "ay", "getAy", "bx", "getBx", "by", "getBy", "cos", "getCos", "dx", "getDx", "dy", "getDy", "h", "getH", "", "isCoplanarX", "()Z", "isCoplanarY", "length", "", "getLength", "()F", "maxX", "getMaxX", "maxY", "getMaxY", "minX", "getMinX", "minY", "getMinY", "sin", "getSin", "wind", "getWind", "containsY", "y", "copyFrom", "other", "getX", "n", "getY", "intersectX", "setTo", "setToHalf", "a", "b", "toString", "", "scale", "Companion", "korge-foundation"})
@SourceDebugExtension(value={"SMAP\n_MathGeom.vector.PolygonScanline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.vector.PolygonScanline.kt\nkorlibs/math/geom/vector/MEdge\n+ 2 Angle.kt\nkorlibs/math/geom/Angle$Companion\n*L\n1#1,591:1\n197#2:592\n195#2:593\n*S KotlinDebug\n*F\n+ 1 _MathGeom.vector.PolygonScanline.kt\nkorlibs/math/geom/vector/MEdge\n*L\n457#1:592\n457#1:593\n*E\n"})
public final class MEdge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int ax;
    private int ay;
    private int bx;
    private int by;
    private int wind;
    private int dy;
    private int dx;
    private boolean isCoplanarX;
    private boolean isCoplanarY;
    private int h;

    public final int getX(int n) {
        return n == 0 ? this.ax : this.bx;
    }

    public final int getY(int n) {
        return n == 0 ? this.ay : this.by;
    }

    public final int getAx() {
        return this.ax;
    }

    public final int getAy() {
        return this.ay;
    }

    public final int getBx() {
        return this.bx;
    }

    public final int getBy() {
        return this.by;
    }

    public final int getWind() {
        return this.wind;
    }

    public final int getDy() {
        return this.dy;
    }

    public final int getDx() {
        return this.dx;
    }

    public final boolean isCoplanarX() {
        return this.isCoplanarX;
    }

    public final boolean isCoplanarY() {
        return this.isCoplanarY;
    }

    public final int getH() {
        return this.h;
    }

    public final float getLength() {
        return (float)Math.hypot(this.dx, this.dy);
    }

    @NotNull
    public final MEdge copyFrom(@NotNull MEdge other) {
        return this.setTo(other.ax, other.ay, other.bx, other.by, other.wind);
    }

    @NotNull
    public final MEdge setTo(int ax, int ay, int bx, int by, int wind) {
        MEdge mEdge;
        MEdge $this$setTo_u24lambda_u240 = mEdge = this;
        boolean bl = false;
        $this$setTo_u24lambda_u240.ax = ax;
        $this$setTo_u24lambda_u240.ay = ay;
        $this$setTo_u24lambda_u240.bx = bx;
        $this$setTo_u24lambda_u240.by = by;
        $this$setTo_u24lambda_u240.dx = bx - ax;
        $this$setTo_u24lambda_u240.dy = by - ay;
        $this$setTo_u24lambda_u240.isCoplanarX = ay == by;
        $this$setTo_u24lambda_u240.isCoplanarY = ax == bx;
        $this$setTo_u24lambda_u240.wind = wind;
        $this$setTo_u24lambda_u240.h = $this$setTo_u24lambda_u240.isCoplanarY ? 0 : ay - ax * $this$setTo_u24lambda_u240.dy / $this$setTo_u24lambda_u240.dx;
        return mEdge;
    }

    @NotNull
    public final MEdge setToHalf(@NotNull MEdge a, @NotNull MEdge b) {
        MEdge mEdge;
        MEdge $this$setToHalf_u24lambda_u241 = mEdge = this;
        boolean bl = false;
        int minY = Math.min(a.getMinY(), b.getMinY());
        int maxY = Math.min(a.getMaxY(), b.getMaxY());
        int minX = (a.intersectX(minY) + b.intersectX(minY)) / 2;
        int maxX = (a.intersectX(maxY) + b.intersectX(maxY)) / 2;
        $this$setToHalf_u24lambda_u241.setTo(minX, minY, maxX, maxY, 1);
        return mEdge;
    }

    public final int getMinX() {
        return Math.min(this.ax, this.bx);
    }

    public final int getMaxX() {
        return Math.max(this.ax, this.bx);
    }

    public final int getMinY() {
        return Math.min(this.ay, this.by);
    }

    public final int getMaxY() {
        return Math.max(this.ay, this.by);
    }

    public final boolean containsY(int y) {
        return y >= this.ay && y < this.by;
    }

    public final int intersectX(int y) {
        return this.isCoplanarY || this.dy == 0 ? this.ax : (y - this.h) * this.dx / this.dy;
    }

    /*
     * WARNING - void declaration
     */
    public final double getAngle-igmgxjg() {
        void x1$iv$iv;
        void y0$iv$iv;
        void x0$iv$iv;
        void x1$iv;
        void y0$iv;
        void x0$iv;
        void $this$iv;
        Angle.Companion companion = Angle.Companion;
        int n = this.ax;
        int n2 = this.ay;
        int n3 = this.bx;
        int y1$iv = this.by;
        Vector2D up$iv = Vector2D.Companion.getUP();
        boolean bl = false;
        void var8_8 = $this$iv;
        double d = (double)x0$iv;
        double d2 = (double)y0$iv;
        double d3 = (double)x1$iv;
        double y1$iv$iv = y1$iv;
        $i$f$between-vuGuAwA = false;
        return AngleKt.Angle_between((double)x0$iv$iv, (double)y0$iv$iv, (double)x1$iv$iv, y1$iv$iv, up$iv);
    }

    public final double getCos() {
        return Angle.getCosine-impl(this.getAngle-igmgxjg());
    }

    public final double getAbsCos() {
        return Math.abs(this.getCos());
    }

    public final double getSin() {
        return Angle.getSine-impl(this.getAngle-igmgxjg());
    }

    public final double getAbsSin() {
        return Math.abs(this.getSin());
    }

    @NotNull
    public String toString() {
        return "Edge([" + this.ax + "," + this.ay + "]-[" + this.bx + "," + this.by + "])";
    }

    @NotNull
    public final String toString(double scale) {
        return "Edge([" + (int)((double)this.ax * scale) + "," + (int)((double)this.ay * scale) + "]-[" + (int)((double)this.bx * scale) + "," + (int)((double)this.by * scale) + "])";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\bJ#\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u001e\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006JN\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J+\u0010\u001e\u001a\u00020\u00062\n\u0010\u0005\u001a\u00060\u0004j\u0002`\u001f2\n\u0010\u0007\u001a\u00060\u0004j\u0002`\u001f2\b\b\u0002\u0010 \u001a\u00020\u000fH\u0086\u0002J3\u0010\u001e\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u000fH\u0086\u0002\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006%"}, d2={"Lkorlibs/math/geom/vector/MEdge$Companion;", "", "()V", "_getIntersectXY", "Lkorlibs/math/geom/Vector2I;", "a", "Lkorlibs/math/geom/vector/MEdge;", "b", "angleBetween", "Lkorlibs/math/geom/Angle;", "angleBetween-YNSfjqc", "(Lkorlibs/math/geom/vector/MEdge;Lkorlibs/math/geom/vector/MEdge;)D", "areParallel", "", "getIntersectX", "", "getIntersectXY", "Lkorlibs/math/geom/Vector2D;", "Lkorlibs/math/geom/Point;", "Ax", "", "Ay", "Bx", "By", "Cx", "Cy", "Dx", "Dy", "getIntersectXYInt", "getIntersectY", "invoke", "Lkorlibs/math/geom/PointInt;", "wind", "ax", "ay", "bx", "by", "korge-foundation"})
    @SourceDebugExtension(value={"SMAP\n_MathGeom.vector.PolygonScanline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _MathGeom.vector.PolygonScanline.kt\nkorlibs/math/geom/vector/MEdge$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,591:1\n377#1,9:592\n377#1,9:603\n1#2:601\n1#2:602\n1#2:612\n1#2:613\n*S KotlinDebug\n*F\n+ 1 _MathGeom.vector.PolygonScanline.kt\nkorlibs/math/geom/vector/MEdge$Companion\n*L\n368#1:592,9\n369#1:603,9\n368#1:601\n369#1:612\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MEdge invoke(int ax, int ay, int bx, int by, int wind) {
            return new MEdge().setTo(ax, ay, bx, by, wind);
        }

        public static /* synthetic */ MEdge invoke$default(Companion companion, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 0x10) != 0) {
                n5 = 0;
            }
            return companion.invoke(n, n2, n3, n4, n5);
        }

        @NotNull
        public final MEdge invoke(@NotNull Vector2I a, @NotNull Vector2I b, int wind) {
            return this.invoke(a.getX(), a.getY(), b.getX(), b.getY(), wind);
        }

        public static /* synthetic */ MEdge invoke$default(Companion companion, Vector2I vector2I, Vector2I vector2I2, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.invoke(vector2I, vector2I2, n);
        }

        public final int getIntersectY(@NotNull MEdge a, @NotNull MEdge b) {
            Vector2I vector2I = this.getIntersectXYInt(a, b);
            return vector2I != null ? vector2I.getY() : Integer.MIN_VALUE;
        }

        public final int getIntersectX(@NotNull MEdge a, @NotNull MEdge b) {
            Vector2I vector2I = this.getIntersectXYInt(a, b);
            return vector2I != null ? vector2I.getX() : Integer.MIN_VALUE;
        }

        public final boolean areParallel(@NotNull MEdge a, @NotNull MEdge b) {
            return (a.getBy() - a.getAy()) * (b.getAx() - b.getBx()) - (b.getBy() - b.getAy()) * (a.getAx() - a.getBx()) == 0;
        }

        @Nullable
        public final Vector2D getIntersectXY(@NotNull MEdge a, @NotNull MEdge b) {
            Vector2D vector2D;
            Vector2I vector2I;
            Companion this_$iv = this;
            boolean $i$f$_getIntersectXY = false;
            double Ax$iv = a.getAx();
            double Ay$iv = a.getAy();
            double Bx$iv = a.getBx();
            double By$iv = a.getBy();
            double Cx$iv = b.getAx();
            double Cy$iv = b.getAy();
            double Dx$iv = b.getBx();
            double Dy$iv = b.getBy();
            Vector2D vector2D2 = this_$iv.getIntersectXY(Ax$iv, Ay$iv, Bx$iv, By$iv, Cx$iv, Cy$iv, Dx$iv, Dy$iv);
            if (vector2D2 != null) {
                Vector2D it$iv = vector2D2;
                boolean bl = false;
                vector2I = new Vector2I((int)MathKt.floorCeil(it$iv.getX()), (int)MathKt.floorCeil(it$iv.getY()));
            } else {
                vector2I = null;
            }
            if (vector2I != null) {
                Vector2I it = vector2I;
                boolean bl = false;
                vector2D = new Vector2D(it.getX(), it.getY());
            } else {
                vector2D = null;
            }
            return vector2D;
        }

        @Nullable
        public final Vector2I getIntersectXYInt(@NotNull MEdge a, @NotNull MEdge b) {
            Vector2I vector2I;
            Companion this_$iv = this;
            boolean $i$f$_getIntersectXY = false;
            double Ax$iv = a.getAx();
            double Ay$iv = a.getAy();
            double Bx$iv = a.getBx();
            double By$iv = a.getBy();
            double Cx$iv = b.getAx();
            double Cy$iv = b.getAy();
            double Dx$iv = b.getBx();
            double Dy$iv = b.getBy();
            Vector2D vector2D = this_$iv.getIntersectXY(Ax$iv, Ay$iv, Bx$iv, By$iv, Cx$iv, Cy$iv, Dx$iv, Dy$iv);
            if (vector2D != null) {
                Vector2D it$iv = vector2D;
                boolean bl = false;
                vector2I = new Vector2I((int)MathKt.floorCeil(it$iv.getX()), (int)MathKt.floorCeil(it$iv.getY()));
            } else {
                vector2I = null;
            }
            return vector2I;
        }

        public final double angleBetween-YNSfjqc(@NotNull MEdge a, @NotNull MEdge b) {
            return Angle.minus-9E-s4b0(b.getAngle-igmgxjg(), a.getAngle-igmgxjg());
        }

        @Nullable
        public final Vector2I _getIntersectXY(@NotNull MEdge a, @NotNull MEdge b) {
            Vector2I vector2I;
            boolean $i$f$_getIntersectXY = false;
            double Ax = a.getAx();
            double Ay = a.getAy();
            double Bx = a.getBx();
            double By = a.getBy();
            double Cx = b.getAx();
            double Cy = b.getAy();
            double Dx = b.getBx();
            double Dy = b.getBy();
            Vector2D vector2D = this.getIntersectXY(Ax, Ay, Bx, By, Cx, Cy, Dx, Dy);
            if (vector2D != null) {
                Vector2D it = vector2D;
                boolean bl = false;
                vector2I = new Vector2I((int)MathKt.floorCeil(it.getX()), (int)MathKt.floorCeil(it.getY()));
            } else {
                vector2I = null;
            }
            return vector2I;
        }

        @Nullable
        public final Vector2D getIntersectXY(double Ax, double Ay, double Bx, double By, double Cx, double Cy, double Dx, double Dy) {
            return MLine.Companion.getIntersectXY(Ax, Ay, Bx, By, Cx, Cy, Dx, Dy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

