/*
 * Decompiled with CFR 0.152.
 */
package korlibs.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import korlibs.memory.BufferKt;
import korlibs.memory.Buffer_jvmKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 G2\u00020\u0001:\u0001GB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010!\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010,\u001a\u00020\u0003H\u0016J\u0016\u0010-\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020#J\u0016\u00100\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020#J\u0016\u00101\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u0016\u00102\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u0016\u00103\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020(J\u0016\u00104\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020(J\u0016\u00105\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020+J\u0016\u00106\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u001dJ\u0016\u00107\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u001dJ\u0016\u00108\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020 J\u0016\u00109\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010/\u001a\u00020 J\u0016\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u0003J\u001a\u0010=\u001a\u00020\f2\b\b\u0002\u0010>\u001a\u00020\u00032\b\b\u0002\u0010?\u001a\u00020\u0003J\b\u0010@\u001a\u00020AH\u0016J.\u0010B\u001a\u00020.2\u0006\u0010C\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010D\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u0005R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0019\u0010\u0013\u001a\n \u0011*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006H"}, d2={"Lkorlibs/memory/Buffer;", "", "size", "", "direct", "", "(IZ)V", "array", "", "offset", "([BII)V", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "bufferBE", "kotlin.jvm.PlatformType", "getBufferBE", "bufferLE", "getBufferLE", "byteOffset", "getByteOffset", "()I", "sizeInBytes", "getSizeInBytes", "equals", "other", "getF32BE", "", "getF32LE", "getF64BE", "", "getF64LE", "getS16BE", "", "getS16LE", "getS32BE", "getS32LE", "getS64BE", "", "getS64LE", "getS8", "", "hashCode", "set16BE", "", "value", "set16LE", "set32BE", "set32LE", "set64BE", "set64LE", "set8", "setF32BE", "setF32LE", "setF64BE", "setF64LE", "sliceInternal", "start", "end", "slicedBuffer", "roffset", "rsize", "toString", "", "transferBytes", "bufferOffset", "arrayOffset", "len", "toArray", "Companion", "korlibs-memory"})
@SourceDebugExtension(value={"SMAP\nBuffer.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.jvm.kt\nkorlibs/memory/Buffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class Buffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    private final ByteBuffer bufferLE;
    private final ByteBuffer bufferBE;
    private final int byteOffset;
    private final int sizeInBytes;

    public Buffer(@NotNull ByteBuffer buffer) {
        this.buffer = buffer;
        this.bufferLE = this.buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.bufferBE = this.buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.byteOffset = this.buffer.position();
        this.sizeInBytes = this.buffer.limit() - this.buffer.position();
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final ByteBuffer getBufferLE() {
        return this.bufferLE;
    }

    public final ByteBuffer getBufferBE() {
        return this.bufferBE;
    }

    public final int getByteOffset() {
        return this.byteOffset;
    }

    public final int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Buffer(int size2, boolean direct) {
        ByteBuffer byteBuffer = (direct ? ByteBuffer.allocateDirect(BufferKt.checkNBufferSize(size2)) : ByteBuffer.wrap(new byte[BufferKt.checkNBufferSize(size2)])).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "order(...)");
        this(byteBuffer);
    }

    public /* synthetic */ Buffer(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    /*
     * WARNING - void declaration
     */
    public Buffer(@NotNull byte[] array, int offset2, int size2) {
        void it;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.wrap(BufferKt.checkNBufferWrap(array, offset2, size2), offset2, size2).order(ByteOrder.nativeOrder());
        Buffer buffer = this;
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        Buffer_jvmKt.positionSafe((java.nio.Buffer)it, offset2);
        Buffer_jvmKt.limitSafe((java.nio.Buffer)it, offset2 + size2);
        ByteBuffer byteBuffer3 = byteBuffer;
        Intrinsics.checkNotNullExpressionValue(byteBuffer3, "also(...)");
        buffer(byteBuffer3);
    }

    public /* synthetic */ Buffer(byte[] byArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        this(byArray, n, n2);
    }

    @NotNull
    public final Buffer sliceInternal(int start2, int end2) {
        return new Buffer(this.slicedBuffer(start2, end2 - start2));
    }

    public final void transferBytes(int bufferOffset, @NotNull byte[] array, int arrayOffset, int len, boolean toArray) {
        ByteBuffer temp = Buffer.slicedBuffer$default(this, bufferOffset, 0, 2, null);
        if (toArray) {
            temp.get(array, arrayOffset, len);
        } else {
            temp.put(array, arrayOffset, len);
        }
    }

    @NotNull
    public final ByteBuffer slicedBuffer(int roffset, int rsize) {
        ByteBuffer byteBuffer;
        int pos = this.byteOffset + roffset;
        ByteBuffer it = byteBuffer = this.buffer.duplicate();
        boolean bl = false;
        it.order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNull(it);
        Buffer_jvmKt.positionSafe(it, pos);
        Buffer_jvmKt.limitSafe(it, pos + rsize);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "also(...)");
        return byteBuffer2;
    }

    public static /* synthetic */ ByteBuffer slicedBuffer$default(Buffer buffer, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = BufferKt.getSize(buffer) - n;
        }
        return buffer.slicedBuffer(n, n2);
    }

    public final byte getS8(int byteOffset) {
        return this.bufferLE.get(this.byteOffset + byteOffset);
    }

    public final short getS16LE(int byteOffset) {
        return this.bufferLE.getShort(this.byteOffset + byteOffset);
    }

    public final int getS32LE(int byteOffset) {
        return this.bufferLE.getInt(this.byteOffset + byteOffset);
    }

    public final long getS64LE(int byteOffset) {
        return this.bufferLE.getLong(this.byteOffset + byteOffset);
    }

    public final float getF32LE(int byteOffset) {
        return this.bufferLE.getFloat(this.byteOffset + byteOffset);
    }

    public final double getF64LE(int byteOffset) {
        return this.bufferLE.getDouble(this.byteOffset + byteOffset);
    }

    public final short getS16BE(int byteOffset) {
        return this.bufferBE.getShort(this.byteOffset + byteOffset);
    }

    public final int getS32BE(int byteOffset) {
        return this.bufferBE.getInt(this.byteOffset + byteOffset);
    }

    public final long getS64BE(int byteOffset) {
        return this.bufferBE.getLong(this.byteOffset + byteOffset);
    }

    public final float getF32BE(int byteOffset) {
        return this.bufferBE.getFloat(this.byteOffset + byteOffset);
    }

    public final double getF64BE(int byteOffset) {
        return this.bufferBE.getDouble(this.byteOffset + byteOffset);
    }

    public final void set8(int byteOffset, byte value) {
        this.bufferLE.put(this.byteOffset + byteOffset, value);
    }

    public final void set16LE(int byteOffset, short value) {
        this.bufferLE.putShort(this.byteOffset + byteOffset, value);
    }

    public final void set32LE(int byteOffset, int value) {
        this.bufferLE.putInt(this.byteOffset + byteOffset, value);
    }

    public final void set64LE(int byteOffset, long value) {
        this.bufferLE.putLong(this.byteOffset + byteOffset, value);
    }

    public final void setF32LE(int byteOffset, float value) {
        this.bufferLE.putFloat(this.byteOffset + byteOffset, value);
    }

    public final void setF64LE(int byteOffset, double value) {
        this.bufferLE.putDouble(this.byteOffset + byteOffset, value);
    }

    public final void set16BE(int byteOffset, short value) {
        this.bufferBE.putShort(this.byteOffset + byteOffset, value);
    }

    public final void set32BE(int byteOffset, int value) {
        this.bufferBE.putInt(this.byteOffset + byteOffset, value);
    }

    public final void set64BE(int byteOffset, long value) {
        this.bufferBE.putLong(this.byteOffset + byteOffset, value);
    }

    public final void setF32BE(int byteOffset, float value) {
        this.bufferBE.putFloat(this.byteOffset + byteOffset, value);
    }

    public final void setF64BE(int byteOffset, double value) {
        this.bufferBE.putDouble(this.byteOffset + byteOffset, value);
    }

    public int hashCode() {
        return BufferKt.hashCodeCommon(Companion, this);
    }

    public boolean equals(@Nullable Object other) {
        return BufferKt.equalsCommon(Companion, this, other);
    }

    @NotNull
    public String toString() {
        return BufferKt.NBuffer_toString(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ.\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lkorlibs/memory/Buffer$Companion;", "", "()V", "copy", "", "src", "Lkorlibs/memory/Buffer;", "srcPosBytes", "", "dst", "dstPosBytes", "sizeInBytes", "equals", "", "korlibs-memory"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean equals(@NotNull Buffer src, int srcPosBytes, @NotNull Buffer dst, int dstPosBytes, int sizeInBytes) {
            return Intrinsics.areEqual(src.slicedBuffer(srcPosBytes, sizeInBytes), dst.slicedBuffer(dstPosBytes, sizeInBytes));
        }

        public final void copy(@NotNull Buffer src, int srcPosBytes, @NotNull Buffer dst, int dstPosBytes, int sizeInBytes) {
            ByteBuffer srcBuf = src.getBuffer();
            ByteBuffer dstBuf = dst.getBuffer();
            int srcPos = srcPosBytes;
            int dstPos = dstPosBytes;
            int size2 = sizeInBytes;
            if (!srcBuf.isDirect() && !dstBuf.isDirect()) {
                System.arraycopy(srcBuf.array(), srcBuf.position() + srcPos, dstBuf.array(), dstBuf.position() + dstPos, size2);
                return;
            }
            dst.slicedBuffer(dstPosBytes, sizeInBytes).put(src.slicedBuffer(srcPosBytes, sizeInBytes));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

