/*
 * Decompiled with CFR 0.152.
 */
package korlibs.memory;

import java.util.Arrays;
import korlibs.memory.ArraysKt;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\bJ\u0012\u0010\u0016\u001a\u00020\u00192\n\u0010\u0017\u001a\u00020\u0006\"\u00020\u0018J\"\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\u0012\u0010\u0016\u001a\u00020\u00002\n\u0010\u0017\u001a\u00020\u001d\"\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0019J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020&2\u0006\u0010'\u001a\u00020\tJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020&J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020&J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020+2\u0006\u0010'\u001a\u00020\tJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020+J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020+J*\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0006\u0010$\u001a\u00020\u00032\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0082\b\u00a2\u0006\u0002\u00102J\u0016\u00103\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\tJ\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u0016\u00106\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\tJ\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u0016\u00109\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\tJ\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010=\u001a\u00020\u0006R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0004\u00a8\u0006>"}, d2={"Lkorlibs/memory/ByteArrayBuilder;", "", "initialCapacity", "", "(I)V", "data", "", "size", "allowGrow", "", "([BIZ)V", "_size", "getAllowGrow", "()Z", "getData", "()[B", "setData", "([B)V", "value", "getSize", "()I", "setSize", "append", "v", "", "", "array", "offset", "len", "", "appendByte", "appendFast", "clear", "ensure", "expected", "ensureCount", "count", "f32", "", "little", "f32BE", "f32LE", "f64", "", "f64BE", "f64LE", "prepare", "T", "callback", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "s16", "s16BE", "s16LE", "s24", "s24BE", "s24LE", "s32", "s32BE", "s32LE", "s8", "toByteArray", "korlibs-memory"})
@SourceDebugExtension(value={"SMAP\nByteArrayBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteArrayBuilder.kt\nkorlibs/memory/ByteArrayBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n42#1,2:147\n42#1,2:150\n42#1,2:153\n42#1,2:156\n42#1,2:159\n42#1,2:162\n42#1,2:165\n42#1,2:168\n42#1,2:171\n42#1,2:174\n42#1,2:177\n42#1,2:180\n42#1,2:183\n42#1,2:186\n42#1,2:189\n42#1,2:192\n42#1,2:195\n1#2:146\n1#2:149\n1#2:152\n1#2:155\n1#2:158\n1#2:161\n1#2:164\n1#2:167\n1#2:170\n1#2:173\n1#2:176\n1#2:179\n1#2:182\n1#2:185\n1#2:188\n1#2:191\n1#2:194\n1#2:197\n*S KotlinDebug\n*F\n+ 1 ByteArrayBuilder.kt\nkorlibs/memory/ByteArrayBuilder\n*L\n65#1:147,2\n70#1:150,2\n74#1:153,2\n75#1:156,2\n76#1:159,2\n78#1:162,2\n79#1:165,2\n80#1:168,2\n82#1:171,2\n83#1:174,2\n84#1:177,2\n85#1:180,2\n86#1:183,2\n87#1:186,2\n89#1:189,2\n90#1:192,2\n91#1:195,2\n65#1:149\n70#1:152\n74#1:155\n75#1:158\n76#1:161\n78#1:164\n79#1:167\n80#1:170\n82#1:173\n83#1:176\n84#1:179\n85#1:182\n86#1:185\n87#1:188\n89#1:191\n90#1:194\n91#1:197\n*E\n"})
public final class ByteArrayBuilder {
    @NotNull
    private byte[] data;
    private final boolean allowGrow;
    private int _size;

    public ByteArrayBuilder(@NotNull byte[] data2, int size2, boolean allowGrow) {
        this.data = data2;
        this.allowGrow = allowGrow;
        this._size = size2;
    }

    public /* synthetic */ ByteArrayBuilder(byte[] byArray, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = byArray.length;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(byArray, n, bl);
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public final void setData(@NotNull byte[] byArray) {
        this.data = byArray;
    }

    public final boolean getAllowGrow() {
        return this.allowGrow;
    }

    public ByteArrayBuilder(int initialCapacity) {
        this(new byte[initialCapacity], 0, false, 4, null);
    }

    public /* synthetic */ ByteArrayBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        this(n);
    }

    public final int getSize() {
        return this._size;
    }

    public final void setSize(int value) {
        int oldPosition = this._size;
        int newPosition = value;
        this.ensure(newPosition);
        this._size = newPosition;
        if (newPosition > oldPosition) {
            ArraysKt.arrayfill(this.data, (byte)0, oldPosition, newPosition);
        }
    }

    private final void ensure(int expected) {
        if (this.data.length < expected) {
            int realNewSize;
            if (!this.allowGrow) {
                throw new RuntimeException("ByteArrayBuffer configured to not grow!");
            }
            int newSize = (this.data.length + 7) * 5;
            int n = realNewSize = newSize < 0 ? 0x3FFFFFFF : newSize;
            if (newSize < 0 && expected > realNewSize) {
                throw new IllegalStateException("ByteArrayBuffer can't grow that much".toString());
            }
            byte[] byArray = Arrays.copyOf(this.data, Math.max(expected, realNewSize));
            Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
            this.data = byArray;
        }
    }

    private final void ensureCount(int count2) {
        this.ensure(this._size + count2);
    }

    private final <T> T prepare(int count2, Function0<? extends T> callback) {
        T t;
        boolean $i$f$prepare = false;
        this.ensureCount(count2);
        T it = t = callback.invoke();
        boolean bl = false;
        this._size += count2;
        return t;
    }

    public final void append(@NotNull byte[] array, int offset2, int len) {
        this.ensureCount(len);
        ArraysKt.arraycopy(array, offset2, this.data, this._size, len);
        this._size += len;
    }

    public static /* synthetic */ void append$default(ByteArrayBuilder byteArrayBuilder, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        byteArrayBuilder.append(byArray, n, n2);
    }

    public final void appendFast(byte v) {
        this.ensure(this._size + 1);
        int n = this._size;
        this._size = n + 1;
        this.data[n] = v;
    }

    @NotNull
    public final ByteArrayBuilder append(byte v) {
        boolean $i$f$append = false;
        this.appendFast(v);
        return this;
    }

    public final void append(byte ... v) {
        ByteArrayBuilder.append$default(this, v, 0, 0, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder append(int ... v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$append_u24lambda_u242 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$append_u24lambda_u242;
        int count$iv = v.length;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        int n = v.length;
        for (int n2 = 0; n2 < n; ++n2) {
            $this$append_u24lambda_u242.data[$this$append_u24lambda_u242._size + n2] = (byte)v[n2];
        }
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder appendByte(int v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$appendByte_u24lambda_u244 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$appendByte_u24lambda_u244;
        int count$iv = 1;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        $this$appendByte_u24lambda_u244.data[$this$appendByte_u24lambda_u244._size] = (byte)v;
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    @NotNull
    public final ByteArrayBuilder s8(int v) {
        return this.appendByte(v);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s16(int v, boolean little) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s16_u24lambda_u246 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s16_u24lambda_u246;
        int count$iv = 2;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set16($this$s16_u24lambda_u246.data, $this$s16_u24lambda_u246._size, v, little);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s16LE(int v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s16LE_u24lambda_u248 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s16LE_u24lambda_u248;
        int count$iv = 2;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set16LE($this$s16LE_u24lambda_u248.data, $this$s16LE_u24lambda_u248._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s16BE(int v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s16BE_u24lambda_u2410 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s16BE_u24lambda_u2410;
        int count$iv = 2;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set16BE($this$s16BE_u24lambda_u2410.data, $this$s16BE_u24lambda_u2410._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s24(int v, boolean little) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s24_u24lambda_u2412 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s24_u24lambda_u2412;
        int count$iv = 3;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set24($this$s24_u24lambda_u2412.data, $this$s24_u24lambda_u2412._size, v, little);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s24LE(int v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s24LE_u24lambda_u2414 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s24LE_u24lambda_u2414;
        int count$iv = 3;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set24LE($this$s24LE_u24lambda_u2414.data, $this$s24LE_u24lambda_u2414._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s24BE(int v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s24BE_u24lambda_u2416 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s24BE_u24lambda_u2416;
        int count$iv = 3;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set24BE($this$s24BE_u24lambda_u2416.data, $this$s24BE_u24lambda_u2416._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s32(int v, boolean little) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s32_u24lambda_u2418 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s32_u24lambda_u2418;
        int count$iv = 4;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set32($this$s32_u24lambda_u2418.data, $this$s32_u24lambda_u2418._size, v, little);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s32LE(int v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s32LE_u24lambda_u2420 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s32LE_u24lambda_u2420;
        int count$iv = 4;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set32LE($this$s32LE_u24lambda_u2420.data, $this$s32LE_u24lambda_u2420._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder s32BE(int v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$s32BE_u24lambda_u2422 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$s32BE_u24lambda_u2422;
        int count$iv = 4;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.set32BE($this$s32BE_u24lambda_u2422.data, $this$s32BE_u24lambda_u2422._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder f32(float v, boolean little) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$f32_u24lambda_u2424 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$f32_u24lambda_u2424;
        int count$iv = 4;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.setF32($this$f32_u24lambda_u2424.data, $this$f32_u24lambda_u2424._size, v, little);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder f32LE(float v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$f32LE_u24lambda_u2426 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$f32LE_u24lambda_u2426;
        int count$iv = 4;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.setF32LE($this$f32LE_u24lambda_u2426.data, $this$f32LE_u24lambda_u2426._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder f32BE(float v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$f32BE_u24lambda_u2428 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$f32BE_u24lambda_u2428;
        int count$iv = 4;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.setF32BE($this$f32BE_u24lambda_u2428.data, $this$f32BE_u24lambda_u2428._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder f64(double v, boolean little) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$f64_u24lambda_u2430 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$f64_u24lambda_u2430;
        int count$iv = 8;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.setF64($this$f64_u24lambda_u2430.data, $this$f64_u24lambda_u2430._size, v, little);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder f64LE(double v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$f64LE_u24lambda_u2432 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$f64LE_u24lambda_u2432;
        int count$iv = 8;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.setF64LE($this$f64LE_u24lambda_u2432.data, $this$f64LE_u24lambda_u2432._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayBuilder f64BE(double v) {
        Unit unit;
        void this_$iv;
        ByteArrayBuilder byteArrayBuilder;
        ByteArrayBuilder $this$f64BE_u24lambda_u2434 = byteArrayBuilder = this;
        boolean bl = false;
        ByteArrayBuilder byteArrayBuilder2 = $this$f64BE_u24lambda_u2434;
        int count$iv = 8;
        boolean $i$f$prepare = false;
        super.ensureCount(count$iv);
        boolean bl2 = false;
        ByteArrayGetSetKt.setF64BE($this$f64BE_u24lambda_u2434.data, $this$f64BE_u24lambda_u2434._size, v);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl3 = false;
        this_$iv._size += count$iv;
        return byteArrayBuilder;
    }

    public final void clear() {
        this._size = 0;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.data, this._size);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        return byArray;
    }
}

