/*
 * Decompiled with CFR 0.152.
 */
package korlibs.render.awt;

import korlibs.event.gamepad.LinuxJoyEventAdapter;
import korlibs.event.gamepad.MacosGamepadEventAdapter;
import korlibs.event.gamepad.XInputGamepadEventAdapter;
import korlibs.platform.Platform;
import korlibs.render.GameWindow;
import korlibs.render.awt.DesktopGamepadUpdater;
import korlibs.time.Stopwatch;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lkorlibs/render/awt/DesktopGamepadUpdater;", "", "()V", "exceptionStopwatch", "Lkorlibs/time/Stopwatch;", "linuxJoyEventAdapter", "Lkorlibs/event/gamepad/LinuxJoyEventAdapter;", "getLinuxJoyEventAdapter", "()Lkorlibs/event/gamepad/LinuxJoyEventAdapter;", "linuxJoyEventAdapter$delegate", "Lkotlin/Lazy;", "macosGamepadEventAdapter", "Lkorlibs/event/gamepad/MacosGamepadEventAdapter;", "getMacosGamepadEventAdapter", "()Lkorlibs/event/gamepad/MacosGamepadEventAdapter;", "macosGamepadEventAdapter$delegate", "xinputEventAdapter", "Lkorlibs/event/gamepad/XInputGamepadEventAdapter;", "getXinputEventAdapter", "()Lkorlibs/event/gamepad/XInputGamepadEventAdapter;", "xinputEventAdapter$delegate", "updateGamepads", "", "window", "Lkorlibs/render/GameWindow;", "korge"})
@SourceDebugExtension(value={"SMAP\nDesktopGamepadUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopGamepadUpdater.kt\nkorlibs/render/awt/DesktopGamepadUpdater\n+ 2 TimeSpan.kt\nkorlibs/time/TimeSpanKt\n*L\n1#1,37:1\n55#2:38\n72#2:39\n*S KotlinDebug\n*F\n+ 1 DesktopGamepadUpdater.kt\nkorlibs/render/awt/DesktopGamepadUpdater\n*L\n12#1:38\n12#1:39\n*E\n"})
public final class DesktopGamepadUpdater {
    @NotNull
    public static final DesktopGamepadUpdater INSTANCE = new DesktopGamepadUpdater();
    @Nullable
    private static Stopwatch exceptionStopwatch;
    @NotNull
    private static final Lazy xinputEventAdapter$delegate;
    @NotNull
    private static final Lazy linuxJoyEventAdapter$delegate;
    @NotNull
    private static final Lazy macosGamepadEventAdapter$delegate;

    private DesktopGamepadUpdater() {
    }

    public final void updateGamepads(@NotNull GameWindow window2) {
        if (exceptionStopwatch != null) {
            Stopwatch stopwatch = exceptionStopwatch;
            Intrinsics.checkNotNull(stopwatch);
            boolean $this$seconds$iv = true;
            boolean $i$f$getSeconds = false;
            double $this$seconds$iv$iv = (double)$this$seconds$iv;
            boolean $i$f$getSeconds2 = false;
            if (Duration.compareTo-LRDsOJo(stopwatch.getElapsed-UwyO8pc(), DurationKt.toDuration($this$seconds$iv$iv, DurationUnit.SECONDS)) < 0) {
                return;
            }
        }
        if (exceptionStopwatch == null) {
            exceptionStopwatch = new Stopwatch(null, 1, null).start();
        }
        try {
            if (Platform.Companion.isWindows()) {
                this.getXinputEventAdapter().updateGamepads(window2.getGamepadEmitter());
            } else if (Platform.Companion.isLinux()) {
                this.getLinuxJoyEventAdapter().updateGamepads(window2.getGamepadEmitter());
            } else if (Platform.Companion.isMac()) {
                this.getMacosGamepadEventAdapter().updateGamepads(window2);
            }
        }
        catch (Throwable e) {
            Stopwatch stopwatch = exceptionStopwatch;
            if (stopwatch != null) {
                stopwatch.restart();
            }
            e.printStackTrace();
        }
    }

    private final XInputGamepadEventAdapter getXinputEventAdapter() {
        Lazy lazy = xinputEventAdapter$delegate;
        return (XInputGamepadEventAdapter)lazy.getValue();
    }

    private final LinuxJoyEventAdapter getLinuxJoyEventAdapter() {
        Lazy lazy = linuxJoyEventAdapter$delegate;
        return (LinuxJoyEventAdapter)lazy.getValue();
    }

    private final MacosGamepadEventAdapter getMacosGamepadEventAdapter() {
        Lazy lazy = macosGamepadEventAdapter$delegate;
        return (MacosGamepadEventAdapter)lazy.getValue();
    }

    static {
        xinputEventAdapter$delegate = LazyKt.lazy(xinputEventAdapter.2.INSTANCE);
        linuxJoyEventAdapter$delegate = LazyKt.lazy(linuxJoyEventAdapter.2.INSTANCE);
        macosGamepadEventAdapter$delegate = LazyKt.lazy(macosGamepadEventAdapter.2.INSTANCE);
    }
}

