/*
 * Decompiled with CFR 0.152.
 */
package korlibs.render.osx;

import java.util.ArrayList;
import java.util.Collection;
import korlibs.render.osx.ConstObjcType;
import korlibs.render.osx.FixedArrayObjcType;
import korlibs.render.osx.ObjcMethodDesc;
import korlibs.render.osx.ObjcParam;
import korlibs.render.osx.ObjcType;
import korlibs.render.osx.ObjcTypeParser;
import korlibs.render.osx.PointerObjcType;
import korlibs.render.osx.PrimitiveObjcType;
import korlibs.render.osx.StrReader;
import korlibs.render.osx.StructObjcType;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lkorlibs/render/osx/ObjcTypeParser;", "", "()V", "parse", "Lkorlibs/render/osx/ObjcMethodDesc;", "str", "Lkorlibs/render/osx/StrReader;", "", "parseInt", "", "parseParam", "Lkorlibs/render/osx/ObjcParam;", "parseType", "Lkorlibs/render/osx/ObjcType;", "korge"})
public final class ObjcTypeParser {
    @NotNull
    public static final ObjcTypeParser INSTANCE = new ObjcTypeParser();

    private ObjcTypeParser() {
    }

    public final int parseInt(@NotNull StrReader str) {
        Object out = "";
        while (Character.isDigit(str.peekChar())) {
            out = (String)out + str.readChar();
        }
        Integer n = StringsKt.toIntOrNull((String)out);
        return n != null ? n : -1;
    }

    @NotNull
    public final ObjcType parseType(@NotNull StrReader str) {
        ObjcType objcType;
        char c = str.readChar();
        char c2 = c;
        if (c2 == 'V') {
            objcType = PrimitiveObjcType.VOID;
        } else if (c2 == 'v') {
            objcType = PrimitiveObjcType.VOID;
        } else if (c2 == 'B') {
            objcType = PrimitiveObjcType.BOOL;
        } else if (c2 == '@') {
            PrimitiveObjcType primitiveObjcType;
            if (str.peekChar() == '?') {
                StrReader.skip$default(str, 0, 1, null);
                primitiveObjcType = PrimitiveObjcType.BLOCK;
            } else {
                primitiveObjcType = PrimitiveObjcType.ID;
            }
            objcType = primitiveObjcType;
        } else if (c2 == '{') {
            String name2 = str.readUntil(parseType.name.1.INSTANCE);
            if (str.readChar() != '=') {
                throw new IllegalStateException(("Invalid " + str).toString());
            }
            ArrayList out = new ArrayList();
            while (str.peekChar() != '}') {
                ((Collection)out).add(this.parseType(str));
            }
            StrReader.skip$default(str, 0, 1, null);
            objcType = new StructObjcType(name2, out);
        } else if (c2 == '[') {
            int count2 = this.parseInt(str);
            ObjcType type2 = this.parseType(str);
            if (str.readChar() != ']') {
                throw new IllegalStateException(("Invalid " + str).toString());
            }
            objcType = new FixedArrayObjcType(count2, type2);
        } else if (c2 == '#') {
            objcType = PrimitiveObjcType.ID;
        } else if (c2 == ':') {
            objcType = PrimitiveObjcType.SEL;
        } else if (c2 == 'C') {
            objcType = PrimitiveObjcType.BYTE;
        } else if (c2 == 'i') {
            objcType = PrimitiveObjcType.INT;
        } else if (c2 == 'I') {
            objcType = PrimitiveObjcType.UINT;
        } else if (c2 == 'q') {
            objcType = PrimitiveObjcType.NINT;
        } else if (c2 == 'Q') {
            objcType = PrimitiveObjcType.NUINT;
        } else if (c2 == '^') {
            objcType = new PointerObjcType(this.parseType(str));
        } else if (c2 == 'r') {
            objcType = new ConstObjcType(this.parseType(str));
        } else if (c2 == 'f') {
            objcType = PrimitiveObjcType.FLOAT;
        } else if (c2 == 'd') {
            objcType = PrimitiveObjcType.DOUBLE;
        } else {
            String string = "Not implemented '" + c + "' in " + str;
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return objcType;
    }

    @NotNull
    public final ObjcParam parseParam(@NotNull StrReader str) {
        ObjcType type2 = this.parseType(str);
        int offset2 = this.parseInt(str);
        return new ObjcParam(offset2, type2);
    }

    @NotNull
    public final ObjcMethodDesc parse(@NotNull StrReader str) {
        ArrayList out = new ArrayList();
        while (str.getHasMore()) {
            ((Collection)out).add(this.parseParam(str));
        }
        return new ObjcMethodDesc(str.getStr(), out);
    }

    @NotNull
    public final ObjcMethodDesc parse(@NotNull String str) {
        return this.parse(new StrReader(str, 0, 0, 6, null));
    }
}

