/*
 * Decompiled with CFR 0.152.
 */
package korlibs.render.platform;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.X11;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import korlibs.io.dynamic.Dyn;
import korlibs.io.dynamic.DynKt;
import korlibs.platform.Platform;
import korlibs.render.GameWindowConfig;
import korlibs.render.osx.MacAWTOpenglContext;
import korlibs.render.platform.AwtToolsKt;
import korlibs.render.platform.BaseOpenglContext;
import korlibs.render.platform.DummyOpenglContext;
import korlibs.render.win32.Win32OpenglContext;
import korlibs.render.x11.X;
import korlibs.render.x11.X11OpenglContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"getDisplayScalingFactor", "", "component", "Ljava/awt/Component;", "glContextFromComponent", "Lkorlibs/render/platform/BaseOpenglContext;", "c", "gwconfig", "Lkorlibs/render/GameWindowConfig;", "korge"})
public final class BaseOpenglContextKt {
    @NotNull
    public static final BaseOpenglContext glContextFromComponent(@NotNull Component c, @NotNull GameWindowConfig gwconfig) {
        BaseOpenglContext baseOpenglContext;
        if (Platform.Companion.isMac()) {
            BaseOpenglContext baseOpenglContext2;
            try {
                baseOpenglContext2 = new MacAWTOpenglContext(gwconfig, c, null, 4, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("Might require run the JVM with --add-opens=java.desktop/sun.java2d.opengl=ALL-UNNAMED");
                baseOpenglContext2 = DummyOpenglContext.INSTANCE;
            }
            baseOpenglContext = baseOpenglContext2;
        } else if (Platform.Companion.isWindows()) {
            baseOpenglContext = Win32OpenglContext.Companion.invoke(c, gwconfig, true).init();
        } else {
            X11OpenglContext x11OpenglContext;
            try {
                X11OpenglContext x11OpenglContext2;
                X11.Display display = X.INSTANCE.XOpenDisplay(null);
                int screen = X.INSTANCE.XDefaultScreen(display);
                if (c instanceof Frame) {
                    long contentWindow = Dyn.getLong-impl(Dyn.dynamicInvoke-WiyfuWs(DynKt.getDyn(AwtToolsKt.awtGetPeer(c)), "getContentWindow", new Object[0]));
                    x11OpenglContext2 = new X11OpenglContext(gwconfig, display, new X11.Drawable(contentWindow), screen, null, true, 16, null);
                } else {
                    long componentId = Native.getComponentID(c);
                    x11OpenglContext2 = new X11OpenglContext(gwconfig, display, new X11.Drawable(componentId), screen, null, true, 16, null);
                }
                x11OpenglContext = x11OpenglContext2;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
            baseOpenglContext = x11OpenglContext;
        }
        return baseOpenglContext;
    }

    public static final float getDisplayScalingFactor(@NotNull Component component) {
        float f;
        Float nativeScaleFactor;
        Float f2;
        Method method2;
        Object object = component.getGraphicsConfiguration();
        if (object == null || (object = ((GraphicsConfiguration)object).getDevice()) == null) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        Object device = object;
        try {
            method2 = device.getClass().getMethod("getScaleFactor", new Class[0]);
        }
        catch (Throwable e) {
            method2 = null;
        }
        Method getScaleFactorMethod = method2;
        if (getScaleFactorMethod == null) {
            f2 = null;
        } else {
            Float f3;
            try {
                Object object2 = getScaleFactorMethod.invoke(device, new Object[0]);
                Intrinsics.checkNotNullExpressionValue(object2, "invoke(...)");
                Object scale = object2;
                Number number = scale instanceof Number ? (Number)((Number)scale) : (Number)null;
                f3 = Float.valueOf(number != null ? number.floatValue() : 1.0f);
            }
            catch (Throwable e) {
                if (!Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(e.getClass()).getQualifiedName(), "java.lang.IllegalAccessException")) {
                    e.printStackTrace();
                }
                f3 = null;
            }
            f2 = f3;
        }
        Float f4 = nativeScaleFactor = f2;
        if (f4 != null) {
            f = f4.floatValue();
        } else {
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (graphicsConfiguration == null) {
                graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            f = (float)graphicsConfiguration.getDefaultTransform().getScaleX();
        }
        return f;
    }
}

