/*
 * Decompiled with CFR 0.152.
 */
package korlibs.time.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import korlibs.time.TimeSpanKt;
import korlibs.time.TimezoneNames;
import korlibs.time.internal.MicroStrReader;
import korlibs.time.internal._Time_internalKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u00a0\u0001\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012b\b\u0002\u0010\f\u001a\\\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00010\r2!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00010\u0015H\u0080\b\u001a\u001e\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001b\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010 H\u0080\b\u001a-\u0010!\u001a\u00020\u0018\"\u0004\b\u0000\u0010\"*\b\u0012\u0004\u0012\u0002H\"0#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u00020\u00180\u0015H\u0080\b\u001a+\u0010%\u001a\u00020\u0018\"\u0004\b\u0000\u0010&*\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020\u00010'2\u0006\u0010(\u001a\u0002H&H\u0000\u00a2\u0006\u0002\u0010)\u001a\u001c\u0010*\u001a\u00020+*\u00020\u00042\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0000\u001a\u0014\u0010*\u001a\u00020+*\u00020\u00012\u0006\u0010.\u001a\u00020\u0001H\u0000\u001a\u001e\u0010/\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b*\u0002002\b\b\u0002\u00101\u001a\u000202H\u0000\u001a\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020+0#*\u00020+2\u0006\u00104\u001a\u000205H\u0000\u001a\u001e\u00106\u001a\u00020+*\u00020+2\u0006\u00107\u001a\u00020\u00012\b\b\u0002\u00108\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00069"}, d2={"MILLIS_PER_DAY", "", "MILLIS_PER_HOUR", "MILLIS_PER_MICROSECOND", "", "MILLIS_PER_MINUTE", "MILLIS_PER_NANOSECOND", "MILLIS_PER_SECOND", "MILLIS_PER_WEEK", "genericBinarySearch", "fromIndex", "toIndex", "invalid", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "from", "to", "low", "high", "check", "Lkotlin/Function1;", "index", "spinlock", "", "time", "Lkotlin/time/Duration;", "Lkorlibs/time/TimeSpan;", "spinlock-LRDsOJo", "(J)V", "chainComparison", "comparer", "Lkotlin/Function0;", "fastForEach", "T", "", "callback", "increment", "K", "", "key", "(Ljava/util/Map;Ljava/lang/Object;)V", "padded", "", "intCount", "decCount", "count", "readTimeZoneOffset", "Lkorlibs/time/internal/MicroStrReader;", "tzNames", "Lkorlibs/time/TimezoneNames;", "splitKeep", "regex", "Lkotlin/text/Regex;", "substr", "start", "length", "korlibs-time"})
@SourceDebugExtension(value={"SMAP\n_Time.internal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 _Time.internal.kt\nkorlibs/time/internal/_Time_internalKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 TimeSpan.kt\nkorlibs/time/TimeSpanKt\n*L\n1#1,220:1\n372#2,7:221\n57#3:228\n74#3:229\n59#3:230\n76#3:231\n57#3:232\n74#3:233\n*S KotlinDebug\n*F\n+ 1 _Time.internal.kt\nkorlibs/time/internal/_Time_internalKt\n*L\n120#1:221,7\n208#1:228\n208#1:229\n217#1:230\n217#1:231\n217#1:232\n217#1:233\n*E\n"})
public final class _Time_internalKt {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;
    public static final int MILLIS_PER_WEEK = 604800000;
    public static final double MILLIS_PER_MICROSECOND = 0.001;
    public static final double MILLIS_PER_NANOSECOND = 1.0E-6;

    public static final int chainComparison(int $this$chainComparison, @NotNull Function0<Integer> comparer2) {
        boolean $i$f$chainComparison = false;
        return $this$chainComparison == 0 ? ((Number)comparer2.invoke()).intValue() : $this$chainComparison;
    }

    public static final <T> void fastForEach(@NotNull List<? extends T> $this$fastForEach, @NotNull Function1<? super T, Unit> callback) {
        boolean $i$f$fastForEach = false;
        int n = 0;
        while (n < $this$fastForEach.size()) {
            callback.invoke($this$fastForEach.get(n++));
        }
    }

    public static final int genericBinarySearch(int fromIndex, int toIndex, @NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Integer> invalid, @NotNull Function1<? super Integer, Integer> check) {
        boolean $i$f$genericBinarySearch = false;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int mval = ((Number)check.invoke((Integer)mid)).intValue();
            if (mval < 0) {
                low = mid + 1;
                continue;
            }
            if (mval > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ((Number)invalid.invoke((Integer)fromIndex, (Integer)toIndex, (Integer)low, (Integer)high)).intValue();
    }

    public static /* synthetic */ int genericBinarySearch$default(int fromIndex, int toIndex, Function4 invalid, Function1 check, int n, Object object) {
        if ((n & 4) != 0) {
            invalid = genericBinarySearch.1.INSTANCE;
        }
        boolean $i$f$genericBinarySearch = false;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int mval = ((Number)check.invoke(mid)).intValue();
            if (mval < 0) {
                low = mid + 1;
                continue;
            }
            if (mval > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ((Number)invalid.invoke(fromIndex, toIndex, low, high)).intValue();
    }

    @NotNull
    public static final String padded(int $this$padded, int count2) {
        String res = StringsKt.padStart(String.valueOf(Math.abs($this$padded)), count2, '0');
        if ($this$padded < 0) {
            return "-" + res;
        }
        return res;
    }

    @NotNull
    public static final String padded(double $this$padded, int intCount, int decCount) {
        int intPart = (int)Math.floor($this$padded);
        int decPart = (int)Math.rint(($this$padded - (double)intPart) * Math.pow(10.0, decCount));
        return _Time_internalKt.substr(_Time_internalKt.padded(intPart, intCount), -intCount, intCount) + "." + _Time_internalKt.substr$default(StringsKt.padStart(String.valueOf(decPart), decCount, '0'), -decCount, 0, 2, null);
    }

    @NotNull
    public static final String substr(@NotNull String $this$substr, int start2, int length2) {
        String string;
        int low = RangesKt.coerceIn(start2 >= 0 ? start2 : $this$substr.length() + start2, 0, $this$substr.length());
        int high = RangesKt.coerceIn(length2 >= 0 ? low + length2 : $this$substr.length() + length2, 0, $this$substr.length());
        if (high < low) {
            string = "";
        } else {
            String string2 = $this$substr.substring(low, high);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        }
        return string;
    }

    public static /* synthetic */ String substr$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return _Time_internalKt.substr(string, n, n2);
    }

    @NotNull
    public static final List<String> splitKeep(@NotNull String $this$splitKeep, @NotNull Regex regex) {
        String str = $this$splitKeep;
        ArrayList out = new ArrayList();
        int lastPos = 0;
        Iterator iterator2 = Regex.findAll$default(regex, $this$splitKeep, 0, 2, null).iterator();
        while (iterator2.hasNext()) {
            MatchResult part = (MatchResult)iterator2.next();
            IntRange prange = part.getRange();
            if (lastPos != prange.getStart()) {
                Collection collection = out;
                String string = str.substring(lastPos, prange.getStart());
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                collection.add(string);
            }
            ((Collection)out).add(StringsKt.substring(str, prange));
            lastPos = prange.getEndInclusive() + 1;
        }
        if (lastPos != str.length()) {
            Collection collection = out;
            String string = str.substring(lastPos);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            collection.add(string);
        }
        return out;
    }

    public static final <K> void increment(@NotNull Map<K, Integer> $this$increment, K key) {
        Map<K, Integer> $this$getOrPut$iv = $this$increment;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = 0;
            $this$getOrPut$iv.put(key, answer$iv);
        }
        Integer n = $this$increment.get(key);
        Intrinsics.checkNotNull(n);
        $this$increment.put(key, ((Number)n).intValue() + 1);
    }

    public static final void spinlock-LRDsOJo(long time) {
        long start2 = TimeSpanKt.now(Duration.Companion);
        while (Duration.compareTo-LRDsOJo(Duration.minus-LRDsOJo(TimeSpanKt.now(Duration.Companion), start2), time) < 0) {
        }
    }

    @Nullable
    public static final Duration readTimeZoneOffset(@NotNull MicroStrReader $this$readTimeZoneOffset, @NotNull TimezoneNames tzNames) {
        MicroStrReader reader = $this$readTimeZoneOffset;
        for (Map.Entry<String, Duration> entry2 : tzNames.getNamesToOffsets().entrySet()) {
            String name2 = entry2.getKey();
            long offset2 = entry2.getValue().unbox-impl();
            if (Intrinsics.areEqual(name2, "GMT") || Intrinsics.areEqual(name2, "UTC") || !reader.tryRead(name2)) continue;
            return Duration.box-impl(offset2);
        }
        if (reader.tryRead('Z')) {
            boolean $this$minutes$iv = false;
            boolean $i$f$getMinutes = false;
            double $this$minutes$iv$iv = (double)$this$minutes$iv;
            boolean $i$f$getMinutes2 = false;
            return Duration.box-impl(DurationKt.toDuration($this$minutes$iv$iv, DurationUnit.MINUTES));
        }
        int sign = 1;
        reader.tryRead("GMT");
        reader.tryRead("UTC");
        if (reader.tryRead("+")) {
            sign = 1;
        }
        if (reader.tryRead("-")) {
            sign = -1;
        }
        String part = StringsKt.replace$default(reader.readRemaining(), ":", "", false, 4, null);
        Integer n = StringsKt.toIntOrNull(StringsKt.padStart(_Time_internalKt.substr(part, 0, 2), 2, '0'));
        if (n == null) {
            return null;
        }
        int hours = n;
        Integer n2 = StringsKt.toIntOrNull(StringsKt.padStart(_Time_internalKt.substr(part, 2, 2), 2, '0'));
        if (n2 == null) {
            return null;
        }
        int minutes = n2;
        int $this$hours$iv = hours;
        boolean $i$f$getHours = false;
        double $this$hours$iv$iv = $this$hours$iv;
        boolean $i$f$getHours2 = false;
        int $this$minutes$iv = minutes;
        boolean $i$f$getMinutes = false;
        double $this$minutes$iv$iv = $this$minutes$iv;
        boolean $i$f$getMinutes3 = false;
        long roffset = Duration.plus-LRDsOJo(DurationKt.toDuration($this$hours$iv$iv, DurationUnit.HOURS), DurationKt.toDuration($this$minutes$iv$iv, DurationUnit.MINUTES));
        return sign > 0 ? Duration.box-impl(TimeSpanKt.unaryPlus-LRDsOJo(roffset)) : Duration.box-impl(Duration.unaryMinus-UwyO8pc(roffset));
    }

    public static /* synthetic */ Duration readTimeZoneOffset$default(MicroStrReader microStrReader, TimezoneNames timezoneNames, int n, Object object) {
        if ((n & 1) != 0) {
            timezoneNames = TimezoneNames.Companion.getDEFAULT();
        }
        return _Time_internalKt.readTimeZoneOffset(microStrReader, timezoneNames);
    }
}

