/*
 * Decompiled with CFR 0.152.
 */
package korlibs.time.locale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import korlibs.time.DayOfWeek;
import korlibs.time.KlockLocale;
import korlibs.time.KlockLocaleContext;
import korlibs.time.PatternDateFormat;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004H\u0016J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u001d\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0014\u0010\u001f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\nR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\n\u00a8\u0006-"}, d2={"Lkorlibs/time/locale/GermanKlockLocale;", "Lkorlibs/time/KlockLocale;", "()V", "ISO639_1", "", "getISO639_1", "()Ljava/lang/String;", "daysOfWeek", "", "getDaysOfWeek", "()Ljava/util/List;", "firstDayOfWeek", "Lkorlibs/time/DayOfWeek;", "getFirstDayOfWeek", "()Lkorlibs/time/DayOfWeek;", "formatDateFull", "Lkorlibs/time/PatternDateFormat;", "getFormatDateFull", "()Lkorlibs/time/PatternDateFormat;", "formatDateLong", "getFormatDateLong", "formatDateMedium", "getFormatDateMedium", "formatDateShort", "getFormatDateShort", "formatDateTimeMedium", "getFormatDateTimeMedium", "formatDateTimeShort", "getFormatDateTimeShort", "formatTimeMedium", "getFormatTimeMedium", "formatTimeShort", "getFormatTimeShort", "h12Marker", "getH12Marker", "months", "getMonths", "getDayByOrdinal", "", "ordinal", "getOrdinalByDay", "day", "context", "Lkorlibs/time/KlockLocaleContext;", "Companion", "korlibs-time"})
@SourceDebugExtension(value={"SMAP\nde.kt\nKotlin\n*S Kotlin\n*F\n+ 1 de.kt\nkorlibs/time/locale/GermanKlockLocale\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,82:1\n11155#2:83\n11266#2,4:84\n*S KotlinDebug\n*F\n+ 1 de.kt\nkorlibs/time/locale/GermanKlockLocale\n*L\n46#1:83\n46#1:84,4\n*E\n"})
public class GermanKlockLocale
extends KlockLocale {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String ISO639_1;
    @NotNull
    private final List<String> h12Marker;
    @NotNull
    private final DayOfWeek firstDayOfWeek;
    @NotNull
    private final List<String> daysOfWeek;
    @NotNull
    private final List<String> months;
    @NotNull
    private final PatternDateFormat formatDateTimeMedium;
    @NotNull
    private final PatternDateFormat formatDateTimeShort;
    @NotNull
    private final PatternDateFormat formatDateFull;
    @NotNull
    private final PatternDateFormat formatDateLong;
    @NotNull
    private final PatternDateFormat formatDateMedium;
    @NotNull
    private final PatternDateFormat formatDateShort;
    @NotNull
    private final PatternDateFormat formatTimeMedium;
    @NotNull
    private final PatternDateFormat formatTimeShort;
    @NotNull
    private static final String[] NUM_TO_ORDINAL;
    @NotNull
    private static final Map<String, Integer> ORDINAL_TO_NUM;

    public GermanKlockLocale() {
        this.ISO639_1 = "de";
        String[] stringArray = new String[]{"vorm.", "nachm."};
        this.h12Marker = CollectionsKt.listOf(stringArray);
        this.firstDayOfWeek = DayOfWeek.Monday;
        stringArray = new String[]{"Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"};
        this.daysOfWeek = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"};
        this.months = CollectionsKt.listOf(stringArray);
        this.formatDateTimeMedium = this.format("dd.MM.y HH:mm:ss");
        this.formatDateTimeShort = this.format("dd.MM.yy HH:mm");
        this.formatDateFull = this.format("EEEE, d. MMMM y");
        this.formatDateLong = this.format("d. MMMM y");
        this.formatDateMedium = this.format("dd.MM.y");
        this.formatDateShort = this.format("dd.MM.yy");
        this.formatTimeMedium = this.format("HH:mm:ss");
        this.formatTimeShort = this.format("HH:mm");
    }

    @Override
    @NotNull
    public String getOrdinalByDay(int day, @NotNull KlockLocaleContext context2) {
        String string = ArraysKt.getOrNull(NUM_TO_ORDINAL, day);
        if (string == null) {
            throw new IllegalStateException("Invalid numeral".toString());
        }
        return string;
    }

    @Override
    public int getDayByOrdinal(@NotNull String ordinal) {
        String string = ordinal.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        Integer n = ORDINAL_TO_NUM.get(string);
        return n != null ? n : -1;
    }

    @Override
    @NotNull
    public String getISO639_1() {
        return this.ISO639_1;
    }

    @Override
    @NotNull
    public List<String> getH12Marker() {
        return this.h12Marker;
    }

    @Override
    @NotNull
    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Override
    @NotNull
    public List<String> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @Override
    @NotNull
    public List<String> getMonths() {
        return this.months;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatDateTimeMedium() {
        return this.formatDateTimeMedium;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatDateTimeShort() {
        return this.formatDateTimeShort;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatDateFull() {
        return this.formatDateFull;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatDateLong() {
        return this.formatDateLong;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatDateMedium() {
        return this.formatDateMedium;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatDateShort() {
        return this.formatDateShort;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatTimeMedium() {
        return this.formatTimeMedium;
    }

    @Override
    @NotNull
    public PatternDateFormat getFormatTimeShort() {
        return this.formatTimeShort;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapIndexedTo$iv$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"nullte", "erste", "zweite", "dritte", "vierte", "f\u00fcnfte", "sechste", "siebte", "achte", "neunte", "zehnte", "elfte", "zw\u00f6lfte", "dreizehnte", "vierzehnte", "f\u00fcnfzehnte", "sechzehnte", "siebzehnte", "achtzehnte", "neunzehnte", "zwanzigste", "einundzwanzigste", "zweiundzwanzigste", "dreiundzwanzigste", "vierundzwanzigste", "f\u00fcnfundzwanzigste", "sechsundzwanzigste", "siebenundzwanzigste", "achtundzwanzigste", "neunundzwanzigste", "drei\u00dfigste", "einunddrei\u00dfigste"};
        String[] $this$mapIndexed$iv = NUM_TO_ORDINAL = stringArray;
        boolean $i$f$mapIndexed = false;
        String[] stringArray2 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void s;
            int n = index$iv$iv++;
            void var9_9 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(s, (int)index2));
        }
        ORDINAL_TO_NUM = MapsKt.toMap((List)var3_3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkorlibs/time/locale/GermanKlockLocale$Companion;", "Lkorlibs/time/locale/GermanKlockLocale;", "()V", "NUM_TO_ORDINAL", "", "", "[Ljava/lang/String;", "ORDINAL_TO_NUM", "", "", "korlibs-time"})
    public static final class Companion
    extends GermanKlockLocale {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

