/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import java.util.Arrays;
import korlibs.datastructure.closeable.Closeable;
import korlibs.wasm.DenoWasmIO;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J-\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0019\"\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u00062\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0019\"\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u00020\u00132\n\u0010\u001f\u001a\u00020 \"\u00020\u0006J\u0016\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006J\u000e\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010'\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0006J\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010)\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lkorlibs/wasm/DenoWASM;", "Lkorlibs/datastructure/closeable/Closeable;", "Lkorlibs/io/lang/Closeable;", "io", "Lkorlibs/wasm/DenoWasmIO;", "streamId", "", "wasmModuleBytes", "", "(Lkorlibs/wasm/DenoWasmIO;I[B)V", "getIo", "()Lkorlibs/wasm/DenoWasmIO;", "getStreamId", "()I", "getWasmModuleBytes", "()[B", "allocAndWrite", "bytes", "close", "", "executeFunction", "", "name", "", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "executeFunctionIndirect", "address", "(I[Ljava/lang/Object;)Ljava/lang/Object;", "free", "ptrs", "", "readBytes", "ptr", "len", "stackAlloc", "size", "stackAllocAndWrite", "stackRestore", "stackSave", "writeBytes", "korge-core"})
public final class DenoWASM
implements Closeable {
    @NotNull
    private final DenoWasmIO io;
    private final int streamId;
    @NotNull
    private final byte[] wasmModuleBytes;

    public DenoWASM(@NotNull DenoWasmIO io2, int streamId, @NotNull byte[] wasmModuleBytes) {
        this.io = io2;
        this.streamId = streamId;
        this.wasmModuleBytes = wasmModuleBytes;
        this.io.loadWASM(this.streamId, this.wasmModuleBytes);
    }

    @NotNull
    public final DenoWasmIO getIo() {
        return this.io;
    }

    public final int getStreamId() {
        return this.streamId;
    }

    @NotNull
    public final byte[] getWasmModuleBytes() {
        return this.wasmModuleBytes;
    }

    public final int allocAndWrite(@NotNull byte[] bytes) {
        return this.io.allocAndWrite(this.streamId, bytes);
    }

    public final void free(int ... ptrs) {
        this.io.free(this.streamId, Arrays.copyOf(ptrs, ptrs.length));
    }

    public final int stackSave() {
        return this.io.stackSave(this.streamId);
    }

    public final void stackRestore(int ptr) {
        this.io.stackRestore(this.streamId, ptr);
    }

    public final int stackAlloc(int size2) {
        return this.io.stackAlloc(this.streamId, size2);
    }

    public final int stackAllocAndWrite(@NotNull byte[] bytes) {
        return this.io.stackAllocAndWrite(this.streamId, bytes);
    }

    public final void writeBytes(int ptr, @NotNull byte[] bytes) {
        this.io.writeBytes(this.streamId, ptr, bytes);
    }

    @NotNull
    public final byte[] readBytes(int ptr, int len) {
        return this.io.readBytes(this.streamId, ptr, len);
    }

    @Nullable
    public final Object executeFunction(@NotNull String name2, Object ... params) {
        return this.io.executeFunction(this.streamId, name2, Arrays.copyOf(params, params.length));
    }

    @Nullable
    public final Object executeFunctionIndirect(int address, Object ... params) {
        return this.io.executeFunctionIndirect(this.streamId, address, Arrays.copyOf(params, params.length));
    }

    @Override
    public void close() {
        this.io.unloadWASM(this.streamId);
    }
}

