/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import korlibs.concurrent.lock.Lock;
import korlibs.datastructure.closeable.Closeable;
import korlibs.io.serialization.json.Json;
import korlibs.io.stream.SyncInputStream;
import korlibs.io.stream.SyncOutputStream;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u000f\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u001cJ5\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0016\u0010%\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010&\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010'J5\u0010(\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001a2\u0016\u0010%\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010&\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010*J\u001a\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010,\u001a\u00020-\"\u00020\u001aJ\u0016\u0010.\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0018J\u001e\u0010/\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u001aJ\u0016\u00102\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u001aJ\u0016\u00104\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0018J\u0016\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aJ\u000e\u00106\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aJ\u001e\u00108\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0018J \u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0014\u0010:\u001a\u00020\u0018*\u00020\u00052\u0006\u0010;\u001a\u00020\u0018H\u0002J\u0014\u0010:\u001a\u00020\u0018*\u00020\u00052\u0006\u00103\u001a\u00020\u001aH\u0002R\u0019\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006<"}, d2={"Lkorlibs/wasm/DenoWasmIO;", "", "output", "Lkorlibs/io/stream/SyncOutputStream;", "input", "Lkorlibs/io/stream/SyncInputStream;", "_close", "Lkorlibs/datastructure/closeable/Closeable;", "Lkorlibs/io/lang/Closeable;", "debug", "", "(Lkorlibs/io/stream/SyncOutputStream;Lkorlibs/io/stream/SyncInputStream;Lkorlibs/datastructure/closeable/Closeable;Z)V", "get_close", "()Lkorlibs/datastructure/closeable/Closeable;", "getDebug", "()Z", "getInput", "()Lkorlibs/io/stream/SyncInputStream;", "lock", "Lkorlibs/concurrent/lock/Lock;", "Lkorlibs/datastructure/lock/Lock;", "getOutput", "()Lkorlibs/io/stream/SyncOutputStream;", "_readMessage", "", "type", "", "_writeMessage", "", "streamId", "payload", "allocAndWrite", "bytes", "close", "executeFunction", "name", "", "params", "", "(ILjava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "executeFunctionIndirect", "address", "(II[Ljava/lang/Object;)Ljava/lang/Object;", "free", "ptrs", "", "loadWASM", "readBytes", "ptr", "len", "stackAlloc", "size", "stackAllocAndWrite", "stackRestore", "stackSave", "unloadWASM", "writeBytes", "writeReadMessage", "readBytesExact", "b", "korge-core"})
@SourceDebugExtension(value={"SMAP\nDenoWasmProcessStdin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DenoWasmProcessStdin.kt\nkorlibs/wasm/DenoWasmIO\n+ 2 Lock.jvm.kt\nkorlibs/concurrent/lock/Lock\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,439:1\n32#2:440\n1#3:441\n1#3:442\n*S KotlinDebug\n*F\n+ 1 DenoWasmProcessStdin.kt\nkorlibs/wasm/DenoWasmIO\n*L\n156#1:440\n156#1:441\n*E\n"})
public final class DenoWasmIO {
    @NotNull
    private final SyncOutputStream output;
    @NotNull
    private final SyncInputStream input;
    @Nullable
    private final Closeable _close;
    private final boolean debug;
    @NotNull
    private final Lock lock;

    public DenoWasmIO(@NotNull SyncOutputStream output2, @NotNull SyncInputStream input, @Nullable Closeable _close, boolean debug) {
        this.output = output2;
        this.input = input;
        this._close = _close;
        this.debug = debug;
        this.lock = new Lock();
    }

    public /* synthetic */ DenoWasmIO(SyncOutputStream syncOutputStream, SyncInputStream syncInputStream, Closeable closeable2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            closeable2 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(syncOutputStream, syncInputStream, closeable2, bl);
    }

    @NotNull
    public final SyncOutputStream getOutput() {
        return this.output;
    }

    @NotNull
    public final SyncInputStream getInput() {
        return this.input;
    }

    @Nullable
    public final Closeable get_close() {
        return this._close;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void close() {
        block0: {
            Closeable closeable2 = this._close;
            if (closeable2 == null) break block0;
            closeable2.close();
        }
    }

    public final void loadWASM(int streamId, @NotNull byte[] bytes) {
        this.writeReadMessage(1000, streamId, bytes);
        if (this.debug) {
            System.out.println((Object)"CMD:loadWASM");
        }
    }

    public final void unloadWASM(int streamId) {
        this.writeReadMessage(1001, streamId, new byte[0]);
        if (this.debug) {
            System.out.println((Object)"CMD:unloadWASM");
        }
    }

    public final void writeBytes(int streamId, int ptr, @NotNull byte[] bytes) {
        byte[] payload = new byte[4 + bytes.length];
        ByteArrayGetSetKt.set32LE(payload, 0, ptr);
        ByteArrayGetSetKt.setBytes(payload, 4, bytes);
        this.writeReadMessage(1010, streamId, payload);
        if (this.debug) {
            System.out.println((Object)("CMD:writeBytes:ptr=" + ptr + ", bytes=" + bytes.length));
        }
    }

    public final int allocAndWrite(int streamId, @NotNull byte[] bytes) {
        return ByteArrayGetSetKt.getS32LE(this.writeReadMessage(1011, streamId, bytes), 0);
    }

    public final void free(int streamId, int ... ptrs) {
        byte[] payload = new byte[ptrs.length * 4];
        int n = ptrs.length;
        for (int n2 = 0; n2 < n; ++n2) {
            ByteArrayGetSetKt.set32LE(payload, n2 * 4, ptrs[n2]);
        }
        this.writeReadMessage(1012, streamId, payload);
        if (this.debug) {
            System.out.println((Object)("CMD:free:ptrs=" + ArraysKt.toList(ptrs)));
        }
    }

    public final int stackSave(int streamId) {
        return ByteArrayGetSetKt.getS32LE(this.writeReadMessage(1013, streamId, new byte[0]), 0);
    }

    public final void stackRestore(int streamId, int ptr) {
        byte[] payload = new byte[4];
        ByteArrayGetSetKt.set32LE(payload, 0, ptr);
        this.writeReadMessage(1014, streamId, payload);
    }

    public final int stackAlloc(int streamId, int size2) {
        byte[] payload = new byte[4];
        ByteArrayGetSetKt.set32LE(payload, 0, size2);
        return ByteArrayGetSetKt.getS32LE(this.writeReadMessage(1015, streamId, payload), 0);
    }

    public final int stackAllocAndWrite(int streamId, @NotNull byte[] bytes) {
        return ByteArrayGetSetKt.getS32LE(this.writeReadMessage(1016, streamId, bytes), 0);
    }

    @NotNull
    public final byte[] readBytes(int streamId, int ptr, int len) {
        byte[] payload = new byte[8];
        ByteArrayGetSetKt.set32LE(payload, 0, ptr);
        ByteArrayGetSetKt.set32LE(payload, 4, len);
        if (this.debug) {
            System.out.println((Object)("CMD:readBytes:ptr=" + ptr + ",len=" + len));
        }
        return this.writeReadMessage(1020, streamId, payload);
    }

    @Nullable
    public final Object executeFunction(int streamId, @NotNull String name2, Object ... params) {
        Object object;
        Object object2 = new Pair[]{TuplesKt.to("func", name2), TuplesKt.to("params", ArraysKt.toList(params))};
        byte[] resultBytes = this.writeReadMessage(1030, streamId, StringsKt.encodeToByteArray(Json.stringify$default(Json.INSTANCE, MapsKt.mapOf(object2), false, 2, null)));
        if (this.debug) {
            System.out.println((Object)("CMD:executeFunction:name=" + name2 + ", params=" + ArraysKt.toList(params)));
        }
        if (resultBytes.length == 0) {
            object = Unit.INSTANCE;
        } else {
            Object it = object2 = Json.parse$default(Json.INSTANCE, StringsKt.decodeToString(resultBytes), null, 2, null);
            boolean bl = false;
            if (this.debug) {
                System.out.println((Object)(" -> CMD:executeFunction:result=" + it));
            }
            object = object2;
        }
        return object;
    }

    @Nullable
    public final Object executeFunctionIndirect(int streamId, int address, Object ... params) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("indirect", address), TuplesKt.to("params", ArraysKt.toList(params))};
        byte[] resultBytes = this.writeReadMessage(1030, streamId, StringsKt.encodeToByteArray(Json.stringify$default(Json.INSTANCE, MapsKt.mapOf(pairArray), false, 2, null)));
        String data2 = StringsKt.decodeToString(resultBytes);
        if (this.debug) {
            System.out.println((Object)("CMD:executeFunctionIndirect:address=" + address + ", params=" + ArraysKt.toList(params)));
        }
        return Json.parse$default(Json.INSTANCE, data2, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] writeReadMessage(int type2, int streamId, byte[] payload) {
        Lock this_$iv = this.lock;
        boolean $i$f$invoke = false;
        Lock lock = this_$iv;
        synchronized (lock) {
            boolean bl = false;
            boolean bl2 = false;
            this._writeMessage(type2, streamId, payload);
            byte[] byArray = this._readMessage(type2);
            return byArray;
        }
    }

    private final void _writeMessage(int type2, int streamId, byte[] payload) {
        byte[] buffer = new byte[12];
        ByteArrayGetSetKt.set32LE(buffer, 0, type2);
        ByteArrayGetSetKt.set32LE(buffer, 4, streamId);
        ByteArrayGetSetKt.set32LE(buffer, 8, payload.length);
        SyncOutputStream.DefaultImpls.write$default(this.output, buffer, 0, 0, 6, null);
        SyncOutputStream.DefaultImpls.write$default(this.output, payload, 0, 0, 6, null);
        this.output.flush();
    }

    private final byte[] _readMessage(int type2) {
        byte[] sizeBuffer = this.readBytesExact(this.input, 4);
        int len = ByteArrayGetSetKt.getS32LE(sizeBuffer, 0);
        byte[] out = this.readBytesExact(this.input, len);
        return out;
    }

    private final byte[] readBytesExact(SyncInputStream $this$readBytesExact, int size2) {
        return this.readBytesExact($this$readBytesExact, new byte[size2]);
    }

    private final byte[] readBytesExact(SyncInputStream $this$readBytesExact, byte[] b) {
        int len;
        int offset2 = 0;
        int remaining = 0;
        for (remaining = b.length; remaining > 0; remaining -= len) {
            len = $this$readBytesExact.read(b, offset2, remaining);
            if (len < 0) {
                throw new IllegalStateException(("InputStream error: len=" + len).toString());
            }
            if (len <= 0) break;
            offset2 += len;
        }
        if (!(remaining == 0)) {
            boolean bl = false;
            String string = "remaining == 0 : " + remaining;
            throw new IllegalStateException(string.toString());
        }
        return b;
    }
}

