/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import java.util.List;
import korlibs.wasm.DenoWasmProcessStdinKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"DenoWasmServerStdinCode", "", "PATHS", "", "getPATHS", "()Ljava/util/List;", "PATHS$delegate", "Lkotlin/Lazy;", "korge-core"})
public final class DenoWasmProcessStdinKt {
    @NotNull
    private static final Lazy PATHS$delegate = LazyKt.lazy(PATHS.2.INSTANCE);
    @NotNull
    private static final String DenoWasmServerStdinCode = "// ISOMORPHIC: works on Deno and node\nconst isDeno = (typeof Deno) !== \"undefined\";\nconst debugEnv = isDeno ? Deno.env.get(\"DEBUG\") : process.env\nconst debug = debugEnv == \"true\";\n//const debug = true\nconst fs = (isDeno) ? null : require('fs');\n\nif (debug) console.error('STARTED!', isDeno);\n\nfunction readSyncExact(reader, size) {\n  if (size >= 32 * 1024 * 1024) throw new Error(`too big to read ${size}`);\n  var out = new Uint8Array(size);\n  var pos = 0;\nif (debug) console.error('try_read', size)\n  while (pos < size) {\n    const chunk = out.subarray(pos)\n    var read = isDeno\n      ? reader.readSync(chunk)\n      : fs.readSync(reader, chunk);\n    if (debug) console.error('read', read)\n    if (read == null || read <= 0) throw Error(\"Broken pipe\");\n    pos += read;\n  }\n  return out;\n}\n\nfunction writeSyncExact(writer, data) {\n  var pos = 0;\n  while (pos < data.length) {\n    const chunk = data.subarray(pos)\n    var written = isDeno\n      ? writer.writeSync(chunk)\n      : fs.writeSync(writer, chunk);\n    if (written <= 0) throw Error(\"Broken pipe\");\n    pos += written;\n  }\n  return pos;\n}\n\nfunction readPacket(reader) {\n  const [kind, streamId, len] = new Int32Array(\n    (readSyncExact(reader, 12)).buffer,\n  );\n  const payload = readSyncExact(reader, len);\n  if (debug) {\n    console.error(\"   packet: \", \"id:\", streamId, \"kind:\", kind, \"len:\", len);\n  }\n  return { kind, streamId, payload };\n}\n\nfunction writePacket(writer, payload) {\n  const data = new Uint8Array(4 + payload.length);\n  const dview = new DataView(data.buffer);\n  dview.setInt32(0, payload.length, true);\n  data.set(payload, 4);\n  const written = writeSyncExact(writer, data);\n  if (written != data.length) {\n    throw new Error(\n      `Not written as many bytes as expected! ${written}, but expected ${data.length}`,\n    );\n  }\n}\n\nclass WasmModule {\n  constructor(\n    exports,\n    u8,\n  ) {\n    this.exports = exports\n    this.u8 = u8\n  }\n}\n\nconst wasmModules = new Map();\n\nfunction readAndProcessPacket(\n  reader,\n  writer,\n) {\n  const { kind, streamId, payload } = readPacket(reader);\n  const wasmModule = wasmModules.get(streamId);\n  // write bytes\n  switch (kind) {\n    case 1000: { // Load WASM module\n      const wasmModule = new WebAssembly.Module(payload);\n      if (debug) console.error(\"!!CMD: Loaded WASM... \", wasmModule);\n      const wasmInstance = new WebAssembly.Instance(wasmModule, {\n        \"wasi_snapshot_preview1\": {\n          proc_exit: () => console.error(arguments),\n          fd_close: () => console.error(arguments),\n          fd_write: () => console.error(arguments),\n          fd_seek: () => console.error(arguments),\n        },\n      });\n      wasmModules.set(\n        streamId,\n        new WasmModule(\n          wasmInstance.exports,\n          new Uint8Array((wasmInstance.exports.memory).buffer),\n        ),\n      );\n      writePacket(writer, new Uint8Array(0));\n      break;\n    }\n    case 1001: { // Unload WASM module and close connection\n      if (debug) console.error(\"!!CMD: Unload WASM...\");\n      wasmModules.delete(streamId);\n      writePacket(writer, new Uint8Array(0));\n      break;\n    }\n    case 1010: { // writeBytes\n      const [offset] = new Int32Array(payload.buffer, 0, 1);\n      const data = new Uint8Array(payload, 4);\n      if (debug) console.error(\"!!CMD: Write Bytes...\", offset, data.length);\n      wasmModule?.u8?.set(data, offset);\n      writePacket(writer, new Uint8Array(0));\n      break;\n    }\n    case 1011: { // allocAndWrite\n      let offset = 0;\n      if (wasmModule) {\n        offset = wasmModule.exports.malloc(payload.length);\n        if (debug) {\n          console.error(\"!!CMD: allocAndWrite...\", offset, payload.length);\n        }\n        wasmModule.u8?.set(payload, offset);\n      }\n      writePacket(writer, new Uint8Array(new Int32Array([offset]).buffer));\n      break;\n    }\n    case 1012: { // free\n      if (wasmModule) {\n        const ptrs = new Int32Array(payload.buffer);\n        for (const ptr of ptrs) {\n          if (ptr != 0) wasmModule.exports.free(ptr);\n        }\n        if (debug) console.error(\"!!CMD: free...\", ptrs);\n      }\n      writePacket(writer, new Uint8Array(0));\n      break;\n    }\n    case 1013: { // stackSave\n      const result = wasmModule.exports.stackSave();\n      if (debug) console.error(\"!!CMD: stackSave...\", \"->\", result);\n      writePacket(writer, new Uint8Array(new Int32Array([result]).buffer));\n      break;\n    }\n    case 1014: { // stackRestore\n      const [ptr] = new Int32Array(payload.buffer, 0, 1);\n      wasmModule.exports.stackRestore(ptr);\n      if (debug) console.error(\"!!CMD: stackRestore...\", ptr);\n      writePacket(writer, new Uint8Array(0));\n      break;\n    }\n    case 1015: { // stackAlloc\n      const [size] = new Int32Array(payload.buffer, 0, 1);\n      const result = wasmModule.exports.stackAlloc(size);\n      if (debug) console.error(\"!!CMD: stackAlloc...\", size, \"->\", result);\n      writePacket(writer, new Uint8Array(new Int32Array([result]).buffer));\n      break;\n    }\n    case 1016: { // stackAllocWrite\n      const ptr = wasmModule.exports.stackAlloc(payload.length);\n      wasmModule?.u8?.set(payload, ptr);\n      if (debug) console.error(\"!!CMD: stackAllocWrite...\", payload.length, \"->\", ptr);\n      writePacket(writer, new Uint8Array(new Int32Array([ptr]).buffer));\n      break;\n    }\n    case 1020: { // readBytes\n      const info = new Int32Array(payload.buffer);\n      const offset = info[0];\n      const len = info[1];\n      if (debug) console.error(\"!!CMD: Read Bytes...\", offset, len, payload);\n      writePacket(\n        writer,\n        wasmModule\n          ? new Uint8Array(wasmModule.u8.buffer, offset, len)\n          : new Uint8Array(len),\n      );\n      break;\n    }\n    case 1030: { // executeFunction\n      const json = JSON.parse(new TextDecoder().decode(payload));\n      if (debug) console.error(\"!!CMD: executeFunction...\", json);\n      let result = null;\n      try {\n        if (json.indirect !== undefined) {\n            result = wasmModule.exports.__indirect_function_table.get(json.indirect)(...json.params);\n        } else {\n            result = wasmModule.exports[json.func](...json.params);\n        }\n      } catch (e) {\n        console.error(e);\n        console.error(e.stack);\n      }\n      const resultPayload = new TextEncoder().encode(JSON.stringify(result));\n      if (debug) console.error(\"    -->\", result, resultPayload);\n      writePacket(writer, resultPayload);\n      break;\n    }\n    default:\n      console.error(`!!ERROR: Invalid message: ${kind}`);\n  }\n}\n\nfunction unhandledrejection(event) {\n  console.error(`UNHANDLED PROMISE REJECTION: ${event.reason}`);\n  console.error(event.reason.stack);\n  event.preventDefault();\n}\n\nif (isDeno) {\n  addEventListener(\"unhandledrejection\", unhandledrejection);\n} else {\n  process.on(\"unhandledrejection\", unhandledrejection);\n}\n\nlet running = true;\n\nwhile (running) {\n  if (isDeno) {\n    readAndProcessPacket(Deno.stdin, Deno.stdout);\n  } else {\n    // I think (pure conjecture) that process.stdin.fd is a getter that, when referenced, will put stdin in non-blocking mode (which is causing the error). When you use the file descriptor directly, you work around that.\n    // https://stackoverflow.com/questions/40362369/stdin-read-fails-on-some-input\n    //readAndProcessPacket(process.stdin.fd, process.stdout.fd);\n    readAndProcessPacket(0, 1);\n  }\n}";

    private static final List<String> getPATHS() {
        Lazy lazy = PATHS$delegate;
        return (List)lazy.getValue();
    }

    public static final /* synthetic */ String access$getDenoWasmServerStdinCode$p() {
        return DenoWasmServerStdinCode;
    }

    public static final /* synthetic */ List access$getPATHS() {
        return DenoWasmProcessStdinKt.getPATHS();
    }
}

