/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import java.util.Arrays;
import korlibs.datastructure.closeable.Closeable;
import korlibs.memory.ByteArrayGetSetKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0017\n\u0002\b\u000b\bf\u0018\u00002\u00060\u0001j\u0002`\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00020\u0011\"\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J/\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u001a\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bJ-\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u001a\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001eJ/\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u000b2\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u001a\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010!J-\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u001a\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010#J-\u0010$\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u001a\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0011H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020*H\u0016J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000bH\u0016J\b\u00100\u001a\u00020\u000bH\u0016J\u0018\u00101\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0004H\u0016J\u0018\u00102\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0011H\u0016J\u0018\u00103\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020*H\u0016J\f\u00104\u001a\u00020\u0004*\u00020\u0011H\u0016J\f\u00104\u001a\u00020\u0004*\u00020*H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u00065"}, d2={"Lkorlibs/wasm/IWASMLib;", "Lkorlibs/datastructure/closeable/Closeable;", "Lkorlibs/io/lang/Closeable;", "content", "", "getContent", "()[B", "isAvailable", "", "()Z", "allocBytes", "", "bytes", "size", "freeBytes", "", "ptrs", "", "initOnce", "context", "Lkotlin/coroutines/CoroutineContext;", "invokeFunc", "", "name", "", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeFuncFloat", "", "(Ljava/lang/String;[Ljava/lang/Object;)F", "invokeFuncIndirect", "address", "(I[Ljava/lang/Object;)Ljava/lang/Object;", "invokeFuncInt", "(Ljava/lang/String;[Ljava/lang/Object;)I", "invokeFuncUnit", "(Ljava/lang/String;[Ljava/lang/Object;)V", "readBytes", "pos", "readInts", "readShorts", "", "stackAlloc", "stackAllocAndWrite", "data", "stackRestore", "ptr", "stackSave", "writeBytes", "writeInts", "writeShorts", "toByteArray", "korge-core"})
public interface IWASMLib
extends Closeable {
    public boolean isAvailable();

    @NotNull
    public byte[] getContent();

    public void initOnce(@NotNull CoroutineContext var1);

    @NotNull
    public byte[] readBytes(int var1, int var2);

    public void writeBytes(int var1, @NotNull byte[] var2);

    @Nullable
    public Object invokeFunc(@NotNull String var1, Object ... var2);

    @Nullable
    public Object invokeFuncIndirect(int var1, Object ... var2);

    public float invokeFuncFloat(@NotNull String var1, Object ... var2);

    public int invokeFuncInt(@NotNull String var1, Object ... var2);

    public void invokeFuncUnit(@NotNull String var1, Object ... var2);

    @NotNull
    public short[] readShorts(int var1, int var2);

    @NotNull
    public int[] readInts(int var1, int var2);

    public void writeShorts(int var1, @NotNull short[] var2);

    public void writeInts(int var1, @NotNull int[] var2);

    @NotNull
    public byte[] toByteArray(@NotNull short[] var1);

    @NotNull
    public byte[] toByteArray(@NotNull int[] var1);

    public int allocBytes(int var1);

    public int allocBytes(@NotNull byte[] var1);

    public void freeBytes(int ... var1);

    public int stackSave();

    public void stackRestore(int var1);

    public int stackAlloc(int var1);

    public int stackAllocAndWrite(@NotNull byte[] var1);

    public int stackAllocAndWrite(@NotNull short[] var1);

    public int stackAllocAndWrite(@NotNull int[] var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nWASMLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WASMLib.kt\nkorlibs/wasm/IWASMLib$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
    public static final class DefaultImpls {
        public static boolean isAvailable(@NotNull IWASMLib $this) {
            return true;
        }

        public static void initOnce(@NotNull IWASMLib $this, @NotNull CoroutineContext context2) {
        }

        @NotNull
        public static byte[] readBytes(@NotNull IWASMLib $this, int pos, int size2) {
            throw new NotImplementedError(null, 1, null);
        }

        public static void writeBytes(@NotNull IWASMLib $this, int pos, @NotNull byte[] data2) {
            throw new NotImplementedError(null, 1, null);
        }

        @Nullable
        public static Object invokeFunc(@NotNull IWASMLib $this, @NotNull String name2, Object ... params) {
            throw new NotImplementedError(null, 1, null);
        }

        @Nullable
        public static Object invokeFuncIndirect(@NotNull IWASMLib $this, int address, Object ... params) {
            throw new NotImplementedError(null, 1, null);
        }

        public static float invokeFuncFloat(@NotNull IWASMLib $this, @NotNull String name2, Object ... params) {
            Object object = $this.invokeFunc(name2, Arrays.copyOf(params, params.length));
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
            return ((Number)object).floatValue();
        }

        public static int invokeFuncInt(@NotNull IWASMLib $this, @NotNull String name2, Object ... params) {
            Object object = $this.invokeFunc(name2, Arrays.copyOf(params, params.length));
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            return number != null ? number.intValue() : 0;
        }

        public static void invokeFuncUnit(@NotNull IWASMLib $this, @NotNull String name2, Object ... params) {
            $this.invokeFunc(name2, Arrays.copyOf(params, params.length));
        }

        @NotNull
        public static short[] readShorts(@NotNull IWASMLib $this, int pos, int size2) {
            byte[] bytes = $this.readBytes(pos, size2 * 2);
            int n = 0;
            short[] sArray = new short[size2];
            while (n < size2) {
                int n2 = n++;
                sArray[n2] = (short)ByteArrayGetSetKt.getS16LE(bytes, n2 * 2);
            }
            return sArray;
        }

        @NotNull
        public static int[] readInts(@NotNull IWASMLib $this, int pos, int size2) {
            byte[] bytes = $this.readBytes(pos, size2 * 4);
            int n = 0;
            int[] nArray = new int[size2];
            while (n < size2) {
                int n2 = n++;
                nArray[n2] = ByteArrayGetSetKt.getS32LE(bytes, n2 * 4);
            }
            return nArray;
        }

        public static void writeShorts(@NotNull IWASMLib $this, int pos, @NotNull short[] data2) {
            $this.writeBytes(pos, $this.toByteArray(data2));
        }

        public static void writeInts(@NotNull IWASMLib $this, int pos, @NotNull int[] data2) {
            $this.writeBytes(pos, $this.toByteArray(data2));
        }

        @NotNull
        public static byte[] toByteArray(@NotNull IWASMLib $this, @NotNull short[] $receiver) {
            byte[] byArray;
            byte[] out = byArray = new byte[$receiver.length * 2];
            boolean bl = false;
            int n = $receiver.length;
            for (int n2 = 0; n2 < n; ++n2) {
                ByteArrayGetSetKt.set16LE(out, n2 * 2, $receiver[n2]);
            }
            return byArray;
        }

        @NotNull
        public static byte[] toByteArray(@NotNull IWASMLib $this, @NotNull int[] $receiver) {
            byte[] byArray;
            byte[] out = byArray = new byte[$receiver.length * 4];
            boolean bl = false;
            int n = $receiver.length;
            for (int n2 = 0; n2 < n; ++n2) {
                ByteArrayGetSetKt.set16LE(out, n2 * 4, $receiver[n2]);
            }
            return byArray;
        }

        public static int allocBytes(@NotNull IWASMLib $this, int size2) {
            Object[] objectArray = new Object[]{size2};
            return $this.invokeFuncInt("malloc", objectArray);
        }

        public static int allocBytes(@NotNull IWASMLib $this, @NotNull byte[] bytes) {
            int n;
            int it = n = $this.allocBytes(bytes.length);
            boolean bl = false;
            $this.writeBytes(it, bytes);
            return n;
        }

        public static void freeBytes(@NotNull IWASMLib $this, int ... ptrs) {
            for (int ptr : ptrs) {
                Object[] objectArray = new Object[]{ptr};
                $this.invokeFunc("free", objectArray);
            }
        }

        public static int stackSave(@NotNull IWASMLib $this) {
            return $this.invokeFuncInt("stackSave", new Object[0]);
        }

        public static void stackRestore(@NotNull IWASMLib $this, int ptr) {
            Object[] objectArray = new Object[]{ptr};
            $this.invokeFuncUnit("stackRestore", objectArray);
        }

        public static int stackAlloc(@NotNull IWASMLib $this, int size2) {
            Object[] objectArray = new Object[]{size2};
            return $this.invokeFuncInt("stackAlloc", objectArray);
        }

        public static int stackAllocAndWrite(@NotNull IWASMLib $this, @NotNull byte[] bytes) {
            int n;
            int it = n = $this.stackAlloc(bytes.length);
            boolean bl = false;
            $this.writeBytes(it, bytes);
            return n;
        }

        public static int stackAllocAndWrite(@NotNull IWASMLib $this, @NotNull short[] data2) {
            return $this.stackAllocAndWrite($this.toByteArray(data2));
        }

        public static int stackAllocAndWrite(@NotNull IWASMLib $this, @NotNull int[] data2) {
            return $this.stackAllocAndWrite($this.toByteArray(data2));
        }
    }
}

