/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.io.lang.ExceptionsKt;
import korlibs.io.lang.UTF8Kt;
import korlibs.io.stream.SyncStream;
import korlibs.io.stream.SyncStreamKt;
import korlibs.util.StringformatKt;
import korlibs.wasm.NamedWasmType;
import korlibs.wasm.WasmCode;
import korlibs.wasm.WasmData;
import korlibs.wasm.WasmElement;
import korlibs.wasm.WasmExport;
import korlibs.wasm.WasmExpr;
import korlibs.wasm.WasmFunc;
import korlibs.wasm.WasmFuncRef;
import korlibs.wasm.WasmGlobal;
import korlibs.wasm.WasmImport;
import korlibs.wasm.WasmInstruction;
import korlibs.wasm.WasmModule;
import korlibs.wasm.WasmOp;
import korlibs.wasm.WasmType;
import korlibs.wasm.WastLocal;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0086\u00012\u00020\u0001:\u0002\u0086\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0016J\u0010\u0010I\u001a\u0004\u0018\u00010)2\u0006\u0010J\u001a\u00020#J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020OJ\u0017\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020#0SH\u0082\bJ\n\u0010T\u001a\u00020\u0004*\u00020MJ\n\u0010U\u001a\u00020V*\u00020MJ\n\u0010W\u001a\u00020X*\u00020MJ\u0010\u0010Y\u001a\b\u0012\u0004\u0012\u00020V0\u0010*\u00020MJ\n\u0010Z\u001a\u00020Q*\u00020MJ\u0012\u0010[\u001a\u00020\u0011*\u00020M2\u0006\u0010\\\u001a\u00020\u0004J\n\u0010]\u001a\u00020Q*\u00020MJ\n\u0010^\u001a\u00020Q*\u00020MJ\n\u0010_\u001a\u00020\u001b*\u00020MJ\n\u0010`\u001a\u00020Q*\u00020MJ\n\u0010a\u001a\u00020\u001e*\u00020MJ\n\u0010b\u001a\u00020Q*\u00020MJ\n\u0010c\u001a\u00020d*\u00020MJ\n\u0010e\u001a\u00020\u0004*\u00020MJ\n\u0010f\u001a\u00020Q*\u00020MJ\n\u0010g\u001a\u00020.*\u00020MJ\n\u0010h\u001a\u00020Q*\u00020MJ\n\u0010i\u001a\u00020V*\u00020MJ\n\u0010j\u001a\u000203*\u00020MJ\n\u0010k\u001a\u00020Q*\u00020MJ\n\u0010l\u001a\u00020m*\u00020MJ\n\u0010n\u001a\u00020\u0004*\u00020MJ\n\u0010o\u001a\u00020p*\u00020MJ\n\u0010q\u001a\u00020\u0004*\u00020MJ\n\u0010r\u001a\u00020p*\u00020MJ\u001e\u0010s\u001a\u00020\u0004*\u00020M2\u0006\u0010t\u001a\u00020\u00162\b\b\u0002\u0010u\u001a\u00020\u0004H\u0002J\u001e\u0010v\u001a\u00020p*\u00020M2\u0006\u0010t\u001a\u00020\u00162\b\b\u0002\u0010u\u001a\u00020\u0004H\u0002J\n\u0010w\u001a\u00020Q*\u00020MJ\n\u0010x\u001a\u00020=*\u00020MJ\n\u0010y\u001a\u00020\u0000*\u00020MJ\n\u0010z\u001a\u00020#*\u00020MJ\n\u0010{\u001a\u00020Q*\u00020MJ\n\u0010|\u001a\u00020Q*\u00020MJ\n\u0010}\u001a\u00020\u0004*\u00020MJ\n\u0010~\u001a\u00020Q*\u00020MJ\u000e\u0010\u007f\u001a\u0006\u0012\u0002\b\u00030B*\u00020MJ\u000b\u0010\u0080\u0001\u001a\u00020V*\u00020MJ\u000b\u0010\u0081\u0001\u001a\u00020Q*\u00020MJ0\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0083\u00010\u0010\"\u0005\b\u0000\u0010\u0083\u0001*\u00020M2\u0015\u0010\u0084\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0005\u0012\u0003H\u0083\u00010\u0085\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R'\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001e0\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%RV\u0010+\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020)0(j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020)`*2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020)0(j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020)`*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-RV\u0010/\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020.0(j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020.`*2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020.0(j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020.`*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010-R\u0011\u00101\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0006R*\u00104\u001a\b\u0012\u0004\u0012\u0002030\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002030\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0014R\u0019\u00106\u001a\b\u0012\u0004\u0012\u00020\u000407\u00a2\u0006\n\n\u0002\u0010:\u001a\u0004\b8\u00109R\u0019\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000407\u00a2\u0006\n\n\u0002\u0010:\u001a\u0004\b<\u00109R*\u0010>\u001a\b\u0012\u0004\u0012\u00020=0\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020=0\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0014R\u001e\u0010@\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0006R2\u0010C\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030B0\u00102\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030B0\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0014R*\u0010F\u001a\b\u0012\u0004\u0012\u00020E0\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020E0\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0014\u00a8\u0006\u0087\u0001"}, d2={"Lkorlibs/wasm/WasmReaderBinary;", "", "()V", "INDEX_FUNCTIONS", "", "getINDEX_FUNCTIONS", "()I", "INDEX_GLOBALS", "getINDEX_GLOBALS", "INDEX_MEMTYPES", "getINDEX_MEMTYPES", "INDEX_TABLES", "getINDEX_TABLES", "<set-?>", "dataCount", "getDataCount", "", "Lkorlibs/wasm/WasmData;", "datas", "getDatas", "()Ljava/util/List;", "doTrace", "", "getDoTrace", "()Z", "setDoTrace", "(Z)V", "Lkorlibs/wasm/WasmElement;", "elements", "getElements", "Lkorlibs/wasm/WasmExport;", "exports", "getExports", "exportsByName", "", "", "getExportsByName", "()Ljava/util/Map;", "exportsByName$delegate", "Lkotlin/Lazy;", "Ljava/util/LinkedHashMap;", "Lkorlibs/wasm/WasmFunc;", "Lkotlin/collections/LinkedHashMap;", "functions", "getFunctions", "()Ljava/util/LinkedHashMap;", "Lkorlibs/wasm/WasmGlobal;", "globals", "getGlobals", "importFunctionsOffset", "getImportFunctionsOffset", "Lkorlibs/wasm/WasmImport;", "imports", "getImports", "importsInTables", "", "getImportsInTables", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "indicesInTables", "getIndicesInTables", "Lkorlibs/wasm/WasmType$Limit;", "memories", "getMemories", "startFunc", "getStartFunc", "Lkorlibs/wasm/WasmType$TableType;", "tables", "getTables", "Lkorlibs/wasm/NamedWasmType;", "types", "getTypes", "value", "getFuncByName", "name", "read", "s", "Lkorlibs/io/stream/SyncStream;", "toModule", "Lkorlibs/wasm/WasmModule;", "trace", "", "str", "Lkotlin/Function0;", "peekU8", "readBlockType", "Lkorlibs/wasm/WasmType;", "readCode", "Lkorlibs/wasm/WasmCode;", "readCodeLocals", "readCodeSection", "readData", "index", "readDataCountSection", "readDataSection", "readElement", "readElementSection", "readExport", "readExportSection", "readExpr", "Lkorlibs/wasm/WasmExpr;", "readFuncIdx", "readFunctionSection", "readGlobal", "readGlobalSection", "readGlobalType", "readImport", "readImportSection", "readInstr", "Lkorlibs/wasm/WasmInstruction;", "readLEB128", "readLEB128Long", "", "readLEB128S", "readLEB128SLong", "readLEB128_I", "signed", "bits", "readLEB128_L", "readMemorySection", "readMemtype", "readModule", "readName", "readSection", "readStartSection", "readTableIdx", "readTableSection", "readTableType", "readType", "readTypesSection", "readVec", "T", "callback", "Lkotlin/Function1;", "Companion", "korge-core"})
@SourceDebugExtension(value={"SMAP\nWasmReaderBinary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmReaderBinary.kt\nkorlibs/wasm/WasmReaderBinary\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SyncStream.kt\nkorlibs/io/stream/SyncStreamKt\n*L\n1#1,478:1\n197#1,2:479\n197#1,2:485\n197#1,2:487\n197#1,2:489\n197#1,2:491\n197#1,2:493\n197#1,2:495\n197#1,2:497\n197#1,2:499\n197#1,2:501\n197#1,2:503\n197#1,2:505\n197#1,2:507\n1549#2:481\n1620#2,3:482\n1549#2:514\n1620#2,3:515\n190#3,5:509\n*S KotlinDebug\n*F\n+ 1 WasmReaderBinary.kt\nkorlibs/wasm/WasmReaderBinary\n*L\n156#1:479,2\n180#1:485,2\n187#1:487,2\n222#1:489,2\n285#1:491,2\n292#1:493,2\n297#1:495,2\n328#1:497,2\n336#1:499,2\n345#1:501,2\n354#1:503,2\n369#1:505,2\n376#1:507,2\n163#1:481\n163#1:482,3\n412#1:514\n412#1:515,3\n409#1:509,5\n*E\n"})
public final class WasmReaderBinary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<NamedWasmType> types = CollectionsKt.emptyList();
    @NotNull
    private List<? extends WasmType.TableType<?>> tables = CollectionsKt.emptyList();
    @NotNull
    private List<WasmType.Limit> memories = CollectionsKt.emptyList();
    @NotNull
    private LinkedHashMap<Integer, WasmFunc> functions = new LinkedHashMap();
    @NotNull
    private LinkedHashMap<Integer, WasmGlobal> globals = new LinkedHashMap();
    @NotNull
    private List<WasmElement> elements = CollectionsKt.emptyList();
    @NotNull
    private List<WasmImport> imports = CollectionsKt.emptyList();
    @NotNull
    private List<WasmExport> exports = CollectionsKt.emptyList();
    @NotNull
    private List<WasmData> datas = CollectionsKt.emptyList();
    private int startFunc = -1;
    private int dataCount = -1;
    @NotNull
    private final Lazy exportsByName$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends WasmExport>>(this){
        final /* synthetic */ WasmReaderBinary this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, WasmExport> invoke() {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = this.this$0.getExports();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (T element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                WasmExport wasmExport = (WasmExport)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getName(), element$iv$iv);
            }
            return destination$iv$iv;
        }
    });
    private boolean doTrace;
    private final int INDEX_FUNCTIONS;
    private final int INDEX_TABLES;
    private final int INDEX_MEMTYPES;
    private final int INDEX_GLOBALS;
    @NotNull
    private final Integer[] indicesInTables;
    @NotNull
    private final Integer[] importsInTables;
    @NotNull
    private static final WasmType.Function INT_FUNC_TYPE = new WasmType.Function(CollectionsKt.emptyList(), CollectionsKt.listOf(WasmType.Companion.getI32()));

    public WasmReaderBinary() {
        this.INDEX_TABLES = 1;
        this.INDEX_MEMTYPES = 2;
        this.INDEX_GLOBALS = 3;
        Integer[] integerArray = new Integer[]{0, 0, 0, 0};
        this.indicesInTables = integerArray;
        integerArray = new Integer[]{0, 0, 0, 0};
        this.importsInTables = integerArray;
    }

    @NotNull
    public final WasmModule toModule() {
        Collection<WasmFunc> collection = this.functions.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        List list2 = CollectionsKt.toList((Iterable)collection);
        Collection<WasmGlobal> collection2 = this.globals.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        return new WasmModule(list2, this.datas, this.types, CollectionsKt.toList((Iterable)collection2), CollectionsKt.toList((Iterable)this.elements), this.tables, this.memories, this.exports, this.startFunc, null, 512, null);
    }

    @NotNull
    public final WasmReaderBinary read(@NotNull SyncStream s) {
        return this.readModule(s);
    }

    private final long readLEB128_L(SyncStream $this$readLEB128_L, boolean signed, int bits) {
        long l;
        long result2 = 0L;
        int shift = 0;
        do {
            l = SyncStreamKt.readU8($this$readLEB128_L);
            result2 |= (l & 0x7FL) << shift;
            shift += 7;
        } while ((l & 0x80L) != 0L);
        if (signed && shift < bits && (l & 0x40L) != 0L) {
            return result2 | -1L << shift;
        }
        return result2;
    }

    static /* synthetic */ long readLEB128_L$default(WasmReaderBinary wasmReaderBinary, SyncStream syncStream, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 64;
        }
        return wasmReaderBinary.readLEB128_L(syncStream, bl, n);
    }

    private final int readLEB128_I(SyncStream $this$readLEB128_I, boolean signed, int bits) {
        int n;
        int result2 = 0;
        int shift = 0;
        do {
            n = SyncStreamKt.readU8($this$readLEB128_I);
            result2 |= (n & 0x7F) << shift;
            shift += 7;
        } while ((n & 0x80) != 0);
        if (signed && shift < bits && (n & 0x40) != 0) {
            return result2 | -1 << shift;
        }
        return result2;
    }

    static /* synthetic */ int readLEB128_I$default(WasmReaderBinary wasmReaderBinary, SyncStream syncStream, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 32;
        }
        return wasmReaderBinary.readLEB128_I(syncStream, bl, n);
    }

    public final int readLEB128(@NotNull SyncStream $this$readLEB128) {
        return this.readLEB128_I($this$readLEB128, false, 32);
    }

    public final int readLEB128S(@NotNull SyncStream $this$readLEB128S) {
        return this.readLEB128_I($this$readLEB128S, true, 32);
    }

    public final long readLEB128Long(@NotNull SyncStream $this$readLEB128Long) {
        return WasmReaderBinary.readLEB128_L$default(this, $this$readLEB128Long, false, 0, 2, null);
    }

    public final long readLEB128SLong(@NotNull SyncStream $this$readLEB128SLong) {
        return WasmReaderBinary.readLEB128_L$default(this, $this$readLEB128SLong, true, 0, 2, null);
    }

    @NotNull
    public final String readName(@NotNull SyncStream $this$readName) {
        return SyncStreamKt.readString($this$readName, this.readLEB128($this$readName), UTF8Kt.getUTF8());
    }

    @NotNull
    public final List<NamedWasmType> getTypes() {
        return this.types;
    }

    @NotNull
    public final List<WasmType.TableType<?>> getTables() {
        return this.tables;
    }

    @NotNull
    public final List<WasmType.Limit> getMemories() {
        return this.memories;
    }

    @NotNull
    public final LinkedHashMap<Integer, WasmFunc> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final LinkedHashMap<Integer, WasmGlobal> getGlobals() {
        return this.globals;
    }

    @NotNull
    public final List<WasmElement> getElements() {
        return this.elements;
    }

    @NotNull
    public final List<WasmImport> getImports() {
        return this.imports;
    }

    @NotNull
    public final List<WasmExport> getExports() {
        return this.exports;
    }

    @NotNull
    public final List<WasmData> getDatas() {
        return this.datas;
    }

    public final int getStartFunc() {
        return this.startFunc;
    }

    public final int getDataCount() {
        return this.dataCount;
    }

    @NotNull
    public final Map<String, WasmExport> getExportsByName() {
        Lazy lazy = this.exportsByName$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final WasmFunc getFuncByName(@NotNull String name2) {
        WasmExport wasmExport = this.getExportsByName().get(name2);
        Object object = wasmExport != null ? wasmExport.getObj() : null;
        return object instanceof WasmFunc ? (WasmFunc)object : null;
    }

    @NotNull
    public final WasmReaderBinary readModule(@NotNull SyncStream $this$readModule) {
        if (!Intrinsics.areEqual(SyncStreamKt.readString$default($this$readModule, 4, null, 2, null), "\u0000asm")) {
            ExceptionsKt.invalidOp("Not a WASM file");
            throw new KotlinNothingValueException();
        }
        int version = SyncStreamKt.readS32LE($this$readModule);
        if (version != 1) {
            throw new IllegalStateException("Only WASM version 1 supported".toString());
        }
        while (!SyncStreamKt.getEof($this$readModule)) {
            this.readSection($this$readModule);
        }
        return this;
    }

    public final void readSection(@NotNull SyncStream $this$readSection) {
        SyncStream content2;
        SyncStream syncStream;
        int type2 = this.readLEB128($this$readSection);
        int len = this.readLEB128($this$readSection);
        SyncStream $this$readSection_u24lambda_u240 = syncStream = (content2 = SyncStreamKt.readStream($this$readSection, len));
        boolean bl = false;
        switch (type2) {
            case 0: {
                String name2 = SyncStreamKt.readStringVL$default($this$readSection_u24lambda_u240, null, 1, null);
                System.out.println((Object)("Unsupported custom section " + type2 + " '" + name2 + "'"));
                break;
            }
            case 1: {
                this.readTypesSection($this$readSection_u24lambda_u240);
                break;
            }
            case 2: {
                this.readImportSection($this$readSection_u24lambda_u240);
                break;
            }
            case 3: {
                this.readFunctionSection($this$readSection_u24lambda_u240);
                break;
            }
            case 4: {
                this.readTableSection($this$readSection_u24lambda_u240);
                break;
            }
            case 5: {
                this.readMemorySection($this$readSection_u24lambda_u240);
                break;
            }
            case 6: {
                this.readGlobalSection($this$readSection_u24lambda_u240);
                break;
            }
            case 7: {
                this.readExportSection($this$readSection_u24lambda_u240);
                break;
            }
            case 8: {
                this.readStartSection($this$readSection_u24lambda_u240);
                break;
            }
            case 9: {
                this.readElementSection($this$readSection_u24lambda_u240);
                break;
            }
            case 10: {
                this.readCodeSection($this$readSection_u24lambda_u240);
                break;
            }
            case 11: {
                this.readDataSection($this$readSection_u24lambda_u240);
                break;
            }
            case 12: {
                this.readDataCountSection($this$readSection_u24lambda_u240);
                break;
            }
            default: {
                System.out.println((Object)("Unsupported section " + type2));
            }
        }
    }

    @NotNull
    public final WasmData readData(@NotNull SyncStream $this$readData, int index2) {
        int memindex = this.readLEB128($this$readData);
        WasmExpr expr2 = this.readExpr($this$readData);
        byte[] data2 = SyncStreamKt.readBytesExact($this$readData, this.readLEB128($this$readData));
        return new WasmData(memindex, data2, index2, expr2);
    }

    public final void readDataSection(@NotNull SyncStream $this$readDataSection) {
        this.datas = this.readVec($this$readDataSection, (Function1)new Function1<Integer, WasmData>(this, $this$readDataSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readDataSection;
            {
                this.this$0 = $receiver;
                this.$this_readDataSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmData invoke(int it) {
                return this.this$0.readData(this.$this_readDataSection, it);
            }
        });
        Iterator<WasmData> iterator2 = this.datas.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            WasmData data2 = iterator2.next();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// DATA[" + index2 + "]: " + data2.getData().length + ": " + data2.getMemindex() + ", " + data2.getE()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WasmType> readCodeLocals(@NotNull SyncStream $this$readCodeLocals) {
        void $this$mapTo$iv$iv;
        int n = this.readLEB128($this$readCodeLocals);
        WasmType type2 = this.readType($this$readCodeLocals);
        Iterable $this$map$iv = RangesKt.until(0, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(type2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final WasmCode readCode(@NotNull SyncStream $this$readCode) {
        int size2 = this.readLEB128($this$readCode);
        SyncStream ss2 = SyncStreamKt.openSync$default(SyncStreamKt.readBytesExact($this$readCode, size2), null, 1, null);
        List locals2 = this.readVec(ss2, (Function1)new Function1<Integer, List<? extends WastLocal>>(this, ss2){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $ss;
            {
                this.this$0 = $receiver;
                this.$ss = $ss;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<WastLocal> invoke(int index2) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.this$0.readCodeLocals(this.$ss);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    WasmType wasmType = (WasmType)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new WastLocal(index2, (WasmType)it));
                }
                return (List)destination$iv$iv;
            }
        });
        WasmExpr expr2 = this.readExpr(ss2);
        return new WasmCode(null, locals2, expr2);
    }

    /*
     * WARNING - void declaration
     */
    public final void readCodeSection(@NotNull SyncStream $this$readCodeSection) {
        int offset2 = this.getImportFunctionsOffset();
        Iterator<Object> iterator2 = this.readVec($this$readCodeSection, (Function1)new Function1<Integer, WasmCode>(this, $this$readCodeSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readCodeSection;
            {
                this.this$0 = $receiver;
                this.$this_readCodeSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmCode invoke(int it) {
                return this.this$0.readCode(this.$this_readCodeSection);
            }
        }).iterator();
        boolean n = false;
        while (iterator2.hasNext()) {
            void entry2;
            void index2 = entry2++;
            WasmCode code = (WasmCode)iterator2.next();
            WasmFunc wasmFunc = this.functions.get(offset2 + index2);
            if (wasmFunc == null) continue;
            wasmFunc.setCode(code);
        }
        for (Map.Entry entry2 : ((Map)this.functions).entrySet()) {
            int index2 = ((Number)entry2.getKey()).intValue();
            WasmFunc func2 = (WasmFunc)entry2.getValue();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// CODE[" + index2 + "]: " + func2.getCode()));
        }
    }

    public final void readTypesSection(@NotNull SyncStream $this$readTypesSection) {
        this.types = this.readVec($this$readTypesSection, (Function1)new Function1<Integer, NamedWasmType>(this, $this$readTypesSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readTypesSection;
            {
                this.this$0 = $receiver;
                this.$this_readTypesSection = $receiver2;
                super(1);
            }

            @NotNull
            public final NamedWasmType invoke(int it) {
                return new NamedWasmType(it, "type" + it, this.this$0.readType(this.$this_readTypesSection));
            }
        });
        Iterator<NamedWasmType> iterator2 = this.types.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            NamedWasmType type2 = iterator2.next();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// TYPE[" + index2 + "]: " + type2));
        }
    }

    public final boolean getDoTrace() {
        return this.doTrace;
    }

    public final void setDoTrace(boolean bl) {
        this.doTrace = bl;
    }

    @NotNull
    public final WasmReaderBinary doTrace(boolean value) {
        this.doTrace = value;
        return this;
    }

    private final void trace(Function0<String> str) {
        boolean $i$f$trace = false;
        if (this.doTrace) {
            System.out.println((Object)str.invoke());
        }
    }

    @NotNull
    public final WasmType readType(@NotNull SyncStream $this$readType) {
        WasmType wasmType;
        int type2 = SyncStreamKt.readU8($this$readType);
        switch (type2) {
            case 64: {
                wasmType = WasmType.Companion.getVoid();
                break;
            }
            case 96: {
                wasmType = new WasmType.Function(this.readVec($this$readType, (Function1)new Function1<Integer, WastLocal>(this, $this$readType){
                    final /* synthetic */ WasmReaderBinary this$0;
                    final /* synthetic */ SyncStream $this_readType;
                    {
                        this.this$0 = $receiver;
                        this.$this_readType = $receiver2;
                        super(1);
                    }

                    @NotNull
                    public final WastLocal invoke(int it) {
                        return new WastLocal(it, this.this$0.readType(this.$this_readType));
                    }
                }), this.readVec($this$readType, (Function1)new Function1<Integer, WasmType>(this, $this$readType){
                    final /* synthetic */ WasmReaderBinary this$0;
                    final /* synthetic */ SyncStream $this_readType;
                    {
                        this.this$0 = $receiver;
                        this.$this_readType = $receiver2;
                        super(1);
                    }

                    @NotNull
                    public final WasmType invoke(int it) {
                        return this.this$0.readType(this.$this_readType);
                    }
                }));
                break;
            }
            case 111: {
                String string = "externref";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 112: {
                String string = "funcref";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 127: {
                wasmType = WasmType.Companion.getI32();
                break;
            }
            case 123: {
                wasmType = WasmType.v128.INSTANCE;
                break;
            }
            case 126: {
                wasmType = WasmType.Companion.getI64();
                break;
            }
            case 125: {
                wasmType = WasmType.Companion.getF32();
                break;
            }
            case 124: {
                wasmType = WasmType.Companion.getF64();
                break;
            }
            default: {
                ExceptionsKt.invalidOp("Unknown type " + type2);
                throw new KotlinNothingValueException();
            }
        }
        return wasmType;
    }

    @NotNull
    public final WasmType readBlockType(@NotNull SyncStream $this$readBlockType) {
        return this.readType($this$readBlockType);
    }

    public final void readImportSection(@NotNull SyncStream $this$readImportSection) {
        this.imports = this.readVec($this$readImportSection, (Function1)new Function1<Integer, WasmImport>(this, $this$readImportSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readImportSection;
            {
                this.this$0 = $receiver;
                this.$this_readImportSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmImport invoke(int it) {
                return this.this$0.readImport(this.$this_readImportSection);
            }
        });
        Iterator<WasmImport> iterator2 = this.imports.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            WasmImport wasmImport = iterator2.next();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// IMPORT[" + index2 + "]: " + wasmImport));
        }
    }

    @NotNull
    public final WasmType.Limit readMemtype(@NotNull SyncStream $this$readMemtype) {
        WasmType.Limit limit;
        int limitType = SyncStreamKt.readU8($this$readMemtype);
        switch (limitType) {
            case 0: {
                limit = new WasmType.Limit(this.readLEB128($this$readMemtype), null);
                break;
            }
            case 1: {
                limit = new WasmType.Limit(this.readLEB128($this$readMemtype), this.readLEB128($this$readMemtype));
                break;
            }
            default: {
                ExceptionsKt.invalidOp("invalid limitType " + limitType);
                throw new KotlinNothingValueException();
            }
        }
        return limit;
    }

    @NotNull
    public final WasmType.TableType<?> readTableType(@NotNull SyncStream $this$readTableType) {
        int elemType = SyncStreamKt.readU8($this$readTableType);
        if (elemType != 112) {
            ExceptionsKt.invalidOp("Invalid elementType " + elemType);
            throw new KotlinNothingValueException();
        }
        return new WasmType.TableType(this.readMemtype($this$readTableType), Reflection.getOrCreateKotlinClass(WasmFuncRef.class));
    }

    @NotNull
    public final WasmType readGlobalType(@NotNull SyncStream $this$readGlobalType) {
        WasmType t = this.readType($this$readGlobalType);
        int mut = SyncStreamKt.readU8($this$readGlobalType);
        return mut != 0 ? (WasmType)new WasmType.Mutable(t) : t;
    }

    public final int getINDEX_FUNCTIONS() {
        return this.INDEX_FUNCTIONS;
    }

    public final int getINDEX_TABLES() {
        return this.INDEX_TABLES;
    }

    public final int getINDEX_MEMTYPES() {
        return this.INDEX_MEMTYPES;
    }

    public final int getINDEX_GLOBALS() {
        return this.INDEX_GLOBALS;
    }

    @NotNull
    public final Integer[] getIndicesInTables() {
        return this.indicesInTables;
    }

    @NotNull
    public final Integer[] getImportsInTables() {
        return this.importsInTables;
    }

    public final int getImportFunctionsOffset() {
        return this.importsInTables[this.INDEX_FUNCTIONS];
    }

    @NotNull
    public final WasmImport readImport(@NotNull SyncStream $this$readImport) {
        Object object;
        String moduleName = this.readName($this$readImport);
        String name2 = this.readName($this$readImport);
        int indexSpace = SyncStreamKt.readU8($this$readImport);
        Integer[] integerArray = this.indicesInTables;
        int n = integerArray[indexSpace];
        integerArray[indexSpace] = n + 1;
        int index2 = n;
        this.importsInTables[indexSpace] = this.indicesInTables[indexSpace];
        n = indexSpace;
        if (n == this.INDEX_FUNCTIONS) {
            object = this.types.get(this.readLEB128($this$readImport)).getType();
        } else if (n == this.INDEX_TABLES) {
            object = this.readTableType($this$readImport);
        } else if (n == this.INDEX_MEMTYPES) {
            object = this.readMemtype($this$readImport);
        } else if (n == this.INDEX_GLOBALS) {
            object = this.readGlobalType($this$readImport);
        } else {
            ExceptionsKt.invalidOp("Unsupported import=" + indexSpace);
            throw new KotlinNothingValueException();
        }
        Object type2 = object;
        WasmImport fimport = new WasmImport(moduleName, name2, indexSpace, index2, type2);
        int n2 = indexSpace;
        if (n2 == this.INDEX_FUNCTIONS) {
            Integer n3 = index2;
            Map map2 = this.functions;
            Intrinsics.checkNotNull(type2, "null cannot be cast to non-null type korlibs.wasm.WasmType.Function");
            map2.put(n3, new WasmFunc(index2, (WasmType.Function)type2, null, fimport, null, 16, null));
        } else if (n2 == this.INDEX_GLOBALS) {
            Integer n4 = index2;
            Map map3 = this.globals;
            Intrinsics.checkNotNull(type2, "null cannot be cast to non-null type korlibs.wasm.WasmType");
            map3.put(n4, new WasmGlobal((WasmType)type2, index2, null, fimport, null, 16, null));
        }
        return fimport;
    }

    public final void readExportSection(@NotNull SyncStream $this$readExportSection) {
        this.exports = this.readVec($this$readExportSection, (Function1)new Function1<Integer, WasmExport>(this, $this$readExportSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readExportSection;
            {
                this.this$0 = $receiver;
                this.$this_readExportSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmExport invoke(int it) {
                return this.this$0.readExport(this.$this_readExportSection);
            }
        });
        Iterator<WasmExport> iterator2 = this.exports.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            WasmExport export = iterator2.next();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// EXPORT[" + index2 + "]: " + export));
        }
    }

    public final void readStartSection(@NotNull SyncStream $this$readStartSection) {
        this.startFunc = this.readLEB128($this$readStartSection);
        WasmReaderBinary this_$iv = this;
        boolean $i$f$trace = false;
        if (this_$iv.doTrace) {
            boolean bl = false;
            System.out.println((Object)("// START: " + this.startFunc));
        }
    }

    public final void readDataCountSection(@NotNull SyncStream $this$readDataCountSection) {
        this.dataCount = this.readLEB128($this$readDataCountSection);
        WasmReaderBinary this_$iv = this;
        boolean $i$f$trace = false;
        if (this_$iv.doTrace) {
            boolean bl = false;
            System.out.println((Object)("// DATA_COUNT: " + this.dataCount));
        }
    }

    @NotNull
    public final WasmExport readExport(@NotNull SyncStream $this$readExport) {
        WasmExport export;
        block7: {
            Object object;
            String name2 = this.readName($this$readExport);
            int tid = SyncStreamKt.readU8($this$readExport);
            int idx = this.readLEB128($this$readExport);
            switch (tid) {
                case 0: {
                    object = this.functions.get(idx);
                    break;
                }
                case 1: {
                    object = this.tables.get(idx);
                    break;
                }
                case 2: {
                    object = this.memories.get(idx);
                    break;
                }
                case 3: {
                    object = this.globals.get(idx);
                    break;
                }
                default: {
                    ExceptionsKt.invalidOp("Unsupported export=" + tid);
                    throw new KotlinNothingValueException();
                }
            }
            Object obj = object;
            export = new WasmExport(name2, tid, idx, obj);
            if (tid != 0) break block7;
            WasmFunc wasmFunc = this.functions.get(idx);
            if (wasmFunc != null) {
                wasmFunc.addExport(export);
            }
        }
        return export;
    }

    public final void readFunctionSection(@NotNull SyncStream $this$readFunctionSection) {
        List funcs2 = this.readVec($this$readFunctionSection, (Function1)new Function1<Integer, WasmFunc>(this, $this$readFunctionSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readFunctionSection;
            {
                this.this$0 = $receiver;
                this.$this_readFunctionSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmFunc invoke(int it) {
                int index2 = this.this$0.readLEB128(this.$this_readFunctionSection);
                Integer[] integerArray = this.this$0.getIndicesInTables();
                int n = this.this$0.getINDEX_FUNCTIONS();
                int n2 = integerArray[n];
                integerArray[n] = n2 + 1;
                WasmType wasmType = this.this$0.getTypes().get(index2).getType();
                Intrinsics.checkNotNull(wasmType, "null cannot be cast to non-null type korlibs.wasm.WasmType.Function");
                return new WasmFunc(n2, (WasmType.Function)wasmType, null, null, null, 28, null);
            }
        });
        for (WasmFunc entry2 : funcs2) {
            ((Map)this.functions).put(entry2.getIndex(), entry2);
        }
        for (Map.Entry entry2 : ((Map)this.functions).entrySet()) {
            int index2 = ((Number)entry2.getKey()).intValue();
            WasmFunc func3 = (WasmFunc)entry2.getValue();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// FUNC[" + index2 + "]: " + func3));
        }
    }

    public final void readTableSection(@NotNull SyncStream $this$readTableSection) {
        List tableTypes2 = this.readVec($this$readTableSection, new Function1<Integer, WasmType.TableType<?>>(this, $this$readTableSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readTableSection;
            {
                this.this$0 = $receiver;
                this.$this_readTableSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmType.TableType<?> invoke(int it) {
                return this.this$0.readTableType(this.$this_readTableSection);
            }
        });
        this.tables = tableTypes2;
        Iterator iterator2 = tableTypes2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            WasmType.TableType table = (WasmType.TableType)iterator2.next();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// TABLE[" + index2 + "]: " + table));
        }
    }

    public final void readMemorySection(@NotNull SyncStream $this$readMemorySection) {
        List memoryTypes2 = this.readVec($this$readMemorySection, (Function1)new Function1<Integer, WasmType.Limit>(this, $this$readMemorySection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readMemorySection;
            {
                this.this$0 = $receiver;
                this.$this_readMemorySection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmType.Limit invoke(int it) {
                return this.this$0.readMemtype(this.$this_readMemorySection);
            }
        });
        this.memories = memoryTypes2;
        Iterator iterator2 = memoryTypes2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            WasmType.Limit memory = (WasmType.Limit)iterator2.next();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// MEMORY[" + index2 + "]: " + memory));
        }
    }

    public final void readGlobalSection(@NotNull SyncStream $this$readGlobalSection) {
        List glbs2 = this.readVec($this$readGlobalSection, (Function1)new Function1<Integer, WasmGlobal>(this, $this$readGlobalSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readGlobalSection;
            {
                this.this$0 = $receiver;
                this.$this_readGlobalSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmGlobal invoke(int it) {
                return this.this$0.readGlobal(this.$this_readGlobalSection);
            }
        });
        for (WasmGlobal entry2 : glbs2) {
            ((Map)this.globals).put(entry2.getIndex(), entry2);
        }
        for (Map.Entry entry2 : ((Map)this.globals).entrySet()) {
            int index2 = ((Number)entry2.getKey()).intValue();
            WasmGlobal global = (WasmGlobal)entry2.getValue();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// GLOBAL[" + index2 + "]: " + global));
        }
    }

    public final int readTableIdx(@NotNull SyncStream $this$readTableIdx) {
        return this.readLEB128($this$readTableIdx);
    }

    public final int readFuncIdx(@NotNull SyncStream $this$readFuncIdx) {
        return this.readLEB128($this$readFuncIdx);
    }

    @NotNull
    public final WasmElement readElement(@NotNull SyncStream $this$readElement) {
        int n = this.readTableIdx($this$readElement);
        WasmExpr wasmExpr = this.readExpr($this$readElement);
        List list2 = this.readVec($this$readElement, (Function1)new Function1<Integer, Integer>(this, $this$readElement){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readElement;
            {
                this.this$0 = $receiver;
                this.$this_readElement = $receiver2;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return this.this$0.readFuncIdx(this.$this_readElement);
            }
        });
        return new WasmElement(n, list2, null, wasmExpr, 4, null);
    }

    public final void readElementSection(@NotNull SyncStream $this$readElementSection) {
        this.elements = this.readVec($this$readElementSection, (Function1)new Function1<Integer, WasmElement>(this, $this$readElementSection){
            final /* synthetic */ WasmReaderBinary this$0;
            final /* synthetic */ SyncStream $this_readElementSection;
            {
                this.this$0 = $receiver;
                this.$this_readElementSection = $receiver2;
                super(1);
            }

            @NotNull
            public final WasmElement invoke(int it) {
                return this.this$0.readElement(this.$this_readElementSection);
            }
        });
        Iterator<WasmElement> iterator2 = this.elements.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            WasmElement e = iterator2.next();
            WasmReaderBinary this_$iv = this;
            boolean $i$f$trace = false;
            if (!this_$iv.doTrace) continue;
            boolean bl = false;
            System.out.println((Object)("// ELEMENT[" + index2 + "]: " + e));
        }
    }

    @NotNull
    public final WasmGlobal readGlobal(@NotNull SyncStream $this$readGlobal) {
        WasmType gt = this.readGlobalType($this$readGlobal);
        WasmExpr e = this.readExpr($this$readGlobal);
        WasmReaderBinary this_$iv = this;
        boolean $i$f$trace = false;
        if (this_$iv.doTrace) {
            boolean bl = false;
            System.out.println((Object)("// GLOBAL: " + gt + ", " + e));
        }
        Integer[] integerArray = this.indicesInTables;
        int n = this.INDEX_GLOBALS;
        int n2 = integerArray[n];
        integerArray[n] = n2 + 1;
        return new WasmGlobal(gt, n2, e, null, null, 24, null);
    }

    @NotNull
    public final WasmExpr readExpr(@NotNull SyncStream $this$readExpr) {
        WasmInstruction i2;
        ArrayList seq = new ArrayList();
        while ((i2 = this.readInstr($this$readExpr)) != WasmInstruction.End.INSTANCE) {
            ((Collection)seq).add(i2);
            if (!(i2 instanceof WasmInstruction.ELSE)) continue;
        }
        return new WasmExpr(seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int peekU8(@NotNull SyncStream $this$peekU8) {
        int n;
        SyncStream $this$keepPosition$iv = $this$peekU8;
        boolean $i$f$keepPosition = false;
        long old$iv = $this$keepPosition$iv.getPosition();
        try {
            boolean bl = false;
            n = SyncStreamKt.readU8($this$peekU8);
        }
        finally {
            $this$keepPosition$iv.setPosition(old$iv);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> readVec(@NotNull SyncStream $this$readVec, @NotNull Function1<? super Integer, ? extends T> callback) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = RangesKt.until(0, this.readLEB128($this$readVec));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(callback.invoke((int)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final WasmInstruction readInstr(@NotNull SyncStream $this$readInstr) {
        WasmInstruction wasmInstruction;
        int op = SyncStreamKt.readU8($this$readInstr);
        int n = op;
        if (n == 0) {
            wasmInstruction = WasmInstruction.unreachable.INSTANCE;
        } else if (n == 1) {
            wasmInstruction = WasmInstruction.nop.INSTANCE;
        } else if (n == 2) {
            wasmInstruction = new WasmInstruction.block(this.readBlockType($this$readInstr), this.readExpr($this$readInstr));
        } else if (n == 3) {
            wasmInstruction = new WasmInstruction.loop(this.readBlockType($this$readInstr), this.readExpr($this$readInstr));
        } else if (n == 4) {
            WasmInstruction.IF iF;
            WasmType bt = this.readBlockType($this$readInstr);
            WasmExpr in1 = this.readExpr($this$readInstr);
            WasmInstruction lastInstruction = CollectionsKt.lastOrNull(in1.getInstructions());
            if (lastInstruction instanceof WasmInstruction.ELSE) {
                WasmInstruction wasmInstruction2 = CollectionsKt.last(in1.getInstructions());
                Intrinsics.checkNotNull(wasmInstruction2, "null cannot be cast to non-null type korlibs.wasm.WasmInstruction.ELSE");
                WasmInstruction.ELSE _else = (WasmInstruction.ELSE)wasmInstruction2;
                iF = new WasmInstruction.IF(bt, new WasmExpr(CollectionsKt.dropLast(in1.getInstructions(), 1)), _else.getCode());
            } else {
                iF = new WasmInstruction.IF(bt, in1, null);
            }
            wasmInstruction = iF;
        } else if (n == 5) {
            wasmInstruction = new WasmInstruction.ELSE(this.readExpr($this$readInstr));
        } else if (n == 11) {
            wasmInstruction = WasmInstruction.End.INSTANCE;
        } else if (n == 12) {
            wasmInstruction = new WasmInstruction.br(this.readLEB128($this$readInstr));
        } else if (n == 13) {
            wasmInstruction = new WasmInstruction.br_if(this.readLEB128($this$readInstr));
        } else if (n == 14) {
            wasmInstruction = new WasmInstruction.br_table(this.readVec($this$readInstr, (Function1)new Function1<Integer, Integer>(this, $this$readInstr){
                final /* synthetic */ WasmReaderBinary this$0;
                final /* synthetic */ SyncStream $this_readInstr;
                {
                    this.this$0 = $receiver;
                    this.$this_readInstr = $receiver2;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return this.this$0.readLEB128(this.$this_readInstr);
                }
            }), this.readLEB128($this$readInstr));
        } else if (n == 15) {
            wasmInstruction = WasmInstruction.RETURN.INSTANCE;
        } else if (n == 16) {
            wasmInstruction = new WasmInstruction.CALL(this.readLEB128($this$readInstr));
        } else if (n == 17) {
            wasmInstruction = new WasmInstruction.CALL_INDIRECT(this.readLEB128($this$readInstr), SyncStreamKt.readU8($this$readInstr));
        } else if (n == 26 ? true : n == 27) {
            wasmInstruction = new WasmInstruction.Ins(WasmOp.Companion.get(op));
        } else {
            boolean bl = 32 <= n ? n < 37 : false;
            if (bl) {
                wasmInstruction = new WasmInstruction.InsInt(WasmOp.Companion.get(op), this.readLEB128($this$readInstr));
            } else {
                boolean bl2 = 40 <= n ? n < 63 : false;
                if (bl2) {
                    wasmInstruction = new WasmInstruction.InsMemarg(WasmOp.Companion.get(op), this.readLEB128($this$readInstr), this.readLEB128($this$readInstr));
                } else if (n == 63 ? true : n == 64) {
                    wasmInstruction = new WasmInstruction.InsInt(WasmOp.Companion.get(op), this.readLEB128($this$readInstr));
                } else if (n == 65) {
                    wasmInstruction = new WasmInstruction.InsConstInt(this.readLEB128S($this$readInstr), WasmOp.Companion.get(op));
                } else if (n == 66) {
                    wasmInstruction = new WasmInstruction.InsConstLong(this.readLEB128SLong($this$readInstr), WasmOp.Companion.get(op));
                } else if (n == 67) {
                    wasmInstruction = new WasmInstruction.InsConstFloat(SyncStreamKt.readF32LE($this$readInstr), WasmOp.Companion.get(op));
                } else if (n == 68) {
                    wasmInstruction = new WasmInstruction.InsConstDouble(SyncStreamKt.readF64LE($this$readInstr), WasmOp.Companion.get(op));
                } else {
                    boolean bl3 = 69 <= n ? n < 192 : false;
                    if (bl3) {
                        wasmInstruction = new WasmInstruction.Ins(WasmOp.Companion.get(op));
                    } else {
                        boolean bl4 = 192 <= n ? n < 197 : false;
                        if (bl4) {
                            wasmInstruction = new WasmInstruction.Ins(WasmOp.Companion.get(op));
                        } else {
                            boolean bl5 = 251 <= n ? n < 255 : false;
                            if (bl5) {
                                int eop = op << 8 | SyncStreamKt.readU8($this$readInstr);
                                wasmInstruction = (64522 <= eop ? eop < 64524 : false) ? (WasmInstruction)new WasmInstruction.InsInt(WasmOp.Companion.get(eop), 0) : (WasmInstruction)new WasmInstruction.Ins(WasmOp.Companion.get(eop));
                            } else {
                                Object[] objectArray = new Object[]{op};
                                ExceptionsKt.invalidOp(StringformatKt.format("Unsupported 0x%02X", objectArray));
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                }
            }
        }
        WasmInstruction i2 = wasmInstruction;
        return i2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkorlibs/wasm/WasmReaderBinary$Companion;", "", "()V", "INT_FUNC_TYPE", "Lkorlibs/wasm/WasmType$Function;", "getINT_FUNC_TYPE", "()Lkorlibs/wasm/WasmType$Function;", "korge-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WasmType.Function getINT_FUNC_TYPE() {
            return INT_FUNC_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

