/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import korlibs.datastructure.ListReader;
import korlibs.io.lang.ExceptionsKt;
import korlibs.io.util.BaseStrReader;
import korlibs.io.util.StrReader;
import korlibs.wasm.NamedWasmType;
import korlibs.wasm.WasmAssert;
import korlibs.wasm.WasmAssertReturn;
import korlibs.wasm.WasmCode;
import korlibs.wasm.WasmData;
import korlibs.wasm.WasmElement;
import korlibs.wasm.WasmExport;
import korlibs.wasm.WasmExpr;
import korlibs.wasm.WasmFunc;
import korlibs.wasm.WasmFuncRef;
import korlibs.wasm.WasmGlobal;
import korlibs.wasm.WasmInstruction;
import korlibs.wasm.WasmModule;
import korlibs.wasm.WasmOp;
import korlibs.wasm.WasmReaderBinaryKt;
import korlibs.wasm.WasmSType;
import korlibs.wasm.WasmType;
import korlibs.wasm.WastLocal;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0007%&'()*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u001fJ\u0016\u0010 \u001a\u0004\u0018\u00010!*\u00020\u001c2\b\b\u0002\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u0004\u0018\u00010!*\u00020\u001c2\b\b\u0002\u0010\"\u001a\u00020#R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"Lkorlibs/wasm/WasmReaderText;", "", "()V", "currentModule", "Lkorlibs/wasm/WasmReaderText$WasmModuleBuilder;", "getCurrentModule", "()Lkorlibs/wasm/WasmReaderText$WasmModuleBuilder;", "modules", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getModules", "()Ljava/util/ArrayList;", "readCodeLevel", "Lkorlibs/wasm/WasmExpr;", "expr", "Lkorlibs/wasm/WasmReaderText$WastBlock;", "func", "Lkorlibs/wasm/WasmReaderText$WasmFuncBuilder;", "exprs", "", "readExprParams", "Lkorlibs/wasm/WasmReaderText$ExprParamsResult;", "readModuleLevel", "", "block", "builder", "readTopLevel", "wast", "", "readType", "Lkorlibs/wasm/WasmType;", "Lkorlibs/wasm/WasmReaderText$WastBlockOrValue;", "toNumberExOrNull", "", "radix", "", "toNumberUnprefixedExOrNull", "ExprParamsResult", "WasmFuncBuilder", "WasmModuleBuilder", "WastBlock", "WastBlockOrValue", "WastParser", "WastValue", "korge-core"})
@SourceDebugExtension(value={"SMAP\nWasmReaderText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText$WasmFuncBuilder\n*L\n1#1,831:1\n1549#2:832\n1620#2,3:833\n1549#2:836\n1620#2,3:837\n1549#2:841\n1620#2,3:842\n1549#2:845\n1620#2,3:846\n1603#2,9:849\n1855#2:858\n1549#2:859\n1620#2,3:860\n1856#2:864\n1612#2:865\n1549#2:876\n1620#2,3:877\n1549#2:880\n1620#2,3:881\n1#3:840\n1#3:863\n67#4,5:866\n67#4,5:871\n*S KotlinDebug\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText\n*L\n171#1:832\n171#1:833,3\n176#1:836\n176#1:837,3\n294#1:841\n294#1:842,3\n350#1:845\n350#1:846,3\n364#1:849,9\n364#1:858\n367#1:859\n367#1:860,3\n364#1:864\n364#1:865\n506#1:876\n506#1:877,3\n507#1:880\n507#1:881,3\n364#1:863\n398#1:866,5\n425#1:871,5\n*E\n"})
public final class WasmReaderText {
    @NotNull
    private final ArrayList<WasmModuleBuilder> modules = new ArrayList();

    @NotNull
    public final ArrayList<WasmModuleBuilder> getModules() {
        return this.modules;
    }

    @NotNull
    public final WasmModuleBuilder getCurrentModule() {
        if (this.modules.isEmpty()) {
            this.modules.add(new WasmModuleBuilder());
        }
        return (WasmModuleBuilder)CollectionsKt.last((List)this.modules);
    }

    @NotNull
    public final WasmReaderText readTopLevel(@NotNull String wast) {
        for (WastBlock block2 : WastParser.INSTANCE.parseBlocks(wast)) {
            this.readTopLevel(block2);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final WasmType readType(@NotNull WastBlockOrValue block2) {
        WasmType wasmType;
        WastBlockOrValue wastBlockOrValue;
        block39: {
            WasmSType wasmSType;
            wastBlockOrValue = block2;
            if (!(wastBlockOrValue instanceof WastValue)) break block39;
            switch (((WastValue)block2).getValue()) {
                case "void": {
                    wasmSType = WasmSType.VOID;
                    break;
                }
                case "i32": {
                    wasmSType = WasmSType.I32;
                    break;
                }
                case "i64": {
                    wasmSType = WasmSType.I64;
                    break;
                }
                case "f32": {
                    wasmSType = WasmSType.F32;
                    break;
                }
                case "f64": {
                    wasmSType = WasmSType.F64;
                    break;
                }
                case "v128": {
                    wasmSType = WasmSType.V128;
                    break;
                }
                case "externref": 
                case "anyref": {
                    wasmSType = WasmSType.ANYREF;
                    break;
                }
                case "funcref": {
                    wasmSType = WasmSType.FUNCREF;
                    break;
                }
                default: {
                    String string = String.valueOf(block2);
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
            }
            wasmType = wasmSType;
            return wasmType;
        }
        if (!(wastBlockOrValue instanceof WastBlock)) throw new NoWhenBranchMatchedException();
        String string = ((WastBlock)block2).getName();
        if (Intrinsics.areEqual(string, "func")) {
            ArrayList results = new ArrayList();
            ArrayList params = new ArrayList();
            for (WastBlockOrValue param : ((WastBlock)block2).getParams()) {
                WastBlockOrValue it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Collection destination$iv$iv;
                boolean $i$f$map;
                Iterable $this$map$iv;
                String string2;
                if (!(param instanceof WastBlock)) {
                    string2 = String.valueOf(param);
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }
                string2 = ((WastBlock)param).getName();
                if (Intrinsics.areEqual(string2, "param")) {
                    $this$map$iv = ((WastBlock)param).getParams();
                    $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        WastBlockOrValue wastBlockOrValue2 = (WastBlockOrValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.readType(it));
                    }
                    for (WasmType p : (List)destination$iv$iv) {
                        ((Collection)params).add(new WastLocal(params.size(), p));
                    }
                    continue;
                }
                if (!Intrinsics.areEqual(string2, "result")) continue;
                Collection collection2 = results;
                $this$map$iv = ((WastBlock)param).getParams();
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (WastBlockOrValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.readType(it));
                }
                Iterable iterable = (List)destination$iv$iv;
                CollectionsKt.addAll(collection2, iterable);
            }
            wasmType = new WasmType.Function(params, results);
            return wasmType;
        }
        if (Intrinsics.areEqual(string, "mut")) {
            wasmType = new WasmType.Mutable(this.readType(CollectionsKt.first(((WastBlock)block2).getParams())));
            return wasmType;
        } else {
            String string3 = String.valueOf(block2);
            throw new NotImplementedError("An operation is not implemented: " + string3);
        }
    }

    public final void readTopLevel(@NotNull WastBlock block2) {
        switch (block2.getName()) {
            case "module": {
                WasmModuleBuilder builder = new WasmModuleBuilder();
                ((Collection)this.modules).add(builder);
                for (WastBlock item2 : block2.getBlockParams()) {
                    this.readModuleLevel(item2, builder);
                }
                break;
            }
            case "assert_return": 
            case "invoke": {
                WasmExpr wasmExpr;
                WasmExpr actual = this.readCodeLevel(block2.getBlockParams().get(0), new WasmFuncBuilder(new WasmModuleBuilder()));
                List<WastBlock> list2 = block2.getBlockParams();
                if (list2 != null && (list2 = CollectionsKt.getOrNull(list2, 1)) != null) {
                    List<WastBlock> it = list2;
                    boolean bl = false;
                    wasmExpr = this.readCodeLevel((WastBlock)((Object)it), new WasmFuncBuilder(new WasmModuleBuilder()));
                } else {
                    wasmExpr = null;
                }
                WasmExpr expected = wasmExpr;
                ((Collection)this.getCurrentModule().getAsserts()).add(new WasmAssertReturn(actual, expected, String.valueOf(block2)));
                break;
            }
            case "assert_trap": {
                break;
            }
            case "assert_invalid": {
                break;
            }
            case "assert_malformed": {
                break;
            }
            default: {
                String string = String.valueOf(block2.getName());
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void readModuleLevel(@NotNull WastBlock block, @NotNull WasmModuleBuilder builder) {
        var3_3 = block.getName();
        tmp = -1;
        switch (var3_3.hashCode()) {
            case 3115919: {
                if (var3_3.equals("elem")) {
                    tmp = 1;
                }
                break;
            }
            case -1077756671: {
                if (var3_3.equals("memory")) {
                    tmp = 2;
                }
                break;
            }
            case 3076010: {
                if (var3_3.equals("data")) {
                    tmp = 3;
                }
                break;
            }
            case 3154628: {
                if (var3_3.equals("func")) {
                    tmp = 4;
                }
                break;
            }
            case -1243020381: {
                if (var3_3.equals("global")) {
                    tmp = 5;
                }
                break;
            }
            case 3575610: {
                if (var3_3.equals("type")) {
                    tmp = 6;
                }
                break;
            }
            case 110115790: {
                if (var3_3.equals("table")) {
                    tmp = 7;
                }
                break;
            }
        }
        switch (tmp) {
            case 6: {
                typeName = CollectionsKt.first(block.getValueParams()).getValue();
                type = this.readType(CollectionsKt.last(block.getParams()));
                builder.addType(new NamedWasmType(builder.getTypes().size(), typeName, type));
                break;
            }
            case 7: {
                name = "$";
                type = "";
                for (WastValue vtype : block.getValueParams()) {
                    if (StringsKt.startsWith$default(vtype.getValue(), "$", false, 2, null)) {
                        name = vtype.getValue();
                        continue;
                    }
                    type = vtype.getValue();
                }
                table = new WasmType.TableType<T>(new WasmType.Limit(0, null, 2, null), Reflection.getOrCreateKotlinClass(WasmFuncRef.class));
                builder.addTable(table, name);
                if (Intrinsics.areEqual(type, "funcref")) {
                    var8_30 = block.getBlockParams().iterator();
                    if (!var8_30.hasNext()) break;
                    param = var8_30.next();
                    if (Intrinsics.areEqual(param.getName(), "elem")) {
                        elemName = CollectionsKt.first(param.getValueParams()).getValue();
                        v0 = builder.getFuncsByName().get(elemName);
                        if (v0 == null) {
                            throw new IllegalStateException(("Can't find func '" + elemName + "'").toString());
                        }
                        func = v0;
                        var13_49 = "elemName=" + elemName + ", func=" + func;
                        throw new NotImplementedError("An operation is not implemented: " + var13_49);
                    }
                    throw new NotImplementedError(null, 1, null);
                }
                var8_31 = "SKIP table=" + block;
                throw new NotImplementedError("An operation is not implemented: " + var8_31);
            }
            case 1: {
                System.out.println((Object)("SKIP elem=" + block));
                break;
            }
            case 3: {
                v1 = CollectionsKt.firstOrNull(block.getBlockParams());
                if (v1 == null) ** GOTO lbl85
                it = v1;
                $i$a$-let-WasmReaderText$readModuleLevel$expr$1 = false;
                v2 = this.readCodeLevel(it, new WasmFuncBuilder(builder).addResult(WasmSType.I32));
                v1 = v2;
                if (v2 != null) ** GOTO lbl88
lbl85:
                // 2 sources

                vtype = new WasmInstruction[]{new WasmInstruction.InsConstInt(this.getCurrentModule().getLastDataPtr(), null, 2, null)};
                v3 = new WasmExpr(vtype);
                v1 = v3;
lbl88:
                // 2 sources

                expr = v1;
                other = CollectionsKt.last(block.getValueParams());
                vtype = 0;
                it = other.getValue().length();
                $i$a$-let-WasmReaderText$readModuleLevel$expr$1 = new byte[it];
                while (vtype < it) {
                    var10_52 = vtype++;
                    $i$a$-let-WasmReaderText$readModuleLevel$expr$1[var10_52] = (byte)other.getValue().charAt(var10_52);
                }
                bytes = $i$a$-let-WasmReaderText$readModuleLevel$expr$1;
                vtype = this.getCurrentModule();
                vtype.setLastDataPtr(vtype.getLastDataPtr() + bytes.length);
                ((Collection)this.getCurrentModule().getDatas()).add(new WasmData(0, bytes, this.getCurrentModule().getDatas().size(), (WasmExpr)expr));
                break;
            }
            case 5: {
                globalIndex = this.getCurrentModule().getGlobals().size();
                gname = "g" + globalIndex;
                type = null;
                expr = null;
                for (WastBlockOrValue param : block.getParams()) {
                    if (param instanceof WastValue && StringsKt.startsWith$default(((WastValue)param).getValue(), "$", false, 2, null)) {
                        gname = ((WastValue)param).getValue();
                        continue;
                    }
                    if (type == null) {
                        type = this.readType(param);
                        continue;
                    }
                    Intrinsics.checkNotNull(param, "null cannot be cast to non-null type korlibs.wasm.WasmReaderText.WastBlock");
                    expr = this.readCodeLevel((WastBlock)param, new WasmFuncBuilder(builder).addResult(type));
                }
                v4 = this.getCurrentModule();
                v5 = type;
                if (v5 == null) {
                    v5 = WasmSType.VOID;
                }
                v4.addGlobal(new WasmGlobal(v5, globalIndex, expr, null, (String)gname, 8, null));
                System.out.println((Object)("SKIP global=" + block));
                break;
            }
            case 2: {
                $this$map$iv = block.getValueParams();
                $i$f$map = false;
                expr = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    func = (WastValue)item$iv$iv;
                    var16_55 = destination$iv$iv;
                    $i$a$-map-WasmReaderText$readModuleLevel$params$1 = false;
                    var16_55.add(Integer.parseInt(it.getValue()));
                }
                params = (List)destination$iv$iv;
                var6_21 = this.getCurrentModule().getMemories();
                v6 = (Integer)CollectionsKt.getOrNull(params, 0);
                var6_21.add(new WasmType.Limit(v6 != null ? v6 : 0, (Integer)CollectionsKt.getOrNull(params, 1)));
                break;
            }
            case 4: {
                funcBuilder = new WasmFuncBuilder(builder);
                var5_16 = block.getParams().iterator();
                var6_22 = 0;
                block30: while (var5_16.hasNext()) {
                    index = var6_22++;
                    param = var5_16.next();
                    if (index == 0 && param instanceof WastValue) {
                        funcBuilder.setFuncName(((WastValue)param).getValue());
                        continue;
                    }
                    if (!(param instanceof WastBlock)) continue;
                    vname = null;
                    var10_54 = ((WastBlock)param).getName();
                    switch (var10_54.hashCode()) {
                        case -934426595: {
                            if (var10_54.equals("result")) break;
                            ** break;
                        }
                        case -1184795739: {
                            if (!var10_54.equals("import")) {
                                ** break;
                            }
                            ** GOTO lbl196
                        }
                        case 106436749: {
                            if (!var10_54.equals("param")) {
                                ** break;
                            }
                            ** GOTO lbl182
                        }
                        case 3575610: {
                            if (!var10_54.equals("type")) {
                                ** break;
                            }
                            ** GOTO lbl198
                        }
                        case -1289153612: {
                            if (!var10_54.equals("export")) {
                                ** break;
                            }
                            ** GOTO lbl194
                        }
                        case 103145323: {
                            if (!var10_54.equals("local")) ** break;
lbl182:
                            // 4 sources

                            for (WastBlockOrValue pp : ((WastBlock)param).getParams()) {
                                if (pp instanceof WastValue && StringsKt.startsWith$default(((WastValue)pp).getValue(), "$", false, 2, null)) {
                                    vname = ((WastValue)pp).getValue();
                                    continue;
                                }
                                funcBuilder.addVar(vname, this.readType(pp), Intrinsics.areEqual(((WastBlock)param).getName(), "param"));
                                vname = null;
                            }
                            continue block30;
                        }
                    }
                    funcBuilder.addResult(this.readType(((WastBlock)param).getParams().get(0)));
                    continue;
lbl194:
                    // 1 sources

                    funcBuilder.setExportName(((WastBlock)param).getValueParams().get(0).getValue());
                    continue;
lbl196:
                    // 1 sources

                    item$iv$iv = "import=" + param;
                    throw new NotImplementedError("An operation is not implemented: " + (String)item$iv$iv);
lbl198:
                    // 1 sources

                    typeName = CollectionsKt.first(((WastBlock)param).getValueParams()).getValue();
                    if (builder.getTypesByName().get(typeName) == null) {
                        throw new IllegalStateException(("Can't find type '" + typeName + "'").toString());
                    }
                    if ((type instanceof WasmType.Function != false ? (WasmType.Function)type : null) == null) {
                        throw new IllegalStateException(("Type " + type + " is not a function").toString());
                    }
                    ftype = ftype;
                    for (WastLocal arg : ftype.getArgs()) {
                        funcBuilder.addVar(arg, true);
                    }
                    funcBuilder.addResult(ftype.getRetType());
                    continue;
lbl211:
                    // 7 sources

                    CollectionsKt.addAll((Collection)funcBuilder.getInstructions(), (Iterable)this.readCodeLevel((WastBlock)param, funcBuilder).getInstructions());
                }
                builder.addFunc(funcBuilder.buildFunc(builder));
                break;
            }
            default: {
                var4_10 = String.valueOf(block.getName());
                throw new NotImplementedError("An operation is not implemented: " + var4_10);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WasmExpr readCodeLevel(@NotNull List<WastBlock> exprs, @NotNull WasmFuncBuilder func2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = exprs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WastBlock wastBlock = (WastBlock)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.readCodeLevel((WastBlock)it, func2));
        }
        List<WasmInstruction> list2 = WasmReaderBinaryKt.getInstructions((List)destination$iv$iv);
        return new WasmExpr(list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExprParamsResult readExprParams(@NotNull WastBlock expr2, @NotNull WasmFuncBuilder func2) {
        void $this$mapNotNullTo$iv$iv;
        ArrayList results = new ArrayList();
        ArrayList types2 = new ArrayList();
        Iterable $this$mapNotNull$iv = expr2.getBlockParams();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            WasmExpr wasmExpr;
            Iterable iterable2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            WastBlock it = (WastBlock)element$iv$iv;
            boolean bl2 = false;
            String string = it.getName();
            if (Intrinsics.areEqual(string, "result")) {
                void $this$mapTo$iv$iv;
                Collection collection = results;
                Iterable $this$map$iv = it.getParams();
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    WastBlockOrValue wastBlockOrValue = (WastBlockOrValue)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(this.readType((WastBlockOrValue)it2));
                }
                iterable2 = (List)destination$iv$iv2;
                CollectionsKt.addAll(collection, iterable2);
                wasmExpr = null;
            } else if (Intrinsics.areEqual(string, "type")) {
                String typeName = CollectionsKt.first(it.getValueParams()).getValue();
                iterable2 = types2;
                NamedWasmType namedWasmType = func2.getModule().getTypesByName().get(typeName);
                if (namedWasmType == null) {
                    throw new IllegalStateException(("Can't find type '" + typeName + "'").toString());
                }
                iterable2.add(namedWasmType);
                wasmExpr = null;
            } else {
                wasmExpr = this.readCodeLevel(it, func2);
            }
            if (wasmExpr == null) continue;
            WasmExpr it$iv$iv = wasmExpr;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List exprs = (List)destination$iv$iv;
        return new ExprParamsResult(exprs, results, types2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final WasmExpr readCodeLevel(@NotNull WastBlock expr2, @NotNull WasmFuncBuilder func2) {
        switch (expr2.getName()) {
            case "invoke": 
            case "call": {
                String funcName = CollectionsKt.first(expr2.getValueParams()).getValue();
                WasmFunc wasmFunc = this.getCurrentModule().getFuncsByName().get(funcName);
                if (wasmFunc == null) {
                    WasmReaderText $this$readCodeLevel_u24lambda_u248 = this;
                    boolean bl = false;
                    System.out.println($this$readCodeLevel_u24lambda_u248.getCurrentModule().getFuncsByName().keySet());
                    throw new IllegalStateException(("Can't find function '" + funcName + "' in " + $this$readCodeLevel_u24lambda_u248.getCurrentModule().getFuncsByName().keySet()).toString());
                }
                WasmFunc fnc = wasmFunc;
                return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), new WasmInstruction.CALL(fnc.getIndex())));
            }
            case "call_indirect": {
                ExprParamsResult result2 = this.readExprParams(expr2, func2);
                NamedWasmType funcType2 = CollectionsKt.first(result2.getTypes());
                return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), new WasmInstruction.CALL_INDIRECT(funcType2.getIndex(), 0)));
            }
            case "if": {
                WasmExpr wasmExpr;
                void kind$iv;
                void this_$iv;
                WasmFuncBuilder result2 = func2;
                String funcType2 = "if";
                WastValue wastValue = CollectionsKt.firstOrNull(expr2.getValueParams());
                String id$iv = wastValue != null ? wastValue.getValue() : null;
                boolean $i$f$pushBlock = false;
                this_$iv.pushBlock((String)kind$iv, id$iv);
                try {
                    boolean bl = false;
                    ArrayList results = new ArrayList();
                    ArrayList params = new ArrayList();
                    WasmExpr btrue = null;
                    WasmExpr bfalse = null;
                    ArrayList conds = new ArrayList();
                    for (WastBlock param : expr2.getBlockParams()) {
                        switch (param.getName()) {
                            case "result": {
                                ((Collection)results).add(this.readType(CollectionsKt.first(param.getParams())));
                                Unit unit = Unit.INSTANCE;
                                break;
                            }
                            case "param": {
                                ((Collection)params).add(this.readType(CollectionsKt.first(param.getParams())));
                                Unit unit = Unit.INSTANCE;
                                break;
                            }
                            case "then": {
                                btrue = this.readCodeLevel(param.getBlockParams(), func2);
                                Unit unit = Unit.INSTANCE;
                                break;
                            }
                            case "else": {
                                bfalse = this.readCodeLevel(param.getBlockParams(), func2);
                                Unit unit = Unit.INSTANCE;
                                break;
                            }
                            default: {
                                ((Collection)conds).add(this.readCodeLevel(param, func2));
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                    }
                    Collection collection = WasmReaderBinaryKt.getInstructions(conds);
                    WasmType wasmType = (WasmType)CollectionsKt.firstOrNull(results);
                    if (wasmType == null) {
                        wasmType = WasmSType.VOID;
                    }
                    WasmExpr wasmExpr2 = btrue;
                    Intrinsics.checkNotNull(wasmExpr2);
                    wasmExpr = new WasmExpr(CollectionsKt.plus(collection, new WasmInstruction.IF(wasmType, wasmExpr2, bfalse)));
                }
                finally {
                    this_$iv.popBlock();
                }
                return wasmExpr;
            }
            case "loop": 
            case "block": {
                WasmExpr wasmExpr;
                WasmFuncBuilder this_$iv = func2;
                String kind$iv = expr2.getName();
                WastValue wastValue = CollectionsKt.firstOrNull(expr2.getValueParams());
                String id$iv = wastValue != null ? wastValue.getValue() : null;
                boolean $i$f$pushBlock = false;
                this_$iv.pushBlock(kind$iv, id$iv);
                try {
                    WasmInstruction.BlockOrLoop blockOrLoop;
                    boolean bl = false;
                    ExprParamsResult result3 = this.readExprParams(expr2, func2);
                    WasmExpr vexpr = new WasmExpr(result3.getInstructions());
                    WasmType wasmType = CollectionsKt.firstOrNull(result3.getResults());
                    if (wasmType == null) {
                        wasmType = WasmSType.VOID;
                    }
                    WasmType blockType = wasmType;
                    WasmInstruction[] bfalse = new WasmInstruction[1];
                    String conds = expr2.getName();
                    if (Intrinsics.areEqual(conds, "block")) {
                        blockOrLoop = new WasmInstruction.block(blockType, vexpr);
                    } else if (Intrinsics.areEqual(conds, "loop")) {
                        blockOrLoop = new WasmInstruction.loop(blockType, vexpr);
                    } else {
                        throw new NotImplementedError(null, 1, null);
                    }
                    bfalse[0] = blockOrLoop;
                    wasmExpr = new WasmExpr(bfalse);
                }
                finally {
                    this_$iv.popBlock();
                }
                return wasmExpr;
            }
            case "return": {
                return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), WasmInstruction.RETURN.INSTANCE));
            }
            case "f32.const": {
                String valueStr = CollectionsKt.first(expr2.getValueParams()).getValue();
                Number number = WasmReaderText.toNumberExOrNull$default(this, valueStr, 0, 1, null);
                if (number == null) {
                    throw new IllegalStateException(("Can't interpret literal '" + valueStr + "'").toString());
                }
                float value = number.floatValue();
                if (!this.readExprParams(expr2, func2).getExprs().isEmpty()) {
                    String $i$f$pushBlock = "Check failed.";
                    throw new IllegalStateException($i$f$pushBlock.toString());
                }
                WasmInstruction[] id$iv = new WasmInstruction[]{new WasmInstruction.InsConstFloat(value, null, 2, null)};
                return new WasmExpr(id$iv);
            }
            case "f64.const": {
                String valueStr = CollectionsKt.first(expr2.getValueParams()).getValue();
                Number number = WasmReaderText.toNumberExOrNull$default(this, valueStr, 0, 1, null);
                if (number == null) {
                    throw new IllegalStateException(("Can't interpret literal '" + valueStr + "'").toString());
                }
                double value = number.doubleValue();
                if (!this.readExprParams(expr2, func2).getExprs().isEmpty()) {
                    String bl = "Check failed.";
                    throw new IllegalStateException(bl.toString());
                }
                WasmInstruction[] $i$f$pushBlock = new WasmInstruction[]{new WasmInstruction.InsConstDouble(value, null, 2, null)};
                return new WasmExpr($i$f$pushBlock);
            }
            case "i32.const": {
                String valueStr = CollectionsKt.first(expr2.getValueParams()).getValue();
                Number number = WasmReaderText.toNumberExOrNull$default(this, valueStr, 0, 1, null);
                if (number == null) {
                    throw new IllegalStateException(("Can't interpret literal '" + valueStr + "'").toString());
                }
                int value = number.intValue();
                if (!this.readExprParams(expr2, func2).getExprs().isEmpty()) {
                    String $i$f$pushBlock = "Check failed.";
                    throw new IllegalStateException($i$f$pushBlock.toString());
                }
                WasmInstruction[] id$iv = new WasmInstruction[]{new WasmInstruction.InsConstInt(value, null, 2, null)};
                return new WasmExpr(id$iv);
            }
            case "i64.const": {
                String valueStr = CollectionsKt.first(expr2.getValueParams()).getValue();
                Number number = WasmReaderText.toNumberExOrNull$default(this, valueStr, 0, 1, null);
                if (number == null) {
                    throw new IllegalStateException(("Can't interpret literal '" + valueStr + "'").toString());
                }
                long value = number.longValue();
                if (!this.readExprParams(expr2, func2).getExprs().isEmpty()) {
                    String bl = "Check failed.";
                    throw new IllegalStateException(bl.toString());
                }
                WasmInstruction[] $i$f$pushBlock = new WasmInstruction[]{new WasmInstruction.InsConstLong(value, null, 2, null)};
                return new WasmExpr($i$f$pushBlock);
            }
            case "global.set": 
            case "global.get": {
                String valueStr = CollectionsKt.first(expr2.getValueParams()).getValue();
                WasmGlobal wasmGlobal = this.getCurrentModule().getGlobalsByName().get(valueStr);
                if (wasmGlobal == null) {
                    throw new IllegalStateException(("Can't find global '" + valueStr + "'").toString());
                }
                WasmGlobal global = wasmGlobal;
                return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), new WasmInstruction.InsInt(Intrinsics.areEqual(expr2.getName(), "global.set") ? WasmOp.Op_global_set : WasmOp.Op_global_get, global.getIndex())));
            }
            case "local.set": 
            case "local.tee": 
            case "local.get": {
                WasmOp wasmOp;
                int n;
                String localName = CollectionsKt.first(expr2.getValueParams()).getValue();
                Number number = WasmReaderText.toNumberExOrNull$default(this, localName, 0, 1, null);
                if (number != null) {
                    n = number.intValue();
                } else {
                    WastLocal wastLocal = func2.getLocalsByName().get(localName);
                    if (wastLocal != null) {
                        n = wastLocal.getIndex();
                    } else {
                        throw new IllegalStateException(("Can't find local '" + localName + "'").toString());
                    }
                }
                int localIndex = n;
                Collection collection = this.readExprParams(expr2, func2).getInstructions();
                switch (expr2.getName()) {
                    case "local.set": {
                        wasmOp = WasmOp.Op_local_set;
                        break;
                    }
                    case "local.get": {
                        wasmOp = WasmOp.Op_local_get;
                        break;
                    }
                    case "local.tee": {
                        wasmOp = WasmOp.Op_local_tee;
                        break;
                    }
                    default: {
                        throw new NotImplementedError(null, 1, null);
                    }
                }
                return new WasmExpr(CollectionsKt.plus(collection, new WasmInstruction.InsInt(wasmOp, localIndex)));
            }
            case "ref.null": {
                WasmSType wasmSType;
                String kind2 = CollectionsKt.last(expr2.getValueParams()).getValue();
                Collection collection = this.readExprParams(expr2, func2).getInstructions();
                String localIndex = kind2;
                if (Intrinsics.areEqual(localIndex, "extern")) {
                    wasmSType = WasmSType.ANYREF;
                } else if (Intrinsics.areEqual(localIndex, "func")) {
                    wasmSType = WasmSType.FUNCREF;
                } else {
                    String id$iv = "kind=" + kind2;
                    throw new NotImplementedError("An operation is not implemented: " + id$iv);
                }
                return new WasmExpr(CollectionsKt.plus(collection, new WasmInstruction.InsType(WasmOp.Op_ref_null, wasmSType)));
            }
            case "unreachable": {
                return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), WasmInstruction.unreachable.INSTANCE));
            }
            case "nop": {
                return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), WasmInstruction.nop.INSTANCE));
            }
            case "br": 
            case "br_if": 
            case "br_table": {
                WasmInstruction wasmInstruction;
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv = expr2.getValueParams();
                boolean $i$f$map = false;
                Iterable $i$f$pushBlock = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    WastValue bfalse = (WastValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getValue());
                }
                List labelNames = (List)destination$iv$iv;
                Iterable $this$map$iv2 = labelNames;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    int n;
                    void it;
                    String bl = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Integer n2 = StringsKt.toIntOrNull((String)it);
                    if (n2 != null) {
                        n = n2;
                    } else {
                        Integer n3 = func2.relativeIndexOfBlockById((String)it);
                        if (n3 != null) {
                            n = n3;
                        } else {
                            throw new IllegalStateException(("it=" + (String)it + " is not an integer").toString());
                        }
                    }
                    collection.add(n);
                }
                List labels = (List)destination$iv$iv2;
                switch (expr2.getName()) {
                    case "br": {
                        wasmInstruction = new WasmInstruction.br(((Number)CollectionsKt.first(labels)).intValue());
                        break;
                    }
                    case "br_if": {
                        wasmInstruction = new WasmInstruction.br_if(((Number)CollectionsKt.first(labels)).intValue());
                        break;
                    }
                    case "br_table": {
                        wasmInstruction = new WasmInstruction.br_table(CollectionsKt.dropLast(labels, 1), ((Number)CollectionsKt.last(labels)).intValue());
                        break;
                    }
                    default: {
                        throw new NotImplementedError(null, 1, null);
                    }
                }
                WasmInstruction instruction = wasmInstruction;
                return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), instruction));
            }
        }
        WasmOp wasmOp = WasmOp.Companion.getOrNull(expr2.getName());
        if (wasmOp == null) {
            throw new IllegalStateException(("Invalid opcode '" + expr2.getName() + "' in " + expr2).toString());
        }
        WasmOp op = wasmOp;
        if (op.getKind().getMemoryTransfer()) {
            int offset2 = 0;
            int align = 0;
            for (WastValue param : expr2.getValueParams()) {
                if (StringsKt.startsWith$default(param.getValue(), "offset=", false, 2, null)) {
                    String string = param.getValue().substring(7);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    offset2 = (int)Long.parseLong(string);
                    continue;
                }
                if (!StringsKt.startsWith$default(param.getValue(), "align=", false, 2, null)) continue;
                String string = param.getValue().substring(6);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                align = (int)Long.parseLong(string);
            }
            return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), new WasmInstruction.InsMemarg(op, align, offset2)));
        }
        if (!((Collection)expr2.getValueParams()).isEmpty()) {
            int n;
            String localName = CollectionsKt.first(expr2.getValueParams()).getValue();
            Number number = WasmReaderText.toNumberExOrNull$default(this, localName, 0, 1, null);
            if (number != null) {
                n = number.intValue();
            } else {
                WastLocal wastLocal = func2.getFuncType().getArgsByName().get(localName);
                if (wastLocal != null) {
                    n = wastLocal.getIndex();
                } else {
                    throw new IllegalStateException(("Can't find localName=" + localName + " in " + expr2 + " in func=" + func2).toString());
                }
            }
            int arg = n;
            WasmInstruction[] wasmInstructionArray = new WasmInstruction[]{new WasmInstruction.InsInt(op, arg)};
            return new WasmExpr(wasmInstructionArray);
        }
        return new WasmExpr(CollectionsKt.plus((Collection)this.readExprParams(expr2, func2).getInstructions(), new WasmInstruction.Ins(op)));
    }

    @Nullable
    public final Number toNumberExOrNull(@NotNull String $this$toNumberExOrNull, int radix) {
        Number number;
        if (StringsKt.startsWith$default($this$toNumberExOrNull, "-", false, 2, null)) {
            Number number2;
            String string = $this$toNumberExOrNull.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            Number number3 = this.toNumberExOrNull(string, radix);
            if (number3 == null) {
                return null;
            }
            Number value = number3;
            if (value instanceof Long) {
                number2 = -value.longValue();
            } else if (value instanceof Double) {
                number2 = -value.doubleValue();
            } else {
                throw new NotImplementedError(null, 1, null);
            }
            return number2;
        }
        if (StringsKt.startsWith$default($this$toNumberExOrNull, "+", false, 2, null)) {
            String string = $this$toNumberExOrNull.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return this.toNumberExOrNull(string, radix);
        }
        if (Intrinsics.areEqual($this$toNumberExOrNull, "inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (Intrinsics.areEqual($this$toNumberExOrNull, "nan")) {
            return Double.NaN;
        }
        if (StringsKt.startsWith$default($this$toNumberExOrNull, "nan:", false, 2, null)) {
            String string = $this$toNumberExOrNull.substring(4);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String nanStr = string;
            if (Intrinsics.areEqual(nanStr, "canonical")) {
                return Double.NaN;
            }
            if (Intrinsics.areEqual(nanStr, "arithmetic")) {
                return Double.NaN;
            }
            Number number4 = WasmReaderText.toNumberExOrNull$default(this, nanStr, 0, 1, null);
            if (number4 == null) {
                throw new IllegalStateException(("INVALID nanStr=" + nanStr).toString());
            }
            Number nanNumber = number4;
            if (nanNumber.longValue() == (long)nanNumber.intValue()) {
                return Float.valueOf(Float.intBitsToFloat(0x7F800000 | nanNumber.intValue()));
            }
            return Double.longBitsToDouble(0x7FF0000000000000L | nanNumber.longValue());
        }
        if (StringsKt.startsWith$default($this$toNumberExOrNull, "0x", false, 2, null) || StringsKt.startsWith$default($this$toNumberExOrNull, "0X", false, 2, null)) {
            String string = $this$toNumberExOrNull.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return this.toNumberUnprefixedExOrNull(string, 16);
        }
        if (StringsKt.startsWith$default($this$toNumberExOrNull, "0o", false, 2, null) || StringsKt.startsWith$default($this$toNumberExOrNull, "0O", false, 2, null)) {
            String string = $this$toNumberExOrNull.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return this.toNumberUnprefixedExOrNull(string, 8);
        }
        if (StringsKt.startsWith$default($this$toNumberExOrNull, "0b", false, 2, null) || StringsKt.startsWith$default($this$toNumberExOrNull, "0B", false, 2, null)) {
            String string = $this$toNumberExOrNull.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return this.toNumberUnprefixedExOrNull(string, 2);
        }
        String cleanStr = StringsKt.replace$default($this$toNumberExOrNull, "_", "", false, 4, null);
        Long l = StringsKt.toLongOrNull(cleanStr, radix);
        if (l != null) {
            number = l;
        } else {
            ULong uLong = UStringsKt.toULongOrNull(cleanStr, radix);
            Long l2 = uLong != null ? Long.valueOf(uLong.unbox-impl()) : null;
            number = l2 != null ? (Number)l2 : (Number)StringsKt.toDoubleOrNull(cleanStr);
        }
        return number;
    }

    public static /* synthetic */ Number toNumberExOrNull$default(WasmReaderText wasmReaderText, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return wasmReaderText.toNumberExOrNull(string, n);
    }

    @Nullable
    public final Number toNumberUnprefixedExOrNull(@NotNull String $this$toNumberUnprefixedExOrNull, int radix) {
        Number number;
        if (StringsKt.startsWith$default($this$toNumberUnprefixedExOrNull, "-", false, 2, null)) {
            Number number2;
            String string = $this$toNumberUnprefixedExOrNull.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            Number number3 = this.toNumberUnprefixedExOrNull(string, radix);
            if (number3 == null) {
                return null;
            }
            Number value = number3;
            if (value instanceof Long) {
                number2 = -value.longValue();
            } else if (value instanceof Double) {
                number2 = -value.doubleValue();
            } else {
                throw new NotImplementedError(null, 1, null);
            }
            return number2;
        }
        if (StringsKt.startsWith$default($this$toNumberUnprefixedExOrNull, "+", false, 2, null)) {
            String string = $this$toNumberUnprefixedExOrNull.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return this.toNumberUnprefixedExOrNull(string, radix);
        }
        if (Intrinsics.areEqual($this$toNumberUnprefixedExOrNull, "inf")) {
            return Double.POSITIVE_INFINITY;
        }
        String cleanStr = StringsKt.replace$default($this$toNumberUnprefixedExOrNull, "_", "", false, 4, null);
        if (radix == 16 && StringsKt.contains$default((CharSequence)cleanStr, "p", false, 2, null)) {
            Number expNum;
            Number decNum2;
            String[] stringArray = new String[]{"p"};
            List list2 = StringsKt.split$default((CharSequence)cleanStr, stringArray, false, 0, 6, null);
            String dec = (String)list2.get(0);
            String exp = (String)list2.get(1);
            String[] stringArray2 = new String[]{"."};
            List list3 = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)dec, stringArray2, false, 0, 6, null), (Iterable)CollectionsKt.listOf("0"));
            String dec1 = (String)list3.get(0);
            String dec2 = (String)list3.get(1);
            Number decNum1 = this.toNumberUnprefixedExOrNull(dec1, 16);
            String str = decNum1 + "." + (decNum2 = this.toNumberUnprefixedExOrNull(dec2, 16)) + "e" + (expNum = this.toNumberUnprefixedExOrNull(exp, 16));
            Number num = this.toNumberUnprefixedExOrNull(str, 10);
            if (num == null) {
                String string = "num=" + num + ", str=" + str + ", dec=" + dec + ", exp=" + exp + ", this=" + $this$toNumberUnprefixedExOrNull + ", dec1=" + dec1 + ", dec2=" + dec2;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            return num;
        }
        Long l = StringsKt.toLongOrNull(cleanStr, radix);
        if (l != null) {
            number = l;
        } else {
            ULong uLong = UStringsKt.toULongOrNull(cleanStr, radix);
            Long l2 = uLong != null ? Long.valueOf(uLong.unbox-impl()) : null;
            number = l2 != null ? (Number)l2 : (Number)StringsKt.toDoubleOrNull(cleanStr);
        }
        return number;
    }

    public static /* synthetic */ Number toNumberUnprefixedExOrNull$default(WasmReaderText wasmReaderText, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return wasmReaderText.toNumberUnprefixedExOrNull(string, n);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lkorlibs/wasm/WasmReaderText$ExprParamsResult;", "", "exprs", "", "Lkorlibs/wasm/WasmExpr;", "results", "Lkorlibs/wasm/WasmType;", "types", "Lkorlibs/wasm/NamedWasmType;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getExprs", "()Ljava/util/List;", "instructions", "Lkorlibs/wasm/WasmInstruction;", "getInstructions", "getResults", "getTypes", "korge-core"})
    public static final class ExprParamsResult {
        @NotNull
        private final List<WasmExpr> exprs;
        @NotNull
        private final List<WasmType> results;
        @NotNull
        private final List<NamedWasmType> types;

        public ExprParamsResult(@NotNull List<WasmExpr> exprs, @NotNull List<? extends WasmType> results, @NotNull List<NamedWasmType> types2) {
            this.exprs = exprs;
            this.results = results;
            this.types = types2;
        }

        @NotNull
        public final List<WasmExpr> getExprs() {
            return this.exprs;
        }

        @NotNull
        public final List<WasmType> getResults() {
            return this.results;
        }

        @NotNull
        public final List<NamedWasmType> getTypes() {
            return this.types;
        }

        @NotNull
        public final List<WasmInstruction> getInstructions() {
            return WasmReaderBinaryKt.getInstructions(this.exprs);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001FB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020,J\u0016\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u000205J \u00102\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\f2\u0006\u00101\u001a\u00020,2\u0006\u00104\u001a\u000205J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0003J\u0006\u0010:\u001a\u00020;J\u001a\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\f2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\fJ6\u0010<\u001a\u0002H?\"\u0004\b\u0000\u0010?2\u0006\u0010=\u001a\u00020\f2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\f2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H?0AH\u0086\b\u00a2\u0006\u0002\u0010BJ\u0017\u0010C\u001a\u0004\u0018\u00010D2\b\u0010>\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010ER!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u0006j\b\u0012\u0004\u0012\u00020\u001b`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR!\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u0006j\b\u0012\u0004\u0012\u00020\u001e`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\nR!\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u0006j\b\u0012\u0004\u0012\u00020\u001e`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\nR-\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001e0#j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001e`$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R!\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u0006j\b\u0012\u0004\u0012\u00020\u001e`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\nR*\u0010+\u001a\u0012\u0012\u0004\u0012\u00020,0\u0006j\b\u0012\u0004\u0012\u00020,`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\n\"\u0004\b.\u0010/\u00a8\u0006G"}, d2={"Lkorlibs/wasm/WasmReaderText$WasmFuncBuilder;", "", "module", "Lkorlibs/wasm/WasmReaderText$WasmModuleBuilder;", "(Lkorlibs/wasm/WasmReaderText$WasmModuleBuilder;)V", "blocks", "Ljava/util/ArrayList;", "Lkorlibs/wasm/WasmReaderText$WasmFuncBuilder$BlockDef;", "Lkotlin/collections/ArrayList;", "getBlocks", "()Ljava/util/ArrayList;", "exportName", "", "getExportName", "()Ljava/lang/String;", "setExportName", "(Ljava/lang/String;)V", "funcName", "getFuncName", "setFuncName", "funcType", "Lkorlibs/wasm/WasmType$Function;", "getFuncType", "()Lkorlibs/wasm/WasmType$Function;", "funcType$delegate", "Lkotlin/Lazy;", "instructions", "Lkorlibs/wasm/WasmInstruction;", "getInstructions", "justLocals", "Lkorlibs/wasm/WastLocal;", "getJustLocals", "locals", "getLocals", "localsByName", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getLocalsByName", "()Ljava/util/LinkedHashMap;", "getModule", "()Lkorlibs/wasm/WasmReaderText$WasmModuleBuilder;", "params", "getParams", "results", "Lkorlibs/wasm/WasmType;", "getResults", "setResults", "(Ljava/util/ArrayList;)V", "addResult", "type", "addVar", "local", "isParam", "", "vname", "buildFunc", "Lkorlibs/wasm/WasmFunc;", "builder", "popBlock", "", "pushBlock", "kind", "id", "T", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "relativeIndexOfBlockById", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "BlockDef", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nWasmReaderText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText$WasmFuncBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,831:1\n1#2:832\n378#3,7:833\n*S KotlinDebug\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText$WasmFuncBuilder\n*L\n62#1:833,7\n*E\n"})
    public static final class WasmFuncBuilder {
        @NotNull
        private final WasmModuleBuilder module;
        @Nullable
        private String funcName;
        @Nullable
        private String exportName;
        @NotNull
        private ArrayList<WasmType> results;
        @NotNull
        private final ArrayList<WastLocal> params;
        @NotNull
        private final ArrayList<WastLocal> justLocals;
        @NotNull
        private final ArrayList<WastLocal> locals;
        @NotNull
        private final LinkedHashMap<String, WastLocal> localsByName;
        @NotNull
        private final ArrayList<WasmInstruction> instructions;
        @NotNull
        private final Lazy funcType$delegate;
        @NotNull
        private final ArrayList<BlockDef> blocks;

        public WasmFuncBuilder(@NotNull WasmModuleBuilder module) {
            this.module = module;
            this.results = new ArrayList();
            this.params = new ArrayList();
            this.justLocals = new ArrayList();
            this.locals = new ArrayList();
            this.localsByName = new LinkedHashMap();
            this.instructions = new ArrayList();
            this.funcType$delegate = LazyKt.lazy((Function0)new Function0<WasmType.Function>(this){
                final /* synthetic */ WasmFuncBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final WasmType.Function invoke() {
                    return new WasmType.Function((List<WastLocal>)this.this$0.getParams(), (List<? extends WasmType>)this.this$0.getResults());
                }
            });
            this.blocks = new ArrayList();
        }

        @NotNull
        public final WasmModuleBuilder getModule() {
            return this.module;
        }

        @Nullable
        public final String getFuncName() {
            return this.funcName;
        }

        public final void setFuncName(@Nullable String string) {
            this.funcName = string;
        }

        @Nullable
        public final String getExportName() {
            return this.exportName;
        }

        public final void setExportName(@Nullable String string) {
            this.exportName = string;
        }

        @NotNull
        public final ArrayList<WasmType> getResults() {
            return this.results;
        }

        public final void setResults(@NotNull ArrayList<WasmType> arrayList) {
            this.results = arrayList;
        }

        @NotNull
        public final ArrayList<WastLocal> getParams() {
            return this.params;
        }

        @NotNull
        public final ArrayList<WastLocal> getJustLocals() {
            return this.justLocals;
        }

        @NotNull
        public final ArrayList<WastLocal> getLocals() {
            return this.locals;
        }

        @NotNull
        public final LinkedHashMap<String, WastLocal> getLocalsByName() {
            return this.localsByName;
        }

        @NotNull
        public final ArrayList<WasmInstruction> getInstructions() {
            return this.instructions;
        }

        @NotNull
        public final WasmType.Function getFuncType() {
            Lazy lazy = this.funcType$delegate;
            return (WasmType.Function)lazy.getValue();
        }

        @NotNull
        public final WasmFuncBuilder addVar(@Nullable String vname, @NotNull WasmType type2, boolean isParam) {
            WastLocal local2 = vname != null ? new WastLocal(vname, type2, this.locals.size()) : new WastLocal(this.locals.size(), type2);
            return this.addVar(local2, isParam);
        }

        @NotNull
        public final WasmFuncBuilder addVar(@NotNull WastLocal local2, boolean isParam) {
            if (isParam) {
                ((Collection)this.params).add(local2);
            } else {
                ((Collection)this.justLocals).add(local2);
            }
            ((Collection)this.locals).add(local2);
            ((Map)this.localsByName).put(local2.getName(), local2);
            return this;
        }

        @NotNull
        public final WasmFuncBuilder addResult(@NotNull WasmType type2) {
            ((Collection)this.results).add(type2);
            return this;
        }

        @NotNull
        public final WasmFunc buildFunc(@NotNull WasmModuleBuilder builder) {
            WasmExport wasmExport;
            Object it;
            int funcIndex = builder.getFuncs().size();
            WasmCode code = new WasmCode((List<WastLocal>)this.params, CollectionsKt.listOf(this.justLocals), new WasmExpr((List<? extends WasmInstruction>)this.instructions));
            String string = this.funcName;
            if (string == null) {
                string = this.exportName;
            }
            if (string != null) {
                it = string;
                boolean bl = false;
                wasmExport = new WasmExport((String)it, -1, -1, null);
            } else {
                wasmExport = null;
            }
            WasmExport export = wasmExport;
            WasmFunc wasmFunc = new WasmFunc(funcIndex, this.getFuncType(), code, null, null, 24, null);
            it = wasmFunc;
            boolean bl = false;
            ((WasmFunc)it).addExport(export);
            WasmFunc func2 = wasmFunc;
            return func2;
        }

        @NotNull
        public final ArrayList<BlockDef> getBlocks() {
            return this.blocks;
        }

        @Nullable
        public final Integer relativeIndexOfBlockById(@Nullable String id2) {
            int n;
            block2: {
                List $this$indexOfLast$iv = this.blocks;
                boolean $i$f$indexOfLast = false;
                ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    BlockDef it = (BlockDef)iterator$iv.previous();
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getId(), id2)) continue;
                    n = iterator$iv.nextIndex();
                    break block2;
                }
                n = -1;
            }
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = it >= 0 ? n2 : null;
            if (n3 == null) {
                return null;
            }
            int absIndex = n3;
            return this.blocks.size() - absIndex - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T pushBlock(@NotNull String kind2, @Nullable String id2, @NotNull Function0<? extends T> block2) {
            boolean $i$f$pushBlock = false;
            this.pushBlock(kind2, id2);
            try {
                T t = block2.invoke();
                return t;
            }
            finally {
                InlineMarker.finallyStart(1);
                this.popBlock();
                InlineMarker.finallyEnd(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static /* synthetic */ Object pushBlock$default(WasmFuncBuilder $this, String kind2, String id2, Function0 block2, int n, Object object) {
            if ((n & 2) != 0) {
                id2 = null;
            }
            boolean $i$f$pushBlock = false;
            $this.pushBlock(kind2, id2);
            try {
                object = block2.invoke();
                return object;
            }
            finally {
                InlineMarker.finallyStart(1);
                $this.popBlock();
                InlineMarker.finallyEnd(1);
            }
        }

        @NotNull
        public final BlockDef pushBlock(@NotNull String kind2, @Nullable String id2) {
            BlockDef blockDef;
            BlockDef it = blockDef = new BlockDef(kind2, id2);
            boolean bl = false;
            this.blocks.add(it);
            return blockDef;
        }

        public static /* synthetic */ BlockDef pushBlock$default(WasmFuncBuilder wasmFuncBuilder, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return wasmFuncBuilder.pushBlock(string, string2);
        }

        public final void popBlock() {
            CollectionsKt.removeLast((List)this.blocks);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lkorlibs/wasm/WasmReaderText$WasmFuncBuilder$BlockDef;", "", "kind", "", "id", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getKind", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "korge-core"})
        public static final class BlockDef {
            @NotNull
            private final String kind;
            @Nullable
            private final String id;

            public BlockDef(@NotNull String kind2, @Nullable String id2) {
                this.kind = kind2;
                this.id = id2;
            }

            @NotNull
            public final String getKind() {
                return this.kind;
            }

            @Nullable
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String component1() {
                return this.kind;
            }

            @Nullable
            public final String component2() {
                return this.id;
            }

            @NotNull
            public final BlockDef copy(@NotNull String kind2, @Nullable String id2) {
                return new BlockDef(kind2, id2);
            }

            public static /* synthetic */ BlockDef copy$default(BlockDef blockDef, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = blockDef.kind;
                }
                if ((n & 2) != 0) {
                    string2 = blockDef.id;
                }
                return blockDef.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "BlockDef(kind=" + this.kind + ", id=" + this.id + ")";
            }

            public int hashCode() {
                int result2 = this.kind.hashCode();
                result2 = result2 * 31 + (this.id == null ? 0 : this.id.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BlockDef)) {
                    return false;
                }
                BlockDef blockDef = (BlockDef)other;
                if (!Intrinsics.areEqual(this.kind, blockDef.kind)) {
                    return false;
                }
                return Intrinsics.areEqual(this.id, blockDef.id);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013J\u000e\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001cJ\u001a\u0010:\u001a\u00020;2\n\u0010<\u001a\u0006\u0012\u0002\b\u00030-2\u0006\u0010=\u001a\u00020\u0017J\u000e\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u000202J\u0006\u0010@\u001a\u00020AR!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0004j\b\u0012\u0004\u0012\u00020\n`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0004j\b\u0012\u0004\u0012\u00020\r`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0004j\b\u0012\u0004\u0012\u00020\u0010`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0004j\b\u0012\u0004\u0012\u00020\u0013`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR-\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00130\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0013`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u0004j\b\u0012\u0004\u0012\u00020\u001c`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\bR-\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001c0\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001c`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R!\u0010&\u001a\u0012\u0012\u0004\u0012\u00020'0\u0004j\b\u0012\u0004\u0012\u00020'`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\bR\u001a\u0010)\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R)\u0010,\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0\u0004j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\bR5\u0010/\u001a&\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0\u0016j\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030-`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001aR!\u00101\u001a\u0012\u0012\u0004\u0012\u0002020\u0004j\b\u0012\u0004\u0012\u000202`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\bR-\u00104\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002020\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u000202`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001a\u00a8\u0006B"}, d2={"Lkorlibs/wasm/WasmReaderText$WasmModuleBuilder;", "", "()V", "asserts", "Ljava/util/ArrayList;", "Lkorlibs/wasm/WasmAssert;", "Lkotlin/collections/ArrayList;", "getAsserts", "()Ljava/util/ArrayList;", "datas", "Lkorlibs/wasm/WasmData;", "getDatas", "elements", "Lkorlibs/wasm/WasmElement;", "getElements", "exports", "Lkorlibs/wasm/WasmExport;", "getExports", "funcs", "Lkorlibs/wasm/WasmFunc;", "getFuncs", "funcsByName", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getFuncsByName", "()Ljava/util/LinkedHashMap;", "globals", "Lkorlibs/wasm/WasmGlobal;", "getGlobals", "globalsByName", "getGlobalsByName", "lastDataPtr", "", "getLastDataPtr", "()I", "setLastDataPtr", "(I)V", "memories", "Lkorlibs/wasm/WasmType$Limit;", "getMemories", "startFunc", "getStartFunc", "setStartFunc", "tables", "Lkorlibs/wasm/WasmType$TableType;", "getTables", "tablesByName", "getTablesByName", "types", "Lkorlibs/wasm/NamedWasmType;", "getTypes", "typesByName", "getTypesByName", "addFunc", "func", "addGlobal", "global", "addTable", "", "table", "name", "addType", "type", "buildModule", "Lkorlibs/wasm/WasmModule;", "korge-core"})
    public static final class WasmModuleBuilder {
        private int lastDataPtr;
        @NotNull
        private final ArrayList<WasmFunc> funcs = new ArrayList();
        @NotNull
        private final ArrayList<WasmData> datas = new ArrayList();
        @NotNull
        private final ArrayList<NamedWasmType> types = new ArrayList();
        @NotNull
        private final ArrayList<WasmElement> elements = new ArrayList();
        @NotNull
        private final ArrayList<WasmType.TableType<?>> tables = new ArrayList();
        @NotNull
        private final ArrayList<WasmType.Limit> memories = new ArrayList();
        @NotNull
        private final ArrayList<WasmExport> exports = new ArrayList();
        @NotNull
        private final ArrayList<WasmGlobal> globals = new ArrayList();
        @NotNull
        private final ArrayList<WasmAssert> asserts = new ArrayList();
        private int startFunc = -1;
        @NotNull
        private final LinkedHashMap<String, WasmFunc> funcsByName = new LinkedHashMap();
        @NotNull
        private final LinkedHashMap<String, WasmGlobal> globalsByName = new LinkedHashMap();
        @NotNull
        private final LinkedHashMap<String, NamedWasmType> typesByName = new LinkedHashMap();
        @NotNull
        private final LinkedHashMap<String, WasmType.TableType<?>> tablesByName = new LinkedHashMap();

        public final int getLastDataPtr() {
            return this.lastDataPtr;
        }

        public final void setLastDataPtr(int n) {
            this.lastDataPtr = n;
        }

        @NotNull
        public final ArrayList<WasmFunc> getFuncs() {
            return this.funcs;
        }

        @NotNull
        public final ArrayList<WasmData> getDatas() {
            return this.datas;
        }

        @NotNull
        public final ArrayList<NamedWasmType> getTypes() {
            return this.types;
        }

        @NotNull
        public final ArrayList<WasmElement> getElements() {
            return this.elements;
        }

        @NotNull
        public final ArrayList<WasmType.TableType<?>> getTables() {
            return this.tables;
        }

        @NotNull
        public final ArrayList<WasmType.Limit> getMemories() {
            return this.memories;
        }

        @NotNull
        public final ArrayList<WasmExport> getExports() {
            return this.exports;
        }

        @NotNull
        public final ArrayList<WasmGlobal> getGlobals() {
            return this.globals;
        }

        @NotNull
        public final ArrayList<WasmAssert> getAsserts() {
            return this.asserts;
        }

        public final int getStartFunc() {
            return this.startFunc;
        }

        public final void setStartFunc(int n) {
            this.startFunc = n;
        }

        @NotNull
        public final LinkedHashMap<String, WasmFunc> getFuncsByName() {
            return this.funcsByName;
        }

        @NotNull
        public final LinkedHashMap<String, WasmGlobal> getGlobalsByName() {
            return this.globalsByName;
        }

        @NotNull
        public final LinkedHashMap<String, NamedWasmType> getTypesByName() {
            return this.typesByName;
        }

        @NotNull
        public final LinkedHashMap<String, WasmType.TableType<?>> getTablesByName() {
            return this.tablesByName;
        }

        public final void addTable(@NotNull WasmType.TableType<?> table, @NotNull String name2) {
            ((Collection)this.tables).add(table);
            ((Map)this.tablesByName).put(name2, table);
        }

        public final void addType(@NotNull NamedWasmType type2) {
            ((Collection)this.types).add(type2);
            ((Map)this.typesByName).put(type2.getName(), type2);
        }

        @NotNull
        public final WasmFunc addFunc(@NotNull WasmFunc func2) {
            ((Collection)this.funcs).add(func2);
            ((Map)this.funcsByName).put(func2.getName(), func2);
            return func2;
        }

        @NotNull
        public final WasmGlobal addGlobal(@NotNull WasmGlobal global) {
            ((Collection)this.globals).add(global);
            ((Map)this.globalsByName).put(global.getName(), global);
            return global;
        }

        @NotNull
        public final WasmModule buildModule() {
            return new WasmModule((List<WasmFunc>)this.funcs, (List<WasmData>)this.datas, (List<NamedWasmType>)this.types, (List<WasmGlobal>)this.globals, (List<WasmElement>)this.elements, (List)this.tables, (List<WasmType.Limit>)this.memories, (List<WasmExport>)this.exports, this.startFunc, (List<? extends WasmAssert>)this.asserts);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0012J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J/\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0012J\b\u0010(\u001a\u00020\u0003H\u0016R&\u0010\b\u001a\r\u0012\t\u0012\u00070\u0000\u00a2\u0006\u0002\b\t0\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR&\u0010\u0016\u001a\r\u0012\t\u0012\u00070\u0017\u00a2\u0006\u0002\b\t0\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\r\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006)"}, d2={"Lkorlibs/wasm/WasmReaderText$WastBlock;", "Lkorlibs/wasm/WasmReaderText$WastBlockOrValue;", "name", "", "params", "", "comment", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "blockParams", "Lkotlin/internal/NoInfer;", "getBlockParams", "()Ljava/util/List;", "blockParams$delegate", "Lkotlin/Lazy;", "getComment", "()Ljava/lang/String;", "getName", "nparams", "", "getNparams", "()I", "getParams", "valueParams", "Lkorlibs/wasm/WasmReaderText$WastValue;", "getValueParams", "valueParams$delegate", "block", "index", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "reader", "Lkorlibs/wasm/WasmReaderText$WastParser$ParamsReader;", "string", "toString", "korge-core"})
    public static final class WastBlock
    implements WastBlockOrValue {
        @NotNull
        private final String name;
        @NotNull
        private final List<WastBlockOrValue> params;
        @Nullable
        private final String comment;
        @NotNull
        private final Lazy valueParams$delegate;
        @NotNull
        private final Lazy blockParams$delegate;

        public WastBlock(@NotNull String name2, @NotNull List<? extends WastBlockOrValue> params, @Nullable String comment) {
            this.name = name2;
            this.params = params;
            this.comment = comment;
            this.valueParams$delegate = LazyKt.lazy((Function0)new Function0<List<? extends WastValue>>(this){
                final /* synthetic */ WastBlock this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<WastValue> invoke() {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = this.this$0.getParams();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof WastValue)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            });
            this.blockParams$delegate = LazyKt.lazy((Function0)new Function0<List<? extends WastBlock>>(this){
                final /* synthetic */ WastBlock this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<WastBlock> invoke() {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = this.this$0.getParams();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof WastBlock)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            });
        }

        public /* synthetic */ WastBlock(String string, List list2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, list2, string2);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<WastBlockOrValue> getParams() {
            return this.params;
        }

        @Nullable
        public final String getComment() {
            return this.comment;
        }

        @NotNull
        public final List<WastValue> getValueParams() {
            Lazy lazy = this.valueParams$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<WastBlock> getBlockParams() {
            Lazy lazy = this.blockParams$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final WastParser.ParamsReader reader() {
            return new WastParser.ParamsReader(this.params);
        }

        public final int getNparams() {
            return this.params.size();
        }

        @NotNull
        public final String string(int index2) {
            WastBlockOrValue wastBlockOrValue = this.params.get(index2);
            String string = wastBlockOrValue instanceof String ? (String)((Object)wastBlockOrValue) : null;
            if (string == null) {
                throw new IllegalStateException((this + " at index=" + index2 + " is not a String").toString());
            }
            return string;
        }

        @NotNull
        public final WastBlock block(int index2) {
            WastBlockOrValue wastBlockOrValue = this.params.get(index2);
            WastBlock wastBlock = wastBlockOrValue instanceof WastBlock ? (WastBlock)wastBlockOrValue : null;
            if (wastBlock == null) {
                throw new IllegalStateException((this + " at index=" + index2 + " is not a Block").toString());
            }
            return wastBlock;
        }

        @NotNull
        public String toString() {
            return "(" + this.name + " " + CollectionsKt.joinToString$default(this.params, " ", null, null, 0, null, null, 62, null) + ")";
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<WastBlockOrValue> component2() {
            return this.params;
        }

        @Nullable
        public final String component3() {
            return this.comment;
        }

        @NotNull
        public final WastBlock copy(@NotNull String name2, @NotNull List<? extends WastBlockOrValue> params, @Nullable String comment) {
            return new WastBlock(name2, params, comment);
        }

        public static /* synthetic */ WastBlock copy$default(WastBlock wastBlock, String string, List list2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = wastBlock.name;
            }
            if ((n & 2) != 0) {
                list2 = wastBlock.params;
            }
            if ((n & 4) != 0) {
                string2 = wastBlock.comment;
            }
            return wastBlock.copy(string, list2, string2);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.params).hashCode();
            result2 = result2 * 31 + (this.comment == null ? 0 : this.comment.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WastBlock)) {
                return false;
            }
            WastBlock wastBlock = (WastBlock)other;
            if (!Intrinsics.areEqual(this.name, wastBlock.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.params, wastBlock.params)) {
                return false;
            }
            return Intrinsics.areEqual(this.comment, wastBlock.comment);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00a8\u0006\u0004"}, d2={"Lkorlibs/wasm/WasmReaderText$WastBlockOrValue;", "", "Lkorlibs/wasm/WasmReaderText$WastBlock;", "Lkorlibs/wasm/WasmReaderText$WastValue;", "korge-core"})
    public static interface WastBlockOrValue {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000b\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0006J,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b*\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\b*\u00020\u0011\u00a8\u0006\u001f"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser;", "", "()V", "parseBlock", "Lkorlibs/wasm/WasmReaderText$WastBlock;", "wast", "", "parseBlocks", "", "parseLevel", "Lkorlibs/wasm/WasmReaderText$WastBlockOrValue;", "Lkorlibs/datastructure/ListReader;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "comment", "level", "", "readUntil", "Lkorlibs/io/util/StrReader;", "str", "wastTokenize", "CLOSE_BRAC", "COMMENT", "HexUtil", "Id", "Num", "OPEN_BRAC", "Op", "ParamsReader", "SpecialNum", "Str", "Token", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nWasmReaderText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText$WastParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StrReader.kt\nkorlibs/io/util/StrReader\n+ 4 StrReader.kt\nkorlibs/io/util/BaseStrReader\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,831:1\n800#2,11:832\n244#3:843\n244#3:853\n244#3:862\n53#4,3:844\n104#4,4:847\n57#4:851\n53#4,3:854\n104#4,4:857\n57#4:861\n53#4,3:863\n104#4,4:866\n57#4:870\n1#5:852\n*S KotlinDebug\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText$WastParser\n*L\n619#1:832,11\n671#1:843\n733#1:853\n736#1:862\n671#1:844,3\n671#1:847,4\n671#1:851\n733#1:854,3\n733#1:857,4\n733#1:861\n736#1:863,3\n736#1:866,4\n736#1:870\n*E\n"})
    public static final class WastParser {
        @NotNull
        public static final WastParser INSTANCE = new WastParser();

        private WastParser() {
        }

        @NotNull
        public final WastBlock parseBlock(@NotNull String wast) {
            return CollectionsKt.first(this.parseBlocks(wast));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<WastBlock> parseBlocks(@NotNull String wast) {
            void $this$filterIsInstanceTo$iv$iv;
            List<Token> tokens2 = this.wastTokenize(new StrReader(wast, null, 0, 6, null));
            ListReader<Token> lreader = new ListReader<Token>(tokens2);
            List blocks = WastParser.parseLevel$default(this, lreader, null, 0, 1, null);
            Iterable $this$filterIsInstance$iv = blocks;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof WastBlock)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<WastBlockOrValue> parseLevel(@NotNull ListReader<Token> $this$parseLevel, @Nullable String comment, int level) {
            ArrayList<WastBlockOrValue> out = new ArrayList<WastBlockOrValue>();
            String rcomment = null;
            while ($this$parseLevel.getHasMore()) {
                Token item2 = $this$parseLevel.peek();
                Token token2 = item2;
                if (Intrinsics.areEqual(token2, OPEN_BRAC.INSTANCE)) {
                    $this$parseLevel.read();
                    if (Intrinsics.areEqual($this$parseLevel.peek(), CLOSE_BRAC.INSTANCE)) {
                        $this$parseLevel.read();
                        continue;
                    }
                    List<WastBlockOrValue> block2 = this.parseLevel($this$parseLevel, rcomment, level + 1);
                    rcomment = null;
                    WastBlockOrValue wastBlockOrValue = CollectionsKt.first(block2);
                    Intrinsics.checkNotNull(wastBlockOrValue, "null cannot be cast to non-null type korlibs.wasm.WasmReaderText.WastValue");
                    out.add(new WastBlock(((WastValue)wastBlockOrValue).getValue(), CollectionsKt.drop((Iterable)block2, 1), rcomment));
                    if ($this$parseLevel.getEof()) break;
                    if (Intrinsics.areEqual($this$parseLevel.read(), CLOSE_BRAC.INSTANCE)) continue;
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual(token2, CLOSE_BRAC.INSTANCE)) {
                    rcomment = null;
                    break;
                }
                if (token2 instanceof COMMENT) {
                    rcomment = $this$parseLevel.read().getStr();
                    continue;
                }
                out.add(new WastValue($this$parseLevel.read().getStr()));
                rcomment = null;
            }
            return out;
        }

        public static /* synthetic */ List parseLevel$default(WastParser wastParser, ListReader listReader, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return wastParser.parseLevel(listReader, string, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final List<Token> wastTokenize(@NotNull StrReader $this$wastTokenize) {
            out = new ArrayList<E>();
            while (!$this$wastTokenize.getEof()) {
                block49: {
                    block48: {
                        block47: {
                            peek = $this$wastTokenize.peekChar();
                            if ($this$wastTokenize.tryLit("nan:", true) == null && $this$wastTokenize.tryLit("-nan:", true) == null) break block47;
                            var4_4 = out;
                            var5_6 = $this$wastTokenize;
                            var16_32 = "nan";
                            $i$f$readWhile = false;
                            this_$iv$iv = (BaseStrReader)this_$iv;
                            $i$f$slice = false;
                            start$iv$iv = this_$iv$iv.startBuffering();
                            try {
                                $i$a$-slice-StrReader$readWhile$1$iv = '\u0000';
                                this_$iv$iv = (BaseStrReader)this_$iv;
                                $i$f$skipWhile = false;
                                while (this_$iv$iv.getHasMore()) {
                                    it = this_$iv$iv.peekChar();
                                    $i$a$-readWhile-WasmReaderText$WastParser$wastTokenize$1 = false;
                                    if ('0' <= it ? it < ':' : false) ** GOTO lbl-1000
                                    if ('a' <= it ? it < '{' : false) ** GOTO lbl-1000
                                    v0 = 'A' <= it ? it < '[' : false;
                                    if (v0 || it == '.' || it == '-' || it == '+' || it == '_') lbl-1000:
                                    // 3 sources

                                    {
                                        v1 = true;
                                    } else {
                                        v1 = false;
                                    }
                                    if (v1) {
                                        this_$iv$iv.readChar();
                                    }
                                }
                            }
                            finally {
                                v2 = this_$iv$iv.endBuffering(start$iv$iv);
                            }
                        }
                        var4_5 = peek;
                        if (((var4_5 == ' ' ? true : var4_5 == '\t') != false ? true : var4_5 == '\r') != false ? true : var4_5 == '\n') {
                            $this$wastTokenize.readChar();
                            continue;
                        }
                        if (var4_5 == ';') {
                            $this$wastTokenize.readChar();
                            v3 = $this$wastTokenize.readUntil('\n');
                            if (v3 == null) {
                                v3 = "";
                            }
                            comment = v3;
                            ((Collection)out).add(new COMMENT(comment));
                            continue;
                        }
                        if (var4_5 == '(') {
                            $this$wastTokenize_u24lambda_u241 = $this$wastTokenize;
                            $i$a$-run-WasmReaderText$WastParser$wastTokenize$2 = false;
                            $this$wastTokenize_u24lambda_u241.read();
                            if ($this$wastTokenize_u24lambda_u241.peekChar() == ';') {
                                $this$wastTokenize_u24lambda_u241.readChar();
                                comment = WastParser.INSTANCE.readUntil($this$wastTokenize_u24lambda_u241, ";)");
                                ((Collection)out).add(new COMMENT(comment));
                                continue;
                            }
                            ((Collection)out).add(OPEN_BRAC.INSTANCE);
                            continue;
                        }
                        if (var4_5 == ')') {
                            $this$wastTokenize_u24lambda_u242 = $this$wastTokenize;
                            $i$a$-run-WasmReaderText$WastParser$wastTokenize$3 = false;
                            $this$wastTokenize_u24lambda_u242.read();
                            ((Collection)out).add(CLOSE_BRAC.INSTANCE);
                            continue;
                        }
                        if (var4_5 == '=') {
                            $this$wastTokenize_u24lambda_u243 = $this$wastTokenize;
                            $i$a$-run-WasmReaderText$WastParser$wastTokenize$4 = '\u0000';
                            ((Collection)out).add(new Op($this$wastTokenize_u24lambda_u243.read(1)));
                            continue;
                        }
                        if (var4_5 == '\"') {
                            $this$wastTokenize.readChar();
                            str = new StringBuilder();
                            while (!$this$wastTokenize.getEof()) {
                                pp = $this$wastTokenize.peekChar();
                                $i$a$-run-WasmReaderText$WastParser$wastTokenize$4 = pp;
                                if ($i$a$-run-WasmReaderText$WastParser$wastTokenize$4 == '\\') {
                                    p1 = $this$wastTokenize.read();
                                    p2 = $this$wastTokenize.read();
                                    $i$a$-slice-StrReader$readWhile$1$iv = p2;
                                    if ($i$a$-slice-StrReader$readWhile$1$iv == '\\') {
                                        v4 = 92;
                                    } else if ($i$a$-slice-StrReader$readWhile$1$iv == '\"') {
                                        v4 = 34;
                                    } else if ($i$a$-slice-StrReader$readWhile$1$iv == '\'') {
                                        v4 = 39;
                                    } else if ($i$a$-slice-StrReader$readWhile$1$iv == 't') {
                                        v4 = 9;
                                    } else if ($i$a$-slice-StrReader$readWhile$1$iv == 'r') {
                                        v4 = 13;
                                    } else if ($i$a$-slice-StrReader$readWhile$1$iv == 'n') {
                                        v4 = 10;
                                    } else {
                                        v5 = (('0' <= $i$a$-slice-StrReader$readWhile$1$iv ? $i$a$-slice-StrReader$readWhile$1$iv < ':' : false) ? true : ('a' <= $i$a$-slice-StrReader$readWhile$1$iv ? $i$a$-slice-StrReader$readWhile$1$iv < 'g' : false)) ? true : ('A' <= $i$a$-slice-StrReader$readWhile$1$iv ? $i$a$-slice-StrReader$readWhile$1$iv < 'G' : false);
                                        if (v5) {
                                            p3 = $this$wastTokenize.read();
                                            vh = HexUtil.INSTANCE.unhex(p2);
                                            vl = HexUtil.INSTANCE.unhex(p3);
                                            v4 = (char)(vh << 4 | vl);
                                        } else {
                                            p3 = "unknown string escape sequence " + p1 + p2;
                                            throw new NotImplementedError("An operation is not implemented: " + p3);
                                        }
                                    }
                                    str.append(v4);
                                    continue;
                                }
                                if ($i$a$-run-WasmReaderText$WastParser$wastTokenize$4 == '\"') {
                                    $this$wastTokenize.readChar();
                                    break;
                                }
                                str.append($this$wastTokenize.read());
                            }
                            pp = out;
                            v6 = str.toString();
                            Intrinsics.checkNotNullExpressionValue(v6, "toString(...)");
                            pp.add(new Str(v6));
                            continue;
                        }
                        v7 = '0' <= var4_5 ? var4_5 < ':' : false;
                        if (!((v7 != false ? true : var4_5 == '-') != false ? true : var4_5 == '+')) break block48;
                        var5_6 = out;
                        this_$iv = $this$wastTokenize;
                        $i$f$readWhile = false;
                        this_$iv$iv = this_$iv;
                        $i$f$slice = false;
                        start$iv$iv = this_$iv$iv.startBuffering();
                        try {
                            $i$a$-slice-StrReader$readWhile$1$iv = false;
                            this_$iv$iv = this_$iv;
                            $i$f$skipWhile = false;
                            while (this_$iv$iv.getHasMore()) {
                                it = this_$iv$iv.peekChar();
                                $i$a$-readWhile-WasmReaderText$WastParser$wastTokenize$5 = false;
                                if ('0' <= it ? it < ':' : false) ** GOTO lbl-1000
                                if ('a' <= it ? it < '{' : false) ** GOTO lbl-1000
                                v8 = 'A' <= it ? it < '[' : false;
                                if (v8 || it == '.' || it == '-' || it == '+' || it == '_') lbl-1000:
                                // 3 sources

                                {
                                    v9 = true;
                                } else {
                                    v9 = false;
                                }
                                if (v9) {
                                    this_$iv$iv.readChar();
                                }
                            }
                        }
                        finally {
                            v10 = this_$iv$iv.endBuffering(start$iv$iv);
                        }
                    }
                    v11 = ('a' <= var4_5 ? var4_5 < '{' : false) ? true : ('A' <= var4_5 ? var4_5 < '[' : false);
                    if (!(((((v11 != false ? true : var4_5 == '$') != false ? true : var4_5 == '%') != false ? true : var4_5 == '_') != false ? true : var4_5 == '.') != false ? true : var4_5 == '/')) break block49;
                    var5_6 = out;
                    this_$iv = $this$wastTokenize;
                    $i$f$readWhile = false;
                    this_$iv$iv = this_$iv;
                    $i$f$slice = false;
                    start$iv$iv = this_$iv$iv.startBuffering();
                    try {
                        $i$a$-slice-StrReader$readWhile$1$iv = false;
                        this_$iv$iv = this_$iv;
                        $i$f$skipWhile = false;
                        while (this_$iv$iv.getHasMore()) {
                            it = this_$iv$iv.peekChar();
                            $i$a$-readWhile-WasmReaderText$WastParser$wastTokenize$6 = false;
                            if ('a' <= it ? it < '{' : false) ** GOTO lbl-1000
                            if ('A' <= it ? it < '[' : false) ** GOTO lbl-1000
                            v12 = '0' <= it ? it < ':' : false;
                            if (v12 || it == '$' || it == '%' || it == '_' || it == '.' || it == '>' || it == '/' || it == '-' || it == '+' || it == '=') lbl-1000:
                            // 3 sources

                            {
                                v13 = true;
                            } else {
                                v13 = false;
                            }
                            if (v13) {
                                this_$iv$iv.readChar();
                            }
                        }
                    }
                    finally {
                        v14 = this_$iv$iv.endBuffering(start$iv$iv);
                    }
                }
                ExceptionsKt.invalidOp("Unknown '" + peek + "' at " + $this$wastTokenize.getPos() + " near '" + $this$wastTokenize.peek(16) + "'");
                throw new KotlinNothingValueException();
            }
            return out;
        }

        @NotNull
        public final String readUntil(@NotNull StrReader $this$readUntil, @NotNull String str) {
            Object out = "";
            while ($this$readUntil.getHasMore()) {
                if (Intrinsics.areEqual($this$readUntil.peek(str.length()), str)) {
                    $this$readUntil.skip(str.length());
                    break;
                }
                out = (String)out + $this$readUntil.readChar();
            }
            return out;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$CLOSE_BRAC;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "()V", "str", "", "getStr", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class CLOSE_BRAC
        implements Token {
            @NotNull
            public static final CLOSE_BRAC INSTANCE = new CLOSE_BRAC();
            @NotNull
            private static final String str = ")";

            private CLOSE_BRAC() {
            }

            @Override
            @NotNull
            public String getStr() {
                return str;
            }

            @NotNull
            public String toString() {
                return "CLOSE_BRAC";
            }

            public int hashCode() {
                return -18146085;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CLOSE_BRAC)) {
                    return false;
                }
                CLOSE_BRAC cfr_ignored_0 = (CLOSE_BRAC)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$COMMENT;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "comment", "", "(Ljava/lang/String;)V", "getComment", "()Ljava/lang/String;", "str", "getStr", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class COMMENT
        implements Token {
            @NotNull
            private final String comment;
            @NotNull
            private final String str;

            public COMMENT(@NotNull String comment) {
                this.str = this.comment = comment;
            }

            @NotNull
            public final String getComment() {
                return this.comment;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @NotNull
            public final String component1() {
                return this.comment;
            }

            @NotNull
            public final COMMENT copy(@NotNull String comment) {
                return new COMMENT(comment);
            }

            public static /* synthetic */ COMMENT copy$default(COMMENT cOMMENT, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = cOMMENT.comment;
                }
                return cOMMENT.copy(string);
            }

            @NotNull
            public String toString() {
                return "COMMENT(comment=" + this.comment + ")";
            }

            public int hashCode() {
                return this.comment.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof COMMENT)) {
                    return false;
                }
                COMMENT cOMMENT = (COMMENT)other;
                return Intrinsics.areEqual(this.comment, cOMMENT.comment);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$HexUtil;", "", "()V", "unhex", "", "char", "", "korge-core"})
        public static final class HexUtil {
            @NotNull
            public static final HexUtil INSTANCE = new HexUtil();

            private HexUtil() {
            }

            public final int unhex(char c) {
                int n;
                char c2 = c;
                boolean bl = '0' <= c2 ? c2 < ':' : false;
                if (bl) {
                    n = c - 48;
                } else {
                    boolean bl2 = 'a' <= c2 ? c2 < 'g' : false;
                    if (bl2) {
                        n = c - 97 + 10;
                    } else {
                        boolean bl3 = 'A' <= c2 ? c2 < 'G' : false;
                        if (bl3) {
                            n = c - 65 + 10;
                        } else {
                            throw new RuntimeException("Not an hex character");
                        }
                    }
                }
                return n;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$Id;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "str", "getStr", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class Id
        implements Token {
            @NotNull
            private final String id;
            @NotNull
            private final String str;

            public Id(@NotNull String id2) {
                this.str = this.id = id2;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @NotNull
            public final Id copy(@NotNull String id2) {
                return new Id(id2);
            }

            public static /* synthetic */ Id copy$default(Id id2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = id2.id;
                }
                return id2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Id(id=" + this.id + ")";
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Id)) {
                    return false;
                }
                Id id2 = (Id)other;
                return Intrinsics.areEqual(this.id, id2.id);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$Num;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "num", "", "(Ljava/lang/String;)V", "getNum", "()Ljava/lang/String;", "str", "getStr", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class Num
        implements Token {
            @NotNull
            private final String num;
            @NotNull
            private final String str;

            public Num(@NotNull String num) {
                this.str = this.num = num;
            }

            @NotNull
            public final String getNum() {
                return this.num;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @NotNull
            public final String component1() {
                return this.num;
            }

            @NotNull
            public final Num copy(@NotNull String num) {
                return new Num(num);
            }

            public static /* synthetic */ Num copy$default(Num num, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = num.num;
                }
                return num.copy(string);
            }

            @NotNull
            public String toString() {
                return "Num(num=" + this.num + ")";
            }

            public int hashCode() {
                return this.num.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Num)) {
                    return false;
                }
                Num num = (Num)other;
                return Intrinsics.areEqual(this.num, num.num);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$OPEN_BRAC;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "()V", "str", "", "getStr", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class OPEN_BRAC
        implements Token {
            @NotNull
            public static final OPEN_BRAC INSTANCE = new OPEN_BRAC();
            @NotNull
            private static final String str = "(";

            private OPEN_BRAC() {
            }

            @Override
            @NotNull
            public String getStr() {
                return str;
            }

            @NotNull
            public String toString() {
                return "OPEN_BRAC";
            }

            public int hashCode() {
                return 1778891429;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OPEN_BRAC)) {
                    return false;
                }
                OPEN_BRAC cfr_ignored_0 = (OPEN_BRAC)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$Op;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "op", "", "(Ljava/lang/String;)V", "getOp", "()Ljava/lang/String;", "str", "getStr", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class Op
        implements Token {
            @NotNull
            private final String op;
            @NotNull
            private final String str;

            public Op(@NotNull String op) {
                this.str = this.op = op;
            }

            @NotNull
            public final String getOp() {
                return this.op;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @NotNull
            public final String component1() {
                return this.op;
            }

            @NotNull
            public final Op copy(@NotNull String op) {
                return new Op(op);
            }

            public static /* synthetic */ Op copy$default(Op op, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = op.op;
                }
                return op.copy(string);
            }

            @NotNull
            public String toString() {
                return "Op(op=" + this.op + ")";
            }

            public int hashCode() {
                return this.op.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Op)) {
                    return false;
                }
                Op op = (Op)other;
                return Intrinsics.areEqual(this.op, op.op);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$ParamsReader;", "", "params", "", "(Ljava/util/List;)V", "hasMore", "", "getHasMore", "()Z", "getParams", "()Ljava/util/List;", "reader", "Lkorlibs/datastructure/ListReader;", "getReader", "()Lkorlibs/datastructure/ListReader;", "block", "Lkorlibs/wasm/WasmReaderText$WastBlock;", "peek", "read", "rest", "restBlock", "string", "", "korge-core"})
        @SourceDebugExtension(value={"SMAP\nWasmReaderText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText$WastParser$ParamsReader\n+ 2 _Extensions.kt\nkorlibs/datastructure/_ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,831:1\n12#2:832\n1#3:833\n1549#4:834\n1620#4,3:835\n*S KotlinDebug\n*F\n+ 1 WasmReaderText.kt\nkorlibs/wasm/WasmReaderText$WastParser$ParamsReader\n*L\n784#1:832\n784#1:833\n785#1:834\n785#1:835,3\n*E\n"})
        public static final class ParamsReader {
            @NotNull
            private final List<Object> params;
            @NotNull
            private final ListReader<Object> reader;

            public ParamsReader(@NotNull List<? extends Object> params) {
                this.params = params;
                this.reader = new ListReader<Object>(this.params);
            }

            @NotNull
            public final List<Object> getParams() {
                return this.params;
            }

            @NotNull
            public final ListReader<Object> getReader() {
                return this.reader;
            }

            public final boolean getHasMore() {
                return this.reader.getHasMore();
            }

            @NotNull
            public final List<Object> rest() {
                ArrayList arrayList;
                boolean $i$f$mapWhile = false;
                ArrayList $this$mapWhile_u24lambda_u240$iv = arrayList = new ArrayList();
                boolean bl = false;
                while (true) {
                    int it = $this$mapWhile_u24lambda_u240$iv.size();
                    boolean bl2 = false;
                    if (!this.reader.getHasMore()) break;
                    it = $this$mapWhile_u24lambda_u240$iv.size();
                    Collection collection = $this$mapWhile_u24lambda_u240$iv;
                    boolean bl3 = false;
                    collection.add(this.reader.read());
                }
                return arrayList;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<WastBlock> restBlock() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.rest();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type korlibs.wasm.WasmReaderText.WastBlock");
                    collection.add((WastBlock)it);
                }
                return (List)destination$iv$iv;
            }

            @Nullable
            public final Object peek() {
                return this.reader.peek();
            }

            @Nullable
            public final Object read() {
                return this.reader.read();
            }

            @NotNull
            public final String string() {
                Object object = this.reader.read();
                String string = object instanceof String ? (String)object : null;
                if (string == null) {
                    throw new IllegalStateException((this + " at index=" + this.reader.getPosition() + " is not a String").toString());
                }
                return string;
            }

            @NotNull
            public final WastBlock block() {
                Object object = this.reader.read();
                WastBlock wastBlock = object instanceof WastBlock ? (WastBlock)object : null;
                if (wastBlock == null) {
                    throw new IllegalStateException((this + " at index=" + this.reader.getPosition() + " is not a Block").toString());
                }
                return wastBlock;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$SpecialNum;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "special", "", "num", "(Ljava/lang/String;Ljava/lang/String;)V", "getNum", "()Ljava/lang/String;", "getSpecial", "str", "getStr", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class SpecialNum
        implements Token {
            @NotNull
            private final String special;
            @NotNull
            private final String num;
            @NotNull
            private final String str;

            public SpecialNum(@NotNull String special, @NotNull String num) {
                this.special = special;
                this.num = num;
                this.str = this.special + ":" + this.num;
            }

            @NotNull
            public final String getSpecial() {
                return this.special;
            }

            @NotNull
            public final String getNum() {
                return this.num;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @NotNull
            public final String component1() {
                return this.special;
            }

            @NotNull
            public final String component2() {
                return this.num;
            }

            @NotNull
            public final SpecialNum copy(@NotNull String special, @NotNull String num) {
                return new SpecialNum(special, num);
            }

            public static /* synthetic */ SpecialNum copy$default(SpecialNum specialNum, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = specialNum.special;
                }
                if ((n & 2) != 0) {
                    string2 = specialNum.num;
                }
                return specialNum.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "SpecialNum(special=" + this.special + ", num=" + this.num + ")";
            }

            public int hashCode() {
                int result2 = this.special.hashCode();
                result2 = result2 * 31 + this.num.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SpecialNum)) {
                    return false;
                }
                SpecialNum specialNum = (SpecialNum)other;
                if (!Intrinsics.areEqual(this.special, specialNum.special)) {
                    return false;
                }
                return Intrinsics.areEqual(this.num, specialNum.num);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$Str;", "Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "string", "", "(Ljava/lang/String;)V", "str", "getStr", "()Ljava/lang/String;", "getString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
        public static final class Str
        implements Token {
            @NotNull
            private final String string;
            @NotNull
            private final String str;

            public Str(@NotNull String string) {
                this.str = this.string = string;
            }

            @NotNull
            public final String getString() {
                return this.string;
            }

            @Override
            @NotNull
            public String getStr() {
                return this.str;
            }

            @NotNull
            public final String component1() {
                return this.string;
            }

            @NotNull
            public final Str copy(@NotNull String string) {
                return new Str(string);
            }

            public static /* synthetic */ Str copy$default(Str str, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = str.string;
                }
                return str.copy(string);
            }

            @NotNull
            public String toString() {
                return "Str(string=" + this.string + ")";
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Str)) {
                    return false;
                }
                Str str = (Str)other;
                return Intrinsics.areEqual(this.string, str.string);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lkorlibs/wasm/WasmReaderText$WastParser$Token;", "", "str", "", "getStr", "()Ljava/lang/String;", "korge-core"})
        public static interface Token {
            @NotNull
            public String getStr();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lkorlibs/wasm/WasmReaderText$WastValue;", "Lkorlibs/wasm/WasmReaderText$WastBlockOrValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "korge-core"})
    public static final class WastValue
    implements WastBlockOrValue {
        @NotNull
        private final String value;

        public WastValue(@NotNull String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final WastValue copy(@NotNull String value) {
            return new WastValue(value);
        }

        public static /* synthetic */ WastValue copy$default(WastValue wastValue, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = wastValue.value;
            }
            return wastValue.copy(string);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WastValue)) {
                return false;
            }
            WastValue wastValue = (WastValue)other;
            return Intrinsics.areEqual(this.value, wastValue.value);
        }
    }
}

