/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.datastructure.ArrayListKt;
import korlibs.datastructure.DoubleArrayList;
import korlibs.datastructure.FloatArrayList;
import korlibs.datastructure.IntArrayList;
import korlibs.datastructure._ExtensionsKt;
import korlibs.encoding.HexKt;
import korlibs.memory.BufferKt;
import korlibs.wasm.NamedWasmType;
import korlibs.wasm.WasmAssert;
import korlibs.wasm.WasmAssertReturn;
import korlibs.wasm.WasmCode;
import korlibs.wasm.WasmCodeVisitor;
import korlibs.wasm.WasmCodeVisitorKt;
import korlibs.wasm.WasmCommonKt;
import korlibs.wasm.WasmData;
import korlibs.wasm.WasmDebugContext;
import korlibs.wasm.WasmElement;
import korlibs.wasm.WasmExpr;
import korlibs.wasm.WasmFunc;
import korlibs.wasm.WasmGlobal;
import korlibs.wasm.WasmImport;
import korlibs.wasm.WasmInstruction;
import korlibs.wasm.WasmInterpreterCode;
import korlibs.wasm.WasmModule;
import korlibs.wasm.WasmRunInterpreter;
import korlibs.wasm.WasmRuntime;
import korlibs.wasm.WasmSType;
import korlibs.wasm.WasmType;
import korlibs.wasm.WastLocal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0004\u0085\u0001\u0086\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007JA\u0010,\u001a\u00020-26\u0010.\u001a2\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u0002000/H\u0086\bJA\u00105\u001a\u00020626\u0010.\u001a2\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u0002060/H\u0086\bJA\u00107\u001a\u00020-26\u0010.\u001a2\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00050/H\u0086\bJA\u00108\u001a\u00020-26\u0010.\u001a2\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u0002090/H\u0086\bJA\u0010:\u001a\u00020626\u0010.\u001a2\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u0002060/H\u0086\bJA\u0010;\u001a\u00020-26\u0010.\u001a2\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00050/H\u0086\bJA\u0010<\u001a\u00020-26\u0010.\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00050/H\u0086\bJA\u0010=\u001a\u00020626\u0010.\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u0002060/H\u0086\bJA\u0010>\u001a\u00020-26\u0010.\u001a2\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020?0/H\u0086\bJA\u0010@\u001a\u00020626\u0010.\u001a2\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u0002060/H\u0086\bJA\u0010A\u001a\u00020-26\u0010.\u001a2\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(3\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00050/H\u0086\bJ\u0010\u0010B\u001a\u00020-2\u0006\u0010.\u001a\u00020CH\u0002J\u001e\u0010D\u001a\u00020E2\u0006\u0010.\u001a\u00020C2\u0006\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020HJ&\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020O2\u0006\u0010G\u001a\u00020HJ\u0018\u0010P\u001a\u00020-2\u0006\u0010Q\u001a\u00020E2\u0006\u0010R\u001a\u00020\u0005H\u0002J\u000e\u0010S\u001a\u0002002\u0006\u0010T\u001a\u00020\u0005J\u000e\u0010U\u001a\u0002092\u0006\u0010T\u001a\u00020\u0005J\u000e\u0010V\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u0005J\u000e\u0010W\u001a\u00020?2\u0006\u0010T\u001a\u00020\u0005J\u0006\u0010X\u001a\u00020\u0000J\u000e\u0010Y\u001a\u00020-2\u0006\u0010.\u001a\u00020CJ0\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\\2\u0016\u0010]\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010Z0^\"\u0004\u0018\u00010ZH\u0096\u0002\u00a2\u0006\u0002\u0010_J/\u0010`\u001a\u0004\u0018\u00010Z2\u0006\u0010R\u001a\u00020\u00052\u0016\u0010]\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010Z0^\"\u0004\u0018\u00010ZH\u0016\u00a2\u0006\u0002\u0010aJ\u0006\u0010b\u001a\u000200J\u0006\u0010c\u001a\u000209J\u0006\u0010d\u001a\u00020\u0005J\u0006\u0010e\u001a\u00020?J\u0010\u0010f\u001a\u0004\u0018\u00010Z2\u0006\u0010N\u001a\u00020gJ\u000e\u0010h\u001a\u00020-2\u0006\u0010i\u001a\u000200J\u000e\u0010j\u001a\u00020-2\u0006\u0010i\u001a\u000209J\u000e\u0010k\u001a\u00020-2\u0006\u0010i\u001a\u00020\u0005J\u000e\u0010l\u001a\u00020-2\u0006\u0010i\u001a\u00020?J\u0018\u0010m\u001a\u00020-2\u0006\u0010N\u001a\u00020g2\b\u0010i\u001a\u0004\u0018\u00010ZJ!\u0010n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010Z0^2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020K0J\u00a2\u0006\u0002\u0010pJ\u0006\u0010q\u001a\u00020-J\u0018\u0010r\u001a\u00020-2\u0006\u0010s\u001a\u00020t2\b\u0010i\u001a\u0004\u0018\u00010ZJ \u0010u\u001a\u00020-2\u0006\u0010N\u001a\u00020g2\u0006\u0010T\u001a\u00020\u00052\b\u0010i\u001a\u0004\u0018\u00010ZJ\u0016\u0010v\u001a\u0002002\u0006\u0010T\u001a\u00020\u00052\u0006\u0010i\u001a\u000200J\u0016\u0010w\u001a\u0002092\u0006\u0010T\u001a\u00020\u00052\u0006\u0010i\u001a\u000209J\u0016\u0010x\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u00052\u0006\u0010i\u001a\u00020\u0005J\u0016\u0010y\u001a\u00020?2\u0006\u0010T\u001a\u00020\u00052\u0006\u0010i\u001a\u00020?J,\u0010z\u001a\u00020-2!\u0010.\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u0002000{H\u0086\bJ,\u0010}\u001a\u0002062!\u0010.\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u0002060{H\u0086\bJ,\u0010~\u001a\u00020-2!\u0010.\u001a\u001d\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u0002090{H\u0086\bJ,\u0010\u007f\u001a\u0002062!\u0010.\u001a\u001d\u0012\u0013\u0012\u001109\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u0002060{H\u0086\bJ-\u0010\u0080\u0001\u001a\u00020-2!\u0010.\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u00020\u00050{H\u0086\bJ-\u0010\u0081\u0001\u001a\u0002062!\u0010.\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u0002060{H\u0086\bJ-\u0010\u0082\u0001\u001a\u00020-2!\u0010.\u001a\u001d\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u00020?0{H\u0086\bJ-\u0010\u0083\u0001\u001a\u0002062!\u0010.\u001a\u001d\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b1\u0012\b\b2\u0012\u0004\b\b(|\u0012\u0004\u0012\u0002060{H\u0086\bJ\r\u0010\u0084\u0001\u001a\u0004\u0018\u00010E*\u00020CR\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\n\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u0011\u0010#\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0012R\u0011\u0010%\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016R\u0011\u0010'\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001aR\u001a\u0010)\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\n\"\u0004\b+\u0010\u001e\u00a8\u0006\u0087\u0001"}, d2={"Lkorlibs/wasm/WasmRunInterpreter;", "Lkorlibs/wasm/WasmRuntime;", "module", "Lkorlibs/wasm/WasmModule;", "memPages", "", "maxMemPages", "(Lkorlibs/wasm/WasmModule;II)V", "MAX_STACK", "getMAX_STACK", "()I", "globalsD", "", "getGlobalsD", "()[D", "globalsF", "", "getGlobalsF", "()[F", "globalsI", "", "getGlobalsI", "()[I", "globalsL", "", "getGlobalsL", "()[J", "localsPos", "getLocalsPos", "setLocalsPos", "(I)V", "getModule", "()Lkorlibs/wasm/WasmModule;", "stackD", "getStackD", "stackF", "getStackF", "stackI", "getStackI", "stackL", "getStackL", "stackPos", "getStackPos", "setStackPos", "binopF32", "", "func", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "l", "r", "binopF32_bool", "", "binopF32_int", "binopF64", "", "binopF64_bool", "binopF64_int", "binopI32", "binopI32_bool", "binopI64", "", "binopI64_bool", "binopI64_int", "callFunc", "Lkorlibs/wasm/WasmFunc;", "compile", "Lkorlibs/wasm/WasmInterpreterCode;", "implicitReturn", "debug", "Lkorlibs/wasm/WasmDebugContext;", "eval", "", "Lkorlibs/wasm/WasmType;", "expr", "Lkorlibs/wasm/WasmExpr;", "type", "Lkorlibs/wasm/WasmType$Function;", "evalInstructions", "code", "index", "getLocalF32", "offset", "getLocalF64", "getLocalI32", "getLocalI64", "initGlobals", "invoke", "", "funcName", "", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeIndirect", "(I[Ljava/lang/Object;)Ljava/lang/Object;", "popF32", "popF64", "popI32", "popI64", "popType", "Lkorlibs/wasm/WasmSType;", "pushF32", "value", "pushF64", "pushI32", "pushI64", "pushType", "readTypes", "types", "(Ljava/util/List;)[Ljava/lang/Object;", "runAsserts", "setGlobal", "global", "Lkorlibs/wasm/WasmGlobal;", "setLocal", "setLocalF32", "setLocalF64", "setLocalI32", "setLocalI64", "unopF32", "Lkotlin/Function1;", "it", "unopF32_bool", "unopF64", "unopF64_bool", "unopI32", "unopI32_bool", "unopI64", "unopI64_bool", "getInterprerCode", "WasmFastInstructions", "WasmFuncCallInt", "korge-core"})
@SourceDebugExtension(value={"SMAP\nWasmRunInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmRunInterpreter.kt\nkorlibs/wasm/WasmRunInterpreter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1676:1\n182#1:1690\n127#1,4:1691\n127#1,4:1695\n127#1,4:1699\n127#1,4:1703\n127#1,4:1707\n127#1,4:1711\n127#1,4:1715\n127#1,4:1719\n127#1,4:1723\n127#1,4:1727\n168#1,4:1731\n168#1,4:1735\n168#1,4:1739\n168#1,4:1743\n168#1,4:1747\n168#1,4:1751\n168#1,4:1755\n168#1,4:1759\n168#1,4:1763\n168#1,4:1767\n173#1,4:1771\n173#1,4:1775\n173#1,4:1779\n173#1,4:1783\n173#1,4:1787\n173#1,4:1791\n178#1,4:1795\n178#1,4:1799\n178#1,4:1803\n178#1,4:1807\n178#1,4:1811\n178#1,4:1815\n182#1:1819\n182#1:1820\n182#1:1821\n127#1,4:1822\n127#1,4:1826\n127#1,4:1830\n127#1,4:1834\n127#1,4:1838\n127#1,4:1842\n127#1,4:1846\n127#1,4:1850\n127#1,4:1854\n127#1,4:1858\n127#1,4:1862\n127#1,4:1866\n127#1,4:1870\n127#1,4:1874\n127#1,4:1878\n183#1:1882\n183#1:1883\n183#1:1884\n200#1,4:1885\n200#1,4:1889\n200#1,4:1893\n200#1,4:1897\n200#1,4:1901\n200#1,4:1905\n200#1,4:1909\n200#1,4:1913\n200#1,4:1917\n200#1,4:1921\n200#1,4:1925\n200#1,4:1929\n200#1,4:1933\n200#1,4:1937\n200#1,4:1941\n184#1:1945\n184#1:1946\n184#1:1947\n184#1:1948\n184#1:1949\n184#1:1950\n184#1:1951\n188#1,4:1952\n188#1,4:1956\n188#1,4:1960\n188#1,4:1964\n188#1,4:1968\n188#1,4:1972\n188#1,4:1976\n185#1:1980\n185#1:1981\n185#1:1982\n185#1:1983\n185#1:1984\n185#1:1985\n185#1:1986\n194#1,4:1987\n194#1,4:1991\n194#1,4:1995\n194#1,4:1999\n194#1,4:2003\n194#1,4:2007\n194#1,4:2011\n127#1,4:2015\n200#1,4:2019\n188#1,4:2023\n194#1,4:2027\n132#1,2:2031\n148#1,3:2033\n148#1,3:2036\n148#1,3:2039\n148#1,3:2042\n148#1,3:2045\n148#1,3:2048\n148#1,3:2051\n148#1,3:2054\n148#1,3:2057\n148#1,3:2060\n140#1,2:2063\n163#1,3:2065\n163#1,3:2068\n163#1,3:2071\n163#1,3:2074\n163#1,3:2077\n163#1,3:2080\n163#1,3:2083\n163#1,3:2086\n163#1,3:2089\n163#1,3:2092\n153#1,3:2095\n153#1,3:2098\n153#1,3:2101\n153#1,3:2104\n153#1,3:2107\n153#1,3:2110\n158#1,3:2113\n158#1,3:2116\n158#1,3:2119\n158#1,3:2122\n158#1,3:2125\n158#1,3:2128\n1864#2,3:1677\n1549#2:1680\n1620#2,3:1681\n1549#2:1686\n1620#2,3:1687\n37#3,2:1684\n1#4:2131\n*S KotlinDebug\n*F\n+ 1 WasmRunInterpreter.kt\nkorlibs/wasm/WasmRunInterpreter\n*L\n312#1:1690\n313#1:1691,4\n314#1:1695,4\n315#1:1699,4\n320#1:1703,4\n321#1:1707,4\n322#1:1711,4\n327#1:1715,4\n328#1:1719,4\n329#1:1723,4\n330#1:1727,4\n332#1:1731,4\n333#1:1735,4\n334#1:1739,4\n335#1:1743,4\n336#1:1747,4\n337#1:1751,4\n338#1:1755,4\n339#1:1759,4\n340#1:1763,4\n341#1:1767,4\n342#1:1771,4\n343#1:1775,4\n344#1:1779,4\n345#1:1783,4\n346#1:1787,4\n347#1:1791,4\n348#1:1795,4\n349#1:1799,4\n350#1:1803,4\n351#1:1807,4\n352#1:1811,4\n353#1:1815,4\n354#1:1819\n355#1:1820\n356#1:1821\n357#1:1822,4\n361#1:1826,4\n362#1:1830,4\n363#1:1834,4\n364#1:1838,4\n365#1:1842,4\n366#1:1846,4\n367#1:1850,4\n368#1:1854,4\n369#1:1858,4\n370#1:1862,4\n371#1:1866,4\n372#1:1870,4\n373#1:1874,4\n374#1:1878,4\n375#1:1882\n376#1:1883\n377#1:1884\n378#1:1885,4\n379#1:1889,4\n380#1:1893,4\n381#1:1897,4\n382#1:1901,4\n383#1:1905,4\n384#1:1909,4\n385#1:1913,4\n386#1:1917,4\n387#1:1921,4\n388#1:1925,4\n389#1:1929,4\n390#1:1933,4\n391#1:1937,4\n392#1:1941,4\n393#1:1945\n394#1:1946\n395#1:1947\n396#1:1948\n397#1:1949\n398#1:1950\n399#1:1951\n400#1:1952,4\n401#1:1956,4\n402#1:1960,4\n403#1:1964,4\n404#1:1968,4\n405#1:1972,4\n406#1:1976,4\n407#1:1980\n408#1:1981\n409#1:1982\n410#1:1983\n411#1:1984\n412#1:1985\n413#1:1986\n414#1:1987,4\n415#1:1991,4\n416#1:1995,4\n417#1:1999,4\n418#1:2003,4\n419#1:2007,4\n420#1:2011,4\n511#1:2015,4\n512#1:2019,4\n513#1:2023,4\n514#1:2027,4\n540#1:2031,2\n541#1:2033,3\n542#1:2036,3\n543#1:2039,3\n544#1:2042,3\n545#1:2045,3\n546#1:2048,3\n547#1:2051,3\n548#1:2054,3\n549#1:2057,3\n550#1:2060,3\n551#1:2063,2\n552#1:2065,3\n553#1:2068,3\n554#1:2071,3\n555#1:2074,3\n556#1:2077,3\n557#1:2080,3\n558#1:2083,3\n559#1:2086,3\n560#1:2089,3\n561#1:2092,3\n562#1:2095,3\n563#1:2098,3\n564#1:2101,3\n565#1:2104,3\n566#1:2107,3\n567#1:2110,3\n568#1:2113,3\n569#1:2116,3\n570#1:2119,3\n571#1:2122,3\n572#1:2125,3\n573#1:2128,3\n46#1:1677,3\n206#1:1680\n206#1:1681,3\n227#1:1686\n227#1:1687,3\n206#1:1684,2\n*E\n"})
public final class WasmRunInterpreter
extends WasmRuntime {
    @NotNull
    private final WasmModule module;
    @NotNull
    private final int[] globalsI;
    @NotNull
    private final float[] globalsF;
    @NotNull
    private final double[] globalsD;
    @NotNull
    private final long[] globalsL;
    private final int MAX_STACK;
    @NotNull
    private final int[] stackI;
    @NotNull
    private final float[] stackF;
    @NotNull
    private final double[] stackD;
    @NotNull
    private final long[] stackL;
    private int localsPos;
    private int stackPos;

    public WasmRunInterpreter(@NotNull WasmModule module, int memPages, int maxMemPages) {
        super(module, memPages, maxMemPages);
        this.module = module;
        this.globalsI = new int[this.module.getGlobals().size()];
        this.globalsF = new float[this.module.getGlobals().size()];
        this.globalsD = new double[this.module.getGlobals().size()];
        this.globalsL = new long[this.module.getGlobals().size()];
        this.MAX_STACK = 2048;
        this.stackI = new int[this.MAX_STACK];
        this.stackF = new float[this.MAX_STACK];
        this.stackD = new double[this.MAX_STACK];
        this.stackL = new long[this.MAX_STACK];
    }

    public /* synthetic */ WasmRunInterpreter(WasmModule wasmModule, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 10;
        }
        if ((n3 & 4) != 0) {
            n2 = 65536;
        }
        this(wasmModule, n, n2);
    }

    @NotNull
    public final WasmModule getModule() {
        return this.module;
    }

    @NotNull
    public final int[] getGlobalsI() {
        return this.globalsI;
    }

    @NotNull
    public final float[] getGlobalsF() {
        return this.globalsF;
    }

    @NotNull
    public final double[] getGlobalsD() {
        return this.globalsD;
    }

    @NotNull
    public final long[] getGlobalsL() {
        return this.globalsL;
    }

    public final int getMAX_STACK() {
        return this.MAX_STACK;
    }

    @NotNull
    public final int[] getStackI() {
        return this.stackI;
    }

    @NotNull
    public final float[] getStackF() {
        return this.stackF;
    }

    @NotNull
    public final double[] getStackD() {
        return this.stackD;
    }

    @NotNull
    public final long[] getStackL() {
        return this.stackL;
    }

    public final int getLocalsPos() {
        return this.localsPos;
    }

    public final void setLocalsPos(int n) {
        this.localsPos = n;
    }

    public final int getStackPos() {
        return this.stackPos;
    }

    public final void setStackPos(int n) {
        this.stackPos = n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WasmRunInterpreter initGlobals() {
        int index2;
        WasmExpr e;
        for (WasmElement element : this.module.getElements()) {
            if (element.getExpr() == null) continue;
            this.eval(e, new WasmType.Function(CollectionsKt.emptyList(), CollectionsKt.listOf(WasmSType.I32)), new WasmDebugContext("element", element.getTableIdx()));
            index2 = this.popI32();
            Iterable $this$forEachIndexed$iv = element.getFunctions(this.module);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void wasmFunc;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                WasmFunc wasmFunc2 = (WasmFunc)item$iv;
                int idx = n;
                boolean bl = false;
                this.getTables().get((int)element.getTableIdx()).getElements()[index2 + idx] = new WasmFuncCallInt(this, (WasmFunc)wasmFunc);
            }
        }
        for (WasmData data2 : this.module.getDatas()) {
            if (data2.getE() == null) continue;
            this.eval(e, new WasmType.Function(CollectionsKt.emptyList(), CollectionsKt.listOf(WasmSType.I32)), new WasmDebugContext("data", data2.getIndex()));
            index2 = this.popI32();
            BufferKt.setArrayInt8$default(this.getMemory(), index2, data2.getData(), 0, 0, 12, null);
        }
        for (WasmGlobal global : this.module.getGlobals()) {
            if (global.getExpr() == null) continue;
            this.eval(global.getExpr(), new WasmType.Function(CollectionsKt.emptyList(), CollectionsKt.listOf(global.getGlobalType())), new WasmDebugContext("global", global.getIndex()));
            Object value = this.popType(WasmCommonKt.toWasmSType(global.getGlobalType()));
            this.setGlobal(global, value);
        }
        if (this.module.getStartFunc() >= 0) {
            this.invoke(this.module.getFunctions().get(this.module.getStartFunc()));
        }
        return this;
    }

    public final void runAsserts() {
        int failed = 0;
        int total = 0;
        for (WasmAssert wasmAssert : this.module.getAsserts()) {
            if (!(wasmAssert instanceof WasmAssertReturn)) continue;
            String msg = ((WasmAssertReturn)wasmAssert).getMsg();
            this.stackPos = 0;
            List<WasmType> typeActual = this.eval(((WasmAssertReturn)wasmAssert).getActual(), new WasmType.Function(CollectionsKt.emptyList(), CollectionsKt.listOf(WasmSType.I32)), new WasmDebugContext("assertActual", total));
            List<WasmType> typeExpect = this.eval(((WasmAssertReturn)wasmAssert).getExpect(), new WasmType.Function(CollectionsKt.emptyList(), CollectionsKt.listOf(WasmSType.I32)), new WasmDebugContext("assertExpect", total));
            ++total;
            if (!Intrinsics.areEqual(typeActual, typeExpect)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Object expect = this.popType(WasmCommonKt.toWasmSType(CollectionsKt.first(typeExpect)));
            Object actual = this.popType(WasmCommonKt.toWasmSType(CollectionsKt.first(typeActual)));
            failed += WasmRuntime.Companion.assert_return_any(actual, expect, msg);
        }
        WasmRuntime.Companion.assert_summary(failed, total);
    }

    @NotNull
    public final List<WasmType> eval(@Nullable WasmExpr expr2, @NotNull WasmType.Function type2, @NotNull WasmDebugContext debug) {
        if (expr2 == null) {
            return CollectionsKt.emptyList();
        }
        WasmInterpreterCode code = this.compile(WasmFunc.Companion.anonymousFunc(type2, expr2), false, debug);
        this.evalInstructions(code, 0);
        return code.getEndStack();
    }

    @Nullable
    public final WasmInterpreterCode getInterprerCode(@NotNull WasmFunc $this$getInterprerCode) {
        if ($this$getInterprerCode.getCode() == null) {
            return null;
        }
        WasmCode wasmCode = $this$getInterprerCode.getCode();
        if ((wasmCode != null ? wasmCode.getInterpreterCode() : null) == null) {
            WasmCode wasmCode2 = $this$getInterprerCode.getCode();
            if (wasmCode2 != null) {
                wasmCode2.setInterpreterCode(this.compile($this$getInterprerCode, true, new WasmDebugContext($this$getInterprerCode.getName(), $this$getInterprerCode.getIndex())));
            }
        }
        WasmCode wasmCode3 = $this$getInterprerCode.getCode();
        return wasmCode3 != null ? wasmCode3.getInterpreterCode() : null;
    }

    public final void invoke(@NotNull WasmFunc func2) {
        WasmInterpreterCode code = this.getInterprerCode(func2);
        if (code != null) {
            this.localsPos += 0;
            this.stackPos += code.getLocalsCount();
        } else {
            LinkedHashMap<String, Function2<WasmRuntime, Object[], Object>> efunc = this.getFunctions().get(func2.getName());
            String string = "efunc=" + efunc;
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        this.evalInstructions(code, 0);
    }

    public final void binopI32(@NotNull Function2<? super Integer, ? super Integer, Integer> func2) {
        boolean $i$f$binopI32 = false;
        int r = this.popI32();
        int l = this.popI32();
        this.pushI32(((Number)func2.invoke((Integer)l, (Integer)r)).intValue());
    }

    public final boolean unopI32_bool(@NotNull Function1<? super Integer, Boolean> func2) {
        boolean $i$f$unopI32_bool = false;
        int it = this.popI32();
        return func2.invoke((Integer)it);
    }

    public final boolean unopF32_bool(@NotNull Function1<? super Float, Boolean> func2) {
        boolean $i$f$unopF32_bool = false;
        float it = this.popF32();
        return func2.invoke(Float.valueOf(it));
    }

    public final boolean unopI64_bool(@NotNull Function1<? super Long, Boolean> func2) {
        boolean $i$f$unopI64_bool = false;
        long it = this.popI64();
        return func2.invoke((Long)it);
    }

    public final boolean unopF64_bool(@NotNull Function1<? super Double, Boolean> func2) {
        boolean $i$f$unopF64_bool = false;
        double it = this.popF64();
        return func2.invoke((Double)it);
    }

    public final boolean binopI32_bool(@NotNull Function2<? super Integer, ? super Integer, Boolean> func2) {
        boolean $i$f$binopI32_bool = false;
        int r = this.popI32();
        int l = this.popI32();
        return func2.invoke((Integer)l, (Integer)r);
    }

    public final boolean binopF32_bool(@NotNull Function2<? super Float, ? super Float, Boolean> func2) {
        boolean $i$f$binopF32_bool = false;
        float r = this.popF32();
        float l = this.popF32();
        return func2.invoke(Float.valueOf(l), Float.valueOf(r));
    }

    public final boolean binopF64_bool(@NotNull Function2<? super Double, ? super Double, Boolean> func2) {
        boolean $i$f$binopF64_bool = false;
        double r = this.popF64();
        double l = this.popF64();
        return func2.invoke((Double)l, (Double)r);
    }

    public final boolean binopI64_bool(@NotNull Function2<? super Long, ? super Long, Boolean> func2) {
        boolean $i$f$binopI64_bool = false;
        long r = this.popI64();
        long l = this.popI64();
        return func2.invoke((Long)l, (Long)r);
    }

    public final void binopI64_int(@NotNull Function2<? super Long, ? super Long, Integer> func2) {
        boolean $i$f$binopI64_int = false;
        long r = this.popI64();
        long l = this.popI64();
        this.pushI32(((Number)func2.invoke((Long)l, (Long)r)).intValue());
    }

    public final void binopF32_int(@NotNull Function2<? super Float, ? super Float, Integer> func2) {
        boolean $i$f$binopF32_int = false;
        float r = this.popF32();
        float l = this.popF32();
        this.pushI32(((Number)func2.invoke(Float.valueOf(l), Float.valueOf(r))).intValue());
    }

    public final void binopF64_int(@NotNull Function2<? super Double, ? super Double, Integer> func2) {
        boolean $i$f$binopF64_int = false;
        double r = this.popF64();
        double l = this.popF64();
        this.pushI32(((Number)func2.invoke((Double)l, (Double)r)).intValue());
    }

    public final void unopI32(@NotNull Function1<? super Integer, Integer> func2) {
        boolean $i$f$unopI32 = false;
        this.pushI32(((Number)func2.invoke((Integer)this.popI32())).intValue());
    }

    public final void unopI64(@NotNull Function1<? super Long, Long> func2) {
        boolean $i$f$unopI64 = false;
        this.pushI64(((Number)func2.invoke((Long)this.popI64())).longValue());
    }

    public final void unopF32(@NotNull Function1<? super Float, Float> func2) {
        boolean $i$f$unopF32 = false;
        this.pushF32(((Number)func2.invoke(Float.valueOf(this.popF32()))).floatValue());
    }

    public final void unopF64(@NotNull Function1<? super Double, Double> func2) {
        boolean $i$f$unopF64 = false;
        this.pushF64(((Number)func2.invoke((Double)this.popF64())).doubleValue());
    }

    public final void binopF32(@NotNull Function2<? super Float, ? super Float, Float> func2) {
        boolean $i$f$binopF32 = false;
        float r = this.popF32();
        float l = this.popF32();
        this.pushF32(((Number)func2.invoke(Float.valueOf(l), Float.valueOf(r))).floatValue());
    }

    public final void binopF64(@NotNull Function2<? super Double, ? super Double, Double> func2) {
        boolean $i$f$binopF64 = false;
        double r = this.popF64();
        double l = this.popF64();
        this.pushF64(((Number)func2.invoke((Double)l, (Double)r)).doubleValue());
    }

    public final void binopI64(@NotNull Function2<? super Long, ? super Long, Long> func2) {
        boolean $i$f$binopI64 = false;
        long r = this.popI64();
        long l = this.popI64();
        this.pushI64(((Number)func2.invoke((Long)l, (Long)r)).longValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object[] readTypes(@NotNull List<? extends WasmType> types2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)types2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WasmType wasmType = (WasmType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.popType(WasmCommonKt.toWasmSType((WasmType)it)));
        }
        Collection $this$toTypedArray$iv = CollectionsKt.reversed((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final void callFunc(WasmFunc func2) {
        WasmInterpreterCode code = this.getInterprerCode(func2);
        if (code != null) {
            int oldLocalsPos = this.localsPos;
            this.localsPos = this.stackPos - code.getParamsCount();
            this.stackPos = this.localsPos + code.getLocalsCount();
            this.invoke(func2);
            this.localsPos = oldLocalsPos;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            WasmImport wasmImport = func2.getFimport();
            if (wasmImport == null) {
                throw new IllegalStateException("Not body and not an import".toString());
            }
            WasmImport fimport = wasmImport;
            LinkedHashMap<String, Function2<WasmRuntime, Object[], Object>> linkedHashMap = this.getFunctions().get(fimport.getModuleName());
            if (linkedHashMap == null || (linkedHashMap = linkedHashMap.get(fimport.getName())) == null) {
                throw new IllegalStateException(("Can't find function " + fimport).toString());
            }
            LinkedHashMap<String, Function2<WasmRuntime, Object[], Object>> ffunc = linkedHashMap;
            Iterable iterable = func2.getType().getArgs();
            WasmRunInterpreter wasmRunInterpreter = this;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WastLocal wastLocal = (WastLocal)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getType());
            }
            Object[] args2 = wasmRunInterpreter.readTypes((List)destination$iv$iv);
            Object result2 = ffunc.invoke(this, args2);
            this.pushType(WasmCommonKt.toWasmSType(func2.getType().getRetType()), result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void evalInstructions(WasmInterpreterCode code, int index2) {
        int index3 = index2;
        int[] instructions = code.getInstructions();
        int instructionsExecuted = 0;
        block284: while (true) {
            boolean bl = 0 <= index3 ? index3 < instructions.length : false;
            if (!bl) break;
            int i2 = instructions[index3];
            int op = i2 & 0xFFF;
            int param = i2 >> 12;
            if (this.getTrace()) {
                String string = "OP[" + code.getDebug().getName() + "][" + index3 + "]: " + HexKt.getHex(op) + ", param=" + param + " : " + WasmFastInstructions.INSTANCE.getNAME_FROM_OP().get(op) + ", localsPos=" + this.localsPos + ", stack=" + this.stackPos;
                System.out.println((Object)string);
            }
            ++instructionsExecuted;
            int n = op;
            switch (n) {
                case 6: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 7: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 8: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 9: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 16: {
                    WasmFunc func2 = this.module.getFunctions().get(param);
                    this.callFunc(func2);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 17: {
                    WasmRuntime.WasmFuncCall item2;
                    int tableIdx = 0;
                    NamedWasmType ntype = this.module.getTypes().get(param);
                    WasmType wasmType = ntype.getType();
                    Intrinsics.checkNotNull(wasmType, "null cannot be cast to non-null type korlibs.wasm.WasmType.Function");
                    WasmType.Function funcType2 = (WasmType.Function)wasmType;
                    int funcIndex = this.popI32();
                    WasmRuntime.WasmFuncCall wasmFuncCall = this.getTables().get(tableIdx).getElements()[funcIndex];
                    if (wasmFuncCall == null) {
                        throw new IllegalStateException(("null function at table=" + tableIdx + ", funcIndex=" + funcIndex + ", funcType=" + funcType2).toString());
                    }
                    Object[] params = new Object[funcType2.getArgs().size()];
                    int n2 = funcType2.getArgs().size();
                    block285: for (int n3 = 0; n3 < n2; ++n3) {
                        WastLocal arg = funcType2.getArgs().get(funcType2.getArgs().size() - 1 - n3);
                        WasmSType wasmSType = arg.getStype();
                        int n4 = WhenMappings.$EnumSwitchMapping$0[wasmSType.ordinal()];
                        switch (n4) {
                            case 1: {
                                throw new NotImplementedError(null, 1, null);
                            }
                            case 2: {
                                params[n3] = this.popI32();
                                continue block285;
                            }
                            case 3: {
                                params[n3] = this.popI64();
                                continue block285;
                            }
                            case 4: {
                                params[n3] = Float.valueOf(this.popF32());
                                continue block285;
                            }
                            case 5: {
                                params[n3] = this.popF64();
                                continue block285;
                            }
                            case 6: {
                                throw new NotImplementedError(null, 1, null);
                            }
                            case 7: {
                                throw new NotImplementedError(null, 1, null);
                            }
                            case 8: {
                                throw new NotImplementedError(null, 1, null);
                            }
                        }
                    }
                    Object res = item2.invoke(this, params);
                    String string = "!!INDIRECT";
                    System.out.println((Object)string);
                    this.pushType(WasmCommonKt.toWasmSType(funcType2.getRetType()), res);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 18: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 19: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 20: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 21: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 24: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 25: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 40: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_load(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 41: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_load(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 42: {
                    this.pushF32(WasmRuntime.Companion.Op_f32_load(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 43: {
                    this.pushF64(WasmRuntime.Companion.Op_f64_load(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 44: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_load8_s(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 45: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_load8_u(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 46: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_load16_s(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 47: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_load16_u(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 48: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_load8_s(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 49: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_load8_u(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 50: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_load16_s(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 51: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_load16_u(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 52: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_load32_s(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 53: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_load32_u(this.popI32(), param, this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 54: {
                    int value = this.popI32();
                    int base2 = this.popI32();
                    WasmRuntime.Companion.Op_i32_store(base2, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 55: {
                    long value = this.popI64();
                    int base3 = this.popI32();
                    WasmRuntime.Companion.Op_i64_store(base3, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 56: {
                    float value = this.popF32();
                    int base4 = this.popI32();
                    WasmRuntime.Companion.Op_f32_store(base4, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 57: {
                    double value = this.popF64();
                    int base5 = this.popI32();
                    WasmRuntime.Companion.Op_f64_store(base5, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 58: {
                    int value = this.popI32();
                    int base6 = this.popI32();
                    WasmRuntime.Companion.Op_i32_store8(base6, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 59: {
                    int value = this.popI32();
                    int base7 = this.popI32();
                    WasmRuntime.Companion.Op_i32_store16(base7, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 60: {
                    long value = this.popI64();
                    int base8 = this.popI32();
                    WasmRuntime.Companion.Op_i64_store8(base8, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 61: {
                    long value = this.popI64();
                    int base9 = this.popI32();
                    WasmRuntime.Companion.Op_i64_store16(base9, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 62: {
                    long value = this.popI64();
                    int base10 = this.popI32();
                    WasmRuntime.Companion.Op_i64_store32(base10, value, param, this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 63: {
                    this.pushI32(WasmRuntime.Companion.Op_memory_size(this));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 64: {
                    WasmRuntime.Companion.Op_memory_grow(this.popI32(), this);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 65: {
                    this.pushI32(code.getIntPool()[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 66: {
                    this.pushI64(code.getLongPool()[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 67: {
                    this.pushF32(code.getFloatPool()[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 68: {
                    this.pushF64(code.getDoublePool()[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 69: {
                    void it;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI32 = false;
                    int base10 = this_$iv.popI32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl2 = false;
                    int n5 = WasmRuntime.Companion.Op_i32_eqz((int)it);
                    wasmRunInterpreter.pushI32(n5);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 70: {
                    void r;
                    void l;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int item2 = r$iv;
                    int params = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl3 = false;
                    int n6 = WasmRuntime.Companion.Op_i32_eq((int)l, (int)r);
                    wasmRunInterpreter.pushI32(n6);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 71: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl4 = false;
                    int n7 = WasmRuntime.Companion.Op_i32_ne(l, r);
                    wasmRunInterpreter.pushI32(n7);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 72: {
                    int n8;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl5 = false;
                    int it = n8 = WasmRuntime.Companion.Op_i32_lt_s(l, r);
                    boolean bl6 = false;
                    if (this.getTrace()) {
                        System.out.println((Object)("l:" + l + " < r:" + r + " == " + it));
                    }
                    int n9 = n8;
                    wasmRunInterpreter.pushI32(n9);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 73: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl7 = false;
                    int n10 = WasmRuntime.Companion.Op_i32_lt_u(l, r);
                    wasmRunInterpreter.pushI32(n10);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 74: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl8 = false;
                    int n11 = WasmRuntime.Companion.Op_i32_gt_s(l, r);
                    wasmRunInterpreter.pushI32(n11);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 75: {
                    int n12;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl9 = false;
                    int it = n12 = WasmRuntime.Companion.Op_i32_gt_u(l, r);
                    boolean bl10 = false;
                    if (this.getTrace()) {
                        System.out.println((Object)("l:" + l + " >u r:" + r + " == " + it));
                    }
                    int n13 = n12;
                    wasmRunInterpreter.pushI32(n13);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 76: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl11 = false;
                    int n14 = WasmRuntime.Companion.Op_i32_le_s(l, r);
                    wasmRunInterpreter.pushI32(n14);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 77: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl12 = false;
                    int n15 = WasmRuntime.Companion.Op_i32_le_u(l, r);
                    wasmRunInterpreter.pushI32(n15);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 78: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl13 = false;
                    int n16 = WasmRuntime.Companion.Op_i32_ge_s(l, r);
                    wasmRunInterpreter.pushI32(n16);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 79: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl14 = false;
                    int n17 = WasmRuntime.Companion.Op_i32_ge_u(l, r);
                    wasmRunInterpreter.pushI32(n17);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 80: {
                    this.pushI32(WasmRuntime.Companion.Op_i64_eqz(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 81: {
                    void r;
                    void l;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long bl14 = r$iv;
                    long it = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl15 = false;
                    int n18 = WasmRuntime.Companion.Op_i64_eq((long)l, (long)r);
                    wasmRunInterpreter.pushI32(n18);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 82: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl16 = false;
                    int n19 = WasmRuntime.Companion.Op_i64_ne(l, r);
                    wasmRunInterpreter.pushI32(n19);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 83: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl17 = false;
                    int n20 = WasmRuntime.Companion.Op_i64_lt_s(l, r);
                    wasmRunInterpreter.pushI32(n20);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 84: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl18 = false;
                    int n21 = WasmRuntime.Companion.Op_i64_lt_u(l, r);
                    wasmRunInterpreter.pushI32(n21);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 85: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl19 = false;
                    int n22 = WasmRuntime.Companion.Op_i64_gt_s(l, r);
                    wasmRunInterpreter.pushI32(n22);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 86: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl20 = false;
                    int n23 = WasmRuntime.Companion.Op_i64_gt_u(l, r);
                    wasmRunInterpreter.pushI32(n23);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 87: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl21 = false;
                    int n24 = WasmRuntime.Companion.Op_i64_le_s(l, r);
                    wasmRunInterpreter.pushI32(n24);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 88: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl22 = false;
                    int n25 = WasmRuntime.Companion.Op_i64_le_u(l, r);
                    wasmRunInterpreter.pushI32(n25);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 89: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl23 = false;
                    int n26 = WasmRuntime.Companion.Op_i64_ge_s(l, r);
                    wasmRunInterpreter.pushI32(n26);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 90: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_int = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv2 = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv2;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl24 = false;
                    int n27 = WasmRuntime.Companion.Op_i64_ge_u(l, r);
                    wasmRunInterpreter.pushI32(n27);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 91: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_int = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float l$iv2 = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl25 = false;
                    int n28 = WasmRuntime.Companion.Op_f32_eq(l, (float)r);
                    wasmRunInterpreter.pushI32(n28);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 92: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_int = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl26 = false;
                    int n29 = WasmRuntime.Companion.Op_f32_ne(l, r);
                    wasmRunInterpreter.pushI32(n29);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 93: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_int = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl27 = false;
                    int n30 = WasmRuntime.Companion.Op_f32_lt(l, r);
                    wasmRunInterpreter.pushI32(n30);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 94: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_int = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl28 = false;
                    int n31 = WasmRuntime.Companion.Op_f32_gt(l, r);
                    wasmRunInterpreter.pushI32(n31);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 95: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_int = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl29 = false;
                    int n32 = WasmRuntime.Companion.Op_f32_le(l, r);
                    wasmRunInterpreter.pushI32(n32);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 96: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_int = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl30 = false;
                    int n33 = WasmRuntime.Companion.Op_f32_ge(l, r);
                    wasmRunInterpreter.pushI32(n33);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 97: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_int = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double bl30 = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl31 = false;
                    int n34 = WasmRuntime.Companion.Op_f64_eq(l, (double)r);
                    wasmRunInterpreter.pushI32(n34);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 98: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_int = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl32 = false;
                    int n35 = WasmRuntime.Companion.Op_f64_ne(l, r);
                    wasmRunInterpreter.pushI32(n35);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 99: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_int = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl33 = false;
                    int n36 = WasmRuntime.Companion.Op_f64_lt(l, r);
                    wasmRunInterpreter.pushI32(n36);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 100: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_int = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl34 = false;
                    int n37 = WasmRuntime.Companion.Op_f64_gt(l, r);
                    wasmRunInterpreter.pushI32(n37);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 101: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_int = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl35 = false;
                    int n38 = WasmRuntime.Companion.Op_f64_le(l, r);
                    wasmRunInterpreter.pushI32(n38);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 102: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_int = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv3 = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv3;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl36 = false;
                    int n39 = WasmRuntime.Companion.Op_f64_ge(l, r);
                    wasmRunInterpreter.pushI32(n39);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 103: {
                    void it;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI32 = false;
                    int r$iv = this_$iv.popI32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl37 = false;
                    int n40 = WasmRuntime.Companion.Op_i32_clz((int)it);
                    wasmRunInterpreter.pushI32(n40);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 104: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI32 = false;
                    int it = this_$iv.popI32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl38 = false;
                    int n41 = WasmRuntime.Companion.Op_i32_ctz(it);
                    wasmRunInterpreter.pushI32(n41);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 105: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI32 = false;
                    int it = this_$iv.popI32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl39 = false;
                    int n42 = WasmRuntime.Companion.Op_i32_popcnt(it);
                    wasmRunInterpreter.pushI32(n42);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 106: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int l$iv3 = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl40 = false;
                    int n43 = l + r;
                    wasmRunInterpreter.pushI32(n43);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 107: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl41 = false;
                    int n44 = l - r;
                    wasmRunInterpreter.pushI32(n44);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 108: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl42 = false;
                    int n45 = l * r;
                    wasmRunInterpreter.pushI32(n45);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 109: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl43 = false;
                    int n46 = l / r;
                    wasmRunInterpreter.pushI32(n46);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 110: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl44 = false;
                    int n47 = WasmRuntime.Companion.Op_i32_div_u(l, r);
                    wasmRunInterpreter.pushI32(n47);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 111: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl45 = false;
                    int n48 = l % r;
                    wasmRunInterpreter.pushI32(n48);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 112: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl46 = false;
                    int n49 = WasmRuntime.Companion.Op_i32_rem_u(l, r);
                    wasmRunInterpreter.pushI32(n49);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 113: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl47 = false;
                    int n50 = l & r;
                    wasmRunInterpreter.pushI32(n50);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 114: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl48 = false;
                    int n51 = l | r;
                    wasmRunInterpreter.pushI32(n51);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 115: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl49 = false;
                    int n52 = l ^ r;
                    wasmRunInterpreter.pushI32(n52);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 116: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl50 = false;
                    int n53 = l << r;
                    wasmRunInterpreter.pushI32(n53);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 117: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl51 = false;
                    int n54 = l >> r;
                    wasmRunInterpreter.pushI32(n54);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 118: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl52 = false;
                    int n55 = l >>> r;
                    wasmRunInterpreter.pushI32(n55);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 119: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl53 = false;
                    int n56 = WasmRuntime.Companion.Op_i32_rotl(l, r);
                    wasmRunInterpreter.pushI32(n56);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 120: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl54 = false;
                    int n57 = WasmRuntime.Companion.Op_i32_rotr(l, r);
                    wasmRunInterpreter.pushI32(n57);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 121: {
                    void it;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI64 = false;
                    long r$iv = this_$iv.popI64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl55 = false;
                    long l = WasmRuntime.Companion.Op_i64_clz((long)it);
                    wasmRunInterpreter.pushI64(l);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 122: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI64 = false;
                    long it = this_$iv.popI64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl56 = false;
                    long l = WasmRuntime.Companion.Op_i64_ctz(it);
                    wasmRunInterpreter.pushI64(l);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 123: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI64 = false;
                    long it = this_$iv.popI64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl57 = false;
                    long l = WasmRuntime.Companion.Op_i64_popcnt(it);
                    wasmRunInterpreter.pushI64(l);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 124: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long bl54 = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl58 = false;
                    long l2 = l + r;
                    wasmRunInterpreter.pushI64(l2);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 125: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl59 = false;
                    long l3 = l - r;
                    wasmRunInterpreter.pushI64(l3);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 126: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl60 = false;
                    long l4 = l * r;
                    wasmRunInterpreter.pushI64(l4);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 127: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl61 = false;
                    long l5 = l / r;
                    wasmRunInterpreter.pushI64(l5);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 128: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl62 = false;
                    long l6 = WasmRuntime.Companion.Op_i64_div_u(l, r);
                    wasmRunInterpreter.pushI64(l6);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 129: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl63 = false;
                    long l7 = l % r;
                    wasmRunInterpreter.pushI64(l7);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 130: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl64 = false;
                    long l8 = WasmRuntime.Companion.Op_i64_rem_u(l, r);
                    wasmRunInterpreter.pushI64(l8);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 131: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl65 = false;
                    long l9 = l & r;
                    wasmRunInterpreter.pushI64(l9);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 132: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl66 = false;
                    long l10 = l | r;
                    wasmRunInterpreter.pushI64(l10);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 133: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl67 = false;
                    long l11 = l ^ r;
                    wasmRunInterpreter.pushI64(l11);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 134: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl68 = false;
                    long l12 = l << (int)r;
                    wasmRunInterpreter.pushI64(l12);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 135: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl69 = false;
                    long l13 = l >> (int)r;
                    wasmRunInterpreter.pushI64(l13);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 136: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl70 = false;
                    long l14 = l >>> (int)r;
                    wasmRunInterpreter.pushI64(l14);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 137: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl71 = false;
                    long l15 = WasmRuntime.Companion.Op_i64_rotl(l, r);
                    wasmRunInterpreter.pushI64(l15);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 138: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv4 = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv4;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl72 = false;
                    long l16 = WasmRuntime.Companion.Op_i64_rotr(l, r);
                    wasmRunInterpreter.pushI64(l16);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 139: {
                    void it;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF32 = false;
                    float r$iv = this_$iv.popF32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl73 = false;
                    float f = WasmRuntime.Companion.Op_f32_abs((float)it);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 140: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF32 = false;
                    float it = this_$iv.popF32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl74 = false;
                    float f = WasmRuntime.Companion.Op_f32_neg(it);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 141: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF32 = false;
                    float it = this_$iv.popF32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl75 = false;
                    float f = WasmRuntime.Companion.Op_f32_ceil(it);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 142: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF32 = false;
                    float it = this_$iv.popF32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl76 = false;
                    float f = WasmRuntime.Companion.Op_f32_floor(it);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 143: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF32 = false;
                    float it = this_$iv.popF32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl77 = false;
                    float f = WasmRuntime.Companion.Op_f32_trunc(it);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 144: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF32 = false;
                    float it = this_$iv.popF32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl78 = false;
                    float f = WasmRuntime.Companion.Op_f32_nearest(it);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 145: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF32 = false;
                    float it = this_$iv.popF32();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl79 = false;
                    float f = WasmRuntime.Companion.Op_f32_sqrt(it);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 146: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float l$iv4 = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl80 = false;
                    float f = l + r;
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 147: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl81 = false;
                    float f = l - r;
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 148: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl82 = false;
                    float f = l * r;
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 149: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl83 = false;
                    float f = l / r;
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 150: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl84 = false;
                    float f = WasmRuntime.Companion.Op_f32_min(l, r);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 151: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl85 = false;
                    float f = WasmRuntime.Companion.Op_f32_max(l, r);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 152: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl86 = false;
                    float f = WasmRuntime.Companion.Op_f32_copysign(l, r);
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 153: {
                    void it;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF64 = false;
                    double r$iv = this_$iv.popF64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl87 = false;
                    double d = WasmRuntime.Companion.Op_f64_abs((double)it);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 154: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF64 = false;
                    double it = this_$iv.popF64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl88 = false;
                    double d = WasmRuntime.Companion.Op_f64_neg(it);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 155: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF64 = false;
                    double it = this_$iv.popF64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl89 = false;
                    double d = WasmRuntime.Companion.Op_f64_ceil(it);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 156: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF64 = false;
                    double it = this_$iv.popF64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl90 = false;
                    double d = WasmRuntime.Companion.Op_f64_floor(it);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 157: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF64 = false;
                    double it = this_$iv.popF64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl91 = false;
                    double d = WasmRuntime.Companion.Op_f64_trunc(it);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 158: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF64 = false;
                    double it = this_$iv.popF64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl92 = false;
                    double d = WasmRuntime.Companion.Op_f64_nearest(it);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 159: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopF64 = false;
                    double it = this_$iv.popF64();
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl93 = false;
                    double d = WasmRuntime.Companion.Op_f64_sqrt(it);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 160: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double bl86 = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl94 = false;
                    double d = l + r;
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 161: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl95 = false;
                    double d = l - r;
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 162: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl96 = false;
                    double d = l * r;
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 163: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl97 = false;
                    double d = l / r;
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 164: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl98 = false;
                    double d = WasmRuntime.Companion.Op_f64_min(l, r);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 165: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl99 = false;
                    double d = WasmRuntime.Companion.Op_f64_max(l, r);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 166: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl100 = false;
                    double d = WasmRuntime.Companion.Op_f64_copysign(l, r);
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 167: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_wrap_i64(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 168: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_s_f32(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 169: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_u_f32(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 170: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_s_f64(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 171: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_u_f64(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 172: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_extend_i32_s(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 173: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_extend_i32_u(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 174: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_s_f32(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 175: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_u_f32(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 176: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_s_f64(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 177: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_u_f64(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 178: {
                    this.pushF32(WasmRuntime.Companion.Op_f32_convert_s_i32(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 179: {
                    this.pushF32(WasmRuntime.Companion.Op_f32_convert_u_i32(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 180: {
                    this.pushF32(WasmRuntime.Companion.Op_f32_convert_s_i64(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 181: {
                    this.pushF32(WasmRuntime.Companion.Op_f32_convert_u_i64(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 182: {
                    this.pushF32(WasmRuntime.Companion.Op_f32_demote_f64(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 183: {
                    this.pushF64(WasmRuntime.Companion.Op_f64_convert_s_i32(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 184: {
                    this.pushF64(WasmRuntime.Companion.Op_f64_convert_u_i32(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 185: {
                    this.pushF64(WasmRuntime.Companion.Op_f64_convert_s_i64(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 186: {
                    this.pushF64(WasmRuntime.Companion.Op_f64_convert_u_i64(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 187: {
                    this.pushF64(WasmRuntime.Companion.Op_f64_promote_f32(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 188: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_reinterpret_f32(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 189: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_reinterpret_f64(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 190: {
                    this.pushF32(WasmRuntime.Companion.Op_f32_reinterpret_i32(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 191: {
                    this.pushF64(WasmRuntime.Companion.Op_f64_reinterpret_i64(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 192: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_extend8_s(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 193: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_extend16_s(this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 194: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_extend8_s(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 195: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_extend16_s(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 196: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_extend32_s(this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 208: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 209: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 256: {
                    int this_$iv = this.stackPos;
                    this.stackPos = this_$iv + -1;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 257: {
                    int this_$iv = this.stackPos;
                    this.stackPos = this_$iv + -1;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 258: {
                    int this_$iv = this.stackPos;
                    this.stackPos = this_$iv + -1;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 259: {
                    int this_$iv = this.stackPos;
                    this.stackPos = this_$iv + -1;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 260: {
                    int this_$iv = this.stackPos;
                    this.stackPos = this_$iv + -1;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 272: {
                    this.pushI32(this.getLocalI32(param));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 273: {
                    this.pushI64(this.getLocalI64(param));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 274: {
                    this.pushF32(this.getLocalF32(param));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 275: {
                    this.pushF64(this.getLocalF64(param));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 276: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 288: {
                    this.setLocalI32(param, this.popI32());
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 289: {
                    this.setLocalI64(param, this.popI64());
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 290: {
                    this.setLocalF32(param, this.popF32());
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 291: {
                    this.setLocalF64(param, this.popF64());
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 292: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 304: {
                    this.pushI32(this.setLocalI32(param, this.popI32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 305: {
                    this.pushI64(this.setLocalI64(param, this.popI64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 306: {
                    this.pushF32(this.setLocalF32(param, this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 307: {
                    this.pushF64(this.setLocalF64(param, this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 308: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 320: {
                    this.pushI32(this.globalsI[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 321: {
                    this.pushI64(this.globalsL[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 322: {
                    this.pushF32(this.globalsF[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 323: {
                    this.pushF64(this.globalsD[param]);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 324: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 336: {
                    this.globalsI[param] = this.popI32();
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 337: {
                    this.globalsL[param] = this.popI64();
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 338: {
                    this.globalsF[param] = this.popF32();
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 339: {
                    this.globalsD[param] = this.popF64();
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 340: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 352: {
                    int v = this.popI32();
                    this.stackPos = this.localsPos;
                    this.pushI32(v);
                    break block284;
                }
                case 353: {
                    long v = this.popI64();
                    this.stackPos = this.localsPos;
                    this.pushI64(v);
                    break block284;
                }
                case 354: {
                    float v = this.popF32();
                    this.stackPos = this.localsPos;
                    this.pushF32(v);
                    break block284;
                }
                case 355: {
                    double v = this.popF64();
                    this.stackPos = this.localsPos;
                    this.pushF64(v);
                    break block284;
                }
                case 356: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 357: {
                    this.stackPos = this.localsPos;
                    break block284;
                }
                case 400: {
                    void r;
                    void l;
                    int v = this.popI32();
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32 = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int l17 = r$iv;
                    int r2 = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl101 = false;
                    void var23_989 = v != 0 ? l : r;
                    wasmRunInterpreter.pushI32((int)var23_989);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 401: {
                    void r;
                    void l;
                    int v = this.popI32();
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64 = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv5 = this_$iv.popI64();
                    long bl101 = r$iv;
                    long bl10 = l$iv5;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl102 = false;
                    void var23_990 = v != 0 ? l : r;
                    wasmRunInterpreter.pushI64((long)var23_990);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 402: {
                    void r;
                    int v = this.popI32();
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32 = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float l$iv5 = r$iv;
                    float l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl103 = false;
                    float f = v != 0 ? l : r;
                    wasmRunInterpreter.pushF32(f);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 403: {
                    void r;
                    int v = this.popI32();
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64 = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double bl103 = r$iv;
                    double l = l$iv;
                    WasmRunInterpreter wasmRunInterpreter = this_$iv;
                    boolean bl104 = false;
                    double d = v != 0 ? l : r;
                    wasmRunInterpreter.pushF64(d);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 404: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 368: {
                    this.pushI32(param);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 369: {
                    this.pushI64(param);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 370: {
                    this.pushF32(param);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 371: {
                    this.pushF64(param);
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 384: {
                    index3 = param;
                    continue block284;
                }
                case 385: {
                    int res = this.popI32();
                    if (res != 0) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 386: {
                    int res = this.popI32();
                    if (res == 0) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 416: {
                    int it$iv;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI32_bool = false;
                    int it = it$iv = this_$iv.popI32();
                    boolean bl105 = false;
                    if (!(it == 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 417: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int bl105 = r$iv;
                    int l = l$iv;
                    boolean bl106 = false;
                    if (!(l == r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 418: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl107 = false;
                    if (!(l != r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 419: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl108 = false;
                    if (!(l < r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 420: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl109 = false;
                    if (!(Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) < 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 421: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl110 = false;
                    if (!(l > r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 422: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl111 = false;
                    if (!(Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) > 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 423: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl112 = false;
                    if (!(l <= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 424: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl113 = false;
                    if (!(Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) <= 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 425: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl114 = false;
                    if (!(l >= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 426: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI32_bool = false;
                    int r$iv = this_$iv.popI32();
                    int l$iv = this_$iv.popI32();
                    int r = r$iv;
                    int l = l$iv;
                    boolean bl115 = false;
                    if (!(Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) >= 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 427: {
                    long it$iv;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$unopI64_bool = false;
                    long it = it$iv = this_$iv.popI64();
                    boolean bl116 = false;
                    if (!(it == 0L)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 428: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long bl116 = r$iv;
                    long l = l$iv;
                    boolean bl117 = false;
                    if (!(l == r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 429: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl118 = false;
                    if (!(l != r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 430: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl119 = false;
                    if (!(l < r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 431: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl120 = false;
                    if (!(Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) < 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 432: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl121 = false;
                    if (!(l > r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 433: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl122 = false;
                    if (!(Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) > 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 434: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl123 = false;
                    if (!(l <= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 435: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl124 = false;
                    if (!(Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) <= 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 436: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv;
                    boolean bl125 = false;
                    if (!(l >= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 437: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopI64_bool = false;
                    long r$iv = this_$iv.popI64();
                    long l$iv6 = this_$iv.popI64();
                    long r = r$iv;
                    long l = l$iv6;
                    boolean bl126 = false;
                    if (!(Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) >= 0)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 438: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_bool = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float l$iv6 = r$iv;
                    float l = l$iv;
                    boolean bl127 = false;
                    if (!(l == r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 439: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_bool = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    boolean bl128 = false;
                    if (!(!(l == r))) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 440: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_bool = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    boolean bl129 = false;
                    if (!(l < r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 441: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_bool = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    boolean bl130 = false;
                    if (!(l > r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 442: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_bool = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    boolean bl131 = false;
                    if (!(l <= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 443: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF32_bool = false;
                    float r$iv = this_$iv.popF32();
                    float l$iv = this_$iv.popF32();
                    float r = r$iv;
                    float l = l$iv;
                    boolean bl132 = false;
                    if (!(l >= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 444: {
                    void r;
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_bool = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double bl132 = r$iv;
                    double l = l$iv;
                    boolean bl133 = false;
                    if (!(l == r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 445: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_bool = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    boolean bl134 = false;
                    if (!(!(l == r))) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 446: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_bool = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    boolean bl135 = false;
                    if (!(l < r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 447: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_bool = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    boolean bl136 = false;
                    if (!(l > r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 448: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_bool = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    boolean bl137 = false;
                    if (!(l <= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 449: {
                    WasmRunInterpreter this_$iv = this;
                    boolean $i$f$binopF64_bool = false;
                    double r$iv = this_$iv.popF64();
                    double l$iv = this_$iv.popF64();
                    double r = r$iv;
                    double l = l$iv;
                    boolean bl138 = false;
                    if (!(l >= r)) {
                        index3 = param;
                        continue block284;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 387: {
                    int value = this.popI32();
                    int nlabels = code.getIntPool()[param];
                    boolean bl139 = 0 <= value ? value < nlabels : false;
                    if (bl139) {
                        index3 = code.getIntPool()[param + 2 + value];
                        continue block284;
                    }
                    index3 = code.getIntPool()[param + 1];
                    continue block284;
                }
                case 512: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_sat_f32_s(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 513: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_sat_f32_u(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 514: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_sat_f64_s(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 515: {
                    this.pushI32(WasmRuntime.Companion.Op_i32_trunc_sat_f64_u(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 516: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_sat_f32_s(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 517: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_sat_f32_u(this.popF32()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 518: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_sat_f64_s(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 519: {
                    this.pushI64(WasmRuntime.Companion.Op_i64_trunc_sat_f64_u(this.popF64()));
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 520: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 521: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 522: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 523: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 524: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 525: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 526: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 527: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 528: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 529: {
                    throw new NotImplementedError(null, 1, null);
                }
                default: {
                    String string = "op=" + op + ", param=" + param + ", i=" + i2;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
            }
            ++index3;
        }
        this.setInstructionsExecuted(this.getInstructionsExecuted() + (long)instructionsExecuted);
    }

    public final void pushType(@NotNull WasmSType type2, @Nullable Object value) {
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Integer n = value instanceof Integer ? (Integer)value : null;
                this.pushI32(n != null ? n : 0);
                break;
            }
            case 3: {
                Long l = value instanceof Long ? (Long)value : null;
                this.pushI64(l != null ? l : 0L);
                break;
            }
            case 4: {
                Float f = value instanceof Float ? (Float)value : null;
                this.pushF32(f != null ? f.floatValue() : 0.0f);
                break;
            }
            case 5: {
                Double d = value instanceof Double ? (Double)value : null;
                this.pushF64(d != null ? d : 0.0);
                break;
            }
            case 6: {
                throw new NotImplementedError(null, 1, null);
            }
            case 7: {
                throw new NotImplementedError(null, 1, null);
            }
            case 8: {
                throw new NotImplementedError(null, 1, null);
            }
        }
    }

    public final void pushI32(int value) {
        int n = this.stackPos;
        this.stackPos = n + 1;
        this.stackI[n] = value;
    }

    public final void pushF32(float value) {
        int n = this.stackPos;
        this.stackPos = n + 1;
        this.stackF[n] = value;
    }

    public final void pushI64(long value) {
        int n = this.stackPos;
        this.stackPos = n + 1;
        this.stackL[n] = value;
    }

    public final void pushF64(double value) {
        int n = this.stackPos;
        this.stackPos = n + 1;
        this.stackD[n] = value;
    }

    public final int popI32() {
        this.stackPos += -1;
        return this.stackI[this.stackPos];
    }

    public final float popF32() {
        this.stackPos += -1;
        return this.stackF[this.stackPos];
    }

    public final long popI64() {
        this.stackPos += -1;
        return this.stackL[this.stackPos];
    }

    public final double popF64() {
        this.stackPos += -1;
        return this.stackD[this.stackPos];
    }

    public final int getLocalI32(int offset2) {
        return this.stackI[this.localsPos + offset2];
    }

    public final long getLocalI64(int offset2) {
        return this.stackL[this.localsPos + offset2];
    }

    public final float getLocalF32(int offset2) {
        return this.stackF[this.localsPos + offset2];
    }

    public final double getLocalF64(int offset2) {
        return this.stackD[this.localsPos + offset2];
    }

    public final int setLocalI32(int offset2, int value) {
        int n;
        int it = n = value;
        boolean bl = false;
        this.stackI[this.localsPos + offset2] = value;
        return n;
    }

    public final long setLocalI64(int offset2, long value) {
        long l;
        long it = l = value;
        boolean bl = false;
        this.stackL[this.localsPos + offset2] = value;
        return l;
    }

    public final float setLocalF32(int offset2, float value) {
        float f;
        float it = f = value;
        boolean bl = false;
        this.stackF[this.localsPos + offset2] = value;
        return f;
    }

    public final double setLocalF64(int offset2, double value) {
        double d;
        double it = d = value;
        boolean bl = false;
        this.stackD[this.localsPos + offset2] = value;
        return d;
    }

    public final void setLocal(@NotNull WasmSType type2, int offset2, @Nullable Object value) {
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                throw new NotImplementedError(null, 1, null);
            }
            case 2: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Int");
                this.setLocalI32(offset2, (Integer)value);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Long");
                this.setLocalI64(offset2, (Long)value);
                break;
            }
            case 4: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Float");
                this.setLocalF32(offset2, ((Float)value).floatValue());
                break;
            }
            case 5: {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Double");
                this.setLocalF64(offset2, (Double)value);
                break;
            }
            case 6: {
                throw new NotImplementedError(null, 1, null);
            }
            case 7: {
                throw new NotImplementedError(null, 1, null);
            }
            case 8: {
                throw new NotImplementedError(null, 1, null);
            }
        }
    }

    public final void setGlobal(@NotNull WasmGlobal global, @Nullable Object value) {
        switch (WhenMappings.$EnumSwitchMapping$0[WasmCommonKt.toWasmSType(global.getGlobalType()).ordinal()]) {
            case 1: {
                throw new NotImplementedError(null, 1, null);
            }
            case 2: {
                int n = global.getIndex();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Int");
                this.globalsI[n] = (Integer)value;
                break;
            }
            case 3: {
                int n = global.getIndex();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Long");
                this.globalsL[n] = (Long)value;
                break;
            }
            case 4: {
                int n = global.getIndex();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Float");
                this.globalsF[n] = ((Float)value).floatValue();
                break;
            }
            case 5: {
                int n = global.getIndex();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Double");
                this.globalsD[n] = (Double)value;
                break;
            }
            case 6: {
                throw new NotImplementedError(null, 1, null);
            }
            case 7: {
                throw new NotImplementedError(null, 1, null);
            }
            case 8: {
                throw new NotImplementedError(null, 1, null);
            }
        }
    }

    @Nullable
    public final Object popType(@NotNull WasmSType type2) {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                object = Unit.INSTANCE;
                break;
            }
            case 2: {
                object = this.popI32();
                break;
            }
            case 3: {
                object = this.popI64();
                break;
            }
            case 4: {
                object = Float.valueOf(this.popF32());
                break;
            }
            case 5: {
                object = this.popF64();
                break;
            }
            case 6: {
                throw new NotImplementedError(null, 1, null);
            }
            case 7: {
                throw new NotImplementedError(null, 1, null);
            }
            case 8: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull String funcName, Object ... params) {
        WasmFunc wasmFunc = this.module.getFunctionsByName().get(funcName);
        if (wasmFunc == null) {
            throw new IllegalStateException(("Can't find '" + funcName + "' in " + this.module.getFunctionsByName().keySet()).toString());
        }
        WasmFunc func2 = wasmFunc;
        WasmInterpreterCode wasmInterpreterCode = this.getInterprerCode(func2);
        if (wasmInterpreterCode == null) {
            throw new IllegalStateException(("Function '" + funcName + "' doesn't have body").toString());
        }
        WasmInterpreterCode code = wasmInterpreterCode;
        Iterator<WastLocal> iterator2 = func2.getType().getArgs().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            WastLocal arg = iterator2.next();
            int offset2 = index2;
            this.setLocal(arg.getStype(), offset2, params[index2]);
        }
        this.stackPos += code.getLocalsCount();
        this.invoke(func2);
        return this.popType(WasmCommonKt.toWasmSType(func2.getType().getRetType()));
    }

    @Override
    @Nullable
    public Object invokeIndirect(int index2, Object ... params) {
        return super.invokeIndirect(index2, Arrays.copyOf(params, params.length));
    }

    @NotNull
    public final WasmInterpreterCode compile(@NotNull WasmFunc func2, boolean implicitReturn, @NotNull WasmDebugContext debug) {
        ArrayList<Long> poolLongs = new ArrayList<Long>();
        IntArrayList poolInts = ArrayListKt.intArrayListOf(new int[0]);
        FloatArrayList poolFloats = ArrayListKt.floatArrayListOf(new float[0]);
        DoubleArrayList poolDoubles = ArrayListKt.doubleArrayListOf(new double[0]);
        IntArrayList instructions = ArrayListKt.intArrayListOf(new int[0]);
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"korlibs/wasm/WasmRunInterpreter$compile$Patch", "", "label", "Lkorlibs/wasm/WasmCodeVisitor$Label;", "intIndex", "", "instrutionIndex", "(Lkorlibs/wasm/WasmCodeVisitor$Label;II)V", "getInstrutionIndex", "()I", "getIntIndex", "getLabel", "()Lkorlibs/wasm/WasmCodeVisitor$Label;", "korge-core"})
        public final class Patch {
            @NotNull
            private final WasmCodeVisitor.Label label;
            private final int intIndex;
            private final int instrutionIndex;

            public Patch(@NotNull WasmCodeVisitor.Label label, int intIndex, int instrutionIndex) {
                this.label = label;
                this.intIndex = intIndex;
                this.instrutionIndex = instrutionIndex;
            }

            public /* synthetic */ Patch(WasmCodeVisitor.Label label, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 2) != 0) {
                    n = -1;
                }
                if ((n3 & 4) != 0) {
                    n2 = -1;
                }
                this(label, n, n2);
            }

            @NotNull
            public final WasmCodeVisitor.Label getLabel() {
                return this.label;
            }

            public final int getIntIndex() {
                return this.intIndex;
            }

            public final int getInstrutionIndex() {
                return this.instrutionIndex;
            }
        }
        ArrayList<Patch> patches = new ArrayList<Patch>();
        Ref.IntRef localsOffset = new Ref.IntRef();
        localsOffset.element = -1;
        Ref.ObjectRef<WasmCodeVisitor.Context> context2 = new Ref.ObjectRef<WasmCodeVisitor.Context>();
        context2.element = new WasmCodeVisitor.Context(func2, this.module);
        WasmCodeVisitorKt.accept(func2, this.module, implicitReturn, new WasmCodeVisitor(poolLongs, poolInts, poolFloats, poolDoubles, this, instructions, context2, localsOffset, patches){
            final /* synthetic */ ArrayList<Long> $poolLongs;
            final /* synthetic */ IntArrayList $poolInts;
            final /* synthetic */ FloatArrayList $poolFloats;
            final /* synthetic */ DoubleArrayList $poolDoubles;
            final /* synthetic */ WasmRunInterpreter this$0;
            final /* synthetic */ IntArrayList $instructions;
            final /* synthetic */ Ref.ObjectRef<WasmCodeVisitor.Context> $context;
            final /* synthetic */ Ref.IntRef $localsOffset;
            final /* synthetic */ ArrayList<Patch> $patches;
            {
                this.$poolLongs = $poolLongs;
                this.$poolInts = $poolInts;
                this.$poolFloats = $poolFloats;
                this.$poolDoubles = $poolDoubles;
                this.this$0 = $receiver;
                this.$instructions = $instructions;
                this.$context = $context;
                this.$localsOffset = $localsOffset;
                this.$patches = $patches;
            }

            /*
             * Unable to fully structure code
             */
            public void visit(@NotNull WasmInstruction i, @NotNull WasmCodeVisitor.Context context) {
                block112: {
                    block118: {
                        block117: {
                            block116: {
                                block115: {
                                    block114: {
                                        block113: {
                                            block111: {
                                                op = i.getOp();
                                                opHI = op.getId() >>> 8;
                                                opLO = op.getId() & 255;
                                                switch (opHI) {
                                                    case 0: {
                                                        v0 = op.getId();
                                                        break;
                                                    }
                                                    case 252: {
                                                        v0 = 512 + opLO;
                                                        break;
                                                    }
                                                    default: {
                                                        throw new NotImplementedError(null, 1, null);
                                                    }
                                                }
                                                newOp = v0;
                                                param = 0;
                                                var8_8 = i;
                                                if (!(var8_8 instanceof WasmInstruction.InsConstLong)) break block111;
                                                var9_9 = ((WasmInstruction.InsConstLong)i).getValue();
                                                v1 = -500000L <= var9_9 ? var9_9 < 500001L : false;
                                                if (v1) {
                                                    param = (int)((WasmInstruction.InsConstLong)i).getValue();
                                                    newOp = 369;
                                                } else {
                                                    param = this.$poolLongs.size();
                                                    ((Collection)this.$poolLongs).add(((WasmInstruction.InsConstLong)i).getValue());
                                                }
                                                break block112;
                                            }
                                            if (!(var8_8 instanceof WasmInstruction.InsConstInt)) break block113;
                                            var9_10 = ((WasmInstruction.InsConstInt)i).getValue();
                                            v2 = -500000 <= var9_10 ? var9_10 < 500001 : false;
                                            if (v2) {
                                                param = ((WasmInstruction.InsConstInt)i).getValue();
                                                newOp = 368;
                                            } else {
                                                param = this.$poolInts.size();
                                                this.$poolInts.plusAssign(((WasmInstruction.InsConstInt)i).getValue());
                                            }
                                            break block112;
                                        }
                                        if (!(var8_8 instanceof WasmInstruction.InsConstFloat)) break block114;
                                        ivalue = (int)((WasmInstruction.InsConstFloat)i).getValue();
                                        if (!((float)ivalue == ((WasmInstruction.InsConstFloat)i).getValue())) ** GOTO lbl-1000
                                        v3 = -500000 <= ivalue ? ivalue < 500001 : false;
                                        if (v3) {
                                            param = ivalue;
                                            newOp = 370;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            param = this.$poolFloats.size();
                                            this.$poolFloats.plusAssign(((WasmInstruction.InsConstFloat)i).getValue());
                                        }
                                        break block112;
                                    }
                                    if (!(var8_8 instanceof WasmInstruction.InsConstDouble)) break block115;
                                    ivalue = (int)((WasmInstruction.InsConstDouble)i).getValue();
                                    if (!((double)ivalue == ((WasmInstruction.InsConstDouble)i).getValue())) ** GOTO lbl-1000
                                    v4 = -500000 <= ivalue ? ivalue < 500001 : false;
                                    if (v4) {
                                        param = ivalue;
                                        newOp = 371;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        param = this.$poolDoubles.size();
                                        this.$poolDoubles.plusAssign(((WasmInstruction.InsConstDouble)i).getValue());
                                    }
                                    break block112;
                                }
                                if (!(var8_8 instanceof WasmInstruction.RETURN)) break block116;
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[WasmCommonKt.toWasmSType(context.getRetType()).ordinal()]) {
                                    case 1: {
                                        newOp = 357;
                                        break block112;
                                    }
                                    case 2: {
                                        newOp = 352;
                                        break block112;
                                    }
                                    case 3: {
                                        newOp = 353;
                                        break block112;
                                    }
                                    case 4: {
                                        newOp = 354;
                                        break block112;
                                    }
                                    case 5: {
                                        newOp = 355;
                                        break block112;
                                    }
                                    case 6: {
                                        newOp = 356;
                                        break block112;
                                    }
                                    case 7: {
                                        throw new NotImplementedError(null, 1, null);
                                    }
                                    case 8: {
                                        throw new NotImplementedError(null, 1, null);
                                    }
                                    default: {
                                        throw new NotImplementedError(null, 1, null);
                                    }
                                }
                            }
                            if (!(var8_8 instanceof WasmInstruction.InsMemarg)) break block117;
                            param = ((WasmInstruction.InsMemarg)i).getOffset();
                            break block112;
                        }
                        if (!(var8_8 instanceof WasmInstruction.InsInt)) break block118;
                        switch (compile.WhenMappings.$EnumSwitchMapping$1[i.getOp().ordinal()]) {
                            case 1: {
                                param = ((WasmInstruction.InsInt)i).getParam();
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[context.getLastInstructionOutputType().ordinal()]) {
                                    case 2: {
                                        newOp = 272;
                                        break;
                                    }
                                    case 3: {
                                        newOp = 273;
                                        break;
                                    }
                                    case 4: {
                                        newOp = 274;
                                        break;
                                    }
                                    case 5: {
                                        newOp = 275;
                                        break;
                                    }
                                    case 6: {
                                        newOp = 276;
                                        break;
                                    }
                                    case 7: {
                                        var12_14 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_14);
                                    }
                                    case 8: {
                                        var12_15 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_15);
                                    }
                                    case 1: {
                                        var12_16 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_16);
                                    }
                                }
                                break block112;
                            }
                            case 2: {
                                param = ((WasmInstruction.InsInt)i).getParam();
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[context.getLastInstructionOutputType().ordinal()]) {
                                    case 2: {
                                        newOp = 304;
                                        break;
                                    }
                                    case 3: {
                                        newOp = 305;
                                        break;
                                    }
                                    case 4: {
                                        newOp = 306;
                                        break;
                                    }
                                    case 5: {
                                        newOp = 307;
                                        break;
                                    }
                                    case 6: {
                                        newOp = 308;
                                        break;
                                    }
                                    case 7: {
                                        var12_17 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_17);
                                    }
                                    case 8: {
                                        var12_18 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_18);
                                    }
                                    case 1: {
                                        var12_19 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_19);
                                    }
                                }
                                break block112;
                            }
                            case 3: {
                                param = ((WasmInstruction.InsInt)i).getParam();
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[context.getLastInstructionOutputType().ordinal()]) {
                                    case 2: {
                                        newOp = 288;
                                        break;
                                    }
                                    case 3: {
                                        newOp = 289;
                                        break;
                                    }
                                    case 4: {
                                        newOp = 290;
                                        break;
                                    }
                                    case 5: {
                                        newOp = 291;
                                        break;
                                    }
                                    case 6: {
                                        newOp = 292;
                                        break;
                                    }
                                    case 7: {
                                        var12_20 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_20);
                                    }
                                    case 8: {
                                        var12_21 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_21);
                                    }
                                    case 1: {
                                        var12_22 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_22);
                                    }
                                }
                                break block112;
                            }
                            case 4: {
                                param = this.this$0.getModule().getGlobals().get(((WasmInstruction.InsInt)i).getParam()).getIndex();
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[context.getLastInstructionOutputType().ordinal()]) {
                                    case 2: {
                                        newOp = 320;
                                        break;
                                    }
                                    case 3: {
                                        newOp = 321;
                                        break;
                                    }
                                    case 4: {
                                        newOp = 322;
                                        break;
                                    }
                                    case 5: {
                                        newOp = 323;
                                        break;
                                    }
                                    case 6: {
                                        newOp = 324;
                                        break;
                                    }
                                    case 7: {
                                        var12_23 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_23);
                                    }
                                    case 8: {
                                        var12_24 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_24);
                                    }
                                    case 1: {
                                        var12_25 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_25);
                                    }
                                }
                                break block112;
                            }
                            case 5: {
                                param = this.this$0.getModule().getGlobals().get(((WasmInstruction.InsInt)i).getParam()).getIndex();
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[context.getLastInstructionType().ordinal()]) {
                                    case 2: {
                                        newOp = 336;
                                        break;
                                    }
                                    case 3: {
                                        newOp = 337;
                                        break;
                                    }
                                    case 4: {
                                        newOp = 338;
                                        break;
                                    }
                                    case 5: {
                                        newOp = 339;
                                        break;
                                    }
                                    case 6: {
                                        newOp = 340;
                                        break;
                                    }
                                    case 7: {
                                        var12_26 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_26);
                                    }
                                    case 8: {
                                        var12_27 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_27);
                                    }
                                    case 1: {
                                        var12_28 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_28);
                                    }
                                }
                                break block112;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: {
                                break block112;
                            }
                            default: {
                                var11_35 = String.valueOf(i);
                                throw new NotImplementedError("An operation is not implemented: " + var11_35);
                            }
                        }
                    }
                    if (var8_8 instanceof WasmInstruction.Ins) {
                        block72 : switch (compile.WhenMappings.$EnumSwitchMapping$1[i.getOp().ordinal()]) {
                            case 11: {
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[context.getLastInstructionType().ordinal()]) {
                                    case 2: {
                                        newOp = 256;
                                        break block72;
                                    }
                                    case 3: {
                                        newOp = 257;
                                        break block72;
                                    }
                                    case 4: {
                                        newOp = 258;
                                        break block72;
                                    }
                                    case 5: {
                                        newOp = 259;
                                        break block72;
                                    }
                                    case 6: {
                                        newOp = 260;
                                        break block72;
                                    }
                                    case 7: {
                                        var12_29 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_29);
                                    }
                                    case 8: {
                                        var12_30 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_30);
                                    }
                                    case 1: {
                                        var12_31 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_31);
                                    }
                                }
                                break;
                            }
                            case 12: {
                                switch (compile.WhenMappings.$EnumSwitchMapping$0[context.getLastInstructionOutputType().ordinal()]) {
                                    case 2: {
                                        newOp = 400;
                                        break block72;
                                    }
                                    case 3: {
                                        newOp = 401;
                                        break block72;
                                    }
                                    case 4: {
                                        newOp = 402;
                                        break block72;
                                    }
                                    case 5: {
                                        newOp = 403;
                                        break block72;
                                    }
                                    case 6: {
                                        newOp = 404;
                                        break block72;
                                    }
                                    case 7: {
                                        var12_32 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_32);
                                    }
                                    case 8: {
                                        var12_33 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_33);
                                    }
                                    case 1: {
                                        var12_34 = String.valueOf(i);
                                        throw new NotImplementedError("An operation is not implemented: " + var12_34);
                                    }
                                }
                                break;
                            }
                        }
                    } else if (var8_8 instanceof WasmInstruction.CALL) {
                        param = ((WasmInstruction.CALL)i).getFuncIdx();
                    } else if (var8_8 instanceof WasmInstruction.CALL_INDIRECT) {
                        param = ((WasmInstruction.CALL_INDIRECT)i).getTypeIdx();
                    } else if (!(var8_8 instanceof WasmInstruction.unreachable)) {
                        var9_13 = String.valueOf(i);
                        throw new NotImplementedError("An operation is not implemented: " + var9_13);
                    }
                }
                this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(newOp, param));
            }

            public void visitFuncStart(@NotNull WasmCodeVisitor.Context ctx) {
                this.$context.element = ctx;
                int n = ctx.getFunc().getRlocals().size();
                block10: for (int n2 = ctx.getFunc().getType().getArgs().size(); n2 < n; ++n2) {
                    WasmSType type2 = ctx.getFunc().getRlocals().get(n2).getStype();
                    switch (compile.WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                        case 1: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case 2: {
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(368, 0));
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(288, n2));
                            continue block10;
                        }
                        case 3: {
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(369, 0));
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(289, n2));
                            continue block10;
                        }
                        case 4: {
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(370, 0));
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(290, n2));
                            continue block10;
                        }
                        case 5: {
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(371, 0));
                            this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(291, n2));
                            continue block10;
                        }
                        case 6: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case 7: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case 8: {
                            throw new NotImplementedError(null, 1, null);
                        }
                    }
                }
            }

            public void visitFuncEnd(@NotNull WasmCodeVisitor.Context context2) {
                this.$localsOffset.element = context2.getLocalsOffset();
            }

            public void visitGotoTable(@NotNull List<WasmCodeVisitor.Label> labels, @NotNull WasmCodeVisitor.Label label, @NotNull WasmCodeVisitor.Context context2) {
                int tableIndex = this.$poolInts.size();
                this.$poolInts.add(labels.size());
                for (WasmCodeVisitor.Label label2 : CollectionsKt.plus((Collection)CollectionsKt.listOf(label), (Iterable)labels)) {
                    ((Collection)this.$patches).add(new Patch(label2, this.$poolInts.size(), 0, 4, null));
                    this.$poolInts.add(0);
                }
                this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(387, tableIndex));
            }

            public void visitGoto(@NotNull WasmCodeVisitor.Label label, @Nullable Boolean cond, @NotNull WasmCodeVisitor.Context context2) {
                int n;
                if (Intrinsics.areEqual(cond, false) && this.$instructions.isNotEmpty()) {
                    Integer replace;
                    int lastOp = this.$instructions.last() & 0xFFF;
                    switch (lastOp) {
                        case 69: {
                            Integer n2 = 416;
                            break;
                        }
                        case 70: {
                            Integer n2 = 417;
                            break;
                        }
                        case 71: {
                            Integer n2 = 418;
                            break;
                        }
                        case 72: {
                            Integer n2 = 419;
                            break;
                        }
                        case 73: {
                            Integer n2 = 420;
                            break;
                        }
                        case 74: {
                            Integer n2 = 421;
                            break;
                        }
                        case 75: {
                            Integer n2 = 422;
                            break;
                        }
                        case 76: {
                            Integer n2 = 423;
                            break;
                        }
                        case 77: {
                            Integer n2 = 424;
                            break;
                        }
                        case 78: {
                            Integer n2 = 425;
                            break;
                        }
                        case 79: {
                            Integer n2 = 426;
                            break;
                        }
                        case 80: {
                            Integer n2 = 427;
                            break;
                        }
                        case 81: {
                            Integer n2 = 428;
                            break;
                        }
                        case 82: {
                            Integer n2 = 429;
                            break;
                        }
                        case 83: {
                            Integer n2 = 430;
                            break;
                        }
                        case 84: {
                            Integer n2 = 431;
                            break;
                        }
                        case 85: {
                            Integer n2 = 432;
                            break;
                        }
                        case 86: {
                            Integer n2 = 433;
                            break;
                        }
                        case 87: {
                            Integer n2 = 434;
                            break;
                        }
                        case 88: {
                            Integer n2 = 435;
                            break;
                        }
                        case 89: {
                            Integer n2 = 436;
                            break;
                        }
                        case 90: {
                            Integer n2 = 437;
                            break;
                        }
                        case 91: {
                            Integer n2 = 438;
                            break;
                        }
                        case 92: {
                            Integer n2 = 439;
                            break;
                        }
                        case 93: {
                            Integer n2 = 440;
                            break;
                        }
                        case 94: {
                            Integer n2 = 441;
                            break;
                        }
                        case 95: {
                            Integer n2 = 442;
                            break;
                        }
                        case 96: {
                            Integer n2 = 443;
                            break;
                        }
                        case 97: {
                            Integer n2 = 444;
                            break;
                        }
                        case 98: {
                            Integer n2 = 445;
                            break;
                        }
                        case 99: {
                            Integer n2 = 446;
                            break;
                        }
                        case 100: {
                            Integer n2 = 447;
                            break;
                        }
                        case 101: {
                            Integer n2 = 448;
                            break;
                        }
                        case 102: {
                            Integer n2 = 449;
                            break;
                        }
                        default: {
                            Integer n2 = replace = null;
                        }
                    }
                    if (replace != null) {
                        ((Collection)this.$patches).add(new Patch(label, 0, this.$instructions.size() - 1, 2, null));
                        this.$instructions.set(this.$instructions.size() - 1, replace);
                        return;
                    }
                }
                ((Collection)this.$patches).add(new Patch(label, 0, this.$instructions.size(), 2, null));
                Boolean bl = cond;
                if (bl == null) {
                    n = 384;
                } else if (Intrinsics.areEqual(bl, true)) {
                    n = 385;
                } else if (Intrinsics.areEqual(bl, false)) {
                    n = 386;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.$instructions.plusAssign(WasmRunInterpreter.access$compile$ins(n, 0));
            }

            public void visitLabel(@NotNull WasmCodeVisitor.Label label, @NotNull WasmCodeVisitor.Context context2) {
                label.setTarget(this.$instructions.size());
            }
        });
        for (Patch patch : patches) {
            int intIndex = patch.getIntIndex();
            int instrutionIndex = patch.getInstrutionIndex();
            if (instrutionIndex >= 0) {
                instructions.set(instrutionIndex, WasmRunInterpreter.compile$ins(instructions.get(instrutionIndex) & 0xFFF, patch.getLabel().getTarget()));
            }
            if (intIndex < 0) continue;
            poolInts.set(intIndex, patch.getLabel().getTarget());
        }
        Object object = instructions.toIntArray();
        int[] nArray = poolInts.toIntArray();
        long[] lArray = CollectionsKt.toLongArray((Collection<Long>)poolLongs);
        float[] fArray = poolFloats.toFloatArray();
        double[] dArray = poolDoubles.toDoubleArray();
        int n = localsOffset.element;
        int[] nArray2 = ((WasmCodeVisitor.Context)context2.element).getLocalsMemOffset();
        int n2 = ((WasmCodeVisitor.Context)context2.element).getParamsOffset();
        int n3 = ((WasmCodeVisitor.Context)context2.element).getFunc().getType().getArgs().size();
        int n4 = ((WasmCodeVisitor.Context)context2.element).getFuncLocals().size();
        ArrayList<WasmSType> arrayList = ((WasmCodeVisitor.Context)context2.element).getStack();
        return new WasmInterpreterCode((int[])object, nArray, lArray, fArray, dArray, n2, n, n3, n4, nArray2, (List<? extends WasmType>)arrayList, debug);
    }

    private static final int compile$ins(int op, int param) {
        if (!(op == (op & 0xFFF))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(param == param << 12 >> 12)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (op == 2775) {
            throw new NotImplementedError(null, 1, null);
        }
        return op & 0xFFF | param << 12;
    }

    static /* synthetic */ int compile$ins$default(int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return WasmRunInterpreter.compile$ins(n, n2);
    }

    public static final /* synthetic */ int access$compile$ins(int op, int param) {
        return WasmRunInterpreter.compile$ins(op, param);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0003\b\u00a8\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010^\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010`\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010i\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010j\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010k\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010l\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010o\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010p\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010q\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010s\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010u\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010v\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010w\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010x\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010y\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010z\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010{\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010|\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010}\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010~\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u007f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0080\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0081\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0082\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0083\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0084\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0085\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0086\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0087\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0088\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0089\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008a\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008b\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008c\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008d\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008e\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008f\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0090\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0091\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0092\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0093\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0094\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0095\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0096\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0097\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0098\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0099\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009a\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009b\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009c\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009d\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009e\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009f\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a0\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a1\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a2\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a3\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a4\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a5\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a6\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a7\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a8\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a9\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00aa\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ab\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ac\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ad\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ae\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00af\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b0\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b1\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b2\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b3\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b4\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b5\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b6\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b7\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b8\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00b9\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ba\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00bb\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00bc\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00bd\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00be\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00bf\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c0\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c1\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c2\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c3\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c4\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c5\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c6\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c7\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c8\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00c9\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ca\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00cb\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00cc\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00cd\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ce\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00cf\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d0\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d1\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d2\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d3\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d4\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d5\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d6\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d7\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d8\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00d9\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00da\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00db\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00dc\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00dd\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00de\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00df\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e0\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e1\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e2\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e3\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e4\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e5\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e6\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e7\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e8\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00e9\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ea\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00eb\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ec\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ed\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ee\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ef\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f0\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f1\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f2\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f3\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f4\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f5\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f6\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f7\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f8\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00f9\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00fa\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00fb\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00fc\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00fd\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00fe\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ff\u0001\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0080\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0081\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0082\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0083\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0084\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0085\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0086\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0087\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0088\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0089\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008a\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008b\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008c\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008d\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008e\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u008f\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0090\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0091\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0092\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0093\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0094\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0095\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0096\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0097\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0098\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0099\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009a\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009b\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009c\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009d\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009e\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009f\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a0\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a1\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a2\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a3\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a4\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a5\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a6\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a7\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a8\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a9\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00aa\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ab\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ac\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00ad\u0002\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ae\u0002"}, d2={"Lkorlibs/wasm/WasmRunInterpreter$WasmFastInstructions;", "", "()V", "NAME_FROM_OP", "", "", "", "getNAME_FROM_OP", "()Ljava/util/Map;", "OP_FROM_NAME", "getOP_FROM_NAME", "Op_block", "Op_br", "Op_br_if", "Op_br_table", "Op_call", "Op_call_indirect", "Op_call_ref", "Op_catch", "Op_catch_all", "Op_data_drop", "Op_delegate", "Op_drop", "Op_elem_drop", "Op_else", "Op_end", "Op_f32_abs", "Op_f32_add", "Op_f32_ceil", "Op_f32_const", "Op_f32_convert_i32_s", "Op_f32_convert_i32_u", "Op_f32_convert_i64_s", "Op_f32_convert_i64_u", "Op_f32_copysign", "Op_f32_demote_f64", "Op_f32_div", "Op_f32_drop", "Op_f32_eq", "Op_f32_floor", "Op_f32_ge", "Op_f32_global_get", "Op_f32_global_set", "Op_f32_gt", "Op_f32_le", "Op_f32_load", "Op_f32_local_get", "Op_f32_local_set", "Op_f32_local_tee", "Op_f32_lt", "Op_f32_max", "Op_f32_min", "Op_f32_mul", "Op_f32_ne", "Op_f32_nearest", "Op_f32_neg", "Op_f32_reinterpret_i32", "Op_f32_return", "Op_f32_select", "Op_f32_short_const", "Op_f32_sqrt", "Op_f32_store", "Op_f32_sub", "Op_f32_trunc", "Op_f64_abs", "Op_f64_add", "Op_f64_ceil", "Op_f64_const", "Op_f64_convert_i32_s", "Op_f64_convert_i32_u", "Op_f64_convert_i64_s", "Op_f64_convert_i64_u", "Op_f64_copysign", "Op_f64_div", "Op_f64_drop", "Op_f64_eq", "Op_f64_floor", "Op_f64_ge", "Op_f64_global_get", "Op_f64_global_set", "Op_f64_gt", "Op_f64_le", "Op_f64_load", "Op_f64_local_get", "Op_f64_local_set", "Op_f64_local_tee", "Op_f64_lt", "Op_f64_max", "Op_f64_min", "Op_f64_mul", "Op_f64_ne", "Op_f64_nearest", "Op_f64_neg", "Op_f64_promote_f32", "Op_f64_reinterpret_i64", "Op_f64_return", "Op_f64_select", "Op_f64_short_const", "Op_f64_sqrt", "Op_f64_store", "Op_f64_sub", "Op_f64_trunc", "Op_global_get", "Op_global_set", "Op_goto", "Op_goto_if", "Op_goto_if_not", "Op_goto_if_not_f32_eq", "Op_goto_if_not_f32_ge", "Op_goto_if_not_f32_gt", "Op_goto_if_not_f32_le", "Op_goto_if_not_f32_lt", "Op_goto_if_not_f32_ne", "Op_goto_if_not_f64_eq", "Op_goto_if_not_f64_ge", "Op_goto_if_not_f64_gt", "Op_goto_if_not_f64_le", "Op_goto_if_not_f64_lt", "Op_goto_if_not_f64_ne", "Op_goto_if_not_i32_eq", "Op_goto_if_not_i32_eqz", "Op_goto_if_not_i32_ge_s", "Op_goto_if_not_i32_ge_u", "Op_goto_if_not_i32_gt_s", "Op_goto_if_not_i32_gt_u", "Op_goto_if_not_i32_le_s", "Op_goto_if_not_i32_le_u", "Op_goto_if_not_i32_lt_s", "Op_goto_if_not_i32_lt_u", "Op_goto_if_not_i32_ne", "Op_goto_if_not_i64_eq", "Op_goto_if_not_i64_eqz", "Op_goto_if_not_i64_ge_s", "Op_goto_if_not_i64_ge_u", "Op_goto_if_not_i64_gt_s", "Op_goto_if_not_i64_gt_u", "Op_goto_if_not_i64_le_s", "Op_goto_if_not_i64_le_u", "Op_goto_if_not_i64_lt_s", "Op_goto_if_not_i64_lt_u", "Op_goto_if_not_i64_ne", "Op_goto_table", "Op_i32_add", "Op_i32_and", "Op_i32_clz", "Op_i32_const", "Op_i32_ctz", "Op_i32_div_s", "Op_i32_div_u", "Op_i32_drop", "Op_i32_eq", "Op_i32_eqz", "Op_i32_extend16_s", "Op_i32_extend8_s", "Op_i32_ge_s", "Op_i32_ge_u", "Op_i32_global_get", "Op_i32_global_set", "Op_i32_gt_s", "Op_i32_gt_u", "Op_i32_le_s", "Op_i32_le_u", "Op_i32_load", "Op_i32_load16_s", "Op_i32_load16_u", "Op_i32_load8_s", "Op_i32_load8_u", "Op_i32_local_get", "Op_i32_local_set", "Op_i32_local_tee", "Op_i32_lt_s", "Op_i32_lt_u", "Op_i32_mul", "Op_i32_ne", "Op_i32_or", "Op_i32_popcnt", "Op_i32_reinterpret_f32", "Op_i32_rem_s", "Op_i32_rem_u", "Op_i32_return", "Op_i32_rotl", "Op_i32_rotr", "Op_i32_select", "Op_i32_shl", "Op_i32_short_const", "Op_i32_shr_s", "Op_i32_shr_u", "Op_i32_store", "Op_i32_store16", "Op_i32_store8", "Op_i32_sub", "Op_i32_trunc_f32_s", "Op_i32_trunc_f32_u", "Op_i32_trunc_f64_s", "Op_i32_trunc_f64_u", "Op_i32_trunc_sat_f32_s", "Op_i32_trunc_sat_f32_u", "Op_i32_trunc_sat_f64_s", "Op_i32_trunc_sat_f64_u", "Op_i32_wrap_i64", "Op_i32_xor", "Op_i64_add", "Op_i64_and", "Op_i64_clz", "Op_i64_const", "Op_i64_ctz", "Op_i64_div_s", "Op_i64_div_u", "Op_i64_drop", "Op_i64_eq", "Op_i64_eqz", "Op_i64_extend16_s", "Op_i64_extend32_s", "Op_i64_extend8_s", "Op_i64_extend_i32_s", "Op_i64_extend_i32_u", "Op_i64_ge_s", "Op_i64_ge_u", "Op_i64_global_get", "Op_i64_global_set", "Op_i64_gt_s", "Op_i64_gt_u", "Op_i64_le_s", "Op_i64_le_u", "Op_i64_load", "Op_i64_load16_s", "Op_i64_load16_u", "Op_i64_load32_s", "Op_i64_load32_u", "Op_i64_load8_s", "Op_i64_load8_u", "Op_i64_local_get", "Op_i64_local_set", "Op_i64_local_tee", "Op_i64_lt_s", "Op_i64_lt_u", "Op_i64_mul", "Op_i64_ne", "Op_i64_or", "Op_i64_popcnt", "Op_i64_reinterpret_f64", "Op_i64_rem_s", "Op_i64_rem_u", "Op_i64_return", "Op_i64_rotl", "Op_i64_rotr", "Op_i64_select", "Op_i64_shl", "Op_i64_short_const", "Op_i64_shr_s", "Op_i64_shr_u", "Op_i64_store", "Op_i64_store16", "Op_i64_store32", "Op_i64_store8", "Op_i64_sub", "Op_i64_trunc_f32_s", "Op_i64_trunc_f32_u", "Op_i64_trunc_f64_s", "Op_i64_trunc_f64_u", "Op_i64_trunc_sat_f32_s", "Op_i64_trunc_sat_f32_u", "Op_i64_trunc_sat_f64_s", "Op_i64_trunc_sat_f64_u", "Op_i64_xor", "Op_if", "Op_local_get", "Op_local_set", "Op_local_tee", "Op_loop", "Op_memory_copy", "Op_memory_fill", "Op_memory_grow", "Op_memory_init", "Op_memory_size", "Op_nop", "Op_ref_is_null", "Op_ref_null", "Op_reserved_0x0a", "Op_rethrow", "Op_return", "Op_return_call", "Op_return_call_indirect", "Op_return_call_ref", "Op_select", "Op_table_copy", "Op_table_fill", "Op_table_grow", "Op_table_init", "Op_table_size", "Op_throw", "Op_try", "Op_unreachable", "Op_v128_drop", "Op_v128_global_get", "Op_v128_global_set", "Op_v128_local_get", "Op_v128_local_set", "Op_v128_local_tee", "Op_v128_return", "Op_v128_select", "Op_void_return", "korge-core"})
    public static final class WasmFastInstructions {
        @NotNull
        public static final WasmFastInstructions INSTANCE = new WasmFastInstructions();
        public static final int Op_unreachable = 0;
        public static final int Op_nop = 1;
        public static final int Op_block = 2;
        public static final int Op_loop = 3;
        public static final int Op_if = 4;
        public static final int Op_else = 5;
        public static final int Op_try = 6;
        public static final int Op_catch = 7;
        public static final int Op_throw = 8;
        public static final int Op_rethrow = 9;
        public static final int Op_reserved_0x0a = 10;
        public static final int Op_end = 11;
        public static final int Op_br = 12;
        public static final int Op_br_if = 13;
        public static final int Op_br_table = 14;
        public static final int Op_return = 15;
        public static final int Op_call = 16;
        public static final int Op_call_indirect = 17;
        public static final int Op_return_call = 18;
        public static final int Op_return_call_indirect = 19;
        public static final int Op_call_ref = 20;
        public static final int Op_return_call_ref = 21;
        public static final int Op_delegate = 24;
        public static final int Op_catch_all = 25;
        public static final int Op_drop = 26;
        public static final int Op_select = 27;
        public static final int Op_local_get = 32;
        public static final int Op_local_set = 33;
        public static final int Op_local_tee = 34;
        public static final int Op_global_get = 35;
        public static final int Op_global_set = 36;
        public static final int Op_i32_load = 40;
        public static final int Op_i64_load = 41;
        public static final int Op_f32_load = 42;
        public static final int Op_f64_load = 43;
        public static final int Op_i32_load8_s = 44;
        public static final int Op_i32_load8_u = 45;
        public static final int Op_i32_load16_s = 46;
        public static final int Op_i32_load16_u = 47;
        public static final int Op_i64_load8_s = 48;
        public static final int Op_i64_load8_u = 49;
        public static final int Op_i64_load16_s = 50;
        public static final int Op_i64_load16_u = 51;
        public static final int Op_i64_load32_s = 52;
        public static final int Op_i64_load32_u = 53;
        public static final int Op_i32_store = 54;
        public static final int Op_i64_store = 55;
        public static final int Op_f32_store = 56;
        public static final int Op_f64_store = 57;
        public static final int Op_i32_store8 = 58;
        public static final int Op_i32_store16 = 59;
        public static final int Op_i64_store8 = 60;
        public static final int Op_i64_store16 = 61;
        public static final int Op_i64_store32 = 62;
        public static final int Op_memory_size = 63;
        public static final int Op_memory_grow = 64;
        public static final int Op_i32_const = 65;
        public static final int Op_i64_const = 66;
        public static final int Op_f32_const = 67;
        public static final int Op_f64_const = 68;
        public static final int Op_i32_eqz = 69;
        public static final int Op_i32_eq = 70;
        public static final int Op_i32_ne = 71;
        public static final int Op_i32_lt_s = 72;
        public static final int Op_i32_lt_u = 73;
        public static final int Op_i32_gt_s = 74;
        public static final int Op_i32_gt_u = 75;
        public static final int Op_i32_le_s = 76;
        public static final int Op_i32_le_u = 77;
        public static final int Op_i32_ge_s = 78;
        public static final int Op_i32_ge_u = 79;
        public static final int Op_i64_eqz = 80;
        public static final int Op_i64_eq = 81;
        public static final int Op_i64_ne = 82;
        public static final int Op_i64_lt_s = 83;
        public static final int Op_i64_lt_u = 84;
        public static final int Op_i64_gt_s = 85;
        public static final int Op_i64_gt_u = 86;
        public static final int Op_i64_le_s = 87;
        public static final int Op_i64_le_u = 88;
        public static final int Op_i64_ge_s = 89;
        public static final int Op_i64_ge_u = 90;
        public static final int Op_f32_eq = 91;
        public static final int Op_f32_ne = 92;
        public static final int Op_f32_lt = 93;
        public static final int Op_f32_gt = 94;
        public static final int Op_f32_le = 95;
        public static final int Op_f32_ge = 96;
        public static final int Op_f64_eq = 97;
        public static final int Op_f64_ne = 98;
        public static final int Op_f64_lt = 99;
        public static final int Op_f64_gt = 100;
        public static final int Op_f64_le = 101;
        public static final int Op_f64_ge = 102;
        public static final int Op_i32_clz = 103;
        public static final int Op_i32_ctz = 104;
        public static final int Op_i32_popcnt = 105;
        public static final int Op_i32_add = 106;
        public static final int Op_i32_sub = 107;
        public static final int Op_i32_mul = 108;
        public static final int Op_i32_div_s = 109;
        public static final int Op_i32_div_u = 110;
        public static final int Op_i32_rem_s = 111;
        public static final int Op_i32_rem_u = 112;
        public static final int Op_i32_and = 113;
        public static final int Op_i32_or = 114;
        public static final int Op_i32_xor = 115;
        public static final int Op_i32_shl = 116;
        public static final int Op_i32_shr_s = 117;
        public static final int Op_i32_shr_u = 118;
        public static final int Op_i32_rotl = 119;
        public static final int Op_i32_rotr = 120;
        public static final int Op_i64_clz = 121;
        public static final int Op_i64_ctz = 122;
        public static final int Op_i64_popcnt = 123;
        public static final int Op_i64_add = 124;
        public static final int Op_i64_sub = 125;
        public static final int Op_i64_mul = 126;
        public static final int Op_i64_div_s = 127;
        public static final int Op_i64_div_u = 128;
        public static final int Op_i64_rem_s = 129;
        public static final int Op_i64_rem_u = 130;
        public static final int Op_i64_and = 131;
        public static final int Op_i64_or = 132;
        public static final int Op_i64_xor = 133;
        public static final int Op_i64_shl = 134;
        public static final int Op_i64_shr_s = 135;
        public static final int Op_i64_shr_u = 136;
        public static final int Op_i64_rotl = 137;
        public static final int Op_i64_rotr = 138;
        public static final int Op_f32_abs = 139;
        public static final int Op_f32_neg = 140;
        public static final int Op_f32_ceil = 141;
        public static final int Op_f32_floor = 142;
        public static final int Op_f32_trunc = 143;
        public static final int Op_f32_nearest = 144;
        public static final int Op_f32_sqrt = 145;
        public static final int Op_f32_add = 146;
        public static final int Op_f32_sub = 147;
        public static final int Op_f32_mul = 148;
        public static final int Op_f32_div = 149;
        public static final int Op_f32_min = 150;
        public static final int Op_f32_max = 151;
        public static final int Op_f32_copysign = 152;
        public static final int Op_f64_abs = 153;
        public static final int Op_f64_neg = 154;
        public static final int Op_f64_ceil = 155;
        public static final int Op_f64_floor = 156;
        public static final int Op_f64_trunc = 157;
        public static final int Op_f64_nearest = 158;
        public static final int Op_f64_sqrt = 159;
        public static final int Op_f64_add = 160;
        public static final int Op_f64_sub = 161;
        public static final int Op_f64_mul = 162;
        public static final int Op_f64_div = 163;
        public static final int Op_f64_min = 164;
        public static final int Op_f64_max = 165;
        public static final int Op_f64_copysign = 166;
        public static final int Op_i32_wrap_i64 = 167;
        public static final int Op_i32_trunc_f32_s = 168;
        public static final int Op_i32_trunc_f32_u = 169;
        public static final int Op_i32_trunc_f64_s = 170;
        public static final int Op_i32_trunc_f64_u = 171;
        public static final int Op_i64_extend_i32_s = 172;
        public static final int Op_i64_extend_i32_u = 173;
        public static final int Op_i64_trunc_f32_s = 174;
        public static final int Op_i64_trunc_f32_u = 175;
        public static final int Op_i64_trunc_f64_s = 176;
        public static final int Op_i64_trunc_f64_u = 177;
        public static final int Op_f32_convert_i32_s = 178;
        public static final int Op_f32_convert_i32_u = 179;
        public static final int Op_f32_convert_i64_s = 180;
        public static final int Op_f32_convert_i64_u = 181;
        public static final int Op_f32_demote_f64 = 182;
        public static final int Op_f64_convert_i32_s = 183;
        public static final int Op_f64_convert_i32_u = 184;
        public static final int Op_f64_convert_i64_s = 185;
        public static final int Op_f64_convert_i64_u = 186;
        public static final int Op_f64_promote_f32 = 187;
        public static final int Op_i32_reinterpret_f32 = 188;
        public static final int Op_i64_reinterpret_f64 = 189;
        public static final int Op_f32_reinterpret_i32 = 190;
        public static final int Op_f64_reinterpret_i64 = 191;
        public static final int Op_i32_extend8_s = 192;
        public static final int Op_i32_extend16_s = 193;
        public static final int Op_i64_extend8_s = 194;
        public static final int Op_i64_extend16_s = 195;
        public static final int Op_i64_extend32_s = 196;
        public static final int Op_ref_null = 208;
        public static final int Op_ref_is_null = 209;
        public static final int Op_i32_drop = 256;
        public static final int Op_i64_drop = 257;
        public static final int Op_f32_drop = 258;
        public static final int Op_f64_drop = 259;
        public static final int Op_v128_drop = 260;
        public static final int Op_i32_local_get = 272;
        public static final int Op_i64_local_get = 273;
        public static final int Op_f32_local_get = 274;
        public static final int Op_f64_local_get = 275;
        public static final int Op_v128_local_get = 276;
        public static final int Op_i32_local_set = 288;
        public static final int Op_i64_local_set = 289;
        public static final int Op_f32_local_set = 290;
        public static final int Op_f64_local_set = 291;
        public static final int Op_v128_local_set = 292;
        public static final int Op_i32_local_tee = 304;
        public static final int Op_i64_local_tee = 305;
        public static final int Op_f32_local_tee = 306;
        public static final int Op_f64_local_tee = 307;
        public static final int Op_v128_local_tee = 308;
        public static final int Op_i32_global_get = 320;
        public static final int Op_i64_global_get = 321;
        public static final int Op_f32_global_get = 322;
        public static final int Op_f64_global_get = 323;
        public static final int Op_v128_global_get = 324;
        public static final int Op_i32_global_set = 336;
        public static final int Op_i64_global_set = 337;
        public static final int Op_f32_global_set = 338;
        public static final int Op_f64_global_set = 339;
        public static final int Op_v128_global_set = 340;
        public static final int Op_i32_return = 352;
        public static final int Op_i64_return = 353;
        public static final int Op_f32_return = 354;
        public static final int Op_f64_return = 355;
        public static final int Op_v128_return = 356;
        public static final int Op_void_return = 357;
        public static final int Op_i32_short_const = 368;
        public static final int Op_i64_short_const = 369;
        public static final int Op_f32_short_const = 370;
        public static final int Op_f64_short_const = 371;
        public static final int Op_goto = 384;
        public static final int Op_goto_if = 385;
        public static final int Op_goto_if_not = 386;
        public static final int Op_goto_table = 387;
        public static final int Op_i32_select = 400;
        public static final int Op_i64_select = 401;
        public static final int Op_f32_select = 402;
        public static final int Op_f64_select = 403;
        public static final int Op_v128_select = 404;
        public static final int Op_goto_if_not_i32_eqz = 416;
        public static final int Op_goto_if_not_i32_eq = 417;
        public static final int Op_goto_if_not_i32_ne = 418;
        public static final int Op_goto_if_not_i32_lt_s = 419;
        public static final int Op_goto_if_not_i32_lt_u = 420;
        public static final int Op_goto_if_not_i32_gt_s = 421;
        public static final int Op_goto_if_not_i32_gt_u = 422;
        public static final int Op_goto_if_not_i32_le_s = 423;
        public static final int Op_goto_if_not_i32_le_u = 424;
        public static final int Op_goto_if_not_i32_ge_s = 425;
        public static final int Op_goto_if_not_i32_ge_u = 426;
        public static final int Op_goto_if_not_i64_eqz = 427;
        public static final int Op_goto_if_not_i64_eq = 428;
        public static final int Op_goto_if_not_i64_ne = 429;
        public static final int Op_goto_if_not_i64_lt_s = 430;
        public static final int Op_goto_if_not_i64_lt_u = 431;
        public static final int Op_goto_if_not_i64_gt_s = 432;
        public static final int Op_goto_if_not_i64_gt_u = 433;
        public static final int Op_goto_if_not_i64_le_s = 434;
        public static final int Op_goto_if_not_i64_le_u = 435;
        public static final int Op_goto_if_not_i64_ge_s = 436;
        public static final int Op_goto_if_not_i64_ge_u = 437;
        public static final int Op_goto_if_not_f32_eq = 438;
        public static final int Op_goto_if_not_f32_ne = 439;
        public static final int Op_goto_if_not_f32_lt = 440;
        public static final int Op_goto_if_not_f32_gt = 441;
        public static final int Op_goto_if_not_f32_le = 442;
        public static final int Op_goto_if_not_f32_ge = 443;
        public static final int Op_goto_if_not_f64_eq = 444;
        public static final int Op_goto_if_not_f64_ne = 445;
        public static final int Op_goto_if_not_f64_lt = 446;
        public static final int Op_goto_if_not_f64_gt = 447;
        public static final int Op_goto_if_not_f64_le = 448;
        public static final int Op_goto_if_not_f64_ge = 449;
        public static final int Op_i32_trunc_sat_f32_s = 512;
        public static final int Op_i32_trunc_sat_f32_u = 513;
        public static final int Op_i32_trunc_sat_f64_s = 514;
        public static final int Op_i32_trunc_sat_f64_u = 515;
        public static final int Op_i64_trunc_sat_f32_s = 516;
        public static final int Op_i64_trunc_sat_f32_u = 517;
        public static final int Op_i64_trunc_sat_f64_s = 518;
        public static final int Op_i64_trunc_sat_f64_u = 519;
        public static final int Op_memory_init = 520;
        public static final int Op_data_drop = 521;
        public static final int Op_memory_copy = 522;
        public static final int Op_memory_fill = 523;
        public static final int Op_table_init = 524;
        public static final int Op_elem_drop = 525;
        public static final int Op_table_copy = 526;
        public static final int Op_table_grow = 527;
        public static final int Op_table_size = 528;
        public static final int Op_table_fill = 529;
        @NotNull
        private static final Map<String, Integer> OP_FROM_NAME;
        @NotNull
        private static final Map<Integer, String> NAME_FROM_OP;

        private WasmFastInstructions() {
        }

        @NotNull
        public final Map<String, Integer> getOP_FROM_NAME() {
            return OP_FROM_NAME;
        }

        @NotNull
        public final Map<Integer, String> getNAME_FROM_OP() {
            return NAME_FROM_OP;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to("Op_unreachable", 0), TuplesKt.to("Op_nop", 1), TuplesKt.to("Op_block", 2), TuplesKt.to("Op_loop", 3), TuplesKt.to("Op_if", 4), TuplesKt.to("Op_else", 5), TuplesKt.to("Op_try", 6), TuplesKt.to("Op_catch", 7), TuplesKt.to("Op_throw", 8), TuplesKt.to("Op_rethrow", 9), TuplesKt.to("Op_reserved_0x0a", 10), TuplesKt.to("Op_end", 11), TuplesKt.to("Op_br", 12), TuplesKt.to("Op_br_if", 13), TuplesKt.to("Op_br_table", 14), TuplesKt.to("Op_return", 15), TuplesKt.to("Op_call", 16), TuplesKt.to("Op_call_indirect", 17), TuplesKt.to("Op_return_call", 18), TuplesKt.to("Op_return_call_indirect", 19), TuplesKt.to("Op_call_ref", 20), TuplesKt.to("Op_return_call_ref", 21), TuplesKt.to("Op_delegate", 24), TuplesKt.to("Op_catch_all", 25), TuplesKt.to("Op_drop", 26), TuplesKt.to("Op_select", 27), TuplesKt.to("Op_local_get", 32), TuplesKt.to("Op_local_set", 33), TuplesKt.to("Op_local_tee", 34), TuplesKt.to("Op_global_get", 35), TuplesKt.to("Op_global_set", 36), TuplesKt.to("Op_i32_load", 40), TuplesKt.to("Op_i64_load", 41), TuplesKt.to("Op_f32_load", 42), TuplesKt.to("Op_f64_load", 43), TuplesKt.to("Op_i32_load8_s", 44), TuplesKt.to("Op_i32_load8_u", 45), TuplesKt.to("Op_i32_load16_s", 46), TuplesKt.to("Op_i32_load16_u", 47), TuplesKt.to("Op_i64_load8_s", 48), TuplesKt.to("Op_i64_load8_u", 49), TuplesKt.to("Op_i64_load16_s", 50), TuplesKt.to("Op_i64_load16_u", 51), TuplesKt.to("Op_i64_load32_s", 52), TuplesKt.to("Op_i64_load32_u", 53), TuplesKt.to("Op_i32_store", 54), TuplesKt.to("Op_i64_store", 55), TuplesKt.to("Op_f32_store", 56), TuplesKt.to("Op_f64_store", 57), TuplesKt.to("Op_i32_store8", 58), TuplesKt.to("Op_i32_store16", 59), TuplesKt.to("Op_i64_store8", 60), TuplesKt.to("Op_i64_store16", 61), TuplesKt.to("Op_i64_store32", 62), TuplesKt.to("Op_memory_size", 63), TuplesKt.to("Op_memory_grow", 64), TuplesKt.to("Op_i32_const", 65), TuplesKt.to("Op_i64_const", 66), TuplesKt.to("Op_f32_const", 67), TuplesKt.to("Op_f64_const", 68), TuplesKt.to("Op_i32_eqz", 69), TuplesKt.to("Op_i32_eq", 70), TuplesKt.to("Op_i32_ne", 71), TuplesKt.to("Op_i32_lt_s", 72), TuplesKt.to("Op_i32_lt_u", 73), TuplesKt.to("Op_i32_gt_s", 74), TuplesKt.to("Op_i32_gt_u", 75), TuplesKt.to("Op_i32_le_s", 76), TuplesKt.to("Op_i32_le_u", 77), TuplesKt.to("Op_i32_ge_s", 78), TuplesKt.to("Op_i32_ge_u", 79), TuplesKt.to("Op_i64_eqz", 80), TuplesKt.to("Op_i64_eq", 81), TuplesKt.to("Op_i64_ne", 82), TuplesKt.to("Op_i64_lt_s", 83), TuplesKt.to("Op_i64_lt_u", 84), TuplesKt.to("Op_i64_gt_s", 85), TuplesKt.to("Op_i64_gt_u", 86), TuplesKt.to("Op_i64_le_s", 87), TuplesKt.to("Op_i64_le_u", 88), TuplesKt.to("Op_i64_ge_s", 89), TuplesKt.to("Op_i64_ge_u", 90), TuplesKt.to("Op_f32_eq", 91), TuplesKt.to("Op_f32_ne", 92), TuplesKt.to("Op_f32_lt", 93), TuplesKt.to("Op_f32_gt", 94), TuplesKt.to("Op_f32_le", 95), TuplesKt.to("Op_f32_ge", 96), TuplesKt.to("Op_f64_eq", 97), TuplesKt.to("Op_f64_ne", 98), TuplesKt.to("Op_f64_lt", 99), TuplesKt.to("Op_f64_gt", 100), TuplesKt.to("Op_f64_le", 101), TuplesKt.to("Op_f64_ge", 102), TuplesKt.to("Op_i32_clz", 103), TuplesKt.to("Op_i32_ctz", 104), TuplesKt.to("Op_i32_popcnt", 105), TuplesKt.to("Op_i32_add", 106), TuplesKt.to("Op_i32_sub", 107), TuplesKt.to("Op_i32_mul", 108), TuplesKt.to("Op_i32_div_s", 109), TuplesKt.to("Op_i32_div_u", 110), TuplesKt.to("Op_i32_rem_s", 111), TuplesKt.to("Op_i32_rem_u", 112), TuplesKt.to("Op_i32_and", 113), TuplesKt.to("Op_i32_or", 114), TuplesKt.to("Op_i32_xor", 115), TuplesKt.to("Op_i32_shl", 116), TuplesKt.to("Op_i32_shr_s", 117), TuplesKt.to("Op_i32_shr_u", 118), TuplesKt.to("Op_i32_rotl", 119), TuplesKt.to("Op_i32_rotr", 120), TuplesKt.to("Op_i64_clz", 121), TuplesKt.to("Op_i64_ctz", 122), TuplesKt.to("Op_i64_popcnt", 123), TuplesKt.to("Op_i64_add", 124), TuplesKt.to("Op_i64_sub", 125), TuplesKt.to("Op_i64_mul", 126), TuplesKt.to("Op_i64_div_s", 127), TuplesKt.to("Op_i64_div_u", 128), TuplesKt.to("Op_i64_rem_s", 129), TuplesKt.to("Op_i64_rem_u", 130), TuplesKt.to("Op_i64_and", 131), TuplesKt.to("Op_i64_or", 132), TuplesKt.to("Op_i64_xor", 133), TuplesKt.to("Op_i64_shl", 134), TuplesKt.to("Op_i64_shr_s", 135), TuplesKt.to("Op_i64_shr_u", 136), TuplesKt.to("Op_i64_rotl", 137), TuplesKt.to("Op_i64_rotr", 138), TuplesKt.to("Op_f32_abs", 139), TuplesKt.to("Op_f32_neg", 140), TuplesKt.to("Op_f32_ceil", 141), TuplesKt.to("Op_f32_floor", 142), TuplesKt.to("Op_f32_trunc", 143), TuplesKt.to("Op_f32_nearest", 144), TuplesKt.to("Op_f32_sqrt", 145), TuplesKt.to("Op_f32_add", 146), TuplesKt.to("Op_f32_sub", 147), TuplesKt.to("Op_f32_mul", 148), TuplesKt.to("Op_f32_div", 149), TuplesKt.to("Op_f32_min", 150), TuplesKt.to("Op_f32_max", 151), TuplesKt.to("Op_f32_copysign", 152), TuplesKt.to("Op_f64_abs", 153), TuplesKt.to("Op_f64_neg", 154), TuplesKt.to("Op_f64_ceil", 155), TuplesKt.to("Op_f64_floor", 156), TuplesKt.to("Op_f64_trunc", 157), TuplesKt.to("Op_f64_nearest", 158), TuplesKt.to("Op_f64_sqrt", 159), TuplesKt.to("Op_f64_add", 160), TuplesKt.to("Op_f64_sub", 161), TuplesKt.to("Op_f64_mul", 162), TuplesKt.to("Op_f64_div", 163), TuplesKt.to("Op_f64_min", 164), TuplesKt.to("Op_f64_max", 165), TuplesKt.to("Op_f64_copysign", 166), TuplesKt.to("Op_i32_wrap_i64", 167), TuplesKt.to("Op_i32_trunc_f32_s", 168), TuplesKt.to("Op_i32_trunc_f32_u", 169), TuplesKt.to("Op_i32_trunc_f64_s", 170), TuplesKt.to("Op_i32_trunc_f64_u", 171), TuplesKt.to("Op_i64_extend_i32_s", 172), TuplesKt.to("Op_i64_extend_i32_u", 173), TuplesKt.to("Op_i64_trunc_f32_s", 174), TuplesKt.to("Op_i64_trunc_f32_u", 175), TuplesKt.to("Op_i64_trunc_f64_s", 176), TuplesKt.to("Op_i64_trunc_f64_u", 177), TuplesKt.to("Op_f32_convert_i32_s", 178), TuplesKt.to("Op_f32_convert_i32_u", 179), TuplesKt.to("Op_f32_convert_i64_s", 180), TuplesKt.to("Op_f32_convert_i64_u", 181), TuplesKt.to("Op_f32_demote_f64", 182), TuplesKt.to("Op_f64_convert_i32_s", 183), TuplesKt.to("Op_f64_convert_i32_u", 184), TuplesKt.to("Op_f64_convert_i64_s", 185), TuplesKt.to("Op_f64_convert_i64_u", 186), TuplesKt.to("Op_f64_promote_f32", 187), TuplesKt.to("Op_i32_reinterpret_f32", 188), TuplesKt.to("Op_i64_reinterpret_f64", 189), TuplesKt.to("Op_f32_reinterpret_i32", 190), TuplesKt.to("Op_f64_reinterpret_i64", 191), TuplesKt.to("Op_i32_extend8_s", 192), TuplesKt.to("Op_i32_extend16_s", 193), TuplesKt.to("Op_i64_extend8_s", 194), TuplesKt.to("Op_i64_extend16_s", 195), TuplesKt.to("Op_i64_extend32_s", 196), TuplesKt.to("Op_ref_null", 208), TuplesKt.to("Op_ref_is_null", 209), TuplesKt.to("Op_i32_drop", 256), TuplesKt.to("Op_i64_drop", 257), TuplesKt.to("Op_f32_drop", 258), TuplesKt.to("Op_f64_drop", 259), TuplesKt.to("Op_v128_drop", 260), TuplesKt.to("Op_i32_local_get", 272), TuplesKt.to("Op_i64_local_get", 273), TuplesKt.to("Op_f32_local_get", 274), TuplesKt.to("Op_f64_local_get", 275), TuplesKt.to("Op_v128_local_get", 276), TuplesKt.to("Op_i32_local_set", 288), TuplesKt.to("Op_i64_local_set", 289), TuplesKt.to("Op_f32_local_set", 290), TuplesKt.to("Op_f64_local_set", 291), TuplesKt.to("Op_v128_local_set", 292), TuplesKt.to("Op_i32_local_tee", 304), TuplesKt.to("Op_i64_local_tee", 305), TuplesKt.to("Op_f32_local_tee", 306), TuplesKt.to("Op_f64_local_tee", 307), TuplesKt.to("Op_v128_local_tee", 308), TuplesKt.to("Op_i32_global_get", 320), TuplesKt.to("Op_i64_global_get", 321), TuplesKt.to("Op_f32_global_get", 322), TuplesKt.to("Op_f64_global_get", 323), TuplesKt.to("Op_v128_global_get", 324), TuplesKt.to("Op_i32_global_set", 336), TuplesKt.to("Op_i64_global_set", 337), TuplesKt.to("Op_f32_global_set", 338), TuplesKt.to("Op_f64_global_set", 339), TuplesKt.to("Op_v128_global_set", 340), TuplesKt.to("Op_i32_return", 352), TuplesKt.to("Op_i64_return", 353), TuplesKt.to("Op_f32_return", 354), TuplesKt.to("Op_f64_return", 355), TuplesKt.to("Op_v128_return", 356), TuplesKt.to("Op_void_return", 357), TuplesKt.to("Op_i32_short_const", 368), TuplesKt.to("Op_i64_short_const", 369), TuplesKt.to("Op_f32_short_const", 370), TuplesKt.to("Op_f64_short_const", 371), TuplesKt.to("Op_goto", 384), TuplesKt.to("Op_goto_if", 385), TuplesKt.to("Op_goto_if_not", 386), TuplesKt.to("Op_goto_table", 387), TuplesKt.to("Op_i32_select", 400), TuplesKt.to("Op_i64_select", 401), TuplesKt.to("Op_f32_select", 402), TuplesKt.to("Op_f64_select", 403), TuplesKt.to("Op_v128_select", 404), TuplesKt.to("Op_goto_if_not_i32_eqz", 416), TuplesKt.to("Op_goto_if_not_i32_eq", 417), TuplesKt.to("Op_goto_if_not_i32_ne", 418), TuplesKt.to("Op_goto_if_not_i32_lt_s", 419), TuplesKt.to("Op_goto_if_not_i32_lt_u", 420), TuplesKt.to("Op_goto_if_not_i32_gt_s", 421), TuplesKt.to("Op_goto_if_not_i32_gt_u", 422), TuplesKt.to("Op_goto_if_not_i32_le_s", 423), TuplesKt.to("Op_goto_if_not_i32_le_u", 424), TuplesKt.to("Op_goto_if_not_i32_ge_s", 425), TuplesKt.to("Op_goto_if_not_i32_ge_u", 426), TuplesKt.to("Op_goto_if_not_i64_eqz", 427), TuplesKt.to("Op_goto_if_not_i64_eq", 428), TuplesKt.to("Op_goto_if_not_i64_ne", 429), TuplesKt.to("Op_goto_if_not_i64_lt_s", 430), TuplesKt.to("Op_goto_if_not_i64_lt_u", 431), TuplesKt.to("Op_goto_if_not_i64_gt_s", 432), TuplesKt.to("Op_goto_if_not_i64_gt_u", 433), TuplesKt.to("Op_goto_if_not_i64_le_s", 434), TuplesKt.to("Op_goto_if_not_i64_le_u", 435), TuplesKt.to("Op_goto_if_not_i64_ge_s", 436), TuplesKt.to("Op_goto_if_not_i64_ge_u", 437), TuplesKt.to("Op_goto_if_not_f32_eq", 438), TuplesKt.to("Op_goto_if_not_f32_ne", 439), TuplesKt.to("Op_goto_if_not_f32_lt", 440), TuplesKt.to("Op_goto_if_not_f32_gt", 441), TuplesKt.to("Op_goto_if_not_f32_le", 442), TuplesKt.to("Op_goto_if_not_f32_ge", 443), TuplesKt.to("Op_goto_if_not_f64_eq", 444), TuplesKt.to("Op_goto_if_not_f64_ne", 445), TuplesKt.to("Op_goto_if_not_f64_lt", 446), TuplesKt.to("Op_goto_if_not_f64_gt", 447), TuplesKt.to("Op_goto_if_not_f64_le", 448), TuplesKt.to("Op_goto_if_not_f64_ge", 449), TuplesKt.to("Op_i32_trunc_sat_f32_s", 512), TuplesKt.to("Op_i32_trunc_sat_f32_u", 513), TuplesKt.to("Op_i32_trunc_sat_f64_s", 514), TuplesKt.to("Op_i32_trunc_sat_f64_u", 515), TuplesKt.to("Op_i64_trunc_sat_f32_s", 516), TuplesKt.to("Op_i64_trunc_sat_f32_u", 517), TuplesKt.to("Op_i64_trunc_sat_f64_s", 518), TuplesKt.to("Op_i64_trunc_sat_f64_u", 519), TuplesKt.to("Op_memory_init", 520), TuplesKt.to("Op_data_drop", 521), TuplesKt.to("Op_memory_copy", 522), TuplesKt.to("Op_memory_fill", 523), TuplesKt.to("Op_table_init", 524), TuplesKt.to("Op_elem_drop", 525), TuplesKt.to("Op_table_copy", 526), TuplesKt.to("Op_table_grow", 527), TuplesKt.to("Op_table_size", 528), TuplesKt.to("Op_table_fill", 529)};
            OP_FROM_NAME = MapsKt.mapOf(pairArray);
            NAME_FROM_OP = _ExtensionsKt.flip(OP_FROM_NAME);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lkorlibs/wasm/WasmRunInterpreter$WasmFuncCallInt;", "Lkorlibs/wasm/WasmRuntime$WasmFuncCall;", "interpreter", "Lkorlibs/wasm/WasmRunInterpreter;", "func", "Lkorlibs/wasm/WasmFunc;", "(Lkorlibs/wasm/WasmRunInterpreter;Lkorlibs/wasm/WasmFunc;)V", "getFunc", "()Lkorlibs/wasm/WasmFunc;", "getInterpreter", "()Lkorlibs/wasm/WasmRunInterpreter;", "invoke", "", "runtime", "Lkorlibs/wasm/WasmRuntime;", "args", "", "(Lkorlibs/wasm/WasmRuntime;[Ljava/lang/Object;)Ljava/lang/Object;", "korge-core"})
    public static final class WasmFuncCallInt
    implements WasmRuntime.WasmFuncCall {
        @NotNull
        private final WasmRunInterpreter interpreter;
        @NotNull
        private final WasmFunc func;

        public WasmFuncCallInt(@NotNull WasmRunInterpreter interpreter, @NotNull WasmFunc func2) {
            this.interpreter = interpreter;
            this.func = func2;
        }

        @NotNull
        public final WasmRunInterpreter getInterpreter() {
            return this.interpreter;
        }

        @NotNull
        public final WasmFunc getFunc() {
            return this.func;
        }

        @Override
        @Nullable
        public Object invoke(@NotNull WasmRuntime runtime, @NotNull Object[] args2) {
            this.interpreter.callFunc(this.func);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WasmSType.values().length];
            try {
                nArray[WasmSType.VOID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmSType.I32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmSType.I64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmSType.F32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmSType.F64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmSType.V128.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmSType.ANYREF.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmSType.FUNCREF.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

