/*
 * Decompiled with CFR 0.152.
 */
package korlibs.wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import korlibs.logger.AnsiEscape;
import korlibs.memory.ArraysKt;
import korlibs.memory.Buffer;
import korlibs.memory.BufferKt;
import korlibs.wasm.WasmModule;
import korlibs.wasm.WasmType;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u001c\b\u0016\u0018\u0000 X2\u00020\u0001:\u0003XYZB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020;H\u0016J\u000e\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020\u0005J\u0012\u0010<\u001a\u00020;2\n\u0010>\u001a\u00020?\"\u00020\u0005J0\u0010@\u001a\u0004\u0018\u00010\u00012\u0006\u0010A\u001a\u00020\n2\u0016\u0010B\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0010\"\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010CJ/\u0010D\u001a\u0004\u0018\u00010\u00012\u0006\u0010E\u001a\u00020\u00052\u0016\u0010B\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0010\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010FJ\u0016\u0010G\u001a\u0002092\u0006\u0010=\u001a\u00020\u00052\u0006\u0010H\u001a\u000209J\u0016\u0010G\u001a\u0002092\u0006\u0010=\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005J\u000e\u0010I\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u0005J\u000e\u0010J\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u0005J\u000e\u0010K\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u0005JA\u0010L\u001a\u00020;2\u0006\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020\n2'\u0010O\u001a#\u0012\u0004\u0012\u00020\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f\u00a2\u0006\u0002\b\u0011H\u0016J\u000e\u0010P\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005J\u000e\u0010Q\u001a\u00020\u00052\u0006\u00108\u001a\u000209J\u000e\u0010R\u001a\u00020;2\u0006\u0010S\u001a\u00020\u0005J\u0006\u0010T\u001a\u00020\u0005J\u000e\u0010U\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005J\u000e\u0010V\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005J\u0016\u0010W\u001a\u00020;2\u0006\u0010=\u001a\u00020\u00052\u0006\u00108\u001a\u000209R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u00ea\u0001\u0010\r\u001a\u00da\u0001\u0012\u0004\u0012\u00020\n\u0012b\u0012`\u0012\u0004\u0012\u00020\n\u0012%\u0012#\u0012\u0004\u0012\u00020\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f\u00a2\u0006\u0002\b\u00110\u000ej/\u0012\u0004\u0012\u00020\n\u0012%\u0012#\u0012\u0004\u0012\u00020\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f\u00a2\u0006\u0002\b\u0011`\u00120\u000ejl\u0012\u0004\u0012\u00020\n\u0012b\u0012`\u0012\u0004\u0012\u00020\n\u0012%\u0012#\u0012\u0004\u0012\u00020\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f\u00a2\u0006\u0002\b\u00110\u000ej/\u0012\u0004\u0012\u00020\n\u0012%\u0012#\u0012\u0004\u0012\u00020\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f\u00a2\u0006\u0002\b\u0011`\u0012`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001cR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001c\"\u0004\b3\u00104\u00a8\u0006["}, d2={"Lkorlibs/wasm/WasmRuntime;", "", "module", "Lkorlibs/wasm/WasmModule;", "memSize", "", "memMax", "(Lkorlibs/wasm/WasmModule;II)V", "exported", "", "", "getExported", "()Ljava/util/Set;", "functions", "Ljava/util/LinkedHashMap;", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "Lkotlin/collections/LinkedHashMap;", "getFunctions", "()Ljava/util/LinkedHashMap;", "instructionsExecuted", "", "getInstructionsExecuted", "()J", "setInstructionsExecuted", "(J)V", "getMemMax", "()I", "getMemSize", "memory", "Lkorlibs/memory/Buffer;", "getMemory", "()Lkorlibs/memory/Buffer;", "setMemory", "(Lkorlibs/memory/Buffer;)V", "memoryNumPages", "getMemoryNumPages", "tables", "", "Lkorlibs/wasm/WasmRuntime$WasmTable;", "getTables", "()Ljava/util/List;", "trace", "", "getTrace", "()Z", "setTrace", "(Z)V", "usedClassMemory", "getUsedClassMemory", "setUsedClassMemory", "(I)V", "alloc", "size", "allocAndWrite", "data", "", "close", "", "free", "ptr", "ptrs", "", "invoke", "funcName", "params", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeIndirect", "index", "(I[Ljava/lang/Object;)Ljava/lang/Object;", "readBytes", "out", "readString", "readStringz", "readStringz16", "register", "moduleName", "name", "func", "stackAlloc", "stackAllocAndWrite", "stackRestore", "stack", "stackSave", "strlen", "strlen16", "writeBytes", "Companion", "WasmFuncCall", "WasmTable", "korge-core"})
@SourceDebugExtension(value={"SMAP\nWasmRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmRuntime.kt\nkorlibs/wasm/WasmRuntime\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Buffer.kt\nkorlibs/memory/BufferKt\n*L\n1#1,354:1\n1549#2:355\n1620#2,3:356\n372#3,7:359\n1#4:366\n191#5:367\n191#5:368\n*S KotlinDebug\n*F\n+ 1 WasmRuntime.kt\nkorlibs/wasm/WasmRuntime\n*L\n36#1:355\n36#1:356,3\n42#1:359,7\n70#1:367\n83#1:368\n*E\n"})
public class WasmRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int memSize;
    private final int memMax;
    private int usedClassMemory;
    private boolean trace;
    private long instructionsExecuted;
    @NotNull
    private Buffer memory;
    @NotNull
    private final List<WasmTable> tables;
    @NotNull
    private final LinkedHashMap<String, LinkedHashMap<String, Function2<WasmRuntime, Object[], Object>>> functions;
    public static final int PAGE_SIZE = 65536;

    /*
     * WARNING - void declaration
     */
    public WasmRuntime(@NotNull WasmModule module, int memSize, int memMax) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.memSize = memSize;
        this.memMax = memMax;
        this.memory = BufferKt.allocDirect(Buffer.Companion, this.memSize * 65536);
        Iterable iterable = module.getTables();
        WasmRuntime wasmRuntime = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WasmType.TableType tableType = (WasmType.TableType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WasmTable(it.getLimit()));
        }
        wasmRuntime.tables = (List)destination$iv$iv;
        this.functions = new LinkedHashMap();
    }

    public final int getMemSize() {
        return this.memSize;
    }

    public final int getMemMax() {
        return this.memMax;
    }

    public final int getUsedClassMemory() {
        return this.usedClassMemory;
    }

    public final void setUsedClassMemory(int n) {
        this.usedClassMemory = n;
    }

    public final boolean getTrace() {
        return this.trace;
    }

    public final void setTrace(boolean bl) {
        this.trace = bl;
    }

    public final long getInstructionsExecuted() {
        return this.instructionsExecuted;
    }

    public final void setInstructionsExecuted(long l) {
        this.instructionsExecuted = l;
    }

    @NotNull
    public final Buffer getMemory() {
        return this.memory;
    }

    public final void setMemory(@NotNull Buffer buffer) {
        this.memory = buffer;
    }

    public final int getMemoryNumPages() {
        return this.memory.getSizeInBytes() / 65536;
    }

    @NotNull
    public final List<WasmTable> getTables() {
        return this.tables;
    }

    @NotNull
    public final LinkedHashMap<String, LinkedHashMap<String, Function2<WasmRuntime, Object[], Object>>> getFunctions() {
        return this.functions;
    }

    @NotNull
    public Set<String> getExported() {
        Set<String> set = this.functions.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return set;
    }

    public void register(@NotNull String moduleName, @NotNull String name2, @NotNull Function2<? super WasmRuntime, ? super Object[], ? extends Object> func2) {
        Object object;
        Map $this$getOrPut$iv = this.functions;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(moduleName);
        if (value$iv == null) {
            boolean bl = false;
            LinkedHashMap answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(moduleName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        LinkedHashMap moduleFunctions = (LinkedHashMap)object;
        ((Map)moduleFunctions).put(name2, func2);
    }

    @Nullable
    public Object invoke(@NotNull String funcName, Object ... params) {
        throw new NotImplementedError(null, 1, null);
    }

    @Nullable
    public Object invokeIndirect(int index2, Object ... params) {
        throw new NotImplementedError(null, 1, null);
    }

    public final void writeBytes(int ptr, @NotNull byte[] data2) {
        BufferKt.setArrayInt8$default(this.memory, ptr, data2, 0, 0, 12, null);
    }

    @NotNull
    public final byte[] readBytes(int ptr, @NotNull byte[] out) {
        return BufferKt.getArrayInt8$default(this.memory, ptr, out, 0, 0, 12, null);
    }

    @NotNull
    public final byte[] readBytes(int ptr, int size2) {
        return this.readBytes(ptr, new byte[size2]);
    }

    public final int stackSave() {
        Object object = this.invoke("stackSave", new Object[0]);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    public final void stackRestore(int stack) {
        Object[] objectArray = new Object[]{stack};
        this.invoke("stackRestore", objectArray);
    }

    public final int stackAlloc(int size2) {
        Object[] objectArray = new Object[]{size2};
        Object object = this.invoke("stackAlloc", objectArray);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    public final int stackAllocAndWrite(@NotNull byte[] data2) {
        int n;
        int it = n = this.stackAlloc(data2.length);
        boolean bl = false;
        this.writeBytes(it, data2);
        return n;
    }

    public final int alloc(int size2) {
        Object[] objectArray = new Object[]{size2};
        Object object = this.invoke("malloc", objectArray);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    public final int allocAndWrite(@NotNull byte[] data2) {
        int n;
        int it = n = this.alloc(data2.length);
        boolean bl = false;
        this.writeBytes(it, data2);
        return n;
    }

    public final void free(int ptr) {
        Object[] objectArray = new Object[]{ptr};
        this.invoke("free", objectArray);
    }

    public final void free(int ... ptrs) {
        for (int ptr : ptrs) {
            this.free(ptr);
        }
    }

    public void close() {
    }

    public final int strlen(int ptr) {
        int n = 0;
        while (this.memory.getS8(ptr + n) != 0) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int strlen16(int ptr) {
        int n = 0;
        while (true) {
            void $this$getS16_u24default$iv;
            Buffer buffer = this.memory;
            int byteOffset$iv = ptr + n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS16 = false;
            if ($this$getS16_u24default$iv.getS16LE(byteOffset$iv) == 0) break;
            n += 2;
        }
        return n / 2;
    }

    @NotNull
    public final String readStringz(int ptr) {
        if (ptr == 0) {
            return "<null>";
        }
        return StringsKt.decodeToString(BufferKt.getArrayInt8$default(this.memory, ptr, new byte[this.strlen(ptr)], 0, 0, 12, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readStringz16(int ptr) {
        if (ptr == 0) {
            return "<null>";
        }
        Object out = "";
        int n = 0;
        while (true) {
            void $this$getS16_u24default$iv;
            Buffer buffer = this.memory;
            int byteOffset$iv = ptr + n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS16 = false;
            int v = $this$getS16_u24default$iv.getS16LE(byteOffset$iv) & 0xFFFF;
            if (v == 0) break;
            out = (String)out + (char)v;
            n += 2;
        }
        return out;
    }

    @NotNull
    public final String readString(int ptr) {
        return this.readStringz16(ptr);
    }

    @JvmStatic
    public static final int assert_return_any(@Nullable Object actual, @Nullable Object expect, @NotNull String msg) {
        return Companion.assert_return_any(actual, expect, msg);
    }

    @JvmStatic
    public static final int assert_return_void(@NotNull String msg) {
        return Companion.assert_return_void(msg);
    }

    @JvmStatic
    public static final int assert_return_ref(@Nullable Object actual, @Nullable Object expect, @NotNull String msg) {
        return Companion.assert_return_ref(actual, expect, msg);
    }

    @JvmStatic
    public static final int assert_return_i32(int actual, int expect, @NotNull String msg) {
        return Companion.assert_return_i32(actual, expect, msg);
    }

    @JvmStatic
    public static final int assert_return_i64(long actual, long expect, @NotNull String msg) {
        return Companion.assert_return_i64(actual, expect, msg);
    }

    @JvmStatic
    public static final int assert_return_f32(float actual, float expect, @NotNull String msg) {
        return Companion.assert_return_f32(actual, expect, msg);
    }

    @JvmStatic
    public static final int assert_return_f64(double actual, double expect, @NotNull String msg) {
        return Companion.assert_return_f64(actual, expect, msg);
    }

    @JvmStatic
    public static final void assert_summary(int failed, int total) {
        Companion.assert_summary(failed, total);
    }

    @JvmStatic
    public static final void set_memory(int ptr, @NotNull String data2, int bytesLen, @NotNull WasmRuntime runtime) {
        Companion.set_memory(ptr, data2, bytesLen, runtime);
    }

    @JvmStatic
    @NotNull
    public static final String read_string(int ptr, @NotNull WasmRuntime runtime) {
        return Companion.read_string(ptr, runtime);
    }

    @JvmStatic
    @NotNull
    public static final Throwable create_unreachable_exception_instance(@NotNull String msg) {
        return Companion.create_unreachable_exception_instance(msg);
    }

    @JvmStatic
    @NotNull
    public static final Throwable create_todo_exception_instance() {
        return Companion.create_todo_exception_instance();
    }

    @JvmStatic
    @NotNull
    public static final Throwable create_unknown_indirect_function(int index2, @NotNull String msg) {
        return Companion.create_unknown_indirect_function(index2, msg);
    }

    @JvmStatic
    @Nullable
    public static final Object call_indirect(int tableIndex, int index2, @NotNull Object[] args2, @NotNull WasmRuntime runtime) {
        return Companion.call_indirect(tableIndex, index2, args2, runtime);
    }

    @JvmStatic
    public static final int Op_i32_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i32_load(addr, offset2, runtime);
    }

    @JvmStatic
    public static final int Op_i32_load8_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i32_load8_s(addr, offset2, runtime);
    }

    @JvmStatic
    public static final int Op_i32_load8_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i32_load8_u(addr, offset2, runtime);
    }

    @JvmStatic
    public static final int Op_i32_load16_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i32_load16_s(addr, offset2, runtime);
    }

    @JvmStatic
    public static final int Op_i32_load16_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i32_load16_u(addr, offset2, runtime);
    }

    @JvmStatic
    public static final long Op_i64_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i64_load(addr, offset2, runtime);
    }

    @JvmStatic
    public static final long Op_i64_load8_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i64_load8_s(addr, offset2, runtime);
    }

    @JvmStatic
    public static final long Op_i64_load8_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i64_load8_u(addr, offset2, runtime);
    }

    @JvmStatic
    public static final long Op_i64_load16_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i64_load16_s(addr, offset2, runtime);
    }

    @JvmStatic
    public static final long Op_i64_load16_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i64_load16_u(addr, offset2, runtime);
    }

    @JvmStatic
    public static final long Op_i64_load32_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i64_load32_s(addr, offset2, runtime);
    }

    @JvmStatic
    public static final long Op_i64_load32_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_i64_load32_u(addr, offset2, runtime);
    }

    @JvmStatic
    public static final float Op_f32_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_f32_load(addr, offset2, runtime);
    }

    @JvmStatic
    public static final double Op_f64_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
        return Companion.Op_f64_load(addr, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_i32_store(int addr, int value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_i32_store(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_i32_store8(int addr, int value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_i32_store8(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_i32_store16(int addr, int value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_i32_store16(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_i64_store(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_i64_store(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_i64_store8(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_i64_store8(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_i64_store16(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_i64_store16(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_i64_store32(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_i64_store32(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_f32_store(int addr, float value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_f32_store(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final void Op_f64_store(int addr, double value, int offset2, @NotNull WasmRuntime runtime) {
        Companion.Op_f64_store(addr, value, offset2, runtime);
    }

    @JvmStatic
    public static final int Op_i32_eqz(int value) {
        return Companion.Op_i32_eqz(value);
    }

    @JvmStatic
    public static final int Op_i32_eq(int l, int r) {
        return Companion.Op_i32_eq(l, r);
    }

    @JvmStatic
    public static final int Op_i32_ne(int l, int r) {
        return Companion.Op_i32_ne(l, r);
    }

    @JvmStatic
    public static final int Op_i32_lt_s(int l, int r) {
        return Companion.Op_i32_lt_s(l, r);
    }

    @JvmStatic
    public static final int Op_i32_le_s(int l, int r) {
        return Companion.Op_i32_le_s(l, r);
    }

    @JvmStatic
    public static final int Op_i32_ge_s(int l, int r) {
        return Companion.Op_i32_ge_s(l, r);
    }

    @JvmStatic
    public static final int Op_i32_gt_s(int l, int r) {
        return Companion.Op_i32_gt_s(l, r);
    }

    @JvmStatic
    public static final int Op_i32_lt_u(int l, int r) {
        return Companion.Op_i32_lt_u(l, r);
    }

    @JvmStatic
    public static final int Op_i32_le_u(int l, int r) {
        return Companion.Op_i32_le_u(l, r);
    }

    @JvmStatic
    public static final int Op_i32_ge_u(int l, int r) {
        return Companion.Op_i32_ge_u(l, r);
    }

    @JvmStatic
    public static final int Op_i32_gt_u(int l, int r) {
        return Companion.Op_i32_gt_u(l, r);
    }

    @JvmStatic
    public static final int Op_i64_eqz(long value) {
        return Companion.Op_i64_eqz(value);
    }

    @JvmStatic
    public static final int Op_i64_eq(long l, long r) {
        return Companion.Op_i64_eq(l, r);
    }

    @JvmStatic
    public static final int Op_i64_ne(long l, long r) {
        return Companion.Op_i64_ne(l, r);
    }

    @JvmStatic
    public static final int Op_i64_lt_s(long l, long r) {
        return Companion.Op_i64_lt_s(l, r);
    }

    @JvmStatic
    public static final int Op_i64_le_s(long l, long r) {
        return Companion.Op_i64_le_s(l, r);
    }

    @JvmStatic
    public static final int Op_i64_ge_s(long l, long r) {
        return Companion.Op_i64_ge_s(l, r);
    }

    @JvmStatic
    public static final int Op_i64_gt_s(long l, long r) {
        return Companion.Op_i64_gt_s(l, r);
    }

    @JvmStatic
    public static final int Op_i64_lt_u(long l, long r) {
        return Companion.Op_i64_lt_u(l, r);
    }

    @JvmStatic
    public static final int Op_i64_le_u(long l, long r) {
        return Companion.Op_i64_le_u(l, r);
    }

    @JvmStatic
    public static final int Op_i64_ge_u(long l, long r) {
        return Companion.Op_i64_ge_u(l, r);
    }

    @JvmStatic
    public static final int Op_i64_gt_u(long l, long r) {
        return Companion.Op_i64_gt_u(l, r);
    }

    @JvmStatic
    public static final int Op_f32_le(float l, float r) {
        return Companion.Op_f32_le(l, r);
    }

    @JvmStatic
    public static final int Op_f32_lt(float l, float r) {
        return Companion.Op_f32_lt(l, r);
    }

    @JvmStatic
    public static final int Op_f32_eq(float l, float r) {
        return Companion.Op_f32_eq(l, r);
    }

    @JvmStatic
    public static final int Op_f32_ne(float l, float r) {
        return Companion.Op_f32_ne(l, r);
    }

    @JvmStatic
    public static final int Op_f32_gt(float l, float r) {
        return Companion.Op_f32_gt(l, r);
    }

    @JvmStatic
    public static final int Op_f32_ge(float l, float r) {
        return Companion.Op_f32_ge(l, r);
    }

    @JvmStatic
    public static final int Op_f64_le(double l, double r) {
        return Companion.Op_f64_le(l, r);
    }

    @JvmStatic
    public static final int Op_f64_lt(double l, double r) {
        return Companion.Op_f64_lt(l, r);
    }

    @JvmStatic
    public static final int Op_f64_eq(double l, double r) {
        return Companion.Op_f64_eq(l, r);
    }

    @JvmStatic
    public static final int Op_f64_ne(double l, double r) {
        return Companion.Op_f64_ne(l, r);
    }

    @JvmStatic
    public static final int Op_f64_gt(double l, double r) {
        return Companion.Op_f64_gt(l, r);
    }

    @JvmStatic
    public static final int Op_f64_ge(double l, double r) {
        return Companion.Op_f64_ge(l, r);
    }

    @JvmStatic
    public static final int Op_selectI(int l, int r, int v) {
        return Companion.Op_selectI(l, r, v);
    }

    @JvmStatic
    public static final long Op_selectL(long l, long r, int v) {
        return Companion.Op_selectL(l, r, v);
    }

    @JvmStatic
    public static final float Op_selectF(float l, float r, int v) {
        return Companion.Op_selectF(l, r, v);
    }

    @JvmStatic
    public static final double Op_selectD(double l, double r, int v) {
        return Companion.Op_selectD(l, r, v);
    }

    @JvmStatic
    public static final int Op_i32_div_u(int l, int r) {
        return Companion.Op_i32_div_u(l, r);
    }

    @JvmStatic
    public static final int Op_i32_rem_u(int l, int r) {
        return Companion.Op_i32_rem_u(l, r);
    }

    @JvmStatic
    public static final int Op_i32_clz(int v) {
        return Companion.Op_i32_clz(v);
    }

    @JvmStatic
    public static final int Op_i32_ctz(int v) {
        return Companion.Op_i32_ctz(v);
    }

    @JvmStatic
    public static final int Op_i32_popcnt(int v) {
        return Companion.Op_i32_popcnt(v);
    }

    @JvmStatic
    public static final long Op_i64_popcnt(long v) {
        return Companion.Op_i64_popcnt(v);
    }

    @JvmStatic
    public static final int Op_i32_rotl(int v, int bits) {
        return Companion.Op_i32_rotl(v, bits);
    }

    @JvmStatic
    public static final int Op_i32_rotr(int v, int bits) {
        return Companion.Op_i32_rotr(v, bits);
    }

    @JvmStatic
    public static final long Op_i64_div_u(long l, long r) {
        return Companion.Op_i64_div_u(l, r);
    }

    @JvmStatic
    public static final long Op_i64_rem_u(long l, long r) {
        return Companion.Op_i64_rem_u(l, r);
    }

    @JvmStatic
    public static final long Op_i64_clz(long v) {
        return Companion.Op_i64_clz(v);
    }

    @JvmStatic
    public static final long Op_i64_ctz(long v) {
        return Companion.Op_i64_ctz(v);
    }

    @JvmStatic
    public static final long Op_i64_rotl(long v, long bits) {
        return Companion.Op_i64_rotl(v, bits);
    }

    @JvmStatic
    public static final long Op_i64_rotr(long v, long bits) {
        return Companion.Op_i64_rotr(v, bits);
    }

    @JvmStatic
    public static final long Op_i64_extend8_s(long v) {
        return Companion.Op_i64_extend8_s(v);
    }

    @JvmStatic
    public static final long Op_i64_extend16_s(long v) {
        return Companion.Op_i64_extend16_s(v);
    }

    @JvmStatic
    public static final long Op_i64_extend32_s(long v) {
        return Companion.Op_i64_extend32_s(v);
    }

    @JvmStatic
    public static final long Op_i64_extend_i32_u(int v) {
        return Companion.Op_i64_extend_i32_u(v);
    }

    @JvmStatic
    public static final long Op_i64_extend_i32_s(int v) {
        return Companion.Op_i64_extend_i32_s(v);
    }

    @JvmStatic
    public static final int Op_i32_wrap_i64(long v) {
        return Companion.Op_i32_wrap_i64(v);
    }

    @JvmStatic
    public static final int Op_i32_extend8_s(int v) {
        return Companion.Op_i32_extend8_s(v);
    }

    @JvmStatic
    public static final int Op_i32_extend16_s(int v) {
        return Companion.Op_i32_extend16_s(v);
    }

    @JvmStatic
    public static final int Op_i32_reinterpret_f32(float v) {
        return Companion.Op_i32_reinterpret_f32(v);
    }

    @JvmStatic
    public static final float Op_f32_reinterpret_i32(int v) {
        return Companion.Op_f32_reinterpret_i32(v);
    }

    @JvmStatic
    public static final long Op_i64_reinterpret_f64(double v) {
        return Companion.Op_i64_reinterpret_f64(v);
    }

    @JvmStatic
    public static final double Op_f64_reinterpret_i64(long v) {
        return Companion.Op_f64_reinterpret_i64(v);
    }

    @JvmStatic
    public static final float Op_f32_convert_s_i32(int v) {
        return Companion.Op_f32_convert_s_i32(v);
    }

    @JvmStatic
    public static final float Op_f32_convert_u_i32(int v) {
        return Companion.Op_f32_convert_u_i32(v);
    }

    @JvmStatic
    public static final float Op_f32_convert_s_i64(long v) {
        return Companion.Op_f32_convert_s_i64(v);
    }

    @JvmStatic
    public static final float Op_f32_convert_u_i64(long v) {
        return Companion.Op_f32_convert_u_i64(v);
    }

    @JvmStatic
    public static final float Op_f32_demote_f64(double v) {
        return Companion.Op_f32_demote_f64(v);
    }

    @JvmStatic
    public static final double Op_f64_convert_s_i32(int v) {
        return Companion.Op_f64_convert_s_i32(v);
    }

    @JvmStatic
    public static final double Op_f64_convert_u_i32(int v) {
        return Companion.Op_f64_convert_u_i32(v);
    }

    @JvmStatic
    public static final double Op_f64_convert_s_i64(long v) {
        return Companion.Op_f64_convert_s_i64(v);
    }

    @JvmStatic
    public static final double Op_f64_convert_u_i64(long v) {
        return Companion.Op_f64_convert_u_i64(v);
    }

    @JvmStatic
    public static final double Op_f64_promote_f32(float v) {
        return Companion.Op_f64_promote_f32(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_u_f32(float v) {
        return Companion.Op_i32_trunc_u_f32(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_s_f32(float v) {
        return Companion.Op_i32_trunc_s_f32(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_u_f64(double v) {
        return Companion.Op_i32_trunc_u_f64(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_s_f64(double v) {
        return Companion.Op_i32_trunc_s_f64(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_sat_f32_u(float v) {
        return Companion.Op_i32_trunc_sat_f32_u(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_sat_f32_s(float v) {
        return Companion.Op_i32_trunc_sat_f32_s(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_sat_f64_u(double v) {
        return Companion.Op_i32_trunc_sat_f64_u(v);
    }

    @JvmStatic
    public static final int Op_i32_trunc_sat_f64_s(double v) {
        return Companion.Op_i32_trunc_sat_f64_s(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_u_f32(float v) {
        return Companion.Op_i64_trunc_u_f32(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_s_f32(float v) {
        return Companion.Op_i64_trunc_s_f32(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_u_f64(double v) {
        return Companion.Op_i64_trunc_u_f64(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_s_f64(double v) {
        return Companion.Op_i64_trunc_s_f64(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_sat_f32_u(float v) {
        return Companion.Op_i64_trunc_sat_f32_u(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_sat_f32_s(float v) {
        return Companion.Op_i64_trunc_sat_f32_s(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_sat_f64_u(double v) {
        return Companion.Op_i64_trunc_sat_f64_u(v);
    }

    @JvmStatic
    public static final long Op_i64_trunc_sat_f64_s(double v) {
        return Companion.Op_i64_trunc_sat_f64_s(v);
    }

    @JvmStatic
    public static final float Op_f32_min(float l, float r) {
        return Companion.Op_f32_min(l, r);
    }

    @JvmStatic
    public static final float Op_f32_max(float l, float r) {
        return Companion.Op_f32_max(l, r);
    }

    @JvmStatic
    public static final float Op_f32_copysign(float magnitude, float sign) {
        return Companion.Op_f32_copysign(magnitude, sign);
    }

    @JvmStatic
    public static final float Op_f32_abs(float v) {
        return Companion.Op_f32_abs(v);
    }

    @JvmStatic
    public static final float Op_f32_sqrt(float v) {
        return Companion.Op_f32_sqrt(v);
    }

    @JvmStatic
    public static final float Op_f32_neg(float v) {
        return Companion.Op_f32_neg(v);
    }

    @JvmStatic
    public static final float Op_f32_ceil(float v) {
        return Companion.Op_f32_ceil(v);
    }

    @JvmStatic
    public static final float Op_f32_floor(float v) {
        return Companion.Op_f32_floor(v);
    }

    @JvmStatic
    public static final float Op_f32_trunc(float v) {
        return Companion.Op_f32_trunc(v);
    }

    @JvmStatic
    public static final float Op_f32_nearest(float v) {
        return Companion.Op_f32_nearest(v);
    }

    @JvmStatic
    public static final double Op_f64_min(double l, double r) {
        return Companion.Op_f64_min(l, r);
    }

    @JvmStatic
    public static final double Op_f64_max(double l, double r) {
        return Companion.Op_f64_max(l, r);
    }

    @JvmStatic
    public static final double Op_f64_copysign(double magnitude, double sign) {
        return Companion.Op_f64_copysign(magnitude, sign);
    }

    @JvmStatic
    public static final double Op_f64_abs(double v) {
        return Companion.Op_f64_abs(v);
    }

    @JvmStatic
    public static final double Op_f64_sqrt(double v) {
        return Companion.Op_f64_sqrt(v);
    }

    @JvmStatic
    public static final double Op_f64_neg(double v) {
        return Companion.Op_f64_neg(v);
    }

    @JvmStatic
    public static final double Op_f64_ceil(double v) {
        return Companion.Op_f64_ceil(v);
    }

    @JvmStatic
    public static final double Op_f64_floor(double v) {
        return Companion.Op_f64_floor(v);
    }

    @JvmStatic
    public static final double Op_f64_trunc(double v) {
        return Companion.Op_f64_trunc(v);
    }

    @JvmStatic
    public static final double Op_f64_nearest(double v) {
        return Companion.Op_f64_nearest(v);
    }

    @JvmStatic
    public static final void Op_memory_init(@NotNull WasmRuntime runtime) {
        Companion.Op_memory_init(runtime);
    }

    @JvmStatic
    public static final int Op_memory_size(@NotNull WasmRuntime runtime) {
        return Companion.Op_memory_size(runtime);
    }

    @JvmStatic
    public static final int Op_memory_grow(int deltaPages, @NotNull WasmRuntime runtime) {
        return Companion.Op_memory_grow(deltaPages, runtime);
    }

    @JvmStatic
    public static final void Op_memory_copy(int dst, int src, int count2, @NotNull WasmRuntime runtime) {
        Companion.Op_memory_copy(dst, src, count2, runtime);
    }

    @JvmStatic
    public static final void Op_memory_fill(int dst, int value, int count2, @NotNull WasmRuntime runtime) {
        Companion.Op_memory_fill(dst, value, count2, runtime);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b}\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J(\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u00100\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0018\u00101\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012H\u0007J\u0018\u00102\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u0010\u00103\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0018\u00104\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u0018\u00105\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u0018\u00106\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J \u00107\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0018\u00108\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u0018\u00109\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u0018\u0010:\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u0018\u0010;\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010=\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010>\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010@\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J(\u0010A\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010C\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010D\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010E\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010F\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0007J\u0010\u0010H\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010I\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010J\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010K\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010L\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010M\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010N\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010O\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J \u0010P\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010Q\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010R\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010S\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010T\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0018\u0010U\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010V\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010W\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0010\u0010X\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010Y\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010Z\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010[\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u0004H\u0007J\u0018\u0010]\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u0004H\u0007J(\u0010^\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J(\u0010_\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J(\u0010`\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010a\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010c\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010g\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010h\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0010\u0010i\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010j\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010k\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0018\u0010l\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0018\u0010m\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0010\u0010n\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000bH\u0007J\u0010\u0010o\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010p\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010q\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0010\u0010r\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010s\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010t\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0018\u0010u\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0018\u0010v\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0018\u0010w\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0018\u0010x\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0018\u0010y\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J \u0010z\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010{\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010|\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010}\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010~\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J \u0010\u007f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J!\u0010\u0080\u0001\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0019\u0010\u0081\u0001\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0019\u0010\u0082\u0001\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0019\u0010\u0083\u0001\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0011\u0010\u0084\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u0011\u0010\u0085\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0019\u0010\u0086\u0001\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J\u0019\u0010\u0087\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\\\u001a\u00020\u000bH\u0007J\u0019\u0010\u0088\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\\\u001a\u00020\u000bH\u0007J)\u0010\u0089\u0001\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J)\u0010\u008a\u0001\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J)\u0010\u008b\u0001\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J)\u0010\u008c\u0001\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0011\u0010\u008d\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0011\u0010\u008e\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0011\u0010\u008f\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0011\u0010\u0090\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0011\u0010\u0091\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0011\u0010\u0092\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J\u0011\u0010\u0093\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0011\u0010\u0094\u0001\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0012H\u0007J,\u0010\u0095\u0001\u001a\u00020(2\u0007\u0010\u0096\u0001\u001a\u00020\u00042\u0007\u0010\u0097\u0001\u001a\u00020\u00042\u0007\u0010\u0098\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J+\u0010\u0099\u0001\u001a\u00020(2\u0007\u0010\u0096\u0001\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0007\u0010\u0098\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u001a\u0010\u009a\u0001\u001a\u00020\u00042\u0007\u0010\u009b\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0011\u0010\u009c\u0001\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0011\u0010\u009d\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J!\u0010\u009e\u0001\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J!\u0010\u009f\u0001\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J!\u0010\u00a0\u0001\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J!\u0010\u00a1\u0001\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J)\u0010\u00a2\u0001\u001a\u00020\u00042\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u00012\t\u0010\u00a4\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J%\u0010\u00a7\u0001\u001a\u00020\u00042\u0007\u0010\u00a3\u0001\u001a\u00020\u00062\u0007\u0010\u00a4\u0001\u001a\u00020\u00062\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J%\u0010\u00a8\u0001\u001a\u00020\u00042\u0007\u0010\u00a3\u0001\u001a\u00020\u00122\u0007\u0010\u00a4\u0001\u001a\u00020\u00122\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J%\u0010\u00a9\u0001\u001a\u00020\u00042\u0007\u0010\u00a3\u0001\u001a\u00020\u00042\u0007\u0010\u00a4\u0001\u001a\u00020\u00042\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J%\u0010\u00aa\u0001\u001a\u00020\u00042\u0007\u0010\u00a3\u0001\u001a\u00020\u000b2\u0007\u0010\u00a4\u0001\u001a\u00020\u000b2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J)\u0010\u00ab\u0001\u001a\u00020\u00042\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u00012\t\u0010\u00a4\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J\u0013\u0010\u00ac\u0001\u001a\u00020\u00042\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J\u001b\u0010\u00ad\u0001\u001a\u00020(2\u0007\u0010\u00ae\u0001\u001a\u00020\u00042\u0007\u0010\u00af\u0001\u001a\u00020\u0004H\u0007J=\u0010\u00b0\u0001\u001a\u0004\u0018\u00010\u00012\u0007\u0010\u00b1\u0001\u001a\u00020\u00042\u0007\u0010\u00b2\u0001\u001a\u00020\u00042\u0010\u0010\u00b3\u0001\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00b4\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0007\u00a2\u0006\u0003\u0010\u00b5\u0001J\"\u0010\u00b6\u0001\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\bJ\n\u0010\u00b7\u0001\u001a\u00030\u00b8\u0001H\u0007J\u001d\u0010\u00b9\u0001\u001a\u00030\u00b8\u00012\u0007\u0010\u00b2\u0001\u001a\u00020\u00042\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J\u0014\u0010\u00ba\u0001\u001a\u00030\u00b8\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0007J\u001b\u0010\u00bb\u0001\u001a\u00030\u00a6\u00012\u0007\u0010\u00bc\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J-\u0010\u00bd\u0001\u001a\u00020(2\u0007\u0010\u00bc\u0001\u001a\u00020\u00042\b\u0010\u00be\u0001\u001a\u00030\u00a6\u00012\u0007\u0010\u00bf\u0001\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c0\u0001"}, d2={"Lkorlibs/wasm/WasmRuntime$Companion;", "", "()V", "PAGE_SIZE", "", "Op_f32_abs", "", "v", "Op_f32_ceil", "Op_f32_convert_s_i32", "Op_f32_convert_s_i64", "", "Op_f32_convert_u_i32", "Op_f32_convert_u_i64", "Op_f32_copysign", "magnitude", "sign", "Op_f32_demote_f64", "", "Op_f32_eq", "l", "r", "Op_f32_floor", "Op_f32_ge", "Op_f32_gt", "Op_f32_le", "Op_f32_load", "addr", "offset", "runtime", "Lkorlibs/wasm/WasmRuntime;", "Op_f32_lt", "Op_f32_max", "Op_f32_min", "Op_f32_ne", "Op_f32_nearest", "Op_f32_neg", "Op_f32_reinterpret_i32", "Op_f32_sqrt", "Op_f32_store", "", "value", "Op_f32_trunc", "Op_f64_abs", "Op_f64_ceil", "Op_f64_convert_s_i32", "Op_f64_convert_s_i64", "Op_f64_convert_u_i32", "Op_f64_convert_u_i64", "Op_f64_copysign", "Op_f64_eq", "Op_f64_floor", "Op_f64_ge", "Op_f64_gt", "Op_f64_le", "Op_f64_load", "Op_f64_lt", "Op_f64_max", "Op_f64_min", "Op_f64_ne", "Op_f64_nearest", "Op_f64_neg", "Op_f64_promote_f32", "Op_f64_reinterpret_i64", "Op_f64_sqrt", "Op_f64_store", "Op_f64_trunc", "Op_i32_clz", "Op_i32_ctz", "Op_i32_div_u", "Op_i32_eq", "Op_i32_eqz", "Op_i32_extend16_s", "Op_i32_extend8_s", "Op_i32_ge_s", "Op_i32_ge_u", "Op_i32_gt_s", "Op_i32_gt_u", "Op_i32_le_s", "Op_i32_le_u", "Op_i32_load", "Op_i32_load16_s", "Op_i32_load16_u", "Op_i32_load8_s", "Op_i32_load8_u", "Op_i32_lt_s", "Op_i32_lt_u", "Op_i32_ne", "Op_i32_popcnt", "Op_i32_reinterpret_f32", "Op_i32_rem_u", "Op_i32_rotl", "bits", "Op_i32_rotr", "Op_i32_store", "Op_i32_store16", "Op_i32_store8", "Op_i32_trunc_s_f32", "Op_i32_trunc_s_f64", "Op_i32_trunc_sat_f32_s", "Op_i32_trunc_sat_f32_u", "Op_i32_trunc_sat_f64_s", "Op_i32_trunc_sat_f64_u", "Op_i32_trunc_u_f32", "Op_i32_trunc_u_f64", "Op_i32_wrap_i64", "Op_i64_clz", "Op_i64_ctz", "Op_i64_div_u", "Op_i64_eq", "Op_i64_eqz", "Op_i64_extend16_s", "Op_i64_extend32_s", "Op_i64_extend8_s", "Op_i64_extend_i32_s", "Op_i64_extend_i32_u", "Op_i64_ge_s", "Op_i64_ge_u", "Op_i64_gt_s", "Op_i64_gt_u", "Op_i64_le_s", "Op_i64_le_u", "Op_i64_load", "Op_i64_load16_s", "Op_i64_load16_u", "Op_i64_load32_s", "Op_i64_load32_u", "Op_i64_load8_s", "Op_i64_load8_u", "Op_i64_lt_s", "Op_i64_lt_u", "Op_i64_ne", "Op_i64_popcnt", "Op_i64_reinterpret_f64", "Op_i64_rem_u", "Op_i64_rotl", "Op_i64_rotr", "Op_i64_store", "Op_i64_store16", "Op_i64_store32", "Op_i64_store8", "Op_i64_trunc_s_f32", "Op_i64_trunc_s_f64", "Op_i64_trunc_sat_f32_s", "Op_i64_trunc_sat_f32_u", "Op_i64_trunc_sat_f64_s", "Op_i64_trunc_sat_f64_u", "Op_i64_trunc_u_f32", "Op_i64_trunc_u_f64", "Op_memory_copy", "dst", "src", "count", "Op_memory_fill", "Op_memory_grow", "deltaPages", "Op_memory_init", "Op_memory_size", "Op_selectD", "Op_selectF", "Op_selectI", "Op_selectL", "assert_return_any", "actual", "expect", "msg", "", "assert_return_f32", "assert_return_f64", "assert_return_i32", "assert_return_i64", "assert_return_ref", "assert_return_void", "assert_summary", "failed", "total", "call_indirect", "tableIndex", "index", "args", "", "(II[Ljava/lang/Object;Lkorlibs/wasm/WasmRuntime;)Ljava/lang/Object;", "checkAddr", "create_todo_exception_instance", "", "create_unknown_indirect_function", "create_unreachable_exception_instance", "read_string", "ptr", "set_memory", "data", "bytesLen", "korge-core"})
    @SourceDebugExtension(value={"SMAP\nWasmRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmRuntime.kt\nkorlibs/wasm/WasmRuntime$Companion\n+ 2 Buffer.kt\nkorlibs/memory/BufferKt\n+ 3 BooleanConversion.kt\nkorlibs/math/BooleanConversionKt\n*L\n1#1,354:1\n169#1,3:355\n169#1,3:359\n169#1,3:362\n169#1,3:365\n169#1,3:369\n169#1,3:373\n169#1,3:377\n169#1,3:380\n169#1,3:383\n169#1,3:387\n169#1,3:391\n169#1,3:395\n169#1,3:399\n169#1,3:403\n169#1,3:407\n169#1,3:411\n169#1,3:414\n169#1,3:418\n169#1,3:422\n169#1,3:425\n169#1,3:429\n169#1,3:433\n169#1,3:437\n192#2:358\n191#2:368\n188#2:372\n193#2:376\n191#2:386\n188#2:390\n192#2:394\n192#2:398\n194#2:402\n195#2:406\n198#2:410\n197#2:417\n199#2:421\n197#2:428\n198#2:432\n200#2:436\n201#2:440\n7#3:441\n7#3:442\n7#3:443\n7#3:444\n7#3:445\n7#3:446\n7#3:447\n7#3:448\n7#3:449\n7#3:450\n7#3:451\n7#3:452\n7#3:453\n7#3:454\n7#3:455\n7#3:456\n7#3:457\n7#3:458\n7#3:459\n7#3:460\n7#3:461\n7#3:462\n7#3:463\n7#3:464\n7#3:465\n7#3:466\n7#3:467\n7#3:468\n7#3:469\n7#3:470\n7#3:471\n7#3:472\n7#3:473\n7#3:474\n*S KotlinDebug\n*F\n+ 1 WasmRuntime.kt\nkorlibs/wasm/WasmRuntime$Companion\n*L\n174#1:355,3\n175#1:359,3\n176#1:362,3\n177#1:365,3\n178#1:369,3\n179#1:373,3\n180#1:377,3\n181#1:380,3\n182#1:383,3\n183#1:387,3\n184#1:391,3\n185#1:395,3\n186#1:399,3\n187#1:403,3\n188#1:407,3\n189#1:411,3\n190#1:414,3\n191#1:418,3\n192#1:422,3\n193#1:425,3\n194#1:429,3\n195#1:433,3\n196#1:437,3\n174#1:358\n177#1:368\n178#1:372\n179#1:376\n182#1:386\n183#1:390\n184#1:394\n185#1:398\n186#1:402\n187#1:406\n188#1:410\n190#1:417\n191#1:421\n193#1:428\n194#1:432\n195#1:436\n196#1:440\n197#1:441\n198#1:442\n199#1:443\n200#1:444\n201#1:445\n202#1:446\n203#1:447\n204#1:448\n205#1:449\n206#1:450\n207#1:451\n208#1:452\n209#1:453\n210#1:454\n211#1:455\n212#1:456\n213#1:457\n214#1:458\n215#1:459\n216#1:460\n217#1:461\n218#1:462\n219#1:463\n220#1:464\n221#1:465\n222#1:466\n223#1:467\n224#1:468\n225#1:469\n226#1:470\n227#1:471\n228#1:472\n229#1:473\n230#1:474\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int assert_return_any(@Nullable Object actual, @Nullable Object expect, @NotNull String msg) {
            boolean result2 = Intrinsics.areEqual(actual, expect);
            String resultStr = result2 ? "ok" : "error (" + actual + " != " + expect + ")";
            String line2 = msg + "... " + resultStr;
            if (!result2) {
                System.out.println((Object)(result2 ? AnsiEscape.Companion.getGreen(line2) : AnsiEscape.Companion.getRed(line2)));
            }
            return result2 ? 0 : 1;
        }

        @JvmStatic
        public final int assert_return_void(@NotNull String msg) {
            return 0;
        }

        @JvmStatic
        public final int assert_return_ref(@Nullable Object actual, @Nullable Object expect, @NotNull String msg) {
            return this.assert_return_any(actual, expect, msg);
        }

        @JvmStatic
        public final int assert_return_i32(int actual, int expect, @NotNull String msg) {
            return this.assert_return_any(actual, expect, msg);
        }

        @JvmStatic
        public final int assert_return_i64(long actual, long expect, @NotNull String msg) {
            return this.assert_return_any(actual, expect, msg);
        }

        @JvmStatic
        public final int assert_return_f32(float actual, float expect, @NotNull String msg) {
            return this.assert_return_any(Float.valueOf(actual), Float.valueOf(expect), msg);
        }

        @JvmStatic
        public final int assert_return_f64(double actual, double expect, @NotNull String msg) {
            return this.assert_return_any(actual, expect, msg);
        }

        @JvmStatic
        public final void assert_summary(int failed, int total) {
            if (failed != 0) {
                System.out.println((Object)AnsiEscape.Companion.getRed("SUMMARY: " + failed + "/" + total));
                throw new IllegalStateException("Some assets failed!".toString());
            }
        }

        @JvmStatic
        public final void set_memory(int ptr, @NotNull String data2, int bytesLen, @NotNull WasmRuntime runtime) {
            int ptr2 = ptr;
            Buffer mem = runtime.getMemory();
            boolean isOdd = bytesLen % 2 != 0;
            int n = data2.length();
            for (int n2 = 0; n2 < n; ++n2) {
                char c = data2.charAt(n2);
                if (isOdd && n2 == data2.length() - 1) {
                    BufferKt.setUnalignedUInt8(mem, ptr2, c);
                    ++ptr2;
                    continue;
                }
                BufferKt.setUnalignedUInt16(mem, ptr2, c);
                ptr2 += 2;
            }
        }

        @JvmStatic
        @NotNull
        public final String read_string(int ptr, @NotNull WasmRuntime runtime) {
            int v;
            if (ptr == 0) {
                return "<null>";
            }
            Object out = "";
            int n = 0;
            while ((v = BufferKt.getUnalignedUInt16(runtime.getMemory(), ptr + n)) != 0) {
                out = (String)out + (char)v;
                n += 2;
            }
            return out;
        }

        @JvmStatic
        @NotNull
        public final Throwable create_unreachable_exception_instance(@NotNull String msg) {
            return new Exception("unreachable:" + msg);
        }

        @JvmStatic
        @NotNull
        public final Throwable create_todo_exception_instance() {
            return new NotImplementedError(null, 1, null);
        }

        @JvmStatic
        @NotNull
        public final Throwable create_unknown_indirect_function(int index2, @NotNull String msg) {
            return new Exception("Unknown indirect function at index " + index2 + ", msg='" + msg + "'");
        }

        @JvmStatic
        @Nullable
        public final Object call_indirect(int tableIndex, int index2, @NotNull Object[] args2, @NotNull WasmRuntime runtime) {
            WasmFuncCall wasmFuncCall = runtime.getTables().get(tableIndex).getElements()[index2];
            if (wasmFuncCall == null) {
                throw new IllegalStateException(("call_indirect: tableIndex=" + tableIndex + ", func=" + index2 + ", args=" + kotlin.collections.ArraysKt.toList(args2)).toString());
            }
            WasmFuncCall func2 = wasmFuncCall;
            return func2.invoke(runtime, args2);
        }

        public final int checkAddr(int addr, int offset2, @NotNull WasmRuntime runtime) {
            int n;
            boolean $i$f$checkAddr = false;
            int it = n = addr + offset2;
            boolean bl = false;
            if (it < 0 || it >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final int Op_i32_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getS32_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS32 = false;
            return $this$getS32_u24default$iv.getS32LE((int)byteOffset$iv);
        }

        @JvmStatic
        public final int Op_i32_load8_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
            int n;
            Companion this_$iv = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            return runtime.getMemory().getS8(n);
        }

        @JvmStatic
        public final int Op_i32_load8_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
            int n;
            Companion this_$iv = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            return BufferKt.getU8(runtime.getMemory(), n);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final int Op_i32_load16_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getS16_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS16 = false;
            return $this$getS16_u24default$iv.getS16LE((int)byteOffset$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final int Op_i32_load16_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getU16_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getU16 = false;
            return BufferKt.getU16LE((Buffer)$this$getU16_u24default$iv, (int)byteOffset$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final long Op_i64_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getS64_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS64 = false;
            return $this$getS64_u24default$iv.getS64LE((int)byteOffset$iv);
        }

        @JvmStatic
        public final long Op_i64_load8_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
            int n;
            Companion this_$iv = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            return runtime.getMemory().getS8(n);
        }

        @JvmStatic
        public final long Op_i64_load8_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
            int n;
            Companion this_$iv = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            return BufferKt.getU8(runtime.getMemory(), n);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final long Op_i64_load16_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getS16_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS16 = false;
            return $this$getS16_u24default$iv.getS16LE((int)byteOffset$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final long Op_i64_load16_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getU16_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getU16 = false;
            return BufferKt.getU16LE((Buffer)$this$getU16_u24default$iv, (int)byteOffset$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final long Op_i64_load32_s(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getS32_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS32 = false;
            return $this$getS32_u24default$iv.getS32LE((int)byteOffset$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final long Op_i64_load32_u(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getS32_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getS32 = false;
            return (long)UInt.constructor-impl($this$getS32_u24default$iv.getS32LE((int)byteOffset$iv)) & 0xFFFFFFFFL;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final float Op_f32_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getF32_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getF32 = false;
            return $this$getF32_u24default$iv.getF32LE((int)byteOffset$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final double Op_f64_load(int addr, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$getF64_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$getF64 = false;
            return $this$getF64_u24default$iv.getF64LE((int)byteOffset$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void Op_i32_store(int addr, int value, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$set32_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$set32 = false;
            $this$set32_u24default$iv.set32LE((int)byteOffset$iv, value);
        }

        @JvmStatic
        public final void Op_i32_store8(int addr, int value, int offset2, @NotNull WasmRuntime runtime) {
            int n;
            Companion this_$iv = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            runtime.getMemory().set8(n, (byte)value);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void Op_i32_store16(int addr, int value, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$set16_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            short value$iv = (short)value;
            boolean littleEndian$iv = true;
            boolean $i$f$set16 = false;
            $this$set16_u24default$iv.set16LE((int)byteOffset$iv, value$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void Op_i64_store(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$set64_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$set64 = false;
            $this$set64_u24default$iv.set64LE((int)byteOffset$iv, value);
        }

        @JvmStatic
        public final void Op_i64_store8(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
            int n;
            Companion this_$iv = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            runtime.getMemory().set8(n, (byte)value);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void Op_i64_store16(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$set16_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            short value$iv = (short)value;
            boolean littleEndian$iv = true;
            boolean $i$f$set16 = false;
            $this$set16_u24default$iv.set16LE((int)byteOffset$iv, value$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void Op_i64_store32(int addr, long value, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$set32_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            int value$iv = (int)value;
            boolean littleEndian$iv = true;
            boolean $i$f$set32 = false;
            $this$set32_u24default$iv.set32LE((int)byteOffset$iv, value$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void Op_f32_store(int addr, float value, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$setF32_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$setF32 = false;
            $this$setF32_u24default$iv.setF32LE((int)byteOffset$iv, value);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void Op_f64_store(int addr, double value, int offset2, @NotNull WasmRuntime runtime) {
            void byteOffset$iv;
            void $this$setF64_u24default$iv;
            int n;
            Buffer buffer = runtime.getMemory();
            Companion this_$iv22 = this;
            boolean $i$f$checkAddr = false;
            int it$iv = n = addr + offset2;
            boolean bl = false;
            if (it$iv < 0 || it$iv >= runtime.getMemory().getSizeInBytes()) {
                throw new IllegalStateException(("Out of bounds addr=" + addr + ", offset=" + offset2 + ", memorySize=" + runtime.getMemory().getSizeInBytes()).toString());
            }
            int this_$iv22 = n;
            boolean littleEndian$iv = true;
            boolean $i$f$setF64 = false;
            $this$setF64_u24default$iv.setF64LE((int)byteOffset$iv, value);
        }

        @JvmStatic
        public final int Op_i32_eqz(int value) {
            boolean $this$toInt$iv = value == 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_eq(int l, int r) {
            boolean $this$toInt$iv = l == r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_ne(int l, int r) {
            boolean $this$toInt$iv = l != r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_lt_s(int l, int r) {
            boolean $this$toInt$iv = l < r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_le_s(int l, int r) {
            boolean $this$toInt$iv = l <= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_ge_s(int l, int r) {
            boolean $this$toInt$iv = l >= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_gt_s(int l, int r) {
            boolean $this$toInt$iv = l > r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_lt_u(int l, int r) {
            boolean $this$toInt$iv = Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) < 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_le_u(int l, int r) {
            boolean $this$toInt$iv = Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) <= 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_ge_u(int l, int r) {
            boolean $this$toInt$iv = Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) >= 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i32_gt_u(int l, int r) {
            boolean $this$toInt$iv = Integer.compareUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r)) > 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_eqz(long value) {
            boolean $this$toInt$iv = value == 0L;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_eq(long l, long r) {
            boolean $this$toInt$iv = l == r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_ne(long l, long r) {
            boolean $this$toInt$iv = l != r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_lt_s(long l, long r) {
            boolean $this$toInt$iv = l < r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_le_s(long l, long r) {
            boolean $this$toInt$iv = l <= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_ge_s(long l, long r) {
            boolean $this$toInt$iv = l >= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_gt_s(long l, long r) {
            boolean $this$toInt$iv = l > r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_lt_u(long l, long r) {
            boolean $this$toInt$iv = Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) < 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_le_u(long l, long r) {
            boolean $this$toInt$iv = Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) <= 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_ge_u(long l, long r) {
            boolean $this$toInt$iv = Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) >= 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_i64_gt_u(long l, long r) {
            boolean $this$toInt$iv = Long.compareUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r)) > 0;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f32_le(float l, float r) {
            boolean $this$toInt$iv = l <= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f32_lt(float l, float r) {
            boolean $this$toInt$iv = l < r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f32_eq(float l, float r) {
            boolean $this$toInt$iv = l == r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f32_ne(float l, float r) {
            boolean $this$toInt$iv = !(l == r);
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f32_gt(float l, float r) {
            boolean $this$toInt$iv = l > r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f32_ge(float l, float r) {
            boolean $this$toInt$iv = l >= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f64_le(double l, double r) {
            boolean $this$toInt$iv = l <= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f64_lt(double l, double r) {
            boolean $this$toInt$iv = l < r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f64_eq(double l, double r) {
            boolean $this$toInt$iv = l == r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f64_ne(double l, double r) {
            boolean $this$toInt$iv = !(l == r);
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f64_gt(double l, double r) {
            boolean $this$toInt$iv = l > r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_f64_ge(double l, double r) {
            boolean $this$toInt$iv = l >= r;
            boolean $i$f$toInt = false;
            return $this$toInt$iv ? 1 : 0;
        }

        @JvmStatic
        public final int Op_selectI(int l, int r, int v) {
            return v != 0 ? l : r;
        }

        @JvmStatic
        public final long Op_selectL(long l, long r, int v) {
            return v != 0 ? l : r;
        }

        @JvmStatic
        public final float Op_selectF(float l, float r, int v) {
            return v != 0 ? l : r;
        }

        @JvmStatic
        public final double Op_selectD(double l, double r, int v) {
            return v != 0 ? l : r;
        }

        @JvmStatic
        public final int Op_i32_div_u(int l, int r) {
            return Integer.divideUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r));
        }

        @JvmStatic
        public final int Op_i32_rem_u(int l, int r) {
            return Integer.remainderUnsigned(UInt.constructor-impl(l), UInt.constructor-impl(r));
        }

        @JvmStatic
        public final int Op_i32_clz(int v) {
            return Integer.numberOfLeadingZeros(v);
        }

        @JvmStatic
        public final int Op_i32_ctz(int v) {
            return Integer.numberOfTrailingZeros(v);
        }

        @JvmStatic
        public final int Op_i32_popcnt(int v) {
            return Integer.bitCount(v);
        }

        @JvmStatic
        public final long Op_i64_popcnt(long v) {
            return Long.bitCount(v);
        }

        @JvmStatic
        public final int Op_i32_rotl(int v, int bits) {
            return Integer.rotateLeft(v, bits);
        }

        @JvmStatic
        public final int Op_i32_rotr(int v, int bits) {
            return Integer.rotateRight(v, bits);
        }

        @JvmStatic
        public final long Op_i64_div_u(long l, long r) {
            return Long.divideUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r));
        }

        @JvmStatic
        public final long Op_i64_rem_u(long l, long r) {
            return Long.remainderUnsigned(ULong.constructor-impl(l), ULong.constructor-impl(r));
        }

        @JvmStatic
        public final long Op_i64_clz(long v) {
            return Long.numberOfLeadingZeros(v);
        }

        @JvmStatic
        public final long Op_i64_ctz(long v) {
            return Long.numberOfTrailingZeros(v);
        }

        @JvmStatic
        public final long Op_i64_rotl(long v, long bits) {
            return Long.rotateLeft(v, (int)bits);
        }

        @JvmStatic
        public final long Op_i64_rotr(long v, long bits) {
            return Long.rotateRight(v, (int)bits);
        }

        @JvmStatic
        public final long Op_i64_extend8_s(long v) {
            return (byte)v;
        }

        @JvmStatic
        public final long Op_i64_extend16_s(long v) {
            return (short)v;
        }

        @JvmStatic
        public final long Op_i64_extend32_s(long v) {
            return (int)v;
        }

        @JvmStatic
        public final long Op_i64_extend_i32_u(int v) {
            return (long)UInt.constructor-impl(v) & 0xFFFFFFFFL;
        }

        @JvmStatic
        public final long Op_i64_extend_i32_s(int v) {
            return v;
        }

        @JvmStatic
        public final int Op_i32_wrap_i64(long v) {
            return (int)v;
        }

        @JvmStatic
        public final int Op_i32_extend8_s(int v) {
            return (byte)v;
        }

        @JvmStatic
        public final int Op_i32_extend16_s(int v) {
            return (short)v;
        }

        @JvmStatic
        public final int Op_i32_reinterpret_f32(float v) {
            return Float.floatToRawIntBits(v);
        }

        @JvmStatic
        public final float Op_f32_reinterpret_i32(int v) {
            return Float.intBitsToFloat(v);
        }

        @JvmStatic
        public final long Op_i64_reinterpret_f64(double v) {
            return Double.doubleToRawLongBits(v);
        }

        @JvmStatic
        public final double Op_f64_reinterpret_i64(long v) {
            return Double.longBitsToDouble(v);
        }

        @JvmStatic
        public final float Op_f32_convert_s_i32(int v) {
            return v;
        }

        @JvmStatic
        public final float Op_f32_convert_u_i32(int v) {
            return (float)UnsignedKt.uintToDouble(UInt.constructor-impl(v));
        }

        @JvmStatic
        public final float Op_f32_convert_s_i64(long v) {
            return v;
        }

        @JvmStatic
        public final float Op_f32_convert_u_i64(long v) {
            return (float)UnsignedKt.ulongToDouble(ULong.constructor-impl(v));
        }

        @JvmStatic
        public final float Op_f32_demote_f64(double v) {
            return (float)v;
        }

        @JvmStatic
        public final double Op_f64_convert_s_i32(int v) {
            return v;
        }

        @JvmStatic
        public final double Op_f64_convert_u_i32(int v) {
            return UnsignedKt.uintToDouble(UInt.constructor-impl(v));
        }

        @JvmStatic
        public final double Op_f64_convert_s_i64(long v) {
            return v;
        }

        @JvmStatic
        public final double Op_f64_convert_u_i64(long v) {
            return UnsignedKt.ulongToDouble(ULong.constructor-impl(v));
        }

        @JvmStatic
        public final double Op_f64_promote_f32(float v) {
            return v;
        }

        @JvmStatic
        public final int Op_i32_trunc_u_f32(float v) {
            return UnsignedKt.doubleToUInt(v);
        }

        @JvmStatic
        public final int Op_i32_trunc_s_f32(float v) {
            return (int)v;
        }

        @JvmStatic
        public final int Op_i32_trunc_u_f64(double v) {
            return UnsignedKt.doubleToUInt(v);
        }

        @JvmStatic
        public final int Op_i32_trunc_s_f64(double v) {
            return (int)v;
        }

        @JvmStatic
        public final int Op_i32_trunc_sat_f32_u(float v) {
            return UnsignedKt.doubleToUInt(RangesKt.coerceIn(v, (float)UnsignedKt.uintToDouble(0), (float)UnsignedKt.uintToDouble(-1)));
        }

        @JvmStatic
        public final int Op_i32_trunc_sat_f32_s(float v) {
            return (int)RangesKt.coerceIn(v, -2.1474836E9f, 2.1474836E9f);
        }

        @JvmStatic
        public final int Op_i32_trunc_sat_f64_u(double v) {
            return UnsignedKt.doubleToUInt(RangesKt.coerceIn(v, UnsignedKt.uintToDouble(0), UnsignedKt.uintToDouble(-1)));
        }

        @JvmStatic
        public final int Op_i32_trunc_sat_f64_s(double v) {
            return (int)RangesKt.coerceIn(v, -2.147483648E9, 2.147483647E9);
        }

        @JvmStatic
        public final long Op_i64_trunc_u_f32(float v) {
            return UnsignedKt.doubleToULong(v);
        }

        @JvmStatic
        public final long Op_i64_trunc_s_f32(float v) {
            return (long)v;
        }

        @JvmStatic
        public final long Op_i64_trunc_u_f64(double v) {
            return UnsignedKt.doubleToULong(v);
        }

        @JvmStatic
        public final long Op_i64_trunc_s_f64(double v) {
            return (long)v;
        }

        @JvmStatic
        public final long Op_i64_trunc_sat_f32_u(float v) {
            return UnsignedKt.doubleToULong(RangesKt.coerceIn(v, (float)UnsignedKt.uintToDouble(0), (float)UnsignedKt.uintToDouble(-1)));
        }

        @JvmStatic
        public final long Op_i64_trunc_sat_f32_s(float v) {
            return (long)RangesKt.coerceIn(v, -2.1474836E9f, 2.1474836E9f);
        }

        @JvmStatic
        public final long Op_i64_trunc_sat_f64_u(double v) {
            return UnsignedKt.doubleToULong(RangesKt.coerceIn(v, UnsignedKt.uintToDouble(0), UnsignedKt.uintToDouble(-1)));
        }

        @JvmStatic
        public final long Op_i64_trunc_sat_f64_s(double v) {
            return (long)RangesKt.coerceIn(v, -2.147483648E9, 2.147483647E9);
        }

        @JvmStatic
        public final float Op_f32_min(float l, float r) {
            return Math.min(l, r);
        }

        @JvmStatic
        public final float Op_f32_max(float l, float r) {
            return Math.max(l, r);
        }

        @JvmStatic
        public final float Op_f32_copysign(float magnitude, float sign) {
            int SIGN_BIT_MASK = Integer.MIN_VALUE;
            int EXP_BIT_MASK = 2139095040;
            int SIGNIF_BIT_MASK = 0x7FFFFF;
            return Float.intBitsToFloat((Float.floatToRawIntBits(sign) & SIGN_BIT_MASK | Float.floatToRawIntBits(magnitude)) & (EXP_BIT_MASK | SIGNIF_BIT_MASK));
        }

        @JvmStatic
        public final float Op_f32_abs(float v) {
            return Math.abs(v);
        }

        @JvmStatic
        public final float Op_f32_sqrt(float v) {
            return (float)Math.sqrt(v);
        }

        @JvmStatic
        public final float Op_f32_neg(float v) {
            return -v;
        }

        @JvmStatic
        public final float Op_f32_ceil(float v) {
            return (float)Math.ceil(v);
        }

        @JvmStatic
        public final float Op_f32_floor(float v) {
            return (float)Math.floor(v);
        }

        @JvmStatic
        public final float Op_f32_trunc(float v) {
            return (int)v;
        }

        @JvmStatic
        public final float Op_f32_nearest(float v) {
            return (int)v;
        }

        @JvmStatic
        public final double Op_f64_min(double l, double r) {
            return Math.min(l, r);
        }

        @JvmStatic
        public final double Op_f64_max(double l, double r) {
            return Math.max(l, r);
        }

        @JvmStatic
        public final double Op_f64_copysign(double magnitude, double sign) {
            long SIGN_BIT_MASK = Long.MIN_VALUE;
            long EXP_BIT_MASK = 0x7FF0000000000000L;
            long SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
            return Double.longBitsToDouble((Double.doubleToRawLongBits(sign) & SIGN_BIT_MASK | Double.doubleToRawLongBits(magnitude)) & (EXP_BIT_MASK | SIGNIF_BIT_MASK));
        }

        @JvmStatic
        public final double Op_f64_abs(double v) {
            return Math.abs(v);
        }

        @JvmStatic
        public final double Op_f64_sqrt(double v) {
            return Math.sqrt(v);
        }

        @JvmStatic
        public final double Op_f64_neg(double v) {
            return -v;
        }

        @JvmStatic
        public final double Op_f64_ceil(double v) {
            return Math.ceil(v);
        }

        @JvmStatic
        public final double Op_f64_floor(double v) {
            return Math.floor(v);
        }

        @JvmStatic
        public final double Op_f64_trunc(double v) {
            return (int)v;
        }

        @JvmStatic
        public final double Op_f64_nearest(double v) {
            return (int)v;
        }

        @JvmStatic
        public final void Op_memory_init(@NotNull WasmRuntime runtime) {
            throw new NotImplementedError(null, 1, null);
        }

        @JvmStatic
        public final int Op_memory_size(@NotNull WasmRuntime runtime) {
            return runtime.getMemoryNumPages();
        }

        @JvmStatic
        public final int Op_memory_grow(int deltaPages, @NotNull WasmRuntime runtime) {
            Buffer oldMemory = runtime.getMemory();
            int oldPages = runtime.getMemoryNumPages();
            int newPages = oldPages + deltaPages;
            if (newPages > runtime.getMemMax()) {
                System.out.println((Object)("Op_memory_grow: oldPages=" + oldPages + ", newPages=" + newPages + " -> FAILED. Restored oldPages"));
                return -1;
            }
            runtime.setMemory(BufferKt.allocDirect(Buffer.Companion, newPages * 65536));
            ArraysKt.arraycopy(oldMemory, 0, runtime.getMemory(), 0, oldPages * 65536);
            return oldPages;
        }

        @JvmStatic
        public final void Op_memory_copy(int dst, int src, int count2, @NotNull WasmRuntime runtime) {
            Buffer mem = runtime.getMemory();
            for (int n = 0; n < count2; ++n) {
                mem.set8(dst + n, mem.getS8(src + n));
            }
        }

        @JvmStatic
        public final void Op_memory_fill(int dst, int value, int count2, @NotNull WasmRuntime runtime) {
            Buffer mem = runtime.getMemory();
            for (int n = 0; n < count2; ++n) {
                BufferKt.setUnalignedInt8(mem, dst + n, value);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lkorlibs/wasm/WasmRuntime$WasmFuncCall;", "", "invoke", "runtime", "Lkorlibs/wasm/WasmRuntime;", "args", "", "(Lkorlibs/wasm/WasmRuntime;[Ljava/lang/Object;)Ljava/lang/Object;", "korge-core"})
    public static interface WasmFuncCall {
        @Nullable
        public Object invoke(@NotNull WasmRuntime var1, @NotNull Object[] var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R$\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkorlibs/wasm/WasmRuntime$WasmTable;", "", "limit", "Lkorlibs/wasm/WasmType$Limit;", "(Lkorlibs/wasm/WasmType$Limit;)V", "elements", "", "Lkorlibs/wasm/WasmRuntime$WasmFuncCall;", "getElements", "()[Lkorlibs/wasm/WasmRuntime$WasmFuncCall;", "setElements", "([Lkorlibs/wasm/WasmRuntime$WasmFuncCall;)V", "[Lkorlibs/wasm/WasmRuntime$WasmFuncCall;", "getLimit", "()Lkorlibs/wasm/WasmType$Limit;", "tableEnsureSize", "", "size", "", "korge-core"})
    public static final class WasmTable {
        @NotNull
        private final WasmType.Limit limit;
        @NotNull
        private WasmFuncCall[] elements;

        public WasmTable(@NotNull WasmType.Limit limit) {
            this.limit = limit;
            this.elements = new WasmFuncCall[this.limit.getMin()];
        }

        @NotNull
        public final WasmType.Limit getLimit() {
            return this.limit;
        }

        @NotNull
        public final WasmFuncCall[] getElements() {
            return this.elements;
        }

        public final void setElements(@NotNull WasmFuncCall[] wasmFuncCallArray) {
            this.elements = wasmFuncCallArray;
        }

        public final void tableEnsureSize(int size2) {
            if (size2 > this.elements.length) {
                WasmFuncCall[] wasmFuncCallArray = Arrays.copyOf(this.elements, size2);
                Intrinsics.checkNotNullExpressionValue(wasmFuncCallArray, "copyOf(...)");
                this.elements = wasmFuncCallArray;
            }
        }
    }
}

