/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.TraceBase;
import kotlinx.atomicfu.TraceFormat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0017"}, d2={"Lkotlinx/atomicfu/TraceImpl;", "Lkotlinx/atomicfu/TraceBase;", "size", "", "format", "Lkotlinx/atomicfu/TraceFormat;", "(ILkotlinx/atomicfu/TraceFormat;)V", "index", "Ljava/util/concurrent/atomic/AtomicInteger;", "mask", "trace", "", "", "[Ljava/lang/Object;", "append", "", "event", "event1", "event2", "event3", "event4", "toString", "", "atomicfu"})
final class TraceImpl
extends TraceBase {
    @NotNull
    private final TraceFormat format;
    private final int size;
    private final int mask;
    @NotNull
    private final Object[] trace;
    @NotNull
    private final AtomicInteger index;

    public TraceImpl(int size2, @NotNull TraceFormat format2) {
        Intrinsics.checkNotNullParameter(format2, "format");
        this.format = format2;
        if (!(size2 >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.size = Integer.highestOneBit((size2 << 1) - 1);
        this.mask = this.size - 1;
        this.trace = new Object[this.size];
        this.index = new AtomicInteger(0);
    }

    @Override
    public void append(@NotNull Object event) {
        Intrinsics.checkNotNullParameter(event, "event");
        int i2 = this.index.getAndIncrement();
        this.trace[i2 & this.mask] = event;
    }

    @Override
    public void append(@NotNull Object event1, @NotNull Object event2) {
        Intrinsics.checkNotNullParameter(event1, "event1");
        Intrinsics.checkNotNullParameter(event2, "event2");
        int i2 = this.index.getAndAdd(2);
        this.trace[i2 & this.mask] = event1;
        this.trace[i2 + 1 & this.mask] = event2;
    }

    @Override
    public void append(@NotNull Object event1, @NotNull Object event2, @NotNull Object event3) {
        Intrinsics.checkNotNullParameter(event1, "event1");
        Intrinsics.checkNotNullParameter(event2, "event2");
        Intrinsics.checkNotNullParameter(event3, "event3");
        int i2 = this.index.getAndAdd(3);
        this.trace[i2 & this.mask] = event1;
        this.trace[i2 + 1 & this.mask] = event2;
        this.trace[i2 + 2 & this.mask] = event3;
    }

    @Override
    public void append(@NotNull Object event1, @NotNull Object event2, @NotNull Object event3, @NotNull Object event4) {
        Intrinsics.checkNotNullParameter(event1, "event1");
        Intrinsics.checkNotNullParameter(event2, "event2");
        Intrinsics.checkNotNullParameter(event3, "event3");
        Intrinsics.checkNotNullParameter(event4, "event4");
        int i2 = this.index.getAndAdd(4);
        this.trace[i2 & this.mask] = event1;
        this.trace[i2 + 1 & this.mask] = event2;
        this.trace[i2 + 2 & this.mask] = event3;
        this.trace[i2 + 3 & this.mask] = event4;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int index2 = this.index.get();
        int start2 = index2 & this.mask;
        int i2 = index2 > this.size ? index2 - this.size : 0;
        int pos = start2;
        int cnt = 0;
        do {
            Object s;
            if ((s = this.trace[pos]) == null) continue;
            if (cnt++ > 0) {
                $this$toString_u24lambda_u240.append('\n');
            }
            $this$toString_u24lambda_u240.append(this.format.format(i2, s));
            ++i2;
        } while ((pos = pos + 1 & this.mask) != start2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

