/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.PrintWriter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceAnnotationVisitor;
import org.objectweb.asm.util.TraceFieldVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.objectweb.asm.util.TraceModuleVisitor;
import org.objectweb.asm.util.TraceRecordComponentVisitor;

public final class TraceClassVisitor
extends ClassVisitor {
    private final PrintWriter printWriter;
    public final Printer p;

    public TraceClassVisitor(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        this(classVisitor, new Textifier(), printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, Printer printer, PrintWriter printWriter) {
        super(0x10A0000, classVisitor);
        this.printWriter = printWriter;
        this.p = printer;
    }

    public void visit(int version, int access2, String name2, String signature2, String superName, String[] interfaces) {
        this.p.visit(version, access2, name2, signature2, superName, interfaces);
        super.visit(version, access2, name2, signature2, superName, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.p.visitSource(file, debug);
        super.visitSource(file, debug);
    }

    public ModuleVisitor visitModule(String name2, int flags, String version) {
        Printer modulePrinter = this.p.visitModule(name2, flags, version);
        return new TraceModuleVisitor(super.visitModule(name2, flags, version), modulePrinter);
    }

    public void visitNestHost(String nestHost) {
        this.p.visitNestHost(nestHost);
        super.visitNestHost(nestHost);
    }

    public void visitOuterClass(String owner, String name2, String descriptor2) {
        this.p.visitOuterClass(owner, name2, descriptor2);
        super.visitOuterClass(owner, name2, descriptor2);
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible2) {
        Printer annotationPrinter = this.p.visitClassAnnotation(descriptor2, visible2);
        return new TraceAnnotationVisitor(super.visitAnnotation(descriptor2, visible2), annotationPrinter);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible2) {
        Printer annotationPrinter = this.p.visitClassTypeAnnotation(typeRef, typePath, descriptor2, visible2);
        return new TraceAnnotationVisitor(super.visitTypeAnnotation(typeRef, typePath, descriptor2, visible2), annotationPrinter);
    }

    public void visitAttribute(Attribute attribute) {
        this.p.visitClassAttribute(attribute);
        super.visitAttribute(attribute);
    }

    public void visitNestMember(String nestMember) {
        this.p.visitNestMember(nestMember);
        super.visitNestMember(nestMember);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.p.visitPermittedSubclass(permittedSubclass);
        super.visitPermittedSubclass(permittedSubclass);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access2) {
        this.p.visitInnerClass(name2, outerName, innerName, access2);
        super.visitInnerClass(name2, outerName, innerName, access2);
    }

    public RecordComponentVisitor visitRecordComponent(String name2, String descriptor2, String signature2) {
        Printer recordComponentPrinter = this.p.visitRecordComponent(name2, descriptor2, signature2);
        return new TraceRecordComponentVisitor(super.visitRecordComponent(name2, descriptor2, signature2), recordComponentPrinter);
    }

    public FieldVisitor visitField(int access2, String name2, String descriptor2, String signature2, Object value) {
        Printer fieldPrinter = this.p.visitField(access2, name2, descriptor2, signature2, value);
        return new TraceFieldVisitor(super.visitField(access2, name2, descriptor2, signature2, value), fieldPrinter);
    }

    public MethodVisitor visitMethod(int access2, String name2, String descriptor2, String signature2, String[] exceptions) {
        Printer methodPrinter = this.p.visitMethod(access2, name2, descriptor2, signature2, exceptions);
        return new TraceMethodVisitor(super.visitMethod(access2, name2, descriptor2, signature2, exceptions), methodPrinter);
    }

    public void visitEnd() {
        this.p.visitClassEnd();
        if (this.printWriter != null) {
            this.p.print(this.printWriter);
            this.printWriter.flush();
        }
        super.visitEnd();
    }
}

